--
-- raporsp_userQL database dump
--

-- Dumped from database version 14.17
-- Dumped by pg_dump version 15.2

-- Started on 2025-04-25 10:41:08

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- TOC entry 5 (class 2615 OID 16385)
-- Name: nilai; Type: SCHEMA; Schema: -; Owner: raporsp_user
--

CREATE SCHEMA nilai;


ALTER SCHEMA nilai OWNER TO raporsp_user;

--
-- TOC entry 6 (class 2615 OID 16386)
-- Name: pkl; Type: SCHEMA; Schema: -; Owner: raporsp_user
--

CREATE SCHEMA pkl;


ALTER SCHEMA pkl OWNER TO raporsp_user;

--
-- TOC entry 7 (class 2615 OID 16387)
-- Name: projec; Type: SCHEMA; Schema: -; Owner: raporsp_user
--

CREATE SCHEMA projec;


ALTER SCHEMA projec OWNER TO raporsp_user;

--
-- TOC entry 9 (class 2615 OID 2200)
-- Name: public; Type: SCHEMA; Schema: -; Owner: raporsp_user
--

-- *not* creating schema, since initdb creates it


ALTER SCHEMA public OWNER TO raporsp_user;

--
-- TOC entry 8 (class 2615 OID 16388)
-- Name: tambah; Type: SCHEMA; Schema: -; Owner: raporsp_user
--

CREATE SCHEMA tambah;


ALTER SCHEMA tambah OWNER TO raporsp_user;

--
-- TOC entry 984 (class 1247 OID 16391)
-- Name: breakpoint; Type: TYPE; Schema: public; Owner: raporsp_user
--

CREATE TYPE public.breakpoint AS (
	func oid,
	linenumber integer,
	targetname text
);


ALTER TYPE public.breakpoint OWNER TO raporsp_user;

--
-- TOC entry 987 (class 1247 OID 16394)
-- Name: frame; Type: TYPE; Schema: public; Owner: raporsp_user
--

CREATE TYPE public.frame AS (
	level integer,
	targetname text,
	func oid,
	linenumber integer,
	args text
);


ALTER TYPE public.frame OWNER TO raporsp_user;

--
-- TOC entry 990 (class 1247 OID 16397)
-- Name: proxyinfo; Type: TYPE; Schema: public; Owner: raporsp_user
--

CREATE TYPE public.proxyinfo AS (
	serverversionstr text,
	serverversionnum integer,
	proxyapiver integer,
	serverprocessid integer
);


ALTER TYPE public.proxyinfo OWNER TO raporsp_user;

--
-- TOC entry 993 (class 1247 OID 16399)
-- Name: role_enum; Type: TYPE; Schema: public; Owner: raporsp_user
--

CREATE TYPE public.role_enum AS ENUM (
    'admin',
    'manager',
    'guru',
    'siswa',
    'umum'
);


ALTER TYPE public.role_enum OWNER TO raporsp_user;

--
-- TOC entry 996 (class 1247 OID 16411)
-- Name: targetinfo; Type: TYPE; Schema: public; Owner: raporsp_user
--

CREATE TYPE public.targetinfo AS (
	target oid,
	schema oid,
	nargs integer,
	argtypes oidvector,
	targetname name,
	argmodes "char"[],
	argnames text[],
	targetlang oid,
	fqname text,
	returnsset boolean,
	returntype oid,
	isfunc boolean,
	pkg oid,
	argdefvals text[]
);


ALTER TYPE public.targetinfo OWNER TO raporsp_user;

--
-- TOC entry 999 (class 1247 OID 16414)
-- Name: var; Type: TYPE; Schema: public; Owner: raporsp_user
--

CREATE TYPE public.var AS (
	name text,
	varclass character(1),
	linenumber integer,
	isunique boolean,
	isconst boolean,
	isnotnull boolean,
	dtype oid,
	value text
);


ALTER TYPE public.var OWNER TO raporsp_user;

--
-- TOC entry 337 (class 1255 OID 16415)
-- Name: uuid_generate_v4(); Type: FUNCTION; Schema: nilai; Owner: raporsp_user
--

CREATE FUNCTION nilai.uuid_generate_v4() RETURNS uuid
    LANGUAGE c STRICT
    AS '$libdir/uuid-ossp', 'uuid_generate_v4';


ALTER FUNCTION nilai.uuid_generate_v4() OWNER TO raporsp_user;

--
-- TOC entry 338 (class 1255 OID 16416)
-- Name: uuid_generate_v4(); Type: FUNCTION; Schema: pkl; Owner: raporsp_user
--

CREATE FUNCTION pkl.uuid_generate_v4() RETURNS uuid
    LANGUAGE c STRICT
    AS '$libdir/uuid-ossp', 'uuid_generate_v4';


ALTER FUNCTION pkl.uuid_generate_v4() OWNER TO raporsp_user;

--
-- TOC entry 339 (class 1255 OID 16417)
-- Name: uuid_generate_v4(); Type: FUNCTION; Schema: projec; Owner: raporsp_user
--

CREATE FUNCTION projec.uuid_generate_v4() RETURNS uuid
    LANGUAGE c STRICT
    AS '$libdir/uuid-ossp', 'uuid_generate_v4';


ALTER FUNCTION projec.uuid_generate_v4() OWNER TO raporsp_user;

--
-- TOC entry 340 (class 1255 OID 16418)
-- Name: pldbg_abort_target(integer); Type: FUNCTION; Schema: public; Owner: raporsp_user
--

CREATE FUNCTION public.pldbg_abort_target(session integer) RETURNS SETOF boolean
    LANGUAGE c STRICT
    AS '$libdir/plugin_debugger', 'pldbg_abort_target';


ALTER FUNCTION public.pldbg_abort_target(session integer) OWNER TO raporsp_user;

--
-- TOC entry 341 (class 1255 OID 16419)
-- Name: pldbg_attach_to_port(integer); Type: FUNCTION; Schema: public; Owner: raporsp_user
--

CREATE FUNCTION public.pldbg_attach_to_port(portnumber integer) RETURNS integer
    LANGUAGE c STRICT
    AS '$libdir/plugin_debugger', 'pldbg_attach_to_port';


ALTER FUNCTION public.pldbg_attach_to_port(portnumber integer) OWNER TO raporsp_user;

--
-- TOC entry 342 (class 1255 OID 16420)
-- Name: pldbg_continue(integer); Type: FUNCTION; Schema: public; Owner: raporsp_user
--

CREATE FUNCTION public.pldbg_continue(session integer) RETURNS public.breakpoint
    LANGUAGE c STRICT
    AS '$libdir/plugin_debugger', 'pldbg_continue';


ALTER FUNCTION public.pldbg_continue(session integer) OWNER TO raporsp_user;

--
-- TOC entry 343 (class 1255 OID 16421)
-- Name: pldbg_create_listener(); Type: FUNCTION; Schema: public; Owner: raporsp_user
--

CREATE FUNCTION public.pldbg_create_listener() RETURNS integer
    LANGUAGE c STRICT
    AS '$libdir/plugin_debugger', 'pldbg_create_listener';


ALTER FUNCTION public.pldbg_create_listener() OWNER TO raporsp_user;

--
-- TOC entry 344 (class 1255 OID 16422)
-- Name: pldbg_deposit_value(integer, text, integer, text); Type: FUNCTION; Schema: public; Owner: raporsp_user
--

CREATE FUNCTION public.pldbg_deposit_value(session integer, varname text, linenumber integer, value text) RETURNS boolean
    LANGUAGE c STRICT
    AS '$libdir/plugin_debugger', 'pldbg_deposit_value';


ALTER FUNCTION public.pldbg_deposit_value(session integer, varname text, linenumber integer, value text) OWNER TO raporsp_user;

--
-- TOC entry 345 (class 1255 OID 16423)
-- Name: pldbg_drop_breakpoint(integer, oid, integer); Type: FUNCTION; Schema: public; Owner: raporsp_user
--

CREATE FUNCTION public.pldbg_drop_breakpoint(session integer, func oid, linenumber integer) RETURNS boolean
    LANGUAGE c STRICT
    AS '$libdir/plugin_debugger', 'pldbg_drop_breakpoint';


ALTER FUNCTION public.pldbg_drop_breakpoint(session integer, func oid, linenumber integer) OWNER TO raporsp_user;

--
-- TOC entry 346 (class 1255 OID 16424)
-- Name: pldbg_get_breakpoints(integer); Type: FUNCTION; Schema: public; Owner: raporsp_user
--

CREATE FUNCTION public.pldbg_get_breakpoints(session integer) RETURNS SETOF public.breakpoint
    LANGUAGE c STRICT
    AS '$libdir/plugin_debugger', 'pldbg_get_breakpoints';


ALTER FUNCTION public.pldbg_get_breakpoints(session integer) OWNER TO raporsp_user;

--
-- TOC entry 347 (class 1255 OID 16425)
-- Name: pldbg_get_proxy_info(); Type: FUNCTION; Schema: public; Owner: raporsp_user
--

CREATE FUNCTION public.pldbg_get_proxy_info() RETURNS public.proxyinfo
    LANGUAGE c STRICT
    AS '$libdir/plugin_debugger', 'pldbg_get_proxy_info';


ALTER FUNCTION public.pldbg_get_proxy_info() OWNER TO raporsp_user;

--
-- TOC entry 348 (class 1255 OID 16426)
-- Name: pldbg_get_source(integer, oid); Type: FUNCTION; Schema: public; Owner: raporsp_user
--

CREATE FUNCTION public.pldbg_get_source(session integer, func oid) RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/plugin_debugger', 'pldbg_get_source';


ALTER FUNCTION public.pldbg_get_source(session integer, func oid) OWNER TO raporsp_user;

--
-- TOC entry 349 (class 1255 OID 16427)
-- Name: pldbg_get_stack(integer); Type: FUNCTION; Schema: public; Owner: raporsp_user
--

CREATE FUNCTION public.pldbg_get_stack(session integer) RETURNS SETOF public.frame
    LANGUAGE c STRICT
    AS '$libdir/plugin_debugger', 'pldbg_get_stack';


ALTER FUNCTION public.pldbg_get_stack(session integer) OWNER TO raporsp_user;

--
-- TOC entry 353 (class 1255 OID 16428)
-- Name: pldbg_get_target_info(text, character); Type: FUNCTION; Schema: public; Owner: raporsp_user
--

CREATE FUNCTION public.pldbg_get_target_info(signature text, targettype character) RETURNS public.targetinfo
    LANGUAGE sql
    AS $_$
  SELECT p.oid AS target,
         pronamespace AS schema,
         pronargs::int4 AS nargs,
         -- The returned argtypes column is of type oidvector, but unlike
         -- proargtypes, it's supposed to include OUT params. So we
         -- essentially have to return proallargtypes, converted to an
         -- oidvector. There is no oid[] -> oidvector cast, so we have to
         -- do it via text.
         CASE WHEN proallargtypes IS NOT NULL THEN
           translate(proallargtypes::text, ',{}', ' ')::oidvector
         ELSE
           proargtypes
         END AS argtypes,
         proname AS targetname,
         proargmodes AS argmodes,
         proargnames AS proargnames,
         prolang AS targetlang,
         quote_ident(nspname) || '.' || quote_ident(proname) AS fqname,
         proretset AS returnsset,
         prorettype AS returntype,

         't'::bool AS isfunc,
         0::oid AS pkg,
	 NULL::text[] AS argdefvals

  FROM pg_proc p, pg_namespace n
  WHERE p.pronamespace = n.oid
  AND p.oid = $1::oid
  -- We used to support querying by function name or trigger name/oid as well,
  -- but that was never used in the client, so the support for that has been
  -- removed. The targeType argument remains as a legacy of that. You're
  -- expected to pass 'o' as target type, but it doesn't do anything.
  AND $2 = 'o'
$_$;


ALTER FUNCTION public.pldbg_get_target_info(signature text, targettype character) OWNER TO raporsp_user;

--
-- TOC entry 360 (class 1255 OID 16429)
-- Name: pldbg_get_variables(integer); Type: FUNCTION; Schema: public; Owner: raporsp_user
--

CREATE FUNCTION public.pldbg_get_variables(session integer) RETURNS SETOF public.var
    LANGUAGE c STRICT
    AS '$libdir/plugin_debugger', 'pldbg_get_variables';


ALTER FUNCTION public.pldbg_get_variables(session integer) OWNER TO raporsp_user;

--
-- TOC entry 361 (class 1255 OID 16430)
-- Name: pldbg_oid_debug(oid); Type: FUNCTION; Schema: public; Owner: raporsp_user
--

CREATE FUNCTION public.pldbg_oid_debug(functionoid oid) RETURNS integer
    LANGUAGE c STRICT
    AS '$libdir/plugin_debugger', 'pldbg_oid_debug';


ALTER FUNCTION public.pldbg_oid_debug(functionoid oid) OWNER TO raporsp_user;

--
-- TOC entry 364 (class 1255 OID 16431)
-- Name: pldbg_select_frame(integer, integer); Type: FUNCTION; Schema: public; Owner: raporsp_user
--

CREATE FUNCTION public.pldbg_select_frame(session integer, frame integer) RETURNS public.breakpoint
    LANGUAGE c STRICT
    AS '$libdir/plugin_debugger', 'pldbg_select_frame';


ALTER FUNCTION public.pldbg_select_frame(session integer, frame integer) OWNER TO raporsp_user;

--
-- TOC entry 365 (class 1255 OID 16432)
-- Name: pldbg_set_breakpoint(integer, oid, integer); Type: FUNCTION; Schema: public; Owner: raporsp_user
--

CREATE FUNCTION public.pldbg_set_breakpoint(session integer, func oid, linenumber integer) RETURNS boolean
    LANGUAGE c STRICT
    AS '$libdir/plugin_debugger', 'pldbg_set_breakpoint';


ALTER FUNCTION public.pldbg_set_breakpoint(session integer, func oid, linenumber integer) OWNER TO raporsp_user;

--
-- TOC entry 366 (class 1255 OID 16433)
-- Name: pldbg_set_global_breakpoint(integer, oid, integer, integer); Type: FUNCTION; Schema: public; Owner: raporsp_user
--

CREATE FUNCTION public.pldbg_set_global_breakpoint(session integer, func oid, linenumber integer, targetpid integer) RETURNS boolean
    LANGUAGE c
    AS '$libdir/plugin_debugger', 'pldbg_set_global_breakpoint';


ALTER FUNCTION public.pldbg_set_global_breakpoint(session integer, func oid, linenumber integer, targetpid integer) OWNER TO raporsp_user;

--
-- TOC entry 367 (class 1255 OID 16434)
-- Name: pldbg_step_into(integer); Type: FUNCTION; Schema: public; Owner: raporsp_user
--

CREATE FUNCTION public.pldbg_step_into(session integer) RETURNS public.breakpoint
    LANGUAGE c STRICT
    AS '$libdir/plugin_debugger', 'pldbg_step_into';


ALTER FUNCTION public.pldbg_step_into(session integer) OWNER TO raporsp_user;

--
-- TOC entry 368 (class 1255 OID 16435)
-- Name: pldbg_step_over(integer); Type: FUNCTION; Schema: public; Owner: raporsp_user
--

CREATE FUNCTION public.pldbg_step_over(session integer) RETURNS public.breakpoint
    LANGUAGE c STRICT
    AS '$libdir/plugin_debugger', 'pldbg_step_over';


ALTER FUNCTION public.pldbg_step_over(session integer) OWNER TO raporsp_user;

--
-- TOC entry 369 (class 1255 OID 16436)
-- Name: pldbg_wait_for_breakpoint(integer); Type: FUNCTION; Schema: public; Owner: raporsp_user
--

CREATE FUNCTION public.pldbg_wait_for_breakpoint(session integer) RETURNS public.breakpoint
    LANGUAGE c STRICT
    AS '$libdir/plugin_debugger', 'pldbg_wait_for_breakpoint';


ALTER FUNCTION public.pldbg_wait_for_breakpoint(session integer) OWNER TO raporsp_user;

--
-- TOC entry 370 (class 1255 OID 16437)
-- Name: pldbg_wait_for_target(integer); Type: FUNCTION; Schema: public; Owner: raporsp_user
--

CREATE FUNCTION public.pldbg_wait_for_target(session integer) RETURNS integer
    LANGUAGE c STRICT
    AS '$libdir/plugin_debugger', 'pldbg_wait_for_target';


ALTER FUNCTION public.pldbg_wait_for_target(session integer) OWNER TO raporsp_user;

--
-- TOC entry 371 (class 1255 OID 16438)
-- Name: plpgsql_oid_debug(oid); Type: FUNCTION; Schema: public; Owner: raporsp_user
--

CREATE FUNCTION public.plpgsql_oid_debug(functionoid oid) RETURNS integer
    LANGUAGE sql STRICT
    AS $_$ SELECT pldbg_oid_debug($1) $_$;


ALTER FUNCTION public.plpgsql_oid_debug(functionoid oid) OWNER TO raporsp_user;

--
-- TOC entry 372 (class 1255 OID 16439)
-- Name: uuid_generate_v1(); Type: FUNCTION; Schema: public; Owner: raporsp_user
--

CREATE FUNCTION public.uuid_generate_v1() RETURNS uuid
    LANGUAGE c STRICT
    AS '$libdir/uuid-ossp', 'uuid_generate_v1';


ALTER FUNCTION public.uuid_generate_v1() OWNER TO raporsp_user;

--
-- TOC entry 373 (class 1255 OID 16440)
-- Name: uuid_generate_v1mc(); Type: FUNCTION; Schema: public; Owner: raporsp_user
--

CREATE FUNCTION public.uuid_generate_v1mc() RETURNS uuid
    LANGUAGE c STRICT
    AS '$libdir/uuid-ossp', 'uuid_generate_v1mc';


ALTER FUNCTION public.uuid_generate_v1mc() OWNER TO raporsp_user;

--
-- TOC entry 374 (class 1255 OID 16441)
-- Name: uuid_generate_v3(uuid, text); Type: FUNCTION; Schema: public; Owner: raporsp_user
--

CREATE FUNCTION public.uuid_generate_v3(namespace uuid, name text) RETURNS uuid
    LANGUAGE c IMMUTABLE STRICT
    AS '$libdir/uuid-ossp', 'uuid_generate_v3';


ALTER FUNCTION public.uuid_generate_v3(namespace uuid, name text) OWNER TO raporsp_user;

--
-- TOC entry 375 (class 1255 OID 16442)
-- Name: uuid_generate_v4(); Type: FUNCTION; Schema: public; Owner: raporsp_user
--

CREATE FUNCTION public.uuid_generate_v4() RETURNS uuid
    LANGUAGE c STRICT
    AS '$libdir/uuid-ossp', 'uuid_generate_v4';


ALTER FUNCTION public.uuid_generate_v4() OWNER TO raporsp_user;

--
-- TOC entry 376 (class 1255 OID 16443)
-- Name: uuid_generate_v5(uuid, text); Type: FUNCTION; Schema: public; Owner: raporsp_user
--

CREATE FUNCTION public.uuid_generate_v5(namespace uuid, name text) RETURNS uuid
    LANGUAGE c IMMUTABLE STRICT
    AS '$libdir/uuid-ossp', 'uuid_generate_v5';


ALTER FUNCTION public.uuid_generate_v5(namespace uuid, name text) OWNER TO raporsp_user;

--
-- TOC entry 377 (class 1255 OID 16444)
-- Name: uuid_nil(); Type: FUNCTION; Schema: public; Owner: raporsp_user
--

CREATE FUNCTION public.uuid_nil() RETURNS uuid
    LANGUAGE c IMMUTABLE STRICT
    AS '$libdir/uuid-ossp', 'uuid_nil';


ALTER FUNCTION public.uuid_nil() OWNER TO raporsp_user;

--
-- TOC entry 378 (class 1255 OID 16445)
-- Name: uuid_ns_dns(); Type: FUNCTION; Schema: public; Owner: raporsp_user
--

CREATE FUNCTION public.uuid_ns_dns() RETURNS uuid
    LANGUAGE c IMMUTABLE STRICT
    AS '$libdir/uuid-ossp', 'uuid_ns_dns';


ALTER FUNCTION public.uuid_ns_dns() OWNER TO raporsp_user;

--
-- TOC entry 379 (class 1255 OID 16446)
-- Name: uuid_ns_oid(); Type: FUNCTION; Schema: public; Owner: raporsp_user
--

CREATE FUNCTION public.uuid_ns_oid() RETURNS uuid
    LANGUAGE c IMMUTABLE STRICT
    AS '$libdir/uuid-ossp', 'uuid_ns_oid';


ALTER FUNCTION public.uuid_ns_oid() OWNER TO raporsp_user;

--
-- TOC entry 380 (class 1255 OID 16447)
-- Name: uuid_ns_url(); Type: FUNCTION; Schema: public; Owner: raporsp_user
--

CREATE FUNCTION public.uuid_ns_url() RETURNS uuid
    LANGUAGE c IMMUTABLE STRICT
    AS '$libdir/uuid-ossp', 'uuid_ns_url';


ALTER FUNCTION public.uuid_ns_url() OWNER TO raporsp_user;

--
-- TOC entry 381 (class 1255 OID 16448)
-- Name: uuid_ns_x500(); Type: FUNCTION; Schema: public; Owner: raporsp_user
--

CREATE FUNCTION public.uuid_ns_x500() RETURNS uuid
    LANGUAGE c IMMUTABLE STRICT
    AS '$libdir/uuid-ossp', 'uuid_ns_x500';


ALTER FUNCTION public.uuid_ns_x500() OWNER TO raporsp_user;

--
-- TOC entry 382 (class 1255 OID 16449)
-- Name: uuid_generate_v4(); Type: FUNCTION; Schema: tambah; Owner: raporsp_user
--

CREATE FUNCTION tambah.uuid_generate_v4() RETURNS uuid
    LANGUAGE c STRICT
    AS '$libdir/uuid-ossp', 'uuid_generate_v4';


ALTER FUNCTION tambah.uuid_generate_v4() OWNER TO raporsp_user;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- TOC entry 218 (class 1259 OID 16450)
-- Name: data_sync; Type: TABLE; Schema: nilai; Owner: raporsp_user
--

CREATE TABLE nilai.data_sync (
    sync_id uuid DEFAULT nilai.uuid_generate_v4() NOT NULL,
    semester_id character varying(5) NOT NULL,
    tabel_sync character varying(60) NOT NULL,
    start_sync timestamp(6) without time zone DEFAULT '2019-09-10 14:29:57.578379'::timestamp without time zone,
    last_sync timestamp(6) without time zone DEFAULT '1901-01-01 00:00:00'::timestamp without time zone NOT NULL
);


ALTER TABLE nilai.data_sync OWNER TO raporsp_user;

--
-- TOC entry 219 (class 1259 OID 16456)
-- Name: matev_rapor; Type: TABLE; Schema: nilai; Owner: raporsp_user
--

CREATE TABLE nilai.matev_rapor (
    id_evaluasi uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    nm_mata_evaluasi character varying(50) NOT NULL,
    a_dari_template numeric(1,0) NOT NULL,
    no_urut numeric(3,0) NOT NULL,
    kkm_kognitif numeric(5,2),
    kkm_psikomotorik numeric(5,2),
    rombongan_belajar_id uuid NOT NULL,
    mata_pelajaran_id integer NOT NULL,
    pembelajaran_id uuid,
    create_date timestamp(6) without time zone DEFAULT '2019-09-10 14:29:57.367005'::timestamp without time zone NOT NULL,
    last_update timestamp(6) without time zone DEFAULT '2019-09-10 14:29:57.367005'::timestamp without time zone NOT NULL,
    soft_delete numeric(1,0) DEFAULT 0 NOT NULL,
    last_sync timestamp(6) without time zone DEFAULT '1901-01-01 00:00:00'::timestamp without time zone NOT NULL,
    updater_id uuid NOT NULL,
    semester_id character varying(5),
    semester numeric(2,0),
    a_dari_template_str character varying(100) DEFAULT 'Nilai Rapor'::character varying
);


ALTER TABLE nilai.matev_rapor OWNER TO raporsp_user;

--
-- TOC entry 220 (class 1259 OID 16465)
-- Name: nilai_ekskul; Type: TABLE; Schema: nilai; Owner: raporsp_user
--

CREATE TABLE nilai.nilai_ekskul (
    id_nilai_x uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    id_kelas_ekskul uuid NOT NULL,
    anggota_rombel_id uuid NOT NULL,
    nilai_angka numeric(5,2) NOT NULL,
    nilai_huruf character varying(3),
    ket character varying(300),
    a_beku numeric(1,0) DEFAULT 1 NOT NULL,
    rapor_ke numeric(2,0),
    create_date timestamp(6) without time zone DEFAULT '2019-09-10 14:29:57.555141'::timestamp without time zone NOT NULL,
    last_update timestamp(6) without time zone DEFAULT '2019-09-10 14:29:57.555141'::timestamp without time zone NOT NULL,
    soft_delete numeric(1,0) DEFAULT 0 NOT NULL,
    last_sync timestamp(6) without time zone DEFAULT '1901-01-01 00:00:00'::timestamp without time zone NOT NULL,
    updater_id uuid NOT NULL,
    semester_id character varying(5),
    semester numeric(2,0)
);


ALTER TABLE nilai.nilai_ekskul OWNER TO raporsp_user;

--
-- TOC entry 221 (class 1259 OID 16474)
-- Name: nilai_rapor; Type: TABLE; Schema: nilai; Owner: raporsp_user
--

CREATE TABLE nilai.nilai_rapor (
    nilai_id uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    id_evaluasi uuid NOT NULL,
    anggota_rombel_id uuid NOT NULL,
    nilai_kognitif_angka numeric(5,2) NOT NULL,
    nilai_kognitif_huruf character varying(3),
    ket_kognitif character varying(300),
    nilai_psim_angka numeric(5,2),
    nilai_psim_huruf character varying(3),
    ket_psim character varying(300),
    nilai_afektif_angka numeric(5,2),
    nilai_afektif_huruf character varying(3),
    ket_afektif character varying(300),
    nilai_afektif2_angka numeric(5,2),
    nilai_afektif2_huruf character varying(3),
    ket_afektif2 character varying(300),
    a_beku numeric(1,0) DEFAULT 1 NOT NULL,
    rapor_ke numeric(2,0),
    create_date timestamp(6) without time zone DEFAULT '2019-09-10 14:29:57.578379'::timestamp without time zone NOT NULL,
    last_update timestamp(6) without time zone DEFAULT '2019-09-10 14:29:57.578379'::timestamp without time zone NOT NULL,
    soft_delete numeric(1,0) DEFAULT 0 NOT NULL,
    last_sync timestamp(6) without time zone DEFAULT '1901-01-01 00:00:00'::timestamp without time zone NOT NULL,
    updater_id uuid NOT NULL,
    semester_id character varying(5),
    semester numeric(2,0)
);


ALTER TABLE nilai.nilai_rapor OWNER TO raporsp_user;

--
-- TOC entry 222 (class 1259 OID 16485)
-- Name: nilai_smt; Type: TABLE; Schema: nilai; Owner: raporsp_user
--

CREATE TABLE nilai.nilai_smt (
    anggota_rombel_id uuid NOT NULL,
    nilai_afektif_angka numeric(5,2),
    nilai_afektif_huruf character varying(3),
    ket_afektif character varying(300),
    nilai_afektif2_angka numeric(5,2),
    nilai_afektif2_huruf character varying(3),
    ket_afektif2 character varying(300),
    a_beku numeric(1,0) DEFAULT 1 NOT NULL,
    rapor_ke numeric(2,0),
    create_date timestamp(6) without time zone DEFAULT '2019-09-10 14:29:57.615745'::timestamp without time zone NOT NULL,
    last_update timestamp(6) without time zone DEFAULT '2019-09-10 14:29:57.615745'::timestamp without time zone NOT NULL,
    soft_delete numeric(1,0) DEFAULT 0 NOT NULL,
    last_sync timestamp(6) without time zone DEFAULT '1901-01-01 00:00:00'::timestamp without time zone NOT NULL,
    updater_id uuid NOT NULL,
    semester_id character varying(5),
    semester numeric(2,0)
);


ALTER TABLE nilai.nilai_smt OWNER TO raporsp_user;

--
-- TOC entry 223 (class 1259 OID 16495)
-- Name: pengguna; Type: TABLE; Schema: nilai; Owner: raporsp_user
--

CREATE TABLE nilai.pengguna (
    pengguna_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    username character varying(150) NOT NULL,
    nama character varying(150) NOT NULL,
    peran_id_str character varying(100) NOT NULL
);


ALTER TABLE nilai.pengguna OWNER TO raporsp_user;

--
-- TOC entry 224 (class 1259 OID 16498)
-- Name: temp_nilai_rapor; Type: TABLE; Schema: nilai; Owner: raporsp_user
--

CREATE TABLE nilai.temp_nilai_rapor (
    nilai_id uuid DEFAULT nilai.uuid_generate_v4() NOT NULL,
    id_evaluasi uuid NOT NULL,
    anggota_rombel_id uuid NOT NULL,
    nilai_kognitif_angka numeric(5,2) NOT NULL,
    nilai_kognitif_huruf character varying(3),
    ket_kognitif character varying(300) DEFAULT 'Rapor SP'::character varying,
    nilai_psim_angka numeric(5,2),
    nilai_psim_huruf character varying(3),
    ket_psim character varying(300) DEFAULT 'Rapor SP'::character varying,
    nilai_afektif_angka numeric(5,2),
    nilai_afektif_huruf character varying(3),
    ket_afektif character varying(300),
    nilai_afektif2_angka numeric(5,2),
    nilai_afektif2_huruf character varying(3),
    ket_afektif2 character varying(300),
    a_beku numeric(1,0) DEFAULT 1 NOT NULL,
    rapor_ke numeric(2,0) DEFAULT 1 NOT NULL,
    create_date timestamp(6) without time zone DEFAULT (now())::timestamp without time zone NOT NULL,
    last_update timestamp(6) without time zone DEFAULT (now())::timestamp without time zone NOT NULL,
    soft_delete numeric(1,0) DEFAULT 0 NOT NULL,
    last_sync timestamp(6) without time zone DEFAULT '2025-01-01 00:00:00'::timestamp without time zone NOT NULL,
    updater_id uuid NOT NULL,
    semester_id character varying(5),
    semester numeric(2,0),
    pembelajaran_id uuid NOT NULL
);


ALTER TABLE nilai.temp_nilai_rapor OWNER TO raporsp_user;

--
-- TOC entry 225 (class 1259 OID 16512)
-- Name: un; Type: TABLE; Schema: nilai; Owner: raporsp_user
--

CREATE TABLE nilai.un (
    un_id uuid NOT NULL,
    registrasi_id uuid NOT NULL,
    tahun_ajaran_id numeric(4,0) NOT NULL,
    un_tgl_daftar date NOT NULL,
    nomor_un character varying(20),
    no_skhun character(20),
    nilai_1 numeric(5,2),
    nilai_2 numeric(5,2),
    nilai_3 numeric(5,2),
    nilai_4 numeric(5,2),
    nilai_5 numeric(5,2),
    nilai_6 numeric(5,2),
    nilai_7 numeric(5,2),
    template_id uuid NOT NULL,
    create_date timestamp(6) without time zone DEFAULT '2019-09-10 14:30:00.045604'::timestamp without time zone NOT NULL,
    last_update timestamp(6) without time zone DEFAULT '2019-09-10 14:30:00.045604'::timestamp without time zone NOT NULL,
    soft_delete numeric(1,0) NOT NULL,
    last_sync timestamp(6) without time zone DEFAULT '1901-01-01 00:00:00'::timestamp without time zone NOT NULL,
    updater_id uuid NOT NULL
);


ALTER TABLE nilai.un OWNER TO raporsp_user;

--
-- TOC entry 226 (class 1259 OID 16518)
-- Name: tabel_anggotakelompok; Type: TABLE; Schema: pkl; Owner: raporsp_user
--

CREATE TABLE pkl.tabel_anggotakelompok (
    anggota_kelompok_id uuid DEFAULT projec.uuid_generate_v4() NOT NULL,
    peserta_didik_id uuid NOT NULL,
    kelompok_id uuid NOT NULL,
    rombongan_belajar_id uuid,
    tahun_id character varying(4)
);


ALTER TABLE pkl.tabel_anggotakelompok OWNER TO raporsp_user;

--
-- TOC entry 227 (class 1259 OID 16522)
-- Name: tabel_capaian_pkl; Type: TABLE; Schema: pkl; Owner: raporsp_user
--

CREATE TABLE pkl.tabel_capaian_pkl (
    id_capaian uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    sekolah_id uuid NOT NULL,
    tahun_id character varying(4),
    anggota_kelompok_id uuid DEFAULT projec.uuid_generate_v4() NOT NULL,
    peserta_didik_id uuid NOT NULL,
    kelompok_id uuid NOT NULL,
    id_tp uuid NOT NULL,
    ketercapaian numeric(3,0),
    keterangan text,
    id_rencana_pkl uuid
);


ALTER TABLE pkl.tabel_capaian_pkl OWNER TO raporsp_user;

--
-- TOC entry 228 (class 1259 OID 16529)
-- Name: tabel_elemenpkl; Type: TABLE; Schema: pkl; Owner: raporsp_user
--

CREATE TABLE pkl.tabel_elemenpkl (
    elemen_id uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    kd_elemen character varying(60) NOT NULL,
    elemen_tp text NOT NULL,
    jenjang character varying(20) NOT NULL,
    status numeric(1,0) DEFAULT 1 NOT NULL,
    no_urut integer
);


ALTER TABLE pkl.tabel_elemenpkl OWNER TO raporsp_user;

--
-- TOC entry 229 (class 1259 OID 16536)
-- Name: tabel_indikatortp; Type: TABLE; Schema: pkl; Owner: raporsp_user
--

CREATE TABLE pkl.tabel_indikatortp (
    id_indikator uuid DEFAULT pkl.uuid_generate_v4() NOT NULL,
    id_tp uuid NOT NULL,
    no_urut integer NOT NULL,
    indikator text NOT NULL,
    status numeric(1,0) DEFAULT 1 NOT NULL
);


ALTER TABLE pkl.tabel_indikatortp OWNER TO raporsp_user;

--
-- TOC entry 230 (class 1259 OID 16543)
-- Name: tabel_kelompok; Type: TABLE; Schema: pkl; Owner: raporsp_user
--

CREATE TABLE pkl.tabel_kelompok (
    kelompok_id uuid DEFAULT projec.uuid_generate_v4() NOT NULL,
    sekolah_id uuid NOT NULL,
    tahun_id character varying(4),
    pembimbing_id uuid,
    nm_kelompok character varying(30),
    prodi character varying(200),
    konsentrasi character varying(200),
    tingkat_pendidikan_id numeric(2,0),
    status numeric(1,0) DEFAULT 1,
    asesor_id uuid,
    kurikulum_id smallint
);


ALTER TABLE pkl.tabel_kelompok OWNER TO raporsp_user;

--
-- TOC entry 231 (class 1259 OID 16548)
-- Name: tabel_nilai_pkl; Type: TABLE; Schema: pkl; Owner: raporsp_user
--

CREATE TABLE pkl.tabel_nilai_pkl (
    id_nilai_pkl uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    sekolah_id uuid NOT NULL,
    tahun_id character varying(4),
    anggota_kelompok_id uuid DEFAULT projec.uuid_generate_v4() NOT NULL,
    peserta_didik_id uuid NOT NULL,
    kelompok_id uuid NOT NULL,
    id_tp uuid NOT NULL,
    skor numeric(5,2),
    deskripsi text,
    id_rencana_pkl uuid
);


ALTER TABLE pkl.tabel_nilai_pkl OWNER TO raporsp_user;

--
-- TOC entry 232 (class 1259 OID 16555)
-- Name: tabel_pelengkap_pkl; Type: TABLE; Schema: pkl; Owner: raporsp_user
--

CREATE TABLE pkl.tabel_pelengkap_pkl (
    id_lengkap_pkl uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    sekolah_id uuid NOT NULL,
    tahun_id character varying(4),
    anggota_kelompok_id uuid DEFAULT projec.uuid_generate_v4() NOT NULL,
    peserta_didik_id uuid NOT NULL,
    kelompok_id uuid NOT NULL,
    catatan text,
    sakit numeric(3,0),
    izin numeric(3,0),
    tanpa_keterangan numeric(3,0),
    id_rencana_pkl uuid
);


ALTER TABLE pkl.tabel_pelengkap_pkl OWNER TO raporsp_user;

--
-- TOC entry 233 (class 1259 OID 16562)
-- Name: tabel_rencana_pkl; Type: TABLE; Schema: pkl; Owner: raporsp_user
--

CREATE TABLE pkl.tabel_rencana_pkl (
    id_rencana_pkl uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    sekolah_id uuid NOT NULL,
    tahun_id character varying(4),
    kelompok_id uuid NOT NULL,
    asesor_id uuid NOT NULL,
    tempat_pkl character varying(100) NOT NULL,
    tgl_pkl_mulai date NOT NULL,
    tgl_pkl_selesai date NOT NULL,
    rencana_ke smallint,
    pembimbing_dudi character varying(150),
    pekerjaan character varying(255),
    sk_penugasan character varying(200)
);


ALTER TABLE pkl.tabel_rencana_pkl OWNER TO raporsp_user;

--
-- TOC entry 234 (class 1259 OID 16568)
-- Name: tabel_tp_elemen; Type: TABLE; Schema: pkl; Owner: raporsp_user
--

CREATE TABLE pkl.tabel_tp_elemen (
    id_tp uuid DEFAULT pkl.uuid_generate_v4() NOT NULL,
    sekolah_id uuid NOT NULL,
    kurikulum_id smallint NOT NULL,
    elemen_id uuid NOT NULL,
    no_urut integer NOT NULL,
    tujuan text NOT NULL,
    status numeric(1,0) DEFAULT 1 NOT NULL
);


ALTER TABLE pkl.tabel_tp_elemen OWNER TO raporsp_user;

--
-- TOC entry 235 (class 1259 OID 16575)
-- Name: nilai_catatanprojek; Type: TABLE; Schema: projec; Owner: raporsp_user
--

CREATE TABLE projec.nilai_catatanprojek (
    id_nilcatprojec uuid DEFAULT projec.uuid_generate_v4() NOT NULL,
    anggota_kelompok_id uuid,
    peserta_didik_id uuid,
    th_ajaran character varying(4) NOT NULL,
    fase character varying(1),
    id_project uuid NOT NULL,
    deskripsi text,
    kelompok_id uuid NOT NULL
);


ALTER TABLE projec.nilai_catatanprojek OWNER TO raporsp_user;

--
-- TOC entry 236 (class 1259 OID 16581)
-- Name: nilai_profil_projek; Type: TABLE; Schema: projec; Owner: raporsp_user
--

CREATE TABLE projec.nilai_profil_projek (
    id_nil_projek uuid DEFAULT projec.uuid_generate_v4() NOT NULL,
    kelompok_id uuid NOT NULL,
    anggota_kelompok_id uuid NOT NULL,
    peserta_didik_id uuid NOT NULL,
    th_ajaran character varying(4) NOT NULL,
    fase character varying(1) NOT NULL,
    id_profil_projek uuid NOT NULL,
    nilai character varying(4) NOT NULL,
    nilai_angka smallint
);


ALTER TABLE projec.nilai_profil_projek OWNER TO raporsp_user;

--
-- TOC entry 237 (class 1259 OID 16585)
-- Name: profil_capaian; Type: TABLE; Schema: projec; Owner: raporsp_user
--

CREATE TABLE projec.profil_capaian (
    id_capaian uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    id_subelemen uuid,
    fase character varying(1),
    nama_capaian text
);


ALTER TABLE projec.profil_capaian OWNER TO raporsp_user;

--
-- TOC entry 238 (class 1259 OID 16591)
-- Name: profil_dimensi; Type: TABLE; Schema: projec; Owner: raporsp_user
--

CREATE TABLE projec.profil_dimensi (
    id_dimensi uuid DEFAULT projec.uuid_generate_v4() NOT NULL,
    nama_dimensi character varying(150),
    urut smallint
);


ALTER TABLE projec.profil_dimensi OWNER TO raporsp_user;

--
-- TOC entry 239 (class 1259 OID 16595)
-- Name: profil_elemen; Type: TABLE; Schema: projec; Owner: raporsp_user
--

CREATE TABLE projec.profil_elemen (
    id_elemen uuid DEFAULT projec.uuid_generate_v4() NOT NULL,
    id_dimensi uuid,
    nama_elemen character varying(200),
    urut smallint
);


ALTER TABLE projec.profil_elemen OWNER TO raporsp_user;

--
-- TOC entry 240 (class 1259 OID 16599)
-- Name: profil_project; Type: TABLE; Schema: projec; Owner: raporsp_user
--

CREATE TABLE projec.profil_project (
    id_project uuid DEFAULT projec.uuid_generate_v4() NOT NULL,
    id_tema uuid,
    nama_project character varying(250),
    fase character varying(1),
    deskripsi_project text,
    status smallint
);


ALTER TABLE projec.profil_project OWNER TO raporsp_user;

--
-- TOC entry 241 (class 1259 OID 16605)
-- Name: profil_subelemen; Type: TABLE; Schema: projec; Owner: raporsp_user
--

CREATE TABLE projec.profil_subelemen (
    id_subelemen uuid DEFAULT projec.uuid_generate_v4() NOT NULL,
    id_elemen uuid,
    nama_subelemen character varying(255)
);


ALTER TABLE projec.profil_subelemen OWNER TO raporsp_user;

--
-- TOC entry 242 (class 1259 OID 16609)
-- Name: profil_tema; Type: TABLE; Schema: projec; Owner: raporsp_user
--

CREATE TABLE projec.profil_tema (
    id_tema uuid DEFAULT projec.uuid_generate_v4() NOT NULL,
    nama_tema character varying(250),
    urut smallint
);


ALTER TABLE projec.profil_tema OWNER TO raporsp_user;

--
-- TOC entry 243 (class 1259 OID 16613)
-- Name: project_capaianprofil; Type: TABLE; Schema: projec; Owner: raporsp_user
--

CREATE TABLE projec.project_capaianprofil (
    id_profil_projek uuid DEFAULT projec.uuid_generate_v4() NOT NULL,
    id_project uuid NOT NULL,
    fase character varying(1) NOT NULL,
    jenjang character varying(20) NOT NULL,
    id_subelemen uuid NOT NULL,
    id_capaian uuid NOT NULL,
    status numeric(1,0) NOT NULL
);


ALTER TABLE projec.project_capaianprofil OWNER TO raporsp_user;

--
-- TOC entry 244 (class 1259 OID 16617)
-- Name: ref_penilaian; Type: TABLE; Schema: projec; Owner: raporsp_user
--

CREATE TABLE projec.ref_penilaian (
    kd_nilai character varying(4) NOT NULL,
    nama_nil character varying(100),
    desk_nilai character varying(255)
);


ALTER TABLE projec.ref_penilaian OWNER TO raporsp_user;

--
-- TOC entry 245 (class 1259 OID 16620)
-- Name: tabel_anggotakelompok; Type: TABLE; Schema: projec; Owner: raporsp_user
--

CREATE TABLE projec.tabel_anggotakelompok (
    anggota_kelompok_id uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    peserta_didik_id uuid NOT NULL,
    kelompok_id uuid NOT NULL,
    th_ajaran character varying(4) NOT NULL,
    fase character varying(1)
);


ALTER TABLE projec.tabel_anggotakelompok OWNER TO raporsp_user;

--
-- TOC entry 246 (class 1259 OID 16624)
-- Name: tabel_kelompok; Type: TABLE; Schema: projec; Owner: raporsp_user
--

CREATE TABLE projec.tabel_kelompok (
    kelompok_id uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    sekolah_id uuid NOT NULL,
    th_ajaran character varying(4) NOT NULL,
    ptk_id uuid,
    nm_kelompok character varying(30),
    tingkat_pendidikan_id numeric(2,0),
    status numeric(1,0) DEFAULT 1,
    fase character varying(1)
);


ALTER TABLE projec.tabel_kelompok OWNER TO raporsp_user;

--
-- TOC entry 247 (class 1259 OID 16629)
-- Name: tabel_kelompok_projek; Type: TABLE; Schema: projec; Owner: raporsp_user
--

CREATE TABLE projec.tabel_kelompok_projek (
    klp_projek_id uuid DEFAULT projec.uuid_generate_v4() NOT NULL,
    kelompok_id uuid NOT NULL,
    id_project uuid NOT NULL,
    th_ajaran character varying(4) NOT NULL,
    fase character varying(1) NOT NULL,
    status numeric(1,0) DEFAULT 1
);


ALTER TABLE projec.tabel_kelompok_projek OWNER TO raporsp_user;

--
-- TOC entry 248 (class 1259 OID 16634)
-- Name: jurusan; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.jurusan (
    jurusan_id character varying(25) NOT NULL,
    nama_jurusan character varying(100) NOT NULL,
    untuk_sma numeric(1,0) NOT NULL,
    untuk_smk numeric(1,0) NOT NULL,
    untuk_pt numeric(1,0) NOT NULL,
    untuk_slb numeric(1,0) NOT NULL,
    untuk_smklb numeric(1,0) NOT NULL,
    jenjang_pendidikan_id numeric(2,0),
    jurusan_induk character varying(25),
    level_bidang_id character varying(5) NOT NULL,
    create_date timestamp(6) without time zone NOT NULL,
    last_update timestamp(6) without time zone NOT NULL,
    expired_date timestamp(6) without time zone,
    last_sync timestamp(6) without time zone NOT NULL
);


ALTER TABLE public.jurusan OWNER TO raporsp_user;

--
-- TOC entry 249 (class 1259 OID 16637)
-- Name: loginstatus; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.loginstatus (
    userid character varying(50) NOT NULL,
    mulai timestamp(6) without time zone NOT NULL,
    status numeric(1,0)
);


ALTER TABLE public.loginstatus OWNER TO raporsp_user;

--
-- TOC entry 250 (class 1259 OID 16640)
-- Name: pengguna_api; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.pengguna_api (
    id uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    username character varying(50) NOT NULL,
    password character varying(255) NOT NULL,
    nama character varying(150),
    telp_hp character varying(30),
    email character varying(255),
    status integer DEFAULT 1
);


ALTER TABLE public.pengguna_api OWNER TO raporsp_user;

--
-- TOC entry 251 (class 1259 OID 16647)
-- Name: ref_klp_mapel; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.ref_klp_mapel (
    klp_id integer NOT NULL,
    jns_klp character varying(5) NOT NULL,
    nama character varying(50) NOT NULL,
    jenjang character varying(20) NOT NULL,
    status numeric(1,0) NOT NULL,
    id integer NOT NULL
);


ALTER TABLE public.ref_klp_mapel OWNER TO raporsp_user;

--
-- TOC entry 252 (class 1259 OID 16650)
-- Name: ref_mapeldapo; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.ref_mapeldapo (
    mata_pelajaran_id integer NOT NULL,
    nm_mapel character varying(150),
    jurusan_id character varying(25)
);


ALTER TABLE public.ref_mapeldapo OWNER TO raporsp_user;

--
-- TOC entry 253 (class 1259 OID 16653)
-- Name: ref_teknik; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.ref_teknik (
    teknik_id integer NOT NULL,
    nama_teknik character varying(50) NOT NULL,
    status numeric(1,0) NOT NULL
);


ALTER TABLE public.ref_teknik OWNER TO raporsp_user;

--
-- TOC entry 254 (class 1259 OID 16656)
-- Name: ref_teknik_id_seq; Type: SEQUENCE; Schema: public; Owner: raporsp_user
--

CREATE SEQUENCE public.ref_teknik_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.ref_teknik_id_seq OWNER TO raporsp_user;

--
-- TOC entry 4205 (class 0 OID 0)
-- Dependencies: 254
-- Name: ref_teknik_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: raporsp_user
--

ALTER SEQUENCE public.ref_teknik_id_seq OWNED BY public.ref_teknik.teknik_id;


--
-- TOC entry 255 (class 1259 OID 16657)
-- Name: refekstra_kurikuler; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.refekstra_kurikuler (
    id_ekskul integer NOT NULL,
    nm_ekskul character varying(80),
    u_sd numeric(1,0) DEFAULT 0 NOT NULL,
    u_smp numeric(1,0) DEFAULT 0 NOT NULL,
    u_sma numeric(1,0) DEFAULT 0 NOT NULL,
    u_smk numeric(1,0) DEFAULT 0 NOT NULL
);


ALTER TABLE public.refekstra_kurikuler OWNER TO raporsp_user;

--
-- TOC entry 256 (class 1259 OID 16664)
-- Name: semester; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.semester (
    semester_id character varying(5) NOT NULL,
    tahun_ajaran_id character varying(4) NOT NULL,
    nama_semester character varying(20) NOT NULL,
    semester numeric(1,0) NOT NULL,
    periode_aktif character varying(1) NOT NULL,
    tanggal_mulai date NOT NULL,
    tanggal_selesai date NOT NULL
);


ALTER TABLE public.semester OWNER TO raporsp_user;

--
-- TOC entry 257 (class 1259 OID 16667)
-- Name: status_data; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.status_data (
    semester_id character varying(5) NOT NULL,
    aktif_data numeric(1,0) NOT NULL,
    keterangan character varying(100) NOT NULL
);


ALTER TABLE public.status_data OWNER TO raporsp_user;

--
-- TOC entry 258 (class 1259 OID 16670)
-- Name: status_input; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.status_input (
    semester_id character varying(5) NOT NULL,
    aktif_data numeric(1,0) NOT NULL,
    keterangan character varying(100) NOT NULL
);


ALTER TABLE public.status_input OWNER TO raporsp_user;

--
-- TOC entry 259 (class 1259 OID 16673)
-- Name: tabel_anggotakelas; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_anggotakelas (
    anggota_rombel_id uuid NOT NULL,
    peserta_didik_id uuid NOT NULL,
    rombongan_belajar_id uuid NOT NULL,
    semester_id character varying(5) NOT NULL
);


ALTER TABLE public.tabel_anggotakelas OWNER TO raporsp_user;

--
-- TOC entry 4206 (class 0 OID 0)
-- Dependencies: 259
-- Name: TABLE tabel_anggotakelas; Type: COMMENT; Schema: public; Owner: raporsp_user
--

COMMENT ON TABLE public.tabel_anggotakelas IS 'asal: tabel_perkelas';


--
-- TOC entry 260 (class 1259 OID 16676)
-- Name: tabel_antar_mapel; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_antar_mapel (
    id_antar_mapel uuid NOT NULL,
    anggota_rombel_id uuid,
    semester_id character varying(5),
    otomatis text,
    sosial text,
    keterangan text,
    keterangansos text,
    peserta_didik_id uuid,
    sikap character varying(3),
    sikapsos character varying(3),
    khusus integer,
    semester numeric(1,0)
);


ALTER TABLE public.tabel_antar_mapel OWNER TO raporsp_user;

--
-- TOC entry 261 (class 1259 OID 16681)
-- Name: tabel_asesor; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_asesor (
    asesor_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    nama character varying(200) NOT NULL,
    nip character varying(18),
    nuptk character varying(16),
    jenis_kelamin character varying(1) NOT NULL,
    tempat_lahir character varying(32) NOT NULL,
    tanggal_lahir date NOT NULL,
    alamat character varying(80) NOT NULL,
    status numeric(1,0) DEFAULT 1 NOT NULL,
    id_dudi uuid
);


ALTER TABLE public.tabel_asesor OWNER TO raporsp_user;

--
-- TOC entry 262 (class 1259 OID 16685)
-- Name: tabel_capaiantp; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_capaiantp (
    id_kompetensi uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    mata_pelajaran_id integer NOT NULL,
    tingkat_pendidikan_id numeric(2,0) NOT NULL,
    semester numeric(1,0) NOT NULL,
    jenis character varying(1) NOT NULL,
    kd_kompetensi character varying(6) NOT NULL,
    kompetensi text NOT NULL,
    ringkasan_kompetensi text,
    bidang numeric(1,0),
    status numeric(1,0) DEFAULT 1,
    jenjang character varying(20)
);


ALTER TABLE public.tabel_capaiantp OWNER TO raporsp_user;

--
-- TOC entry 263 (class 1259 OID 16692)
-- Name: tabel_cat_wali; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_cat_wali (
    sikap_id uuid NOT NULL,
    rombongan_belajar_id uuid,
    peserta_didik_id uuid,
    semester_id character varying(5),
    deskripsi text,
    deskripsi1 text,
    semester numeric(1,0)
);


ALTER TABLE public.tabel_cat_wali OWNER TO raporsp_user;

--
-- TOC entry 264 (class 1259 OID 16697)
-- Name: tabel_deskripsi; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_deskripsi (
    deskripsi_id uuid NOT NULL,
    mata_pelajaran_id integer,
    rombongan_belajar_id uuid,
    peserta_didik_id uuid,
    deskripsi_peng_o text,
    deskripsi_peng_m text,
    deskripsi_ket_o text,
    deskripsi_ket_m text,
    deskripsi_sik_o text,
    deskripsi_sik_m text,
    deskripsi_siksos_o text,
    deskripsi_siksos_m text,
    semester_id character varying(5),
    id_minat character varying(2),
    anggota_rombel_id uuid,
    semester numeric(1,0)
);


ALTER TABLE public.tabel_deskripsi OWNER TO raporsp_user;

--
-- TOC entry 265 (class 1259 OID 16702)
-- Name: tabel_deskripsi_tengah; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_deskripsi_tengah (
    deskripsi_id uuid NOT NULL,
    mata_pelajaran_id integer,
    rombongan_belajar_id uuid,
    peserta_didik_id uuid,
    deskripsi_peng_o text,
    deskripsi_peng_m text,
    deskripsi_ket_o text,
    deskripsi_ket_m text,
    deskripsi_sik_o text,
    deskripsi_sik_m text,
    deskripsi_siksos_o text,
    deskripsi_siksos_m text,
    semester_id character varying(5),
    id_minat character varying(2),
    anggota_rombel_id uuid,
    semester numeric(1,0)
);


ALTER TABLE public.tabel_deskripsi_tengah OWNER TO raporsp_user;

--
-- TOC entry 266 (class 1259 OID 16707)
-- Name: tabel_dudi; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_dudi (
    id_dudi uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    nama_dudi character varying(200),
    lokasi character varying(250),
    keterangan text,
    status numeric(1,0) DEFAULT 1 NOT NULL
);


ALTER TABLE public.tabel_dudi OWNER TO raporsp_user;

--
-- TOC entry 267 (class 1259 OID 16713)
-- Name: tabel_ekstra; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_ekstra (
    id_ekstra uuid NOT NULL,
    nama_ekstra character varying(30),
    id_ekskul integer
);


ALTER TABLE public.tabel_ekstra OWNER TO raporsp_user;

--
-- TOC entry 268 (class 1259 OID 16716)
-- Name: tabel_indikator_skkni; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_indikator_skkni (
    id_indikator uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    skkd_id uuid NOT NULL,
    no_urut integer NOT NULL,
    indikator text NOT NULL,
    status numeric(1,0) DEFAULT 1 NOT NULL,
    sekolah_id uuid NOT NULL
);


ALTER TABLE public.tabel_indikator_skkni OWNER TO raporsp_user;

--
-- TOC entry 269 (class 1259 OID 16723)
-- Name: tabel_info; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_info (
    id_info integer NOT NULL,
    v_app character varying(10) NOT NULL,
    v_db character varying(10) NOT NULL,
    pesan character varying(100) NOT NULL,
    tanggal timestamp(6) without time zone NOT NULL,
    tampil numeric(1,0)
);


ALTER TABLE public.tabel_info OWNER TO raporsp_user;

--
-- TOC entry 270 (class 1259 OID 16726)
-- Name: tabel_jurusan; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_jurusan (
    jurusan_id character varying(25) NOT NULL,
    nama_jurusan_sp character varying(100),
    kurikulum character varying(120),
    jurusan_sp_id uuid,
    kurikulum_id smallint,
    sekolah_id uuid
);


ALTER TABLE public.tabel_jurusan OWNER TO raporsp_user;

--
-- TOC entry 271 (class 1259 OID 16729)
-- Name: tabel_kehadiran; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_kehadiran (
    kd_kehadiran uuid NOT NULL,
    semester_id character varying(5) NOT NULL,
    anggota_rombel_id uuid NOT NULL,
    sakit numeric(3,0),
    izin numeric(3,0),
    tanpa_keterangan numeric(3,0),
    peserta_didik_id uuid,
    semester numeric(1,0)
);


ALTER TABLE public.tabel_kehadiran OWNER TO raporsp_user;

--
-- TOC entry 272 (class 1259 OID 16732)
-- Name: tabel_kelas; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_kelas (
    rombongan_belajar_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    semester_id character varying(5) NOT NULL,
    jurusan_id character varying(25),
    ptk_id uuid,
    nm_kelas character varying(30),
    tingkat_pendidikan_id numeric(2,0),
    jenis_rombel numeric(2,0),
    nama_jurusan_sp character varying(100),
    jurusan_sp_id uuid,
    kurikulum_id smallint NOT NULL,
    program character varying(150),
    konsentrasi character varying(150)
);


ALTER TABLE public.tabel_kelas OWNER TO raporsp_user;

--
-- TOC entry 273 (class 1259 OID 16735)
-- Name: tabel_kelas_ekskul; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_kelas_ekskul (
    id_kelas_ekskul uuid NOT NULL,
    rombongan_belajar_id uuid NOT NULL,
    id_ekskul integer NOT NULL,
    nm_ekskul character varying(80) NOT NULL,
    sk_ekskul character varying(80) NOT NULL,
    tgl_sk_ekskul date,
    jam_kegiatan_per_minggu numeric(2,0)
);


ALTER TABLE public.tabel_kelas_ekskul OWNER TO raporsp_user;

--
-- TOC entry 274 (class 1259 OID 16738)
-- Name: tabel_kenaikan; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_kenaikan (
    kd_kenaikan uuid NOT NULL,
    semester_id character varying(5) NOT NULL,
    anggota_rombel_id uuid NOT NULL,
    peserta_didik_id uuid,
    kenaikan numeric(3,0),
    tingkat numeric(3,0)
);


ALTER TABLE public.tabel_kenaikan OWNER TO raporsp_user;

--
-- TOC entry 275 (class 1259 OID 16741)
-- Name: tabel_kkm; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_kkm (
    id_kkm uuid NOT NULL,
    mata_pelajaran_id integer,
    tingkat_pendidikan_id numeric(2,0),
    semester_id character varying(5),
    kkm numeric(2,0),
    jjm numeric(2,0),
    jurusan_id character varying(25)
);


ALTER TABLE public.tabel_kkm OWNER TO raporsp_user;

--
-- TOC entry 276 (class 1259 OID 16744)
-- Name: tabel_kurikulum; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_kurikulum (
    kurikulum_id smallint NOT NULL,
    nama_kurikulum character varying(120) NOT NULL,
    mulai_berlaku date NOT NULL,
    sistem_sks numeric(1,0) NOT NULL,
    total_sks numeric(3,0) NOT NULL,
    jenjang_pendidikan_id numeric(2,0) NOT NULL,
    jurusan_id character varying(25),
    create_date timestamp(6) without time zone NOT NULL,
    last_update timestamp(6) without time zone NOT NULL,
    expired_date timestamp(6) without time zone,
    last_sync timestamp(6) without time zone NOT NULL
);


ALTER TABLE public.tabel_kurikulum OWNER TO raporsp_user;

--
-- TOC entry 277 (class 1259 OID 16747)
-- Name: tabel_map_mapelk2013; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_map_mapelk2013 (
    id_map_mapel uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    mata_pelajaran_id integer NOT NULL,
    nm_lokal character varying(100),
    area_kompetensi character varying(2),
    klp_mpl smallint NOT NULL,
    kurikulum_id smallint NOT NULL,
    urut_rapor integer,
    tingkat_pendidikan_id numeric(2,0)
);


ALTER TABLE public.tabel_map_mapelk2013 OWNER TO raporsp_user;

--
-- TOC entry 278 (class 1259 OID 16751)
-- Name: tabel_map_mapelskl; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_map_mapelskl (
    id_map_mapel uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    mata_pelajaran_id integer NOT NULL,
    nm_lokal character varying(100),
    area_kompetensi character varying(2),
    klp_mpl smallint NOT NULL,
    kurikulum_id smallint NOT NULL,
    urut_skl integer,
    tingkat_pendidikan_id numeric(2,0)
);


ALTER TABLE public.tabel_map_mapelskl OWNER TO raporsp_user;

--
-- TOC entry 279 (class 1259 OID 16755)
-- Name: tabel_mapel; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_mapel (
    mata_pelajaran_id integer NOT NULL,
    nm_mapel character varying(150),
    kelompok character varying(2),
    semester numeric(1,0),
    jurusan_id character varying(25),
    urut_rapor integer,
    nm_lokal character varying(150),
    nm_ringkas character varying(10)
);


ALTER TABLE public.tabel_mapel OWNER TO raporsp_user;

--
-- TOC entry 280 (class 1259 OID 16758)
-- Name: tabel_nilai_dudi; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_nilai_dudi (
    id_nilai_dudi uuid NOT NULL,
    rombongan_belajar_id uuid,
    anggota_rombel_id uuid,
    peserta_didik_id uuid,
    mitra character varying(200),
    lokasi character varying(250),
    lama smallint,
    keterangan text,
    semester_id character varying(5),
    semester numeric(1,0)
);


ALTER TABLE public.tabel_nilai_dudi OWNER TO raporsp_user;

--
-- TOC entry 281 (class 1259 OID 16763)
-- Name: tabel_nilai_ekstra; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_nilai_ekstra (
    kd_nilai_ekstra uuid NOT NULL,
    semester_id character varying(5) NOT NULL,
    anggota_rombel_id uuid NOT NULL,
    id_ekstra uuid NOT NULL,
    nilai_ekstra character varying(3),
    deskripsi text,
    peserta_didik_id uuid,
    id_kelas_ekskul uuid,
    ekskul_rombel_id uuid,
    id_ekskul_baru integer NOT NULL,
    semester numeric(1,0)
);


ALTER TABLE public.tabel_nilai_ekstra OWNER TO raporsp_user;

--
-- TOC entry 4207 (class 0 OID 0)
-- Dependencies: 281
-- Name: TABLE tabel_nilai_ekstra; Type: COMMENT; Schema: public; Owner: raporsp_user
--

COMMENT ON TABLE public.tabel_nilai_ekstra IS 'asal: tabel_ekstra';


--
-- TOC entry 282 (class 1259 OID 16768)
-- Name: tabel_nilai_formatif; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_nilai_formatif (
    formatif_id uuid NOT NULL,
    mata_pelajaran_id integer NOT NULL,
    rombongan_belajar_id uuid NOT NULL,
    peserta_didik_id uuid NOT NULL,
    id_kompetensi uuid NOT NULL,
    nilai numeric(5,2) NOT NULL,
    teknik_id integer NOT NULL,
    semester_id character varying(5) NOT NULL,
    penilaian_ke smallint NOT NULL
);


ALTER TABLE public.tabel_nilai_formatif OWNER TO raporsp_user;

--
-- TOC entry 283 (class 1259 OID 16771)
-- Name: tabel_nilai_karakter; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_nilai_karakter (
    id_nilai uuid NOT NULL,
    rombongan_belajar_id uuid,
    anggota_rombel_id uuid,
    peserta_didik_id uuid,
    dimensi1 text,
    dimensi2 text,
    dimensi3 text,
    dimensi4 text,
    dimensi5 text,
    dimensi6 text,
    semester_id character varying(5),
    semester numeric(1,0)
);


ALTER TABLE public.tabel_nilai_karakter OWNER TO raporsp_user;

--
-- TOC entry 284 (class 1259 OID 16776)
-- Name: tabel_nilai_p3guru; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_nilai_p3guru (
    id_p3 uuid NOT NULL,
    rombongan_belajar_id uuid NOT NULL,
    peserta_didik_id uuid NOT NULL,
    id_subelemen uuid,
    nilai numeric(5,0) NOT NULL,
    dimensi integer NOT NULL,
    semester_id character varying(5) NOT NULL,
    id_elemen uuid NOT NULL,
    ptk_id uuid NOT NULL,
    anggota_rombel_id uuid NOT NULL,
    id_dimensi uuid
);


ALTER TABLE public.tabel_nilai_p3guru OWNER TO raporsp_user;

--
-- TOC entry 285 (class 1259 OID 16779)
-- Name: tabel_nilai_ukk; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_nilai_ukk (
    id_nilai_ukk uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    semester_id character varying(5),
    rombongan_belajar_id uuid,
    anggota_rombel_id uuid,
    peserta_didik_id uuid,
    id_paket uuid NOT NULL,
    id_dudi uuid NOT NULL,
    ptk_id uuid NOT NULL,
    asesor_id uuid NOT NULL,
    tempat_ttd character varying(100) NOT NULL,
    tanggal date NOT NULL,
    nilai_ukk numeric(5,0) NOT NULL,
    kesimpulan_id character varying(100) NOT NULL,
    kesimpulan_en character varying(100) NOT NULL,
    keterangan text,
    waktu numeric(5,0)
);


ALTER TABLE public.tabel_nilai_ukk OWNER TO raporsp_user;

--
-- TOC entry 286 (class 1259 OID 16784)
-- Name: tabel_nilaiakhir; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_nilaiakhir (
    id_nilai_akhir uuid NOT NULL,
    anggota_rombel_id uuid,
    mata_pelajaran_id integer,
    semester_id character varying(5),
    nilai_peng numeric(5,0),
    predikat_peng character varying(1),
    nilai_ket numeric(5,0),
    predikat_ket character varying(1),
    nilai_sik numeric(2,0),
    predikat_sik character varying(15),
    nilai_siksos numeric(2,0),
    predikat_siksos character varying(15),
    peserta_didik_id uuid,
    id_minat character varying(2),
    semester numeric(1,0)
);


ALTER TABLE public.tabel_nilaiakhir OWNER TO raporsp_user;

--
-- TOC entry 287 (class 1259 OID 16787)
-- Name: tabel_nilaiskl; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_nilaiskl (
    id_nilai_skl uuid NOT NULL,
    semester_id character varying(5),
    sekolah_id uuid NOT NULL,
    rombongan_belajar_id uuid NOT NULL,
    anggota_rombel_id uuid,
    peserta_didik_id uuid,
    mata_pelajaran_id integer,
    kurikulum_id smallint NOT NULL,
    nilai numeric(5,2)
);


ALTER TABLE public.tabel_nilaiskl OWNER TO raporsp_user;

--
-- TOC entry 288 (class 1259 OID 16790)
-- Name: tabel_nilaitengah; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_nilaitengah (
    id_nilai_akhir uuid NOT NULL,
    anggota_rombel_id uuid,
    mata_pelajaran_id integer,
    semester_id character varying(5),
    nilai_peng numeric(5,0),
    predikat_peng character varying(1),
    nilai_ket numeric(5,0),
    predikat_ket character varying(1),
    nilai_sik numeric(2,0),
    predikat_sik character varying(15),
    nilai_siksos numeric(2,0),
    predikat_siksos character varying(15),
    peserta_didik_id uuid,
    id_minat character varying(2),
    semester numeric(1,0)
);


ALTER TABLE public.tabel_nilaitengah OWNER TO raporsp_user;

--
-- TOC entry 289 (class 1259 OID 16793)
-- Name: tabel_paket_kompetensi; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_paket_kompetensi (
    id_paket uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    kd_paket character varying(60) NOT NULL,
    nama_paket_id character varying(200),
    nama_paket_en character varying(200),
    jurusan_id character varying(25),
    kurikulum_id smallint NOT NULL,
    status numeric(1,0) DEFAULT 1 NOT NULL
);


ALTER TABLE public.tabel_paket_kompetensi OWNER TO raporsp_user;

--
-- TOC entry 290 (class 1259 OID 16797)
-- Name: tabel_pembelajaran; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_pembelajaran (
    pembelajaran_id uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    rombongan_belajar_id uuid NOT NULL,
    mata_pelajaran_id integer NOT NULL,
    semester_id character varying(5) NOT NULL,
    ptk_terdaftar_id uuid,
    status_di_kurikulum numeric(2,0),
    nama_mata_pelajaran character varying(100),
    induk_pembelajaran uuid,
    is_dapo numeric(1,0) DEFAULT 1
);


ALTER TABLE public.tabel_pembelajaran OWNER TO raporsp_user;

--
-- TOC entry 4208 (class 0 OID 0)
-- Dependencies: 290
-- Name: TABLE tabel_pembelajaran; Type: COMMENT; Schema: public; Owner: raporsp_user
--

COMMENT ON TABLE public.tabel_pembelajaran IS 'asal: tabel_peminatan';


--
-- TOC entry 291 (class 1259 OID 16802)
-- Name: tabel_pengumumanlulus; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_pengumumanlulus (
    setlulus_id uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    tahun_ajaran_id character varying(4) NOT NULL,
    nomor_sk character varying(100),
    link_sk text,
    isi_lulus text,
    isi_gagal text,
    sekolah_id uuid,
    tgl_pengumuman timestamp(6) without time zone,
    status_aktif numeric(1,0) DEFAULT 1 NOT NULL
);


ALTER TABLE public.tabel_pengumumanlulus OWNER TO raporsp_user;

--
-- TOC entry 292 (class 1259 OID 16809)
-- Name: tabel_ptk; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_ptk (
    ptk_id uuid NOT NULL,
    nama character varying(100) NOT NULL,
    nip character varying(18),
    jenis_ptk_id numeric(2,0) NOT NULL,
    jenis_kelamin character varying(1) NOT NULL,
    tempat_lahir character varying(32) NOT NULL,
    tanggal_lahir date NOT NULL,
    nuptk character varying(16),
    alamat_jalan character varying(80),
    status_keaktifan_id numeric(2,0) NOT NULL,
    soft_delete numeric(1,0) NOT NULL
);


ALTER TABLE public.tabel_ptk OWNER TO raporsp_user;

--
-- TOC entry 293 (class 1259 OID 16812)
-- Name: tabel_ptk_pelengkap; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_ptk_pelengkap (
    ptk_pelengkap_id uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    ptk_id uuid NOT NULL,
    gelar_depan character varying(20),
    gelar_belakang character varying(20),
    nip_niy character varying(18)
);


ALTER TABLE public.tabel_ptk_pelengkap OWNER TO raporsp_user;

--
-- TOC entry 294 (class 1259 OID 16816)
-- Name: tabel_ptk_terdaftar; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_ptk_terdaftar (
    ptk_terdaftar_id uuid NOT NULL,
    ptk_id uuid NOT NULL,
    tahun_ajaran_id character varying(4),
    jenis_keluar_id character(1),
    soft_delete numeric(1,0) NOT NULL,
    sekolah_id uuid
);


ALTER TABLE public.tabel_ptk_terdaftar OWNER TO raporsp_user;

--
-- TOC entry 295 (class 1259 OID 16819)
-- Name: tabel_ptspas; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_ptspas (
    id_ptspas uuid NOT NULL,
    semester_id character varying(5),
    mata_pelajaran_id integer NOT NULL,
    rombongan_belajar_id uuid NOT NULL,
    peserta_didik_id uuid NOT NULL,
    anggota_rombel_id uuid NOT NULL,
    nil_pts numeric(5,2),
    nil_pas numeric(5,2)
);


ALTER TABLE public.tabel_ptspas OWNER TO raporsp_user;

--
-- TOC entry 296 (class 1259 OID 16822)
-- Name: tabel_registrasi_pd; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_registrasi_pd (
    registrasi_id uuid NOT NULL,
    jurusan_sp_id uuid,
    peserta_didik_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    jenis_pendaftaran_id numeric(1,0) NOT NULL,
    nipd character varying(18),
    tanggal_masuk_sekolah date NOT NULL,
    jenis_keluar_id character(1),
    tanggal_keluar date,
    keterangan character varying(128),
    no_skhun character(20),
    no_peserta_ujian character(20),
    no_seri_ijazah character varying(80),
    a_pernah_paud numeric(1,0) DEFAULT 0 NOT NULL,
    a_pernah_tk numeric(1,0) DEFAULT 0 NOT NULL,
    sekolah_asal character varying(100),
    id_hobby numeric(5,0) NOT NULL,
    id_cita numeric(5,0) NOT NULL,
    last_update timestamp(6) without time zone DEFAULT now() NOT NULL,
    soft_delete numeric(1,0) NOT NULL,
    last_sync timestamp(6) without time zone DEFAULT '1901-01-01 00:00:00'::timestamp without time zone NOT NULL,
    updater_id uuid NOT NULL
);


ALTER TABLE public.tabel_registrasi_pd OWNER TO raporsp_user;

--
-- TOC entry 297 (class 1259 OID 16829)
-- Name: tabel_rombel_skil; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_rombel_skil (
    idrombel_skill uuid NOT NULL,
    rombongan_belajar_id uuid NOT NULL,
    skkd_id uuid NOT NULL,
    semester_id character varying(5) NOT NULL,
    id_indikator text NOT NULL
);


ALTER TABLE public.tabel_rombel_skil OWNER TO raporsp_user;

--
-- TOC entry 298 (class 1259 OID 16834)
-- Name: tabel_sekolah; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_sekolah (
    sekolah_id uuid NOT NULL,
    nama character varying(100) NOT NULL,
    npsn character varying(8),
    nss character varying(12),
    alamat text,
    kd_pos character varying(6),
    telepon character varying(20),
    fax character varying(20),
    kelurahan character varying(60),
    kecamatan character varying(60),
    kab_kota character varying(60),
    propinsi character varying(60),
    website character varying(100),
    email character varying(50),
    nm_kepsek character varying(100),
    nip_kepsek character varying(25),
    niy_kepsek character varying(30),
    status_kepemilikan_id numeric(1,0) NOT NULL,
    kode_aktivasi character varying(30),
    jenjang character varying(20),
    bentuk_pendidikan_id smallint
);


ALTER TABLE public.tabel_sekolah OWNER TO raporsp_user;

--
-- TOC entry 4209 (class 0 OID 0)
-- Dependencies: 298
-- Name: TABLE tabel_sekolah; Type: COMMENT; Schema: public; Owner: raporsp_user
--

COMMENT ON TABLE public.tabel_sekolah IS 'asal: tabel_profil';


--
-- TOC entry 299 (class 1259 OID 16839)
-- Name: tabel_setskl; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_setskl (
    setskl_id uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    tahun_ajaran_id character varying(4) NOT NULL,
    judul_1 character varying(100),
    nomor_skl character varying(100),
    judul_2 character varying(100),
    isi_text1 text,
    identitas_id1 character varying(2),
    identitas_id2 character varying(2),
    identitas_id3 character varying(2),
    identitas_id4 character varying(2),
    identitas_id5 character varying(2),
    identitas_id6 character varying(2),
    identitas_id7 character varying(2),
    identitas_id8 character varying(2),
    isi_text2 text,
    isi_text3 text,
    ada_nilai numeric(1,0) DEFAULT 1,
    judul_nilai character varying(60),
    isi_text4 text,
    ket_tempat_ttd character varying(100),
    nama_kepsek character varying(100),
    nip_kepsek character varying(50),
    ada_foto numeric(1,0) DEFAULT 0,
    ada_ttd numeric(1,0) DEFAULT 0,
    ada_kop numeric(1,0) DEFAULT 1,
    statuslulus numeric(1,0) DEFAULT 1,
    desimal_nilai numeric(1,0) DEFAULT 2,
    ada_ratarata numeric(1,0) DEFAULT 1,
    desimal_ratarata numeric(1,0) DEFAULT 2,
    sekolah_id uuid
);


ALTER TABLE public.tabel_setskl OWNER TO raporsp_user;

--
-- TOC entry 300 (class 1259 OID 16853)
-- Name: tabel_siswa; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_siswa (
    peserta_didik_id uuid NOT NULL,
    nis character varying(20) NOT NULL,
    nisn character varying(13),
    nm_siswa character varying(100) NOT NULL,
    tempat_lahir character varying(50),
    tanggal_lahir date,
    jenis_kelamin character varying(1),
    agama character varying(25),
    alamat_siswa text,
    telepon_siswa character varying(20),
    diterima_tanggal date,
    nm_ayah character varying(100),
    nm_ibu character varying(100),
    pekerjaan_ayah character varying(30),
    pekerjaan_ibu character varying(30),
    nm_wali character varying(100),
    pekerjaan_wali character varying(30)
);


ALTER TABLE public.tabel_siswa OWNER TO raporsp_user;

--
-- TOC entry 301 (class 1259 OID 16858)
-- Name: tabel_siswa_pelengkap; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_siswa_pelengkap (
    pelengkap_siswa_id uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    peserta_didik_id uuid NOT NULL,
    status_dalam_kel character varying(30),
    anak_ke numeric(3,0),
    sekolah_asal character varying(100),
    diterima_kelas character varying(20),
    alamat_ortu text,
    telepon_ortu character varying(20),
    alamat_wali text,
    telepon_wali character varying(20),
    foto_siswa character varying(100),
    no_ijasahnas character varying(100),
    tgl_lulus date,
    no_transkrip character varying(100)
);


ALTER TABLE public.tabel_siswa_pelengkap OWNER TO raporsp_user;

--
-- TOC entry 302 (class 1259 OID 16864)
-- Name: tabel_skilpassport; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_skilpassport (
    id_skilpassport uuid NOT NULL,
    idrombel_skill uuid NOT NULL,
    rombongan_belajar_id uuid NOT NULL,
    anggota_rombel_id uuid NOT NULL,
    peserta_didik_id uuid NOT NULL,
    skkd_id uuid NOT NULL,
    semester_id character varying(5) NOT NULL,
    ujisiswa character varying(100),
    tgl_uji date,
    nilai character varying(100),
    ptk_id uuid
);


ALTER TABLE public.tabel_skilpassport OWNER TO raporsp_user;

--
-- TOC entry 303 (class 1259 OID 16867)
-- Name: tabel_sklidentitas; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_sklidentitas (
    id smallint NOT NULL,
    nama_identitas character varying(100) NOT NULL,
    kolom character varying(100) NOT NULL,
    status numeric(1,0) NOT NULL
);


ALTER TABLE public.tabel_sklidentitas OWNER TO raporsp_user;

--
-- TOC entry 304 (class 1259 OID 16870)
-- Name: tabel_sskkd_skkni; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_sskkd_skkni (
    skkd_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    kurikulum_id smallint NOT NULL,
    tingkat_pendidikan_id numeric(2,0) NOT NULL,
    kd_skkni character varying(60) NOT NULL,
    kompetensi text NOT NULL,
    jenjang character varying(20) NOT NULL,
    status numeric(1,0) DEFAULT 1 NOT NULL,
    urut_kd integer
);


ALTER TABLE public.tabel_sskkd_skkni OWNER TO raporsp_user;

--
-- TOC entry 305 (class 1259 OID 16876)
-- Name: tabel_sumatif_pas; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_sumatif_pas (
    sumatif_id uuid NOT NULL,
    mata_pelajaran_id integer NOT NULL,
    rombongan_belajar_id uuid NOT NULL,
    peserta_didik_id uuid NOT NULL,
    nilai numeric(5,2) NOT NULL,
    jenis character varying(50) NOT NULL,
    semester_id character varying(5) NOT NULL,
    penilaian_ke smallint NOT NULL,
    targetcapaian character varying(200),
    capaian character varying(2),
    keterangan character varying(200),
    statuscapaian smallint,
    targetcapaian_id uuid,
    kd_capaian character varying(6),
    bobotsum smallint DEFAULT 1 NOT NULL
);


ALTER TABLE public.tabel_sumatif_pas OWNER TO raporsp_user;

--
-- TOC entry 306 (class 1259 OID 16880)
-- Name: tabel_tanggalrapor; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_tanggalrapor (
    tanggal_id uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    semester_id character varying(5),
    tanggal date,
    semester numeric(1,0),
    tempat_ttd character varying(100),
    status_kepsek character varying(100),
    status_nip_kepsek character varying(50),
    status_nip_walas character varying(50),
    ttd_validasi smallint
);


ALTER TABLE public.tabel_tanggalrapor OWNER TO raporsp_user;

--
-- TOC entry 307 (class 1259 OID 16884)
-- Name: tabel_targetcapaian; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_targetcapaian (
    targetcapaian_id uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    mata_pelajaran_id integer NOT NULL,
    tingkat_pendidikan_id numeric(2,0) NOT NULL,
    semester numeric(1,0) NOT NULL,
    kd_capaian character varying(6) NOT NULL,
    targetcapaian character varying(255) NOT NULL,
    status numeric(1,0) DEFAULT 1 NOT NULL,
    jenjang character varying(20) NOT NULL
);


ALTER TABLE public.tabel_targetcapaian OWNER TO raporsp_user;

--
-- TOC entry 308 (class 1259 OID 16889)
-- Name: tabel_targetcptp; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_targetcptp (
    targetid uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    mata_pelajaran_id integer NOT NULL,
    fase character varying(1) NOT NULL,
    targetcapaian_id uuid NOT NULL,
    id_kompetensi uuid NOT NULL
);


ALTER TABLE public.tabel_targetcptp OWNER TO raporsp_user;

--
-- TOC entry 309 (class 1259 OID 16893)
-- Name: tabel_unit_kompetensi; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.tabel_unit_kompetensi (
    id_unit uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    id_paket uuid NOT NULL,
    urut_unit integer,
    kd_unit character varying(60) NOT NULL,
    nama_unit character varying(250),
    status numeric(1,0) DEFAULT 1 NOT NULL
);


ALTER TABLE public.tabel_unit_kompetensi OWNER TO raporsp_user;

--
-- TOC entry 310 (class 1259 OID 16898)
-- Name: user_login; Type: TABLE; Schema: public; Owner: raporsp_user
--

CREATE TABLE public.user_login (
    userid character varying(50) NOT NULL,
    password character varying(128) NOT NULL,
    nama character varying(60) NOT NULL,
    level character varying(50) NOT NULL,
    ptk_id uuid,
    salt character varying(128),
    is_logged_in integer DEFAULT 0,
    tgl_daftar timestamp(6) without time zone,
    last_logged_in timestamp(6) without time zone,
    add_by bigint,
    ip_address character varying(45),
    photo character varying(255),
    status_edit integer,
    is_active integer DEFAULT 1 NOT NULL,
    email character varying(150),
    sub_you integer DEFAULT 0,
    id uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    last_logged_out timestamp(6) without time zone,
    thema character varying(100) DEFAULT 'pasek-theme'::text,
    warnaheader character varying(100) DEFAULT ''::text,
    warnaside character varying(100) DEFAULT ''::text
);


ALTER TABLE public.user_login OWNER TO raporsp_user;

--
-- TOC entry 311 (class 1259 OID 16910)
-- Name: koneksi; Type: TABLE; Schema: tambah; Owner: raporsp_user
--

CREATE TABLE tambah.koneksi (
    id_data uuid DEFAULT tambah.uuid_generate_v4() NOT NULL,
    nama_app character varying(100),
    alamat_ip character varying(150),
    key character varying(150),
    port character varying(5) DEFAULT 5774,
    npsn character varying(15),
    ip_mpd character varying(150)
);


ALTER TABLE tambah.koneksi OWNER TO raporsp_user;

--
-- TOC entry 312 (class 1259 OID 16917)
-- Name: koneksi_ext; Type: TABLE; Schema: tambah; Owner: raporsp_user
--

CREATE TABLE tambah.koneksi_ext (
    id_data uuid DEFAULT tambah.uuid_generate_v4() NOT NULL,
    nama_app character varying(100),
    ip_ext character varying(150),
    key character varying(150),
    "user" character varying(100) DEFAULT 5774,
    pass character varying(100),
    id_sekolah character varying(100)
);


ALTER TABLE tambah.koneksi_ext OWNER TO raporsp_user;

--
-- TOC entry 313 (class 1259 OID 16924)
-- Name: log_nilaiakhir; Type: TABLE; Schema: tambah; Owner: raporsp_user
--

CREATE TABLE tambah.log_nilaiakhir (
    id_log uuid DEFAULT tambah.uuid_generate_v4() NOT NULL,
    anggota_rombel_id uuid,
    mata_pelajaran_id integer,
    semester_id character varying(5),
    nilai_peng_awal numeric(5,0),
    nilai_peng_akhir numeric(5,0),
    peserta_didik_id uuid,
    tgl_update timestamp(6) without time zone DEFAULT now(),
    pengguna_id uuid NOT NULL,
    keterangan text
);


ALTER TABLE tambah.log_nilaiakhir OWNER TO raporsp_user;

--
-- TOC entry 314 (class 1259 OID 16931)
-- Name: logo_ttdkepsek; Type: TABLE; Schema: tambah; Owner: raporsp_user
--

CREATE TABLE tambah.logo_ttdkepsek (
    sekolah_id uuid NOT NULL,
    logo_pemda character varying(100),
    logo_sek character varying(100),
    ttd_kepsek character varying(100),
    kop_sekolah character varying(100)
);


ALTER TABLE tambah.logo_ttdkepsek OWNER TO raporsp_user;

--
-- TOC entry 315 (class 1259 OID 16934)
-- Name: mapel_gabung; Type: TABLE; Schema: tambah; Owner: raporsp_user
--

CREATE TABLE tambah.mapel_gabung (
    id_data uuid DEFAULT tambah.uuid_generate_v4() NOT NULL,
    mata_pelajaran_id_asal integer,
    mata_pelajaran_id integer,
    tingkat_pendidikan_id smallint,
    jenjang character varying(20),
    status numeric(1,0) DEFAULT 1
);


ALTER TABLE tambah.mapel_gabung OWNER TO raporsp_user;

--
-- TOC entry 316 (class 1259 OID 16939)
-- Name: mata_pelajaran_kurikulum; Type: TABLE; Schema: tambah; Owner: raporsp_user
--

CREATE TABLE tambah.mata_pelajaran_kurikulum (
    kurikulum_id smallint NOT NULL,
    mata_pelajaran_id integer NOT NULL,
    tingkat_pendidikan_id numeric(2,0) NOT NULL,
    jumlah_jam numeric(2,0) NOT NULL,
    jumlah_jam_maksimum numeric(2,0) NOT NULL,
    status_di_kurikulum numeric(2,0) NOT NULL,
    wajib numeric(1,0) NOT NULL,
    sks numeric(2,0) DEFAULT 0 NOT NULL,
    a_peminatan numeric(1,0) NOT NULL,
    area_kompetensi character(1) DEFAULT '*'::bpchar NOT NULL,
    gmp_id uuid,
    create_date timestamp(6) without time zone DEFAULT '2022-06-28 18:45:38.08'::timestamp without time zone NOT NULL,
    last_update timestamp(6) without time zone DEFAULT '2022-06-28 18:45:38.08'::timestamp without time zone NOT NULL,
    expired_date timestamp(6) without time zone,
    last_sync timestamp(6) without time zone DEFAULT '1901-01-01 00:00:00'::timestamp without time zone NOT NULL,
    CONSTRAINT ckc_area_kompetensi_mata_pel CHECK ((area_kompetensi = ANY (ARRAY['A'::bpchar, 'N'::bpchar, 'P'::bpchar, '*'::bpchar])))
);


ALTER TABLE tambah.mata_pelajaran_kurikulum OWNER TO raporsp_user;

--
-- TOC entry 317 (class 1259 OID 16948)
-- Name: ref_mapping_mapeldapo; Type: TABLE; Schema: tambah; Owner: raporsp_user
--

CREATE TABLE tambah.ref_mapping_mapeldapo (
    kurikulum_id smallint NOT NULL,
    mata_pelajaran_id integer NOT NULL,
    tingkat_pendidikan_id numeric(2,0) NOT NULL,
    jumlah_jam numeric(2,0) NOT NULL,
    jumlah_jam_maksimum numeric(2,0) NOT NULL,
    status_di_kurikulum numeric(2,0) NOT NULL,
    wajib numeric(1,0) NOT NULL,
    sks numeric(2,0) DEFAULT 0 NOT NULL,
    a_peminatan numeric(1,0) NOT NULL,
    area_kompetensi character(1) DEFAULT '*'::bpchar NOT NULL,
    gmp_id uuid,
    create_date timestamp(6) without time zone DEFAULT '2022-06-28 18:45:38.08'::timestamp without time zone NOT NULL,
    last_update timestamp(6) without time zone DEFAULT '2022-06-28 18:45:38.08'::timestamp without time zone NOT NULL,
    expired_date timestamp(6) without time zone,
    last_sync timestamp(6) without time zone DEFAULT '1901-01-01 00:00:00'::timestamp without time zone NOT NULL
);


ALTER TABLE tambah.ref_mapping_mapeldapo OWNER TO raporsp_user;

--
-- TOC entry 336 (class 1259 OID 17354)
-- Name: tabel_nilai_ijazah; Type: TABLE; Schema: tambah; Owner: raporsp_user
--

CREATE TABLE tambah.tabel_nilai_ijazah (
    id_data uuid DEFAULT tambah.uuid_generate_v4() NOT NULL,
    anggota_rombel_id uuid,
    semester_id character varying(5),
    rombongan_belajar_id uuid,
    peserta_didik_id uuid,
    link_download character varying(150),
    publish character varying(1) DEFAULT 0
);


ALTER TABLE tambah.tabel_nilai_ijazah OWNER TO raporsp_user;

--
-- TOC entry 318 (class 1259 OID 16956)
-- Name: tabel_nilai_klaper; Type: TABLE; Schema: tambah; Owner: raporsp_user
--

CREATE TABLE tambah.tabel_nilai_klaper (
    id_data uuid NOT NULL,
    anggota_rombel_id uuid,
    semester_id character varying(5),
    semester numeric(1,0),
    peserta_didik_id uuid,
    link_download character varying(150),
    publish character varying(1) DEFAULT 0
);


ALTER TABLE tambah.tabel_nilai_klaper OWNER TO raporsp_user;

--
-- TOC entry 319 (class 1259 OID 16960)
-- Name: tabel_nilai_pkl; Type: TABLE; Schema: tambah; Owner: raporsp_user
--

CREATE TABLE tambah.tabel_nilai_pkl (
    id_data uuid DEFAULT tambah.uuid_generate_v4() NOT NULL,
    rombongan_belajar_id uuid,
    tahun_id character varying(4),
    kelompok_id uuid,
    anggota_kelompok_id uuid,
    peserta_didik_id uuid,
    link_download character varying(150),
    publish character varying(1) DEFAULT 0
);


ALTER TABLE tambah.tabel_nilai_pkl OWNER TO raporsp_user;

--
-- TOC entry 320 (class 1259 OID 16965)
-- Name: tabel_nilai_rapor; Type: TABLE; Schema: tambah; Owner: raporsp_user
--

CREATE TABLE tambah.tabel_nilai_rapor (
    id_data uuid NOT NULL,
    anggota_rombel_id uuid,
    semester_id character varying(5),
    semester numeric(1,0),
    peserta_didik_id uuid,
    link_download character varying(150),
    publish character varying(1) DEFAULT 0
);


ALTER TABLE tambah.tabel_nilai_rapor OWNER TO raporsp_user;

--
-- TOC entry 321 (class 1259 OID 16969)
-- Name: tabel_nilai_rapor_pts; Type: TABLE; Schema: tambah; Owner: raporsp_user
--

CREATE TABLE tambah.tabel_nilai_rapor_pts (
    id_data uuid NOT NULL,
    anggota_rombel_id uuid,
    semester_id character varying(5),
    semester numeric(1,0),
    peserta_didik_id uuid,
    link_download character varying(150),
    publish character varying(1) DEFAULT 0
);


ALTER TABLE tambah.tabel_nilai_rapor_pts OWNER TO raporsp_user;

--
-- TOC entry 322 (class 1259 OID 16973)
-- Name: tabel_nilai_skl; Type: TABLE; Schema: tambah; Owner: raporsp_user
--

CREATE TABLE tambah.tabel_nilai_skl (
    id_data uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    anggota_rombel_id uuid,
    semester_id character varying(5),
    rombongan_belajar_id uuid,
    peserta_didik_id uuid,
    link_download character varying(150),
    publish character varying(1) DEFAULT 0
);


ALTER TABLE tambah.tabel_nilai_skl OWNER TO raporsp_user;

--
-- TOC entry 323 (class 1259 OID 16978)
-- Name: tabel_nilai_tengah; Type: TABLE; Schema: tambah; Owner: raporsp_user
--

CREATE TABLE tambah.tabel_nilai_tengah (
    id_data uuid NOT NULL,
    anggota_rombel_id uuid,
    semester_id character varying(5),
    semester numeric(1,0),
    peserta_didik_id uuid,
    link_download character varying(150),
    publish character varying(1) DEFAULT 0
);


ALTER TABLE tambah.tabel_nilai_tengah OWNER TO raporsp_user;

--
-- TOC entry 324 (class 1259 OID 16982)
-- Name: tabel_nilaiprojek; Type: TABLE; Schema: tambah; Owner: raporsp_user
--

CREATE TABLE tambah.tabel_nilaiprojek (
    id_data uuid NOT NULL,
    tahun_ajaran character varying(4),
    semester numeric(1,0),
    peserta_didik_id uuid,
    link_download character varying(150),
    publish character varying(1) DEFAULT 0
);


ALTER TABLE tambah.tabel_nilaiprojek OWNER TO raporsp_user;

--
-- TOC entry 325 (class 1259 OID 16986)
-- Name: tabel_nilaiukk; Type: TABLE; Schema: tambah; Owner: raporsp_user
--

CREATE TABLE tambah.tabel_nilaiukk (
    id_data uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    anggota_rombel_id uuid,
    semester_id character varying(5),
    rombongan_belajar_id uuid,
    peserta_didik_id uuid,
    link_download character varying(150),
    publish character varying(1) DEFAULT 0
);


ALTER TABLE tambah.tabel_nilaiukk OWNER TO raporsp_user;

--
-- TOC entry 326 (class 1259 OID 16991)
-- Name: tabel_pelengkap; Type: TABLE; Schema: tambah; Owner: raporsp_user
--

CREATE TABLE tambah.tabel_pelengkap (
    id_data uuid NOT NULL,
    anggota_rombel_id uuid,
    semester_id character varying(5),
    semester numeric(1,0),
    peserta_didik_id uuid,
    link_download character varying(150),
    publish character varying(1) DEFAULT 0
);


ALTER TABLE tambah.tabel_pelengkap OWNER TO raporsp_user;

--
-- TOC entry 327 (class 1259 OID 16995)
-- Name: tabel_sertifikat; Type: TABLE; Schema: tambah; Owner: raporsp_user
--

CREATE TABLE tambah.tabel_sertifikat (
    id_data uuid NOT NULL,
    anggota_rombel_id uuid,
    semester_id character varying(5),
    semester numeric(1,0),
    peserta_didik_id uuid,
    link_download character varying(150),
    publish character varying(1) DEFAULT 0
);


ALTER TABLE tambah.tabel_sertifikat OWNER TO raporsp_user;

--
-- TOC entry 328 (class 1259 OID 16999)
-- Name: tabel_skillpass; Type: TABLE; Schema: tambah; Owner: raporsp_user
--

CREATE TABLE tambah.tabel_skillpass (
    id_data uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    anggota_rombel_id uuid,
    semester_id character varying(5),
    rombongan_belajar_id uuid,
    peserta_didik_id uuid,
    link_download character varying(150),
    publish character varying(1) DEFAULT 0
);


ALTER TABLE tambah.tabel_skillpass OWNER TO raporsp_user;

--
-- TOC entry 329 (class 1259 OID 17004)
-- Name: tabel_transkrip; Type: TABLE; Schema: tambah; Owner: raporsp_user
--

CREATE TABLE tambah.tabel_transkrip (
    id_data uuid NOT NULL,
    anggota_rombel_id uuid,
    semester_id character varying(5),
    semester numeric(1,0),
    peserta_didik_id uuid,
    link_download character varying(150),
    publish character varying(1) DEFAULT 0
);


ALTER TABLE tambah.tabel_transkrip OWNER TO raporsp_user;

--
-- TOC entry 330 (class 1259 OID 17008)
-- Name: tabel_transkrip_nilai; Type: TABLE; Schema: tambah; Owner: raporsp_user
--

CREATE TABLE tambah.tabel_transkrip_nilai (
    id_data uuid NOT NULL,
    anggota_rombel_id uuid,
    semester_id character varying(5),
    semester numeric(1,0),
    peserta_didik_id uuid,
    link_download character varying(150),
    publish character varying(1) DEFAULT 0
);


ALTER TABLE tambah.tabel_transkrip_nilai OWNER TO raporsp_user;

--
-- TOC entry 331 (class 1259 OID 17012)
-- Name: tbl_kehadiran_ext; Type: TABLE; Schema: tambah; Owner: raporsp_user
--

CREATE TABLE tambah.tbl_kehadiran_ext (
    id_data integer NOT NULL,
    peserta_didik_id uuid NOT NULL,
    nis character varying(20),
    nisn character varying(13),
    nm_siswa character varying(100),
    semester_id character varying(5),
    sakit numeric(3,0),
    izin numeric(3,0),
    tanpa_keterangan numeric(3,0),
    catatan_walas text
);


ALTER TABLE tambah.tbl_kehadiran_ext OWNER TO raporsp_user;

--
-- TOC entry 332 (class 1259 OID 17017)
-- Name: tbl_nilai_ext; Type: TABLE; Schema: tambah; Owner: raporsp_user
--

CREATE TABLE tambah.tbl_nilai_ext (
    id_data integer NOT NULL,
    peserta_didik_id uuid NOT NULL,
    nis character varying(20),
    nisn character varying(13),
    nm_siswa character varying(100),
    mata_pelajaran_id integer,
    semester_id character varying(5),
    nilai_rapor numeric(5,0),
    deskripsi_rapor_max text,
    deskripsi_rapor_min text
);


ALTER TABLE tambah.tbl_nilai_ext OWNER TO raporsp_user;

--
-- TOC entry 333 (class 1259 OID 17022)
-- Name: tbl_nilaiekskul_ext; Type: TABLE; Schema: tambah; Owner: raporsp_user
--

CREATE TABLE tambah.tbl_nilaiekskul_ext (
    id_data integer NOT NULL,
    peserta_didik_id uuid NOT NULL,
    nis character varying(20),
    nisn character varying(13),
    nm_siswa character varying(100),
    semester_id character varying(5),
    klp_eksdapo integer,
    nm_ekskul character varying(100),
    id_kelas_ekskul uuid,
    nilai_ekskul character varying(3),
    deskripsi_nilai text
);


ALTER TABLE tambah.tbl_nilaiekskul_ext OWNER TO raporsp_user;

--
-- TOC entry 334 (class 1259 OID 17027)
-- Name: tbl_nilaip3_k13; Type: TABLE; Schema: tambah; Owner: raporsp_user
--

CREATE TABLE tambah.tbl_nilaip3_k13 (
    id_data integer NOT NULL,
    peserta_didik_id uuid NOT NULL,
    nis character varying(20),
    nisn character varying(13),
    nm_siswa character varying(100),
    semester_id character varying(5),
    dimensi_ke1 text,
    dimensi_ke2 text,
    dimensi_ke3 text,
    dimensi_ke4 text,
    dimensi_ke5 text,
    dimensi_ke6 text
);


ALTER TABLE tambah.tbl_nilaip3_k13 OWNER TO raporsp_user;

--
-- TOC entry 335 (class 1259 OID 17032)
-- Name: ttd_ptk; Type: TABLE; Schema: tambah; Owner: raporsp_user
--

CREATE TABLE tambah.ttd_ptk (
    ptk_id uuid DEFAULT tambah.uuid_generate_v4() NOT NULL,
    file_ttd character varying(100),
    nama_ttd character varying(100)
);


ALTER TABLE tambah.ttd_ptk OWNER TO raporsp_user;

--
-- TOC entry 4080 (class 0 OID 16450)
-- Dependencies: 218
-- Data for Name: data_sync; Type: TABLE DATA; Schema: nilai; Owner: raporsp_user
--

COPY nilai.data_sync (sync_id, semester_id, tabel_sync, start_sync, last_sync) FROM stdin;
\.


--
-- TOC entry 4081 (class 0 OID 16456)
-- Dependencies: 219
-- Data for Name: matev_rapor; Type: TABLE DATA; Schema: nilai; Owner: raporsp_user
--

COPY nilai.matev_rapor (id_evaluasi, nm_mata_evaluasi, a_dari_template, no_urut, kkm_kognitif, kkm_psikomotorik, rombongan_belajar_id, mata_pelajaran_id, pembelajaran_id, create_date, last_update, soft_delete, last_sync, updater_id, semester_id, semester, a_dari_template_str) FROM stdin;
\.


--
-- TOC entry 4082 (class 0 OID 16465)
-- Dependencies: 220
-- Data for Name: nilai_ekskul; Type: TABLE DATA; Schema: nilai; Owner: raporsp_user
--

COPY nilai.nilai_ekskul (id_nilai_x, id_kelas_ekskul, anggota_rombel_id, nilai_angka, nilai_huruf, ket, a_beku, rapor_ke, create_date, last_update, soft_delete, last_sync, updater_id, semester_id, semester) FROM stdin;
\.


--
-- TOC entry 4083 (class 0 OID 16474)
-- Dependencies: 221
-- Data for Name: nilai_rapor; Type: TABLE DATA; Schema: nilai; Owner: raporsp_user
--

COPY nilai.nilai_rapor (nilai_id, id_evaluasi, anggota_rombel_id, nilai_kognitif_angka, nilai_kognitif_huruf, ket_kognitif, nilai_psim_angka, nilai_psim_huruf, ket_psim, nilai_afektif_angka, nilai_afektif_huruf, ket_afektif, nilai_afektif2_angka, nilai_afektif2_huruf, ket_afektif2, a_beku, rapor_ke, create_date, last_update, soft_delete, last_sync, updater_id, semester_id, semester) FROM stdin;
\.


--
-- TOC entry 4084 (class 0 OID 16485)
-- Dependencies: 222
-- Data for Name: nilai_smt; Type: TABLE DATA; Schema: nilai; Owner: raporsp_user
--

COPY nilai.nilai_smt (anggota_rombel_id, nilai_afektif_angka, nilai_afektif_huruf, ket_afektif, nilai_afektif2_angka, nilai_afektif2_huruf, ket_afektif2, a_beku, rapor_ke, create_date, last_update, soft_delete, last_sync, updater_id, semester_id, semester) FROM stdin;
\.


--
-- TOC entry 4085 (class 0 OID 16495)
-- Dependencies: 223
-- Data for Name: pengguna; Type: TABLE DATA; Schema: nilai; Owner: raporsp_user
--

COPY nilai.pengguna (pengguna_id, sekolah_id, username, nama, peran_id_str) FROM stdin;
\.


--
-- TOC entry 4086 (class 0 OID 16498)
-- Dependencies: 224
-- Data for Name: temp_nilai_rapor; Type: TABLE DATA; Schema: nilai; Owner: raporsp_user
--

COPY nilai.temp_nilai_rapor (nilai_id, id_evaluasi, anggota_rombel_id, nilai_kognitif_angka, nilai_kognitif_huruf, ket_kognitif, nilai_psim_angka, nilai_psim_huruf, ket_psim, nilai_afektif_angka, nilai_afektif_huruf, ket_afektif, nilai_afektif2_angka, nilai_afektif2_huruf, ket_afektif2, a_beku, rapor_ke, create_date, last_update, soft_delete, last_sync, updater_id, semester_id, semester, pembelajaran_id) FROM stdin;
\.


--
-- TOC entry 4087 (class 0 OID 16512)
-- Dependencies: 225
-- Data for Name: un; Type: TABLE DATA; Schema: nilai; Owner: raporsp_user
--

COPY nilai.un (un_id, registrasi_id, tahun_ajaran_id, un_tgl_daftar, nomor_un, no_skhun, nilai_1, nilai_2, nilai_3, nilai_4, nilai_5, nilai_6, nilai_7, template_id, create_date, last_update, soft_delete, last_sync, updater_id) FROM stdin;
\.


--
-- TOC entry 4088 (class 0 OID 16518)
-- Dependencies: 226
-- Data for Name: tabel_anggotakelompok; Type: TABLE DATA; Schema: pkl; Owner: raporsp_user
--

COPY pkl.tabel_anggotakelompok (anggota_kelompok_id, peserta_didik_id, kelompok_id, rombongan_belajar_id, tahun_id) FROM stdin;
\.


--
-- TOC entry 4089 (class 0 OID 16522)
-- Dependencies: 227
-- Data for Name: tabel_capaian_pkl; Type: TABLE DATA; Schema: pkl; Owner: raporsp_user
--

COPY pkl.tabel_capaian_pkl (id_capaian, sekolah_id, tahun_id, anggota_kelompok_id, peserta_didik_id, kelompok_id, id_tp, ketercapaian, keterangan, id_rencana_pkl) FROM stdin;
\.


--
-- TOC entry 4090 (class 0 OID 16529)
-- Dependencies: 228
-- Data for Name: tabel_elemenpkl; Type: TABLE DATA; Schema: pkl; Owner: raporsp_user
--

COPY pkl.tabel_elemenpkl (elemen_id, kd_elemen, elemen_tp, jenjang, status, no_urut) FROM stdin;
1f4504d2-856e-4afe-a184-8efd0532700d	TP 01	Internalisasi dan Penerapan Soft Skills	SMK	1	1
e5783495-e089-4943-92a5-1bef21f6417f	TP 02	Penerapan Hard Skills	SMK	1	2
bc65379b-08fb-4bbb-9dda-394b0e24989f	TP 02	Peningkatan dan Pengembangan Hard Skills	SMK	1	3
328a3425-606e-4c4b-8a5d-822c1c3cab2b	TP 02	Penyiapan Kemandirian Berwirausaha	SMK	1	4
\.


--
-- TOC entry 4091 (class 0 OID 16536)
-- Dependencies: 229
-- Data for Name: tabel_indikatortp; Type: TABLE DATA; Schema: pkl; Owner: raporsp_user
--

COPY pkl.tabel_indikatortp (id_indikator, id_tp, no_urut, indikator, status) FROM stdin;
\.


--
-- TOC entry 4092 (class 0 OID 16543)
-- Dependencies: 230
-- Data for Name: tabel_kelompok; Type: TABLE DATA; Schema: pkl; Owner: raporsp_user
--

COPY pkl.tabel_kelompok (kelompok_id, sekolah_id, tahun_id, pembimbing_id, nm_kelompok, prodi, konsentrasi, tingkat_pendidikan_id, status, asesor_id, kurikulum_id) FROM stdin;
\.


--
-- TOC entry 4093 (class 0 OID 16548)
-- Dependencies: 231
-- Data for Name: tabel_nilai_pkl; Type: TABLE DATA; Schema: pkl; Owner: raporsp_user
--

COPY pkl.tabel_nilai_pkl (id_nilai_pkl, sekolah_id, tahun_id, anggota_kelompok_id, peserta_didik_id, kelompok_id, id_tp, skor, deskripsi, id_rencana_pkl) FROM stdin;
\.


--
-- TOC entry 4094 (class 0 OID 16555)
-- Dependencies: 232
-- Data for Name: tabel_pelengkap_pkl; Type: TABLE DATA; Schema: pkl; Owner: raporsp_user
--

COPY pkl.tabel_pelengkap_pkl (id_lengkap_pkl, sekolah_id, tahun_id, anggota_kelompok_id, peserta_didik_id, kelompok_id, catatan, sakit, izin, tanpa_keterangan, id_rencana_pkl) FROM stdin;
\.


--
-- TOC entry 4095 (class 0 OID 16562)
-- Dependencies: 233
-- Data for Name: tabel_rencana_pkl; Type: TABLE DATA; Schema: pkl; Owner: raporsp_user
--

COPY pkl.tabel_rencana_pkl (id_rencana_pkl, sekolah_id, tahun_id, kelompok_id, asesor_id, tempat_pkl, tgl_pkl_mulai, tgl_pkl_selesai, rencana_ke, pembimbing_dudi, pekerjaan, sk_penugasan) FROM stdin;
\.


--
-- TOC entry 4096 (class 0 OID 16568)
-- Dependencies: 234
-- Data for Name: tabel_tp_elemen; Type: TABLE DATA; Schema: pkl; Owner: raporsp_user
--

COPY pkl.tabel_tp_elemen (id_tp, sekolah_id, kurikulum_id, elemen_id, no_urut, tujuan, status) FROM stdin;
\.


--
-- TOC entry 4097 (class 0 OID 16575)
-- Dependencies: 235
-- Data for Name: nilai_catatanprojek; Type: TABLE DATA; Schema: projec; Owner: raporsp_user
--

COPY projec.nilai_catatanprojek (id_nilcatprojec, anggota_kelompok_id, peserta_didik_id, th_ajaran, fase, id_project, deskripsi, kelompok_id) FROM stdin;
\.


--
-- TOC entry 4098 (class 0 OID 16581)
-- Dependencies: 236
-- Data for Name: nilai_profil_projek; Type: TABLE DATA; Schema: projec; Owner: raporsp_user
--

COPY projec.nilai_profil_projek (id_nil_projek, kelompok_id, anggota_kelompok_id, peserta_didik_id, th_ajaran, fase, id_profil_projek, nilai, nilai_angka) FROM stdin;
\.


--
-- TOC entry 4099 (class 0 OID 16585)
-- Dependencies: 237
-- Data for Name: profil_capaian; Type: TABLE DATA; Schema: projec; Owner: raporsp_user
--

COPY projec.profil_capaian (id_capaian, id_subelemen, fase, nama_capaian) FROM stdin;
37ca081f-73ce-44a4-8d9a-2121b0aac6e5	0a7e0d5a-a3e3-4096-9873-ee23e44e040b	F	Mengajukan pertanyaan untuk menganalisis secara kritis permasalahan yang kompleks dan abstrak dengan mengutamakan kemanusiaan.
2280a399-3196-40d9-9967-9276733b5bc9	47b75deb-4ee2-4562-9591-5f229e7928d0	F	Menganalisis dan mengevaluasi penalaran yang digunakannya dalam menemukan dan mencari solusi serta mengambil keputusan.
09f8fd5c-6005-4c00-b949-bdc35e034b2b	7e756d19-6f67-4268-ad79-0c774e45c7a0	F	Menghasilkan gagasan yang beragam untuk mengekspresikan pikiran dan/atau perasaannya, menilai gagasannya, serta memikirkan segala risikonya dengan mempertimbangkan banyak perspektif seperti etika dan nilai kemanusiaan ketika gagasannya direalisasikan.
9e162499-f269-4075-b08c-63e96bf690a5	daf48d15-79f1-476d-9175-53467be2d79f	F	Mengeksplorasi dan mengekspresikan pikiran dan/atau perasaannya dalam bentuk karya dan/atau tindakan, serta mengevaluasinya dan mempertimbangkan dampak dan resikonya bagi diri dan lingkungannya.
e016ba62-dde7-4d36-974f-fe924cc22af3	0d20742f-373f-43e7-8f0a-ac55634d6168	B	Mengekspresikan pandangannya terhadap topik yang umum dan dapat mengidentifikasi sudut pandang orang lain. Mendengarkan dan membayangkan sudut pandang orang lain yang berbeda dari dirinya pada situasi di ranah sekolah, keluarga, dan lingkungan sekitar.
40f90fc6-41d0-4bd6-91a4-b8d684e45fce	bf718e44-f855-4119-a2a5-f0b18884d980	A	Memiliki rutinitas sederhana yang diatur secara mandiri dan dijalankan sehari-hari serta menjaga kesehatan dan keselamatan/keamanan diri dalam semua aktivitas kesehariannya.
af813569-4c58-4bf2-9c93-53890e4ab8ab	a95eaf7e-0117-4504-a6f9-7cf877488d7a	B	Mengetahui adanya pengaruh orang lain, situasi, dan peristiwa yang terjadi terhadap emosi yang dirasakannya; serta berupaya untuk mengekspresikan emosi secara tepat dengan mempertimbangkan perasaan dan kebutuhan orang lain disekitarnya
de634a05-0082-42ad-a486-5429aa09e764	b481fab5-d71c-430b-86e4-eead673a4650	C	Memahami berbagai kualitas atau sifat-sifat Tuhan yang diutarakan dalam kitab suci agama masing-masing dan menghubungkan kualitas- kualitas positif Tuhan dengan sikap pribadinya, serta meyakini firman Tuhan sebagai kebenaran.
9e9e6758-0df7-4290-8923-8f93a6cb25fb	b6d22c6b-54c9-42c8-b852-4afa839c779e	C	Mengkonfirmasi dan mengklarifikasi stereotip dan prasangka yang dimilikinya tentang orang atau kelompok di sekitarnya untuk mendapatkan pemahaman yang lebih baik serta mengidentifikasi pengaruhnya terhadap individu dan kelompok di lingkungan sekitarnya
08659f70-229a-4b1c-8448-fbb2073a6c45	a95eaf7e-0117-4504-a6f9-7cf877488d7a	C	Memahami perbedaan emosi yang dirasakan dan dampaknya terhadap proses belajar dan interaksinya dengan orang lain; serta mencoba cara-cara yang sesuai untuk mengelola emosi agar dapat menunjang aktivitas belajar dan interaksinya dengan orang lain.
5c88007f-e47a-49ce-8836-ef472fbd7b09	712e611e-b8e2-44a2-8ec6-bb43c386fcea	D	Memahami makna dan fungsi, unsur-unsur utama agama /kepercayaan dalam konteks Indonesia, membaca kitab suci, serta memahami ajaran agama/ kepercayaan terkait hubungan sesama manusia dan alam semesta.
d6ed6893-1106-42c0-8fcf-7ed4c86cb681	ddf90b9b-3201-4154-b1d4-d568b6ca6820	D	Menjelaskan asumsi yang digunakan, menyadari kecenderungan dan konsekuensi bias pada pemikirannya, serta berusaha mempertimbangkan perspektif yang berbeda.
46ddac24-acc4-4ed6-91d5-39af219f511f	0eeef478-286e-4b18-be54-f1e22deaaa02	E	Aktif menyimak untuk memahami dan menganalisis informasi, gagasan, emosi, keterampilan dan keprihatinan yang disampaikan oleh orang lain dan kelompok menggunakan berbagai simbol dan media secara efektif, serta menggunakan berbagai strategi komunikasi untuk menyelesaikan masalah guna mencapai berbagai tujuan bersama.
f738bb16-cbfc-4ca5-8f78-0a138b13efbf	55396071-9cd9-49d3-b5e2-8c042e974f3c	F	Mengidentifikasi hal yang menjadi permasalahan bersama, memberikan alternatif solusi untuk menjembatani perbedaan dengan mengutamakan kemanusiaan.
34423c53-b93c-42b4-8b0b-a6195ad4d739	6a1fe567-19e4-493b-a408-e76a18c96b74	F	Memahami dan menghargai perasaan dan sudut pandang orang dan/atau kelompok lain.
c36d2643-dabf-4f96-8516-ee43290c8c57	4ec128dc-bb2c-49ba-a73e-36b73c8c7ddf	F	Menganalisis pengaruh keanggotaan kelompok lokal, regional, nasional, dan global terhadap pembentukan identitas, termasuk identitas dirinya. Mulai menginternalisasi identitas diri sebagai bagian dari budaya bangsa.
e14fe012-499d-42f9-960c-57bf0d069ca6	0a3cfa27-ff5f-42ba-903b-3920fe3c3045	A	Melakukan refleksi untuk mengidentifikasi kekuatan dan kelemahan, serta prestasi dirinya.
8f98de59-ee52-476c-842a-504da080c625	34bd1617-c2a4-4511-91c5-41518730adad	A	Menetapkan target belajar dan merencanakan waktu dan tindakan belajar yang akan dilakukannya.
c6ba8fa1-39e4-476f-b1cf-255f50268f46	1cdcc713-626e-40a6-8990-a209db3bed28	A	Mengidentifikasi perbedaan-perbedaan budaya yang konkrit di lingkungan sekitar
c770a75c-5550-4ff3-a0e0-e6d74933ae3c	a95eaf7e-0117-4504-a6f9-7cf877488d7a	A	Mengidentifikasi perbedaan emosi yang dirasakannya dan situasi- situasi yang menyebabkan- nya; serta mengekspresi- kan secara wajar
2449e7e2-b398-4510-9699-a9ae4446503b	8f867dd8-acfd-48af-aa5b-e28675fa1e1f	A	Berinisiatif untuk mengerjakan tugas-tugas rutin secara mandiri dibawah pengawasan dan dukungan orang dewasa
6627a197-577d-4a6d-9a2e-e6ce9709750f	fc76b41b-d4b2-437d-a597-473431a50234	A	Melaksanakan kegiatan belajar di kelas dan menyelesaikan tugas-tugas dalam waktu yang telah disepakati.
9e7d6efe-2fdf-42e6-b74a-0d7dc6289ea8	b4fc9911-56ef-4c82-8d54-0f17b98fbe95	A	Berani mencoba dan adaptif menghadapi situasi baru serta bertahan mengerjakan tugas-tugas yang disepakati hingga tuntas
8fa828bc-3956-4acc-8479-dede402e6681	478a6fbf-bfe7-45b5-8aee-800093132bf1	A	Terbiasa melaksanakan ibadah sesuai ajaran agama/kepercayaannya
58ee13b0-8b38-4028-b8ff-fdc51021b8a8	bf718e44-f855-4119-a2a5-f0b18884d980	B	Mulai membiasakan diri untuk disiplin, rapi, membersihkan dan merawat tubuh, menjaga tingkah laku dan perkataan dalam semua aktivitas kesehariannya
aa837b9a-1658-4522-bf18-cb5800d81c03	b481fab5-d71c-430b-86e4-eead673a4650	A	Mengenali sifat-sifat utama Tuhan bahwa Ia Maha Esa dan Ia adalah Sang Pencipta yang Maha Pengasih dan Maha Penyayang dan mengenali kebaikan dirinya sebagai cerminan sifat Tuhan
710bbacd-ebdd-4822-b651-7bc082b006a6	0a7e0d5a-a3e3-4096-9873-ee23e44e040b	A	Mengajukan pertanyaan untuk menjawab keingintahuannya dan untuk mengidentifikasi suatu permasalahan mengenai dirinya dan lingkungan sekitarnya.  
b78a6627-0fcf-4844-9521-7140f5020da6	893a5c93-2e80-4d98-886b-68c6dd3853c9	A	Mengidentifikasi dan mengolah informasi  dan gagasan     
9a97365e-1b7a-4efb-bc62-abe519f9c355	47b75deb-4ee2-4562-9591-5f229e7928d0	A	Melakukan penalaran konkrit dan memberikan alasan dalam menyelesaikan masalah dan mengambil keputusan
379d7d93-91ea-468b-ada8-a3a7dc7199e7	ddf90b9b-3201-4154-b1d4-d568b6ca6820	A	Menyampaikan apa yang sedang dipikirkan secara terperinci          
168abfa8-0393-4735-bdb7-28da0f45bebf	7e756d19-6f67-4268-ad79-0c774e45c7a0	A	Menggabungkan beberapa gagasan menjadi ide atau gagasan imajinatif yang bermakna untuk mengekspresikan pikiran dan/atau perasaannya.
1eefd08b-0b0e-4110-91d3-d19fb6567b02	b481fab5-d71c-430b-86e4-eead673a4650	B	Memahami sifat-sifat Tuhan utama lainnya dan mengaitkan sifat-sifat tersebut dengan konsep dirinya dan ciptaan- Nya
653f6afd-5e97-4e51-a2ab-4fba5584fe48	712e611e-b8e2-44a2-8ec6-bb43c386fcea	B	Mengenali unsur- unsur utama agama/kepercayaan (simbol-simbol keagamaan dan sejarah agama/ kepercayaan)
942b776b-ee20-4215-84ac-267e0f579e1e	478a6fbf-bfe7-45b5-8aee-800093132bf1	B	Terbiasa melaksanakan ibadah wajib sesuai tuntunan agama/kepercayaan nya
62cc360b-988d-49d5-ad7b-a3328b156da6	bce43e95-5030-4ae8-a6fb-b8d03f32051a	B	Membiasakan melakukan refleksi tentang pentingnya bersikap jujur dan berani menyampaikan kebenaran atau fakta
c285b385-1b22-4492-aaed-86ec6468d51a	6a1fe567-19e4-493b-a408-e76a18c96b74	B	Terbiasa memberikan apresiasi di lingkungan sekolah dan masyarakat
80590f3b-75b3-460a-89ce-f38d05e826bf	8119ef8c-5f73-43f7-9e02-7020bb834df6	B	Memahami keterhubungan antara satu ciptaan dengan ciptaan Tuhan yang lainnya
4f1893dd-64aa-4a1b-9352-ad081f74edaa	b89fcb3f-3e2b-4c4f-a726-26bf5a76a60b	B	Terbiasa memahami tindakan-tindakan yang ramah dan tidak ramah lingkungan serta membiasakan diri untuk berperilaku ramah lingkungan
0fb9aa08-74de-451f-94b3-225f09a99860	ac37856c-353f-453c-ba40-69a153cdfbdc	B	Mengidentifikasi hak dan tanggung jawab orang-orang di sekitarnya serta kaitannya dengan keimanan kepada Tuhan YME.
9428fb74-a373-4b87-aaf5-2e91025af465	4ec128dc-bb2c-49ba-a73e-36b73c8c7ddf	B	Mengidentifikasi dan mendeskripsikan ide-ide tentang dirinya dan berbagai macam kelompok di lingkungan sekitarnya, serta cara orang lain berperilaku dan berkomunikasi dengannya.
38ba476e-5841-4a47-a591-c07cf1fbf7c7	92e4cd49-5c96-4ced-a9c6-22d5ed14d1ca	B	Mengidentifikasi dan membandingkan praktik keseharian diri dan budayanya dengan orang lain di tempat dan waktu/era yang berbeda.
e10476ea-f597-4019-92bd-5732ee5ba85d	4c6deafc-753e-4cd7-87da-6c8d90747f86	B	Memahami bahwa kemajemukan dapat memberikan kesempatan untuk mendapatkan pengalaman dan pemahaman yang baru.
bdf61fe2-c29c-4217-9679-d5d173f36c11	2f008a79-9a19-4d7c-bb1c-88134fc4f817	B	Mendeskripsikan penggunaan kata, tulisan dan bahasa tubuh yang memiliki makna yang berbeda di lingkungan sekitarnya dan dalam suatu budaya tertentu.
9c1e70e7-ef6a-4f0b-86b5-7b375ce8b52d	ed71cad9-4fdc-427c-b6fe-38bbfb319429	B	Menyebutkan apa yang telah dipelajari tentang orang lain dari interaksinya dengan kemajemukan budaya di lingkungan sekitar.
3f5633c8-ccd0-4bb4-8a3a-bc53db0a0b90	b6d22c6b-54c9-42c8-b852-4afa839c779e	B	Mengkonfirmasi dan mengklarifikasi stereotip dan prasangka yang dimilikinya tentang orang atau kelompokdi sekitarnya untuk mendapatkan pemahaman yang lebih baik        
88f9de6d-c0bf-4232-af7c-d9be379be3fd	1cdcc713-626e-40a6-8990-a209db3bed28	B	Mengenali bahwa perbedaan budaya mempengaruhi pemahaman antarindividu.
c00294fd-3496-4178-a00d-bd89ecc3b4c1	de05089a-4b99-409e-bd93-3762a3edf525	B	Mengidentifikasi cara berkontribusi terhadap lingkungan sekolah, rumah dan lingkungan sekitarnya yang inklusif, adil dan berkelanjutan          
72d24828-0326-409e-b4e3-25161b080cdc	0829a3e9-e2f2-4faf-884a-39ff3b7b5fa4	B	Berpartisipasi menentukan beberapa pilihan untuk keperluan bersama berdasarkan kriteria sederhana        
3ac69f20-68ce-4c91-b549-784a22b0d711	046256c5-e308-4030-bb19-b67495819ec7	B	Memahami konsep hak dan kewajiban, serta implikasinya terhadap perilakunya.
ffc069d0-7769-4a8d-ad68-74f96f6581c5	d3cfbf79-d348-4ff6-ab52-55e649904305	B	Menampilkan tindakan yang sesuai dengan harapan dan tujuan kelompok.         
60e1d6aa-8976-4031-a921-bd0f444502e3	d85fe979-81c0-4166-923d-a0abef963fc4	B	Menyadari bahwa setiap orang membutuhkan orang lain dalam memenuhi kebutuhannya dan perlunya saling membantu
0876fa34-aecc-4ad4-b08f-fc4955b1393a	427bc77c-6725-4502-8029-56963c67ae2c	B	Menyadari bahwa dirinya memiliki peran yang berbeda dengan orang lain/temannya, serta mengetahui konsekuensi perannya terhadap ketercapaian tujuan.
1601ca11-29c4-4897-81d5-448ace3589e3	3b3d646c-d37e-4a59-bc8e-f1d984a2d2cd	B	Peka dan mengapresiasi orang-orang di lingkungan sekitar, kemudian melakukan tindakan untuk menjaga keselarasan dalam berelasi dengan orang lain.
cad81e0a-1b8c-409e-9656-4a0512658f93	92b6a87b-007e-401d-889d-3e73ec4dc9b1	B	Memahami berbagai alasan orang lain menampilkan respon tertentu
2292acc1-4bb2-412d-be69-ed2b6e7b02f6	3a402764-0f3c-4cf5-be41-1c94fe7d05de	B	Memberi dan menerima hal yang dianggap penting dan berharga kepada/dari orang-orang di lingkungan sekitar baik yang dikenal maupun tidak dikenal.
15e87cc3-8e7c-4c8a-80cd-117ccbb18bf2	970d6997-34b2-4b40-8a92-8444f8f71621	B	Mengidentifikasi kemampuan, prestasi, dan ketertarikannya serta tantangan yang dihadapi berdasarkan kejadian-kejadian yang dialaminya dalam kehidupan sehari-hari.
68bc242e-36bb-4a8f-9d8f-01e1cede738e	bce43e95-5030-4ae8-a6fb-b8d03f32051a	A	Membiasakan bersikap jujur terhadap diri sendiri dan orang lain dan berani menyampaikan kebenaran atau fakta
d534dbf9-4826-4064-8c86-498c6a1db600	55396071-9cd9-49d3-b5e2-8c042e974f3c	A	Mengenali hal-hal yang sama dan berbeda yang dimiliki diri dan temannya dalam berbagai hal, serta memberikan respon secara positif.
438b4129-21dd-4101-9b22-59421418f1ba	712e611e-b8e2-44a2-8ec6-bb43c386fcea	A	Mengenali unsur-unsur utama agama/kepercayaan (ajaran, ritual keagamaan, kitab suci, dan orang suci/ utusan Tuhan YME).
a0837a21-7a2d-4464-891c-ab93bb1bb791	bce43e95-5030-4ae8-a6fb-b8d03f32051a	C	Berani dan konsisten menyampaikan kebenaran atau fakta serta memahami konsekuensi- konsekuensinya untuk diri sendiri
de938c05-12f3-44c6-9807-869df9a7eca1	6a1fe567-19e4-493b-a408-e76a18c96b74	A	Mengidentifikasi emosi, minat dan kebutuhan orang- orang terdekat dan meresponnya secara positif.
10174c80-39eb-4bfd-adfd-33e98b99e5c2	ac37856c-353f-453c-ba40-69a153cdfbdc	A	Mengidentifikasi hak dan tanggung jawabnya di rumah, sekolah, dan lingkungan sekitar serta kaitannya dengan keimanan kepada Tuhan YME.
b7a81b2e-7dc3-44fe-b648-71e76855b713	4ec128dc-bb2c-49ba-a73e-36b73c8c7ddf	A	Mengidentifikasi dan mendeskripsikan ide-ide tentang dirinya dan beberapa macam kelompok di lingkungan sekitarnya
4b02a36e-18e6-4c21-862d-ffb03d85f5d8	92e4cd49-5c96-4ced-a9c6-22d5ed14d1ca	A	Mengidentifikasi dan mendeskripsikan praktik keseharian diri dan budayanya    
1b263cdb-24a9-4a68-b495-c7f9aa64b303	4c6deafc-753e-4cd7-87da-6c8d90747f86	A	Mendeskripsikan pengalaman dan pemahaman hidup bersama-sama dalam kemajemukan.
b2cc59d0-baf6-4ae8-9147-4ab672bcafce	2f008a79-9a19-4d7c-bb1c-88134fc4f817	A	Mengenali bahwa diri dan orang lain menggunakan kata, gambar, dan bahasa tubuh yang dapat memiliki makna yang berbeda di lingkungan sekitarnya
58ba460f-49c0-4a84-a9e8-114321b71ac4	0d20742f-373f-43e7-8f0a-ac55634d6168	A	Mengekspresikan pandangannya terhadap topik yang umum dan mendengarkan sudut pandang orang lain yang berbeda dari dirinya dalam lingkungan keluarga dan sekolah
b2e1d9f6-cfd5-4ff5-a5db-06b970cb5099	ed71cad9-4fdc-427c-b6fe-38bbfb319429	A	Menyebutkan apa yang telah dipelajari tentang orang lain dari interaksinya dengan kemajemukan budaya di lingkungan sekolah dan rumah
376e1bbd-4f65-4062-88ae-4a0083841f44	b6d22c6b-54c9-42c8-b852-4afa839c779e	A	mengenali perbedaan tiap orang atau kelompok dan menganggapnya sebagai kewajaran
32115b29-f788-4b8f-adb4-7e19395dcd8a	de05089a-4b99-409e-bd93-3762a3edf525	A	Menjalin pertemanan tanpa memandang perbedaan agama, suku, ras, jenis kelamin, dan perbedaan lainnya, dan mengenal masalah- masalah sosial, ekonomi, dan lingkungan di lingkungan sekitarnya
df01f65a-89a4-4a32-80b4-b6736f5aed8d	d3cfbf79-d348-4ff6-ab52-55e649904305	A	Menerima dan melaksanakan tugas serta peran yang diberikan kelompok dalam sebuah kegiatan bersama.
a3522978-3639-4cc1-84b5-59686ba39518	d85fe979-81c0-4166-923d-a0abef963fc4	A	Mengenali kebutuhan- kebutuhan diri sendiri yang memerlukan orang lain dalam pemenuhannya.
e9394a6e-28e3-4b05-ac37-106bf81ca869	427bc77c-6725-4502-8029-56963c67ae2c	A	Melaksanakan aktivitas kelompok sesuai dengan kesepakatan bersama dengan bimbingan,  dan saling mengingatkan adanya kesepakatan tersebut.
552bab6b-8c6a-44e9-b417-98254e6ea1e7	3b3d646c-d37e-4a59-bc8e-f1d984a2d2cd	A	Peka dan mengapresiasi  orang- orang di lingkungan sekitar, kemudian melakukan tindakan sederhana untuk mengungkapkannya.
aa7048d1-0afd-4aa0-960f-cbc8c892ae24	92b6a87b-007e-401d-889d-3e73ec4dc9b1	A	Mengenali berbagai reaksi orang lain di lingkungan sekitar dan penyebabnya.
10a94e8d-ae2a-4539-a953-244b596ac3cf	3a402764-0f3c-4cf5-be41-1c94fe7d05de	A	Memberi dan menerima hal yang dianggap berharga dan penting kepada/dari orang-orang di lingkungan sekitar.
0df9c8d7-c702-4ca7-8eb9-864a0baf42dc	970d6997-34b2-4b40-8a92-8444f8f71621	A	Mengidentifikasi dan menggambarkan kemampuan, prestasi, dan ketertarikannya secara subjektif       
45b9bce8-fbd9-4c69-993d-2fe5d0eb402c	34bd1617-c2a4-4511-91c5-41518730adad	B	Menjelaskan pentingnya memiliki tujuan dan berkomitmen dalam mencapainya serta mengeksplorasi langkah-langkah yang sesuai untuk mencapainya
b6a57648-5cb2-4587-8dff-3c5b8d95388b	8f867dd8-acfd-48af-aa5b-e28675fa1e1f	B	Mempertimbangka n, memilih dan mengadopsi berbagai strategi dan mengidentifikasi sumber bantuan yang diperlukan serta berinisiatif menjalankannya untuk mendapatkan hasil belajar yang diinginkan.
d4abaf61-b631-4871-982c-d265df5ee463	fc76b41b-d4b2-437d-a597-473431a50234	B	Menjelaskan pentingnya mengatur diri secara mandiri dan mulai menjalankan kegiatan dan tugas yang telah sepakati secara mandiri
ae36c144-2ff7-4a7e-b887-4a969f028917	b4fc9911-56ef-4c82-8d54-0f17b98fbe95	B	Tetap bertahan mengerjakan tugas ketika dihadapkan dengan tantangan dan berusaha menyesuaikan strateginya ketika upaya sebelumnya tidak berhasil.
4c0759e9-4183-45d9-8871-37de4cab0c7b	0a7e0d5a-a3e3-4096-9873-ee23e44e040b	B	Mengajukan pertanyaan untuk mengidentifikasi suatu permasalahan dan mengkonfirmasi pemahaman terhadap suatu permasalahan mengenai dirinya dan lingkungan sekitarnya.
2c1250ad-33d9-4049-9213-f79448580782	893a5c93-2e80-4d98-886b-68c6dd3853c9	B	Mengumpulkan, mengklasifikasikan, membandingkan dan memilih informasi dan gagasan dari berbagai sumber.
a33974f3-88fa-4d5a-8dd7-bdefcf94069c	47b75deb-4ee2-4562-9591-5f229e7928d0	B	Menjelaskan alasan yang relevan dalam penyelesaian masalah dan pengambilan keputusan
84b1ccd0-6f14-4995-b972-e183fa611328	ddf90b9b-3201-4154-b1d4-d568b6ca6820	B	Menyampaikan apa yang sedang dipikirkan dan menjelaskan alasan dari hal yang dipikirkan
01b8f599-825d-4cc7-9b0f-6c525acb3ad5	7e756d19-6f67-4268-ad79-0c774e45c7a0	B	Memunculkan gagasan imajinatif baru yang bermakna dari beberapa gagasan yang berbeda sebagai ekspresi pikiran dan/atau perasaannya.
776ff4a4-f423-4e4e-be0e-c7ff2b413fd9	daf48d15-79f1-476d-9175-53467be2d79f	B	Mengeksplorasi dan mengekspresikan pikiran dan/atau perasaannya sesuai dengan minat dan kesukaannya dalam bentuk karya dan/atau tindakan serta mengapresiasi karya dan tindakan yang dihasilkan
edc8c88b-5253-46c0-b05b-bf5cd92be4e3	3063aa35-60fb-49b4-a071-7ae10b9de043	B	Membandingkan gagasan-gagasan kreatif untuk menghadapi situasi dan permasalahan.       
cb618d8e-dc54-4f57-90c2-e2a6a3a27db4	712e611e-b8e2-44a2-8ec6-bb43c386fcea	C	Memahami unsur-unsur utama agama/kepercayaan, dan mengenali peran agama/kepercayaan dalam kehidupan serta memahami ajaran moral agama.
ea1768cc-b1e4-4817-a6d1-66138c572733	bf718e44-f855-4119-a2a5-f0b18884d980	C	Memperhatikan kesehatan jasmani, mental, dan rohani dengan melakukan aktivitas fisik, sosial, dan ibadah.
0aabe150-6de8-4844-bad2-3570f4f8c357	8119ef8c-5f73-43f7-9e02-7020bb834df6	A	Mengidentifikasi berbagai ciptaan Tuhan
88692e49-9a9e-4a4e-a31b-dd03795220bb	b89fcb3f-3e2b-4c4f-a726-26bf5a76a60b	A	Membiasakan bersyukur atas lingkungan alam sekitar dan berlatih untuk menjaganya
32bee08e-2c33-4c4c-a468-72803b0c5c82	478a6fbf-bfe7-45b5-8aee-800093132bf1	C	Melaksanakan ibadah secara rutin sesuai dengan tuntunan agama/kepercayaan, berdoa mandiri, merayakan, dan memahami makna hari- hari besarnya
cd69a299-f1ec-448d-aef8-72ffbef5cda8	3063aa35-60fb-49b4-a071-7ae10b9de043	C	berupaya mencari solusi alternatif saat pendekatan yang diambil tidak berhasil berdasarkan identifikasi terhadap situasi
b221b5e8-ffa6-4e77-9f9c-f0926dcbbb0c	6a1fe567-19e4-493b-a408-e76a18c96b74	C	Mulai memandang sesuatu dari perspektif orang lain serta mengidentifikasi kebaikan dan kelebihan orang sekitarnya.
785fec84-c329-4cfb-886e-e6bff5db90ad	92e4cd49-5c96-4ced-a9c6-22d5ed14d1ca	C	Mendeskripsikan dan membandingkan pengetahuan, kepercayaan, dan praktik dari berbagai kelompok budaya.
c98e3938-5e32-4e3b-a95b-cc7c5eabb51d	4c6deafc-753e-4cd7-87da-6c8d90747f86	C	Mengidentifikasi peluang dan tantangan yang muncul dari keragaman budaya di Indonesia.
9cefa1d6-2147-4d00-88a2-f88933a9d886	2f008a79-9a19-4d7c-bb1c-88134fc4f817	C	Memahami persamaan dan perbedaan cara komunikasi baik di dalam maupun antar kelompok budaya.
4f59c421-1fe6-4515-b09b-1131886fe396	0d20742f-373f-43e7-8f0a-ac55634d6168	C	Membandingkan beragam perspektif untuk memahami permasalahan sehari- hari. Membayangkan dan mendeskripsikan situasi komunitas yang berbeda dengan dirinya ke dalam situasi dirinya dalam konteks lokal dan regional.
671da6f6-5684-4fc7-ac17-0fb25f08d53c	ed71cad9-4fdc-427c-b6fe-38bbfb319429	C	Menjelaskan apa yang telah dipelajari dari interaksi dan pengalaman dirinya dalam lingkungan yang beragam.
583c3a76-0b21-499f-a628-7fcddd48d5ad	1cdcc713-626e-40a6-8990-a209db3bed28	C	Mencari titik temu nilai budaya yang beragam untuk menyelesaikan permasalahan bersama.
d73dc820-91b2-4b83-aaaf-4f52464f5e69	de05089a-4b99-409e-bd93-3762a3edf525	C	Membandingkan beberapa tindakan dan praktik perbaikan lingkungan sekolah yang inklusif, adil, dan berkelanjutan, dengan mempertimbangkan dampaknya secara jangka panjang terhadap manusia, alam, dan masyarakat
8bf7c536-98d0-4991-b334-821824a48767	0829a3e9-e2f2-4faf-884a-39ff3b7b5fa4	C	Berpartisipasi dalam menentukan kriteria yang disepakati bersama untuk menentukan pilihan dan keputusan untuk kepentingan bersama
10e1fd54-5d7c-44cb-82d2-d8c9b0f4bac8	046256c5-e308-4030-bb19-b67495819ec7	C	Memahami konsep hak dan kewajiban, serta implikasinya terhadap perilakunya. Menggunakan konsep ini untuk menjelaskan perilaku diri dan orang sekitarnya
df1e4fde-b8ae-4b64-8c7d-9719f468bc9c	d3cfbf79-d348-4ff6-ab52-55e649904305	C	Menunjukkan ekspektasi (harapan) positif kepada orang lain dalam rangka mencapai tujuan kelompok di lingkungan sekitar (sekolah dan rumah).
7a300111-4725-404d-94b4-c4396e05b317	0eeef478-286e-4b18-be54-f1e22deaaa02	C	Memahami informasi dari berbagai sumber dan menyampaikan pesan menggunakan berbagai simbol dan media secara efektif kepada orang lain untuk mencapai tujuan bersama       
5e0afe0c-932c-4268-86d4-d870828412bc	d85fe979-81c0-4166-923d-a0abef963fc4	C	Menyadari bahwa meskipun setiap orang memiliki otonominya masing-masing, setiap orang membutuhkan orang lain dalam memenuhi kebutuhannya.
682a72e9-48e4-43ef-84af-e2bb02e165a8	92b6a87b-007e-401d-889d-3e73ec4dc9b1	C	Menerapkan pengetahuan mengenai berbagai reaksi orang lain dan penyebabnya dalam konteks keluarga, sekolah, serta pertemanan dengan sebaya.
f54a74b2-6466-4fdc-a10e-13a87f46303e	0a3cfa27-ff5f-42ba-903b-3920fe3c3045	C	Melakukan refleksi untuk mengidentifikasi faktor-faktor di dalam maupun di luar dirinya yang dapat mendukung/mengham batnya dalam belajar dan mengembangkan diri; serta mengidentifikasi cara- cara untuk mengatasi kekurangannya.
8903831b-8f0c-4d44-8476-c3c2067bfb25	34bd1617-c2a4-4511-91c5-41518730adad	C	Menilai faktor-faktor (kekuatan dan kelemahan) yang ada pada dirinya dalam upaya mencapai tujuan belajar, prestasi, dan pengembangan dirinya serta mencoba berbagai strategi untuk mencapainya.
5c2c9cab-d809-47ba-9c39-c9255c321268	8f867dd8-acfd-48af-aa5b-e28675fa1e1f	C	Memahami arti penting bekerja secara mandiri serta inisiatif untuk  melakukannya dalam menunjang pembelajaran dan pengembangan dirinya
d0eb91d9-59c1-4d2e-ad24-0884f0199149	fc76b41b-d4b2-437d-a597-473431a50234	C	Mengidentifikasi faktor-faktor yang dapat mempengaruhi kemampuan dalam mengelola diri dalam pelaksanaan aktivitas belajar dan pengembangan dirinya.
4afd80e5-f3c4-401d-8d80-20ce178e8047	b4fc9911-56ef-4c82-8d54-0f17b98fbe95	C	Menyusun, menyesuaikan, dan mengujicobakan berbagai strategi dan cara kerjanya untuk membantu dirinya dalam penyelesaian tugas yang menantang
7c59ba7d-65dd-4e90-b2e4-ac6b85c4ef95	0a7e0d5a-a3e3-4096-9873-ee23e44e040b	C	Mengajukan pertanyaan untuk membandingkan berbagai informasi dan untuk menambah pengetahuannya.
8beae205-aaf8-4630-b7b4-c01690abfdd3	893a5c93-2e80-4d98-886b-68c6dd3853c9	C	Mengumpulkan, mengklasifikasikan, membandingkan, dan memilih informasi dari berbagai sumber, serta memperjelas informasi dengan bimbingan orang dewasa.
4569ef9a-f60d-4531-be72-83d490817b21	47b75deb-4ee2-4562-9591-5f229e7928d0	C	Menjelaskan alasan yang relevan dan akurat dalam penyelesaian masalah dan pengambilan keputusan
d3a35cd0-77cb-4a15-abb4-66dda2b92921	ddf90b9b-3201-4154-b1d4-d568b6ca6820	C	Memberikan alasan dari hal yang dipikirkan, serta menyadari kemungkinan adanya bias pada pemikirannya sendiri
b4feb15d-d7af-43fa-adc0-f82c36e525d5	daf48d15-79f1-476d-9175-53467be2d79f	C	Mengeksplorasi dan mengekspresikan pikiran dan/atau perasaannya sesuai dengan minat dan kesukaannya dalam bentuk karya dan/atau tindakan serta mengapresiasi dan mengkritik karya dan tindakan yang dihasilkan
552c6f96-622d-4fc0-a34e-7c06df07c6b4	b481fab5-d71c-430b-86e4-eead673a4650	D	Memahami kehadiran Tuhan dalam kehidupan sehari-hari serta mengaitkan pemahamannya tentang kualitas atau sifat-sifat Tuhan dengan konsep peran manusia di bumi sebagai makhluk Tuhan yang bertanggung jawab.
184310ea-5696-4e2a-9e8a-a851af0ae984	8119ef8c-5f73-43f7-9e02-7020bb834df6	C	Memahami konsep harmoni dan mengidentifikasi adanya saling ketergantungan  antara berbagai ciptaan Tuhan
b174c72a-5bbf-4d87-a096-736e39f730e7	b89fcb3f-3e2b-4c4f-a726-26bf5a76a60b	C	Mewujudkan rasa syukur dengan terbiasa berperilaku  ramah lingkungan dan memahami akibat perbuatan tidak ramah lingkungan dalam lingkup kecil maupun besar.
de8cf15f-f77c-4a85-9bf2-e457ffd664f0	ac37856c-353f-453c-ba40-69a153cdfbdc	C	Mengidentifikasi dan memahami peran, hak, dan kewajiban dasar sebagai warga negara serta kaitannya dengan keimanan kepada Tuhan YME dan secara sadar mempraktikkannya dalam kehidupan sehari-hari.
62c0d57d-53ec-4b58-90ea-cba0ab20bd60	4ec128dc-bb2c-49ba-a73e-36b73c8c7ddf	C	Mengidentifikasi dan mendeskripsikan keragaman budaya di sekitarnya; serta menjelaskan peran budaya dan Bahasa dalam membentuk identitas dirinya.
f14fa74c-dded-4c82-948c-206c2449d554	7e756d19-6f67-4268-ad79-0c774e45c7a0	C	Mengembangkan gagasan yang ia miliki untuk membuat kombinasi hal yang baru dan imajinatif untuk mengekspresikan pikiran dan/atau perasaannya.
f0fefe3c-2457-4fb6-a3b7-abafe99d5dba	fc76b41b-d4b2-437d-a597-473431a50234	D	Berkomitmen dan menjaga konsistensi pencapaian tujuan yang telah direncanakannya untuk mencapai tujuan belajar dan pengembangan diri yang diharapkannya
c6d2d5d3-a03b-497d-b66b-169605b868a0	34bd1617-c2a4-4511-91c5-41518730adad	D	Merancang strategi yang sesuai untuk menunjang pencapaian tujuan belajar, prestasi, dan pengembangan diri dengan mempertimbangkan kekuatan dan kelemahan dirinya, serta situasi yang dihadapi.
8961c87c-e81b-4348-af4c-7ab7b8417d44	478a6fbf-bfe7-45b5-8aee-800093132bf1	D	Melaksanakan ibadah secara rutin dan mandiri sesuai dengan tuntunan agama/kepercayaan, serta berpartisipasi pada perayaan hari-hari besarnya
74dece2e-d136-4490-98ce-5c7d27f3c36b	8119ef8c-5f73-43f7-9e02-7020bb834df6	D	Memahami konsep sebab- akibat di antara berbagai ciptaan Tuhan dan mengidentifikasi berbagai sebab yang mempunyai dampak baik atau buruk, langsung maupun tidak langsung, terhadap alam semesta.
87681c3d-f079-42e6-80c1-7ee1325aa679	b89fcb3f-3e2b-4c4f-a726-26bf5a76a60b	D	Mewujudkan rasa syukur dengan berinisiatif untuk menyelesaikan permasalahan lingkungan alam sekitarnya dengan mengajukan alternatif solusi dan mulai menerapkan solusi tersebut.
d965401c-02b2-4604-8c67-caf9a8bc2f94	ac37856c-353f-453c-ba40-69a153cdfbdc	D	Menganalisa peran, hak, dan kewajiban sebagai warga negara, memahami perlunya mengutamakan kepentingan umum di atas kepentingan pribadi sebagai wujud dari keimanannya kepada Tuhan YME.
99604cee-8922-4dff-a9b1-7e579ae196c1	4ec128dc-bb2c-49ba-a73e-36b73c8c7ddf	D	Menjelaskan perubahan budaya seiring waktu dan sesuai konteks, baik dalam skala lokal, regional, dan nasional. Menjelaskan identitas diri yang terbentuk dari budaya bangsa.
f07e7915-e686-49a6-aae0-f749d3ca35c7	92e4cd49-5c96-4ced-a9c6-22d5ed14d1ca	D	Memahami dinamika budaya yang mencakup pemahaman, kepercayaan, dan praktik keseharian dalam konteks personal dan sosial.
7b52a810-cb64-40e0-a7ae-bb84dd3e145a	4c6deafc-753e-4cd7-87da-6c8d90747f86	D	Memahami pentingnya melestarikan dan merayakan tradisi budaya untuk mengembangkan identitas pribadi, sosial, dan bangsa Indonesia serta mulai berupaya melestarikan budaya dalam kehidupan sehari- hari.
3e16ac98-c5b2-49fa-a248-2ed28f6e767c	2f008a79-9a19-4d7c-bb1c-88134fc4f817	D	Mengeksplorasi pengaruh budaya terhadap penggunaan bahasa serta dapat mengenali risiko dalam berkomunikasi antar budaya.
ed0cf226-2578-482b-9c2a-800f5856cb42	0d20742f-373f-43e7-8f0a-ac55634d6168	D	Menjelaskan asumsi- asumsi yang mendasari perspektif tertentu. Membayangkan dan mendeskripsikan perasaan serta motivasi komunitas yang berbeda dengan dirinya yang berada dalam situasi yang sulit.
1b7c74a3-ecb3-4d0c-86ce-ac70f1453d61	ed71cad9-4fdc-427c-b6fe-38bbfb319429	D	Merefleksikan secara kritis gambaran berbagai kelompok budaya yang ditemui dan cara meresponnya.
f059902d-53e6-4a89-976d-d94067a585f4	b6d22c6b-54c9-42c8-b852-4afa839c779e	D	Mengkonfirmasi, mengklarifikasi dan menunjukkan sikapmenolak stereotip serta prasangka tentang gambaran identitas kelompok dan suku bangsa.
9811cb5c-df58-4e7a-8ac2-a4d4d7aca702	1cdcc713-626e-40a6-8990-a209db3bed28	D	Mengidentifikasi dan menyampaikan isu-isu tentang penghargaan terhadap keragaman dan kesetaraan budaya.
9dcfc5b5-59f3-4642-a0d1-bacda9ade68d	0eeef478-286e-4b18-be54-f1e22deaaa02	D	Memahami informasi, gagasan, emosi, keterampilan dan keprihatinan yang diungkapkan oleh orang lain menggunakan berbagai simbol dan media secara efektif, serta memanfaatkannya untuk meningkatkan kualitas hubungan interpersonal guna mencapai tujuan bersama.
49a8e468-f404-467b-b463-a3ec9fe13b09	d85fe979-81c0-4166-923d-a0abef963fc4	D	Mendemonstrasikan kegiatan kelompok yang menunjukkan bahwa anggota kelompok dengan kelebihan dan kekurangannya masing- masing perlu dan dapat saling membantu memenuhi kebutuhan.
f5cf5560-23a0-4d2d-9cd9-7ece49aefb6b	427bc77c-6725-4502-8029-56963c67ae2c	D	Membagi peran dan menyelaraskan tindakan dalam kelompok serta menjaga tindakan agar selaras untuk mencapai tujuan bersama.
c3a3eede-ecde-4bd7-a527-30a4a36238d5	3b3d646c-d37e-4a59-bc8e-f1d984a2d2cd	D	Tanggap terhadap lingkungan sosial sesuai dengan tuntutan peran sosialnya dan berkontribusi sesuai dengan kebutuhan masyarakat.
09032a46-db9b-4fe3-a60e-17b3a0e8eb98	92b6a87b-007e-401d-889d-3e73ec4dc9b1	D	Menggunakan pengetahuan tentang sebab dan alasan orang lain menampilkan reaksi tertentu untuk menentukan tindakan yang tepat agar orang lain menampilkan respon yang diharapkan.
2408d24a-aa40-481e-a26a-ed192208a9a8	3a402764-0f3c-4cf5-be41-1c94fe7d05de	D	Mengupayakan memberi hal yang dianggap penting dan berharga kepada masyarakat yang membutuhkan bantuan di sekitar tempat tinggal
26ccd3fc-e222-4f1f-aa57-d4110981908b	970d6997-34b2-4b40-8a92-8444f8f71621	D	Membuat penilaian yang realistis terhadap kemampuan dan minat , serta prioritas pengembangan diri berdasarkan pengalaman belajar dan aktivitas lain yang dilakukannya.
4168aabc-d471-48ea-8776-7daa40c67373	0a3cfa27-ff5f-42ba-903b-3920fe3c3045	D	Memonitor kemajuan belajar yang dicapai serta memprediksi tantangan pribadi dan akademik yang akan muncul berlandaskan pada pengalamannya untuk mempertimbangkan strategi belajar yang sesuai.
da3246c7-1e84-4265-a19c-b059d385c32f	a95eaf7e-0117-4504-a6f9-7cf877488d7a	D	Memahami dan memprediksi konsekuensi dari emosi dan pengekspresiannya dan menyusun langkah- langkah untuk mengelola emosinya dalam pelaksanaan belajar dan berinteraksi dengan orang lain.
47680d82-c790-4b0e-b423-a21e16e0bb25	b4fc9911-56ef-4c82-8d54-0f17b98fbe95	D	Membuat rencana baru dengan mengadaptasi, dan memodifikasi strategi yang sudah dibuat ketika upaya sebelumnya tidak berhasil, serta menjalankan kembali tugasnya dengan keyakinan baru.
d84a37e1-8a7c-4e62-9713-6f2527fb3853	bce43e95-5030-4ae8-a6fb-b8d03f32051a	D	Berani dan konsisten menyampaikan kebenaran atau fakta serta memahami konsekuensi- konsekuensinya untuk diri sendiri dan orang lain
25700f18-6503-4812-8fa6-782790aa24f6	bf718e44-f855-4119-a2a5-f0b18884d980	D	Mengidentifikasi pentingnya menjaga keseimbangan kesehatan jasmani, mental, dan rohani serta berupaya menyeimbangkan aktivitas fisik, sosial dan ibadah.
7b86efd1-cbf2-4e22-9890-a2fecb962e2b	55396071-9cd9-49d3-b5e2-8c042e974f3c	D	Mengenal perspektif dan emosi/perasaan dari sudut pandang orang atau kelompok lain yang tidak pernah dijumpai atau dikenalnya. Mengutamakan persamaan dan menghargai perbedaan sebagai alat pemersatu dalam keadaan konflik atau perdebatan.
32119fc3-c1c3-4e50-b2fc-a3b473bbaeb7	6a1fe567-19e4-493b-a408-e76a18c96b74	D	Memahami perasaan dan sudut pandang orang dan/atau kelompok lain yang tidak pernah dikenalnya.
9f6351c2-caa4-4542-805f-4ba64cb5d884	8f867dd8-acfd-48af-aa5b-e28675fa1e1f	D	Mengkritisi efektivitas dirinya dalam bekerja secara mandiri dengan mengidentifikasi hal-hal yang menunjang maupun menghambat dalam mencapai tujuan.
35dc3a83-9e9b-4d62-a9f6-d38164ca405f	0a7e0d5a-a3e3-4096-9873-ee23e44e040b	D	Mengajukan pertanyaan untuk klarifikasi dan interpretasi informasi, serta mencari tahu penyebab dan konsekuensi dari informasi tersebut.
ca80f534-c887-48e8-9d58-6085b582d9bc	893a5c93-2e80-4d98-886b-68c6dd3853c9	D	Mengidentifikasi, mengklarifikasi, dan menganalisis informasi yang relevan serta memprioritaskan beberapa gagasan tertentu.
af38c25d-1e58-4065-8522-cdbc8b6c4394	47b75deb-4ee2-4562-9591-5f229e7928d0	D	Membuktikan penalaran dengan berbagai argumen dalam mengambil suatu simpulan atau keputusan.
582da6fd-cfdf-4ab9-abdf-76b00810c117	7e756d19-6f67-4268-ad79-0c774e45c7a0	D	Menghubungkan gagasan yang ia miliki dengan informasi atau gagasan baru untuk menghasilkan kombinasi gagasan baru dan imajinatif untuk mengekspresikan pikiran dan/atau perasaannya.
48b9ba23-a4ce-411e-b647-adbd57c98d12	478a6fbf-bfe7-45b5-8aee-800093132bf1	E	Melaksanakan ibadah secara rutin dan mandiri serta menyadari arti penting ibadah tersebut dan berpartisipasi aktif pada kegiatan keagamaan atau kepercayaan
b3010338-87ca-44c8-b322-5834956f16b4	bce43e95-5030-4ae8-a6fb-b8d03f32051a	E	Menyadari bahwa aturan agama dan sosial merupakan aturan yang baik dan menjadi bagian dari diri sehingga bisa menerapkannya secara bijak dan kontekstual
292d209c-a0f7-4e61-9476-144975ffa2f4	bf718e44-f855-4119-a2a5-f0b18884d980	E	Melakukan aktivitas fisik, sosial, dan ibadah secara seimbang.
4fa43452-cd0e-4553-bb91-6a51537a1011	55396071-9cd9-49d3-b5e2-8c042e974f3c	E	Mengidentifikasi hal yang menjadi permasalahan bersama, memberikan alternatif solusi untuk menjembatani perbedaan dengan mengutamakan kemanusiaan.
f630b6e1-3b97-45fe-b1c5-5b6561b5515a	6a1fe567-19e4-493b-a408-e76a18c96b74	E	Memahami dan menghargai perasaan dan sudut pandang orang dan/atau kelompok lain.
ea1eab42-296d-4234-b6e8-6ed518a7edeb	8119ef8c-5f73-43f7-9e02-7020bb834df6	E	Mengidentifikasi masalah lingkungan hidup di tempat ia tinggal dan melakukan langkah- langkah konkrit yang bisa dilakukan untuk menghindari kerusakan dan menjaga keharmonisan ekosistem yang ada di lingkungannya.
2afe8ee2-bc4d-4870-99be-7dab63d3d0c6	b89fcb3f-3e2b-4c4f-a726-26bf5a76a60b	E	Mewujudkan rasa syukur dengan membangun kesadaran peduli lingkungan alam dengan menciptakan dan mengimplementasikan solusi dari permasalahan lingkungan yang ada.
30bf19f0-0b60-4df1-bb47-2a6e74c3c90b	ac37856c-353f-453c-ba40-69a153cdfbdc	E	Memperoleh hak dan melaksanakan kewajiban kewarganegaraan dan terbiasa mendahulukan kepentingan umum di atas kepentingan pribadi sebagai wujud dari keimanannya kepada Tuhan YME.
4be80e6a-9ee9-4ea2-8fad-47fab995fa36	3063aa35-60fb-49b4-a071-7ae10b9de043	E	Bereksperimen dengan berbagai pilihan secara kreatif untuk memodifikasi gagasan sesuai dengan perubahan situasi.
8528fce3-efff-41a0-9aec-6e13edb970d7	4ec128dc-bb2c-49ba-a73e-36b73c8c7ddf	E	Menganalisis pengaruh keanggotaan kelompok lokal, regional, nasional, dan global terhadap pembentukan identitas, termasuk identitas dirinya. Mulai menginternalisasi identitas diri sebagai bagian dari budaya bangsa.
c71b164e-64c9-4c80-a63e-1c615bd35a28	92e4cd49-5c96-4ced-a9c6-22d5ed14d1ca	E	Menganalisis dinamika budaya yang mencakup pemahaman, kepercayaan, dan praktik keseharian dalam rentang waktu yang panjang dan konteks yang luas.
22a9b05f-1e76-4d27-8e33-df853e10f38f	4c6deafc-753e-4cd7-87da-6c8d90747f86	E	Memahami pentingnya saling menghormati dalam mempromosikan pertukaran budaya dan kolaborasi dalam dunia yang saling terhubung serta menunjukkannya dalam perilaku.
0bde36c1-e8bc-4f65-8be3-63c19b4317b2	2f008a79-9a19-4d7c-bb1c-88134fc4f817	E	Menganalisis hubungan antara bahasa, pikiran, dan konteks untuk memahami dan meningkatkan komunikasi antar budaya yang berbeda-beda.
07d89a84-6180-4c3b-8cfd-b843866b5a26	ed71cad9-4fdc-427c-b6fe-38bbfb319429	E	Merefleksikan secara kritis dampak dari pengalaman hidup di lingkungan yang beragam terkait dengan perilaku, kepercayaan serta tindakannya terhadap orang lain.
bc8811ac-2198-414b-8c80-2caadf1de792	1cdcc713-626e-40a6-8990-a209db3bed28	E	Mengetahui tantangan dan keuntungan hidup dalam lingkungan dengan budaya yang beragam, serta memahami pentingnya kerukunan antar budaya dalam kehidupan bersama yang harmonis.
462c91a9-8fd6-4690-962a-631026b3f084	0829a3e9-e2f2-4faf-884a-39ff3b7b5fa4	E	Berpartisipasi menentukan pilihan dan keputusan untuk kepentingan bersama melalui proses bertukar pikiran secara cermat dan terbuka secara mandiri
fd379f09-ca65-45ef-9645-a8d4f2a33d25	046256c5-e308-4030-bb19-b67495819ec7	E	Memahami konsep hak dan kewajiban, serta implikasinya terhadap ekspresi dan perilakunya. Mulai mencari solusi untuk dilema terkait konsep hak dan kewajibannya.
f1c51dc3-1d0b-48d6-9210-0abf341a66e3	d3cfbf79-d348-4ff6-ab52-55e649904305	E	Membangun tim dan mengelola kerjasama untuk mencapai tujuan bersama sesuai dengan target yang sudah ditentukan.
97657d43-de33-4f0d-bdb9-e2abaa773549	d85fe979-81c0-4166-923d-a0abef963fc4	E	Menyelaraskan kapasitas kelompok agar para anggota kelompok dapat saling membantu satu sama lain memenuhi kebutuhan mereka baik secara individual maupun kolektif.
eecc7404-d1c0-44cb-a350-8f04ea8513ce	427bc77c-6725-4502-8029-56963c67ae2c	E	Menyelaraskan dan menjaga tindakan diri dan anggota kelompok  agar sesuai antara satu dengan lainnya serta menerima konsekuensi tindakannya dalam rangka mencapai tujuan bersama.
1e45aab4-5c9d-4fbd-9817-6e24953961a3	3b3d646c-d37e-4a59-bc8e-f1d984a2d2cd	E	Tanggap terhadap lingkungan sosial sesuai dengan tuntutan peran sosialnya dan berkontribusi sesuai dengan kebutuhan masyarakat untuk menghasilkan keadaan yang lebih baik.
c78506dd-50fa-4e5a-9111-6a6db8a37d10	92b6a87b-007e-401d-889d-3e73ec4dc9b1	E	Melakukan tindakan yang tepat agar orang lain merespon sesuai dengan yang diharapkan dalam rangka penyelesaian pekerjaan dan pencapaian tujuan.
4bd70d52-a4f9-491f-b3c8-447c783795f3	daf48d15-79f1-476d-9175-53467be2d79f	D	Mengeksplorasi dan mengekspresikan pikiran dan/atau perasaannya dalam bentuk karya dan/atau tindakan, serta mengevaluasinya dan mempertimbang kan dampaknya bagi orang lain
9a859176-66c9-4a86-a86b-6f98ca69d088	3063aa35-60fb-49b4-a071-7ae10b9de043	D	Menghasilkan solusi alternatif dengan mengadaptasi berbagai gagasan dan umpan balik untuk menghadapi situasi dan permasalahan
77ec2d51-79cd-4ba7-bed9-4b6d5bd74517	b481fab5-d71c-430b-86e4-eead673a4650	E	Menerapkan pemahamannya tentang kualitas atau sifat-sifat Tuhan dalam ritual ibadahnya baik ibadah yang bersifat personal maupun sosial.
0d650cc8-b344-4246-80f2-954ed30c1b53	b6d22c6b-54c9-42c8-b852-4afa839c779e	E	Mengkritik dan menolak stereotip serta prasangka tentang gambaran identitas kelompok dan suku bangsa serta berinisiatif mengajak orang lain untuk menolak stereotip dan prasangka.
407eb916-f9b8-4510-8bfb-4cb4a5fa1f3f	712e611e-b8e2-44a2-8ec6-bb43c386fcea	E	Memahami struktur organisasi, unsur-unsur utama agama /kepercayaan dalam konteks Indonesia, memahami kontribusi agama/kepercayaan terhadap peradaban dunia.
270b9b90-b529-4788-b2a0-e3fb0a648d87	34bd1617-c2a4-4511-91c5-41518730adad	E	Mengevaluasi efektivitas strategi pembelajaran digunakannya, serta menetapkan tujuan belajar, prestasi, dan pengembangan diri secara spesifik dan merancang strategi yang sesuai untuk menghadapi tantangan- tantangan yang akan dihadapi pada konteks pembelajaran, sosial dan pekerjaan yang akan dipilihnya di masa depan.
5892938d-52d7-4fbd-bed1-39cedd0bd6dd	daf48d15-79f1-476d-9175-53467be2d79f	F	Menghubungkan Gagasan Yang Ia Miliki Dengan Informasi Atau Gagasan Baru Untuk Menghasilkan Kombinasi Gagasan Baru Dan Imajinatif Untuk Mengekspresikan Pikiran Dan/Atau Perasaannya
d2ac1e45-63c9-4db9-8ecb-439c15a1412d	3063aa35-60fb-49b4-a071-7ae10b9de043	F	Menghasilkan Solusi Alternatif Dengan Mengadaptasi Berbagai Gagasan Dan Umpan Balik Untuk Menghadapi Situasi Dan Permasalahan
213b84a5-2a30-432a-9268-6a63b20ad60d	b4fc9911-56ef-4c82-8d54-0f17b98fbe95	F	Menyesuaikan dan mulai menjalankan rencana dan strategi pengembangan dirinya dengan mempertimbangkan minat dan tuntutan pada konteks belajar maupun pekerjaan yang akan dijalaninya di masa depan, serta berusaha untuk mengatasi tantangan-tantangan yang ditemui.
7211c2d0-2137-4496-b829-33995f7484fa	3a402764-0f3c-4cf5-be41-1c94fe7d05de	E	Mengupayakan memberi hal yang dianggap penting dan berharga kepada orang-orang yang membutuhkan di masyarakat yang lebih luas (negara, dunia).
6fc89cb3-d9f5-4373-a3c8-801dbd2e31b3	970d6997-34b2-4b40-8a92-8444f8f71621	E	Mengidentifikasi kekuatan dan tantangan-tantangan yang akan dihadapi pada konteks pembelajaran, sosial dan pekerjaan yang akan dipilihnya di masa depan.
69385bf8-4afd-4511-b563-e5b440bd4ce5	8f867dd8-acfd-48af-aa5b-e28675fa1e1f	E	Menentukan prioritas pribadi, berinisiatif mencari dan mengembangkan pengetahuan dan keterampilan yang spesifik sesuai tujuan di masa depan.
4e289518-0367-4811-92e2-95b1fb9b002c	fc76b41b-d4b2-437d-a597-473431a50234	E	Melakukan tindakan-tindakan secara konsisten guna mencapai tujuan karir dan pengembangan dirinya di masa depan, serta berusaha mencari dan melakukan alternatif tindakan lain yang dapat dilakukan ketika menemui hambatan.
cb9d751b-29a4-48c2-a30c-234f6a90c4ff	b4fc9911-56ef-4c82-8d54-0f17b98fbe95	E	Menyesuaikan dan mulai menjalankan rencana dan strategi pengembangan dirinya dengan mempertimbangkan minat dan tuntutan pada konteks belajar maupun pekerjaan yang akan dijalaninya di masa depan, serta berusaha untuk mengatasi tantangan- tantangan yang ditemui.
e19f7ffa-82b1-47b4-9a07-f57fc2f4d0c7	0a7e0d5a-a3e3-4096-9873-ee23e44e040b	E	Mengajukan pertanyaan untuk menganalisis secara kritis permasalahan yang kompleks dan abstrak.
210a09af-8fde-49de-b50b-bd99e2e4709e	893a5c93-2e80-4d98-886b-68c6dd3853c9	E	Secara kritis mengklarifikasi serta menganalisis gagasan dan informasi yang kompleks dan abstrak dari berbagai sumber. Memprioritaskan suatu gagasan yang paling relevan dari hasil klarifikasi dan analisis.
9c8b3cc0-5b12-4331-a0bd-82cf56cbc4bd	47b75deb-4ee2-4562-9591-5f229e7928d0	E	Menganalisis dan mengevaluasi penalaran yang digunakannya dalam menemukan dan mencari solusi serta mengambil keputusan.
5c765c64-7a7a-4a99-b9e2-b8e4d1800064	ddf90b9b-3201-4154-b1d4-d568b6ca6820	E	Menjelaskan alasan untuk mendukung pemikirannya dan memikirkan pandangan yang mungkin berlawanan dengan pemikirannya dan mengubah pemikirannya jika diperlukan.
fed0e063-8d0d-4315-8eae-a0b9e393b783	7e756d19-6f67-4268-ad79-0c774e45c7a0	E	Menghasilkan gagasan yang beragam untuk mengekspresikan pikiran dan/atau perasaannya, menilai gagasannya, serta memikirkan segala risikonya dengan mempertimbangkan banyak perspektif seperti etika dan nilai kemanusiaan ketika gagasannya direalisasikan.
c22ffcb1-f046-461a-86f7-1a868a9d45e2	daf48d15-79f1-476d-9175-53467be2d79f	E	Mengeksplorasi dan mengekspresikan pikiran dan/atau perasaannya dalam bentuk karya dan/atau tindakan, serta mengevaluasinya dan mempertimbangkan dampak dan risikonya bagi diri dan lingkungannya dengan menggunakan berbagai perspektif.
cdcd4c81-87e7-475a-9b37-b253d25f4ceb	47b75deb-4ee2-4562-9591-5f229e7928d0	F	Menganalisis dan mengevaluasi penalaran yang digunakannya dalam menemukan dan mencari solusi serta mengambil keputusan.
250493ca-fabe-43b3-8483-9a2098b35730	b89fcb3f-3e2b-4c4f-a726-26bf5a76a60b	F	Terbiasa Memahami Tindakan-Tindakan Yang Ramah Dan Tidak Ramah Lingkungan Serta Membiasakan Diri Untuk Berperilaku Ramah Lingkungan\n
90309d8d-4014-4a71-aed8-cf9008e63a74	92e4cd49-5c96-4ced-a9c6-22d5ed14d1ca	F	Menganalisis dinamika budaya yang mencakup pemahaman, kepercayaan, dan praktik keseharian dalam rentang waktu yang Panjang dan konteks yang luas.
19a12356-22ce-401b-a714-0f39f0ff3771	de05089a-4b99-409e-bd93-3762a3edf525	D	Mengidentifikasi masalah yang ada di sekitarnya sebagai akibat dari pilihan yang dilakukan oleh manusia, serta dampak masalah tersebut terhadap sistem ekonomi, sosial dan lingkungan, serta mencari solusi yang memperhatikan prinsip- prinsip keadilan terhadap manusia, alam dan masyarakat
6e0b71ab-5900-426d-8079-83959435492d	daf48d15-79f1-476d-9175-53467be2d79f	A	Mengeksplorasi dan mengekspresikan pikiran dan/atau perasaannya dalam bentuk karya dan/atau tindakan serta mengapresiasi karya dan tindakan yang dihasilkan
4788f1fe-f2dc-4adf-bdc8-6783c55086fd	0eeef478-286e-4b18-be54-f1e22deaaa02	B	Memahami informasi yang disampaikan (ungkapan pikiran, perasaan, dan keprihatinan) orang lain dan menyampaikan informasi secara akurat menggunakan berbagai simbol dan media       
013b5aa1-2120-41b2-bab9-d18fdf12fd29	0829a3e9-e2f2-4faf-884a-39ff3b7b5fa4	A	Mengidentifikasi pilihan- pilihan berdasarkan kebutuhan dirinya dan orang lain ketika membuat keputusan        
cdaadad4-05cc-463c-8a26-ffe89b617fcd	0eeef478-286e-4b18-be54-f1e22deaaa02	A	Memahami informasi sederhana dari orang lain dan menyampaikan informasi sederhana kepada orang lain menggunakan kata- katanya sendiri.
e2faecef-ae70-4f02-8c7d-9b5127f08bfd	55396071-9cd9-49d3-b5e2-8c042e974f3c	C	Mengidentifikasi kesamaan dengan orang lain sebagai perekat hubungan sosial dan mewujudkannya dalam aktivitas kelompok. Mulai mengenal berbagai kemungkinan interpretasi dan cara pandang yang berbeda ketika dihadapkan dengan dilema.
dbbe6092-4892-4a61-bbdd-10797609342c	427bc77c-6725-4502-8029-56963c67ae2c	C	Menyelaraskan tindakannya sesuai dengan perannya dan mempertimbangkan peran orang lain untuk mencapai tujuan bersama.
587c45f7-1bf8-4239-8fa6-8326ba86c148	3a402764-0f3c-4cf5-be41-1c94fe7d05de	C	Memberi dan menerima hal yang dianggap penting dan berharga kepada/dari orang-orang di lingkungan luas/masyarakat baik yang dikenal maupun tidak dikenal.
98bd01e5-0765-410e-bb14-7d4cc5e681c4	046256c5-e308-4030-bb19-b67495819ec7	D	Memahami konsep hak dan kewajiban serta implikasinya terhadap ekspresi dan perilakunya. Mulai aktif mengambil sikap dan langkah untuk melindungi hak orang/kelompok lain.
425cf458-d949-4519-b684-1b4903ae682e	de05089a-4b99-409e-bd93-3762a3edf525	E	Berinisiatif melakukan suatu tindakan berdasarkan identifikasi masalah untuk mempromosikan keadilan, keamanan ekonomi, menopang ekologi dan demokrasi sambil menghindari kerugian jangka panjang terhadap manusia, alam ataupun masyarakat.
a74eb881-5791-46ca-b66e-81d2a653f723	4c6deafc-753e-4cd7-87da-6c8d90747f86	F	Mempromosikan pertukaran budaya dan kolaborasi dalam dunia yang saling terhubung serta menunjukkannya dalam perilaku.
b4b24abf-2ca4-46c3-83be-ebb6a7eca7c9	893a5c93-2e80-4d98-886b-68c6dd3853c9	F	Secara kritis mengklarifikasi serta menganalisis gagasan dan informasi yang kompleks dan abstrak dari berbagai sumber. Memprioritaskan suatu gagasan yang paling relevan dari hasil klarifikasi dan analisis.
2a62421d-98ec-4a1e-baed-3f0803280fa0	3063aa35-60fb-49b4-a071-7ae10b9de043	A	Mengidentifikasi gagasan-gagasan kreatif untuk menghadapi situasi dan permasalahan.       
d47dab3a-fe10-4888-806a-6d6355cbdd37	55396071-9cd9-49d3-b5e2-8c042e974f3c	B	Terbiasa mengidentifikasi hal- hal yang sama dan berbeda yang dimiliki diri dan temannya dalam berbagai hal serta memberikan respon secara positif.
447398f5-235e-4e0a-81dc-867473e02309	046256c5-e308-4030-bb19-b67495819ec7	A	Mengidentifikasi peran, hak dan kewajiban warga dalam masyarakat demokratis
677372b3-af99-4b02-ab2b-d4be3293ee99	0a3cfa27-ff5f-42ba-903b-3920fe3c3045	B	Melakukan refleksi untuk mengidentifikasi kekuatan, kelemahan, dan prestasi dirinya, serta situasi yang dapat mendukung dan menghambat pembelajaran dan pengembangan dirinya
9c89ad0d-98b6-4701-b97a-321f27c23015	3b3d646c-d37e-4a59-bc8e-f1d984a2d2cd	C	Tanggap terhadap lingkungan sosial sesuai dengan tuntutan peran sosialnya dan menjaga keselarasan dalam berelasi dengan orang lain.
465453d4-953a-4dec-8ce0-673e8ed591a8	970d6997-34b2-4b40-8a92-8444f8f71621	C	Menggambarkan pengaruh kualitas dirinya terhadap pelaksanaan dan hasil belajar; serta mengidentifikasi kemampuan yang ingin dikembangkan dengan mempertimbangkan tantangan yang dihadapinya dan umpan balik dari orang dewasa
dff6306a-2fc3-4e2a-bfd2-7359f28aa641	0829a3e9-e2f2-4faf-884a-39ff3b7b5fa4	D	Berpartisipasi dalam menentukan kriteria dan metode yang disepakati bersama untuk menentukan pilihan dan keputusan untuk kepentingan bersama melalui proses bertukar pikiran secara cermat dan terbuka dengan panduan pendidik
392409eb-b7ef-4788-a8a4-95f0fcbdf89f	d3cfbf79-d348-4ff6-ab52-55e649904305	D	Menyelaraskan tindakan sendiri dengan tindakan orang lain untuk melaksanakan kegiatan dan mencapai tujuan kelompok di lingkungan sekitar, serta memberi semangat kepada orang lain untuk bekerja efektif dan mencapai tujuan bersama.
b3843e33-7d93-490d-bc39-90e7df470be3	0d20742f-373f-43e7-8f0a-ac55634d6168	E	Menyajikan pandangan yang seimbang mengenai permasalahan yang dapat menimbulkan pertentangan pendapat. Memperlakukan orang lain dan budaya yang berbeda darinya dalam posisi setara dengan diri dan budayanya, serta bersedia memberikan pertolongan ketika orang lain berada dalam situasi sulit.
0fc5f6d8-870f-4045-b6fc-e795c9b08a9a	8119ef8c-5f73-43f7-9e02-7020bb834df6	F	Memahami Konsep Sebab Akibat Di Antara Berbagai Ciptaan Tuhan Dan Mengidentifikasi Berbagai Sebab Yang Mempunyai Dampak Baik Atau Buruk, Mengidentifikasi Masalah Lingkungan Hidup Di Tempat Ia Tinggal Dan Melakukan Langkah-Langkah Konkrit Yang Bisa Dilakukan
3d6a985f-af20-4c7b-bb4b-f4609c48efd6	893a5c93-2e80-4d98-886b-68c6dd3853c9	F	Mengidentifikasi, Mengklarifikasi, Dan Menganalisis Informasi Yang Relevan Serta Memprioritaskan Beberapa Gagasan Tertentu.
73841a26-0a56-46d3-8def-dc55a868bb6a	ddf90b9b-3201-4154-b1d4-d568b6ca6820	F	Menjelaskan Asumsi Yang Digunakan, Menyadari Kecenderungan Dan Konsekuensi Bias Pada Pemikirannya, Serta Berusaha Mempertimbangkan Perspektif Yang Berbeda
6ee4f207-7dc9-4109-b2ac-850733b6f60f	0a3cfa27-ff5f-42ba-903b-3920fe3c3045	E	Melakukan refleksi terhadap umpan balik dari teman, guru, dan orang dewasa lainnya, serta informasi-informasi karir yang akan dipilihnya untuk menganalisis karakteristik dan keterampilan yang dibutuhkan dalam menunjang atau menghambat karirnya di masa depan.
68eced91-519e-4944-8e79-7a10f748a27a	a95eaf7e-0117-4504-a6f9-7cf877488d7a	E	Mengendalikan dan menyesuaikan emosi yang dirasakannya secara tepat ketika menghadapi situasi yang menantang dan menekan pada konteks belajar, relasi, dan pekerjaan.
f34b62c0-236e-457f-bd99-f31e74ac6959	970d6997-34b2-4b40-8a92-8444f8f71621	F	Mengidentifikasi kekuatan dan tantangan-tantangan yang akan dihadapi pada konteks pembelajaran, sosial dan pekerjaan yang akan dipilihnya di masa depan.
\.


--
-- TOC entry 4100 (class 0 OID 16591)
-- Dependencies: 238
-- Data for Name: profil_dimensi; Type: TABLE DATA; Schema: projec; Owner: raporsp_user
--

COPY projec.profil_dimensi (id_dimensi, nama_dimensi, urut) FROM stdin;
6946e191-5ce0-4b8b-bdc4-0d3b4c6ddc75	Beriman, Bertakwa Kepada Tuhan Yang Maha Esa, dan Berakhlak Mulia\r\n	1
33215983-fe69-4450-89bd-9d13a7792199	Berkebinekaan global	2
6f807664-da67-4b17-9fbc-da51a3ecf87d	Mandiri	4
94278fa9-ab9a-49ce-ace5-8b735ea25241	Bernalar kritis	5
d29a0c65-82f3-443f-8c88-50056f5fec2a	Kreatif	6
67cd143a-6ee2-4c92-aaac-14f2e79c6962	Bergotong royong	3
\.


--
-- TOC entry 4101 (class 0 OID 16595)
-- Dependencies: 239
-- Data for Name: profil_elemen; Type: TABLE DATA; Schema: projec; Owner: raporsp_user
--

COPY projec.profil_elemen (id_elemen, id_dimensi, nama_elemen, urut) FROM stdin;
82b5464c-28da-46ff-8e56-076020c3dad6	6946e191-5ce0-4b8b-bdc4-0d3b4c6ddc75	Akhlak beragama	1
07a6960e-3ccf-4a91-8c41-e7872fa2d122	6946e191-5ce0-4b8b-bdc4-0d3b4c6ddc75	Akhlak pribadi	2
8cb1a132-b301-48fc-abad-dcc68e2bca30	6946e191-5ce0-4b8b-bdc4-0d3b4c6ddc75	Akhlak kepada manusia	3
6163eb1b-dd6f-4c55-accc-e28905b41df4	6946e191-5ce0-4b8b-bdc4-0d3b4c6ddc75	Akhlak kepada alam	4
aebf11b2-0ffc-4e99-95e2-2bedfdee30ce	6946e191-5ce0-4b8b-bdc4-0d3b4c6ddc75	Akhlak bernegara	5
41019ffa-bed6-4b9f-a98e-d43dd7b71820	33215983-fe69-4450-89bd-9d13a7792199	Mengenal dan menghargai budaya	1
788f0689-8d91-4e1f-aa57-0b1e42ff09d1	33215983-fe69-4450-89bd-9d13a7792199	Komunikasi dan interaksi antar budaya	2
c6f26cf6-b30c-4e1a-9ec1-ed4c47791f42	33215983-fe69-4450-89bd-9d13a7792199	Refleksi dan tanggung jawab terhadap pengalaman kebinekaan	3
1bbe32af-b3be-4bc0-92dc-37758212caf3	33215983-fe69-4450-89bd-9d13a7792199	Berkeadilan sosial	4
1120f11f-748b-4c3d-9f68-4084e4fc94b8	67cd143a-6ee2-4c92-aaac-14f2e79c6962	Kolaborasi	1
1d754644-4d8d-4d2d-b0f6-84466c691387	67cd143a-6ee2-4c92-aaac-14f2e79c6962	Kepedulian	2
b25935c5-41b4-46e0-80ab-4e4528e5782a	67cd143a-6ee2-4c92-aaac-14f2e79c6962	Berbagi	3
7bab5397-1ac1-42fd-95df-21304f87a1d3	6f807664-da67-4b17-9fbc-da51a3ecf87d	Pemahaman diri dan situasi	1
a38df29f-9391-4fa9-b980-2a91e7dbb258	6f807664-da67-4b17-9fbc-da51a3ecf87d	Regulasi diri	2
6cf583f0-d86b-4fa6-b098-e68e067ab1fa	94278fa9-ab9a-49ce-ace5-8b735ea25241	Memperoleh dan memproses informasi dan gagasan	1
d61c4d33-b5f5-44b5-bea0-368a431f6a69	94278fa9-ab9a-49ce-ace5-8b735ea25241	Menganalisis dan mengevaluasi penalaran	2
f01d3953-b234-477e-ae1e-b1cfeab946e1	94278fa9-ab9a-49ce-ace5-8b735ea25241	Merefleksi dan mengevaluasi pemikirannya sendiri	3
17ca395d-1e2d-445b-b975-c958b77a8bb0	d29a0c65-82f3-443f-8c88-50056f5fec2a	Menghasilkan gagasan yang orisinal	1
9edcfd40-147f-4f10-bb2e-989e9c86778b	d29a0c65-82f3-443f-8c88-50056f5fec2a	Menghasilkan karya dan tindakan yang orisinal	2
1b7d5322-daaf-45dd-8e40-682d1d6647a2	d29a0c65-82f3-443f-8c88-50056f5fec2a	Memiliki keluwesan berpikir dalam mencari alternatif solusi permasalahan	3
\.


--
-- TOC entry 4102 (class 0 OID 16599)
-- Dependencies: 240
-- Data for Name: profil_project; Type: TABLE DATA; Schema: projec; Owner: raporsp_user
--

COPY projec.profil_project (id_project, id_tema, nama_project, fase, deskripsi_project, status) FROM stdin;
\.


--
-- TOC entry 4103 (class 0 OID 16605)
-- Dependencies: 241
-- Data for Name: profil_subelemen; Type: TABLE DATA; Schema: projec; Owner: raporsp_user
--

COPY projec.profil_subelemen (id_subelemen, id_elemen, nama_subelemen) FROM stdin;
b481fab5-d71c-430b-86e4-eead673a4650	82b5464c-28da-46ff-8e56-076020c3dad6	Mengenal dan Mencintai Tuhan Yang Maha Esa
712e611e-b8e2-44a2-8ec6-bb43c386fcea	82b5464c-28da-46ff-8e56-076020c3dad6	Pemahaman Agama/ Kepercayaan
478a6fbf-bfe7-45b5-8aee-800093132bf1	82b5464c-28da-46ff-8e56-076020c3dad6	Pelaksanaan Ritual Ibadah
bce43e95-5030-4ae8-a6fb-b8d03f32051a	07a6960e-3ccf-4a91-8c41-e7872fa2d122	Integritas
bf718e44-f855-4119-a2a5-f0b18884d980	07a6960e-3ccf-4a91-8c41-e7872fa2d122	Merawat Diri secara Fisik, Mental, dan Spiritual
6a1fe567-19e4-493b-a408-e76a18c96b74	8cb1a132-b301-48fc-abad-dcc68e2bca30	Berempati kepada orang lain
b89fcb3f-3e2b-4c4f-a726-26bf5a76a60b	6163eb1b-dd6f-4c55-accc-e28905b41df4	Menjaga Lingkungan Alam Sekitar
ac37856c-353f-453c-ba40-69a153cdfbdc	aebf11b2-0ffc-4e99-95e2-2bedfdee30ce	Melaksanakan Hak dan Kewajiban sebagai Warga Negara Indonesia
4ec128dc-bb2c-49ba-a73e-36b73c8c7ddf	41019ffa-bed6-4b9f-a98e-d43dd7b71820	Mendalami budaya dan identitas budaya
92e4cd49-5c96-4ced-a9c6-22d5ed14d1ca	41019ffa-bed6-4b9f-a98e-d43dd7b71820	Mengeksplorasi dan membandingkan pengetahuan budaya, kepercayaan, serta praktiknya
4c6deafc-753e-4cd7-87da-6c8d90747f86	41019ffa-bed6-4b9f-a98e-d43dd7b71820	Menumbuhkan rasa menghormati terhadap keanekaragaman budaya
2f008a79-9a19-4d7c-bb1c-88134fc4f817	788f0689-8d91-4e1f-aa57-0b1e42ff09d1	Berkomunikasi antar budaya
0d20742f-373f-43e7-8f0a-ac55634d6168	788f0689-8d91-4e1f-aa57-0b1e42ff09d1	Mempertimbangkan dan menumbuhkan berbagai perspektif
ed71cad9-4fdc-427c-b6fe-38bbfb319429	c6f26cf6-b30c-4e1a-9ec1-ed4c47791f42	Refleksi terhadap pengalaman kebinekaan
b6d22c6b-54c9-42c8-b852-4afa839c779e	c6f26cf6-b30c-4e1a-9ec1-ed4c47791f42	Menghilangkan stereotip dan prasangka
1cdcc713-626e-40a6-8990-a209db3bed28	c6f26cf6-b30c-4e1a-9ec1-ed4c47791f42	Menyelaraskan perbedaan budaya
de05089a-4b99-409e-bd93-3762a3edf525	1bbe32af-b3be-4bc0-92dc-37758212caf3	Aktif membangun masyarakat yang inklusif, adil, dan berkelanjutan
0829a3e9-e2f2-4faf-884a-39ff3b7b5fa4	1bbe32af-b3be-4bc0-92dc-37758212caf3	Berpartisipasi dalam proses pengambilan keputusan bersama
046256c5-e308-4030-bb19-b67495819ec7	1bbe32af-b3be-4bc0-92dc-37758212caf3	Memahami peran individu dalam demokrasi
d3cfbf79-d348-4ff6-ab52-55e649904305	1120f11f-748b-4c3d-9f68-4084e4fc94b8	Kerja sama
0eeef478-286e-4b18-be54-f1e22deaaa02	1120f11f-748b-4c3d-9f68-4084e4fc94b8	Komunikasi untuk mencapai tujuan bersama
d85fe979-81c0-4166-923d-a0abef963fc4	1120f11f-748b-4c3d-9f68-4084e4fc94b8	Saling  ketergantungan positif
427bc77c-6725-4502-8029-56963c67ae2c	1120f11f-748b-4c3d-9f68-4084e4fc94b8	Koordinasi Sosial
3b3d646c-d37e-4a59-bc8e-f1d984a2d2cd	1d754644-4d8d-4d2d-b0f6-84466c691387	Tanggap terhadap lingkungan Sosial
92b6a87b-007e-401d-889d-3e73ec4dc9b1	1d754644-4d8d-4d2d-b0f6-84466c691387	Persepsi sosial
3a402764-0f3c-4cf5-be41-1c94fe7d05de	b25935c5-41b4-46e0-80ab-4e4528e5782a	Berbagi
970d6997-34b2-4b40-8a92-8444f8f71621	7bab5397-1ac1-42fd-95df-21304f87a1d3	Mengenali kualitas dan minat diri serta tantangan yang dihadapi
0a3cfa27-ff5f-42ba-903b-3920fe3c3045	7bab5397-1ac1-42fd-95df-21304f87a1d3	Mengembangka n refleksi diri
a95eaf7e-0117-4504-a6f9-7cf877488d7a	a38df29f-9391-4fa9-b980-2a91e7dbb258	Regulasi emosi
34bd1617-c2a4-4511-91c5-41518730adad	a38df29f-9391-4fa9-b980-2a91e7dbb258	Penetapan tujuan belajar, prestasi, dan pengembanga n diri serta rencana strategis untuk mencapainya
8f867dd8-acfd-48af-aa5b-e28675fa1e1f	a38df29f-9391-4fa9-b980-2a91e7dbb258	Menunjukkan inisiatif dan bekerja secara mandiri
fc76b41b-d4b2-437d-a597-473431a50234	a38df29f-9391-4fa9-b980-2a91e7dbb258	Mengembangka n pengendalian dan disiplin diri
b4fc9911-56ef-4c82-8d54-0f17b98fbe95	a38df29f-9391-4fa9-b980-2a91e7dbb258	Percaya diri, tangguh (resilient), dan adaptif
0a7e0d5a-a3e3-4096-9873-ee23e44e040b	6cf583f0-d86b-4fa6-b098-e68e067ab1fa	Mengajukan pertanyaan
55396071-9cd9-49d3-b5e2-8c042e974f3c	8cb1a132-b301-48fc-abad-dcc68e2bca30	Mengutamakan persamaan dengan orang lain dan menghargai perbedaan
8119ef8c-5f73-43f7-9e02-7020bb834df6	6163eb1b-dd6f-4c55-accc-e28905b41df4	Memahami Keterhubungan Ekosistem Bumi
893a5c93-2e80-4d98-886b-68c6dd3853c9	6cf583f0-d86b-4fa6-b098-e68e067ab1fa	Mengidentifikasi, mengklarifikasi, dan mengolah informasi dan gagasan
47b75deb-4ee2-4562-9591-5f229e7928d0	d61c4d33-b5f5-44b5-bea0-368a431f6a69	Menganalisis dan mengevaluasi penalaran dan prosedurnya
ddf90b9b-3201-4154-b1d4-d568b6ca6820	f01d3953-b234-477e-ae1e-b1cfeab946e1	Merefleksi  dan mengevaluasi pemikirannya sendiri
7e756d19-6f67-4268-ad79-0c774e45c7a0	17ca395d-1e2d-445b-b975-c958b77a8bb0	Menghasilkan gagasan yang orisinal
daf48d15-79f1-476d-9175-53467be2d79f	9edcfd40-147f-4f10-bb2e-989e9c86778b	Menghasilkan karya dan tindakan yang orisinal
3063aa35-60fb-49b4-a071-7ae10b9de043	1b7d5322-daaf-45dd-8e40-682d1d6647a2	Memiliki keluwesan berpikir dalam mencari alternatif solusi permasalahan
\.


--
-- TOC entry 4104 (class 0 OID 16609)
-- Dependencies: 242
-- Data for Name: profil_tema; Type: TABLE DATA; Schema: projec; Owner: raporsp_user
--

COPY projec.profil_tema (id_tema, nama_tema, urut) FROM stdin;
8012d397-656b-47f3-b39a-2fe4260a40dd	Gaya Hidup Berkelanjutan	1
1e6cf100-9ccb-4c8e-8429-f55e9e3171cd	Kearifan Lokal	2
caf51456-0fb1-49d9-8f35-0a0e7d06462b	Bhinneka Tunggal Ika	3
c3bef365-ec6d-48ce-9fa1-75a269729b77	Bangunlah Jiwa dan Raganya	4
36db3318-105f-48b2-a1ef-d0541c9e942d	Suara Demokrasi	5
64bb2271-df9e-4df3-8c87-240aaccfa121	Berekayasa dan Berteknologi untuk Membanguan NKRI	6
2081baa2-92ae-47b5-9a63-0ab5e82577a3	Kewirausahaan	7
9b132aa6-3b70-48e8-9557-b506bb4595ca	Kebekerjaan	8
19bf5991-bbb6-4b29-be0a-1a8b93cb035c	Budaya Kerja	9
\.


--
-- TOC entry 4105 (class 0 OID 16613)
-- Dependencies: 243
-- Data for Name: project_capaianprofil; Type: TABLE DATA; Schema: projec; Owner: raporsp_user
--

COPY projec.project_capaianprofil (id_profil_projek, id_project, fase, jenjang, id_subelemen, id_capaian, status) FROM stdin;
\.


--
-- TOC entry 4106 (class 0 OID 16617)
-- Dependencies: 244
-- Data for Name: ref_penilaian; Type: TABLE DATA; Schema: projec; Owner: raporsp_user
--

COPY projec.ref_penilaian (kd_nilai, nama_nil, desk_nilai) FROM stdin;
SAB	Sangat Berkembang	Siswa mengembangkan kemampuannya melampaui harapan
MB	Mulai Berkembang	Siswa mulai mengembangkan kemampuan namun masih belum ajek
SB	Sedang Berkembang	Siswa telah mengembangkan kemampuan hingga berada dalam tahap ajek
BSH	Berkembang Sesuai Harapan	Siswa telah mengembangkan kemampuan sesuai harapan
\.


--
-- TOC entry 4107 (class 0 OID 16620)
-- Dependencies: 245
-- Data for Name: tabel_anggotakelompok; Type: TABLE DATA; Schema: projec; Owner: raporsp_user
--

COPY projec.tabel_anggotakelompok (anggota_kelompok_id, peserta_didik_id, kelompok_id, th_ajaran, fase) FROM stdin;
\.


--
-- TOC entry 4108 (class 0 OID 16624)
-- Dependencies: 246
-- Data for Name: tabel_kelompok; Type: TABLE DATA; Schema: projec; Owner: raporsp_user
--

COPY projec.tabel_kelompok (kelompok_id, sekolah_id, th_ajaran, ptk_id, nm_kelompok, tingkat_pendidikan_id, status, fase) FROM stdin;
\.


--
-- TOC entry 4109 (class 0 OID 16629)
-- Dependencies: 247
-- Data for Name: tabel_kelompok_projek; Type: TABLE DATA; Schema: projec; Owner: raporsp_user
--

COPY projec.tabel_kelompok_projek (klp_projek_id, kelompok_id, id_project, th_ajaran, fase, status) FROM stdin;
\.


--
-- TOC entry 4110 (class 0 OID 16634)
-- Dependencies: 248
-- Data for Name: jurusan; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.jurusan (jurusan_id, nama_jurusan, untuk_sma, untuk_smk, untuk_pt, untuk_slb, untuk_smklb, jenjang_pendidikan_id, jurusan_induk, level_bidang_id, create_date, last_update, expired_date, last_sync) FROM stdin;
\.


--
-- TOC entry 4111 (class 0 OID 16637)
-- Dependencies: 249
-- Data for Name: loginstatus; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.loginstatus (userid, mulai, status) FROM stdin;
\.


--
-- TOC entry 4112 (class 0 OID 16640)
-- Dependencies: 250
-- Data for Name: pengguna_api; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.pengguna_api (id, username, password, nama, telp_hp, email, status) FROM stdin;
\.


--
-- TOC entry 4113 (class 0 OID 16647)
-- Dependencies: 251
-- Data for Name: ref_klp_mapel; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.ref_klp_mapel (klp_id, jns_klp, nama, jenjang, status, id) FROM stdin;
4	D	Kelompok D	SLB	1	17
1	A	Kelompok A	SD	1	24
1	A	Kelompok A	SMP	1	25
2	B	Kelompok B	SD	1	26
2	B	Kelompok B	SMP	1	27
1	A	Kelompok Umum	SMA	1	6
9	X	Umum	SD	1	1
9	X	Umum	SMP	1	2
9	X	Umum	SMA	1	3
9	X	Umum	SMK	1	4
9	X	Umum	SLB	1	5
1	A	Kelompok A	SLB	1	8
2	B	Kelompok B	SLB	1	11
2	B	Kelompok Pilihan	SMA	1	9
3	C	Kelompok A (Umum)	SMA	1	12
4	D	Kelompok B (Umum)	SMA	1	15
5	E	Kelompok C (Peminatan)	SMA	1	18
1	A	Kelompok Umum	SMK	1	7
2	B	Kelompok Kejuruan	SMK	1	10
3	C	Kelompok C	SD	0	28
4	D	Kelompok D	SD	0	30
5	E	Kelompok E	SD	0	32
6	F	Kelompok F	SD	0	34
3	C	Kelompok C	SLB	1	14
5	E	Kelompok E	SLB	0	20
6	F	Kelompok F	SLB	0	21
6	F	Kelompok F	SMA	0	22
3	C	A. Muatan Nasional	SMK	1	13
4	D	B. Muatan Kewilayahan	SMK	1	16
8	H	C3. Kompetensi Keahlian	SMK	1	37
7	G	C2. Dasar Program Keahlian	SMK	1	36
6	F	C1. Dasar Bidang Keahlian	SMK	1	23
5	E	C. Muatan Peminatan Kejuruan	SMK	1	19
3	C	Kelompok C	SMP	0	29
4	D	Kelompok D	SMP	0	31
5	E	Kelompok E	SMP	0	33
6	F	Kelompok F	SMP	0	35
\.


--
-- TOC entry 4114 (class 0 OID 16650)
-- Dependencies: 252
-- Data for Name: ref_mapeldapo; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.ref_mapeldapo (mata_pelajaran_id, nm_mapel, jurusan_id) FROM stdin;
100014010	Pengenalan Kitab Suci Tri Pitaka	\N
903	Berbicara	\N
400100250	Perkembangan Bahasa	\N
300310200	Bahasa Belanda	\N
400100260	Perkembangan Seni	\N
401251130	Layanan Lembaga Perbankan dan Keuangan Mikro	\N
101001000	Pendidikan Agama dan Budi Pekerti	\N
800010101	Dasar-dasar Komunikasi	\N
802000500	Sistem Operasi	\N
400100240	Perkembangan Sosial Emosional	\N
800020410	Ilmu Penyakit dan Penunjang Diagnostik	\N
804040120	Estimasi Biaya Konstruksi dan Properti	\N
800030204	Melakukan manajemen pergu&gan & distribusi	\N
800080230	Dasar Manajemen Laboratorium Dan Kesehatan Lingkungan	\N
803041505	Melakukan ins. jaringn tembaga multipair ats tanah & bwh tnh	\N
500030000	Pendidikan Jasmani dan Kesehatan	\N
802010710	Pemrograman Web dan Perangkat Bergerak	\N
902	Menulis	\N
802020302	Membuat paket soft aplikasi berbasis desktop tingkat dasar	\N
803020501	Memahami teknik dasar elektronika analog &digital serta kom.	\N
802031512	Melakukan ins. sistem audio video CCTV	\N
804190100	Teknik Pengukuran Besaran Proses Instrumentasi	\N
802030500	Perencanaan Pekerjaan dengan Komputer	\N
802040800	Produksi Audio Visual	\N
802020210	Komputer dan Jaringan Dasar	\N
802030601	Melakukan ins. personal `computer	\N
802032507	Membuat produk desain kom.visual mengrh ke media televisi	\N
803050200	Pekerjaan Dasar Elektromekanika	\N
804150500	Sistem Kelistrikan Mesin Industri	\N
804050803	Melakukan perencanaan pekerjaan konstruksi batu & beton	\N
804051005	Membuat sambungan & hbngan kayu utk pekerjaan mebel/furnitur	\N
804050306	Menjelaskan proses pengawasan pd pemasangan rangka atap baja	\N
807020100	Basic Aircraft Technology and Knowledgle (BATK)	\N
804131100	Penggantian Instrumen Logam dan Gelas	\N
400100210	Perkembangan Nilai Agama dan Moral	\N
804100400	Instrumentasi dan Kontrol Pembangkitan	\N
803060700	Perencanaan Sistem Komunikasi	\N
800010123	Menjelaskan dasar-dasar penyakit	\N
821060102	Menerapkan teknik dasar perkapalan	\N
804100901	Menerapkan rangkaian, besaran, & standarisasi gambar listrik	\N
802011004	Melakukan perawatan,perbaikan & atau setting ulang sistem PC	\N
804110101	Mengoper. sistm kendali berbasis elektro. & elektronik	\N
804090311	Menghitung renc. anggaran & belanja (RAB) pekerj. plumbing  	\N
804190200	Teknologi Instrumentasi Kontrol Proses	\N
400100230	Perkembangan Kognitif	\N
802031502	Menerapkan dasar2 kelistrikan, elektronika & teknik digital	\N
807021300	Aircraft Instrument	\N
807022200	Aircraft Instruments & Autopilot	\N
814100131	Merawat & memelihara peralatan-peralatan unit mesin blowing	\N
825020103	Menanam & mengatur pola tanam tanaman pangan & hortikultura	\N
809010800	Penyelesaian Grafika dan Pelapisan Cetakan	\N
811010100	Foto Reproduksi dan Montase	\N
814030900	Sistem dan Pengendalian Produksi	\N
801040200	Kesehatan Mental dan Ketidakmampuan Lanjut Usia	\N
807022500	Pembubutan Komponen Pesawat Udara	\N
816010309	Melakukan pemeriksaan & pengujian kain hasil produksi	\N
817010103	Menerapkan konsep & dasar ilmu geologi, kristal & mineral	\N
820040407	Memelihara & memperbaiki pemindah tenaga	\N
807021510	Aircraft Electronic CAD	\N
815010200	Penanganan mesin Carding dan Drawing	\N
817010110	Menerapkan dasar2 manaj. usaha kecil pd usaha hasil tambang	\N
802020303	Membuat paket soft aplikasi berbasis desktop tingkat lanjut	\N
819050102	Mengoperasikan peralatan instrumentasi kimia	\N
821060403	Menerapkan kerja dasar logam, las, & listrik	\N
800030202	Menerapkan sistem mutu dalam kontrol kualitas produk farmasi	\N
820040409	Memelihara & memperbaiki kelistrikan otomotif	\N
822070108	Menerpkn pengendali berbantuan mikropr mikrokontroller & PLC	\N
821061001	Menjelaskan dasar kekuatan bahan & komponen mesin	\N
904	Berhitung	\N
821200100	Perawatan dan Perbaikan Mesin Listrik	\N
822060103	Menentukan prosedur & harga perbaikan bodi otomotif	\N
822180100	Sistem Kontrol dan Kelistrikan PLTMH	\N
803050108	Mengoperasikan Programmable Logic Controller (PLC)	\N
823040102	Melakukan pengaturan tegangan, frekuensi, & beban pembangkit	\N
824060200	Program Siaran Jurnalistik	\N
825040201	Menyiapkan lahan & media semai serta merawat pohon induk.	\N
814100141	Mengoperasikan & merawat mesin open end	\N
825050200	Agribisnis Pupuk dan Pestisida Organik /Hayati	\N
825100300	Teknologi Otomatisasi Alat Mesin Panen dan Pascapanen	\N
825160100	Pengolahan Hsl Samping Prod Perikanan & Rmpt Laut	\N
100014020	Riwayat Hidup Buddha Gautama	\N
802020300	Pemodelan Perangkat Lunak	\N
400100220	Perkembangan Motorik	\N
800060301	Menjelaskan dasar2 keperawatan & pelayanan kesehatan gigi	\N
600060010	Prakarya dan Kewirausahaan (Rekayasa)	\N
803060200	Perekayasaan Sistem Audio	\N
700112000	Cetak Saring/Sablon	\N
842020183	Membuat produk kria kayu dengan teknik bubut	\N
827390300	Desain dan Gambar Permesinan Kapal (Marine Engineering Drawing and Design)	\N
827390208	Menerapkan dasar-dasar kenautikaan	\N
828080109	Mengelola administrasi kas 	\N
830030100	Anatomi dan Fisiologi Kecantikan	\N
830050101	Melakukan pencucian rambut 	\N
843060544	Menarikan Tari Wayang	\N
843060410	Gerak Dasar Tari	\N
830050102	Melakukan perawatan kulit kepala & rambut	\N
831010107	Merawat mesin penyempurnaan tekstil	\N
836020101	Merencanakan pekerjaan bahan kayu, logam & batu produk 	\N
839110100	Produk Kulit non alas kaki dan non busana	\N
999903806	Level 6	KRS038
401251102	Komputer Akuntansi Perbankan	\N
842030100	Pembuatan produk dengan teknik ukir	\N
999906537	Teknik Pengukuran & Pengetahuan Peralatan Pastry (MDU-4)	KRS065
843030200	Wawasan Seni Pertunjukan	\N
843060563	Menarikan tari Topeng Tua, Topeng Keras, & Dalem Arsawijaya	\N
843060503	Memainkan tari: Beskalan,Bapang,Klono Topeng Patih (Malang)	\N
999901612	Belum Ada Modul	KRS016
843060518	Menarikan tari Pabbekenna Maji'na & Pagellu	\N
843011754	Menerapkan instrumen individu non klasik	\N
825220200	Keamanan Pangan dan Sistem Jaminan Mutu (Quality Sistem)	\N
999800312	Keterampilan membaca, menulis dan bahasa Indonesia tingkat dasar	PKBM003
843060561	Menarikan tari Telek	\N
875170001	Membaca & menggambar gambar teknik part Pesawat Udara	\N
843060959	Menabuh gamelan babarongan gending iringan tari	\N
875150002	Menerapkan dasar-dasar teknologi pesawat udara 	\N
999906518	Pengetahuan Oprasional Pembuatan Kue (MDO-4)	KRS065
843060546	Menarikan Tari Karya Individu	\N
875190009	Melaksanakan fuctional test instrumen pesawat udara	\N
999891005	Sosial, Politik dan Kebangsaan	PKBM009
999900810	Paket/Gaya	KRS008
999900911	Unit Kompetensi Tambahan	KRS009
999902518	Menghitung biaya ekspor	KRS025
999901107	Level 7	KRS011
999901211	Unit Kompetensi Tambahan	KRS012
999901609	Level 9	KRS016
999900616	Komunikasi dan Dokumen kerja	KRS006
999901812	Belum Ada Modul	KRS018
999902104	Level 4	KRS021
999902313	K3 (Kesehatan dan Keselamatan Kerja) DG?SP-01	KRS023
999904310	Paket/Gaya	KRS043
999902412	MD-1 Gambar Kerja	KRS024
999905916	Prosedur Operasional Standar (MD. 1)	KRS059
999902611	Unit Kompetensi Tambahan	KRS026
999902811	Unit Kompetensi Tambahan	KRS028
999902920	Pengenalan Rambu2 Dalam Dunia Jurnalistik (Md-11)	KRS029
999903301	Level 1	KRS033
999902912	Dasar-Dasar Jurnalistik (Md-3.1)	KRS029
999903108	Level 8	KRS031
999903302	Level 2	KRS033
999902515	Pengakuan Laut	KRS025
999903703	Level 3	KRS037
999903426	Teknologi Otomotif (MD-05)	KRS034
999904317	Desain Grafis for make Label and Cover(MD.6)	KRS043
999903907	Level 7	KRS039
999904111	Unit Kompetensi Tambahan	KRS041
843060504	Memainkan tari: Muang Sangkal, Topeng Getak (Madura)	\N
999904320	Prosedur Umum Keselamatan dan Kesehatan Kerja (MD.9)	KRS043
999906311	Unit Kompetensi Tambahan	KRS063
999904814	Peralatan/ bahan untuk pemeliharaan taman	KRS048
999904813	Pemeliharaan utilitas taman	KRS048
999905005	Level 5	KRS050
999906530	Teknik Pengukuran & Pengetahuan Peralatan Roti (MDU-4)	KRS065
999905111	Unit Kompetensi Tambahan	KRS051
999905409	Level 9	KRS054
999905711	Unit Kompetensi Tambahan	KRS057
999906106	Level 6	KRS061
999906630	Pengetahuan Penunjang Sebagai Penata Kecantikan (MD.11)	KRS066
999905516	Pemeriksaan Klien (MD-05)	KRS055
827110309	Menggunakan pengendali elektromagnet & elektronika	\N
828140110	Keamanan Pangan (Sanitasi, Higienis, dan Keselamatan Kerja)	\N
999906531	Pengetahuan Dasar Pengolahan Roti & Pengetahuan Bahan Adiktif 	KRS065
830040105	Melakukan perwtn tngn kaki kuku, kulit kepl & mewrnai kuku 	\N
999906814	Merias wajah pengantin pria dan wanita	KRS068
828080108	Menerapkan aspek manajemen bank syariah	\N
825270400	Keamanan Pangan dan Sistem Managemen Mutu Pangan	\N
827350500	Olah Gerak dan Pengendalian Kapal (Ship Manoeuvering and Handling)	\N
999902310	Paket/Gaya	KRS023
999906712	Pengetahuan Penunjang Asisten Penata Kecantikan Rambut (MD-01)	KRS067
839020101	Menggambar dengan program komputer	\N
827040200	Prosedur Darurat dan SAR (Emergency Procedure and SAR)	\N
817110104	Menjelaskan kimia hidrokarbon & non-hirokarbon serta gas	\N
827010114	Mengoperasikan & merawat mesin penggerak utama & mesin bantu	\N
827370230	Dinas Jaga Mesin dan Kepedulian Keamanan (Watch keeping andS ecurity Awareness)	\N
827380101	Mengerjakan pengurusan dokumen kapal masuk pelabuhan	\N
999908511	Unit Kompetensi Tambahan	KRS085
999908530	Sistem transmisi otomatis (MD-4)	KRS085
999907913	Teknik Produksi Animasi terpilih*** (MD-02)	KRS079
999910705	Prosedure Pijat Urut Perawatan Wanita dan Bayi (MD-5)	KRS107
999908701	Prosedur Kesehatan dan Keselamatan kerja (MD-1)	KRS087
999908915	Duties and Responsibilities	KRS089
999913210	Komunikasi di Tempat Kerja (MP.III-10)	KRS132
999911406	MP-7  Teknik Menggelar dan Memotong Bahan Utama dan Bahan Pelengkap	KRS114
999912416	MD.3 Prinsip dan unsur desain  lanjutan 1	KRS124
999908923	Emergency Procedure Training / Wet Drill	KRS089
999912102	MP2. Undang-Undang dan Peraturan yang berlaku	KRS121
999911708	MD 8  Pengetahuan Konteks Tari	KRS117
999908203	Level 3	KRS082
999915046	Prosedur pengolahan dan penyajian	KRS150
999912911	MD-2  Alat Ukur (measurement tools)	KRS129
999914315	Kemampuan penunjang sebagai pemrogram aplikasiAplikasi Mobile (MD.IV-15)	KRS143
825210400	Dasar Penanganan dan Proses Pengolahan hasil Perikanan	\N
999913404	MP-4 Aplikasi Matematika, Fisika dan Kimia Bahan dalam Perakitan Pipa	KRS134
999913601	Persiapan pelaksanaan konstruksi kayu  (MP.1)	KRS136
999913103	Persiapan Tata Letak Area Pekerjaan  (MD. 3)	KRS131
843060904	Memainkan instrumen gender barung penerus tingkat pengrawit	\N
999914505	Penggunaan Perangkat Lunak Multimedia (MD.IV-5)	KRS145
400200000	Guru Kelas SD/MI/SLB	\N
401251104	Ekonomi Islam	\N
100013080	Liturgi	\N
999914711	Tanggung jawab & kontribusi terhadap hak cipta, etika & privasi di lingkungan TI	KRS147
999914806	Jenis dan metode keamanan sistem operasi untuk server (MDP-2)	KRS148
801031100	Pengasuhan dan Advokasi Anak	\N
828020110	Memproses transaksi keuangan	\N
999908408	Level 8	KRS084
803080508	Menerapkan prosdr pengujian perngkat kras & lunak terbaru	\N
999902331	Pengantar Hak Kekayaan Intelektual DG-13	KRS023
400300000	Pendidikan Luar Sekolah	\N
999907623	Administrasi  (MD-04)	KRS076
805010607	Melaksanakan pengukuran survei teknik sipil	\N
807020520	Alat Bantu Perakitan Pesawat Udara (Aircraft Tools Jig and Fixture)	\N
803040800	Teknik Instalasi Jaringan Akses Fiber (JARLOKAF)	\N
825210136	Mengolah produk perikanan secara tradisional	\N
820100103	Menggunakan measuring tools & special tools	\N
822060109	Melaksanakan perbaikan kecil cat (spot repair) bodi otomotif	\N
999907511	Unit Kompetensi Tambahan	KRS075
821061004	Menggunakan perkakas tangan & perkakas bertenaga	\N
875180008	Melaksanakan fabrikasi lembaran pelat untuk aircraft parts	\N
875180006	Melakukan pekerjaan pengelasan menggunakan las busur listrik	\N
999915402	Komunikasi, Presentasi, dan Tatalaksana (MD2.III)	KRS154
829111103	Melakukan pengolahan & penyajian kue Indonesia	\N
828020105	Memberikan pelayanan prima kepd pelanggan	\N
999916401	MD. 1. Ketentuan Umum dan Tatacara Perpajakan (KUP) 	KRS164
999906423	Terapi Aroma (Aromatherapy): Mengaplikasikan Aromaterapi untuk Perawatan SPA	KRS064
999915064	Resep masakan aneka masakan nasi makanan sepinggan	KRS150
999800712	Pendidikan Jasmani, Olahraga dan Kesehatan	PKBM007
999905208	Level 8	KRS052
843060906	Memainkan instrumen kendang tingkat pengrawit	\N
999908815	Penanganan kedatangan pesawat (arrival)	KRS088
999910409	Pedoman Hidup Bersih dan Sehat pada Anak (PHBS) - (MD-1)	KRS104
999907404	Level 4	KRS074
999913813	Blok dan Skema telepon selular (HPS-05)	KRS139
999912441	Teknik membuat sketsa utk rangkaian bunga kiriman & perlengkapan bunga pengantin	KRS124
999906426	Terapi Perawatan Tangan, Kaki Dan Kuku dengan masker Khusus secara Manual	KRS064
999915068	Resep masakan lauk pauk hewani  dari bahan  telur	KRS150
999915401	Pengetahuan Bahan, Alat, dan Tempat Penyedia Bahan & Alat Pembuatan Malam Batik	KRS154
999905822	Bahasa Inggris (MD-04)	KRS058
999907811	Unit Kompetensi Tambahan	KRS078
200041010	Aku Sayang Bumi, Gaya Hidup Berkelanjutan	\N
825210100	Penanganan Bahan Hasil Pertanian dan Perikanan	\N
999916006	MD 1. Pemotongan dan Pemungutan Pajak Penghasilan 	KRS160
800000102	Dasar Dasar Konstruksi dan Perawatan Bangunan Sipil	\N
800000138	Dasar Dasar Manajemen Perkantoran dan Layanan Bisnis	\N
800000266	Kriya Kreatif Logam dan Perhiasan	\N
800000237	Mekanisasi Pertanian	\N
401121010	Fisika (Teknologi Informasi dan Komunikasi)	\N
800000122	Dasar Dasar Teknik Jaringan Komputer dan Telekomunikasi	\N
999915050	Jenis-jenis Peralatan kuliner bertehnologi	KRS150
999915032	Kontrol bahan makanan dan peralatan serta permasalahannya	KRS150
999908211	Unit Kompetensi Tambahan	KRS082
999908708	Aplikasi Browsing dan Email (MD-8)	KRS087
999908022	Modul Transistor Bipolar (ED-02.08)	KRS080
999913705	MD.5 Prosedur pembuatan PCB berstandar baku IPC-A610 revision D/E class	KRS137
999908422	Mobilisasi dan transportasi (MD-11)	KRS084
999910108	Mengelola Administrasi Pembelian	KRS101
999910005	Optimalisasi mesin pencari dan Media Sosial untuk pemasaran digital	KRS100
999910606	Ilmu komunikasi yang efektif & efisien, manajemen & pemasaran jasa pelayanan	KRS106
999914308	Pemrograman Aplikasi Menggunakan Peta dan Lokasi (MD.IV-08)	KRS143
800000156	Desain Pemodelan dan Informasi Bangunan	\N
800000203	Teknik Kelistrikan Pesawat Udara (Aircraft Electricity)	\N
800000282	Layanan Penunjang Kefarmasian Klinis dan Komunitas	\N
843060952	Memainkan instrumen rebab	\N
999904612	Belum Ada Modul	KRS046
999904706	Level 6	KRS047
999904707	Level 7	KRS047
999904709	Level 9	KRS047
999904710	Paket/Gaya	KRS047
999904717	Pemotongan dan Pemungutan Pajak Penghasilan 	KRS047
999904718	Pajak Penghasilan Orang Pribadi 	KRS047
999904825	Pengetahuan mengenai Peralatan Taman	KRS048
999906623	Perawatan wajah Berpigmentasi Secara Manual (MD.4)	KRS066
999906624	Perawatan Wajah Kering Kasar Secara Manual (MD.5)	KRS066
999906818	Merias wajah pengantin pria dan wanita 	KRS068
999908202	Level 2	KRS082
813010100	Pemeliharaan dan Perawatan Sistem Kontrol Proses	\N
814100134	Mengoperasikan & merawat unit mesin blowing	\N
825280200	Dasar Pengendalian Mutu Hasil pertanian	\N
999910302	Pembuatan Bakso Ikan	KRS103
999912311	Pembuatan corsase (MP 5)	KRS123
826050400	Penyuluhan Kehutanan	\N
826050401	Mengidentifikasi tipe-tipe hutan & jenis pohon	\N
828170100	Menghitung Tarif dan Dokumen Pasasi	\N
839020109	Membuat kria tekstil dengan teknik tenun	\N
839020110	Membuat kria tekstil dengan teknik tapestri	\N
808070708	Memperbaiki car audio video	\N
808070709	Memperbaiki sistem light-tronic	\N
808070710	Memperbaiki sistem alarm, central-lock & power windows	\N
809010100	Dasar-dasar Kegrafikaan	\N
999916706	MD. 6. Akuntansi Perpajakan 	KRS167
999916707	MD. 7. Pajak Internasional	KRS167
401900000	Ilmu Pengetahuan Alam dan Sosial (IPAS)	\N
802011011	Merancang data base untuk web content server	\N
804111000	Teknik Pemesinan NC/CNC dan CAM	\N
804111100	Perawatan dan Perbaikan Peralatan Mekatronik	\N
875180004	Menggunakan perkakas tangan & bertenaga operasi digenggam	\N
999904820	Pengendalian Hama, Penyakit Tanaman dan Gulma	KRS048
999906538	Pengetahuan Dasar Dekorasi Kue dan Coklat & Pengetahuan Bahan Adiktif (MDD-5)	KRS065
999906633	Perawatan Wajah Dehidrasi dengan teknologi alat listrik (MD.5)	KRS066
999906701	Level 1	KRS067
999908026	Modul Voltage Regulator Series (ED-02.12)	KRS080
999906424	Terapi Perawatan Badan: Menggunakan Exfoliating Modern (Granules / Enzyme)	KRS064
999912442	MD.6 Teknik merangkai rangkaian bunga kiriman  dengan tema  hari libur nasional	KRS124
999916902	Pengendalian Biaya, Pembukuan & Inovasi Pengolahan Roti (MDU-2)	KRS169
800000202	Teknik Pemanasan, Tata Udara, dan Pendinginan (Heating, Ventilation, and AC)	\N
800000279	Layanan Penunjang Keperawatan dan Caregiving	\N
100014080	Pendidikan Humanis	\N
100014090	Seni dan Budaya Buddhis	\N
100014100	Dhammapada	\N
800000280	Layanan Penunjang Dental Care	\N
100014110	Meditasi	\N
100014120	Jataka	\N
100014140	Pendidikan Agama Buddha dan Budi Pekerti	\N
100015000	Pendidikan Agama Hindu	\N
100015020	Weda	\N
100015030	Etika Hindu	\N
100015040	Acara Hindu	\N
100015050	Sejarah Agama Hindu	\N
100015060	Tattwa	\N
100015070	Bahasa Kawi & Bahasa Sansekerta	\N
100015080	Yoga	\N
100015090	Seni Budaya Keagamaan Hindu	\N
901	Membaca	\N
401251500	Bisnis Online	\N
100016000	Pendidikan Agama Konghuchu 	\N
100011060	Sejarah Kebudayaan Islam	\N
100012000	Pendidikan Agama Kristen 	\N
100012010	Ilmu Pengetahuan Alkitab	\N
100012011	Pengetahuan Alkitab	\N
100012020	Etika	\N
100012021	Etika Kristen	\N
100012030	Sejarah Gereja/Sejarah Suci	\N
100012040	Dogmatika	\N
100016010	Pendidikan Agama Konghuchu dan Budi Pekerti	\N
200010200	Pendidikan Kewarganegaraan 	\N
300110000	Bahasa Indonesia	\N
300310100	Bahasa Arab	\N
401130110	Kimia (Kesehatan)	\N
401130500	Kimia Analitik Terapan	\N
401130700	Azas Teknik Kimia	\N
401130800	Operasi Teknik Kimia	\N
401251021	Akuntansi Perusahaan Jasa	\N
100012060	Hermeneutika	\N
100012070	Misiologi	\N
100013000	Pendidikan Agama Katholik	\N
803070810	Teknik Pemrograman, Mikroprosesor dan Mikrokontroler	\N
804130102	Melakukan rutinitas penglsan menggunkn pros las busur manual	\N
825210129	Menyimpan & menggudangkan bahan hasil pert& hasil olahannya	\N
839020164	Melakukan pematrian logam dengan teknik patri lunak & keras	\N
100014050	Kitab Suci Abhidhamma/Abhidharma Pitaka	\N
100014060	Bahasa Pali/Sansekerta	\N
100014070	Etika Buddhis	\N
842020184	Membuat produk kria kayu dengan teknik inlay	\N
999902314	Pengenalan bahan, alat, dan hasil DG?SP-02	KRS023
999906435	MD 6 Terapi Perawatan Wajah Tidak Bermasalah (Facial SPA ) Secara Manual	KRS064
999907316	Meridian Tubuh Manusia (MD-05)	KRS073
999907328	Kode Etik, Prosedur dan Peraturan Praktik Sinshe (MD-18)	KRS073
999910610	Sistim rujukan dan keadaan klien yang harus segera dirujuk (MD-9)	KRS106
999911219	Metode Untuk Menyelesaikan Masalah yang Lazim Dalam Pekerjaan Menjahit	KRS112
999912107	MP7. Kamus Istilah Pertelevisian	KRS121
300120000	Bahasa dan Sastra Indonesia	\N
300210000	Bahasa Inggris	\N
300220000	Bahasa dan Sastra Inggris	\N
300310500	Bahasa Jerman	\N
300310800	Bahasa Perancis	\N
300310900	Bahasa Asing Lain	\N
300311900	Muatan Lokal Bahasa Daerah	\N
300311901	Bahasa Madura	\N
300312900	Muatan Lokal Potensi Daerah	\N
401121020	Fisika (Kesehatan)	\N
401121040	Fisika (Perikanan dan Kelautan)	\N
401130000	Kimia	\N
401130200	Teknik Dasar Pekerjaan Laboratorium Kimia	\N
401130300	Analisis Kimia Dasar	\N
401130400	Kimia Organik	\N
401130900	Proses Industri Kimia	\N
401130910	Evaluasi Kimia dan Fisika Tekstil	\N
401130920	Pencelupan & Analisa Zat warna	\N
401131110	Alat Industri Kimia	\N
401131200	Kimia Amami	\N
401131300	Analisis Kimia Terapan	\N
401131600	Analisis Proksimat	\N
401131800	Proses Persiapan Kimia Tekstil	\N
401131900	Teknik Pencapan & Colour Matching	\N
401132100	Analisis Kimia Instrumen	\N
401140100	Mikro Biologi	\N
401140200	Bakteriologi	\N
401140300	Parasitologi	\N
401140400	Hematologi	\N
401140500	Serologi dan Immunologi	\N
401140600	Patofisiologi	\N
401140700	Immunologi	\N
401140800	Dasar-dasar Mikrobiologi	\N
401140900	Analisis Konstanta fisik	\N
401141100	Farmakologi	\N
401141200	Farmakognosi	\N
401141400	Kimia Farmasi	\N
401141510	Ilmu Farmasi	\N
401141700	Teknologi Pengemasan Produk	\N
401141800	Manajemen Produksi Obat	\N
401200000	Ilmu Pengetahuan Sosial (IPS)	\N
401250100	Ekonomi	\N
401251010	Dasar-dasar Perbankan	\N
401251020	Akuntansi Perusahaan Dagang	\N
401251030	Akuntansi Keuangan	\N
401251040	Komputer Akuntansi 	\N
401251060	Administrasi Pajak	\N
401251070	Pengelolaan Kas	\N
401251090	Layanan Perbankan	\N
401251100	Pengantar Keuangan dan Akuntansi	\N
814	Tutor SPS	PAUD004
300310600	Bahasa Korea	\N
100013010	Pendidikan Agama Katholik dan Budi Pekerti	\N
401251101	Akuntansi Perbankan	\N
600070000	Prakarya	\N
401251120	Layanan Lembaga Keuangan Syariah	\N
800050400	Keterampilan Kebutuhan Dasar Manusia	\N
401251110	Perencanaan Pemasaran	\N
100013060	Kitab Suci	\N
600011000	Seni dan Budaya 	\N
401270000	Tata Negara	\N
401251107	Pengantar Ekonomi 	\N
500010000	Pendidikan Jasmani, Olahraga, dan Kesehatan	\N
814150200	Pengendalian Mutu Produksi	\N
800010121	Melaksanakan dasar-dasar KIE (Kom., Informasi, & Edukasi)	\N
600020000	Seni Budaya dan Prakarya	\N
700010000	Program Khusus	\N
600050000	Kerajinan Tangan dan Kesenian	\N
600060030	Prakarya dan Kewirausahaan (Pengolahan)	\N
401251109	Analisa dan Riset Pasar	\N
800050212	Menerapkan etika keperawatan & kaidah hukum keperawatan	\N
600080000	Pengembangan Diri	\N
700101000	Tata Boga	\N
401251630	Visual Merchandising	\N
600060000	Prakarya dan Kewirausahaan	\N
700119000	Budidaya Peternakan	\N
700103000	Tata Kecantikan	\N
700104000	Pijat (Massage)	\N
700105000	Tata Graha	\N
700106100	Informatika	\N
700107000	Teknik Penyiaran Radio	\N
700108000	Perbengkelan Motor	\N
700109000	Seni Musik	\N
700111000	Seni Lukis	\N
600090000	Pelayanan Prima	\N
700114000	Seni Membatik	\N
700115000	Desain Grafis	\N
700116000	Fotografi	\N
700117000	Elektronika Alat Rumah Tangga	\N
700118000	Budidaya  Perikanan	\N
700120000	Budidaya Tanaman	\N
800030208	Melaksanakan sistem dokumentasi farmasi industri	\N
800000100	Produktif	\N
800010111	Perilaku Manusia dan Lingkungan Sosial	\N
800020100	Ilmu obat-obatan	\N
800010129	Menganalisis data hasil pemeriksaan	\N
800010128	Menjelaskan transfusi darah & bank darah	\N
600080010	Pengembangan Kapasitas	\N
999914710	Melaksanakan pekerjaan secara tim  (MP.IV-10)	KRS147
800010131	Melakukan promosi kesehatan	\N
800030107	Menerapkan manajemen & administrasi di bi&g farmasi	\N
800020200	Ilmu Penyakit	\N
800020500	Ilmu Kesehatan Masyarakat	\N
800020600	Komunikasi Keperawatan	\N
800020700	Konsep Dasar Keperawatan	\N
401110210	Biologi (Agrobisnis dan Agroteknologi)	\N
800030102	Menjelaskan CPOB, CPKB, & CPOTB	\N
401251105	Akuntansi Perbankan Syariah	\N
500060000	Pendidikan Olahraga dan Rekreasi	\N
800020300	Tumbuh Kembang Manusia	\N
800030109	Membuat obat tradisional & fitofarmaka	\N
800030110	Menerapkan distribusi berbagai jenis sediaan obat	\N
800030200	Pengujian dan Pengendalian Mutu Produk	\N
800030300	Manajemen Bahan	\N
800030400	Pengelolaan Produksi Obat	\N
500020000	Pendidikan Jasmani	\N
800030500	Teknologi Pengemasan Obat	\N
800040100	P3K	\N
800050100	PKD	\N
800050200	Dasar-dasar Keperawatan	\N
800050201	Menjelaskan dasar-dasar keperawatan & pelayanan kesehatan	\N
800050203	Mengidentifikasi jenis pemerik. lab dsr yg diperlukan pasien	\N
800050204	Mengasuh bayi, balita, anak, & lansia sesuai tngkt perkemb.	\N
800050205	Melaksanakan pelayan klien/pasien berpenyakit ringan	\N
800050208	Menjelaskan kesehatan reproduksi	\N
800050209	Melakukan pemeriksaan tanda-tanda vital	\N
843100300	Olah Rasa	\N
800050210	Melakukan mobilisasi pasif terhadap klien/pasien	\N
800050300	Administrasi Keperawatan	\N
401251108	Pengantar Bisnis	\N
600012000	Seni, Budaya dan Prakarya	\N
800050420	Kebutuhan Dasar Manusia	\N
800050430	Keterampilan Dasar Tindakan Keperawatan	\N
800060100	PKG	\N
800060200	PPAkG	\N
800060300	Anatomi Gigi	\N
804131400	Teknologi Pengerjaan Non Logam	\N
700110000	Seni Tari	\N
999800406	Muatan Lokal	PKBM004
999800407	Pendidikan Agama	PKBM004
999800409	Pendidikan Kewarganegaraan	PKBM004
999800410	Pengembangan Kepribadian Profesional	PKBM004
999800411	Seni Budaya	PKBM004
999800412	Muatan Lokal Sekolah	\N
999903112	Teknik Komunikasi Efektif (MDIII-1)	KRS031
999908014	Modul Kepemimpinan (ED-02.02)	KRS080
401234000	Sejarah Tingkat Lanjut	\N
100013090	Sejarah Gereja	\N
999916812	Pengetahuan Bahan Makanan (MDC-3)	KRS168
100014030	Ritual Buddhis	\N
401260000	Antropologi	\N
100014000	Pendidikan Agama Buddha	\N
600010000	Pendidikan Seni	\N
100014040	Kitab Suci Vinaya Pitaka	\N
700113000	Suvenir	\N
700102000	Tata Busana	\N
211701000	Bahasa dan Sastra Lainnya	\N
401130100	Kimia	\N
999800414	Keterampilan	\N
800080210	Ilmu Keperawatan	\N
800081200	Kimia Klinik	\N
800060500	Ilmu Pengawetan Gigi	\N
802000100	KKPI	\N
800081100	Imunoserologi	\N
800081300	Mikrobiologi Kesehatan	\N
999800503	Ilmu Pengetahuan Alam 	PKBM005
800080220	Laboratorium Kesehatan Dasar	\N
800090100	Perlindungan Khusus	\N
800100100	Psikologi	\N
800100200	Etika/Perilaku	\N
801010100	Hukum Kesejahteraan Sosial	\N
801020100	Identifikasi Masalah dan Kebutuhan Klien	\N
801030200	Masalah Sosial	\N
801030304	Menerapkan kode etik pekerjaan sosial	\N
800080300	Dasar Teknologi Laboratorium Kesehatan	\N
800070100	Anatomi dan Fisiologi	\N
802030400	Menggabar dengan Komputer	\N
800081000	Histologi	\N
801030400	Metode Perawatan Sosial	\N
800050410	Kesehatan Reproduksi	\N
801030309	Melaksanakan intervensi	\N
802011003	Melakukan perbaikan periferal	\N
999800416	Keterampilan Fungsional Terstruktur	\N
801040100	Studi Kasus	\N
802021000	Rancang Bangun Jaringan	\N
801040110	Gerontologi	\N
801040300	Komunikasi dan Relasi	\N
801040400	Psikososial Lanjut Usia	\N
802010100	Pemrograman Dasar	\N
802000400	Sistem Komputer	\N
802021900	Teknologi Layanan Jaringan	\N
802020100	Perakitan Komputer	\N
800060305	Melakukan diagnosis berbagai penyakit gigi & mulut	\N
802000200	Komputer	\N
802010300	Pemrogram Desktop	\N
802010400	Pemrograman Berorientasi Obyek	\N
802010500	Pemrogram WEB Dinamis	\N
802010700	Pemrograman Perangkat Bergerak	\N
802010800	Algoritma Pemrograman	\N
802010900	Teknik Pemrograman	\N
802011001	Melakukan ins. PC	\N
802011005	Melakukan ins. sistem operasi & aplikasi berbasis GUI & CLI	\N
802011006	Melakukan ins., perawatan & perbaikan perangkat LAN	\N
802011007	Melakukan ins. sistem operasi jaringan berbasis GUI & CLI	\N
802011008	Melakukan ins., perawatan & perbaikan perangkat WAN	\N
802020200	Jaringan Dasar	\N
802011009	Merancang sistem keamanan jaringan	\N
802011010	Melakukan administrasi server dalam jaringan	\N
802020306	Membuat halaman web statis	\N
802020304	Mengoperasikan sistem operasi jaringan komputer	\N
801030306	Menerapkan teknik-teknik pekerjaan sosial	\N
802020305	Melakukan pemrograman basis data (SQL)	\N
802021400	Perakitan Personel Komputer	\N
802020307	Membuat halaman web dinamis tingkat dasar	\N
802020400	Basis Data	\N
802020500	Administrasi Basis Data	\N
802020510	Kerja Proyek Teknik Rekayasa Perangkat Lunak	\N
802020600	Komputer Terapan	\N
802020700	Komunikasi Data	\N
802020800	Sistem Operasi Jaringan	\N
802020900	Administrasi Server	\N
802020910	Administrasi Infrastruktur Jaringan	\N
802020920	Administrasi Sistem Jaringan	\N
802021100	Jaringan Nirkabel	\N
802030200	Corel draw dan Paint Brush	\N
802021200	Keamanan Jaringan	\N
802010200	Pemrograman WEB	\N
802021600	Instalasi Local Area Network (LAN)	\N
802021800	Teknologi Jaringan Berbasis Luas (WAN)	\N
802030300	Simulasi Digital	\N
802030310	Simulasi dan Komunikasi Digital	\N
800060600	Oral Diagnostik	\N
802030110	Dasar Desain Grafis	\N
801030311	Melakukan referal 	\N
999800413	Pemberdayaan	\N
800080200	Laboratorium Dasar	\N
999800417	Keterampilan Fungsional Tersertifikasi	\N
999800501	Bahasa Indonesia	PKBM005
999800502	Bahasa Inggris	PKBM005
999800505	Keterampilan Fungsional	PKBM005
999800506	Matematika	PKBM005
800060400	Ilmu Pencabutan Gigi	\N
801030301	Melakukan kerja sama dengan berbagai jenis klien	\N
999800507	Muatan Lokal	PKBM005
999800508	Pendidikan Agama	PKBM005
999800509	Pendidikan Jasmani, Olahraga dan Kesehatan	PKBM005
999800510	Pendidikan Kewarganegaraan	PKBM005
825010300	Pembiakan Tanaman	\N
825010400	Penyuluhan Pertanian	\N
800000283	Pekerjaan Sosial	\N
800000285	Nautika Kapal Penangkap Ikan	\N
800000286	Dasar Dasar Teknika Kapal Penangkap Ikan	\N
800000287	Dasar Dasar Nautika Kapal Penangkap Ikan	\N
800010124	Melaksanakan uji laboratorium	\N
800070200	Anatomi Fisiologi	\N
800080400	Dasar Patologi Klinik	\N
800080100	Dasar-dasar Kerja di Laboratorium	\N
802010600	Pemrogram Grafik	\N
801030308	Melakukan asesmen	\N
800060700	Pendidikan Kesehatan Gigi	\N
800060900	Farmakologi, Peralatan dan Perawatan Gigi	\N
401130620	Analisis Bahan Organik	\N
802030700	Instalasi Wide Area Network (WAN)	\N
802030606	Melakukan pengolahan gambar digital	\N
802031511	Membuat dokumentasi video	\N
803020502	Menerapkan dasar-dasar komunikasi siaran radio	\N
802031700	Desain Multimedia Interaktif	\N
802031710	Kerja Proyek Multimedia	\N
802031800	Videography	\N
802031900	Animasi 2 dimensi dan 3 dimensi	\N
802031910	Digital Animasi	\N
802032000	Proses Digital	\N
803021700	Operasi dan Pemeliharaan Transmisi Kabel Laut	\N
802032508	Melakukan paska produksi desain kom. visual (post design)	\N
803041900	Sistem Internet of Things (SloT)	\N
802032800	Desain Publikasi	\N
999800602	Bahasa Inggris	PKBM006
802032900	Design media interaktif	\N
802033100	Teknik animasi 2D dan 3D	\N
802040300	Editing	\N
802040600	Menggambar dengan Komputer	\N
802031600	Teknik Pengolahan Vidio	\N
803020506	Melaksanakan program musik	\N
802030604	Melakukan pengambilan gambar video	\N
803020503	Membuat program siaran radio	\N
802040900	Dasar Seni Audio Visual	\N
803010100	Teknik Elektronika Dasar	\N
803010200	Teknik Microprosessor	\N
803020300	Teknik Dasar Modulasi dan Demodulasi	\N
803020400	Sistem Telekomunikasi	\N
803020401	Dasar Sistem Telekomunikasi	\N
803060900	Perawatan dan Perbaikan Peralatan Audio dan Video	\N
999800603	Ekonomi	PKBM006
803020504	Melaksanakan siaran radio on-air	\N
803021900	Operasi dan Pemeliharaan Transmisi Satelit	\N
803020505	Melaksanakan jurnalisme radio	\N
803041600	Kerja Proyek Work Telekomunikasi	\N
803020507	Merancang program cerita radio	\N
802040200	Perekaman	\N
803020800	Sistem Komunikasi Serat Optik	\N
803020900	Sistem Komunikasi Bergerak/Seluler	\N
803020700	Sistem Komunikasi Satelit	\N
803021000	Pengoperasian OLTE	\N
803021100	PABX	\N
803021300	Sistem Manajemen Jaringan	\N
803021400	Sistem Transmisi Backbone	\N
803030200	Antena dan Propagasi	\N
803030100	Teknik Digital	\N
802031100	Teknik Animasi 2 Dimensi	\N
802030900	Desain Multimedia	\N
999800601	Bahasa Indonesia	PKBM006
803041513	Melakukan ins. di terminal milik pelanggan (CPE)	\N
803030300	Teknik Radio Gelombang Mikro	\N
803021800	Operasi dan Pemeliharaan Transmisi Radio	\N
803041504	Melakukan ins. kabel rumah/gedung	\N
803041507	Melakukan ins. perangkat pendukung di jaringan akses tembaga	\N
803041508	Mengoperasikan & memelihara jaringan wireless broadband	\N
803041509	Melakukan ins. jaringan akses serat optik	\N
401251610	Customer Service	\N
401251620	Pengelolaan Bisnis Ritel	\N
803041700	Layanan Komputasi Awan (SaaS)	\N
803030400	Multiplexing PDH dan SDH	\N
803041800	Platform Komputasi Awan (PaaS)	\N
803050101	Menerapkan dasar-dasar teknik mesin	\N
802040400	Pengetahuan Broadcasting	\N
803042000	Sistem Keamanan Jaringan	\N
803042100	Instalasi dan Konfigurasi CPE	\N
803042200	Instalasi dan Pemeliharaan VSAT	\N
803042300	Instalasi Jaringan FTTH	\N
803042400	Koneksi Jaringan Telekomunikasi	\N
802031510	Melakukan ins. & perawatan video game	\N
803050103	Melakukan pekerjaan bengkel elektronika	\N
803050104	Mengoperasikan mesin perkakas powertool & konvensional	\N
803050105	Mengoperasikan sensor	\N
803050106	Mengoperasikan peralatan elektronik & kelistrikan	\N
803060303	Melakukan manajemen produksi	\N
802030607	Melakukan editing audio	\N
802040500	Susun Huruf Komputer	\N
999901611	Unit Kompetensi Tambahan	KRS016
804040130	Estimasi Biaya Pekerjaan Jalan, Irigasi, dan Jembatan	\N
802040700	Komunikasi Massa	\N
802040100	Teknologi Penyiaran	\N
999800604	Geografi	PKBM006
999900410	Paket/Gaya	KRS004
999800606	Matematika	PKBM006
999800605	Keterampilan Fungsional 	PKBM006
999908601	Level 1	KRS086
999908602	Level 2	KRS086
803020500	Pengoperasian Sistem Radio Gelombang Mikro	\N
999908603	Level 3	KRS086
999908604	Level 4	KRS086
822060108	Melaksanakan pengecatan ulang bodi otomotif	\N
825010404	Mengelola bisnis perikanan budidaya	\N
825060809	Memelihara ternak laktasi	\N
825010403	Mengelola bisnis peternakan	\N
802030600	Multimedia dan Desain WEB	\N
802032700	Menggambar dengan Perangkat Lunak	\N
802032600	Sablon (Screen Printing)	\N
802031000	Pengolahan Citra Digital	\N
802030608	Melakukan editing video	\N
802030605	Membuat animasi digital	\N
803021500	Kerja Proyek Telekomunikasi	\N
803060310	Melakukan editing	\N
803060400	Perekayasaan Sistem Atena	\N
803061000	Perencanaan dan Instalasi Sistem Audio Video	\N
804080800	Gambar dan Rencana Anggarana Biaya (RAB)	\N
843110100	Teknik Pemeranan	\N
804010100	Gambar Teknik	\N
803070310	Sistem Pengendali Elektronik	\N
804050800	Konstruksi Batu	\N
803070400	Perekayasaan Sistem Robotik	\N
803090100	Pemrograman dan Aplikasi Mikrokontroler Instrumentasi Medik	\N
800000131	Dasar Dasar Agriteknologi Pengolahan Hasil Pertanian	\N
809010211	Membuat plate ganda	\N
804050304	Melakukan pekerjaan konstruksi baja	\N
803081100	Gambar & Perencanaan	\N
803061100	Editing Audio dan Video	\N
803070500	Pemb. dan Pemeliharaan Peralatan Sistem Kontrol	\N
803090400	Perekayasaan Kontrol Instrumentasi Medik	\N
804011200	Gambar Teknik Otomotif	\N
803070200	Sensor dan Akuator	\N
804010101	Dasar Gambar Teknik	\N
804010200	Gambar Interior dan Eksterior Bangunan Gedung	\N
804010300	Gambar Konstruksi Baja	\N
804010400	Gambar Konstruksi Bangunan	\N
804010500	Gambar Teknik listrik	\N
804010700	Gambar Dengan CAD	\N
804010900	Gambar Teknik Pesawat Udara dan CAD	\N
804011300	Gambar Teknik dan Presentasi	\N
804040400	Sistem Utilitas Bangunan Gedung	\N
804011500	Gambar Teknik Manufaktur	\N
804050200	Pelaksanaan Pekerjaan Konstruksi Baja	\N
804020100	Mekanika Teknik	\N
804030100	Ukur Tanah	\N
804030200	Teknik Pengukuran Tanah	\N
804040100	Ilmu Batuan 	\N
804040110	Estimasi Biaya Konstruksi	\N
804040200	Konstruksi Bangunan Gedung	\N
804040300	Perawatan Gedung	\N
804011000	Kerja Bengkel dan Gambar Teknik	\N
800000101	Dasar Dasar Teknik Perawatan Gedung	\N
804050303	Melakukan perencanaan struktur konstruksi baja	\N
804050302	Menjelaskan dasar-dasar konstruksi baja	\N
804050411	Merancang partisi ruang	\N
804090300	Perancangan Pipa dan Pompa Air	\N
804050480	Dasar-dasar Konstruksi Bangunan dan Teknik Pengukuran Tanah	\N
804050307	Merancang as built drawing	\N
803090200	Penerapan Rangkaian Elektronika Instrumentasi Medik	\N
804050308	Menyusun anggaran biaya pekerjaan konstruksi baja	\N
804050400	Konstruksi Bangunan	\N
804050401	Menerapkan ilmu statika & tegangan	\N
804050402	Menjelaskan dasar-dasar ilmu bangunan 	\N
804050404	Menggambar rencana kolom & balok beton bertulang	\N
804050405	Menggambar rencana konstuksi lantai & dinding	\N
804050407	Menggambar konstruksi langit-langit, atap & tangga	\N
804050409	Menggambar dekorasi interior & eksterior bangunan	\N
804050410	Mengidentifikasi material finishing bangunan	\N
804050420	Dasar-dasar Konstruksi Bangunan	\N
803070600	Instrumentasi dan Kontrol	\N
804050460	Pengelolaan Bisnis Konstruksi dan Properti	\N
804050470	Perencanaan Bisnis Konstruksi dan Properti	\N
804050500	Teknologi Konstruksi Kayu	\N
804101300	Perangkat Pembangkit	\N
804050501	Merencanakan pekerjaan konstruksi kayu	\N
804050503	Melakukan kerja kayu dengan mesin tetap (statis)	\N
804050700	Finishing Konstruksi Kayu	\N
804050801	Mengidentifikasi bahan bangunan	\N
803060302	Melakukan pembuatan naskah/skenario drama & non drama	\N
803060301	Menjelaskan dasar-dasar teknologi TV	\N
804050802	Menerapkan dasar-dasar ilmu bangunan	\N
803070300	Perekayasaan Sistem Kontrol	\N
804050808	Melaksanakan pekerjaan beton pracetak	\N
804080700	Gambar Dasar Plambing	\N
804101400	Proteksi Listrik Pembangkit	\N
825210800	Teknik Pengembangbiakan Komoditas Air Payau dan Laut	\N
804090400	Hidrolika	\N
804100910	Merawat panel listrik & switchgear	\N
804101200	Mesin Listrik Pembangkit	\N
804100920	Teknik Instalasi Tenaga Listrik	\N
804101000	Instalasi Motor Listrik	\N
825010402	Mengelola bisnis tanaman perkebunan	\N
803060300	Perekayasaan Sistem Radio dan Televisi	\N
804101500	Perbaikan Peralatan Listrik	\N
804110100	Teknologi Mekanik	\N
804011100	Gambar Teknik Instrumentasi	\N
999902605	Level 5	KRS026
804050300	Teknologi Dasar Konstruksi Baja	\N
827280104	Menjelaskan teknik budidaya rumput laut	\N
999902604	Level 4	KRS026
827280102	Menjelaskan biologi pertumbuhan rumput laut	\N
803070100	Komunikasi Data dan Interface	\N
828020104	Mengoperasikan & merawat alat-alat kantor	\N
827280103	Mengidentifikasi parameter kualitas air	\N
828020103	Melakukan korespondensi	\N
803070800	Mikroprosesor dan Mikrokontroler	\N
803060304	Melakukan penataan artistik	\N
803060305	Menggunakan peralatan tata cahaya	\N
803060306	Menggunakan peralatan audio 	\N
803060307	Mengoperasikan kamera foto	\N
803060308	Mengoperasikan kamera video	\N
804051100	Finishing Bangunan	\N
804060300	Teknik Pelaksanaan dan Pekerjaan Jalan	\N
804060500	Teknik Pelaksanaan dan Pengawasan Pekerjaan Jembatan	\N
804070100	Teknologi Bahan	\N
804160200	Teknik Gambar Produksi dan Konstruksi Mesin	\N
999905403	Level 3	KRS054
804110300	Mekanika Teknik dan elemen mesin	\N
804080400	Teknik Pengejokan	\N
804080500	Pengetahuan Bahan Plambing	\N
804080600	Dasar-dasar Plambing	\N
804110102	Mengoperasikan sistem kendali pd otomasi industri	\N
804050809	Melaksanakan pekerjaan jalan	\N
804051003	Merencanakan pekerjaan mebel kayu	\N
843050300	Harmoni	\N
804180100	Teknik Dasar Instrumentasi	\N
804120400	Teknik Pengelasan Gas Tungsten (TIG/WIG)	\N
804130100	Gambar Teknik Fabrikasi Logam	\N
804130101	Melaksanakan fabrikasi tingkat dasar	\N
804130104	Melaksanakan fabrikasi tingkat lanjut	\N
804130105	Menggambar bukaan/bentangan geometri 	\N
804130300	Teknik Pembentukan dan Perakitan Fabrikasi Logam	\N
804130400	Teknik Konstruksi Fabrikasi Logam	\N
804130500	Teknik Pengendalian Instrumen Logam	\N
804130600	Teknik Pembuatan Pola	\N
804130700	Teknik Pembuatan Cetakan dan Inti	\N
804130800	Teknik Pengerjaan Logam	\N
804131104	Mengoperasikan perkakas & peralatan pembuatan instrumentasi 	\N
804050900	Konstruksi Beton Bertulang	\N
804160202	Melaksanakan fabrikasi, pemben. pelengkungan, & pencetakan	\N
804160205	Menggambar 2D & 3D dengan sistem CAD	\N
999907106	Level 6	KRS071
804131602	Membaca sketsa & gambar teknik	\N
804180200	Dasar Instrumentasi	\N
999907205	Level 5	KRS072
824051100	Seni Film	\N
804160203	Merancang gambar teknik	\N
804110103	Merakit sistem kendali berbasis relay 	\N
804160400	Teknik Gambar Mesin 3D dengan CAD	\N
804160600	Teknik Gambar Konstruksi	\N
804160700	Teknik Gambar Produksi	\N
804170200	Kelistrikan dan Elektronika Instrumentasi	\N
804131520	Pengelasan Logam	\N
804200200	Teknik Pengendalian Sistem Kontrol Mekanik	\N
999907912	Manajemen Produksi Animasi (MD-01)	KRS079
807020900	Aircraft Drawing & CAD	\N
804131603	Menggunakan mesin untuk operasi dasar	\N
804131604	Melakukan peleburan logam	\N
999907202	Level 2	KRS072
999907203	Level 3	KRS072
999907206	Level 6	KRS072
999907107	Level 7	KRS071
999907405	Level 5	KRS074
999907207	Level 7	KRS072
999907208	Level 8	KRS072
999907209	Level 9	KRS072
999907210	Paket/Gaya	KRS072
999907211	Unit Kompetensi Tambahan	KRS072
999907301	Level 1	KRS073
999907302	Level 2	KRS073
999907303	Level 3	KRS073
999907304	Level 4	KRS073
999907305	Level 5	KRS073
999907309	Level 9	KRS073
999907310	Paket/Gaya	KRS073
999907402	Level 2	KRS074
999907403	Level 3	KRS074
999907602	Level 2	KRS076
999907406	Level 6	KRS074
999907407	Level 7	KRS074
999907408	Level 8	KRS074
999907409	Level 9	KRS074
999907601	Level 1	KRS076
999907204	Level 4	KRS072
999907903	Level 3	KRS079
999907904	Level 4	KRS079
999907902	Level 2	KRS079
803060100	Perencanaan dan Instalasi Sistem Audio	\N
804110105	Merakit sistem PLC 	\N
999907905	Level 5	KRS079
999907906	Level 6	KRS079
999907907	Level 7	KRS079
999907908	Level 8	KRS079
999907909	Level 9	KRS079
999907910	Paket/Gaya	KRS079
830090200	Pengeritingan Rambut dan Penataan Sanggul Tradisional dan Kreatif	\N
999907916	Pengantar Komunikasi (MD-04)	KRS079
999908002	Level 2	KRS080
804050807	Melaksanakan pekerjaan finishing bangunan	\N
999908001	Level 1	KRS080
999908003	Level 3	KRS080
999907810	Paket/Gaya	KRS078
999907921	Pengembangan Diri (MD-05)	KRS079
999907919	Teknik Produksi (MD-03)	KRS079
999907812	Ragam motif bordir (MD-01)	KRS078
999908004	Level 4	KRS080
999908005	Level 5	KRS080
999908007	Level 7	KRS080
999908008	Level 8	KRS080
999907922	Pengantar K3 (MD-06)	KRS079
804080300	Teknik Finishing Furnitur	\N
804131601	Menggunakan peralatan pembandingan &/atau alat ukur	\N
804051006	Membuat komponen & detail sambungan bentuk rumit	\N
804051007	Melakukan penyetelan & perakitan mebel & asesoris	\N
804051008	Merencanakan & melaksanakan pekerjaan ukir	\N
804051009	Merencanakan & melaksanakan pekerjaan finishing	\N
804150105	Memelihara & memperbaiki komponen sistem pneumatik	\N
804132200	Perancangan Teknik dan Gambar Manufaktur-Fabrikasi	\N
804132300	Teknik Fabrikasi Logam	\N
804132400	Teknik Pemesinan Konvensional	\N
804132500	Teknik Pemesinan Non Konvensional	\N
804140100	Peknik Pengecoran dan Perlakukan Panas 	\N
804140300	Teknik Pengecoran dengan Mesin	\N
804140400	Teknik Pengecoran Manual	\N
804150100	Teknik Pemeliharaan Mekanik Mesin Industri	\N
804150106	Mendiagnosis&memperbaiki kesalhan pd peralatan listrik AC/DC	\N
807021910	Pembentukan Logam Pesawat Udara	\N
804150200	Tekinik Pemeliharaan Sistem Pnematik dan Hidrolik	\N
804150300	Teknik Pemeliharaan Sis Kelistrikan Mesin Perkakas	\N
804150400	Proses Produksi dan Konstruksi Mesin	\N
804150700	Teknik Mekanik Mesin Industri	\N
804160100	Teknik Produksi Dengan Mesin Perkakas	\N
806011100	Perawatan dan Perbaikan Peralatan Listrik	\N
804160300	Teknik Gambar Mesin 2D dengan CAD	\N
804160800	Teknik Merancang dengan CAM	\N
804200100	Teknik Pengukuran Besaran Proses	\N
804210100	Teknik Eksplorasi Dasar	\N
806010602	Menerapkan gambar teknik dasar	\N
806010603	Merawat & memperbaiki pengisian refrigeran	\N
807020610	Instalasi Hidrolik dan Pneumatik Pesawat Udara	\N
806010609	Mengoperasikan pendingin ruangan &pengaturan sstm tata udara	\N
999905924	Etika Profesi (MD. 9)	KRS059
804131102	Memelihara peralatan produksi instrumentasi	\N
807020710	Gambar Listrik Pesawat Udara Dan CAD	\N
804131103	Pembuatan instrumentasi secara manual	\N
807010100	Basic Skills	\N
809010303	Melakukan pelipatan hasil cetakan	\N
807020200	Aircraft Structure	\N
807020300	Aircraft Systems	\N
807020400	Aircraft Welding	\N
807020500	Aircraft Manufacture & Assy Parts 	\N
807020600	Aircraft Hydraulic & Pneumatic System	\N
806010610	Merawat & memperbaiki kelistrikan sistem tata udara	\N
807020700	Aircraft Electrical Drawing	\N
807020800	Aircraft Electricity & Electronics	\N
807020810	Listrik dan Elektronika Pesawat Udara	\N
807021800	Aircraft Electronic Communication & Navigation	\N
807021900	Aircraft Sheet Metal Forming	\N
814030100	Analisa Perancangan Kerja	\N
807022600	Pemesinan CNC Komponen Pesawat Udara	\N
813010112	Mendeskripsikan dasar-dasar instrumentasi industri	\N
800061400	Kegawatdaruratan Umum, Gigi, dan Mulut	\N
809010308	Melaksanakan berbagai jenis penjili&	\N
808050500	Maintenance Practice	\N
808070700	Electric Machine & Motor Control	\N
809010210	Membuat plate offset photopolymer	\N
999906001	Level 1	KRS060
813010106	Menggunakan power supply pneumatik pd sistm instrumentasi 	\N
803050300	Rangkaian Elektronika	\N
809010309	Membuat pisau pon/ril/embossing cetak	\N
809010400	Dasar-Dasar Pengelolaan Usaha Grafika	\N
809010500	Kalkulasi Grafika	\N
809010600	Pengelolaan Proses Produksi Grafika	\N
809010700	Penyelesaian Grafika	\N
814031400	Penanganan Transportasi	\N
813010113	Menerapkan gambar teknik instrumentasi	\N
814100104	Melakukan proses pemintaan leleh	\N
813010114	Menerapkan konsep dasar elektronika instrumentasi	\N
813010115	Menerapkan teknik pengukuran	\N
813010117	Melakukan pemrograman sistem kontrol mekanik	\N
809010307	Memotong kertas dengan mesin	\N
813010700	Rekayasa Sistem Kontrol Mekanik	\N
813010800	Konstruksi Sistem Kontrol Mekanik	\N
813010900	Perawatan dan Perbaikan Sistem Kontrol Mekanik	\N
814020200	Penanganan Material dan Sikap Kerja	\N
814030400	Sistem Distribusi Barang	\N
999905911	Unit Kompetensi Tambahan	KRS059
814030800	Perencanaan Tata letak Fasilitas	\N
814031800	Manajemen Transportasi	\N
814050100	Pengendalian Persediaan	\N
814060100	Pengaturan Tata Letak Peralatan	\N
814100102	Melaksanakan pengujian benang tekstil	\N
814100103	Menjelaskan proses persiapan pemintalan serat buatan	\N
999906003	Level 3	KRS060
808060600	Material Composite	\N
806010612	Merencanakan gambar sistem tata udara	\N
300310300	Bahasa Cina	\N
999906006	Level 6	KRS060
401232000	Sejarah Nasional dan Sejarah Umum	\N
999906009	Level 9	KRS060
999906102	Level 2	KRS061
999906103	Level 3	KRS061
804131700	Finishing Logam	\N
843050400	Ear Training	\N
806010611	Merawat & memperbaiki mesin pendingin	\N
804131606	Membuat pelat pola & pola resin	\N
804132100	Penerapan Pengujian Mutu	\N
999906002	Level 2	KRS060
808060610	Aircraft Komposite	\N
809010302	Memproduksi catakan dengan cetak saring	\N
804160204	Membuat bukaan/bentangan geometri	\N
814030700	Perancangan Sistem Kerja dan Ergonomis	\N
814160200	Pengendalian Limbah Industri	\N
813010300	Konstruksi Sistem Kontrol Proses	\N
809010305	Melakukan laminating	\N
809010306	Melakukan pemvernisan	\N
809010310	Mengepon hasil cetak & emboss	\N
809010311	Mengelem hasil pon	\N
809010312	Mengemas hasil cetak	\N
813010108	Menerpkan sistm pengndlian bsran proses pd sistm kntrol pros	\N
813010109	Menerapkan teknik pengendalian pd sistem instr. industri 	\N
817030111	Mengoperasikan & merawat sumur migas	\N
813010110	Menerapkan teknik digital pd sstm pengendalian besrn proses	\N
813010111	Memperbaiki perltn & komponen sistm pengendlian besrn proses	\N
813010116	Menerapkan sistem kontrol mekanik	\N
813010200	Rekayasa Sistem Kontrol Proses	\N
814031100	Pergudangan	\N
814010101	Kesehatan dan Keselamatan Kerja	\N
814031200	Material Handling Equipment	\N
814100135	Mengoperasikan & merawat unit mesin carding	\N
815010700	Pemeliharaan Mesin Pemintalan	\N
807022400	Computer Aided Design	\N
814031300	Logistik Multimoda	\N
807022300	Digital and Microprocessor	\N
814031900	Manajemen Pergudangan	\N
814032000	Manajemen Distribusi	\N
814032100	Freight Forwarding	\N
814040100	Pengendalian Produksi	\N
814070100	Distribusi Barang	\N
814080100	Pengendalian Gudang	\N
814090100	Peralatan Gudang	\N
814100100	Pemintalan Serat Buatan	\N
814100101	Mengidentifikasi serat tekstil	\N
814100105	Melakukan proses pembuatan serat stapel	\N
817040100	Proses Produksi	\N
817010107	Mengidentifikasi bahan galian	\N
817090100	Hambatan dalam Pemboran	\N
999906010	Paket/Gaya	KRS060
814170100	Perbaikan dan Perawatan	\N
814100140	Mengoperasikan & merawat unit mesin roving	\N
814160100	Produksi Bersih	\N
999906008	Level 8	KRS060
814170200	Perawatan dan Perbaikan Mesin	\N
815010100	Penanganan mesin Blowing	\N
815010300	Penanganan mesin Combing	\N
815010400	Penanganan mesin Roving	\N
815010800	Pemintalan Serat Stapel	\N
815010900	Pengendalian Mutu Pemintalan	\N
808070704	Memperbaiki sistem ABS, ASR/ETC & ESP	\N
815011000	Persiapan Pemintalan Serat Stapel	\N
816010100	Persiapan Pembuatan Kain	\N
816010200	Desain Tekstil	\N
816010300	Pembuatan Kain	\N
802032300	Komputer Grafis	\N
843110200	Bermain Peran	\N
816010310	Merawat mesin-mesin tenun	\N
816010400	Pengendalian Mutu Kain	\N
816010500	Perajutan	\N
816010600	Pertenunan	\N
817010105	Mengaplikasikan ilmu ukur tanah	\N
817010108	Menerapkan dasar-dasar pemboran	\N
999906107	Level 7	KRS061
817010109	Menerapkan petrografi 	\N
817010111	Menerapkan teknik peledakan & eksplorasi bahan galian	\N
817010112	Menjelaskan reklamasi daerah bekas tambang	\N
817030110	Mendeskripsikan perltn penguk. pd produksi di permuk & migas	\N
814100137	Mengoperasikan & merawat unit mesin super lap	\N
817040110	Proses Produksi Migas	\N
809010304	Melakukan susun gabung lembar hasil cetak	\N
817050100	Peralatan Produksi Atas dan Bawah Permukaan	\N
817060100	Dasar-dasar Teknik Pemboran	\N
817060101	Mendeskripsikan geologi dasar	\N
817060102	Mendeskripsikan ilmu batuan & bahan galian	\N
817060105	Mendeskripsikan kegiatan pemboran migas	\N
817090300	Teknik Pemboran	\N
817100100	Teknik Instrumentasi Kilang	\N
814031000	Kimia Analisa Tekstil	\N
999906005	Level 5	KRS060
817090200	Peralatan Pemboran	\N
999906012	Belum Ada Modul	KRS060
999906101	Level 1	KRS061
999906104	Level 4	KRS061
999906105	Level 5	KRS061
999906108	Level 8	KRS061
824051200	Produksi Film	\N
999906109	Level 9	KRS061
999906110	Paket/Gaya	KRS061
999906111	Unit Kompetensi Tambahan	KRS061
999906616	Diagnosa Kulit Kaki (MD.5)	KRS066
999906618	Merias Wajah Sehari-Hari (Pagi/Malam) (MD.7)	KRS066
814020100	Penanganan Material	\N
999906619	Perawatan Tangan dan Mewarnai Kuku (MD.8)	KRS066
999906620	Perawatan Kaki dan Mewarnai Kuku (MD.9)	KRS066
807022210	Aircraft Instruments	\N
808070702	Memperbaiki electronic management sistem	\N
814100106	Melakukan proses texturizing	\N
807022700	Pengefraisan Komponen Pesawat Udara	\N
808010100	Aerodynamics and Flight Control	\N
808020200	Gambar Bukaan/Bentangan Geometri	\N
808040400	Gas Turbine Engine	\N
816030100	Pencelupan	\N
819050106	Melakukan unit proses kimia	\N
820040404	Menerapkan prosedur kerja bangku	\N
816040100	Pencapan	\N
816050100	Penyempurnaan Khusus	\N
816070100	K3LH	\N
816070101	Menerapkan keselamatan, kshtn kerja, dan lindung lingk	\N
816010304	Menerapkan proses pembuatan kain tenun	\N
816080100	Pemeliharaan kecil mesin jahit	\N
817010102	Menjelaskan konsep eksplorasi & eksploitasi	\N
821060500	Gambar Obyek dengan Komputer	\N
817010113	Menerapkan sistem penambangan	\N
817020100	Teknik Reservoir dan Perhitungan Cadangan Migas	\N
817020200	Teknik Reservoir	\N
817170100	Preparasi Bahan Galian	\N
817030105	Menghitung ca&gan migas	\N
817030108	Menerapkan kerja sumur sembur alam & buatan	\N
817030109	Menghitung kapasitas sumur sembur buatan ESP & pompa angguk	\N
817110100	Proses Pengolahan Migas dan Petrokimia	\N
814150100	Kualitas dan Hasil Produksi	\N
817010200	Dasar-dasar Geologi	\N
821030108	Melakukan pemeriksaan & pengujian hasil pengelasan	\N
819050107	Melakukan operasi teknik kimia	\N
819020100	Analisis Instrumen	\N
819020110	Analisis Kimia Instrumen	\N
819010100	Analisis Titrimetri dan Gravimetri	\N
819050100	Pengelolaan Industri Kimia Skala Kecil	\N
819050101	Melaksanakan pengelolaan bahan kimia	\N
819050103	Membaca diagram alir proses produksi industri kimia	\N
821200500	Pelapisan Permukaan	\N
821200600	Pekerjaan Perabot dan Elemen Bangunan	\N
821040100	Teknologi Dasar Kelistrikan	\N
816010700	Desain Anyaman	\N
820010100	Teknologi dasar Otomotif	\N
820030300	Teknik Listrik dasar Otomotif	\N
820030500	Perawatan Ketel Uap	\N
820030600	Perawatan Turbin Gas	\N
820030700	Sistem Kelistrikan dan Kontrol Elektronik	\N
820040400	Pemeliharaan Mesin Kendaraan Ringan	\N
820040401	Menerapkan dasar mesin & pembentukan logam	\N
820040402	Menjelaskan proses-proses mesin konversi energi	\N
820040403	Menginterpretasikan gambar teknik	\N
821030107	Melakukan pekerjaan dengan las bahan khusus	\N
821060120	Konstruksi Bangunan Kapal Baja	\N
818010400	Geologi Terapan	\N
821040200	Teknologi Dasar Teknik	\N
821050100	Gambar Teknik Interior Kapal	\N
821060100	Gambar Konstruksi Kapal Baja	\N
821060101	Menggambar teknik	\N
821060104	Mengidentifikasi bahan kapal baja	\N
821060105	Mengoperasikan mesin kerja kayu portabel	\N
821060106	Menggambar konstruksi bangunan kapal baja	\N
821060107	Melakukan pemeliharaan&perbaikan kpl baja & perlengkapannya	\N
821060108	Melaksanakan pembuatan & perakitan komponen kapal	\N
821060109	Menggambar bukaan konstruksi kapal baja	\N
821060110	Menerapakan teknologi pembangunan kapal baja	\N
821060111	Menggambar dengan menggunakan komputer	\N
821060200	Gambar Bukaan Konstruksi Kapal Baja	\N
821060707	Menerapkan komponen pemesinan bantu kapal	\N
821060300	Gambar Konstruksi Kapal dengna CAD	\N
821060400	Gambar Konstruksi Kapal	\N
821060401	Menggambar teknik dasar	\N
821060404	Menguasai dasar desain grafis	\N
821060405	Menggambar mesin	\N
821060406	Menggambar ins. listrik	\N
821060407	Menggambar konstruksi kayu	\N
821060408	Menggambar konstruksi kapal	\N
821060410	Menggambar sistem propulsi	\N
821200408	Melaksanakan pekerjaan pelapisan permukaan	\N
821060600	Gambar Konstruksi Interior Kapal	\N
821060700	Gambar Sistem Pemesinan Kapal	\N
819050105	Melakukan proses industri kimia	\N
821060701	Menerapkan gambar teknik mesin (GTM)	\N
821060703	Melaksanakan pekerjaan pelat & pipa	\N
821060704	Melaksanakan pekerjaan dengan mesin bubut, frais & fluida	\N
821060706	Menerapkan kerja penggerak kapal dengan mesin sekrap	\N
821060800	Gambar Perlengkapan dan Sistem dalam Kapal	\N
816060100	Memberikan layanan prima kepada pelanggan	\N
821061000	Gambar Teknik Pengelasan	\N
818010500	Tambang Terapan	\N
822060104	Memperbaiki panel-panel bodi otomotif	\N
818020100	Geoteknik	\N
821200700	Pekerjaan Interior	\N
821200900	Pekerjaan di Bengkel Interior Divisi Kapal Perang	\N
822010100	Teknik Kerja Bengkel	\N
822060106	Memasang & memperbaiki kaca kendaraan	\N
999906824	Belum Ada Modul	KRS068
822070100	Teknik Elektronika	\N
804100607	Mengoperasikan saluran kabel & udara pd tegangan menengah	\N
999906823	SOP tempat kerja 	KRS068
814120100	Pengujian Bahan Tekstil	\N
817010100	Geologi Dasar	\N
814100142	Mengoperasikan mesin packing	\N
814110200	Pengantar Teknologi Tekstil	\N
816020100	Pengelantangan	\N
817110101	Menjelaskan geologi dasar	\N
814130100	Polimerisasi	\N
814140100	Pemintalan Leleh	\N
814110100	Pengantar Ilmu Tekstil	\N
822070105	Mengoperasikan aplikasi software pd komputer	\N
821190200	Instalasi Penerangan dan Tenaga	\N
821190100	Instalasi Listrik Kapal	\N
821100100	Pekerjaan Mesin Fluida	\N
821110200	Pekerjaan Mesin Penggerak	\N
821180100	Pemeriksaan dan Pengujian Hasil Las	\N
825020108	Melaksanakan panen tanaman pangan & hortikultura	\N
821200400	Pekerjaan Interior Kapal	\N
821200200	Pengendali Mekanik Elektrik dan Elektronik	\N
821190400	Sistem Kontrol Kelistrikan Kapal	\N
800050206	Menerapkan komunikasi interpersonal, massa & terapeutik	\N
821200300	Pembuatan Perabot dan Elemen Bangunan Kapal	\N
823010100	Pemanas Energi Surya	\N
821200402	Menerapkan dasar desain grafis	\N
821200403	Menggunakan mesin kerja kayu portable	\N
821200404	Menggunakan mesin kayu stationer	\N
821200405	Membuat perabot kayu	\N
821200407	Melaksanakan pekerjaan interior kapal	\N
822020100	Teknik Listrik	\N
822110110	Perancangan Sistem Kontrol Kendaraan	\N
822030100	Mekanika dan Elemen Mesin	\N
822040100	Computer Aided Engineering (CAE)	\N
822040110	Sistem Mekatronik Berbasis CAE	\N
822050100	Robotik	\N
822050110	Sistem Robotik	\N
822060101	Menjelaskan dasar-dasar kerja mesin	\N
822070104	Menerapkan sistem mikroprosesor & mikrokontroller	\N
822070107	Merakit perangkat keras komputer	\N
821090800	Elemen Mesin	\N
822080100	Engine Manajemen System (EMS)	\N
822090100	Chasis Manajement System (CMS)	\N
822100110	Perawatan dan Perbaikan Comfort Safety dan IT	\N
822130100	Dasar-dasar Energi Terbarukan	\N
822140100	Pengoperasian dan Pemeliharaan PLTMH	\N
822140200	Pengelolaan PLTMH	\N
822140300	Konstruksi Sipil PLTMH	\N
822140400	Teknik Konversi dan Konservasi Energi	\N
822150100	Studi Kelayakan dan Perencanaan Alam PLTMH	\N
822160100	Pemasangan PLTMH	\N
822170100	Turbin Air dan Kelengkapan Mekanik	\N
822170500	Teknik Pengendali Daya	\N
822190100	Sistem Kontrol dan Kelistrikan	\N
822190200	Teknik Energi Hibrid	\N
822190300	Teknik Energi Hidro	\N
822190400	Teknik Energi Surya	\N
822190500	Teknik Energi Angin	\N
822210100	Aplikasi PLTS	\N
823020100	Teknologi PLTB	\N
825060200	Dasar-dasar Pakan Ternak	\N
823030100	Biogas	\N
823030200	Teknologi Biogas	\N
823040101	Mengoperasikan sistem pembangkit	\N
823040105	Menerapkan penggunaan baterai & instrumen kontrol	\N
825020109	Membuat pupuk organik	\N
823040106	Memasang proteksi pembangkit	\N
800030104	Melakukan pekerjaan di laboratorium resep	\N
823040108	Memasang proteksi, kontrol relay& kontrol PLC/SCADA	\N
824030300	Sistem Rural	\N
821090400	Pekerjaan Finishing Badan Kapal Fiberglass	\N
813	Tutor TPA	PAUD003
825020110	Membudidayakan tanaman secara hidroponik	\N
800061000	Dasar-dasar Ilmu Kedokteran Gigi	\N
825020504	Membibitkan tanaman perkebunan	\N
825020505	Menanam tanaman perkebunan	\N
825020507	Memelihara kesuburan tanah	\N
825020509	Melakukan sensus tanaman produksi	\N
825020510	Memanen & mengangkut hasil tanaman perkebunan	\N
825020511	Mengelola pekerjaan kebun	\N
825020800	Agribisnis Tanaman Pangan	\N
825021000	Pembibitan dan Kultur Jaringan Tanaman perkebunan	\N
825021100	Pemeliharaan dan Pengelolaan Tanaman perkebunan	\N
825021200	Persiapan lahan dan penanaman tanaman perkebunan	\N
806010607	Merencanakan perakitan sistem refrigerasi	\N
825022100	Produksi Komoditas Perkebunan, dan Herbal	\N
825030200	Pengantar Desain Taman	\N
825050100	Agribisnis Ekologi	\N
825030100	Produksi Benih	\N
825050300	Pengujian Mutu Benih	\N
825050400	Agribisnis Perbenihan Tanaman	\N
825050500	Manajemen Pertanian	\N
825050600	Pemuliaan Tanaman	\N
825060100	Dasar-dasar Pemeliharaan Ternak	\N
825060300	Dasar-dasar Kesehatan Ternak	\N
823040104	Mengoperasikan PLC & SCADA	\N
825060301	Melakukan pemeriksaan klinis ternak	\N
825060305	Mendeskripsikan gejala penyakit ternak	\N
825060306	Melakukan pencegahan penyakit ternak	\N
825060307	Melakukan pemeriksaan higiene produk asal ternak	\N
825060308	Melakukan inseminasi buatan untuk ternak	\N
825060309	Melakukan pemeriksaan kebuntingan ternak	\N
825060310	Menolong kelahiran ternak	\N
838040100	Desain Furniture	\N
821190300	Sistem Ketenagalistrikan Kapal	\N
800060910	Asistensi Kesehatan Gigi	\N
822010110	Kerja Bengkel	\N
821090710	Pekerjaan Pelat dan sistem pemipaan kapal	\N
817110102	Menjelaskan ilmu batuan & bahan galian	\N
800060920	Asistensi	\N
800061100	Farmakologi Bahan dan Obat Kedokteran Gigi	\N
800061200	Manajemen Kesehatan Gigi dan Mulut	\N
804050600	Pelaksanaan Konstruksi Kayu	\N
803041512	Melaksanakan ins. antena VSAT	\N
817110106	Menerapkan blending	\N
807021310	Instalasi Instrumen Pesawat Udara	\N
824040400	Skenario	\N
824020200	Teknik Catu Daya	\N
825061311	Menyusun proposal usaha	\N
824050500	Produksi Acara	\N
824050700	Manajemen Produksi	\N
824050800	Penulisan Naskah	\N
825010206	Mengoperasikan alat mesin:pengolah tanah,pennm,& pemelihraan	\N
825062103	Melakukan pencegahan penyakit ternak & merawat ternak sakit	\N
825010210	Mengelola unit tata guna lahan & lahan pertanian.	\N
825030400	Tanaman Pertanaman	\N
825020200	Agribisnis Tanaman Sayuran	\N
825010405	Membuat profil potensi wilayah desa	\N
825010407	Menyusun programa penyuluhan pertanian	\N
825020105	Mengairi tanaman pangan & hortikultura	\N
825020104	Memupuk tanaman pangan & hortikultura	\N
823070100	Kerja Proyek	\N
825020512	Mengelola usaha tanaman perkebunan	\N
825070110	Sumber Tenaga Penggerak dan Klimatologi	\N
807021200	Aircraft Component CNC Machining	\N
825020111	Mengelola usaha tanaman pangan & hortikultura	\N
825020300	Agribisnis Tanaman Buah	\N
825062000	Agribisnis Aneka Ternak	\N
825020400	Agribisnis Tanaman Hias	\N
825020500	Agribisnis Tanaman Perkebunan Tahunan	\N
825020501	Menentukan komoditas tanaman perkebunan	\N
825020502	Mengoperasikan & merawat alat & mesin pertanian	\N
825020503	Menyiapkan lahan produksi tanaman perkebunan	\N
825020520	Produksi Tanaman Perkebunan Tahunan	\N
809010300	Produksi Grafika	\N
825020600	Agribisnis Tanaman Perkebunan Semusin	\N
825020700	Agribisnis Tanaman Herbal/Atsiri	\N
825030300	Perawatan Taman	\N
825010409	Melaksanakan kegiatan penyuluhan pertanian	\N
825030500	Pembentukan Tapak	\N
825060700	Agribisnis Pakan Ternak Ruminansia	\N
825062300	Fisiologi Hewan	\N
825061400	Agribisnis Aneka Ternak Serangga	\N
825061600	Agribisnis Aneka Hewan Kesayangan	\N
825060800	Agribisnis Pembibitan Ternak Ruminansia	\N
825062100	Dasar-dasar Peternakan	\N
825062102	Memelihara aneka ternak	\N
802030603	Mendesain & mengelola isi halaman web	\N
802030602	Menjelaskan dasar-dasar multimedia	\N
825080100	Ilmu Bahan Teknik	\N
814030600	Pengendalian Mutu	\N
843100100	Olah Tubuh 	\N
825063300	Industri Pembibitan Ternak	\N
825063400	Industri Ternak Pedaging	\N
825130300	Pemetaan lahan	\N
825090100	Traktor Pertanian	\N
825180100	Pemeriksaan Laboratorium	\N
825230210	Produksi Pengolahan Hasil Hewani	\N
825170100	Klinik Hewan	\N
825210101	Menerapkan keselmtan, kesehtn kerja & lingkungan hdp (K3LH)	\N
825100200	Teknologi Otomatisasi Alat Mesin Budidaya	\N
825130100	Pemetaan Lahan Pertanian	\N
825130200	Pengukuran dan Pemetaan Lahan Pertanian	\N
825063600	Industri Ternak Unggas Petelur	\N
825160110	Dsr Teknik Pnangkpn Ikan & Pnympnan Hsl Tngkp	\N
825100100	Alat Mesin Budidaya Pertanian	\N
825190100	Obat dan Vaksin	\N
825200100	Kesehatan masyarakat Veteriner	\N
825010406	Menyusun rencana definitif kelompok (RDK)	\N
825230200	Produksi Hasil Hewani	\N
825063200	Industri Pakan Ternak	\N
825210130	Menerapkan sanitasi industri pengolahan hasil pertanian	\N
825240200	Pengolahan Diversifikasi Hasil Perikanan	\N
825210131	Mengelola usaha pengolahan hasil pertanian	\N
825220500	Produksi Pengolahan Komoditas Perkebunan dan Herbal	\N
825210132	Menjelaskan komoditi hasil perikanan	\N
825210134	Menangani produk dengan refrigrasi	\N
825220300	Keamanan Pangan, Penyimpanan, dan Penggudangan	\N
825063100	Industri Aneka Ternak	\N
825210103	Mengelola peralatan pengawasan mutu	\N
802030800	Administrasi Jaringan	\N
825230400	Produksi Makanan dan Minuman Herbal	\N
825240100	Pengolahan Hasil Perikanan Tradisional	\N
825240110	Produksi Hasil Perikanan secara Tradisional	\N
825240310	Produksi Olahan Ekspor Hasil Perikanan	\N
825010209	Melaksanakan pengukuran lahan 	\N
825240400	Produksi Olahan Rumput Laut dan Hasil Samping Perikanan	\N
825250100	Dasar Analisis Fisikokimia	\N
825250101	Melakukan pengelolaan bahan kimia	\N
825250102	Melakukan dasar-dasar pekerjaan analisis kimia	\N
825250103	Menerapkan good laboratory practice	\N
825061500	Agribisnis Aneka Ternak Monogastrik	\N
825020101	Menyiapkan lahan pertanian	\N
825010208	Mengopersikn alt mesin pertnian psca panen & pengolhn hasil 	\N
807021000	Aircraft Component Turning	\N
807021100	Aircraft Component Milling	\N
807021400	Aircraft Electrical System Assembly	\N
823060100	Teknologi Gasifikasi Biomassa	\N
807021320	Instruments Pesawat Udara	\N
823050100	Bahan Bakar Nabati	\N
818010200	Bahan Galian	\N
820070102	Melakukan perbaikan sistem hidrolik sepeda motor	\N
820040406	Memelihara & memperbaiki engine otomotif	\N
825060400	Dasar-dasar Pembibitan Ternak	\N
820140200	Perawatan dan Perbaikan Kelistrikan Otomotif	\N
820140300	Perawatan dan Perbaikan Mesin Otomotif	\N
826050410	Melakukan pemanenan hasil hutan	\N
820140400	Perawatan dan Perbaikan Sasis, Pemindah Tenaga Otomotif	\N
821010100	Konsep Dasar Perkapalan	\N
825010201	Menjelaskan bahan logam & non logam. 	\N
820110100	Perbaikan Panel-Panel Bodi	\N
825140100	Irigasi dan Drainase	\N
825150100	Pengelolaan Tanah Pertanian	\N
999906004	Level 4	KRS060
825062200	Anatomi Hewan	\N
825240210	Produksi Olahan Diversifikasi Hasil Perikanan	\N
825240300	Pengolahan Hasil Perikanan Standar Eksport	\N
825250107	Melakukan analisis proksimat	\N
826050500	Pembinaan Hutan	\N
826050700	Pengukuran Hutan	\N
827010104	Menerpkn dinas jga deck/P2TL & isyrt visual/komuniksi di kpl	\N
999911007	Melakukan Prosedur Administrasi (MP 3-7)	KRS110
826050800	Perlindungan Hutan	\N
826060500	Inventarisasi Hutan	\N
826060510	Inventarisasi Pada Hutan Produksi Sebelum Penebangan	\N
826060600	Garap Tari	\N
826070100	Pengukuran dan Pemetaan Digital	\N
826080100	Inventarisasi Keanekaragaman Hayati	\N
999900608	Level 8	KRS006
826100100	Ekowisata	\N
827080200	Prosedur Darurat	\N
827030100	DTPIP2HT	\N
825250108	Melakukan analisis parameter lingkungan	\N
827040100	Dasar-dasar Keselamatan di Laut (DKL)	\N
827110304	Melaksanakan pekerjaan ins. listrik penerangan & tenaga	\N
827050110	Bahasa Inggris Maritim	\N
827050100	Bahasa Inggris Maritim dan Perikanan (BIMP)	\N
827060600	Meteorologi dan Oseanografi	\N
827060100	Pelayaran Kapal Perikanan (PKP)	\N
827060200	Bahan dan alat tangkap	\N
827060300	Ilmu Pelayaran Datar	\N
827060400	Kompas Magnet dan Kompas Gasing	\N
827060500	Manajemen Kapal Perikanan	\N
827010108	Menerapkan perncanan pelyrn, pelayrn datar & pelayrn astron.	\N
827060800	Olah Gerak dan Pengendalian Kapal Penangkap Ikan	\N
827070100	KDJKP	\N
827090100	Teknik dan alat Penangkap Ikan (TAPI)	\N
827090110	Bahan dan Alat Tangkap Penangkap Ikan	\N
827100100	MDITKP	\N
827110301	Mengidentifikasi bahan kapal kayu	\N
827110302	Menerapkan pengoperasian mesin kerja kayu portabel	\N
827110303	Melakukan percobaan me& listrik tegangan AC	\N
827110305	Melaksanakan pekerjaan teknik pendingin	\N
807021710	Instalasi Kelistrikan Pesawat Udara	\N
827110306	Menerapkan komponen rangkaian elektronik	\N
827110307	Membuat ins. listrik kapal/industri	\N
827110308	Memperbaiki mesin listrik	\N
827110310	Listrik Kapal Penangkap Ikan	\N
827110320	Motor Diesel Kapal Penangkap Ikan	\N
827120100	KSPOKP	\N
999911216	Mengoperasi-kan Berbagai Jenis Mesin Jahit (MD-07)	KRS112
827130100	Mesin Pendingin Kapal Perikanan (MPKP)	\N
827130110	Mesin Pendingin	\N
827130200	Permesinan Kapal Penangkap Ikan	\N
827140100	Dasar-dasar Budidaya Perairan	\N
827140200	Dasar Dasar Budidaya Perikanan	\N
827150100	Pengelolaan Kualitas Air	\N
827170100	Produksi Pakan Alami	\N
827170200	Produksi Pakan Alami dan Buatan	\N
827180100	Produksi Pakan Buatan	\N
827190100	Teknik Pembenihan Ikan	\N
827330100	Dasar-dasar Penanganan Pengaturan Muatan (DPPM)	\N
999911006	Berkomunikasi melalui Telepon (MP 3-6)	KRS110
827080400	Perencanaan Pelayaran	\N
843060925	Memainkan karawitan Iringan Tari	\N
843090311	Membuat pementasan drama	\N
999911213	Merencanakan Kebutuhan Bahan Pakaian (MD-04)	KRS112
999912436	MD.23 Etika kerja 	KRS124
999911215	Memotong Bahan (MD-06)	KRS112
999911218	Melakukan Pekerjaan Dalam Tim (MD-09)	KRS112
807021700	Aircraft Electrical System 	\N
999911220	Pengetahuan tentang Leadership, SOP, Pembagian Tugas, Deskripsi mutu hasil kerja	KRS112
999911301	Belum Ada Modul	KRS113
999912434	MD.21 Perhitungan Harga jual	KRS124
999911212	Membuat Pola (MD-03)	KRS112
999912454	MD.18 Teknik merangkai bunga meja penerima tamu 	KRS124
999913201	K3L pada Pekerjaan Pemasangan Perpipaan (MP.III-1)	KRS132
807021610	Rangkaian Elektronika dan Kontroller	\N
818010300	Geologi Teknik	\N
807022100	Aircraft Electronical	\N
807021720	Aircraft Electrical	\N
814100110	Memelihara komponen mesin & peralatan	\N
817110108	Menjelaskan tentang gas processing	\N
817110107	Mendeskripsikan proses petrokimia	\N
817110109	Menjelaskan produk migas & petrokimia	\N
821010200	Pekerjaan Dasar Teknik Perkapalan	\N
821030103	Menerapkan teknologi las	\N
827290300	Teknik Pembibitan Rumput Laut	\N
821030100	Perawatan dan Perbaikan Kapal Baja	\N
823170600	Teknik Kontrol	\N
821020100	Perlengkapan Kapal	\N
825010205	Mengoperasikan & merawat traktor pertanian roda 2 & roda4	\N
825060500	Agribisnis Ternak Ruminansia Pedaging	\N
827200110	Teknik Pembesaran Komoditas Perikanan Air Tawar	\N
827280109	Melaksanakan pengolahan rumput laut pasca panen	\N
827210400	Pengembangbiakan Komoditas Perikanan Laut	\N
827370300	Dinas Jaga Pemesinan Kapal Niaga	\N
827350300	Kecakapan Bahari (Seaman Ship)	\N
827280110	Menguji kualitas rumput laut kering	\N
827220100	Teknik Pembenihan Krustasea	\N
827230100	Teknik Pembesaran Krustasea	\N
999913402	MP-2 Teknik Perakitan Pipa	KRS134
827240100	Teknik Pemanenan Krustasea dan Pasca Panen	\N
827250100	Teknik Pembenihan Kekerangan	\N
827270100	Teknik Pemanenan Kekerangan dan Pasca Panen	\N
827280100	Teknik Pembenihan Rumput Laut	\N
827280106	Menanggulangi hama & penyakit rumput laut	\N
827280107	Melaks. pembibitan tek. demplot (lumbung) bibit rumput laut	\N
827280108	Melaksanakan budidaya rumput laut secara terpadu	\N
827210300	Penanganan Hasil Perikanan Laut	\N
821080203	Melakukan pembuatan komponen & konstruksi kapal non baja	\N
827290100	Teknik Pembesaran Rumput Laut	\N
827290400	Teknik Pemanenan dan Pasca Panen Rumput Laut	\N
827290500	Teknik Pengolahan Rumput Laut	\N
828090100	Administrasi sarana dan prasarana	\N
829111104	Melakukan pengolahan & penyajian kue pastry kontinental 	\N
827310100	Hukum Maritim (HM)	\N
827310200	Hukum Maritim dan Peraturan Perikanan	\N
827340100	Bahasa Inggris Maritim	\N
827350101	Menerapkan hukum laut	\N
827320100	Bangunan dan Stabilitas Kapal Niaga (BSKN)	\N
827350400	Meteorologi (Meteorology)	\N
827350100	Pelayaran Kapal Niaga (PKN)	\N
827370100	Dinas Jaga/P2TL Kapal Niaga (DJKN)	\N
830040000	Kecantikan Dasar	\N
827210200	Budidaya Perikanan Laut	\N
827351000	Permesinan Kapal (Ship Machinery)	\N
820130300	Pemeliharaan dan Perbaikan Interior	\N
821080400	Pembuatan Kapal Kayu	\N
827370210	Dinas Jaga	\N
827350700	Pelayaran Astronomi (Celestial Navigation)	\N
827210100	Teknik Pemanenan Ikan dan Pasca Panen	\N
827370220	Dinas Jaga / P2TL	\N
827370200	Komunikasi dan Dinas Jaga/P2TL Kapal Perikanan	\N
828010110	Melakukan pemasaran barang & jasa	\N
827260100	Teknik Pembesaran Kekerangan	\N
830040100	Dasar Kecantikan Kulit	\N
829121200	Produk Cake	\N
999902416	(MD-5) Administrasi Proyek	KRS024
828080129	Menjelaskan usaha kartu plastik	\N
828080200	Otomatisasi Tata Kelola Keuangan	\N
828090000	Administrasi Umum	\N
829111107	Melakukan pelayanan makanan & minuman 	\N
820050500	Pemeliharaan Sasis & Pemindah TKR	\N
828060100	Kearsipan	\N
829131300	Kue Indonesia	\N
999912807	Dasar-dasar sistem hidrolik (MD-7)	KRS128
830010100	Sanitasi, Hygiene Kecantikan	\N
829151500	Pengelolaan Usaha Pastry dan Bakery	\N
830020100	Kosmetika	\N
999913403	MP-3 Identifikasi Alat dan Bahan Perakitan Pipa	KRS134
999912802	Pengetahuan Produk-produk Alat Berat (MD-2)	KRS128
828080126	Menjelaskan lembaga keuangan bukan bank	\N
829141400	Roti, kue Diet Khusus dan Teknik Fusion	\N
827210600	Pengolahan Hasil Perikanan	\N
803081400	Sistem Kendali Instrumentasi dan Otomatisasi Proses	\N
100010000	Pendidikan Agama	\N
821060103	Melaksanakan pekerjaan dasar kayu, alumunium, & fiberglass	\N
999914311	Pemrograman Aplikasi Menggunakan SMS (MD.IV-11)	KRS143
828020100	Pengantar Administrasi Perkantoran	\N
827290200	Teknik Penanaman Rumput Laut	\N
999914804	Panduan menyusun laporan (MDK-4)	KRS148
100011000	Pendidikan Agama Islam	\N
821060705	Melaksanakan kerja penggerak kapal dgn mengg. mesin perkakas	\N
999915062	Bimbingan dan  Pelatihan	KRS150
828080125	Menjelaskan lalu lintas pembayaran transaksi	\N
821030101	Menerapkan pekerjaan dasar kayu, alumunium, & fiberglass	\N
999912806	Dasar-dasar power train tipe roda (wheel) (MD-6)	KRS128
821080300	Pengoperasian Mesin Kerja Kayu	\N
820040408	Memperbaiki sasis & suspensi	\N
829111108	Melakukan pengolahan & menyajikan hi&gan penutup 	\N
820070100	Pemeliharaan Mesin Sepeda Motor	\N
820070101	Menjelaskan dasar-dasar mesin	\N
821030102	Menggambar teknik pengelasan	\N
821090330	Pembuatan dan Perakitan Komponen Kapal Kayu dan Fiberglass	\N
831010100	Tekstil	\N
821030104	Menerapkan kerja las SMAW & FCAW	\N
817060110	Mendeskripsikan semen pemboran	\N
818010100	Pemetaan Topografi dan Pemetaan Geologi	\N
817120100	Peralatan Proses dan Utilitas	\N
817120200	Konstruksi Jalan dan Jembatan	\N
817130100	Produk Migas dan Storage handling	\N
820120100	Pengecatan Bodi	\N
817140100	Gas Processing	\N
817160100	Teknik Peledakan dan Pemboran	\N
817110110	Mengoperasikan peralatan proses migas	\N
820110110	Perbaikan Panel Bodi	\N
821170400	Teknik Las SAW	\N
817060106	Melakukan pemboran	\N
820120200	Pengecatan Bodi Otomotif	\N
820140100	Manajemen Perawatan Otomotif	\N
821090500	Perawatan dan Perbaikan Kapal Fiberglass	\N
817180100	Eksplorasi dan Teknik Penambangan	\N
822070111	Mengoperasikan rangkaian elekronika terapan & power supply	\N
821120300	Mesin Penggerak Kapal	\N
821120310	Elemen mesin dan penggerak kapal	\N
821140500	Gambar Teknik Mesin	\N
821150600	Pemrograman CNC	\N
821170200	Teknik Las FCAW	\N
821090700	Pekerjaan Plat dan Pipa	\N
821170300	Teknik Las GTAW	\N
823080100	ISDN	\N
821170500	Teknik Las Bangunan Kapal	\N
821170610	Teknik Las GTAW dan SAW	\N
821170700	Teknik Listrik dan Pengukuran	\N
821170900	Teknik Elektronika Kapal	\N
821171000	Teknik Pendinginan dan Elektronika Kapal	\N
822070106	Menerapkan komunikasi data sinyal digital antar peralatan	\N
828190108	Mempresentasikan komentar pemanduan wisata	\N
823170610	Teknik Kontrol Sistem Mekatronik	\N
822070113	Melakukan dasar pekerjaan bengkel elektronika	\N
823060200	Teknologi Gasifikasi	\N
821170100	Teknik Las SMAW	\N
824010100	Teknik Trafik	\N
999912809	Dasar sistem kemudi (MD-9)	KRS128
824050900	Penyutradaraan	\N
824051000	Sejarah Film 	\N
824051500	Visual Effect	\N
824060100	Program Siaran Artistik	\N
828100100	Administrasi Humas dan Keprotokolan	\N
828100200	Otomatisasi Tata Kelola Humas dan Keprotokolan	\N
828110100	Etika Profesi	\N
828120100	Pengantar Pariwisata	\N
828120200	Kepariwisataan	\N
828120300	Komunikasi Industri Pariwisata	\N
828190105	Melakukan penawaran paket wisata	\N
828190107	Melakukan pemanduan perjalanan wisata 	\N
828190110	Kepemanduan Ekowisata	\N
827380109	Mempersiapkan perbekalan yang diperlukan selama berlayar	\N
828190120	Kepemanduan Wisata Bahari	\N
999900609	Level 9	KRS006
829111100	Produk Pastry dan Bakery	\N
830050106	Melakukan penataan sanggul	\N
830040103	Melakukan perawatan kulit wajah tidak bermasalah	\N
999908010	Paket/Gaya	KRS080
830040104	Melakukan rias wajah sehari-hari	\N
830050105	Melakukan pengeritingan rambut	\N
830050108	Melakukan pelurusan rambut	\N
830040102	Menjelaskan kosmetika kecantikan	\N
999912435	MD.22 Prosedur K3	KRS124
830050107	Melakukan pewarnaan rambut	\N
999912808	Dasar elektrik (MD-8)	KRS128
999913310	MD-7 Pengembangan Diri	KRS133
999912921	Alat Bantu Diagnosis (MA-1)	KRS129
828020101	Mengaplikasikan keterampilan komunikasi	\N
825230110	Produksi Pengolahan Hasil Nabati	\N
825021300	Manajemen Perkebunan	\N
825060807	Menangani penggemukan ternak ruminansia	\N
825061300	Agribisnis Aneka Ternak Unggas Produksi 	\N
825062101	Menjelaskan dasar-dasar budidaya aneka ternak	\N
825062400	Reproduksi Hewan	\N
825062600	Dasar-dasar Mikrobiologi dan Parasitologi	\N
825230100	Produksi Hasil Nabati	\N
827150200	Kualitas Air dan Hama Penyakit	\N
826060520	Inventarisasi Pada Hutan Produksi Setelah Penebangan	\N
827010102	Menerapkan tata laksana perikanan yang bertanggungjawab	\N
827080300	Tata laksana perikanan yang bertanggung jawab (CCRF)	\N
827190110	Teknik Pendederan Komoditas Perikanan Air Tawar	\N
817070100	Teknik dan Peralatan Pemboran	\N
826090100	Pembinaan Habitat dan Populasi	\N
827351200	Sistem Navigasi Elektronik (Electronic Navigation System)	\N
825250400	Teknik Panen, Penanganan Pasca Panen dan Pemasaran Ikan Hias	\N
817080100	Lumpur dan Hidrolika Lumpur Pemboran	\N
828020102	Mengaplikasikan penyelenggaraan administrasi perkantoran	\N
822070102	Menerapkan besaran-besaran listrik rangkaian elektronika	\N
821090600	Pekerjaan Mesin Perkakas	\N
821170800	Teknik Pendingin Dasar	\N
817060107	Mengoperasikan peralatan pemboran	\N
817060108	Melakukan penyemenan casing	\N
817060109	Mendeskripsikan lumpur & hidrolika lumpur	\N
821130400	Pneumatik dan Hidrolik	\N
817120110	Konstruksi dan Utilitas Gedung	\N
825040202	Melakukan uji mutu & mensertifikasi benih tanaman.	\N
825040203	Melaksanakan berbagai teknik pembiakan	\N
825040204	Melaksanakan pemeliharaan tanaman	\N
825040206	Mengemas & mentransformasi bibit tanaman	\N
825040300	Pembibitan dan Kultur Jaringan Tanaman	\N
825060801	Mengidentifikasi kan&g ternak & peralatan	\N
825062105	Membuat & mengawetkan pakan ternak	\N
825062106	Merancang kan&g ternak & peralatan	\N
825060804	Membuat ransum ternak ruminansia	\N
825060806	Memeliharan bibit ternak ruminansia	\N
827350105	Menerapkan bangunan & stabilitas kapal	\N
825062104	Melakukan pemanenan hasil budidaya aneka ternak	\N
826050403	Menjelaskan tipe iklim & jenis tanah hutan	\N
825210109	Menganalisis proksimat bahan hasil pertanian	\N
825062107	Mengelola usaha aneka ternak	\N
825062108	Mengolah limbah aneka ternak	\N
825062109	Membibitkan aneka ternak	\N
825062110	Menjelaskan sistem organ tubuh aneka ternak	\N
825210105	Membuat & menstandarisasi larutan pereaksi	\N
825210106	Mengambil contoh hasil pertanian	\N
825210111	Menganalisis mutu air & limbah cair	\N
825210112	Menganalisis secara mikrobiologis bahan & produk pertanian	\N
825210113	Menguji mutu bahan & produk pertanian sesuai standar	\N
825210121	Mengenal komoditas hasil pertanian	\N
825210122	Menerapkan dasar lingkungan industri hasil pertanian	\N
825210123	Melaksanakan dasar-dasar pengawetan bahan hasil pertanian	\N
825210124	Melaksanakan dasar-dasar pengendalian mutu hasil pertanian	\N
825210125	Menerapkan teknik satuan operasi pengolhn hasil pertanian	\N
825250109	Melakukan analisis secara mikrobiologis	\N
825060802	Menyeleksi bibit ternak ruminansia	\N
826050405	Melakukan pengelolaan hutan	\N
825250700	Teknik Pengembangbiakan Komoditas Ikan Hias	\N
830130100	Perawatan Wajah dengan Teknologi	\N
825270200	Pengujian Mutu NonPangan & Limbah Industri PHPP	\N
825270300	Manajemen Pengendalian Mutu HPP	\N
825270600	Pengujian Secara Mikrobiologis	\N
826050402	Menjelaskan Hukum & Perun&g-un&gan Kehutanan	\N
827110100	Pesawat Bantu Kapal Perikanan (PBKP)	\N
826050408	Mengidentifikasi hutan rakyat	\N
827380107	Menghitung jasa penumpkn brg di terminal petikemas & gudang	\N
826050406	Mengidentifikasi pemanfaatan jasa lingk. & wisata kehutanan	\N
826050407	Menerapkan teknik konservasi tanah & air	\N
826050409	Mengidentifikasi flora fauna yang dilindungi	\N
827020100	Bangunan Stabilitas Kapal Perikanan (BSKP)	\N
827010109	Menjelaskan dasar-dasar elektronika & permesinan kapal	\N
827010110	Menerapkan oseanografi perikanan & meteorologi	\N
827010111	Menjelaskan bangunan kapal & stabilitas kapal	\N
827010112	Menerapkan penanganan hasil tangkap	\N
827010113	Menerapkan teknik penangkapan & tatalaksana perikanan 	\N
827010115	Mengoperasikan & merawat mesin pendingin & alat tangkap	\N
827010116	Mengops & merawat sstm kendali otomat. & kelistrikan kapal	\N
825260100	Teknik Pengambilan Contoh	\N
824060600	Manajemen Siaran Radio	\N
827110110	Pesawat Bantu Kapal Penangkap Ikan	\N
827110200	Motor Diesel dan Instalasi Tenaga Kapal Perikanan	\N
827350102	Menerapkan ilmu pelayaran datar	\N
825250300	Dekorasi Akuarium/Aquascape/Paludarium	\N
827350106	Menerapkan dasar-dasar keselamatan di laut	\N
827350107	Menerapkan penanganan & peraturan muatan	\N
827350108	Menjelaskan dasar-dasar elektronik & permesinan kapal	\N
827380102	Mengerjakan pengurusan dokumen kapal keluar pelabuhan	\N
827380106	Menghitung jasa labuh & tambat kapal	\N
999902521	Ketentuan Ekspor	KRS025
827380110	Menger.pengurusan pengiri. brg . melalui fas. EDI Bea Cukai	\N
827350104	Menerapkan meteorologi & oseanografi	\N
827390207	Menerapkan komunikasi maritim internasional	\N
830120100	Rias wajah Khusus dan Kreatif	\N
825250500	Teknik Pembesaran Komoditas Ikan Hias	\N
828080106	Menerapkan etika bisnis Islam	\N
829111106	Melakukan perencanaan produk roti & kue untuk diet khusus 	\N
828130100	Pemesanan Tempat (Airlines Resevation)	\N
829020500	Klerikal dan Komunikasi Industri Perhotelan	\N
829101009	Melaksanakan pengelolaan usaha jasa boga	\N
830070100	Pengeritingan dan Pelurusan Rambut	\N
828080107	Menerapkan prinsip dasar ekonomi Islam	\N
831060604	Membuat busana anak 	\N
831060606	Membuat pola (pattern making)	\N
831080806	Melakukan proses spreading, cutting, & bundelling	\N
834020107	Membuat relief teknik cetak tunggal & ganda	\N
839020149	Membakar benda keramik	\N
842030400	Pembuatan produk dengan teknik sekrol	\N
843010100	Apresiasi Musik Daerah/Keroncong/Pop	\N
824060300	Siaran Online	\N
826050404	Menerapkan teknik perencanaan hutan 	\N
825060805	Melakukan penanganan ternak ruminansia	\N
825010100	Dasar-dasar Budidaya Tanaman	\N
825010200	Alat Mesin Pertanian	\N
825010202	Menjelaskan sifat-sifat fisik tanah.	\N
825020100	Agribisnis Tanaman Pangan dan Palawija	\N
825020102	Membibitkan tanaman pangan & hortikultura	\N
830040107	Melakukan rias wajah khusus	\N
830050040	Perawatan Wajah (Beauty Aesthetic) pada SPA	\N
839040100	Pewarnaan	\N
828150111	Melakukan penataan layanan ruang rapat/seminar	\N
839070200	Sablon	\N
824051300	Sinematografi Dasar     	\N
843060946	Memainkan vokal sinden	\N
843060960	Memainkan vokal daerah	\N
843060915	Memainkan karawitan iringan/ilustrasi	\N
843060916	Memainkan karawitan Bangsi	\N
843060936	Memainkan instrumen gambang tingkat pengrawit	\N
843060937	Memainkan instrumen suling tingkat pengrawit	\N
843060919	Memainkan karawitan Gen&g	\N
843060920	Menden&gkan vokal Minang	\N
843060921	Menyanyikan vokal Minang	\N
843060922	Memainkan karawitan Saluang	\N
843060926	Memainkan karawitan Iringan Vokal	\N
843060927	Memainkan komposisi karawitan	\N
843060928	Membawakan sekar mamaos	\N
827390400	Elektronika (Electronics)	\N
827390500	Ilmu Bahan (Fabrication and Repair Material)	\N
843060933	Menabuh waditra kendang dlm gending . embat sawilet & kering	\N
843060934	Memainkan instrumen siter tingkat pengrawit	\N
843060935	Memainkan instrumen gender barung tingkat pengrawit	\N
843060913	Menyanyi vokal Makassar	\N
843060917	Memainkan karawitan Serunai	\N
843060938	Memainkan instrumen bonang barung tingkat pengrawit	\N
843060939	Memainkan karawitan bersama Yogyakarta	\N
843060940	Memainkan ricikan/instrumen individu rebab	\N
843060941	Memainkan ricikan/instrumen individu kendang	\N
843060942	Memainkan ricikan/instrumen individu gender	\N
843060943	Memainkan ricikan/instrumen individu gambang	\N
843060918	Memainkan karawitan Kecapi	\N
843060930	Membawakan lagu-lagu kawih	\N
843062400	Praktik Karawitan Daerah Setempat	\N
843060947	Memainkan vokal tembang	\N
843060948	Menabuh gong kebyar iringan tari	\N
843060956	Menyanyikan vokal daerah (tembang)	\N
843061300	Praktik Individu Instrumen Pokok	\N
843061310	Penguasaan Instrumen Pokok	\N
843061000	Teknik Karawitan Dasar	\N
843061100	PKB (Praktik Karawitan Bersama)	\N
843062300	Praktik Karawitan Daerah lain	\N
843061200	Kreativitas Karawitan	\N
843062200	Penciptaan Karawitan	\N
843061500	Teknik Instrumen Pokok	\N
999800401	Bahasa Indonesia	PKBM004
843061600	Metode Kepelatihan	\N
843061700	Tari bentuk	\N
843090400	Dasar Pemeranan	\N
843060945	Memainkan karawitan iringan	\N
843060912	Memainkan instrumen suling	\N
843063000	Tari Daerah Lain	\N
875160004	Melakukan pengukuran teknik	\N
843070110	Vokal Karawitan	\N
843070200	Teknik Vokal Dasar	\N
843080103	Melakukan olah vokal pedalangan	\N
843070500	Titilaras dan Vokal Dasar	\N
843070600	Pengetahuan Bahan dan Alat	\N
843070700	Ilmu Bentuk Analisis Karawitan	\N
843080100	Sastra Pedalangan	\N
843061110	Praktik Karawitan Iringan	\N
828080103	Mengelola akad transaksi 	\N
999901303	Level 3	KRS013
843090600	Tata artistik	\N
843060519	Menarikan tari Pajaga Gilireng & Pajoge Makkunrai	\N
843090500	Dasar Tata Artistik	\N
843060958	Menabuh gamelan semar pagulingan tabuh instrumental	\N
843090700	Dasar Komposisi	\N
845080100	Mengawasi Mutu Busana	\N
843062100	Penataan Karawitan Mandiri	\N
875160005	Melakukan pekerjaan pembubutan	\N
875160006	Melakukan pekerjaan frais	\N
875190100	Mesin Listrik Dan Kontrol Motor	\N
875200000	Elektronika Pesawat Udara	\N
875200002	Menggambar teknik listrik&elektronika dengan aplikasi komp.	\N
999902417	(MD-6) Pengawasan Interior	KRS024
843060929	Membawakan sekar kapasindhenan	\N
999800403	Ilmu Pengetahuan Sosial	PKBM004
999800404	Keterampilan Fungsional	PKBM004
999800405	Matematika	PKBM004
999800607	Muatan Lokal 	PKBM006
999800608	Pendidikan Agama	PKBM006
843040109	Membuat foto obyek lukisan dengan kamera digital	\N
875160003	Menggunakan perkakas tangan	\N
843070100	Vokal	\N
999906811	Unit Kompetensi Tambahan	KRS068
999907617	Teknik Komunikasi (MD-06)	KRS076
999907808	Level 8	KRS078
999907822	Administrasi (MD-04)	KRS078
999908006	Level 6	KRS080
843060944	Memainkan ricikan/instrumen individu siter	\N
843060914	Memainkan karawitan mandiri	\N
843061400	Pengetahuan Karawitan	\N
828180110	Perencanaan dan Pengelolaan Perjalanan Wisata	\N
843060557	Menarikan tari Panji Semirang	\N
828190101	Menerapkan pelayanan prima	\N
828190102	Memutakhirkan informasi industri pariwisata	\N
830140200	Perawatan Wajah, Badan (Body Massage) dan Waxing	\N
831010101	Melaksanakan proses persiapan penyempurnaan tekstil	\N
831010102	Melaksanakan proses penyempurnaan tekstil	\N
831010105	Melakukan proses pencapan	\N
831010300	Presentasi Kreasi Karya	\N
831020210	Teknologi Menjahit	\N
831020200	Dasar Teknologi Menjahit	\N
831060605	Menggambar busana (fashion drawing)	\N
831060607	Membuat busana wanita	\N
831060609	Memilih bahan baku busana 	\N
839070100	Cetak Saring	\N
831060611	Mengawasi mutu busana	\N
831070700	Pembuatan Pola	\N
831070800	Pembuatan Busana	\N
832010100	Sketsa dan Gambar	\N
830060200	Pemangkasan dan Pewarnaan Rambut	\N
830060100	Pemangkasan dan Penataan Rambut	\N
843011753	Menyusun harmoni SATB	\N
845010100	Membuat Pola (Pattern Making)	\N
843110300	Teknik Penghayatan Peran	\N
843011742	Orkestrasi	\N
875150006	Menerapkan aircraft maintenance practice and tools	\N
844010100	Menerapkan prosedur K3 dalam bekerja	\N
875200005	Menerapkan wiring kelistrikan pesawat udara	\N
999900510	Paket/Gaya	KRS005
845040100	Membuat Busana Anak	\N
845050100	Membuat Busana Bayi	\N
845060100	Memilih Bahan Baku Busana	\N
845070100	Membuat Hiasan pada Busana (Ebroidery)	\N
875150000	Air Frame dan Power Plant	\N
999900306	Level 6	KRS003
875160002	Menerapkan keselamatan penerbangan sipil 	\N
875160010	Menggambar 2 dimensi dengan auto CAD	\N
875150009	Melaksanakan perawatan aircraft system 	\N
875150010	Melakukan perawatan piston engine system and component	\N
875150011	Merawat turbine engine system and component 	\N
875150020	Pistone Engine	\N
875170000	Konstruksi Badan Pesawat Udara	\N
875160000	Pemesinan Pesawat Udara	\N
875160001	Menerapkan konsep teknologi pesawat udara	\N
875160011	Menggambar 3 dimensi dengan auto CAD	\N
875160007	Mengoperasikan mesin CNC	\N
843011752	Mengidentifikasi solfegio	\N
999900307	Level 7	KRS003
875170002	Menggunakan perkakas tangan & perkakas tangan bertenaga 	\N
875150003	Menerapkan konsep & prinsip aircraft drawing 	\N
875170003	Melakukan pengukuran	\N
875170005	Melakukan teknik las oksi asetilin	\N
875170006	Mengelas dengan proses las busur	\N
875170007	Membuat gambar bentangan /pemolaan	\N
875190004	Menerapkan rangkaian elektronika	\N
875190005	Mengoperasikan mesin-mesin listrik	\N
824051400	Tata Kamera	\N
875200006	Menerapkan sistem komunikasi pesawat udara	\N
845020100	Membuat Busana Wanita	\N
875200007	Menerapkan instrumen pesawat udara	\N
875200008	Menerapkan sistem mikrokomputer & controlling pesawat udara	\N
875200009	Mengoperasikan radio navigasi pesawat udara	\N
875201000	Pemeliharaan & Perbaikan Ins Elektronika Pesawat Udara	\N
999891002	Olahraga dan Kesehatan	PKBM009
843120700	Perawatan dan Penataan Rambut	\N
999900401	Level 1	KRS004
845030100	Membuat Busana Pria	\N
999900308	Level 8	KRS003
999900310	Paket/Gaya	KRS003
999900501	Level 1	KRS005
999900304	Level 4	KRS003
999900411	Unit Kompetensi Tambahan	KRS004
999900412	Belum Ada Modul	KRS004
999900507	Level 7	KRS005
999900502	Level 2	KRS005
999900503	Level 3	KRS005
999900504	Level 4	KRS005
999900505	Level 5	KRS005
999900506	Level 6	KRS005
999901309	Level 9	KRS013
999900509	Level 9	KRS005
999900601	Level 1	KRS006
999900511	Unit Kompetensi Tambahan	KRS005
999900602	Level 2	KRS006
999901301	Level 1	KRS013
999901308	Level 8	KRS013
830050400	Manicure, Padicure dan Waxing pada SPA	\N
999901310	Paket/Gaya	KRS013
999901311	Unit Kompetensi Tambahan	KRS013
999901312	Belum Ada Modul	KRS013
875201003	Menerapkan aircraft drawing	\N
999900312	Belum Ada Modul	KRS003
999908413	Etika dan perilaku (MD-2)	KRS084
999915098	Pendelegasian tugas dan tanggung jawab	KRS150
999915100	Jadwal Kerja (Time Schedule)	KRS150
999915049	Standar penilaian Kinerja	KRS150
999915133	Penilaian dan Penghargaan Prestasi kerja	KRS150
999916106	MD 6. Akuntansi perapajakan	KRS161
999916202	MD 2. Praktikum Komputerisasi Perpajakan 	KRS162
875150012	Merawat propeller	\N
830080100	Pewarnaan Rambut	\N
839050100	Batik	\N
830090100	Penataan Sanggul Tradisional dan Kreatif	\N
830110100	Manicure Pedicure Spa dan Nail Art	\N
830140100	Perawatan Badan dan Penjabutan Bulu	\N
831060608	Membuat busana bayi	\N
843011755	Mengoperasikan program komputer musik	\N
999900203	Level 3	KRS002
999900204	Level 4	KRS002
999900205	Level 5	KRS002
999900206	Level 6	KRS002
999900207	Level 7	KRS002
999901807	Level 7	KRS018
999881001	Keaksaraan Usaha Mandiri	PKBM008
999900211	Unit Kompetensi Tambahan	KRS002
999900605	Level 5	KRS006
999900301	Level 1	KRS003
999900302	Level 2	KRS003
999900303	Level 3	KRS003
999900603	Level 3	KRS006
999900702	Level 2	KRS007
999900703	Level 3	KRS007
999900606	Level 6	KRS006
999900612	Merawat Bayi	KRS006
999900614	Menjaga Bayi	KRS006
999901109	Level 9	KRS011
999902110	Paket/Gaya	KRS021
999900604	Level 4	KRS006
999900705	Level 5	KRS007
999900706	Level 6	KRS007
999900707	Level 7	KRS007
999900711	Unit Kompetensi Tambahan	KRS007
999900712	Belum Ada Modul	KRS007
999900802	Level 2	KRS008
999900908	Level 8	KRS009
999900803	Level 3	KRS008
999900805	Level 5	KRS008
999900806	Level 6	KRS008
999900807	Level 7	KRS008
999900808	Level 8	KRS008
999900809	Level 9	KRS008
999900901	Level 1	KRS009
999900902	Level 2	KRS009
999900903	Level 3	KRS009
999900904	Level 4	KRS009
999900907	Level 7	KRS009
999900909	Level 9	KRS009
999901012	Belum Ada Modul	KRS010
999900910	Paket/Gaya	KRS009
999900912	Belum Ada Modul	KRS009
999901001	Level 1	KRS010
999901002	Level 2	KRS010
999901003	Level 3	KRS010
999901004	Level 4	KRS010
999901006	Level 6	KRS010
999901008	Level 8	KRS010
999901009	Level 9	KRS010
999901708	Level 8	KRS017
999831001	Keaksaraan Dasar	PKBM003
999901103	Level 3	KRS011
999901104	Level 4	KRS011
999901105	Level 5	KRS011
999901106	Level 6	KRS011
999901110	Paket/Gaya	KRS011
999900704	Level 4	KRS007
999901112	Belum Ada Modul	KRS011
999901201	Level 1	KRS012
999901202	Level 2	KRS012
999901204	Level 4	KRS012
999901207	Level 7	KRS012
999901208	Level 8	KRS012
999901209	Level 9	KRS012
999901212	Huruf Jepang 2	KRS012
999901505	Level 5	KRS015
999901011	Unit Kompetensi Tambahan	KRS010
999900208	Level 8	KRS002
999900202	Level 2	KRS002
999901904	Level 4	KRS019
999901905	Level 5	KRS019
999901507	Level 7	KRS015
999901906	Level 6	KRS019
999901907	Level 7	KRS019
999901908	Level 8	KRS019
825062500	Anatomi dan Fisiologi Hewan	\N
999902101	Level 1	KRS021
999902103	Level 3	KRS021
999902105	Level 5	KRS021
999902115	Produksi Acara TV (MD-04)	KRS021
999902106	Level 6	KRS021
999902112	Teknik Kamera TV (MD-01)	KRS021
999901307	Level 7	KRS013
999902117	Teknik Komunikasi (MD-06)	KRS021
999902113	Komposisi Gambar (MD-02)	KRS021
999902201	Level 1	KRS022
999902202	Level 2	KRS022
999902203	Level 3	KRS022
999902204	Level 4	KRS022
999902205	Level 5	KRS022
999902208	Level 8	KRS022
999915101	Pengawasan Kerja	KRS150
999901903	Level 3	KRS019
999902217	Kebersihan diri dan lingkungan (MD-6)	KRS022
999902109	Level 9	KRS021
999902213	Etika dan Perilaku (MD-2)	KRS022
999902218	Istirahat dan tidur (MD-7)	KRS022
999902219	Sterilisasi dan desinfeksi (MD-8)	KRS022
999902220	Gizi (MD-9)	KRS022
999902302	Level 2	KRS023
999902303	Level 3	KRS023
999902304	Level 4	KRS023
999902305	Level 5	KRS023
999902306	Level 6	KRS023
999902307	Level 7	KRS023
999902308	Level 8	KRS023
999902309	Level 9	KRS023
999902102	Level 2	KRS021
999901102	Level 2	KRS011
999891004	Seni dan Budaya	PKBM009
999900209	Level 9	KRS002
999891001	Ilmu Pengetahuan dan Teknkologi	PKBM009
999900210	Paket/Gaya	KRS002
999900701	Level 1	KRS007
999900801	Level 1	KRS008
999900201	Level 1	KRS002
999902516	Pengangkutan udara	KRS025
999901603	Level 3	KRS016
999901605	Level 5	KRS016
999901606	Level 6	KRS016
999902508	Level 8	KRS025
999901608	Level 8	KRS016
999901709	Level 9	KRS017
999901801	Level 1	KRS018
999901802	Level 2	KRS018
999901803	Level 3	KRS018
999901804	Level 4	KRS018
999901805	Level 5	KRS018
999901806	Level 6	KRS018
999901808	Level 8	KRS018
999901810	Paket/Gaya	KRS018
999901901	Level 1	KRS019
999901909	Level 9	KRS019
999901912	Belum Ada Modul	KRS019
999901405	Level 5	KRS014
999901408	Level 8	KRS014
999902301	Level 1	KRS023
800000176	Teknik Logistik	\N
999902316	Pengantar Teknik II DG?SP-04	KRS023
999902317	Etika Kerja DG?SP-05	KRS023
999902319	Membaca Brief  DG-01	KRS023
999902320	Metodologi Riset DG-02	KRS023
999902321	Komputer Grafis DTP DG-03	KRS023
999902322	Teori Dasar Layout DG-04	KRS023
999902323	Prinsip Desain DG-05	KRS023
999902324	Tipografi DG-06	KRS023
999902326	Finished Artwork DG-08	KRS023
999902328	Teknik Komunikasi DG-10	KRS023
999902329	Komputer Grafis Vektor DG-11	KRS023
999902330	Teori Warna DG-12	KRS023
999902401	Level 1	KRS024
999902402	Level 2	KRS024
999902403	Level 3	KRS024
999902405	Level 5	KRS024
999902406	Level 6	KRS024
999902407	Level 7	KRS024
999902507	Level 7	KRS025
999901410	Paket/Gaya	KRS014
999902530	Menghitung Biaya Impor	KRS025
999902806	Level 6	KRS028
800000175	Teknik Pengendalian Produksi	\N
843060559	Menarikan tari Pendet	\N
843060560	Menarikan tari Tarunajaya	\N
999902531	Pengisian Dokumen Impor	KRS025
999902528	Asuransi Kargo	KRS025
999902532	Belum Ada Modul	KRS025
999902602	Level 2	KRS026
999902526	Ketentuan umum dibidang impor	KRS025
999902510	Paket/Gaya	KRS025
999902603	Level 3	KRS026
999902608	Level 8	KRS026
999902609	Level 9	KRS026
999902610	Paket/Gaya	KRS026
999902702	Level 2	KRS027
999902703	Level 3	KRS027
999902705	Level 5	KRS027
999902706	Level 6	KRS027
999902707	Level 7	KRS027
999902801	Level 1	KRS028
999902802	Level 2	KRS028
999902803	Level 3	KRS028
999902804	Level 4	KRS028
999902805	Level 5	KRS028
999902807	Level 7	KRS028
999903001	Level 1	KRS030
999902808	Level 8	KRS028
999902902	Level 2	KRS029
999902903	Level 3	KRS029
999902904	Level 4	KRS029
999902923	Mentalitas Dasar (Mdu)	KRS029
999903002	Level 2	KRS030
999901604	Level 4	KRS016
999903003	Level 3	KRS030
999903004	Level 4	KRS030
999903005	Level 5	KRS030
999903006	Level 6	KRS030
999903008	Level 8	KRS030
999903010	Paket/Gaya	KRS030
999903011	Unit Kompetensi Tambahan	KRS030
999903012	Belum Ada Modul	KRS030
999903101	Level 1	KRS031
999903102	Level 2	KRS031
999903201	Level 1	KRS032
999902501	Level 1	KRS025
999902118	Pedoman Umum K3 (MD-07)	KRS021
843060558	Menarikan tari Panyembrama	\N
800000172	Teknik Pengelasan Kapal	\N
200040020	Kearifan Lokal	\N
800000177	Teknik Audio Video	\N
800000187	Desain Rancang Bangun Kapal	\N
800000174	Teknik Fabrikasi Logam dan Manufaktur	\N
200041020	Aku Cinta Indonesia, Kearifan Lokal	\N
800000178	Teknik Mekatronika	\N
800000180	Teknik Otomasi Industri	\N
800000181	Teknik Elektronika Komunikasi	\N
800000182	Instrumentasi Medik	\N
800000189	Konstruksi Kapal Non Baja	\N
999901712	Belum Ada Modul	KRS017
800000188	Konstruksi Kapal Baja	\N
999902408	Level 8	KRS024
800000192	Analisis Pengujian Laboratorium	\N
200040030	Bhineka Tunggal Ika	\N
999902108	Level 8	KRS021
999901404	Level 4	KRS014
999901602	Level 2	KRS016
999902107	Level 7	KRS021
999901508	Level 8	KRS015
999901601	Level 1	KRS016
999902511	Unit Kompetensi Tambahan	KRS025
999903501	Level 1	KRS035
999902524	Jenis Pembayaran Ekspor-Impor	KRS025
999902525	Permohonan pembukaan L/C impor	KRS025
999902701	Level 1	KRS027
999903103	Level 3	KRS031
999902709	Level 9	KRS027
999902712	Belum Ada Modul	KRS027
999902809	Level 9	KRS028
999902905	Level 5	KRS029
999902907	Level 7	KRS029
999902908	Level 8	KRS029
999903007	Level 7	KRS030
999903105	Level 5	KRS031
999902514	L/C	KRS025
999903106	Level 6	KRS031
999903107	Level 7	KRS031
999903109	Level 9	KRS031
999903110	Paket/Gaya	KRS031
999903306	Level 6	KRS033
999903202	Level 2	KRS032
999903203	Level 3	KRS032
999903204	Level 4	KRS032
999903205	Level 5	KRS032
999903206	Level 6	KRS032
999903207	Level 7	KRS032
999903210	Paket/Gaya	KRS032
999903303	Level 3	KRS033
999903304	Level 4	KRS033
999903305	Level 5	KRS033
999903104	Level 4	KRS031
999903412	Persiapan Berkendara (MP MKB 01)	KRS034
999903119	Teknik Pelaporan (MDIII-8)	KRS031
999903503	Level 3	KRS035
800000186	Electrical Avionic	\N
999903708	Level 8	KRS037
999903701	Level 1	KRS037
999903504	Level 4	KRS035
999903506	Level 6	KRS035
999903507	Level 7	KRS035
999903509	Level 9	KRS035
999903510	Paket/Gaya	KRS035
999903511	Unit Kompetensi Tambahan	KRS035
999903601	Level 1	KRS036
999903602	Level 2	KRS036
999903603	Level 3	KRS036
999903604	Level 4	KRS036
999903605	Level 5	KRS036
999903606	Level 6	KRS036
999903608	Level 8	KRS036
999903610	Paket/Gaya	KRS036
999903702	Level 2	KRS037
800000200	Teknik Pembangkit Tenaga Listrik	\N
999903704	Level 4	KRS037
999903705	Level 5	KRS037
999903706	Level 6	KRS037
999903707	Level 7	KRS037
999903709	Level 9	KRS037
999903901	Level 1	KRS039
999903911	Unit Kompetensi Tambahan	KRS039
999903801	Level 1	KRS038
999903802	Level 2	KRS038
999903803	Level 3	KRS038
999903807	Level 7	KRS038
999903808	Level 8	KRS038
999903809	Level 9	KRS038
999903810	Paket/Gaya	KRS038
999903811	Unit Kompetensi Tambahan	KRS038
999903812	Belum Ada Modul	KRS038
999903902	Level 2	KRS039
999904314	Proses dan Tahapan Editing (MD.3)	KRS043
999903903	Level 3	KRS039
999903904	Level 4	KRS039
999903905	Level 5	KRS039
999903906	Level 6	KRS039
999903908	Level 8	KRS039
999903912	Belum Ada Modul	KRS039
999903710	Paket/Gaya	KRS037
999904207	Level 7	KRS042
999904209	Level 9	KRS042
999904303	Level 3	KRS043
999904304	Level 4	KRS043
999904305	Level 5	KRS043
999904309	Level 9	KRS043
999904311	Unit Kompetensi Tambahan	KRS043
999904318	Grammar of the Edit (MD.7)	KRS043
999902512	Sales contract	KRS025
999902413	(MD-2) Tiga Dimensi	KRS024
999904319	Teknik Komunikasi (MD.8)	KRS043
999903909	Level 9	KRS039
800000197	Teknik Pembuatan Kain	\N
800000193	Teknik Kimia Industri	\N
800000194	Kimia Tekstil	\N
800000198	Teknik Penyempurnaan Tekstil	\N
200040060	Rekayasa dan Teknologi	\N
800000185	Airframe Powerplant	\N
800000199	Teknik Instalasi Tenaga Listrik	\N
800000201	Teknik Jaringan Tenaga Listrik	\N
999904316	Metodologi evaluasi (MD.5)	KRS043
200040010	Gaya Hidup Berkelanjutan	\N
200040050	Suara Demokrasi	\N
800000195	Teknik Pembuatan Serat Filamen	\N
843060562	Menarikan tari Tenun	\N
999902601	Level 1	KRS026
999902520	K3	KRS025
999902513	Aplikasi Letter of credit	KRS025
999902502	Level 2	KRS025
999902503	Level 3	KRS025
999902504	Level 4	KRS025
999902505	Level 5	KRS025
999904605	Level 5	KRS046
999904010	Paket/Gaya	KRS040
999903429	Tanggung Jawab Pengemudi Pemula (MD-08)	KRS034
999903910	Paket/Gaya	KRS039
999903406	Level 6	KRS034
999904204	Level 4	KRS042
999904012	Belum Ada Modul	KRS040
999904101	Level 1	KRS041
999904103	Level 3	KRS041
999904107	Level 7	KRS041
999904104	Level 4	KRS041
999904201	Level 1	KRS042
999904604	Level 4	KRS046
999904301	Level 1	KRS043
999904109	Level 9	KRS041
999904202	Level 2	KRS042
999904203	Level 3	KRS042
999904009	Level 9	KRS040
999904211	Unit Kompetensi Tambahan	KRS042
999904212	Belum Ada Modul	KRS042
999904302	Level 2	KRS043
999905001	Level 1	KRS050
999904321	Belum Ada Modul	KRS043
999904401	Level 1	KRS044
999904402	Level 2	KRS044
827160100	Kesehatan Biota Air	\N
999904405	Level 5	KRS044
999903407	Level 7	KRS034
999904210	Paket/Gaya	KRS042
999904505	Level 5	KRS045
999904508	Level 8	KRS045
999904509	Level 9	KRS045
999904510	Paket/Gaya	KRS045
999904511	Unit Kompetensi Tambahan	KRS045
999904601	Level 1	KRS046
999904905	Level 5	KRS049
800000160	Teknik Mekanik Industri	\N
999905103	Level 3	KRS051
999904608	Level 8	KRS046
999904810	Paket/Gaya	KRS048
999904816	Pemupukan	KRS048
999904725	Pajak Penghasilan Badan 	KRS047
999904726	PPh Pasal 26	KRS047
999904727	Pajak Internasional	KRS047
999904729	Belum Ada Modul	KRS047
999904809	Level 9	KRS048
843060565	Menarikan tari putri	\N
999903405	Level 5	KRS034
999904817	Pemangkasan Tanaman	KRS048
999904818	Penyulaman Tanaman	KRS048
999904819	Pembersihan Taman	KRS048
999905419	Teknik Komunikasi (MD-08)	KRS054
999904902	Level 2	KRS049
999905108	Level 8	KRS051
999904904	Level 4	KRS049
999904906	Level 6	KRS049
999904907	Level 7	KRS049
999904910	Paket/Gaya	KRS049
999904911	Unit Kompetensi Tambahan	KRS049
999904912	Belum Ada Modul	KRS049
999905002	Level 2	KRS050
999905119	Fotografi Studio (FG-V-2)	KRS051
999905003	Level 3	KRS050
999905006	Level 6	KRS050
999905007	Level 7	KRS050
999905008	Level 8	KRS050
999905009	Level 9	KRS050
999905101	Level 1	KRS051
999905102	Level 2	KRS051
999905104	Level 4	KRS051
999905109	Level 9	KRS051
999904501	Level 1	KRS045
999905201	Level 1	KRS052
999905112	Fotografi Dasar (FG-III-1)	KRS051
999905117	K3 (kesehatan, keselamatan kerja) (FG-III-6)	KRS051
999905118	Ilmu Komunikasi Dasar (FG-V-1)	KRS051
999905120	Fotografi Model Manusia (FG-V-3)	KRS051
999905122	Fotografi Arsitektur (FG-V-5)	KRS051
999905124	Fotografi Ilustrasi (FG-V-7)	KRS051
999905408	Level 8	KRS054
999905125	Fotografi Lanskap (FG-V-8)	KRS051
999905126	Olah Digital (FG-V-9)	KRS051
999905127	Teknik Presentasi (FG-V-10)	KRS051
999905412	Public Speaking (MD-01)	KRS054
999904602	Level 2	KRS046
999904903	Level 3	KRS049
999904502	Level 2	KRS045
999904721	PPN dan PPnBM	KRS047
999905411	Unit Kompetensi Tambahan	KRS054
999905202	Level 2	KRS052
999904108	Level 8	KRS041
999905105	Level 5	KRS051
800000204	Teknik Kelistrikan Kapal	\N
999904724	Pemeriksaan Bea dan Cukai 	KRS047
800000158	Desain dan Teknik Furnitur	\N
800000214	Pengembangan Gim	\N
800000207	Teknik Geomatika	\N
800000208	Informasi Geospasial	\N
800000206	Teknik Energi Biomassa	\N
800000159	Teknik Pemesinan	\N
999905410	Paket/Gaya	KRS054
800000162	Desain Gambar Mesin	\N
843060564	Menarikan tari Wiranata & Wirayuda	\N
999904102	Level 2	KRS041
999904106	Level 6	KRS041
999903427	Prosedur Keselamatan (MD-06)	KRS034
999903428	Spesifikasi Kendaraan (MD-07)	KRS034
999903408	Level 8	KRS034
999903416	Teknologi Otomotif (MP MKB 05)	KRS034
999903417	Prosedur Keselamatan (MP MKB 06)	KRS034
999903422	Persiapan Berkendara (MD-01)	KRS034
827200100	Teknik Pembesaran Ikan	\N
999905707	Level 7	KRS057
999800612	Sejarah	PKBM006
843120300	Tata Suara	\N
843060567	Menarikan tari gagah	\N
875150004	Menerapkan konsep electrical, instrument,electronic&digital 	\N
843060569	Menyusun gerak tari/koreografi	\N
827370500	Komunikasi	\N
999901402	Level 2	KRS014
843120200	Tata Busana	\N
999901711	Unit Kompetensi Tambahan	KRS017
999901403	Level 3	KRS014
999904803	Level 3	KRS048
999903404	Level 4	KRS034
999902410	Paket/Gaya	KRS024
999902519	Aplikasi pengisian dokumen ekspor	KRS025
999904506	Level 6	KRS045
999904801	Level 1	KRS048
999903414	Pemahaman Peraturan Lalu Lintas (MP MKB 03)	KRS034
999904507	Level 7	KRS045
999904603	Level 3	KRS046
999905114	Penyinaran Dasar (FG-III-3)	KRS051
999904806	Level 6	KRS048
999905012	Belum Ada Modul	KRS050
999905113	Komposisi Dasar (FG-III-2)	KRS051
999905801	Level 1	KRS058
999904807	Level 7	KRS048
999904808	Level 8	KRS048
999904815	Penyiraman	KRS048
999904909	Level 9	KRS049
999905004	Level 4	KRS050
999905010	Paket/Gaya	KRS050
999905106	Level 6	KRS051
999905107	Level 7	KRS051
999904408	Level 8	KRS044
999904802	Level 2	KRS048
999905422	Bahasa Indonesia (MD-11)	KRS054
999904410	Paket/Gaya	KRS044
999905505	Level 5	KRS055
999905503	Level 3	KRS055
999905510	Paket/Gaya	KRS055
999905504	Level 4	KRS055
843120100	Tata Rias	\N
999905603	Level 3	KRS056
999905513	Pedoman Pelayanan Pijat Refleksi (MD-02)	KRS055
999905423	Manajemen Keartisan (MD-12)	KRS054
999905519	Anatomi musculoskeletal (MD-08)	KRS055
999905521	Dasar Pengobatan Pijat Refleksi Indonesia (MD-10)	KRS055
999906209	Level 9	KRS062
999905601	Level 1	KRS056
999905604	Level 4	KRS056
999905605	Level 5	KRS056
999905915	Etika Profesi (MD. 4)	KRS059
999905704	Level 4	KRS057
999905606	Level 6	KRS056
999905607	Level 7	KRS056
999905608	Level 8	KRS056
999905609	Level 9	KRS056
999905610	Paket/Gaya	KRS056
999905612	Belum Ada Modul	KRS056
999905701	Level 1	KRS057
999905702	Level 2	KRS057
999905708	Level 8	KRS057
999906112	Belum Ada Modul	KRS061
999905918	Koreografi I (MD. 3)	KRS059
999905706	Level 6	KRS057
999905710	Paket/Gaya	KRS057
999905712	Belum Ada Modul	KRS057
999905502	Level 2	KRS055
999906201	Level 1	KRS062
999905919	SCBI Jenjang III (MD. 4)	KRS059
999905802	Level 2	KRS058
999905910	Paket/Gaya	KRS059
999905803	Level 3	KRS058
999905905	Level 5	KRS059
999905908	Level 8	KRS059
999905909	Level 9	KRS059
999905922	Biomekanik (MD. 7)	KRS059
999905602	Level 2	KRS056
999905703	Level 3	KRS057
999905906	Level 6	KRS059
999905705	Level 5	KRS057
999905920	Cidera Olahraga (MD. 5)	KRS059
999905921	Anatomi (MD. 6)	KRS059
999905923	Ilmu Kepelatihan (MD. 8)	KRS059
843060572	Melagukan vokal tembang	\N
999906401	Level 1	KRS064
999905709	Level 9	KRS057
999906202	Level 2	KRS062
999906203	Level 3	KRS062
999906205	Level 5	KRS062
999906206	Level 6	KRS062
999906207	Level 7	KRS062
999904804	Level 4	KRS048
999906212	Belum Ada Modul	KRS062
999906301	Level 1	KRS063
999906302	Level 2	KRS063
999905501	Level 1	KRS055
800000211	Teknik Pemboran Minyak dan Gas	\N
843060571	Memainkan karawitan	\N
807021500	Aircraft Electronic Drawing	\N
999901811	Unit Kompetensi Tambahan	KRS018
843060566	Menarikan tari alus	\N
843060577	Memainkan instrumen Pokok Gender tingkat Pengrawit	\N
843060578	Memainkan karawitan (PKB) Calung tingkat Pengrawit	\N
843060570	Melakukan tata rias & busana	\N
843060574	Menarikan tari daerah lain (Bali,Sunda,Surakarta,& Banyumas)	\N
827390206	Mengoperasikan & merawat sistm kntrl & sistm kelistrikan kpl	\N
827390600	Mesin Penggerak Utama (Main Propulsion Engine)	\N
839030100	Desain Produk 	\N
999906540	Etika Profesi (MDUIII-8)	KRS065
999902411	Unit Kompetensi Tambahan	KRS024
999903308	Level 8	KRS033
999904407	Level 7	KRS044
999905903	Level 3	KRS059
999906605	Level 5	KRS066
999905806	Level 6	KRS058
999905526	Manajemen pelayanan pijat refleksi (MD-15)	KRS055
999905527	Pelaporan dan rujukan (MD-16)	KRS055
999905804	Level 4	KRS058
999905418	Costumer Relation (MD-07)	KRS054
999906516	Inovasi Kue Kontinental MDO-2)	KRS065
999905904	Level 4	KRS059
999906607	Level 7	KRS066
999906303	Level 3	KRS063
999906517	Teknik Pengukuran (MDU-4)	KRS065
999906304	Level 4	KRS063
999905901	Level 1	KRS059
999906608	Level 8	KRS066
999906308	Level 8	KRS063
999906309	Level 9	KRS063
999906310	Paket/Gaya	KRS063
999906312	Belum Ada Modul	KRS063
827380100	Penanganan dan Pengaturan Muatan (PPM)	\N
999906305	Level 5	KRS063
830050300	Perawatan Badan (Body Treatment) Pada SPA	\N
999906503	Level 3	KRS065
999906506	Level 6	KRS065
999906716	Penataan Sanggul hairpiece (MD-05)	KRS067
999906510	Paket/Gaya	KRS065
999906534	Pemasaran Produk Roti (MDUIII-7)	KRS065
999906520	Pengetahuan Resep (MDO III-5)	KRS065
999906522	Higiene dan Sanitasi (MDU-3)	KRS065
999906523	Pengetahuan Bahan Makanan (MDC-3)	KRS065
999906524	Pengetahuan Bahan Aditif (MDU-5)	KRS065
999906525	Etika Profesi (MPUIII-8)	KRS065
999906526	Pengolahan Roti & Penyajian Roti (MDRIII-1)	KRS065
999906528	(MDU-2)	KRS065
999906529	Higiene dan Sanitasi & Pengetahuan Bahan Makanan (MDU-3)	KRS065
999906532	(MDR-5)	KRS065
999905524	Konseling dalam Pelayanan Pijat Refleksi (MD-13)	KRS055
999905522	Diagnosa dan Rencana Terapi (MD-11)	KRS055
999906536	Pengendalian Biaya & Inovasi Dekorasi Kue dan Coklat (MDU-2)	KRS065
999906539	Pengetahuan Dasar Dekorasi  Pastry (MDD-6)	KRS065
999906541	Belum Ada Modul	KRS065
999906606	Level 6	KRS066
999906601	Level 1	KRS066
999906602	Level 2	KRS066
999906603	Level 3	KRS066
999906604	Level 4	KRS066
999906615	Diagnosa Kulit Tangan (MD.4)	KRS066
999906614	Diagnosa Kulit Wajah (MD.3)	KRS066
999906612	Persiapan Area Kerja dan Pengemasan (MD.1)	KRS066
999906610	Paket/Gaya	KRS066
999906611	Unit Kompetensi Tambahan	KRS066
999906434	MD 5 Melakukan Depilasi menggunakan Krim Depilasi	KRS064
827380104	Melaksanakan bongkar muat barang curah & pdt di pelabuhan	\N
827390100	Mtr Diesel & Instalasi Tenaga Kapal Niaga (MDITKN)	\N
999906505	Level 5	KRS065
999906504	Level 4	KRS065
999906626	Merias Wajah Geriatri (MD.7)	KRS066
999906627	Merias Wajah Sikatri (MD.8)	KRS066
999906707	Level 7	KRS067
999906708	Level 8	KRS067
999906709	Level 9	KRS067
999906710	Paket/Gaya	KRS067
999906711	Unit Kompetensi Tambahan	KRS067
999906713	Pencucian Rambut (MD-02)	KRS067
999906806	Level 6	KRS068
999906507	Level 7	KRS065
999906533	Pengetahuan dasar dekorasi roti (MDU-6)	KRS065
999906718	Pemangkasan rambut dasar (MD-02)	KRS067
999906719	Pengeritingan rambut dasar (MD-03)	KRS067
999906732	Penataan Sanggul Daerah (MD-09)	KRS067
999906801	Level 1	KRS068
999906802	Level 2	KRS068
999906803	Level 3	KRS068
999906804	Level 4	KRS068
999906805	Level 5	KRS068
999906808	Level 8	KRS068
999906807	Level 7	KRS068
999906717	Pegetahuan Penunjang Penata Kecantikan Rambut (MD-01)	KRS067
999906809	Level 9	KRS068
999906810	Paket/Gaya	KRS068
999906812	Membuat perlengkapan riasan pengantin 	KRS068
999903611	Unit Kompetensi Tambahan	KRS036
999906609	Level 9	KRS066
999905805	Level 5	KRS058
999906307	Level 7	KRS063
827390200	Kelistrikan, Sis Pngndlian & Otmtsasi Kpl Niaga	\N
827390201	Mengoperasikan&merawat mesin penggerak utama, pesawat bantu	\N
999905417	Leadership (MD06)	KRS054
827390202	Menerapkan dasar-dasar keselamatan kerja di laut	\N
827390203	Menerapkan bahan teknik & dasar gambar teknik	\N
827390204	Menerapkan kerja bengkel	\N
827390205	Menerapkan dinas jaga di atas kapal	\N
828010101	Menjelaskan prinsip-prinsip bisnis	\N
828010102	Melakukan penataan produk	\N
828010104	Melaksanakan proses administrasi transaksi	\N
828010106	Melaksanakan penagihan pembayaran	\N
999906909	Level 9	KRS069
828010107	Mengoperasikan peralatan transaksi di lokasi penjualan	\N
828010109	Membuka usaha eceran/ritel (expansion store opening)	\N
828070200	Otomatisasi Tata Kelola Kepegawaian	\N
828070100	Administrasi Kepegawaian	\N
999906502	Level 2	KRS065
999906432	MD 3 Melakukan Perawatan Punggung (Back Treatment)	KRS064
821090310	Gambar Kapal Kayu dan Fiberglass	\N
999906501	Level 1	KRS065
828080102	Mengelola siklus akuntansi jasa & dagang 	\N
999906822	Menyusun perencanaan biaya rias pengantin 	KRS068
999906816	Menetapkan biaya rias pengantin 	KRS068
999907502	Level 2	KRS075
827360200	Komunikasi dan Isyarat (Isyarat &Communication)	\N
999906910	Paket/Gaya	KRS069
999907325	Terapi Moksa (MD-15)	KRS073
804150600	Sistem Pneumatik dan Hidrolik	\N
999907003	Level 3	KRS070
999906902	Level 2	KRS069
999906903	Level 3	KRS069
999906904	Level 4	KRS069
999906509	Level 9	KRS065
999906905	Level 5	KRS069
999906906	Level 6	KRS069
999906908	Level 8	KRS069
999908107	Level 7	KRS081
999907312	Esensi perencanaan TCM (MD- 01)	KRS073
999906912	Belum Ada Modul	KRS069
999907001	Level 1	KRS070
999907005	Level 5	KRS070
999907621	Produksi (MD-02)	KRS076
999907006	Level 6	KRS070
999907009	Level 9	KRS070
999907010	Paket/Gaya	KRS070
999907011	Unit Kompetensi Tambahan	KRS070
999908504	Level 4	KRS085
999907103	Level 3	KRS071
999907008	Level 8	KRS070
999907104	Level 4	KRS071
999907105	Level 5	KRS071
999907311	Unit Kompetensi Tambahan	KRS073
999907510	Paket/Gaya	KRS075
999907317	Penyebab dan Proses Penyakit (MD-06)	KRS073
999907321	Diferensiasi Sindrom TCM (MD-10)	KRS073
999907323	Terapi Tuina Chuzhen (MD-13)	KRS073
999907318	Prinsip Terapi (MD-07)	KRS073
999907319	Prinsip Pencegahan (MD-08)	KRS073
999907503	Level 3	KRS075
999907410	Paket/Gaya	KRS074
999907613	Pengetahuan alat dan bahan (MD-02)	KRS076
827380103	Mengerjakan bongkar muat di petikemas di terminal petikemas	\N
827390800	Perawatan dan Perbaikan Permesinan Kapal 	\N
999907501	Level 1	KRS075
999907508	Level 8	KRS075
843120400	Tata Cahaya	\N
999907314	Fenomena Organ (MD-03)	KRS073
999906817	Memakaikan busana pengantin pria dan wanita 	KRS068
999907506	Level 6	KRS075
999907509	Level 9	KRS075
999907504	Level 4	KRS075
999907603	Level 3	KRS076
999906901	Level 1	KRS069
999907605	Level 5	KRS076
999907606	Level 6	KRS076
999907608	Level 8	KRS076
999907609	Level 9	KRS076
999907610	Paket/Gaya	KRS076
999907612	Ragam motif sulam (MD-01)	KRS076
999907615	Teknik tusuk hias (MD-04)	KRS076
999907820	Produksi (MD-02)	KRS078
999907616	Pelayanan Prima (MD-05)	KRS076
999907618	Prosedur K3 (MD-07)	KRS076
999907619	Pola ragam hias (MD-08)	KRS076
999907620	Membuat Desain (MD-01)	KRS076
999907622	Packaging  (MD-03)	KRS076
999907624	Ragam Motif sulam  (MD-05)	KRS076
999907625	Desain tekstil  (MD-06)	KRS076
999907626	Pengetahuan alat sulam  (MD-07)	KRS076
999907627	Teknik komunikasi  (MD-08)	KRS076
999907004	Level 4	KRS070
999908509	Level 9	KRS085
999908108	Level 8	KRS081
999908109	Level 9	KRS081
999908409	Level 9	KRS084
999908410	Paket/Gaya	KRS084
999907604	Level 4	KRS076
999908913	Announcement	KRS089
999908510	Paket/Gaya	KRS085
999907324	Terapi Kop (MD-14)	KRS073
999908513	Sistem-sistem engine (MD-02)	KRS085
999908106	Level 6	KRS081
999907102	Level 2	KRS071
828080100	Administrasi Keuangan	\N
828010105	Melakukan penyerahan/pengiriman produk	\N
827391000	Sistem Kelistrikan Kapal (Marine Electrical System)	\N
827391100	Sistem Kontrol (Control System)	\N
827400100	Pesawat Bantu Kapal Niaga (PBKN)	\N
827410200	Dinas Jaga Pemesinan Kapal Niaga	\N
828010100	Pengantar Ekonomi dan Bisnis	\N
828150101	Melakukan pelayanan prima	\N
828150103	Mengidentifikasi sumber-sumber informasi industry pariwisata	\N
828150105	Melakukan pelaynn porter&jsa valet pd tamu sscr provisional	\N
999907901	Level 1	KRS079
828150106	Melakukan layanan reservasi 	\N
828150107	Melakukan layanan akomodasi reception	\N
830050100	Dasar Kecantikan Rambut	\N
831010103	Mengidentifikasi zat warna & zat pembantu	\N
828080120	Menerapkan etika dalam pelayanan nasabah	\N
828080113	Menerapkan prinsip dasar perbankan syariah	\N
999908012	Modul Layanan Pelanggan (ED-01.03)	KRS080
999908104	Level 4	KRS081
999908528	Engine management system (MD-2)	KRS085
999907818	Prosedur K3 (MD-07)	KRS078
999907823	Ragam Motif Bordir (MD-05)	KRS078
999907824	Pengetahuan Dasar Mesin Bordir (MD-07)	KRS078
999907825	Teknik Komunikasi (MD-08)	KRS078
999907826	Pelayanan Prima (MD-09)	KRS078
999908537	Logika matematika (MD-11)	KRS085
999908308	Level 8	KRS083
999908207	Level 7	KRS082
999908023	Modul Transistor Unipolar (ED-02.09)	KRS080
999908027	Modul Audio Amplifier (ED-02.13)	KRS080
999907705	Level 5	KRS077
999908101	Level 1	KRS081
999908105	Level 5	KRS081
999908418	Istirahat dan tidur (MD-7)	KRS084
999908110	Paket/Gaya	KRS081
999908111	Unit Kompetensi Tambahan	KRS081
999908206	Level 6	KRS082
999908208	Level 8	KRS082
999908307	Level 7	KRS083
999908306	Level 6	KRS083
999908402	Level 2	KRS084
999908403	Level 3	KRS084
999908309	Level 9	KRS083
999908310	Paket/Gaya	KRS083
999908401	Level 1	KRS084
999908404	Level 4	KRS084
999907816	Pelayanan prima (MD-05)	KRS078
999908405	Level 5	KRS084
999908406	Level 6	KRS084
999908407	Level 7	KRS084
999908024	Modul SCR, DIAC dan Triac (ED-02.10)	KRS080
999908417	Kebersihan diri dan lingkungan (MD-6)	KRS084
999907817	Teknik komunikasi (MD-06)	KRS078
999908904	Level 4	KRS089
999908420	Gizi (MD-9)	KRS084
999908421	Tanda Vital (MD-10)	KRS084
999905404	Level 4	KRS054
999908506	Level 6	KRS085
999908507	Level 7	KRS085
999908508	Level 8	KRS085
999908905	Level 5	KRS089
828080111	Mengelola administrasi pajak	\N
999910116	Mengelola Administrasi Pajak Penghasilan Pasal 21	KRS101
999908605	Level 5	KRS086
999908524	Sistem kelistrikan body (MM-6)	KRS085
999908525	Overhaul angine (MM-7)	KRS085
828080110	Mengelola laporan keuangan bank syariah	\N
828140100	Sanitasi, Hygiene dan Keselamatan Kerja	\N
999908529	Air induction system (MD-3)	KRS085
999908533	Sistem electronic power steering (MD-7)	KRS085
999908535	Teknik komunikasi dalam bahasa Indonesia dan Inggris (MD-9)	KRS085
999908521	Sistem pemindah tenaga (MM-3)	KRS085
999908538	Pemograman computer (MD-12)	KRS085
999908909	Level 9	KRS089
999908606	Level 6	KRS086
999908607	Level 7	KRS086
999908608	Level 8	KRS086
999908609	Level 9	KRS086
999908610	Paket/Gaya	KRS086
999908518	Ilmu terapan dasar (MD-7)	KRS085
999908908	Level 8	KRS089
828150100	Industri Perhotelan	\N
999908903	Level 3	KRS089
999908522	Sistem chasis (MM-4)	KRS085
999908902	Level 2	KRS089
999908910	Paket/Gaya	KRS089
999908912	Aviation Security	KRS089
999908914	CASR	KRS089
999909103	Penanaman	KRS091
999908520	Sistem bahan bakar diesel (MM-2)	KRS085
999908919	Emergency Procedures	KRS089
999908920	Flight Safety	KRS089
999908921	Emergency Equipment	KRS089
999908922	Kesamaptaan	KRS089
999908926	Basic Indoc	KRS089
999908927	Food and Beverage	KRS089
999909001	Belum Ada Modul	KRS090
999909101	K3LH	KRS091
999909401	Belum Ada Modul	KRS094
999909301	Belum Ada Modul	KRS093
999908918	Cabin Practice	KRS089
999908916	Rules and Regulations	KRS089
999908505	Level 5	KRS085
831010104	Melaksanakan proses pencelupan kain & benang	\N
828150104	Melakukan kom.dgn konsumen melalui telp atau surat menyurat	\N
828080114	Mengelola administrasi biaya produksi	\N
828130110	Pemesanan Tempat, Tour Leader, dan Spesial Event	\N
999908011	Unit Kompetensi Tambahan	KRS080
828080112	Mengelola komputer akuntansi	\N
999907704	Level 4	KRS077
831080808	Melakukan pemasangan kancing	\N
831080810	Melakukan proses finishing	\N
999910011	Cara Mudah Membuat Email Blast	KRS100
831080811	Melaksanakan kendali & penjaminan kualitas	\N
831080900	Pengembangan Bisnis Busana	\N
831101400	Gambar	\N
831101200	Dasar-dasar Desain Kriya	\N
999910004	Teknik Penyajian Isi dari Kanal Pemasaran	KRS100
999910106	Mengelola Administrasi Kas dan Bank	KRS101
831111100	Pengetahuan Alat dan Bahan 	\N
832020100	Sketsa	\N
999908907	Level 7	KRS089
831080802	Memilih bahan baku tekstil	\N
999908925	Aircraft Type Rating	KRS089
999909104	Pemeliharaan	KRS091
999909106	Non modul	KRS091
999909201	Belum Ada Modul	KRS092
999909502	Komunikasi dalam Bahasa Inggris dengan keluarga klien	KRS095
999909601	Belum Ada Modul	KRS096
999909505	Pencatatan Status kesehatan dan kegiatan klien dalam Bahasa Inggris	KRS095
999911902	Pedoman rencana siar ( MP ? 2 )	KRS119
999909801	Belum Ada Modul	KRS098
831090900	Pembuatan Busana (custom-made)	\N
999909901	Belum Ada Modul	KRS099
999910001	Pengenalan Pemasaran Digital	KRS100
999910003	WEB 2.0	KRS100
999910007	Profesionalisme Kerja	KRS100
999910008	Perencanaan Pemasaran Digital	KRS100
999911904	Pedoman operasional peralatan siaran ( MP - 4 )	KRS119
999910009	Strategi Berjualan di Internet	KRS100
999910010	Teknik Pembuatan Website untuk E-Commers	KRS100
999910104	Program Pengolahan angka/ Spreadsheet	KRS101
999910114	Mengelola Administrasi Persediaan	KRS101
999910013	Pengelolaan Bisnis Mandiri	KRS100
999910101	Mengelola Jurnal	KRS101
999910102	Buku Besar	KRS101
999910105	Program Aplikasi Komputer Akuntansi	KRS101
999910107	Mengelola Administrasi Dana Kas Kecil	KRS101
999910006	Pemasaran digital melalui pasar niaga elektronik	KRS100
843010712	Memainkan repertoar dalam tangga nada mayor	\N
843060520	Menarikan tari Pakarena Anida & Jangang Lea-Lea	\N
999910113	Mengelola Administrasi Piutang	KRS101
999908924	CRM	KRS089
999911903	Pedoman penulisan (rewriting ) ( MP - 3 )	KRS119
999910119	Mengelola Administrasi Pajak Badan	KRS101
999911407	MP-8   Pengepresan dan Penyetrikaan	KRS114
999910111	Mengelola Buku Besar Perusahaan Industri	KRS101
999910012	Cara Mudah Membuat Content Video	KRS100
999910611	Kasus kasus keadaan darurat (MD-10)	KRS106
999910707	Jejaring Dalam Pelayanan  (MD-7)	KRS107
999910703	Metode Pijat Tradisional Indonesia (MD-3)	KRS107
999910704	Cara memeriksa kondisi klien (MD-4)	KRS107
999910714	Anatomi umum, otot dan pergerakan nya (MD-10)	KRS107
999908917	English Aviation	KRS089
999910710	Prosedure Pijat Urut Relaksasi dan Kebugaran (MD-5)	KRS107
999910711	Prosedure Pijat Urut mengatasi nyeri pergerakan (MD-6)	KRS107
999910713	Manajemen Praktis Pelayanan Jasa Pijat (MD-9)	KRS107
999910715	Belum Ada Modul	KRS107
999909701	Belum Ada Modul	KRS097
999910801	Belum Ada Modul	KRS108
999911409	Teknik Menjahit Berbagai Busana 	KRS114
999911004	Mengkomunikasikan informasi (MP3-4)	KRS110
999911005	Melakukan pemanduan di obyek wisata (MP3-5)	KRS110
999911010	Menyusun rencana perjalanan wisata (MP 3-10)	KRS110
999911011	Menyiapkan informasi wisata (MP 3-11)	KRS110
999911012	Menyiapkan perangkat perjalanan (MP 3-12)	KRS110
999911014	Membuat laporan pemanduan wisata (MP 3-14)	KRS110
999911015	Memimpin perjalanan wisata (MP 3-15)	KRS110
999911101	Belum Ada Modul	KRS111
999911201	Menyiapkan Tempat Kerja (MD-01)	KRS112
999911202	Menjahit dengan alat jahit tangan (MD-02)	KRS112
999910701	Pedoman Pelayanan Pijat (MD-1)	KRS107
831101000	Dasar-dasar Desain	\N
999911801	Belum Ada Modul	KRS118
999910702	Prinsip dasar pengobatan tradisional Indonesia(MD-2)	KRS107
999911905	Ilmu komunikasi ( MP ? 5 )	KRS119
999911906	Pedoman Kinerja Penyaiar (MP ? 6 )	KRS119
830040108	Melakukan pengangkatan bulu yg tidak dikehendaki (depilasi)	\N
999910120	Penyajian Laporan Harga Pokok Produksi	KRS101
830040110	Melakukan rias wajah utk keg. event (foto/tv/film...)	\N
999912001	Kesadaran Tentang NKRI dan Pancasila (MD-01)	KRS120
999910121	Penyajian Laporan Keuangan Konsolidasi	KRS101
999910301	Bahan Baku Produk Olahan Ikan	KRS103
830040106	Melakukan perawatan kulit wajah bermasalah secara manual	\N
831010106	Melaksanakan proses penyempurnaan fisika & kimia	\N
831080803	Memodifikasi pola atau blok	\N
831080809	Melakukan proses fusing	\N
831080804	Menyesuaikan ukuran pola	\N
831101300	Desain Produk	\N
831080805	Membuat marker	\N
834010100	Relief	\N
834020100	Pembuatan Patung	\N
834020104	Membuat desain patung teknik manual	\N
834020106	Membuat relief teknik pahat & modelling	\N
836020109	Melaksanakan finishing pekerjaan bahan batu	\N
834020109	Membuat patung teknik cetak tunggal & ganda	\N
839020100	Dasar Kekriyaan	\N
834020110	Melaksanakan pameran seni patung	\N
834020200	Patung	\N
835010100	Reproduksi	\N
835010300	Desain Patung 3D	\N
836020100	Desain Interior dan landscaping	\N
836020103	Menggambar dengan perangkat lunak CAD	\N
836020104	Melaksanakan pekerjaan kayu	\N
836020105	Melaks.finishing desain prod. Int.& landscaping bhn kayu	\N
836020106	Melaksanakan pekerjaan logam	\N
836020108	Melaksanakan pekerjaan batu	\N
837030100	Desain Interior	\N
999912113	MP13. Tata Tertib Perusahaan	KRS121
837030200	Dasar Desain Interior dan Teknik Furnitur	\N
839010100	Pengetahuan Bahan 	\N
839020102	Membuat gambar berbagai jenis produk kria tekstil	\N
999912912	MD-3  Alat Layanan Khusus (service special tools)	KRS129
839020103	Mewarna pd kain & serat	\N
840020120	Pembentukan dengan Teknik Langsung	\N
999911203	Menjahit dengan alat jahit mesin mono fungsi (jahit lurus) (MD-03)	KRS112
999911204	Evaluasi dan revisi hasil kerja (fitting) (MD-04)	KRS112
999911205	Penyeterikaan (MD-05)	KRS112
999911206	Kesehatan dan Keselamatan Kerja (MD-06)	KRS112
999911207	Pengetahuan Bahan Pakaian (MD-07)	KRS112
999911208	Komunikasi (MD-08)	KRS112
999912620	(MP-20) Pemrograman AGV	KRS126
999911410	MP-11 Pemeliharaan Mesin Jahit	KRS114
999911411	MP-12 Standar Mutu Busana 	KRS114
999911703	MD 3  Pengetahuan Teks Tari 	KRS117
999911704	MD 4  Manajemen Seni Pertunjukan	KRS117
999911705	MD 5  Pendidikan Tari 	KRS117
999911706	MD 6  Penyajian Tari	KRS117
999911707	MD 7  Penataan Tari 	KRS117
999911709	MD 9  Manajemen Pertunjukan Tari	KRS117
999911710	MD 10  Wirausaha	KRS117
999912002	Komunikasi (MD-02)	KRS120
999912313	Belum Ada Modul	KRS123
999912008	Panduan Tata Rias Wajah dan Rambut untuk presentasi Televisi (MD-08)	KRS120
831010200	Pengetahuan Bahan Tekstil	\N
999912303	Teknik Pemutihan limbah dan unsur tanaman (MP 3) 	KRS123
999912923	Air Induction System (MA-3)	KRS129
999912009	Panduan KeterampilanSerasi Berbusana  (MD-09)	KRS120
999912305	Pembuatan bunga dari limbah dan unsur tanaman  (MP 5)	KRS123
832030200	Seni Lukis Realis	\N
999912308	Pembuatan bunga dari limbah dan unsur tanaman (MP 2) 	KRS123
999912309	Merangkai bunga pada wadah sesuai dengan 8 bentuk pola dasar (MP 3)	KRS123
999912312	Pembuatan poutporri (MP 6)	KRS123
999912913	MD-4  Peralatan Penunjang Bengkel (workshop equipment)	KRS129
999912401	MD 1. Sarana Penunjang 	KRS124
999912402	MD 2. Pengantar Teori Warna	KRS124
999912425	Teknik merangkai bunga pola dasar bentuk crescent	KRS124
999912623	(MP-23) Material Bahan Prototipe 3D	KRS126
999912611	(MP-11) Sistem Perancangan HRC	KRS126
999912618	(MP-18) Sistem Perancangan AGV	KRS126
999912616	(MP-16) Manajemen Data pada Sistem Robot Industri	KRS126
999912603	(MP-3)   Wewenang dan Tanggung Jawab Kerja	KRS126
999912605	(MP-5)   Pemeliharaan Berkala	KRS126
999912606	(MP-6)   Teknik Presentasi Produk	KRS126
999912607	(MP-7)   Evaluasi Produk	KRS126
999912608	(MP-8)   Sistem Robot Industrial Manipulator	KRS126
999912609	(MP-9)   Perakitan Sistem Robot Manipulator	KRS126
999912610	(MP-10) Pemrograman Sistem Robot Manipulator	KRS126
999912612	(MP-12) Pemrograman HRC	KRS126
999912602	(MP-2)   Prosedur Keamanan Kerja	KRS126
999912613	(MP-13) Sistem Perancangan IoT 	KRS126
999912615	(MP-15) Sinkronisasi Data	KRS126
999912619	(MP-19) Perakitan AGV	KRS126
999912621	(MP-21) Petunjuk Kerja Pengoperasian AGV	KRS126
831080800	Pembuatan Busana (Industri)	\N
831080801	Melaksanakan pelayanan prima 	\N
999912624	(MP-24) Software Desain 3D	KRS126
999912426	Teknik merangkai bunga pola dasar bentuk  lengkung terbalik simetris	KRS124
999912304	Teknik pewarnaan  (MP 4)	KRS123
999912005	Panduan Operasional Komputer (MD-05)	KRS120
999912431	T. Merangkai bunga modifikasi mass line arrangement grs melengkung dg grs lurus	KRS124
999912601	(MP-1)   Perkembangan Robot Industri	KRS126
875190006	Membuat rangkaian kontrol motor	\N
834020108	Membuat patung teknik pahat & ketok	\N
832030100	Seni Lukis Dekoratif	\N
834020105	Membuat rencana dengan teknik komputer	\N
832030300	Seni Lukis Non Realis	\N
832030400	Seni Lukis dinding (Mural/Mosaik)	\N
833010100	Digital Painting/Imaging	\N
833020100	Desain Tiga Dimensi	\N
839020169	Melakukan kerja perhiasan (jewellery)	\N
839020170	Melakukan finishing kria logam	\N
839060100	Tenun	\N
839100100	Produk Alas Kaki	\N
843050600	Musik Teknologi	\N
839100200	Alas Kaki Kulit dan Imitasi	\N
839120100	Produk Kulit Tatah Sungging	\N
839120200	Tatah Sungging Kulit	\N
839130100	Produk Busana Kulit	\N
840010100	Pengolahan Tanah Liat	\N
840020110	Pembentukan dengan Teknik Cetak	\N
842040200	Kerja Finishing	\N
999912905	Sistem kelistrikan body dan engine (MD-5)	KRS129
999913717	MD.17 Keterampilan representasi diri	KRS137
840030100	Dekorasi Keramik	\N
840040100	Pengglasiran Benda Keramik	\N
840050100	Pembakaran Benda Keramik	\N
841010100	Pembuatan Perhiasan	\N
842010100	Dekorasi dan Kethok Pembentukan	\N
842020100	Penyiapan bahan produksi kriya kayu	\N
842020181	Melaksanakan teknik kerja bangku	\N
999900610	Paket/Gaya	KRS006
999913703	MD.3 Dasar-dasar pengukuran	KRS137
839090100	Makrame	\N
842040300	Teknik Kerja Bangku	\N
842040100	Melakukan finishing kriya kayu	\N
842040400	Teknik Kerja Mesin	\N
842040500	Teknik Kerja Ukir	\N
999912904	Sistem chasis dan suspense (MD-4)	KRS129
842030300	Pembuatan produk dengan teknik bubut	\N
999912906	Keselamatan dan Kesehatan Kerja (MD-6)	KRS129
999912907	Ilmu terapan dasar (MD-7)	KRS129
999800512	Seni Budaya	PKBM005
999901306	Level 6	KRS013
999913205	Pemasangan Peralatan Plambing (MP.III-5)	KRS132
999902116	Sistem Peralatan Produksi Acara TV (MD-05 	KRS021
999914305	Pemrograman Aplikasi Menggunakan Database (MD.IV-05)	KRS143
999913111	Pembuatan Mortar Pasangan Bata (MD. 4)	KRS131
999913112	Pembuatan Dinding Pasangan Bata (MD. 5)	KRS131
839020143	Membentuk keramik dengan tangan	\N
999913209	Pelaporan (MP.III-9)	KRS132
999913114	Pembuatan Pasangan Bata Dekoratif (MD. 8)	KRS131
999913202	Persiapan Pemasangan Perpipaan (MP.III-2)	KRS132
999913203	Pemasangan dan Penyambungan Pipa Air Bersih (MP.III-3)	KRS132
999913206	Pemeriksaan Sistem Plambing (MP.III-6)	KRS132
999912925	Sistem Final Drive/Gardan LSD(Limited Slip Deferential) (MA-5)	KRS129
999913207	Pengujian dan Komisioning (MP.III-7)	KRS132
999913208	Pemeliharaan dan Perawatan (MP.III-8)	KRS132
999913301	MD-1 Prinsip Pengembangan Game	KRS133
999913113	Pembuatan Pasangan bata lengkung (MD. 7)	KRS131
999913302	MD-2 Pedoman Dasar Pemrograman Game	KRS133
999913303	MD-3 Sikap dan Komunikasi Pengembangan Game	KRS133
999913304	MD-1 Dasar Pemrograman Gim	KRS133
999913305	MD-2 Desain Gim	KRS133
999913306	MD-3 Pembuatan Aset Gim	KRS133
999913307	MD-4 Pengembangan Gim	KRS133
999913308	MD-5 Pengujian Gim	KRS133
999913309	MD-6 Monetisasi Gim	KRS133
999913501	Gambar Teknis Perancah (MP-02.01)	KRS135
999913502	Prinsip Perancah  (MP-02.02)	KRS135
999913503	Pemasangan dan Pembongkaran Perancah (MP-02.03)	KRS135
999913506	Perencanaan Perancah (MP-03.01)	KRS135
999913507	Pelaksanaan Pekerjaan Perancah (MP-03.02)	KRS135
999913508	Supervisi Perancah (MP-03.03)	KRS135
999913509	Evaluasi Pekerjaan Perancah (MP-03.04)	KRS135
999913510	Tugas, Hak dan Tanggung Jawab (MP-03.05)	KRS135
999913511	Keselamatan dan Kesehatan Kerja (MP-03.06)	KRS135
802031500	Teknik Pengolahan Audio	\N
999914605	Analisis data dalam pembuatan desain web (MD.IV-5)	KRS146
999913110	Persiapan Pekerjaan Pemasangan Bata (MD. 2)	KRS131
999914310	Pemrograman Aplikasi Menggunakan koneksi Wi-Fi (MD.IV-10)	KRS143
999914405	Teknik komunikasi efektif (MD-5)	KRS144
839080100	Jahit	\N
999914502	Komunikasi kerja (MD.IV-2)	KRS145
999914508	Terminologi bidang multimedia/ Glossary (MD.IV-8)	KRS145
999914509	Penggunaan Perangkat Keras Multimedia (MD.IV-9)	KRS145
999914510	Tanggung jawab dan hak (MD.IV-10)	KRS145
999914602	Desain antarmuka halaman web (MD.IV-2)	KRS146
999914306	Pemrograman Aplikasi Menggunakan Kamera (MD.IV-06)	KRS143
999914604	Desain responsif halaman web (MD.IV-4)	KRS146
999913708	MD.8 Sistem Sensor	KRS137
999914603	Konsep Desain Halaman Web (MD.IV-3)	KRS146
999914501	Pengenalan produk multimedia (MD.IV-1)	KRS145
842020182	Melaksanakan pekerjaan ukir kayu	\N
840020130	Pembentukan dengan Teknik Putar Centering	\N
839020162	Membuat produk kria logam dengan teknik canai	\N
839020163	Mengecor logam dalam berbagai bentuk	\N
840020100	Pembentukan Benda Keramik	\N
839020167	Menghias logam dengan berbagai teknik 	\N
839020168	Melakukan pembubutan logam	\N
843010700	Program Acara Musik (Live Show)	\N
842020185	Membuat produk kria kayu teknik skrolling	\N
843040104	Membuat lukisan kaca	\N
843010711	Membaca notasi musik (teori musik)	\N
843010400	Ilmu bentuk Analisa Musik	\N
843010720	Piano Wajib	\N
843011000	Dasar Penguasaan Instrumen Pokok	\N
843011751	Menerapkan teori musik (membaca notasi musik)	\N
843010300	Pengetahuan Dasar Seni Musik	\N
843020100	Seni Budaya	\N
843030100	Wawasan Seni dan Desain	\N
843060505	Memainkan tari: Glipang (Probolinggo)	\N
843040100	Seni Lukis Modern	\N
843040102	Membuat lukisan tradisional & lukisan modern	\N
843040103	Membuat lukisan mixed media	\N
843040105	Membuat lukisan mosaik	\N
999915037	Cara memilih bahan untuk pengembangan resep 	KRS150
843040106	Membuat lukisan air brush	\N
843050100	Teori Musik	\N
843050200	Apresiasi Musik	\N
843050700	Keyboard	\N
843060100	Pengetahuan Seni Tari	\N
843060400	Dasar Tari	\N
843010710	PIP Klasik	\N
843060500	Tari Tradisi	\N
843060502	Memainkan tari: Jejer/Paju Gandrung (Banyuwangi)	\N
999913701	MD.1 Pedoman penggunaan Work Order (Perintah kerja)	KRS137
999914101	Belum Ada Modul	KRS141
843060300	Iringan Tari	\N
999913818	Modul Layanan Pelanggan (MDP)	KRS139
999914506	Penyajian / presentasi produk Multimedia (MD.IV-6)	KRS145
999913819	Modul K3 ( MK3 )	KRS139
999913820	Teknik Peng-Bor-an (HPS-07)	KRS139
999913821	Teknik Memasang & melepas (Re-build)(HPS-08)	KRS139
999914001	Belum Ada Modul	KRS140
999914201	MP1 K3L dan APD	KRS142
401110220	Biologi (Perikanan dan Kelautan)	\N
999914202	MP2 Bongkar Pasang Bodi Kendaraan 	KRS142
999914205	MP5 Persiapan Permukaan Bodi Kendaraan	KRS142
999914206	MP6 Pengecatan Bodi Kendaraan	KRS142
999914207	MP7 Polishing Finishing	KRS142
999914208	MP8 Etika Kerja	KRS142
999914301	Algoritma dan Pemrograman  (MD.IV-1)	KRS143
999914503	Identifikasi elemen multimedia (MD.IV-3)	KRS145
999914702	Algoritma Pemrogram  (MP.IV-2)	KRS147
999915036	Aneka resep yang dikembangkan (Fusion Recipe)	KRS150
999914507	Penawaran jasa pembuatan produk multimedia (MD.IV-7)	KRS145
999905401	Level 1	KRS054
999914606	Pengujian dan penilaian desain web (MD.IV-6)	KRS146
999914608	Hak atas kekayaan intelektual (MD.IV-8)	KRS146
999915029	Tanggung jawab pekerjaan	KRS150
999914504	Perangkat Lunak Multimedia (MD.IV-4)	KRS145
999914607	Kerjasama dalam tim (MD.IV-7)	KRS146
100011010	Al-Qur'an 	\N
100011020	Hadits	\N
843012000	Ansambel Dasar	\N
999915041	Cara pengolahan makanan untuk jamuan prasmanan	KRS150
999915042	Aneka resep hari-hari besar	KRS150
401251350	Administrasi Barang	\N
999905402	Level 2	KRS054
401110000	Ilmu Pengetahuan Alam (Terapan)	\N
100011040	Akhlak	\N
100011050	Ushul Fiqih	\N
401000000	Matematika (Umum)	\N
401100000	Ilmu Pengetahuan Alam (IPA)	\N
401251370	Pelayanan Penjualan	\N
401110100	Ilmu Pengetahuan Alam (Biologi)	\N
100011030	Aqidah	\N
401110300	Biologi Perikanan	\N
843010713	Memainkan repertoar dalam tangga nada minor	\N
401120000	Ilmu Pengetahuan Alam (Fisika)	\N
401121000	Fisika	\N
401251160	Pengelolaan Kas	\N
401251170	Akuntansi Dasar	\N
401251380	Penataan Produk	\N
401251200	Pengelolaan Usaha Pemasaran	\N
401251210	Strategi Pemasaran	\N
401251320	Pengetahuan Produk	\N
401251330	Penataan Barang Dagangan	\N
401251340	Komunikasi Bisnis	\N
401251360	Administrasi Transaksi	\N
802031105	Memproduksi animasi 2D	\N
801030900	Terapi Lanjut Usia	\N
802031106	Memproduksi animasi 3D	\N
801030600	Gerontik	\N
801031300	Rehabilitasi Sosial Disabilitas	\N
801031400	Pengetahuan Dasar Pekerjaan Sosial	\N
802031102	Menggambar (life drawing)	\N
802031107	Melakukan produksi media	\N
999913816	Modul Trouble Shoting Software (MTS)	KRS139
801031000	Pemberdayaan Lanjut Usia	\N
802031108	Melakukan pembuatan game sederhana	\N
802031110	Animasi 2D	\N
802031200	Teknik Animasi 3 Dimensi	\N
802031210	Animasi 3D	\N
802031300	Komposisi Foto Digital	\N
802031400	Teknik Pengambilan Gambar Bergerak	\N
999915040	Metode pelatihan kompetisi kuliner	KRS150
843060200	Olah Tubuh Tari	\N
843010600	Dasar Teknologi Musik	\N
843100200	Olah Suara	\N
843010200	Solfegio	\N
843011700	PIP Non Klasik	\N
843010500	Organologi	\N
843060512	Menarikan tari Bosara	\N
843060513	Menarikan tari Dao Bulan	\N
843060516	Menarikan tari Ma'randing	\N
806010400	Kontrol Refrigerasi dan Tata Udara	\N
843060517	Menarikan tari Marellau Pammase Dewata	\N
843060526	Menarikan tari Layang-Layang Gusmiati Suid	\N
401251221	Aplikasi Pengolah Angka/Spreadsheet	\N
401251230	Pemasaran On_Line	\N
401251220	Paket Program Pengolah Angka/Spreadsheet	\N
803040200	Instalasi Jaringan Kabel	\N
401251300	Marketing	\N
401251310	Prinsip-Prinsip Bisnis	\N
803030600	Komunikasi bergerak/Seluler	\N
802031104	Melakukan pra produksi animasi	\N
803040600	Teknik Instalasi Kabel Rumah/Gedung (IKR/IKG)	\N
803040300	Instalasi Kabel Rumah/Gedung	\N
803040100	Perencanaan Jaringan Kabel	\N
803040400	Teknik Instalasi Jaringan Akses Radio (JARLOKAR)	\N
803040500	Teknik Instalasi Jaringan Akses Tembaga (JARLOKAT)	\N
803080500	Transmisi dan Instrumen Komunikasi	\N
805010603	Menerapkan dasar-dasar gambar teknik	\N
803041100	Pengukuran Trafik Telekomunikasi	\N
803041200	Networking NGN	\N
803041300	Instalasi di Pelanggan (CPE)	\N
803041400	Instalasi VSAT	\N
803041500	Merancang Jaringan Akses Telekomunikasi	\N
803041501	Menerapkan teknis projek telekomunikasi	\N
804051001	Menerapkan dasar ilmu bangunan	\N
803050102	Melaksanakan pengukuran besaran listrik & gambar teknik	\N
803080200	Perencanaan dan Instalasi Sistem Pemancar	\N
803080300	Perencanaan & Instalasi Atena Pemancar &Penerima	\N
803040900	Dasar Perencanaan Jaringan Akses Pelanggan	\N
803080501	Menjelaskan dasar-dasar sistem telekomunikasi	\N
803041000	Instalasi VOIP	\N
803080503	Melaksanakan pekerjaan ins. antena & perangkat pendukungnya	\N
803080505	Menerapkan ins. perangkat radio & pendukungnya	\N
843030500	Tinjauan Seni	\N
803080507	Melaksanakan ins. antena & feeder di base station	\N
803080600	Teknik Telepon	\N
803080700	Piranti Sensor & Aktuator	\N
803080800	Sistem Kontrol Elektromekanik & Elektronik	\N
803080900	Sistem Kontrol Terprogram	\N
803080910	Sistem Kontrol Otomatik	\N
803081000	Sistem Kontrol Elektropnumatik	\N
804051000	Teknik Konstruksi Furnitur	\N
805010200	Pengantar Survey Pemetaan	\N
804130200	Teknik Penyambungan Logam	\N
804110400	Teknik Gambar Manufaktur	\N
806010500	Refrigerasi/Pendinginan	\N
805010100	Surveying	\N
805010610	Menerapkan fotogrametri dalam pembuatan peta	\N
805010400	Penginderaan Jauh	\N
804110900	Dasar Perancangan Teknik Mesin	\N
805010600	Aplikasi Sistem Informasi Geografis (SIG)	\N
805010601	Menerapkan keselamatan & kesehatan kerja (K3)	\N
805010602	Menerapkan dasar-dasar survei & pemetaan	\N
805010604	Melaksanakan pengukuran posisi vertikal 	\N
825210140	Melakukan pengendalian mutu hasil perikanan	\N
805010605	Melaksanakan pengukuran posisi horizontal	\N
805010609	Menentukan posisi dengan media satelit	\N
808070712	Memperbaiki sistem-sistem elektronik pd kendaraan	\N
805010500	Sistem Informasi Geografis (SIG)	\N
805010800	Kartografi	\N
805010900	Survei Terestris Geomatika	\N
806010100	Proteksi Jaringan Tenaga Listrik	\N
806010200	Sistem dan Instalasi Refrigerasi	\N
806010300	Sistem dan Instalasi Tata Udara	\N
803080502	Melaksanakan peker.ins. pd panel koneksi di ruangtransmisi	\N
401251240	Pengelolaan Bisnis Ritel	\N
806010600	Tata Udara/AC	\N
808070706	Memperbaiki sistem suspensi aktif	\N
820100104	Menggunakan workshop equipment	\N
804110800	Teknik Pemesinan CNC	\N
805010700	Survei Terestris Geospasial	\N
820100105	Melaksanakan pekerjaan dasar listrik	\N
821061011	Mengoperasikan mesin-mesin las otomatis	\N
821061012	Melakukan pemeriksaan & pengujian hasil las	\N
821061100	Menggambar secara manual	\N
821061300	Gambar dengan Perangkat lunak	\N
821061400	Gambar Sistem Pemesinan dan Perlengkapan Kapal	\N
822060107	Melakukan proses finishing perbaikan bodi otomotif	\N
825061200	Agribisnis Pembibitan Ternak Unggas	\N
843030400	Dasar-dasar Kreativitas	\N
825061301	Merancang kan&g ternak unggas & peralatan	\N
825061304	Melakukan pemeliharaan unggas pedaging	\N
825061305	Membuat ransum ternak unggas	\N
825061100	Agribisnis Pakan Ternak Unggas	\N
843030300	Manajemen Seni Pertunjukan	\N
843060514	Menarikan tari Galaganjur	\N
843060506	Memainkan tari daerah lain: Gambyong	\N
843060507	Memainkan tari daerah lain: Enggar-enggar/Karonsih	\N
843060509	Memainkan tari daerah lain: Panji Semirang	\N
843060510	Melaksanakan tata teknis pentas: tata rias & busana	\N
843060529	Menarikan tari San&g Pangan & Nelayan Huriah Adam	\N
843060522	Menarikan tari Patteunung & Patuddu Sarawa&g	\N
999906431	MD 2 Perawatan Pijat Relaksasi Internasional	KRS064
843060554	Menarikan tari Jauk Keras & Jauk Manis	\N
843060536	Menarikan tari Rantak Kudo	\N
843060547	Menarikan Tari Topeng Priangan	\N
999907814	Dasar seni dan desain (MD-03)	KRS078
843060537	Menarikan tari Sado	\N
843060540	Melaksanakan praktek menabuh iringan tari	\N
843060541	Menata/mendesain rias & busana Tari Sunda	\N
843060552	Menarikan tari Baris Tunggal	\N
843060548	Menarikan Tari Pencak Silat	\N
999901302	Level 2	KRS013
999907703	Level 3	KRS077
843060549	Menarikan Tari Jaipongan	\N
843060550	Menarikan Tari Topeng Cirebon	\N
843060551	Menarikan Oleg Tambulilingan	\N
843060553	Menarikan tari Condong Legong Keraton	\N
999906408	Level 8	KRS064
843060556	Menarikan tari Legong Guak Macok, Jobog, & Lasem	\N
843060528	Menarikan tari In&g Sungai Garinggiang	\N
843060534	Menarikan tari Mancak Koto Anao	\N
999912003	Tata Bahasa (MD-03)	KRS120
843060525	Menarikan tari Galambang Pa&g Laweh	\N
999908515	Sistem chasis dan suspense (MD-4)	KRS085
999908534	Sistem kelistrikan body yang dikontrol secara elektronik	KRS085
809010207	Membuat output image	\N
999912103	MP3. Teori Dasar Produksi Acara Televisi	KRS121
999912104	MP4. Artistik	KRS121
999912105	MP5. Teknologi Broadcasting Televisi	KRS121
821090300	Perakitan Konstruksi Kapal Fiberglass	\N
999912106	MP6. Pengantar Ilmu Komunikasi	KRS121
821061003	Membaca gambar teknik	\N
828030102	Menerapkan komunikasi bisnis	\N
820100108	Menggunakan hydraulic & pneumatic system	\N
820100109	Melaksanakan pekerjaan dasar engine	\N
820100110	Melaksanakan pekerjaan disel engine system	\N
820100200	Engine dan Unit Alat Berat	\N
821061005	Melakukan pekerjaan dengan mesin umum	\N
820100107	Menggunakan dasar hydraulic & pneumatic system	\N
820100106	Melaksanakan pekerjaan dasar komponen ototronik	\N
821080207	Melakukan fabrikasi untuk aluminium	\N
821080202	Melakukan gambar teknik perkapalan	\N
821061009	Mengelas tingkat lanjut dengan las busur manual	\N
821061010	Mengelas tingkat lanjut dengan las MIG (GMAW) & TIG (GTAW)	\N
821061007	Mengelas dengan las Oksigen-Asetilen (Las Karbit)	\N
821080204	Melakukan teknik pengerjaan kayu	\N
821080205	Menggunakan perkakas kerja kayu	\N
821080206	Melakukan pekerjaan laminasi fiberglass	\N
821080208	Menggunakan perkakas kerja aluminium	\N
821080500	Merawat Mesin Kerja Kayu	\N
821090200	Pembuatan Komponen Konstruksi Kapal Fiberglass	\N
821061006	Melakukan pengelasan dasar & penyolderan 	\N
825061306	Menangani kesehatan ternak unggas	\N
825061307	Melakukan penetasan telur	\N
825210138	Mengolah hasil perikanan untuk ekspor	\N
825210135	Menerapkan GMP, sanitasi, & keamanan pangan	\N
825210137	Melakukan pengalengan hasil perikanan	\N
825210139	Melakukan pengemasan & penyimpanan produk hasil perikanan	\N
825061308	Memelihara induk ternak unggas	\N
825210155	Mengendalikan hama & penyakit ikan	\N
809010209	Membuat plate offset lithography	\N
828041100	Teknologi Perkantoran	\N
828210100	Front Office	\N
828030103	Mengelola dokumen transaksi kegiatan kas	\N
843040110	Membuat gambar lukisan dengan komputer	\N
828050100	Korespondensi	\N
828190130	Pemesanan dan Penghitungan Tarif Penerbangan	\N
828200100	Pengelolaan Meeting, Converence & Exhibition	\N
829080800	Pengolahan dan Penyajian Makanan Indonesia	\N
843040108	Membuat lukisan teknik batik	\N
843060523	Menarikan tari Saloureng & sayo kembe	\N
843060545	Menarikan Tari Ketuk Tilu	\N
829101006	Mengolah & menyajikan makanan & minuman 	\N
831030300	Dasar Pola	\N
831040400	Dasar Desain	\N
831050500	Pembuatan Hiasan	\N
831050510	Pembuatan Hiasan Busana	\N
843040107	Membuat lukisan teknik seni grafis	\N
843040200	Seni Lukis Imajiner	\N
829080900	Pengolahan dan Penyajian Makanan	\N
843040111	Melaksanakan pameran seni lukis	\N
828030101	Melaksanakan prinsip profesionalisme dalam bekerja 	\N
843040300	Seni Eksperimen	\N
843040310	Seni Lukis Eksperimental	\N
843040400	Tata Teknik Pentas	\N
843040500	Seni Lukis Ekspresif	\N
999905306	Level 6	KRS053
828030100	Pengantar Akuntansi	\N
843060542	Melaksanakan tata teknik pentas	\N
843060533	Menarikan tari Rantak Gusmiati Suid	\N
843060524	Menarikan tari Sere Lalosu/Sere Alusu	\N
843060527	Menarikan tari Pasambahan Sofyani	\N
843060531	Menarikan tari Panen Gusmiati Suid	\N
843060521	Menarikan tari Pakuru Sumanga & Pangayo	\N
999912413	MD 12. Etika  kerja	KRS124
999912414	MD.1 Sarana penunjang merangkai bunga lanjutan 1 	KRS124
825210156	Mengelola induk ikan	\N
999912110	MP10. Pengawasan Kualitas Produksi Acara TV.	KRS121
999912409	MD 9. Teknik merangkal rangkaian pola dasar bentuk Segitiga	KRS124
999912415	MD.2 Pengetahuan warna lanjutan 1 	KRS124
999912707	Belum Ada Modul	KRS127
999912412	MD 11. Prosedure P3K	KRS124
828020106	Berkomunikasi dalam bahasa Inggris 	\N
825210158	Merawat telur & larva	\N
825220100	Keamanan Pangan	\N
843090305	Melaksanakan teknik tata pentas	\N
828020107	Mengelola dokumen & arsip	\N
828020108	Mengatur perjalanan dinas	\N
828020109	Menangani pertemuan	\N
828030105	Memproses transaksi ke dalam buku besar	\N
828030107	Menyajikan laporan harga pokok produk	\N
828030109	Menyiapkan surat pemberitahuan pajak	\N
828030111	Mengoperasikan aplikasi komputer akuntansi	\N
825210157	Memijahkan ikan	\N
828031100	Perbankan Dasar	\N
875180002	Menggambar 2D & 3D auto CAD	\N
829101000	Pengelolaan Usaha Boga	\N
999902223	Pemberian obat (MD-12)	KRS022
829101002	Melakukan komunikasi 	\N
829101003	Melakukan persiapan pengolahan makanan	\N
831060600	Desain Busana	\N
831060602	Melaksanakan layanan scr prima kpd pelanggan (customer care)	\N
831060603	Membuat busana pria 	\N
828040100	Otomatisasi Perkantoran	\N
843060900	Pengetahuan Karawitan Dasar	\N
843060810	Pagelaran Tari	\N
843090307	Melaksanakan penulisan naskah lakon drama	\N
843060905	Memainkan instrumen rebab tingkat pengrawit	\N
843090200	Manajemen Pertunjukan	\N
875190000	Kelistrikan Pesawat Udara	\N
843090303	Menerapkan olah sukma	\N
999912007	Presenting (MD-07)	KRS120
843090302	Menerapkan olah vokal & olah pernafasan 	\N
875180000	Konstruksi Rangka Pesawat Udara	\N
999902221	Tanda Vital (MD-10)	KRS022
875180001	Menggambar sketsa & teknik	\N
875180003	Mengukur dengan alat ukur mekanik presisi	\N
843090300	Pengetahuan Teater	\N
843060910	Memainkan instrumen gen&g	\N
999912108	MP8. Seni Peran	KRS121
999912406	MD 6. Cara membuat Decorative Wrapping Flower Arrangement	KRS124
875180010	Melakukan perakitan part-part struktur pesawat udara	\N
999800702	Bahasa Inggris	PKBM007
875180005	Melakukan pemotongan secara mekanik	\N
999902226	Bantuan Hidup Dasar (BHD) (MD-15)	KRS022
875190002	Menggambar teknik listrik & elektronika	\N
875190003	Menggunakan peralatan kerja kelistrikan	\N
999800613	Seni Budaya	PKBM006
999800614	Sosiologi	PKBM006
999800709	Matematika	PKBM007
875190001	Menerapkan dasar teknologi pesawat udara (DTPU)	\N
999800701	Bahasa Indonesia	PKBM007
999800704	Ekonomi	PKBM007
999800705	Fisika 	PKBM007
999800707	Keterampilan Fungsional 	PKBM007
999902225	Pencatatan dan Pelaporan (MD-14)	KRS022
999800708	Kimia	PKBM007
999800710	Muatan Lokal 	PKBM007
999800703	Biologi	PKBM007
999800715	Sejarah	PKBM007
999800716	Seni Budaya	PKBM007
999800717	Sosiologi	PKBM007
999900709	Level 9	KRS007
999901512	Belum Ada Modul	KRS015
999800706	Geografi	PKBM007
999902227	Teknologi Informasi Sederhana (MD-16)	KRS022
999800713	Pendidikan Kewarganegaraan	PKBM007
828030108	Menyusun & menyajikan laporan keuangan	\N
829081000	Produk Cake, dan Kue Indonesia	\N
999902228	Teknologi Kesehatan Khusus Lansia (MD-17)	KRS022
999902229	Budaya Negara Tujuan (MD-18)	KRS022
999903401	Level 1	KRS034
999905302	Level 2	KRS053
999903402	Level 2	KRS034
999903403	Level 3	KRS034
999904003	Level 3	KRS040
999904004	Level 4	KRS040
999904716	Pemeriksaan Pajak	KRS047
999905203	Level 3	KRS052
999905204	Level 4	KRS052
999905205	Level 5	KRS052
999905206	Level 6	KRS052
999905207	Level 7	KRS052
999905209	Level 9	KRS052
999905210	Paket/Gaya	KRS052
999905211	Unit Kompetensi Tambahan	KRS052
999905301	Level 1	KRS053
999905305	Level 5	KRS053
843090304	Menerapkan dasar-dasar dramatik	\N
829090900	Hidanganan Kesempatan Khusu dan Fusion Food	\N
999912111	MP11. Pengantar K3LH	KRS121
999912410	MD 10. Teknik membuat rangkaian bunga pola	KRS124
999912408	MD 8. Teknik  merangkai rangkaian bunga pola dasar bentuk bulat	KRS124
999912407	MD 7. Cara membuat Aksesoris dari materi non Floral	KRS124
999905405	Level 5	KRS054
828030110	Mengoperasikan paket program pengolah angka/spreadsheet	\N
999912816	Elemen Mesin pada Alat Berat (MD-16)	KRS128
999913710	MD.10 Sistem kontrol unit	KRS137
999913709	MD.9 Sistem pengolah sinyal	KRS137
999912817	Dasar-dasar pengoperasian alat berat (MD-17)	KRS128
999912901	Alat dan peralatan bengkel (MD-01)	KRS129
999912902	Sistem-sistem engine (MD-02)	KRS129
999912903	Sistem Pemindah Tenaga (MD-03)	KRS129
999912926	Sistem Rem Yang Di Kontrol Secara Elektronik (MA-6)	KRS129
999912927	Sistem Electronic Power Steering (MA-7)	KRS129
999912701	Gambar Listrik     (PLC ? 01)	KRS127
999912702	Peralatan Kerja dan Alat Ukur Listrik (PLC- 02)	KRS127
999912812	Dasar sistem suspensi, roda dan ban (MD-12)	KRS128
999906411	Unit Kompetensi Tambahan	KRS064
999913711	MD.11 Sistem antarmuka	KRS137
999913712	MD.12 Sistem aktuator	KRS137
999913713	MD.13 Sistem Mekanik Robot	KRS137
999905406	Level 6	KRS054
999905826	Dasar Manajemen	KRS058
999906409	Level 9	KRS064
999905811	Unit Kompetensi Tambahan	KRS058
999905814	Keterampilan Mengetik	KRS058
999907708	Level 8	KRS077
999906703	Level 3	KRS067
999906413	MD 2. Hidroterapi: Perawatan Mandi Berendam	KRS064
999906410	Paket/Gaya	KRS064
999907804	Level 4	KRS078
999907710	Paket/Gaya	KRS077
999905407	Level 7	KRS054
999910304	Pembuatan Pempek Ikan	KRS103
999905514	Anatomi Fisiologi Umum Dan Struktur Tungkai Kaki Bawah (MD-03)	KRS055
999905825	Stenografi Lanjutan	KRS058
999906415	MD 4. Terapi Perawatan Badan: Dengan lulur	KRS064
999908303	Level 3	KRS083
999907711	Unit Kompetensi Tambahan	KRS077
999915018	Suhu ruang penhyimpanan bahan	KRS150
999907801	Level 1	KRS078
999907802	Level 2	KRS078
999907803	Level 3	KRS078
999907805	Level 5	KRS078
999907806	Level 6	KRS078
999905812	Dasar Stenografi	KRS058
999908302	Level 2	KRS083
999908804	Level 4	KRS088
999912421	Teknik merangkai bunga  pola dasar bentuk diagonal	KRS124
999912417	MD.4 Ilmu  Hortikultura Lanjutan  1	KRS124
999913707	MD.7 Modul pembuatan sistem catu daya	KRS137
999912422	Teknik merangkai Bunga pola dasar  Bentuk L 	KRS124
999908802	Level 2	KRS088
999908305	Level 5	KRS083
999908801	Level 1	KRS088
999908817	Bobot dan Keseimbangan Pesawat (Basic Weight and Balance)	KRS088
999908805	Level 5	KRS088
999908807	Level 7	KRS088
999908901	Level 1	KRS089
999908809	Level 9	KRS088
999908810	Paket/Gaya	KRS088
999908811	Unit Kompetensi Tambahan	KRS088
999907709	Level 9	KRS077
999908806	Level 6	KRS088
999910405	Teknik Berkomunikasi (MD-5)	KRS104
999910308	GMP dan SSOP	KRS103
999910305	Pengemasan Produk Olahan Ikan	KRS103
999910303	MP-3. Pembuatan Otak-Otak ikan	KRS103
999910307	Analisis Usaha Produk Olahan Ikan	KRS103
999910401	Media Pengasuhan (MD-1)	KRS104
999915026	Pengetahuan resep	KRS150
999910402	Pedoman Perawatan Kesehatan Anak (MD-2)	KRS104
999910403	Pertumbuhan dan Perkembangan Anak (MD-3)	KRS104
999910404	Pembelajaran Terpadu/Tematik (MD-4)	KRS104
999910406	Perencanaan Kegiatan (MD-6)	KRS104
999915079	Resep masakan Oriental dari Negara china	KRS150
999910407	Nutrisi Anak (MD-7)	KRS104
999912933	Kontrol elektronik otomotif (MD-13)	KRS129
999905807	Level 7	KRS058
999915025	Pengetahuan, penggunaan dan Penanganan peralatan	KRS150
999908209	Level 9	KRS082
999915027	Terminologi dapur (Kitchen Terminologi)	KRS150
999908301	Level 1	KRS083
999915073	Resep masakan lauk pauk nabati  dari bahan nabati lainnya	KRS150
999915075	Resep masakan hidangan pendamping  aneka acar	KRS150
999915076	Resep masakan hidangan hidangan punutup dari bahan beras dan tepung beras	KRS150
999908210	Paket/Gaya	KRS082
999915074	Resep masakan hidangan pendamping  aneka sambal	KRS150
800000247	Bisnis Retail	\N
999907807	Level 7	KRS078
999915024	Pengetahuan dan Penanganan sayuran	KRS150
999908304	Level 4	KRS083
999915023	Pengetahuan dan Penanganan bumbu dan rempah	KRS150
999912813	Dasar-dasar  AC (MD-13)	KRS128
999912424	Teknik merangkai  bunga pola dasar bentuk Hogarth	KRS124
999912457	MD.22 Prosedur menghitung harga jual	KRS124
999912458	MD.23 Prosedur K3	KRS124
999912626	(MP-26) Petunjuk Penggunaan Pemindai 3D	KRS126
999912815	Dasar-dasar perawatan berkala (MD-15)	KRS128
999915031	Kerjasama dalam  pekerjaan	KRS150
999915034	Perencanaan Menu (Menu Planning)	KRS150
999913720	MD.20 Dasar-dasar robotika	KRS137
999913801	Layanan Pelangan (TAC-01)	KRS138
999913803	K3 (TAC-03)	KRS138
999913804	Instalasi Listrik AC  (TAC-04)	KRS138
999913806	Pemasangan Unit Indoor dan Outdoor AC (TAC-06)          	KRS138
999913807	Perawatan Perangkat  AC (TAC-07)	KRS138
999913809	Komponen Elektronika (HPS-01)	KRS139
999916814	Etika Profesi (MPUIII-8)	KRS168
999913604	Wewenang dan Tanggung Jawab Pertukangan Konstruksi Kayu (MP. 4)	KRS136
999913715	MD.15 Evaluasi dan presentasi hasil rancangan	KRS137
999913005	Modul laporan Kerja (MD-5).	KRS130
999916305	MD 5. Pemeriksaan Perpajakan	KRS163
999915035	Aneka menu kreasi (Menu Creation)	KRS150
999915043	Pelatihan  HACCP  (HACCP Training)	KRS150
999915044	Monitoring pelaksanaan kerja	KRS150
999915045	Prosedur penyimpanan bahan	KRS150
999910416	P3K (MD-8)	KRS104
999915030	Pengetahuan Komunikasi	KRS150
999912931	Logika Matematika (MA-11)	KRS129
999905820	Pengelolaan Administrasi Keuangan Pimpinan	KRS058
999916602	MD. 2. Pajak Penghasilan Badan 	KRS166
999913001	Modul K3LH (MD-1)	KRS130
999915028	Pengetahuan hygiene dan sanitasi	KRS150
999913008	Pengetahuan produk alat berat Excavator / Dump Truck / Loader	KRS130
999916103	MD 3. Manajemen Perkantoran	KRS161
999913010	Modul pengetahuan tanah dan material (MD-10)	KRS130
999915010	Pembuatan kaldu ikan/ sea food (Fish Stock)	KRS150
999915015	Tehnik pembuatan saus dasar panas 	KRS150
999915012	Pembuatan kaldu sayuran (vegetables stock)	KRS150
999915013	Bahan dan bumbu pengolahan saus dasar	KRS150
999915014	Tehnik pembuatan saus dasar dingin	KRS150
999915066	Resep masakan lauk pauk hewani dari bahan unggas	KRS150
999915016	Tehnik pembuatan saus Indonesia dan Oriental	KRS150
999915110	Kepemimpinan	KRS150
999915063	Resep masakan aneka masakan nasi berbumbu	KRS150
999915065	Resep aneka lauk pauk hewani dari bahan daging	KRS150
999915070	Resep masakan lauk pauk nabati  dari bahan tempe	KRS150
999915017	Tehnik penyimpanan bahan olahan	KRS150
999916205	MD 5. Pemeriksaan Pajak 	KRS162
999915082	Resep masakan Oriental dari Negara Thailand	KRS150
999916402	MD. 2. Kepabeanan dan Cukai 	KRS164
999913106	Pembuatan Pilar Pasangan Bata  (MD. 6)	KRS131
999915083	Resep masakan Kontinental hidangan pembuka panas dan dingin	KRS150
999915102	Resep Standar	KRS150
999910419	Prosedur Bekerja di Luar Negeri (MD-11)	KRS104
999915201	Belum Ada Modul	KRS152
999915128	Standar operasional kerja	KRS150
999915129	Perkembangan terminologi makanan	KRS150
999913104	Pembuatan Mortar Pasangan Bata  (MD. 4)	KRS131
999915103	Pelatihan jenjang karir	KRS150
999915130	Berkomunikasi dalam Bahasa Inggris	KRS150
999915131	Tanggung Jawab dalam pekerjaan	KRS150
999915132	Keluhan tamu dan penanganannya	KRS150
999915134	Keselamatan Kerja	KRS150
999915301	Belum Ada Modul	KRS153
999916306	MD 6. Akuntansi perapajakan	KRS163
999916605	MD. 5. Pemeriksaan Pajak	KRS166
800000260	Seni Patung	\N
999916201	MD 1. PPh Pasal 21	KRS162
300310700	Bahasa Mandarin	\N
999916301	MD 1. Ketentuan Umum dan Tatacara Perpajakan (KUP) 	KRS163
999916105	MD 5. Pemeriksaan Pajak 	KRS161
999916102	MD 2. Pajak Penghasilan Orang Pribadi 	KRS161
999916107	MD 7. Manajemen Perkantoran	KRS161
999916203	MD 3. Ketentuan Umum dan Tatacara Perpajakan (KUP) 	KRS162
999916204	MD 4. Manajemen Perkantoran	KRS162
999916206	MD 6. Akuntansi perapajakan	KRS162
999916302	MD 2. Manajemen Perkantoran	KRS163
999910602	Pedoman HBS dan K3 (MD-2) 	KRS106
999916303	MD 3. PPN dan PPnBM	KRS163
999916403	MD. 3. Logistik Ekspor ?Impor 	KRS164
999912932	Pemrograman Komputer (MA-12)	KRS129
999913004	Metode pengoperasian Excavator /  Dump Truck / Loader	KRS130
999913605	Evaluasi Kualitas Hasil Konstruksi Kayu (MP. 5)	KRS136
999913718	MD.18 Keselamatan dan Kesehatan Kerja (K3)	KRS137
999916404	MD. 4. Manajemen Perkantoran 	KRS164
800000252	Akuntansi	\N
999915404	Wirausaha dan Pemasaran (MD4.III)	KRS154
999915127	Pengelolaan Usaha Jasa Makanan	KRS150
999913808	Perbaikan AC (TAC-08)	KRS138
999913603	Pengetahuan Pertukangan konstruksi kayu (MP.3)	KRS136
999913719	MD.19 Pelayanan pelanggan	KRS137
999913105	Pembuatan Dinding Pasangan Bata  (MD. 5)	KRS131
999915033	Petunjuk Penggunaan Peralatan Modern	KRS150
999913002	Perawatan harian Excavator /  Dump Truck / Loader 	KRS130
999913716	MD.16 Prosedur perbaikan Robot	KRS137
999915058	Tugas dan Tanggung jawab pekerjaan	KRS150
999915061	Tehnik dan jenis komunikasi	KRS150
999915060	Sifat, karakter rekan kerja dan pelanggan	KRS150
999915048	Pengendalian biaya produksi	KRS150
999901510	Paket/Gaya	KRS015
802031504	Membuat rekaman audio di studio	\N
999915904	MD 4. Manajemen Perkantoran 	KRS159
800000243	Nautika Kapal Penangkapan Ikan	\N
999916008	MD 3. Ketentuan Umum dan Tatacara Perpajakan (KUP)	KRS160
200030070	Kewirausahaan (P4 Pancasila & Budaya Kerja)	\N
999916009	MD 4. Manajemen Perkantoran	KRS160
999916101	MD 1. Ketentuan Umum dan Tata Cara Perpajakan (KUP)	KRS161
999916808	Pengetahuan Zat Pewarna Kue (MDU III-8)	KRS168
999916809	Pengetahuan Resep (MDO III-5)	KRS168
999916811	Higiene dan Sanitasi (MDU-3)	KRS168
999916813	Pengetahuan Bahan Aditif (MDU-5)	KRS168
999916906	Pengetahuan dasar dekorasi roti (MDU-6)	KRS169
999916908	Etika Profesi (MPUIII-8)	KRS169
800000248	Manajemen Perkantoran	\N
200030090	Budaya Kerja (P4 Pancasila & Budaya Kerja)	\N
300230000	Bahasa Inggris Tingkat Lanjut	\N
800000265	Kriya Kreatif Keramik	\N
999908707	Teknik Presentasi (MD-7)	KRS087
800000157	Desain Interior dan Teknik Furnitur	\N
200040070	Kewirausahaan	\N
999917008	Etika Profesi (MDUIII-8)	KRS170
800000151	Teknik Perawatan Gedung	\N
200040080	Kebekerjaan	\N
200030010	Gaya Hidup Berkelanjutan (P4 Pancasila & Budaya Kerja)	\N
300130000	Bahasa Indonesia Tingkat Lanjut	\N
200041030	Kita Semua Bersaudara, Bhinneka Tunggal Ika	\N
800000238	Agribisnis Pengolahan Hasil Pertanian	\N
401002000	Matematika Tingkat Lanjut	\N
700109010	Seni Musik Ketrampilan	\N
800000217	Teknik Jaringan Akses Telekomunikasi	\N
200030030	Bhinneka Tunggal Ika (P4 Pancasila & Budaya Kerja)	\N
999906702	Level 2	KRS067
800000154	Teknik Konstruksi dan Perumahan	\N
800000155	Konstruksi Gedung dan Sanitasi	\N
999917006	Pengetahuan Dasar Dekorasi  Pastry (MDD-6)	KRS170
800000233	Agribisnis Perikanan Payau dan Laut	\N
700123000	Budidaya Tanaman Hortikultura	\N
800000241	Kehutanan	\N
700122000	Seni Teater	\N
800000244	Teknika Kapal Niaga	\N
800000245	Nautika Kapal Niaga	\N
800000231	Kesehatan Hewan	\N
800000267	Kriya Kreatif Kayu dan Rotan	\N
800000278	Desain dan Produksi Busana	\N
700121000	Seni Rupa	\N
200030050	Suara Demokrasi (P4 Pancasila & Budaya Kerja)	\N
100013050	Pastoral dan Katekese	\N
700110010	Seni Tari Ketrampilan	\N
800000246	Bisnis Digital	\N
800000234	Agribisnis Perikanan Air Tawar	\N
200030040	Bangunlah Jiwa dan Raganya (P4 Pancasila & Budaya Kerja)	\N
800000235	Agribisnis Rumput Laut	\N
800000136	Dasar Dasar Nautika Kapal Niaga	\N
999917007	Pemasaran Produk Pastry (MDUIII-7)	KRS170
999915059	Kerjasama dan permasalahannya	KRS150
200041040	Imajinasi dan Kreativitasku, Rekayasa dan Teknologi	\N
800000251	Layanan Perbankan Syariah	\N
800000236	Usaha Pertanian Terpadu	\N
800000232	Agribisnis Ikan Hias	\N
800000250	Layanan Perbankan	\N
800000240	Pengawasan Mutu Hasil Pertanian	\N
100014130	Pokok-pokok Dasar Agama Buddha	\N
800000275	Produksi dan Siaran Program Televisi	\N
800000137	Dasar Dasar Pemasaran	\N
800000139	Dasar Dasar Akuntansi dan Keuangan Lembaga	\N
800000268	Seni Musik	\N
803030501	Menerapkan prosedur kerja transmisi telekomunikasi	\N
800000142	Dasar Dasar Kuliner	\N
800000144	Dasar Dasar Seni Rupa	\N
200010300	Pendidikan Pancasila	\N
200040040	Bangunlah Jiwa dan Raganya	\N
800020400	Pengantar Ilmu Penyakit dan Penunjang Medis	\N
800000270	Seni Karawitan	\N
802031507	Memperb. alat reprod. sinyl audio video compact kaset & CD	\N
999915047	Pengendalian bahan	KRS150
800000147	Dasar Dasar Seni Pertunjukan	\N
800000149	Dasar Dasar Animasi	\N
802031503	Melakukan ins. sound system	\N
800090200	Perundang-undangan Kesehatan	\N
800000273	Tata Artistik Teater	\N
802032200	Fotografi	\N
800000276	Produksi Film	\N
800000255	Perhotelan	\N
800000271	Seni Pedalangan	\N
999915051	Pengetahuan kreativitas menu	KRS150
999916907	Pemasaran Produk Roti (MDUIII-7)	KRS169
999915052	Pengetahuan kreasi makanan	KRS150
999915053	Pengetahuan Dasar Kepemimpinan	KRS150
999915054	Pengetahuan makanan kesempatan khusus	KRS150
999915055	Pengetahuan kalkulasi biaya	KRS150
999915056	Pengetahuan Standar   HACCP	KRS150
999915057	Pengetahuan standar penilaian Kinerja	KRS150
999915905	MD 5. Pemeriksaan Pajak	KRS159
820090100	Power Train dan Hidrolik Alat Berat	\N
820080200	Kelistrikan dan Sistem Kontrol Alat Berat	\N
804110505	Mengoperasikan mesin NC/CNC	\N
804110503	Melaksanakan pekerjaan pemesinan operasi kompleks	\N
804110700	Teknik Pemesinan Gerinda	\N
809010201	Membuat brief konsep desain	\N
803030505	Melakukan ins. PSTN	\N
999901509	Level 9	KRS015
814031600	Manajemen Distribusi dan  Delivery	\N
820090200	Hidrolik Alat Berat	\N
820070300	Pemeliharaan dan Kelistrikan Sepeda Motor	\N
820070105	Melakukan perbaikan sistem engine sepeda motor	\N
820100102	Menggunakan service literatur	\N
820070108	Melaksanakan pekerj. servis pd roda, ban & rantai spd motor	\N
804160201	Melak. rutin. las oks-asetilen, las busur manual & las gas	\N
800000104	Dasar Dasar Desain Pemodelan dan Informasi Bangunan	\N
800000263	Kriya Kreatif Batik dan Tekstil	\N
817030100	Teknik Produksi Migas	\N
809010202	Menyusun huruf/type setting	\N
820090300	Powertrain dan Undercarriage Alat Berat	\N
802031508	Melakukan konversi cassette ke CD	\N
809010204	Membuat foto reproduksi	\N
820080100	Kelistrikan Alat Berat	\N
999915109	Motivasi Kerja	KRS150
999905303	Level 3	KRS053
820070200	Pemeliharaan Sasis Sepeda Motor	\N
800000258	Spa dan Beauty Therapy	\N
802032500	Karya Desain Komunikasi Visual	\N
800000262	Teknik Grafika	\N
803021510	Instalasi Catudaya dan Grounding Sistem Telekomuni	\N
800030100	Dasar-dasar Kefarmasian	\N
800000109	Dasar Dasar Teknik Logistik	\N
803080400	Perbaikan & Prwtn Peralatan Elektronika Komunikasi	\N
800000121	Dasar Dasar Pengembangan Perangkat Lunak dan Gim	\N
800000277	Animasi	\N
800000259	Seni Lukis	\N
800061300	Alat Kesehatan Gigi,Pencegahan dan Pengendalian Penyakit	\N
700115100	Desain Grafis Percetakan	\N
800000103	Dasar Dasar Teknik Konstruksi dan Perumahan	\N
999900710	Paket/Gaya	KRS007
800000107	Dasar Dasar Teknik Otomotif	\N
800000106	Dasar Dasar Teknik Mesin	\N
800000220	Asisten Dental	\N
800000105	Dasar Dasar Teknik Furnitur	\N
800000111	Dasar Dasar Teknik Pesawat Udara	\N
800000112	Dasar Dasar Teknik Konstruksi Kapal	\N
800000113	Dasar Dasar Kimia Analisis	\N
800000114	Dasar Dasar Teknik Kimia Industri	\N
800000115	Dasar Dasar Teknik Tekstil	\N
800000117	Dasar Dasar Teknik Energi Terbarukan	\N
800000118	Dasar Dasar Teknik Geospasial	\N
800000119	Dasar Dasar Teknik Geologi Pertambangan	\N
800000120	Dasar Dasar Teknik Perminyakan	\N
800000123	Dasar Dasar Layanan Kesehatan	\N
804131106	Melaksanakan kontrol kualitas pd instrumentasi	\N
800000128	Dasar Dasar Agribisnis Ternak	\N
803041510	Menjelaskan arsitektur jaringan selular	\N
800000129	Dasar Dasar Agribisnis Perikanan	\N
800000130	Dasar Dasar Usaha Pertanian Terpadu	\N
800000132	Dasar Dasar Kehutanan	\N
800000140	Dasar Dasar Usaha Layanan Pariwisata	\N
800000143	Dasar Dasar Kecantikan dan Spa	\N
800000146	Dasar Dasar Desain dan Produksi Kriya	\N
800000269	Seni Tari	\N
800000150	Dasar Dasar Busana	\N
800000148	Dasar Dasar Broadcasting dan Perfilman	\N
800000272	Seni Teater	\N
401901000	Projek IPAS	\N
800000254	Ekowisata	\N
800000256	Kuliner	\N
800000264	Kriya Kreatif Kulit dan Imitasi	\N
820070400	Pengelolaan Bengkel Sepeda Motor	\N
803010300	Dasar Listrik dan Elektronika	\N
820070103	Melakukan overhaul sistem pendingin sepeda motor 	\N
401130610	Analisis Bahan Anorganik	\N
804010210	Aplikasi Perangkat Lunak dan Perancangan Interior Gedung	\N
804050403	Menggambar bangunan secara manual & dengan perangkat lunak 	\N
804050505	Melaksanakan pekerjaan finishing konstruksi kayu	\N
804090306	Menerapkan sistem pembuangan air kotor/ drainase	\N
804100600	Jaringan Distribusi Tenaga Listrik	\N
804100603	Mengoperasikan saluran pelanggan & tegangan rendah & opstig	\N
804110108	Memelihara sistem PLC/SCADA otomasi industri	\N
804131607	Melakukan operasi pengecoran tingkat lanjut	\N
820070500	Pemeliharaan Listrik Sepeda Motor	\N
806010601	Melaksanakan pekerjaan dasar kelistrikan & dasar mekanik	\N
800000127	Dasar Dasar Agribisnis Tanaman	\N
806010606	Mengambar sistem cold storage	\N
401251080	Layanan Lembaga Keuangan Non Bank	\N
401130600	Analisis Kimia Terpadu	\N
600030000	Seni Budaya dan Keterampilan	\N
803030506	Melakukan ins., mengoperasikan & memelihara PABX	\N
804110504	Memprogram mesin NC/CNC	\N
802033200	Animasi	\N
804110600	Teknik Pemesinan Frais	\N
803030507	Mengoperasikan & memelihara sentral telepon digital	\N
800000141	Dasar Dasar Perhotelan	\N
401141210	Farmakognosi Dasar	\N
825060900	Agribisnis Ternak Unggas Pedaging	\N
821080100	Desain Kapal Kayu	\N
821080200	Konstruksi Kapal Kayu	\N
825060812	Mengelola usaha ternak ruminansia	\N
825061000	Agribisnis Ternak Unggas Petelur	\N
814030500	Sistem Informasi Gudang	\N
825210142	Menerapkan program manajemen mutu terpadu	\N
825210153	Membudidayakan pakan alami	\N
843060583	Menyajikan vokal daerah	\N
825210159	Melakukan pendederan	\N
825210152	Menyiapkan wadah & media budidaya ikan	\N
825210300	Dasar Pengendalian Mutu Hsl Pertanian & Perikanan	\N
825210500	Dasar Pengendalian Mutu Hasil Perikanan	\N
825230300	Produksi Hasil Perkebunan	\N
843080107	Menulis naskah cerita wayang (naskah pendek/pdt)	\N
826110100	Teknik Konservasi Tanah dan Air	\N
826120100	Teknik Rehabilitasi dan Reklamasi	\N
826130100	Teknik Agroforestry	\N
826140100	Inventarisasi Hutan Produksi	\N
826150100	Pemanenan Hasil Hutan	\N
826150110	Pemanenan Hasil Hutan Produksi	\N
826160100	Pengujian Kayu Bulat	\N
826160200	Pengujian Kayu Gergajian	\N
826170100	Perencanaan Hutan	\N
827010100	HMP4L2	\N
827410100	KSPOKN	\N
843120500	Tata Panggung	\N
999903805	Level 5	KRS038
844030100	Melaksanakan pelayanan  prima kepada pelanggan	\N
828011000	Ekonomi Bisnis	\N
839020148	Mengglasir benda keramik	\N
843080210	Vokal Pedalangan Dasar	\N
843060800	Pergelaran	\N
999905415	Teknik Vokal (MD-04)	KRS054
843060909	Menyajikan vokal daerah tingkat pengrawit	\N
843060911	Memainkan instrumen kecapi	\N
843080105	Melakukan teknik dasar dodogan & keprakan	\N
824050600	Kamera dan Pencahayaan	\N
843060908	Memainkan karawitan iringan tingkat pengrawit	\N
843080300	Dramaturgi Pedalangan	\N
843080400	Praktek Pedalangan	\N
843060600	Tata Rias Busana Tari	\N
843080410	Praktik Pedalangan Dasar	\N
843080500	Vokal Pedalangan	\N
843080510	Iringan Pedalangan	\N
843080520	Lakon Pedalangan	\N
843080600	Tehnik Gerak Wayang	\N
809010212	Membuat silinder gravure	\N
843060620	Tata Rias dan Busana	\N
843060700	Koreografi	\N
999903418	Spesifikasi Kendaraan (MP MKB 07)	KRS034
814031500	Administrasi Pergudangan	\N
827280105	Menentukan lokasi budidaya	\N
816010302	Melakukan proses penganjian benang	\N
817030106	Melakukan pengujian sumur (well testing)	\N
817110103	Menjelaskan konsep eksplorasi hidrokarbon	\N
820070109	Melakukan pemeliharaan&perbaikan sistem kelistrikan spd mtr	\N
999910002	Pemasaran Digital melalui Media Sosial dan Pasar Niaga Elektronik	KRS100
875180007	Melakukan pekerjaan pengelasan  menggunakan las oxy-asetilin	\N
875190007	Merakit & memperbaiki sistem kelistrikan pesawat udara	\N
999900611	Unit Kompetensi Tambahan	KRS006
843060923	Memainkan karawitan Rebab	\N
843060924	Memainkan karawitan Talempong Pacik	\N
843060949	Menabuh gong kebyar tabur instrumental	\N
843070400	PIIP (Praktik Individu Instrumen Pokok) Dasar	\N
843080106	Melakukan teknik gerak, antawacana, vokal, dodogan& keprakan	\N
843090310	Melaksanakan tata busana	\N
999900311	Unit Kompetensi Tambahan	KRS003
839020146	Membuat dekorasi keramik pd proses pembentukan 	\N
999900607	Level 7	KRS006
811010300	Foto Reproduksi dan Acuan Cetak	\N
999800609	Pendidikan Jasmani, Olahraga dan Kesehatan	PKBM006
809010301	Mengoperasikan mesin cetak	\N
999800511	Pengembangan Kepribadian Profesional	PKBM005
999900617	Modul Penerapan bahasa dan dokumen Negara tujuan	KRS006
821070100	Pembuatan dan Perakitan Komponen Kapal Baja	\N
999901005	Level 5	KRS010
999903208	Level 8	KRS032
809020600	Cetak Saring dan Cetak Tampon/Pad Printing	\N
999909102	Persiapan Tanam	KRS091
811010200	Fotoreproduksi	\N
999910109	Mengelola administrasi Penjualan	KRS101
999910110	Mengelola Buku Jurnal Perusahaan Industri	KRS101
999910417	Pertumbuhan dan Perkembangan Anak (MD-9)	KRS104
999910418	Etika Profesi Pengasuh Anak (MD-10)	KRS104
999903211	Unit Kompetensi Tambahan	KRS032
803030509	Membuat perencanaan jaringan & kebutuhan layanan komunikasi	\N
843060610	Tata Rias dan Tata Busana Tari	\N
804110501	Melaksanakan penanganan material secara manual	\N
804051002	Menerapkan pekerjaan dasar-dasar furnitur/cabinet making	\N
821070200	Perakitan Konstruksi Bangunan Kapal Baja	\N
803030510	Melakukan ins., mengop.n & memelihara sentral telpn seluler	\N
804110500	Teknik Pemesinan Bubut	\N
821070300	Penerapan Teknologi Pembangunan Kapal Baja	\N
800010100	Kesehatan Masyarakat	\N
803021200	Transmisi Broadband NGN	\N
100015010	Pendidikan Agama Hindu dan Budi Pekerti	\N
700106000	Teknik Informatika dan Komputer	\N
801030100	Kontak dengan Klien dan Lingkungan Sosial	\N
999905310	Paket/Gaya	KRS053
802000300	Teknologi Informasi dan Komunikasi	\N
802021700	Maintenance and Repair Local Area Network (LAN)	\N
802030410	Desain Interior Kapal dengan CAD	\N
802030609	Menyusun proposal penawaran projek multimedia	\N
401251150	Praktikum Akuntansi Perusahaan Jasa, Dagang dan Manufaktur	\N
999904404	Level 4	KRS044
800061500	Komunikasi Interpersonal dan Penjaminan mutu	\N
800060302	Melak.surveilan epidemiologi penyakit gigi & mlt di masy.	\N
800010125	Melaksanakan penanganan bahan & reagen laboratorium	\N
401250000	Ilmu Pengetahuan Sosial (Ekonomi)	\N
999903309	Level 9	KRS033
999903310	Paket/Gaya	KRS033
999903311	Unit Kompetensi Tambahan	KRS033
999903312	Komunikasi Efektif (MD-1)	KRS033
999903313	Gambar Teknik (MD-2)	KRS033
999903314	Alat Ukur (MD-3)	KRS033
999903315	Teknik Pengelasan Busur Manual (MD-4)	KRS033
999915002	Penanganan Bahan Makanan	KRS150
999903316	Kesehatan dan Keselamatan Kerja Las (MD-5)	KRS033
999905308	Level 8	KRS053
999905821	Kesekretarisan	KRS058
999905823	Korespondensi Bahasa Inggris	KRS058
999906427	MD 7. Terapi Termal: Dengan Sauna	KRS064
999905816	Komunikasi Kantor	KRS058
999905817	Aplikasi Komputer	KRS058
999905819	Dasar Bahasa Inggris	KRS058
999910415	Pembuatan perencanaan kegiatan (MD-7)	KRS104
999905309	Level 9	KRS053
999906420	MD 9. Terapi Penunjang lain: Komunikasi ditempat Kerja Spa	KRS064
999906421	MD 1. Hidroterapi: Melakukan Perawatan Contrast Bath	KRS064
999906422	MD 2. Terapi Pijat: Perawatan Pijat Refleksi 	KRS064
999906425	MD 5. Terapi Perawatan Badan: dengan Masker Bahan Segar	KRS064
999906631	Perawatan Wajah Berkomedo dengan teknologi alat listrik (MD.3)	KRS066
999906011	Unit Kompetensi Tambahan	KRS060
999905815	Manajemen Kearsipan	KRS058
999910411	Panduan Peralatan Teknologi Sederhana (MD-3)	KRS104
999902325	Komputer Grafis Digital Imaging-07	KRS023
999905813	Korespondensi Niaga Bahasa Indonesia	KRS058
999905304	Level 4	KRS053
999910413	Komunikasi Verbal dan Non Verbal (MD-5)	KRS104
999905311	Unit Kompetensi Tambahan	KRS053
800050207	Menjelaskan tahapan perkembangan srt kebutuhan dasar manusia	\N
999902917	Membangun Jejaring Dan Memanfaatkannya  (Md-3.6)	KRS029
999902607	Level 7	KRS026
999903117	Troubleshooting Jaringan Komputer (MDIII-6)	KRS031
401141300	Administrasi Farmasi	\N
999905907	Level 7	KRS059
999905420	K3 (Kesehatan, Keselamatan Kerja) (MD-09)	KRS054
999902414	(MD-3) Desain Elementer dan Material	KRS024
999905913	Metode Mengajar 1 (MD. 2)	KRS059
999906007	Level 7	KRS060
999906208	Level 8	KRS062
999906436	MD 7 Perawatan Mata dan Bibir Secara Manual	KRS064
999906512	Pengolahan Kue Kontinental (MDCIII-1)	KRS065
999906625	Merias Wajah Panggung (MD.6)	KRS066
999907507	Level 7	KRS075
999902810	Paket/Gaya	KRS028
999902710	Paket/Gaya	KRS027
999908906	Level 6	KRS089
999908531	Sistem final drive/gardan LSD (limited slip differential) (MD-5)	KRS085
999913805	Penggunaan Alat Ukur Listrik (TAC-05)	KRS138
999911210	Membaca dan Menganalisa Sketsa Mode/ Desain (MD-01)	KRS112
999908706	Pengolah Data (MD-6)	KRS087
999911901	Pedoman Tehnik Olah Vokal dan Pernafasan (MP ? 1 )	KRS119
999912301	Menerapkan K3 di tempat kerja  (MP 1)	KRS123
999911211	Mengukur Tubuh(MD-02)	KRS112
999912114	MP14. Praktik	KRS121
999912418	Teknik merangkai bunga  pola dasar bentuk oval horizontal	KRS124
999912455	MD.19 Teknik membuat taman mini di depan panggung 	KRS124
999912604	(MP-4)   Instrumen Kualifikasi Rancangan Sistem	KRS126
999912801	Keselamatan, Kesehatan Kerja dan Lingkungan Hidup (K3LH) (MD-1)	KRS128
999912909	Hak dan Tanggung Jawab (MD-9)	KRS129
999913101	Pengetahuan Penunjang Pekerjaan Pemasangan bata level 2 (MD. 1)	KRS131
999913505	Kesehatan dan Keselamatan Kerja (K3) (MP-02.05)	KRS135
999914303	Pemrograman Aplikasi Penyimpanan Data Menggunakan Shared Data (MD.IV-03)	KRS143
401251103	Produk Syariah	\N
401131400	Analisis Kuantitatif Konvensional	\N
999903317	Bahasa Inggris Teknik (MD-6)	KRS033
803010400	Elektronika dan Microprosesor	\N
401121030	Fisika (Agrobisnis dan Agroteknologi)	\N
999902606	Level 6	KRS026
999902523	Tugas Rutin Ekspor- Impor	KRS025
600040000	Pendidikan Keterampilan	\N
300310400	Bahasa Jepang	\N
813010102	Menggambar teknik sistem instrumentasi kontrol proses	\N
804150101	Melakukan pengelasan dengan las oks, busur manual & las gas	\N
800000226	Agribisnis Tanaman Pangan dan Hortikultura	\N
81	Guru PAUD	PAUD001
815010600	Penanganan mesin Oven End dan Winding	\N
804131000	Pemeliharaan dan Perbaikan Instrumen Logam	\N
800030101	Menerapkan dasar2 kimia, kefarmasian & kesehatan masyarakat	\N
827010103	Menerapkan penanganan & penyimpanan hasil penangkapan ikan	\N
821160700	Perbaikan, Perawatan dan Pengoperasian Mesin CNC	\N
825250600	Teknik Pendederan Komoditas Ikan Hias	\N
814070200	Pengendalian Dokumen Administrasi Gudang	\N
817150110	Keselamatan, Kesehatan Kerja, dan Lingkungan Hidu	\N
827110300	Kelistrikan, Sis Pngndlian & Otmtsasi Kpl Perikann	\N
825250106	Melakukan verifikasi alat ukur primer & sekunder	\N
999910603	Anatomi Fisiologi Umum (MD-3)	KRS106
821061002	Menjelaskan dasar-dasar kelistrikan & teknik mesin	\N
814100109	Melakukan proses pengujian hasil produksi	\N
804060200	Perencanaan Konstruksi Jalan,Irigasi, dan Jembatan	\N
825063500	Industri Ternak Ruminansia Perah	\N
827350110	Menerapkan olah gerak kapal & sistem kontrol kemudi otomatis	\N
825010204	Mengoper. & merwt mtr tenaga penggerak alt mesin pertanian	\N
814030300	Pengendalian Dokumen Administrasi Gudang	\N
825120100	Perawatan dan Perbaikan Alat Mesin Pertanian	\N
823040109	Memasang panel & unit pembangkit	\N
999911501	Belum Ada Modul	KRS115
825210107	Menganalisis bahan hasil pertanian secara organoleptik	\N
827210500	Pengendalian Mutu Hasil Industri Perikanan Laut	\N
827300100	Teknik Pemanenan Rumput Laut dan Pasca Panen	\N
817060111	Mendeskripsikan permasalahan dalam pemboran	\N
804101100	Pekerjaan Dasar Elektromekanik	\N
821060702	Melaksanakan pekerjaan mesin gergaji & gerinda	\N
843060573	Melakukn tata teknik pentas: tt cahaya, tt panggung tt suara	\N
819040100	Dasar Komputasi Proses dan Instrumen Kontrol	\N
806010608	Merawat & memperb. Kelist. sistm refrigrasi & sistm pengatrn	\N
999911413	MP-14 Dasar-Dasar Desain Busana	KRS114
800000191	Kimia Analisis	\N
999911414	MP-15 Penyelesaian Akhir Busana	KRS114
999911415	MP-16 Pelayanan Prima	KRS114
999911416	MP-17 Keselamatan dan Kesehatan Kerja	KRS114
999911417	MP-18 Pembuatan Laporan	KRS114
999915405	Modul 5 (MD5)	KRS154
999912439	MD.3 Prinsip dan unsur  desain  lanjutan 2	KRS124
999912440	MD.4 Ilmu  Hortikultura Lanjutan 2	KRS124
999912445	MD.9 Teknik merangkai rangkaian bunga kiriman dengan tema dukacita	KRS124
999912446	MD.10 Teknik merangkai buket pengantin dengan holder	KRS124
999915703	Pemahaman Peraturan Lalu Lintas (MP MKB 03)	KRS157
999912930	Membangun Usaha Mandiri atau Berkelompok (MA-10)	KRS129
999910712	Evaluasi kondisi klien (MD-7) 	KRS107
800000249	Manajemen Logistik	\N
999915099	Kerjasama dalam pekerjaan	KRS150
999913504	Tugas, Hak dan Tanggung Jawab (MP-02.04)	KRS135
999915108	Pemecahan Masalah (Problem Solving)	KRS150
800000221	Asisten Teknik Laboratorium Medik	\N
999915088	Penataan hidangan makanan prasmanan	KRS150
999915107	R. Standar porsi penyajian (Portion Size Standard)	KRS150
999915702	Mengendalikan kendaraan (MP MKB 02)	KRS157
999915106	Pengawasan sisa bahan makanan	KRS150
800000261	Desain Komunikasi Visual	\N
999915097	Dokumen Operasional	KRS150
999915091	Pengetahuan masakan Indonesia	KRS150
999915104	Pemesanan Bahan makanan	KRS150
999915105	Persiapan Bahan makanan	KRS150
999915087	Resep masakan Kontinental hidangan dari bahan pasta	KRS150
800000223	Farmasi Industri	\N
804090308	Melakukan perhitungan laju aliran  air	\N
812	Tutor KB	PAUD002
999915021	Etika komunikasi	KRS150
800000222	Farmasi Klinis dan Komunitas	\N
999911412	MP-13 Pemasaran Produk Busana	KRS114
800000219	Asisten Keperawatan dan Caregiver	\N
800000224	Pekerja Sosial	\N
999911701	MD 1  Tari Tradisional	KRS117
800000229	Agribisnis Ternak Ruminansia	\N
800000227	Agribisnis Perbenihan Tanaman	\N
800000218	Teknik Transmisi Telekomunikasi	\N
804050450	Pelaksanaan dan Pengawasan Konstruksi dan Properti	\N
800000230	Agribisnis Ternak Unggas	\N
825040205	Membiakkan tanaman dengan teknik kultur jaringan	\N
804120300	Teknik Pengelasan Gas Metal (MIG/MAG)	\N
804170100	Teknik Kelistrikan dan Elektronika Instrumentasi	\N
999911601	Belum Ada Modul	KRS116
800000190	Interior Kapal	\N
800000228	Agribisnis Lanskap dan Pertamanan	\N
807021600	Aircraft Electronic Circuits and Controller	\N
825060311	Melakukan penanganan hewan kesayangan	\N
999915501	Belum Ada Modul	KRS155
839020122	Membuat produk kerajinan kulit non alas kaki & non busana	\N
804131200	Pembuatan Instrumen Logam dan Gelas	\N
825061310	Melakukan penanganan & pemanfaatan limbah ternak unggas	\N
825020106	Mengendalikn organism pengganggu tnmn pngan & hortikultura	\N
825020900	Panen dan pasca Panen Tanaman perkebunan	\N
816010303	Merawat mekanis mesin-mesin persiapan pembuat kain	\N
999902409	Level 9	KRS024
827060700	Navigasi Radar dan Elektronik	\N
831060610	Membuat hiasan pada busana (embroidery)	\N
821060402	Menerapkan konsep dasar perkapalan	\N
999907614	Dasar seni dan desain (MD-03)	KRS076
999902911	Unit Kompetensi Tambahan	KRS029
830040109	Melakukan perawatan klt wajah bermasalah dgn pertln bertek.	\N
831102000	Dasar-dasar Seni Rupa	\N
999915802	Mengendalikan kendaraan (MP MKB 02)	KRS158
834020101	Menggambar teknik, sketsa & bentuk	\N
827390700	Penggunaan Peralatan Kerja Manual dan Bertenaga (Use of Hand and Powertools)	\N
843060931	Menabuh waditra gamelan dlm ... lagu gede embat opat wiled	\N
843070300	Praktik Vokal	\N
828150110	Melakukan pembersihan area umum (Public Area) & peralatan 	\N
807021920	Teknik Pengelasan Pesawat Udara	\N
999905011	Unit Kompetensi Tambahan	KRS050
817150100	Paleontologi 	\N
999901910	Paket/Gaya	KRS019
999900305	Level 5	KRS003
999900905	Level 5	KRS009
999901007	Level 7	KRS010
999901401	Level 1	KRS014
803050400	Penerapan Rangkaian Elektronika	\N
875201011	Menerapkan aircraft material and hardware	\N
999902111	Unit Kompetensi Tambahan	KRS021
999902404	Level 4	KRS024
999902418	(MD-7) Teknik Presentasi	KRS024
999902211	Unit Kompetensi Tambahan	KRS022
999906911	Unit Kompetensi Tambahan	KRS069
999902529	Pemeriksaan Barang Ekspor-Impor	KRS025
825230500	Dasar-dasar Otomatisasi Teknologi Pertanian	\N
999903612	Belum Ada Modul	KRS036
999904011	Unit Kompetensi Tambahan	KRS040
999904308	Level 8	KRS043
999904606	Level 6	KRS046
875170004	Melaksanakan tek. pembentukan & perakitan part pesawat udara	\N
999905523	Pijat Refleksi untuk mengatasi gangguan pada sistem organ (MD-12)	KRS055
999903113	Pengantar Jaringan Komputer (MDIII-2)	KRS031
999904811	Unit Kompetensi Tambahan	KRS048
999904824	Pengetahuan Hama, Penyakit Tanaman dan Gulma	KRS048
999907911	Unit Kompetensi Tambahan	KRS079
999910103	Penyelesaian Siklus Akuntansi	KRS101
828010108	Mengidentifikasi peluang baru dari pelanggan	\N
999905116	Pengantar Bisnis Fotografi (FG-III-5)	KRS051
999905912	Body basic dan music (MD.1) 	KRS059
999906306	Level 6	KRS063
999906407	Level 7	KRS064
999906813	Memakaikan busana pengantin pria dan wanita beserta aksesori	KRS068
999912109	MP9. Dasar-Dasar Manajemen Produksi Acara TV 	KRS121
999904722	Kepabeanan dan Cukai 	KRS047
999907315	Materi Dasar Tubuh Manusia Menurut TCM (MD-04)	KRS073
999907607	Level 7	KRS076
999908205	Level 5	KRS082
999907809	Level 9	KRS078
999908311	Unit Kompetensi Tambahan	KRS083
999908009	Level 9	KRS080
999915705	Teknologi Otomotif (MP MKB 05)	KRS157
999905414	Etika dan Estetika (MD-03)	KRS054
999907819	Membuat Desain (MD-01)	KRS078
999904206	Level 6	KRS042
999905902	Level 2	KRS059
999906519	Pengetahuan Zat Pewarna Kue (MDU III-8)	KRS065
999912625	(MP-25) Petunjuk Penggunaan Printer 3D	KRS126
999901809	Level 9	KRS018
999915406	Modul 6 (MD6)	KRS154
828090200	Otomatisasi Tata Kelola Sarana dan Prasarana	\N
830050200	Pengelolaan Usaha Beauty Aesthetic Pada SPA (Bilingual)	\N
999915701	Persiapan Berkendara (MP MKB 01)	KRS157
999915707	Spesifikasi Kendaraan (MP MKB 07)	KRS157
999915601	Belum Ada Modul	KRS156
999915706	Prosedur Keselamatan (MP MKB 06)	KRS157
999915708	Komunikasi dan Pelayanan (MP MKB 08)	KRS157
999915801	Persiapan Berkendara (MP MKB 01)	KRS158
843090800	Kerja Kreatif Garap Tari	\N
803060600	Perbaikan dan Perawatan Peralatan Elektronika A.V	\N
999915704	Perawatan Kendaraan (MP MKB 04)	KRS157
821200401	Menerapkan kerja dasar logam, pengelasan & listrik	\N
808070701	Membuat rangkaian elekt. terapan berbasis micro-controller	\N
804011400	Ilmu Bahan Teknik dan Gambar Teknik	\N
999800611	Pengembangan Kepribadian Profesional	PKBM006
809020100	Pengolahan Limbah Industri Percetakan 	\N
820040405	Menggunakan alat-alat ukur (measuring tools)	\N
827380105	Melaksanakan peng brg dari gudang ke samping kapal di pelab.	\N
999900613	Mengasuh Bayi	KRS006
999900804	Level 4	KRS008
999901108	Level 8	KRS011
999908523	Sistem kelistrikan engine (MM-5)	KRS085
999915805	Teknologi Otomotif (MP MKB 05)	KRS158
999909501	Komunikasi dalam Bahasa Inggris dengan klien	KRS095
999901511	Unit Kompetensi Tambahan	KRS015
999903411	Unit Kompetensi Tambahan	KRS034
999902517	Kepabeanan ekspor	KRS025
999901210	Paket/Gaya	KRS012
999903420	Tanggung jawab Pengemudi Angkutan Umum (MP MKB 09)	KRS034
999903307	Level 7	KRS033
999904315	Creative Thinking (Berpikir Kreatif) (MD.4)	KRS043
999904406	Level 6	KRS044
999904504	Level 4	KRS045
999904708	Level 8	KRS047
999907505	Level 5	KRS075
999908911	Unit Kompetensi Tambahan	KRS089
999911908	Standart panduan  K3 ditempat kerja ( MP ? 8 )	KRS119
875150001	Menerapkan keselamatan penerbangan sipil	\N
999913107	Pembuatan Pasangan bata lengkung  (MD. 7)	KRS131
999908536	Membangun usaha mandiri atau secara berkelompok (MD-10)	KRS085
834020102	Membuat gambar dasar secara manual & program komputer 3D	\N
999910609	Konseling dan saran kepada klien Akupresur     ( MD ? 8 )	KRS106
999911008	Bekerja dalam lingkungan sosial yang berbeda (MP 3-8)	KRS110
999909105	Panen	KRS091
401251180	Praktikum Akuntansi Lembaga/Instansi Pemerintah	\N
999912614	(MP-14) Komunikasi dan Pengolahan Data	KRS126
999910117	Mengelola Administrasi Pajak Penghasilan WP Orang	KRS101
803080506	Menjelskan teknik pekerj ins & prosdr multiplekser PDH & SDH	\N
999914203	MP3 Perbaikan Panel Bodi Kendaraan	KRS142
999800610	Pendidikan Kewarganegaraan	PKBM006
809010203	Melaksanakan scanning/scanning image	\N
999914801	Konfigurasi pada keamanan komputer (MDK-1)	KRS148
808070705	Memperbaiki sistem transmisi otomatis dgn kontrol elektronik	\N
999910414	Pedoman prakarya menggunakan media dan barang/ bahan bekas (MD-6)	KRS104
825061309	Melakukan penanganan pasca panen ternak unggas	\N
999915085	Resep masakan Kontinental makanan pokok dan pelengkapnya	KRS150
802031505	Memperbaiki radio penerima,compact kaset recorder &CD player	\N
825210161	Mengestimasi hasil produksi & memanen hasil budidaya ikan	\N
805010611	Menggunakan perangkat lunak untuk pengolahan&penyajian data	\N
843090900	Kerja Kreatif Garap Musik Pengiring Tari	\N
999914309	Pemrograman Aplikasi Menggunakan koneksi Bluetooth (MD.IV-09)	KRS143
821080201	Melakukan kerja bangku (logam, kayu, & fiberglass)	\N
809010200	Persiapan Grafika	\N
804051004	Menggun.peraltn tangan, listrik & mesin ttp/sttis peker kayu	\N
803071500	Instalasi dan Perbaikan Perangkat dan Media Transmisi Elektronika	\N
828030106	Mengelola kartu utang, piutang, persediaan, & aktiva tetap	\N
800000116	Dasar Dasar Teknik Ketenagalistrikan	\N
829070700	Pengolahan dan Penyajian Makanan Kontinental	\N
999904712	Ketentuan Umum dan Tata cara Perpajakan (KUP)	KRS047
999915022	Pengetahuan dan Penanganan Bahan makanan	KRS150
825060808	Menangani reproduksi ternak ruminansia	\N
831060601	Melaksanakan pemeliharaan kecil mesin jahit	\N
999910408	Etika Profesi Pengasuh Anak (MD-8)	KRS104
401001000	Matematika (Peminatan)	\N
999908814	GSE (Ground Support Equipment)	KRS088
999915709	Tanggung jawab Pengemudi Angkutan Umum (MP MKB 09)	KRS157
804100507	Mengukur tahanan peralatan listrik,isolasi,&kontak sambungan	\N
802031501	Menerapkan keselamatan, kesehatan kerja (K3)	\N
800000274	Produksi dan Siaran Program Radio	\N
803040700	Operasi dan Pemeliharaan Jaringan Akses Pelanggan	\N
999915807	Spesifikasi Kendaraan (MP MKB 07)	KRS158
999916304	MD 4. Praktikum Komputerisasi Perpajakan 	KRS163
999901707	Level 7	KRS017
999901409	Level 9	KRS014
800000133	Dasar Dasar Teknika Kapal Penangkapan Ikan	\N
875160008	Melakukan pekerjaan pemesinan untuk pembuatan komponen 	\N
999915806	Prosedur Keselamatan (MP MKB 06)	KRS158
999902222	Mobilisasi dan transportasi (MD-11)	KRS022
999910601	POS Pelayanan Akupresur, Etika dan Hukum serta Peraturan Pemeritah (MD-1)	KRS106
999905307	Level 7	KRS053
999908803	Level 3	KRS088
999914701	Pengetahuan Penunjang Web Programmer (MP.IV-1)	KRS147
800030105	Menjelaskan dasar-dasar penyakit & farmakologi	\N
800030203	Menerapkan perencanaan produksi & pengendalian inventory	\N
999912101	MP1. Pancasila	KRS121
999900508	Level 8	KRS005
999915804	Perawatan Kendaraan (MP MKB 04)	KRS158
875160009	Merakit komponen pemesina	\N
805010300	Dasar-dasar Perhitungan Survey Pemetaan	\N
999900407	Level 7	KRS004
999800415	Keterampilan: Fungsional Terstruktur/Tersertifikasi	\N
830050104	Melakukan pemangkasan rambut & penataan rambut	\N
843011100	Dasar Penguasaan Instrumen	\N
843011730	Koor/Orkes	\N
999900309	Level 9	KRS003
999901203	Level 3	KRS012
825050700	Produksi, Pengolahan. Dan Pemasaran Benih Tanaman	\N
999902415	(MD-4) Rencana Anggaran Biaya	KRS024
999902420	(MD-9) Hubungan Kerja dengan Pemberi Tugas	KRS024
999902922	Liputan Tidak Terjadwal/Di Luar Program (Md-16)	KRS029
999903410	Paket/Gaya	KRS034
827010101	Menerapkan hukum laut & manaj. operasional kpl penangkp ikan	\N
843060580	Memainkan karawitan iringan Wayang tingkat Pengrawit	\N
843060582	Memainkan karawitan (PKB) Gamelan Perunggu gaya Banyumas	\N
843060901	Memainkan kelompok instrumen balungan tingkat pengrawit	\N
843080700	Karawitan Pedalangan	\N
999800711	Pendidikan Agama	PKBM007
100011070	Pendidikan Agama Islam dan Budi Pekerti	\N
999904713	Pajak Daerah dan Retribusi Daerah	KRS047
999905421	Teknologi Informasi (Internet) dan Sistem Tata Suara (MD-10)	KRS054
401251106	Komputer Akuntansi Perbankan Syariah	\N
802032400	Videografi	\N
802032501	Mengoperasikan komputer grafis	\N
802032502	Melaksanakan proses pekerjaan fotografi	\N
803030500	Pengoperasian dan Pemeliharaan Suitsing STDI	\N
813010101	Menerapkan dasar-dasar instrumentasi	\N
813010103	Menerapkan konsep elektronika instrumentasi	\N
824060500	Manajemen Produksi, Naskah dan Penyutradaraan	\N
825040200	Produksi Bibit dan kultur Jaringan	\N
825060304	Memberikan pengobatan & vaksin ternak	\N
825060600	Agribisnis Ternak Ruminansia Perah	\N
825210108	Menganlisis secara fisik bhn hasil pertanian & bahan kemasan	\N
827190120	Teknik Pengembangbiakan Komoditas Perikanan Air Tawar	\N
999910410	Pengenalan Fungsi Anggota Gerak Tubuh Anak (MD-2)	KRS104
999915095	Penghidangann atau tata hidangan	KRS150
999906437	MD 8 Terapi Ternal Menggunakan Selimut Panas	KRS064
999915803	Pemahaman Peraturan Lalu Lintas (MP MKB 03)	KRS158
999915808	Komunikasi dan Pelayanan (MP MKB 08)	KRS158
999916810	Pengetahuan analisis biaya (MDU III-9)	KRS168
800000173	Teknik Konstruksi Badan Pesawat Udara (Aircraft Sheet Metal Forming)	\N
200030060	Berekayasa dan Berteknologi untuk Membangun NKRI (P4 Pancasila & Budaya Kerja)	\N
800000257	Tata Kecantikan Kulit dan Rambut	\N
401251600	Pengemasan dan Pengiriman Produk	\N
804050805	Melakukan pengelolaan pekerjaan konstruksi batu & beton	\N
816010305	Membuat kain dgn msn tenun teropong mnggunkn dobby& jacquard	\N
999906429	Menerapkan Lingkungan Kerja Bersih dan Aman di SPA, sesuai Prinsip K3	KRS064
999915809	Tanggung jawab Pengemudi Kendaraan Pribadi (MP MKB 09)	KRS158
800000225	Agribisnis Tanaman Perkebunan	\N
843011740	Orkestra	\N
843011741	Orkestra/AnsambelLanjut	\N
999903419	Komunikasi dan Pelayanan (MP MKB 08)	KRS034
999904411	Unit Kompetensi Tambahan	KRS044
999904720	PPh Pasal 21	KRS047
999905416	Pengembangan Diri (MD-05)	KRS054
829010100	Tata Graha	\N
829010200	Housekeeping	\N
829020200	Binatu	\N
829050500	Boga Dasar	\N
999915902	MD 2. Pajak Daerah dan Retribusi Daerah 	KRS159
999916405	MD. 5. Pemeriksaan Bea dan Cukai	KRS164
999916501	MD. 1. Ketentuan Umum dan Tatacara Perpajakan (KUP) 	KRS165
999914708	Identifikasi library, komponen, atau code framework yang diperlukan (MP.IV-8)	KRS147
999908532	Sistem rem yang dikontrol secara elektronik (MD-6)	KRS085
839020121	Membuat produk alas kaki	\N
827350103	Menerapkan bahasa inggris maritim	\N
827350200	Ilmu Pelayaran Datar (Terrestrial Navigation)	\N
826040300	Dendrologi	\N
827280111	Melakukan pengembangan pasca panen rumput laut	\N
825250200	Pengujian Secara Kimia, dan Instumental	\N
825280300	Dasar Proses Pengolahan Hasil Pertanian	\N
828080104	Mengelola transaksi di bi&g &a bank syariah	\N
999916801	Pengolahan Kue Kontinental (MDCIII-1)	KRS168
828080128	Menjelaskan sumber pendanaan bank	\N
825280100	Dasar Penanganan Bahan Hasil Pertanian	\N
828080127	Menjelaskan prinsip keuangan dan lembaga keuangan	\N
839020123	Mencetak kulit dengan mesin press	\N
839020124	Menyeset kulit dengan pisau seset manual & seset masinal	\N
828080105	Mengelola proses pembiayaan di bank syariah	\N
843050500	Band	\N
843060543	Menarikan Tari Keurseus	\N
999904609	Level 9	KRS046
999914802	Pemeliharaan pada keamanan komputer (MDK-2)	KRS148
999904610	Paket/Gaya	KRS046
802032100	Game Edukasi	\N
999910608	pelaporan, dokumentasi dan pengarsipan  (MD-7)	KRS106
999904701	Level 1	KRS047
999904702	Level 2	KRS047
999906515	Pemasaran Produk Pastry (MDUIII-7)	KRS065
999906513	Penyajian Kue (MDUIII-1)	KRS065
999906815	Membuat sanggul pengantin wanita beserta aksesori 	KRS068
999904703	Level 3	KRS047
802031101	Memahami dasar-dasar animasi	\N
999907813	Pengetahuan bahan dan alat(MD-02)	KRS078
999913003	Pengoperasian dasar Excavator /  Dump Truck / Loader 	KRS130
809010205	Menggabung image secara manual & elektronik	\N
999912814	Dasar penggunaan buku manual pengoperasian dan perawatan serta suku cadang	KRS128
802031506	Memperbaiki sistem penerima televisi	\N
999913602	Komponen Konstruksi kayu bangunan gedung  (MP.2)	KRS136
809010206	Membuat layout siap ke film atau pelat	\N
600060020	Prakarya dan Kewirausahaan (Budidaya)	\N
803030503	Melakukan ins. perangkat terminal & jaringan telekomunikasi 	\N
808070711	Memperbaiki sistem kontrol parkir	\N
843090306	Memerankan tokoh dalam drama sesuai dengan karakter 	\N
999905818	Pengetahuan kesekretarisan	KRS058
999902711	Unit Kompetensi Tambahan	KRS027
828200110	Pengelolaan Meeting, Incentive, Conference dan Exhibition	\N
829020300	Laundry	\N
843060902	Memainkan kelompok instrumen struktural tingkat pengrawit	\N
829020410	Food and Beverage Service	\N
829020600	Banquet Management	\N
829020700	Rooms Division Management	\N
829030300	Tata Hidang	\N
829040400	Pengetahuan Bahan Makanan	\N
829060600	Ilmu Gizi	\N
829020400	Food and Beverage	\N
999916705	MD. 5. Pemeriksaan Pajak	KRS167
999908201	Level 1	KRS082
825270100	Pengujian Mutu Pangan	\N
801031200	Perawatan dan Pelayanan Lansia	\N
999916703	MD. 3. Manajemen Perkantoran 	KRS167
999906819	Membuat sanggul pengantin wanita 	KRS068
999916505	MD. 5. Pemeriksaan Pajak	KRS165
999916506	MD. 6. Akuntansi Perpajakan	KRS165
999916704	MD. 4. Praktikum Komputerisasi Perpajakan 	KRS167
999916603	MD. 3. Manajemen Perkantoran 	KRS166
999916604	MD. 4. Praktikum Komputerisasi Perpajakan 	KRS166
999901710	Paket/Gaya	KRS017
999916701	MD 1. PPh Pasal 26	KRS167
999916803	Pengendalian Biaya dan Pembukuan (MDU III-2)	KRS168
999916802	Penyajian Kue (MDUIII-1)	KRS168
999916504	MD. 4. Praktikum Komputerisasi Perpajakan 	KRS165
999916503	MD. 3. Manajemen Perkantoran 	KRS165
999904705	Level 5	KRS047
999916804	Pemasaran Produk Pastry (MDUIII-7)	KRS168
802030100	Desain Grafis	\N
999903804	Level 4	KRS038
999916606	MD. 6. Akuntansi Perpajakan	KRS166
999901305	Level 5	KRS013
999901506	Level 6	KRS015
802021500	Maintenance and Repair Personel Komputer	\N
999916601	MD. 1. Ketentuan Umum dan Tatacara Perpajakan (KUP) 	KRS166
999904403	Level 3	KRS044
999904409	Level 9	KRS044
999901911	Unit Kompetensi Tambahan	KRS019
999901407	Level 7	KRS014
999904313	Perkembangan Teknologi Editing (MD.2)	KRS043
999916502	MD. 2. Pajak Penghasilan Badan 	KRS165
999904611	Unit Kompetensi Tambahan	KRS046
999904208	Level 8	KRS042
999904006	Level 6	KRS040
802032110	Teknologi Pengolahan Audio dan Video	\N
821060708	Melakukan pekerjaan listrik dasar	\N
825250110	Melakukan analisis parameter lingkungan	\N
999904704	Level 4	KRS047
826010100	Silvika	\N
826010200	Silvikultur	\N
804160500	Teknik Desain Gambar dengan CAM	\N
809020200	Cetak Datar	\N
806010605	Membaca gambar mesin pendingin 	\N
809020900	Proses Cetak	\N
809020500	Cetak Datar dan Cetak Digital	\N
809021000	Teknik Cetak	\N
810010100	Setting	\N
819050108	Melaksanakan proses pengolahan limbah kimia	\N
828150108	Melakukan pembukuan keuangan	\N
828150109	Melaksanakan & memproses dokumen kantor	\N
828150113	Melakukan, melyni memproses penangnn linen & pakaian tamu 	\N
828160100	Public Relation	\N
828180100	Perencanaan dan Pengelolaan Perjalanan 	\N
828190100	Pemanduan Perjalanan Wisata	\N
843060953	Memainkan instrumen kendang gupekan	\N
843060955	Memainkan gender wayang	\N
844040100	Menggambar Busana (Fashion drawing)	\N
999901406	Level 6	KRS014
999904711	Unit Kompetensi Tambahan	KRS047
999904823	Pengetahuan Media Tanam	KRS048
999904826	Pengetahuan Pemeliharaan Tanaman	KRS048
817030101	Menerapkan geologi dasar	\N
999904901	Level 1	KRS049
999906622	Perawatan Wajah Berkomedo Secara Manual (MD.3)	KRS066
800030206	Melakukan penarikan kembali obat jadi	\N
999904822	Pengetahuan Tanaman Taman	KRS048
999907701	Level 1	KRS077
999907702	Level 2	KRS077
800000242	Teknika Kapal Penangkapan Ikan	\N
999908519	Sistem bahan bakar motor bensin (MM-1)	KRS085
999908527	Alat Bantu Diagnosis (MD-1)	KRS085
999914814	Kerahasiaan Perusahaan (MDHTJ-3)	KRS148
999913814	Perangkat Lunak/Software (HPS-06)	KRS139
999914404	Tugas dan peran seorang Drafter (MD-4)	KRS144
999914703	Melakukan Debuging  (MP.IV-3)	KRS147
999914705	Metode Pembuatan Halaman Web Dinamis (MD.IV-5)	KRS147
999914706	Pemrograman Berbasis Objek  (MP.IV-6)	KRS147
999914909	K3 Teknik Komputer	KRS149
999914704	Membuat program web untuk akses basis data   (MP.IV-4)	KRS147
999914707	Menggunakan Pustaka (library) atau Komponen Pre-existing  (MP.IV-7)	KRS147
999914403	Pengoperasian program aplikasi CAD (MD-3) 	KRS144
999914904	Perangkat Lunak komputer  (MD-4)	KRS149
999914906	Pengembangan Diri  (MD-6)	KRS149
800060306	Menerapkan praktik keperawatan gigi 	\N
999914901	Komunikasi Efektif (MD-1)	KRS149
999914910	Perencanaan Anggaran	KRS149
999914907	Pengantar Komputer   (MD-7)	KRS149
999914908	Elektronika dasar 	KRS149
808080800	Electrical Avionics Drawing	\N
800000166	Teknik Kendaraan Ringan	\N
999914905	Pemeliharaan Data  (MD-5)	KRS149
999915003	Penimbangan bahan	KRS150
821190500	Perawatan dan Perbaikan Peralatan Kelistrikan Kapal	\N
999914903	Sistem Operasi  (MD-3)	KRS149
817030103	Menerapkan konsep eksplorasi hidrokarbon	\N
829111101	Melakukan komunikasi dalam pelayanan jasa	\N
999916805	Inovasi Kue Kontinental MDO-2)	KRS168
817030102	Menerapkan ilmu batuan & bahan galian	\N
999915089	Penataan hidangan Coffe break	KRS150
999908808	Level 8	KRS088
999916806	Teknik Pengukuran (MDU-4)	KRS168
999916807	Pengetahuan Oprasional Pembuatan Kue (MDO-4)	KRS168
800000126	Dasar Dasar Pekerjaan Sosial	\N
401130120	Kimia (Agrobisnis dan Agroteknologi)	\N
825220400	Penanganan Pasca Panen,Pengolahan Hasil dan Penyimpanan Produk Pertanian Organik	\N
999907007	Level 7	KRS070
801031600	Pelayanan Kesejahteraan Sosial	\N
820100101	Menggunakan peralatan & perlengkapan tangan di tempat kerja	\N
999907411	Unit Kompetensi Tambahan	KRS074
999904821	Administrasi Laporan Pekerjaan	KRS048
999913009	Komponen utama alat berat excavator (MD-9a)/ dump truk (MD-9b)/ Loader (MD-9c)	KRS130
800000167	Teknik Sepeda Motor	\N
999905115	Olah Digital Dasar (FG-III-4)	KRS051
800000170	Teknik Bodi Kendaraan Ringan	\N
999902312	Perintah Kerja Design DG?SP-01	KRS023
800000168	Teknik Alat Berat	\N
800000165	Teknik Pemesinan Kapal	\N
800000163	Teknik Pemesinan Pesawat Udara (Aircraft Machining)	\N
999907628	Pelayanan prima  (MD-09)	KRS076
800000171	Teknik Pengelasan	\N
800000164	Teknik Konstruksi Rangka Pesawat Udara (Airframe Mechanic)	\N
800001000	Praktik Kerja Lapangan	\N
800030205	Melakukan monitoring barang kadaluwarsa & pemusnahannya	\N
800030207	Menjelaskan penelitian & pengembangan produk	\N
999914709	Pembuatan Dokumen Kode Aplikasi Web (MP.IV-9)	KRS147
804090302	Memasang alat sanitair	\N
800060310	Menjelaskan ilmu gizi dalam lingkup keperawatan	\N
800060311	Menerapkan swamedikasi	\N
804100510	Memelihara peralatan DC power	\N
999904828	Tata Laksana Kerja	KRS048
999916010	MD 5. Pemeriksaan Pajak	KRS160
999906720	Pratata Dasar (MD-04)	KRS067
999902915	Teknik Wawancara (Md-3.4)	KRS029
804090303	Menerapkan sistem penyediaan air bersih	\N
804100601	Memasang APP & alat ukur	\N
804100200	Penggerak Mula	\N
804100500	Jaringan Transmisi Tenaga Listrik	\N
500040000	Pendidikan Jasmani dan Olahraga	\N
804100501	Memelihara sarana elektronik, komunikasi & penunjang	\N
804100503	Memasang & memelihara kelengkapan isolator	\N
804100504	Menyambung kawat saluran udara	\N
804100505	Memasang jumper konduktor switchgear & groundwire	\N
804100506	Memasang ins. penangkal petir & pembumian gedung	\N
804100508	Mengukur temperatur titik sambung&ratio kumparan trafo daya	\N
804100509	Memasang tap changer & mengganti transformator daya	\N
999902916	Komunikasi Di Era Internet (Md-3.5)	KRS029
804100810	Teknik Instalasi Penerangan Listrik	\N
804100820	Teknik Instalasi Pneumatik	\N
804100902	Menerapkan pekerjaan mekanik dasar 	\N
804100903	Menerapkan dasar-dasar elektronika	\N
804100906	Memasang ins. tenaga listrik	\N
804100907	Memperbaiki motor listrik	\N
804100909	Memasang sistem pentanahan ins. listrik	\N
804110106	Memelihara sistem kendali elektrik	\N
804110107	Memelihara sistem kendali pneumatik 	\N
804110200	Kelistrikan Mesin dan Konversi Energi	\N
809010810	Penyelesain Grafika	\N
809020300	Cetak Khusus	\N
809020400	Cetak Tinggi dan Cetak dalam	\N
809020700	Pembuatan Acuan Cetak	\N
809020800	Perwajahan	\N
817010106	Melakukan pemetaan geologi	\N
843090308	Melaksanakan tata panggung, dekorasi, tata cahaya & suara	\N
999902913	Hubungan Wartawan Dan Narasumber (Md-3.2)	KRS029
999902914	Teknik Menulis Berita (Md-3.3)	KRS029
999906404	Level 4	KRS064
999905506	Level 6	KRS055
801030302	Melakukan kerja sama di lingkungan sosial klien	\N
801030500	Praktikum Perawatan Sosial	\N
999905508	Level 8	KRS055
999905507	Level 7	KRS055
999902919	Manual Alat Kerja (Md-3.9)	KRS029
999905509	Level 9	KRS055
999906402	Level 2	KRS064
999906722	Pengecatan rambut uban (MD-06)	KRS067
999913006	Modul komunikasi/ presentasi (MD-6).	KRS130
999906405	Level 5	KRS064
401251400	Perencanaan Bisnis	\N
999902909	Level 9	KRS029
804090304	Memasang ins. pipa air kotor	\N
600070100	Produk Kreatif dan Kewirausahaan	\N
999906723	Penataan sanggul cemara (MD-07)	KRS067
999906725	Pemangkasan Desain (MD-02)	KRS067
999906726	Pewarnaan Desain (MD-03)	KRS067
999906728	Pengeritingan Desain (MD-05)	KRS067
999906729	Pratata Desain (MD-06)	KRS067
999906730	Penataan Desain (MD-07)	KRS067
999906731	Penataan Rambut Panjang/Sanggul Modern (MD-08)	KRS067
999907306	Level 6	KRS073
999907821	Packaging (MD-03)	KRS078
999907918	Manajemen Produksi (MD-02)	KRS079
999908102	Level 2	KRS081
999908703	Sistem Operasi  (MD-3)	KRS087
999908103	Level 3	KRS081
999908611	Unit Kompetensi Tambahan	KRS086
999908704	Pengolah Kata (MD-4)	KRS087
999912437	MD.1 Sarana penunjang merangkai bunga lanjutan 2 	KRS124
999912438	MD.2 Pengetahuan warna lanjutan 2 	KRS124
999912448	MD.12 Teknik merangkai perlengkapan bunga pengantin( flowers to wear )	KRS124
999912449	MD.13 Teknik merangkai buket  pengiring pengantin	KRS124
999912450	MD.14 Teknik membuat sketsa untuk dekorasi ruangan 	KRS124
999912451	MD.15 Teknik membuat rangkaian backdrop	KRS124
999912452	MD.16 Teknik merangkai bunga standing	KRS124
999912908	Sikap dan Tata Nilai (MD-8) 	KRS129
875190008	Menerapkan dasar instrumen pesawat udara	\N
999912456	MD.21 Teknik pengiriman rangkaian bunga segar	KRS124
820070106	Melakukan perbaikan sistm transmisi spd mtr manual&otomatis	\N
825210200	Dasar Proses Pengolahan Hsl Pertanian & Perikanan	\N
839020145	Membentuk keramik dengan teknik cetak 	\N
800000124	Dasar Dasar Teknik Laboratorium Medik	\N
999902918	TEKNIK LIPUTAN (MD-3.7)	KRS029
999915092	Pengetahuan Masakan Oriental	KRS150
800000125	Dasar Dasar Teknologi Farmasi	\N
999906406	Level 6	KRS064
800000169	Teknik Ototronik	\N
800000161	Teknik Pengecoran Logam	\N
804050504	Melaksanakan pekerjaan konstruksi kayu	\N
999906403	Level 3	KRS064
800060309	Menjelaskan penggunaan herbal dalam keperawatan	\N
803050100	Pengetahuan Listrik, Elektronika dan Digital	\N
800060308	Melaksanakan pekerjaan laboratoris gigi	\N
999906721	Penataan rambut pendek (MD-05)	KRS067
500050000	Bimbingan dan Konseling/Konselor (BP/BK)	\N
800060307	Melaksanakan penatalaksanaan kedaruratan gigi & mulut	\N
804090301	Menerapkan dasar-dasar plumbing	\N
804100606	Memperbaiki gangguan pd alat pembatas & pengukur	\N
839020106	Membuat kria tekstil dengan teknik makrame	\N
804100608	Mengoperasikan pole top switch & saklar semi automatic	\N
804100609	Mengoperasikan automatic & capacitor voltage regulator	\N
804100610	Memasang & memelihara peralatan pendukung	\N
804100700	Gardu Induk	\N
804100908	Mengoperasikan sistem pengendali 	\N
999915093	Pengetahuan masakan Kontinental	KRS150
839020142	Membuat cetakan pekerjaan keramik	\N
835010200	Reproduksi 3D	\N
839020125	Menjahit kulit dengan tangan & mesin	\N
999912811	Dasar-dasar undercarriage (MD-11)	KRS128
999903409	Level 9	KRS034
839020126	Membentuk produk kulit dengan kulit perkamen	\N
999902910	Paket/Gaya	KRS029
839020128	Membuat produk kulit bentuk busana	\N
839020141	Mengolah clay body menjadi tanah liat plastis	\N
999903415	Perawatan Kendaraan (MP MKB 04)	KRS034
804090307	Membuat gambar ins. plambing	\N
839020108	Membuat kria tekstil dengan teknik kristik & sulam	\N
839020127	Membentuk produk kulit dengan teknik tatah sungging	\N
999907101	Level 1	KRS071
999908705	Pengolah Angka (MD-5)	KRS087
999908709	Tata Laksana Kerja (MD-9)	KRS087
999908710	Paket/Gaya	KRS087
999908711	Unit Kompetensi Tambahan	KRS087
999911403	MP-4  Pola Draping	KRS114
999911404	MP-5  Pola Busana Secara Konstruksi	KRS114
999911405	MP-6  Membuat Pola dengan CAD Sistem	KRS114
999911907	Pedoman undang ? undang penyiaran ( MP-7 )	KRS119
999912803	Alat dan Peralatan Kerja (MD. 3)	KRS128
999912922	Engine Management System (MA-2)	KRS129
999912810	Dasar sistem rem (MD-10)	KRS128
825210600	Teknik Pembesaran Komoditas Air Payau dan Laut	\N
999914810	Jenis dan metode keamanan website (MDP-6)	KRS148
999912805	Dasar-dasar power train tipe rantai (chain) (MD-5)	KRS128
825210700	Teknik Pendederan Komoditas Air Payau dan Laut	\N
843080108	Menulis naskah cerita wayang utuh	\N
843080131	Melakukan olah vokal tembang	\N
843080132	Melakukan teknik dasar dodogan, keprakan/cepala	\N
843080109	Merencanakan & mendemonstrasikan pentas wayang	\N
843080200	Pengetahuan Pedalangan	\N
999905808	Level 8	KRS058
999906416	MD 5. Terapi Perawatan Badan: dengan Masker Badan Tradisional	KRS064
999906417	MD 6. Terapi Perawatan Badan: Hair Spa	KRS064
999906414	MD 3. Terapi Pijat: Pijat Tradisional Indonesia	KRS064
999915004	Teknik Mengupas Aneka Bahan	KRS150
999906636	Merias Wajah Karakter sesuai tema (MD.8)	KRS066
804100900	Instalasi Tenaga Listrik	\N
999906635	Merias Wajah foto/TV/film berwarna dan hitam putih (MD.7)	KRS066
999905810	Paket/Gaya	KRS058
999906637	Merias Wajah Fantasi sesuai tema (MD.9)	KRS066
999906638	Merawat badan dengan teknologi alat listrik (MD.10)	KRS066
999906639	Merawat badan secara tradisional (MD.11)	KRS066
999906640	Pengetahuan Penunjang Sebagai Ahli Kecantikan (MD.12)	KRS066
999906706	Level 6	KRS067
999906704	Level 4	KRS067
999906705	Level 5	KRS067
999907108	Level 8	KRS071
999907111	Unit Kompetensi Tambahan	KRS071
999907110	Paket/Gaya	KRS071
999907201	Level 1	KRS072
999905809	Level 9	KRS058
999915005	Teknik Memotong Aneka Bahan	KRS150
999915006	Cara Menyiapkan Bahan Berdasarkan Resep	KRS150
999915007	Bumbu rempah dan penanganannya	KRS150
999915094	Macam?macam metode pengolahan	KRS150
999915096	Aplikasi Metode Pengolahan Makanan	KRS150
999907915	Prinsip Dasar Animasi (MD-03)	KRS079
999907002	Level 2	KRS070
820030400	Perawatan dan Perbaikan Motor Diesel Pembangkit	\N
999908414	Struktur dan fungsi tubuh manusia (MD-3)	KRS084
839020147	Membuat dekorasi keramik clay body plastis & leather hard	\N
999907112	Belum Ada Modul	KRS071
999912112	Penilaian Kualitas Program Siaran Televisi dari aspek Perusahaan & Penonton	KRS121
839110200	Non Alas Kaki dan Non Busana Kulit dan Imitasi	\N
999901206	Level 6	KRS012
999901304	Level 4	KRS013
999911209	Etika Profesi (MD-09)	KRS112
820070107	Melakukan perbaikan sistem rem & suspensi sepeda motor	\N
802020301	Menjelaskan algoritma pemrograman	\N
804100800	Instalasi Penerangan Listrik	\N
804100605	Mengoperasikan saluran udara & SUTR	\N
804090309	Menerapkan perencanaan pompa air	\N
804090310	Menerapkan sistem pengolahan limbah 	\N
804100100	Dasar dan Pengukuran Listrik	\N
804100300	Generator	\N
804100502	Memelihara sistem kelistrikan & instrumen kontrol & proteksi	\N
804100602	Memasang saluran tegangan rendah & menengah	\N
804131600	Pengecoran Logam	\N
804131510	Pembubutan Logam	\N
804131105	Memperbaiki instrumentasi	\N
401210000	Ilmu Pengetahuan Sosial (Geografi)	\N
401220000	Geografi	\N
804131530	Pengelasan dan Pembubutan	\N
804131500	Pembubutan Logam dan Pengelasan Logam	\N
814100108	Melakukan proses pemintalan basah	\N
804131300	Teknologi dasar Pengerjaan Logam	\N
814100132	Menerapkan dasar-dasar ilmu tekstil	\N
814100133	Melaksanakan proses pemintalan	\N
825100400	Teknologi Otomatisasi Alat Mesin Pemeliharaan	\N
825110100	Alat Mesin Pasca Panen	\N
875201005	Menerapkan electronic fundamental	\N
875201004	Menerapkan electrical fundamental	\N
875201006	Menerapkan teknik digital	\N
875201007	Merawat radio communication & navigation	\N
875201008	Menerapkan electronic instrument system	\N
875201009	Menerapkan maintenance practice	\N
875201010	Merawat aircraft system	\N
999900402	Level 2	KRS004
999900403	Level 3	KRS004
999901411	Unit Kompetensi Tambahan	KRS014
999900405	Level 5	KRS004
999900406	Level 6	KRS004
999900408	Level 8	KRS004
999900409	Level 9	KRS004
999901701	Level 1	KRS017
999903116	IP Addressing (MDIII-5)	KRS031
999901501	Level 1	KRS015
999913810	Avometer (HPS - 02)	KRS139
999901502	Level 2	KRS015
999901503	Level 3	KRS015
999901504	Level 4	KRS015
999901702	Level 2	KRS017
999901703	Level 3	KRS017
999901704	Level 4	KRS017
999901705	Level 5	KRS017
999901706	Level 6	KRS017
999903111	Unit Kompetensi Tambahan	KRS031
999902207	Level 7	KRS022
999901412	Belum Ada Modul	KRS014
999902210	Paket/Gaya	KRS022
999904001	Level 1	KRS040
999907326	Terapi Kerokan (MD-16)	KRS073
999904002	Level 2	KRS040
999904005	Level 5	KRS040
999904007	Level 7	KRS040
999904008	Level 8	KRS040
999908013	Modul K3 (ED-02.01)	KRS080
999907401	Level 1	KRS074
999908015	Modul Teori Dasar Listrik (ED-02.03)	KRS080
999908018	Modul Resistor (ED-02.04)	KRS080
999908016	Modul AVO meter (ED-02.04)	KRS080
999908019	Modul Induktor dan Transformator (ED-02.05)	KRS080
999908020	Modul Kapasitor (ED-02.06)	KRS080
999908021	Modul Dioda (ED-02.07)	KRS080
999908025	Modul Catu daya (ED-02.11)	KRS080
999908501	Level 1	KRS085
999908502	Level 2	KRS085
999908423	Pemberian obat (MD-12)	KRS084
999912433	MD.20 Macam-macam Teknik  desain	KRS124
999908425	Pencatatan dan Pelaporan (MD-14)	KRS084
999908503	Level 3	KRS085
999912459	MD.24 Etika kerja	KRS124
999912501	Belum Ada Modul	KRS125
999912703	Sensor dan Aktuator  (PLC-03)	KRS127
999912915	MD-6  Sistem Bahan Bakar 	KRS129
999912916	MD-7  Sistem Pemindah Tenaga	KRS129
999912917	MD-8  Sistem Kelistrikan	KRS129
999912706	Layanan Pelanggan (PLC-06)	KRS127
999912918	MD-9  Sistem Rangka dan Suspensi 	KRS129
999912919	MD.10  K3 dan 5R Bengkel	KRS129
999912920	MD.11  Standar Operasional prosedur Bengkel	KRS129
999914401	Menggambar teknik dasar (MD-1)	KRS144
804111200	Pekerjaan Dasar Teknik Mesin	\N
804120100	Teknik Pengelasan Oksi-Asetilin (OAW)	\N
804120200	Teknik Pengelasan Las busur Manual (SMAW)	\N
817030104	Menjelaskan tentang geologi migas & fluida reservoir	\N
999912929	Teknik Komunikasi Dalam Bahasa Indonesia Dan Inggris(MA-9)	KRS129
999913812	Teknik Penyolderan (HPS - 04)	KRS139
109011000	Pendidikan Kepercayaan terhadap Tuhan YME	\N
814100107	Meakukan pengujian bhn baku pulp, penimb. & pengeringan	\N
800000210	Teknik Produksi Minyak dan Gas	\N
999917002	Pengendalian Biaya & Inovasi Dekorasi Kue dan Coklat (MDU-2)	KRS170
999915008	Bahan dan bumbu pengolahan kaldu	KRS150
999913811	Catu daya (HPS - 03)	KRS139
400100000	Guru Kelas PAUD/TK/RA	\N
802032506	Membuat produk desain komunikasi mengrh ke media ind&outdoor	\N
806010604	Melakukan perawatan & perbaikan mesin pendingin&cold storage	\N
822060105	Memperb. pelind. Moulding. gmbr2 hiasan stiker lis & spoiler	\N
843080101	Menerapkan teknik dasar memainkan wayang	\N
828080121	Menjelaskan konsep bank umum berdasarkan prinsip syariah	\N
999902214	Struktur dan fungsi tubuh manusia (MD-3)	KRS022
999902209	Level 9	KRS022
999917003	Higiene dan Sanitasi & Pengetahuan Bahan Makanan (MDU-3)	KRS170
803071000	Pengendali Sistem Robotik	\N
800000209	Geologi Pertambangan	\N
800000212	Teknik Pengolahan Minyak, Gas dan Petrokimia	\N
800000215	Sistem Informasi, Jaringan, dan Aplikasi	\N
803070900	Pembuatan , Perbaikan dan PemeliharaanPeralatan Elektronika	\N
999915009	Pembuatan kaldu ayam (White Chicken Stock)	KRS150
999900404	Level 4	KRS004
825100500	Teknologi Otomatisasi Alat Mesin Pengolahan Hasil Pertanian	\N
401230000	Sejarah	\N
401231000	Sejarah Indonesia	\N
401233000	Sejarah Budaya	\N
401240000	Sosiologi	\N
401241000	Sosiologi	\N
109011010	Pendidikan Kepercayaan terhadap Tuhan YME dan Budi Pekerti	\N
131001000	Sastra Indonesia	\N
200010000	Pendidikan Pancasila dan Kewarganegaraan 	\N
803071200	Instalasi dan Perbaikan Sistem Televisi	\N
803071300	Penerapan Rangkaian Elektronika daya dan komunikasi	\N
803071400	PenerapanSistem Transmisi Gelombang Elektromagnetik	\N
803080100	Perekayasaan Sistem Komunikasi	\N
825110110	Workshop Alat Mesin Pertanian	\N
825110200	Teknik Penanganan Pasca Panen	\N
875201001	Menerapkan ilmu aerodynamic and flight control	\N
875201002	Merawat aircraft structure & propulsion	\N
999914805	Jenis dan fungsi perangkat keamanan jaringan (MDP-1)	KRS148
999914807	Jenis dan metode keamanan sistem operasi untuk klien (MDP-3)	KRS148
999914808	Jenis dan metode keamanan basis data (MDP-4)	KRS148
999914809	Jenis-jenis serangan komputer (MDP-5)	KRS148
999914812	Tanggungjawab Pekerjaan (MDHTJ-1)	KRS148
999915111	Post Shift & Pre Shift	KRS150
999915113	Peraturan dan Standar kerja	KRS150
999915114	Standar Penyimpanan	KRS150
999915115	Hygiene dan sanitasi	KRS150
999915116	Tata Cara Melakukan Promosi	KRS150
999915118	Kontrol Biaya Produksi 	KRS150
999915119	Analisa dan Evaluasi Pelayanan	KRS150
999915120	Metode Pemilihan dan penilaian Calon Karyawan	KRS150
999915121	Tata Tertib Kerja	KRS150
999915122	Komunikasi dan Pelayanan	KRS150
999915123	Rencana Kebutuhan Bahan	KRS150
999915124	Penyimpanan bahan	KRS150
999915125	Rencana Pemanfaatan Bahan	KRS150
999915126	Laporan Pelaksanaan Kerja	KRS150
999912617	(MP-17) Kecerdasan Buatan (AI) Robot Industri	KRS126
999912010	Standard Panduan Keselamatan dan Kesehatan Kerja (K3) di tempat kerja (MD-10)	KRS120
829101001	Menerapkan keselamtn, kesehtn kerja (K3), & hygiene sanitasi	\N
803041511	Melakukan ins. antena & feeder pd jaringan akses wireless	\N
999915077	Resep masakan hidangan hidangan punutup dari bahan beras ketan dan tepungketan	KRS150
999908204	Level 4	KRS082
999910201	Belum Ada Modul	KRS102
999910607	Dasar ilmu pengobatan tradisional China 2  (MD-4-)B	KRS106
999904728	Bahasa Inggris untuk bidang Perpajakan (English for Taxation Purpose)	KRS047
100012050	Pendidikan Agama Kristen dan Budi Pekerti	\N
802032503	Mempersiapkan, melaksankn & mempross hsl shooting videografi	\N
401130130	Kimia (Perikanan dan Kelautan)	\N
401131000	Alat Mesin Industri Kimia	\N
401131700	Penyempurnaan Khusus Kimia & Fisika	\N
401141600	Teknik Pembuatan Sediaan Obat	\N
800000281	Layanan Penunjang Laboratorium Medik	\N
800030103	Melaksanakan kerja sama dengan kolega & pelanggan	\N
800010126	Melakukan pemeriksaan urin, faeces & cairan tubuh lainnya	\N
800010127	Melak. Pemerik. hematologi bakt.parasitologi & non patoogis	\N
100013070	Doktrin Gereja Katolik dan Moral Kristiani	\N
800030108	Menerapkan akuntansi dalam bi&g farmasi	\N
801050100	Kewirausahaan	\N
801030305	Menjelaskan dasar-dasar pekerjaan sosial	\N
801030310	Melakukan terminasi (pengakhiran hubungan kerja)	\N
802011002	Menjelaskan teknik elektronika analog & digital dasar	\N
802021300	Troubleshooting Jaringan	\N
800060303	Memelihara berbagai bahan & obat-obatan di klinik	\N
825021400	Fisiologi Tumbuhan	\N
822060110	Melaksanakan perbaikan sistem kelistrikan bodi otomotif	\N
802031509	Melakukan ins. & perawatan home theater	\N
802032509	Melaksanakan pameran hasil karya desain komunikasi visual	\N
803020600	Pengoperasian Sistem Komunikasi Satelit	\N
803041506	Melakukan ins. di terminal jaringan akses tembaga multipair	\N
803050107	Mengoperasikan peralatan pneumatik & hidrolik	\N
825060811	Melakukan penanganan & pemanfaatan limbah ternak	\N
825060810	Mengelola pasca panen ternak ruminansia	\N
804010800	Menggamabar dengan Perangkat Lunak	\N
804050305	Menjelaskan sistem pemeriksaan & perbaikan pd pekerjaan	\N
804050406	Menggambar konstruksi kusen, pintu & jendela	\N
804090200	Teknik Saniter dan Sistem Pembuangan Air Kotor	\N
804050100	Pengawasan Pekerjaan Konstruksi Baja	\N
804051200	Teknik Furnitur	\N
804130900	Pembuatan Komponen Instrumen Logam	\N
804080200	Peralatan Tangan dan Mesin Pengerjaan Kayu	\N
999907307	Level 7	KRS073
999907706	Level 6	KRS077
999907914	Pengantar Animasi (MD-03)	KRS079
999907920	Dasar-dasar Komunikasi (MD-04)	KRS079
804150102	Memasang & memperbaiki komponen permesinan	\N
809010208	Mencetak coba plate relief/letterpress	\N
807021810	Instalasi Komunikasi dan Navigasi Elektronik Pesawat Udara	\N
813010105	Melaksanakan pekerjaan mekanik & kelistrikan instrumentasi	\N
804131101	Menerapkan keselamatan & kesehatan kerja lingkungan hidup 	\N
813010104	Melakukan pengukuran besaran sistem inst kntrl proses	\N
813010400	Perawatan dan Perbaikan Sistem Kontrol Proses	\N
813010107	Menerapkan tek. Elekt. digital pd sistem instr. Kont. proses	\N
815010500	Penanganan mesin Ring Spinning	\N
816010307	Membuat kain dengan mesin tenun rapier menggunakan tapet	\N
999906617	Perawatan Kulit Wajah Tidak Bermasalah (MD.6)	KRS066
808030300	Pengaturan Keselamatan Penerbangan Sipil	\N
817030107	Menjelaskan sistem pengangkatan minyak bumi	\N
819030100	Manajemen Laboratorium	\N
820020200	Pekerjaan dasar Teknik Otomotif	\N
821060412	Merancang gambar dengan komputer	\N
821200800	Pekerjaan Pelapisan Permukaan	\N
821200406	Membuat komponen konstruksi bangunan kapal	\N
822090110	Perawatan dan Perbaikan Chasis Management System	\N
822110100	Vihicle Control System (VCS)	\N
823040103	Menanggulangi gangguan operasional pembangkit	\N
823040100	Pembangkit Listrik Tenaga Biomassa	\N
825020508	Mengatur/memberikan perlakuan pd tanaman perkebunan	\N
825060303	Melakukan pemeriksaan post mortem kesehatan ternak	\N
825010207	Mengoperasikan alat mesin: pemanenan & pengangkut srna prod.	\N
825020107	Mengatur/memberikan perlakuan pd tanmn pangan & hortikultura	\N
825010408	Menyusun rencana kerja & bahan penyuluhan pertanian	\N
825210104	Menerapkan prinsip kerja laboratorium yang baik (GLP)	\N
825210126	Melaksanakan proses pengolahan dengan fermentasi	\N
827010105	Menerapkan perawatan alat tangkap & metoda penangkapan	\N
827110350	Sistem Pengendalian dan Otomatisasi	\N
827080100	Manajemen Kapal Perikanan (MKP)	\N
827110330	Perawatan dan Perbaikan Mesin Kapal Penangkap Ikan	\N
999911214	Meletakkan pola di atas bahan/kain (MD-05)	KRS112
821030105	Melakukan pengelasan non ferro proses TIG	\N
829111109	Melakukan pengelolaan usaha produk patiseri 	\N
827350800	Perawatan Kapal (Ship Maintenance)	\N
827350109	Mengoperasikan peralatan navigasi konvensional & elektronik	\N
828080123	Menjelaskan konsep perusahaan anjak piutang dan sewa guna	\N
829111105	Melakukan pengolahan & penyajian coklat & permen coklat	\N
999914312	Pemrograman Aplikasi menggunakan telepon  (MD.IV-12)	KRS143
822070109	Melakukan dasar-dasar pekerjaan bengkel elektronika	\N
828190106	Melakukan perencanaan & pengelolaan perjalanan wisata  	\N
821090320	Konstruksi Bangunan Kapal Kayu dan Fiberglass	\N
827311100	Pencegahan Pencemaran Lingkungan Laut (MPP include Environment Awareness)	\N
825210110	Menganalisis secara kimia bahan & produk hasil pertanian	\N
825270700	Pengujian Mutu Pangan, Non Pangan, Air, dan Limbah Industri Pertanian	\N
828080101	Menerapkan prinsip praktik profesional dalam bekerja	\N
830040111	Melakukan perawatan ba& secara tradisional & modern 	\N
843060932	Menabuh waditra kendang dlm ... rerenggongan embat 2 wiled	\N
843062000	Penataan Karawitan Iringan	\N
843080102	Melaksanakan dialog wayang (antawacana)	\N
875190010	Melakukan fungsional tes perlengkapan listrik pesawat udara	\N
999800313	Keterampilan berhitung tingkat dasar	PKBM003
828150112	Melakukan penataan kamar untuk tamu & layanan housekeeping	\N
875150005	Menerapkan penggunaan aircraft material and hardware	\N
875150008	Melakukan perawatan & perbaikan aircraft structure 	\N
875200003	Menganalisis rangkaian listrik & rangkaian elektronika dasar	\N
999908411	Unit Kompetensi Tambahan	KRS084
999915019	Penggunaan dan Perawatan Peralatan Pengolahan Makanan	KRS150
999914811	 Jenis dan metode keamanan pada aplikasi komputer (MDP-7)	KRS148
999900708	Level 8	KRS007
999900811	Unit Kompetensi Tambahan	KRS008
999901010	Paket/Gaya	KRS010
999901111	Unit Kompetensi Tambahan	KRS011
999801002	Keterampilan berhitung tingkat lanjutan	PKBM010
999902215	Konsep kebutuhan dasar manusia (MD-4)	KRS022
999891006	Profesi, Keahlian dan Pekerjaan	PKBM009
999901607	Level 7	KRS016
999901902	Level 2	KRS019
999902318	Finalisasi Hasil Kerja DG?SP-06	KRS023
999902419	(MD-8) Kode Etik Profesi	KRS024
999902704	Level 4	KRS027
999902901	Level 1	KRS029
999903009	Level 9	KRS030
800000153	Konstruksi Jalan dan Jembatan	\N
999902906	Level 6	KRS029
999903607	Level 7	KRS036
999903118	Perawatan Jaringan Komputer (MDIII-7)	KRS031
999903508	Level 8	KRS035
999903712	Belum Ada Modul	KRS037
999904306	Level 6	KRS043
800000184	Instrumentasi dan Otomatisasi Proses	\N
999902506	Level 6	KRS025
999904105	Level 5	KRS041
999904110	Paket/Gaya	KRS041
999904412	Belum Ada Modul	KRS044
999904503	Level 3	KRS045
800000152	Konstruksi Jalan, Irigasi, dan Jembatan	\N
999905413	Pengantar MC Formal (MD-02)	KRS054
999905110	Paket/Gaya	KRS051
800000216	Teknik Komputer dan Jaringan	\N
843060575	Memainkan instrumen Pokok Rebab tingkat Pengrawit	\N
999904805	Level 5	KRS048
999905515	Ilmu Pijat Pengobatan Refleksi Relaksasi (MD-04)	KRS055
999905511	Unit Kompetensi Tambahan	KRS055
999905611	Unit Kompetensi Tambahan	KRS056
999905917	Metode Mengajar 2 (MD. 2)	KRS059
999906210	Paket/Gaya	KRS062
999903421	Tanggung jawab Pengemudi Kendaraan Pribadi (MP MKB 09)	KRS034
999906508	Level 8	KRS065
999906511	Unit Kompetensi Tambahan	KRS065
999906621	Pengetahuan Penunjang Sebagai Asisten Kecantikan (MD.10)	KRS066
999915020	Hyigiene Sanitasi Perorangan, lingkungan kerja dan Makanan	KRS150
999904812	Pemeliharaan elemen keras (hard material) taman	KRS048
999906821	Keamanan dan keselamatan lingkungan kerja 	KRS068
999907013	Komunikasi, Presentasi, dan Tatalaksana (MD2.III)	KRS070
999907320	Cara Pemeriksaan TCM (MD- 09)	KRS073
999908512	Alat dan peralatan bengkel (MD-01)	KRS085
828150102	Menerapkan hygiene,sanitasi,keselamtn kerja &lingkungn hidup	\N
999908028	Modul Pemeliharaan dan perawatan alat elektronika (ED-02.14)	KRS080
999907815	Pengetahuan bordir mesin (MD-04)	KRS078
999908516	Sistem kelistrikan body dan engine (MD-5)	KRS085
999910605	Teknik pemijatan Akupresur ( MD ? 5 ) 	KRS106
999910115	Mengelola Administrasi Hutang	KRS101
999909504	Strategi komunikasi dalam Bahasa Ingris	KRS095
999909503	Berkomunikasi dengan baik dan efektif dengan petugas kesehatan dalam B. Inggris	KRS095
999911001	Bekerjasama dengan kolega dan wisatawan (MP 3-1)	KRS110
999910706	Evaluasi kondisi klien (MD-6) 	KRS107
999911003	Mengkoordinasikan dan mengoperasikan perjalanan wisata (MP 3-3)	KRS110
831080807	Mengoperasikan & melakukan pemeliharaan mesin jahit	\N
836020102	Menggambr sketsa & teknik obj desain prod int. & landscaping	\N
999912004	Penulisan Naskah (MD-04)	KRS120
999912427	MD.14 Teknik merangkai bunga modifikasi mass arrangement	KRS124
999912622	(MP-22) Desain Prototipe 3D pada Industri	KRS126
839130200	Busana Kulit dan Imitasi	\N
842030200	Pembuatan prod. dengan teknik kerja bangku & mesin	\N
999913108	Pembuatan Pasangan Bata Dekoratif  (MD. 8)	KRS131
999913405	MP-5 Pengenalan Lingkungan dan Pelestariannya.	KRS134
999913512	Etika Profesi  (MP-03.07)	KRS135
999914302	Perancangan Antarmuka Pengguna Aplikasi Mobile (MD.IV-2)	KRS143
801030800	Rehabilitasi Sosial Adiksi korban NAPZA	\N
843060501	Memainkan tari: Ngremo/Remo (Surabaya)	\N
401251190	Akuntansi Perbankan dan Keuangan Mikro	\N
801030700	Konseling Lanjut Usia dan keluarga	\N
843060515	Menarikan tari Malattu Kopi	\N
802031103	Mengoperasikan komputer grafis & animasi	\N
808070707	Memperbaiki sistem automatic airconditioning	\N
805010612	Menyusun rencana anggarn biaya pekerjaan survei & pemetaan	\N
825061302	Mengoperasikan peralatan agribisnis ternak unggas	\N
803041502	Menjelaskan dasar2 sistem telekomunikasi&komunikasi data	\N
843060555	Menarikan tari Kebyar Duduk & Kebyar Terompong	\N
829101004	Melakukan pengolahan & penyajian makanan kontinental	\N
843060530	Menarikan tari Payuang & tari Piriang III Sofyani	\N
829111102	Melakukan persiapan pengolahan produk patiseri	\N
822070101	Menerapkan dasar kelistrikan, elektronika, & teknik digital	\N
828030104	Memproses entri jurnal	\N
843060581	Memainkan karawitan (PKB) daerah lain (tari Surakarta)	\N
875180011	Memelihara & memperbaiki sistem hidrolik	\N
999800714	Pengembangan Kepribadian Profesional	PKBM007
999904714	Praktikum Komputerisasi Perpajakan 	KRS047
999912705	PLC (PLC-05)	KRS127
999912928	Sistem Kelistrikan Body yang dikontrol secara elektronik	KRS129
999915078	Resep masakan hidangan hidangan punutup dari bahan  non beras	KRS150
999910306	Penyimpanan dan Distribusi Produk Olahan Ikan	KRS103
999913802	Peralatan Pemasangan AC (TAC-02)	KRS138
999915084	Resep masakan Kontinental hidangan soup jernih dan soup kental	KRS150
999915081	Resep masakan Oriental dari Negara Korea	KRS150
999915080	Resep masakan Oriental dari Negara Jepang	KRS150
999916104	MD 4. Praktikum Komputerisasi Perpajakan 	KRS161
999915072	Resep masakan lauk pauk nabati  dari bahan hasil olahan nabati	KRS150
999916901	Pengolahan Roti & Penyajian Roti (MDRIII-1)	KRS169
999916903	Higiene dan Sanitasi & Pengetahuan Bahan Makanan (MDU-3)	KRS169
800000239	Agribisnis Pengolahan Hasil Perikanan	\N
800060304	Berkomunikasi dgn pasien, masy & tenaga medik/paramedik lain	\N
200030080	Kebekerjaan (P4 Pancasila & Budaya Kerja)	\N
803030508	Melakukan ins., mengoperasikan & memelihara softswitch	\N
803030504	Melakukan ins. sistem pentanahan (grounding) & pengaman 	\N
820100100	Perawatan Engine dan Unit Alat Berat	\N
803030502	Memahami dasar-dasar sistem telekomunikasi	\N
800000108	Dasar Dasar Teknik Pengelasan dan Fabrikasi Logam	\N
800000134	Dasar Dasar Nautika Kapal Penangkapan Ikan	\N
803081300	Pengukuran Besaran Instrumentasi dan Otomatisasi Proses	\N
825010401	Mengelola bisnis tanaman pangan & hortikultura	\N
825210154	Memproduksi pakan ikan buatan	\N
820130200	Pemeliharaan dan Perbaikan Kelistrikan Bodi dan Assesories	\N
843090100	Tata Teknis Pentas	\N
816010301	Melaksanakan proses persiapan pembuatan kain	\N
843060568	Menarikan tari daerah lain (Bali,Sunda,Yogyakarta,&Banyumas)	\N
999911013	Mengikuti Prosedur Keamanan, Keselamatan dan Kesehatan Kerja (MP 3-13)	KRS110
999908813	Penanganan pesawat di darat (Aircraft Handling)	KRS088
999908424	Peran dan tanggung jawab pekarya kesehatan (MD-13)	KRS084
999912302	Metode pengeringan bunga dan unsur tanaman secara alami   (MP 2)	KRS123
822060102	Menggunakan peralatan & perlengkapan di tempat kerja	\N
817110112	Mendeskrip. sift fisika-kimia & listrik dlm pengolhn migas	\N
999910604	Dasar ilmu pengobatan tradisional China 1 (MD-4-A)	KRS106
999915086	Resep masakan Kontinental hidangan penutup panas dan dingin	KRS150
999914304	Pemrograman Aplikasi Penyimpanan Data Menggunakan Shared Data (MD.IV-04)	KRS143
200010100	Pendidikan Kewarganegaraan dan Sejarah	\N
400100270	Program Pendidikan Khusus	\N
800030106	Membt sediaan obat sesuai resep dktr di bwh pengwsn apoteker	\N
803081200	Pemeliharaan sistem Instrumentasi dan Otomatisasi proses	\N
817010101	Menjelaskan geologi dasar, ilmu batuan & bahan galian	\N
817110105	Menjelaskan proses separasi, konversi, & treating	\N
839020104	Membuat kria tekstil dengan teknik cetak saring	\N
817010104	Menjelaskn btuan mik&makro fosil srta teknik penyajian fosil	\N
828080122	Menjelaskan konsep pasar modal dan valuta asing	\N
822080110	Perawatan dan Perbaikan Engine Management System dan Motor Listrik	\N
999904827	Pengetahuan Elemen Keras (hard material) Taman 	KRS048
830100100	Pengelolaan Usaha Kecantikan	\N
800000183	Teknik Elektronika Pesawat Udara (Aviation Electronics)	\N
999904312	Proses produksi acara televisi (MD.1)	KRS043
999905520	Teori Zona Pijat Refleksi (MD-09)	KRS055
999907015	Wirausaha dan Pemasaran(MD4.III)	KRS070
999912430	T. Merangkai bunga modifikasi mass line arrangement grs lurus dg grs melengkung	KRS124
999912924	Sistem Transimisi Otomatis (MA-4)	KRS129
801031500	Keterampilan Teknis Pekerjaan Sosial	\N
843060508	Memainkan tri daerah: Pendet/Payemrama, Oleg TamuLilingan	\N
999906418	Terapi Herbal: Menyajikan minuman/makanan sehat dan jamu untuk perawatan SPA	KRS064
999914803	Jenis-jenis dan penanggulangan serangan komputer (MDK-3)	KRS148
999912443	MD.7 Teknik merangka rangkaian bunga kiriman dengan tema khusus khusus	KRS124
999912419	MD.6 Teknik merangkai bunga pola dasar bentuk kipas (mass arrangement)	KRS124
999911402	MP-3  Menggambar Busana dengan Komputer (Desain Komputer)	KRS114
829101008	Melakukan perencanaan& pengolhn mkann untk kesempatan khusus	\N
999903423	Mengendalikan Kendaraan (MD-02)	KRS034
999905512	Etika Profesi Pelayanan Pijat Refleksi (MD-01)	KRS055
800050202	Melaksanakan pemberian obat & nutrisi kepd klien/pasien	\N
804060400	Teknik Pelaksanaan dan Pengawasan Pekerjaan Irigasi	\N
821060411	Menerapkan perencanaan pekerjaan dengan komputer	\N
827010107	Menerapkan olah gerak kapal & pengendalian kapal perikanan	\N
820130100	Pemeliharaan Kaca, Assisories & Kelistrikan Bodi	\N
825010203	Mengoperasikan & merawat alat & mesin perbengkelan pertanian	\N
200040000	Project Penguatan Profil Pelajar Pancasila	\N
999905121	Fotografi Alam Benda (FG-V-4)	KRS051
999906527	Pengendalian Biaya dan Pembukuan & Inovasi Pengolahan Roti	KRS065
999912306	Merangkai bunga pada wadah sesuai dengan pola dasar  (MP 6)	KRS123
999914204	MP4 Penggantian Panel Bodi dan Rangka Kendaraan	KRS142
999915039	Cara Pengolahan makanan dengan Demo Memasak (Cooking Demo)	KRS150
999913706	MD.6 Prosedur pengujian komponen elektronika sesuai standar baku ISO 8373:2012	KRS137
999906428	MD 8. Terapi Penunjang lain: Mengaplikasikan Rempah untuk Perawatan SPA	KRS064
829101007	Melakukan perencanaan & pengolhn maknn sesuai kebutuhan gizi	\N
999906727	Pengeringan dengan teknik blowdry/catok/fingerdry (MD-04)	KRS067
999906204	Level 4	KRS062
999906430	MD 1 Melakukan Perawatan Under Water Massage 	KRS064
999913204	Pemasangan dan Penyambungan Pipa Air Limbah dan Drainase Air Hujan (MP.III-4)	KRS132
825210151	Mengidentfkasi param. kualitas & kuant. air srta potensi lhn	\N
999912428	MD.15 Teknik merangkai bunga modifikasi mass line arrangement garis lurus	KRS124
999915069	Resep masakan lauk pauk hewani  dari bahan hasil olahan (delicatessen)	KRS150
999916702	MD. 2. Ketentuan Umum dan Tatacara Perpajakan (KUP) 	KRS167
999915038	Aneka resep makanan dengan berbagai metode pengolahan	KRS150
807020510	Perakitan Struktur Pesawat Udara (Aircraft Structure Assy)	\N
999902224	Peran dan tanggung jawab pekarya kesehatan (MD-13)	KRS022
999906629	Menambah bulu mata buatan satu per satu (MD.10)	KRS066
826020100	Ilmu Ukur Kayu	\N
827350111	Menerapkn dinas jaga di deck, P2TL&isyarat visual/komunikasi	\N
827351100	Sistem Kemudi Kompas (Compasses and Steering System)	\N
999915901	MD 1. Ketentuan Umum dan Tata cara Perpajakan (KUP)	KRS159
802020309	Melakukan pemrog. b.orientasi obj berbasis teks deskt & web	\N
802032504	Mempersiapkan pembuatan produk desain komunikasi visual	\N
843060950	Menabuh gong gede tabuh lelembatan	\N
999914902	Perangkat Keras komputer  (MD-2)	KRS149
999914601	Pengenalan perangkat lunak dalam desain web (MD.IV-1)	KRS146
999915090	Penatan hidangan Lunch box dan snack box	KRS150
999911009	Mengembangkan & memelihara pengetahuan umum yang diperlukan oleh pemandu wisata	KRS110
804100604	Mengoperasikan peralatan & semi automatic change over	\N
804100904	Melakukan pengukuran komponen elektronika	\N
809010900	Perencanaan dan Pengendalian Produksi	\N
999913007	Safety unit alat berat Excavator / Dump Truck / Loader	KRS130
999908702	Undang-Undang dan Kode Etik  HAKI (MD-2)	KRS087
999915067	Resep masakan lauk pauk hewani dari bahan ikan,kerang dan hasil laut lainnya	KRS150
839020129	Membuat produk kulit bntk asesoris,dompet, & gantungan kunci	\N
999911401	MP-2  Desain Ilustrasi Busana	KRS114
999906632	Perawatan Wajah Berpigmentasi dengan teknologi alat listrik (MD.4)	KRS066
999914813	Kordinasi Tim (MDHTJ-2)	KRS148
999917004	Teknik Pengukuran & Pengetahuan Peralatan Pastry (MDU-4)	KRS170
825010411	Menumbuhkembangkan kelembagaan kelompok tani 	\N
999901610	Paket/Gaya	KRS016
999902206	Level 6	KRS022
999903115	Instalasi Jaringan Komputer (MDIII-4)	KRS031
805010608	Menentukan azimut dengan pengamatan matahari	\N
999912704	Instalasi Listrik, Pengaman dan K3 (PLC -04)	KRS127
999912447	MD.11 Teknik merangkai buket pengantin tanpa wadah (handtied )	KRS124
999915112	Kontrol Persiapan,  pengolahan dan penyajian makanan	KRS150
842020189	Membuat produk kria kayu dengan apilkasi bahan non kayu	\N
999902114	Teknik Pena-taan Cahaya TV (MD-03)	KRS021
827090200	Teknik Penangkapan ikan, Penanganan, dan Penyimpanan Hasil Tangkapan	\N
999906535	Pengolahan Dekorasi Kue dan Coklat & Penyajian Kue (MDDIII-1)	KRS065
999912432	T. Merangkai bunga modifikasi mass line arrangement grs melengkung dg grs mlgkng	KRS124
999914314	Pemrograman Aplikasi berbasis jaringan (network programming) (MD.IV-14)	KRS143
999912310	Metode pengeringan bunga dan unsur tanaman secara kimiawi (MP 4)	KRS123
999917005	Pengetahuan Dasar Dekorasi Kue dan Coklat & Pengetahuan Bahan Adiktif (MDD-5)	KRS170
999916708	 MD. 8. Bahasa Inggris untuk bidang Perpajakan (English for Taxation Purpose)	KRS167
802032505	Membuat produk desain komunikasi teknik saring	\N
999917001	Pengolahan Dekorasi Kue dan Coklat & Penyajian Kue (MDDIII-1)	KRS170
828190103	Melaksanakan tata cara pemesanan tempat (Airline Reservaton)	\N
999912420	MD.7 Teknik merangkai Bunga pola dasar bentuk segiempat ( mass arrangement)	KRS124
100012080	Pendidikan Karakter Kristen	\N
822070110	Merakit & memelihr peralatan pengendali &otomasi elektronika	\N
401131100	Kimia Klinik 	\N
401131500	Analisis Mikrobiologi	\N
401141500	Pelayanan Farmasi	\N
401251050	Akuntansi Perusahaan Manufaktur	\N
875200001	Menerapkan dasar teknologi pesawat udara	\N
800050211	Melaksanakan dokumentasi tindakan keperawatan	\N
800010130	Menerapkan kontrol kualitas prosedur laboratorium	\N
800030201	Menjelaskan dasar-dasar pembuatan & pengemasan sediaan obat	\N
999800408	Pendidikan Jasmani, Olahraga dan Kesehatan	PKBM004
801030307	Menerapkan prosedur pelayanan di lembaga pelayanan sosial	\N
801030303	Melakukan pencatatan, pelaporan & temu bahas kasus	\N
801030300	Keterampilan Teknis Perawatan Sosial	\N
802020308	Membuat halaman web dinamis tingkat lanjut	\N
999800504	Ilmu Pengetahuan Sosial	PKBM005
825010220	Pengoperasian Dasar-Dasar Perbengkelan Pertanian	\N
800000284	Teknika Kapal Penangkap Ikan	\N
803021600	Operasi dan Pemeliharaan Jaringan Utama	\N
803020508	Merancang jadwal produksi harian/running sheet	\N
802031513	Melakukan ins. peralatan audio video mobil	\N
803042500	Infrastruktur Komputasi Awan (IaaS)	\N
999908539	Kontrol elektronik otomotif (MD-13)	KRS085
802031920	Digital Prosesing	\N
803060800	Penerapan Sistem Radio dan Televisi	\N
803090300	Pengoperasian, Perawatan dan Perbaikan Instrumentasi Medik	\N
804050301	Menjelaskan ilmu bangunan & bahan bangunan	\N
804050408	Menggambar utilitas gedung	\N
804050502	Melakukan kerja kayu dengan alat tangan & listrik	\N
804090100	Sistem Penyediaan Air Bersih	\N
803060309	Merancang koordinasi produksi program acara	\N
804060100	Keselamatan Kerja dan Kesehatan Lingkungan	\N
804130103	Mengelas dengan proses las MIG (GMAW)	\N
999912910	MD-1  Alat dengan Tenaga (power tools)	KRS129
999907308	Level 8	KRS073
804080100	Rekayasa dan Pemodelan Furnitur	\N
804110104	Merakit sistem kendali elektropneumatik 	\N
804150103	Memelihara & memperbaiki rakitan penggerak & pembawa mekanik	\N
804150104	Memelihara & memperbaiki komponen sistem hidrolik	\N
807010200	Keterampilan Dasar (Aircraft Basic Skills)	\N
813010118	Melakukan peker. Kons. pengendalian sistem kontrol mekanik	\N
804131605	Melakukan operasi pengecoran tingkat dasar	\N
999915403	Pengetahuan & Praktek untuk Pemasakan, Pencetakan Malam Batik sesuai SOP & K3	KRS154
814010100	Keselamatan, Kesehatan, Kerja dan Sikap Kerja	\N
814080200	Penyimpanan dan Penggudangan	\N
814100138	Mengoperasikan & merawat unit mesin combing	\N
816010308	Membuat kain dgn mesin tenun projektil mengg. tapet	\N
814100139	Mengoperasikan & merawat unit mesin drawing	\N
808070703	Memperbaiki sistem pengatur kecepatan otomatis	\N
816010306	Membuat kain dgn mesin tenun jet menggunkn cam/eksentrik	\N
819030110	Pengelolaan Laboratorium	\N
821030109	Melakukan pengelasan pd perakitan konstruksi kapal	\N
821060409	Menggambar sistem perpipaan kapal	\N
821060900	Gambar Konstruksi Kapal Fiberglass dengan CAD	\N
819050104	Menyiapkan bahan untuk proses produksi industri kimia	\N
822060100	Teknik Perawatan dan Perbaikan Otomotif	\N
822120100	Konversi Energi	\N
822200100	Pemasangan dan Pemeliharaan PLTS	\N
823040107	Menguji switch gear, DC power & rectifier, & unit generator	\N
825050800	Agribisnis Pembibitan dan Kultur Jaringan Tanaman	\N
807021410	Merakit Sistem Listrik Pesawat Udara	\N
825010211	Membuat jaringan irigasi & drainase serta mengoperasikannya	\N
825020610	Produksi Tanaman Perkebunan Semusim	\N
825070100	Sumber Tenaga Penggerak Alat Mesin Pertanian	\N
825210102	Menangani hsl pertanian sesuai good manufacturing process	\N
825250105	Melak. analisis kimia scr spektro., el.kimia & kromatografi	\N
825210127	Melaksanakan proses pengolahan hasil pertanian	\N
827020200	Bangunan dan Stabilitas Kapal Penangkap Ikan	\N
825210128	Mengemas bahan hasil pertanian & produk olahan	\N
827110340	Ilmu Bahan, Bahan Bakar, dan Pelumas	\N
827010106	Menerapkan bhs inggris pelayaran & bhs inggris perikanan	\N
821030106	Melakukan pengelasan baja proses SAW	\N
827280101	Menjelaskan potensi agribisnis rumput laut	\N
827350900	Perlengkapan Kapal (Deck and Machinery Equipment)	\N
999913401	MP-1 Membaca Gambar Kerja	KRS134
820060600	Pemeliharaan Kelistrikan Kendaraan Ringan	\N
828080124	Menjelaskan konsep perusahaan dana pensiun dan modal ventura	\N
999914313	Pemrograman Aplikasi Layer Perantara  (web service) (MD.IV-13)	KRS143
821170600	Teknik Las FCAW dan GMAW	\N
822070112	Menerapkn pengendli berbantu mikropros mikrokontroller & PLC	\N
830040101	Menjelaskan anatomi & fisiologi 	\N
817060103	Mendeskripsikan konsep eksplorasi hidrokarbon	\N
825020506	Mengendalikan organisme pengganggu tanaman (OPT)	\N
817060104	Memahami tentang geologi migas & fluida reservoir	\N
825060803	Memproduksi hijauan pakan ternak ruminansia	\N
999910118	Mengelola Aktiva Tetap	KRS101
825270500	Pengambilan Contoh, Pengujian Organoleptik, dan Pengujian Fisik - Mekanis	\N
827380108	Mengerjakan adm keuangan & pembukuan di perusahaan pelayaran	\N
824060400	Kamera, Pencahayaan dan Tata Suara	\N
825010410	Melaksanakan evaluasi kegiatan penyuluhan pertanian	\N
828190104	Melakukan perhitungan tarif & dokumen pasasi udara	\N
822070103	Menerapkan konsep elektronika digital & rangkaian komputer	\N
843080104	Melakukan iringan pedalangan	\N
843090309	Melaksanakan tata rias panggung	\N
843040101	Membuat gmbr dasar lukis realistik dgn tek. bhn kering & bsh	\N
999800402	Ilmu Pengetahuan Alam 	PKBM004
828180120	Perencanaan dan Pengelolaan Usaha Wisata Bahari dan Ekowisata	\N
844020100	Melaksanakan pemeliharaan kecil	\N
875150007	Menerapkan aerodynamic and flight control 	\N
875200004	Menerapkan rangkaian elektronika analog & digital	\N
999914406	Prosedur umum Kesehatan dan Keselamatan dan Kesehatan Kerja (MD-6)	KRS144
830050103	Melakukan pengeringan rambut dengan alat pengering	\N
999901213	Bahasa Jepang 2	KRS012
999900812	Belum Ada Modul	KRS008
999900906	Level 6	KRS009
999901101	Level 1	KRS011
999901205	Level 5	KRS012
999902212	Komunikasi Efektif (MD-1)	KRS022
999902216	Kesehatan dan Keselamatan Kerja (K3) (MD-5)	KRS022
999902311	Unit Kompetensi Tambahan	KRS023
999891003	Keagamaan	PKBM009
999902509	Level 9	KRS025
800000179	Teknik Elektronika Industri	\N
999902327	Tata Laksana DTP DG-09	KRS023
999902527	Prosedur pabean barang impor	KRS025
999902708	Level 8	KRS027
999902921	Wawancara Tatap Muka/ Ekslusif (Md-14)	KRS029
600070200	Projek Kreatif dan Kewirausahaan	\N
999902315	Pengantar Teknik I DG?SP-03	KRS023
999902522	Korespondensi Ekspor-Impor 	KRS025
999903502	Level 2	KRS035
999903209	Level 9	KRS032
999903505	Level 5	KRS035
999903609	Level 9	KRS036
999903413	Mengendalikan kendaraan (MP MKB 02)	KRS034
999903711	Unit Kompetensi Tambahan	KRS037
999904307	Level 7	KRS043
800000196	Teknik Pembuatan Benang Stapel	\N
999903425	Perawatan Kendaraan (MD-04)	KRS034
999904205	Level 5	KRS042
999904607	Level 7	KRS046
999904719	Akuntansi perapajakan	KRS047
999904908	Level 8	KRS049
999905128	Manajemen (FG-V-11)	KRS051
999905123	Fotografi Jurnalistik (FG-V-6)	KRS051
800000213	Rekayasa Perangkat Lunak	\N
800000205	Teknik Energi Surya, Hidro, dan Angin	\N
843060579	Memainkan karawitan iringan tari tingkat Pengrawit	\N
999905517	Pijat Refleksi untuk Stamina dan Gangguan Pergerakan (MD-06)	KRS055
999904723	Logistik Ekspor ?Impor 	KRS047
999905518	Hubungan Kerja di tempat Pelayanan Pijat Refleksi (MD-07)	KRS055
827360100	Komunikasi Kapal Niaga (KKN)	\N
999906211	Unit Kompetensi Tambahan	KRS062
814100136	Mengoperasikan & merawat unit mesin lap former	\N
999906715	Pengeringan rambut dengan pengering genggam (blowdry) (MD-04)	KRS067
999905525	Anatomi fisiologi pathologi organ tubuh (MD-14)	KRS055
999906521	Pengetahuan analisis biaya (MDU III-9)	KRS065
999906613	Persiapan Pribadi dan Pelanggan (MD.2)	KRS066
999906714	Perawatan rambut dan kulit kepala (creambath) (MD-03)	KRS067
828010103	Melaksanakan negosiasi & konfirmasi keputusan pelanggan	\N
999906433	MD 4 Perawatan Masker Badan Dengan Lumpur/Algae/ Seaweed/Clay	KRS064
999906907	Level 7	KRS069
999907313	Filosofi Dasar TCMb (MD-02)	KRS073
999907322	Perencanaan Terapi (MD-12)	KRS073
999907611	Unit Kompetensi Tambahan	KRS076
999908412	Komunikasi efektif (MD-1)	KRS084
827390900	Permesinan Bantu (Auxiliary Machinery)	\N
999908416	K3 Kesehatan dan Keselamatan Kerja (MD-5)	KRS084
999908415	Konsep kebutuhan dasar manusia (MD-4)	KRS084
999908419	Sterilisasi dan desinfeksi (MD-8)	KRS084
999908526	Sistem AC (Air Conditioning) (MM-8)	KRS085
839020105	Membuat kria tekstil dgn teknik batik tulis,cap,& ikat celup	\N
999908517	Keselamatan dan Kesehatan Kerja (MD-6)	KRS085
999910112	Menyelesaikan Siklus Akuntansi  Perusahaan industri	KRS101
999910708	Manajemen Praktis Pelayanan Jasa Pijat(MD-8)	KRS107
999911408	MP-9   Pengoperasian Berbagai Mesin Jahit dan Mesin Penyelesaian	KRS114
999910709	Anatomi umum, otot dan pergerakan nya(MD-9)	KRS107
999911002	Memberikan Bantuan Pada Kedatangan dan Keberangkatan (MP 3-2)	KRS110
834020103	Membuat desain relief teknik manual & komputer	\N
836020107	Melaksanakan finishing prod. Int. & landscaping bhn logam	\N
999912006	Produksi Acara Televisi (MD-06)	KRS120
999912403	MD 3. Pengantar tentang Prinsip dan Unsur Desain	KRS124
999912429	T. Merangkai bunga modifikasi mass line arrangement grs lurus dg grs lurus	KRS124
840020140	Pembentukan dengan Teknik Putar Pilin	\N
839020165	Melaksanakan pengelasan dengan oxyacetylene & las listrik	\N
999913109	Pengetahuan Penunjang Pekerjaan Pemasangan bata level 3  (MD. 1)	KRS131
999914307	Pemrograman Aplikasi Menggunakan Media (MD.IV-07)	KRS143
839020144	Membentuk keramik dengan teknik putar	\N
839020166	Membuat karya kria logam dengan bahan pelat & kawat	\N
999913817	Modul Kewirausahan ( MKW )	KRS139
842020186	Membuat komponen produk kria kayu dengan mesin kayu tetap	\N
999913702	MD.2 Pedoman pembuatan Bill of Material dan SOP Network Planning	KRS137
401110200	Biologi	\N
842020187	Melakukan pekerjaan finishing kayu	\N
842020188	Melakukan pekerjaan pengeringan kayu 	\N
401251250	Pengelolaan Penjualan Langsung	\N
803041503	Melakukan ins. catu daya & batere sistem telekomunikasi	\N
804210200	Pengetahuan Industri Migas	\N
805010606	Melaksanakan pengukuran pemetaan topografi 	\N
821061200	Menggambar Bukaan Konstruksi Bangunan Kapal	\N
825061303	Melakukan pemeliharaan unggas petelur	\N
843060511	Menarikan tari Anging Mamiri Anida & Tomassenga	\N
821080210	Melaksanakan pekerjaan bengkel produksi	\N
821080209	Melakukan dasar pengelasan GMAW/MIG & GTAW/TIG	\N
829101005	Melakukan pengolahan & penyajian makanan Indonesia	\N
821061008	Mengelas tingkat dsr dengan proses las MIG (GMAW)&TIG(GTAW)	\N
843060535	Menarikan tari Alang Babega	\N
839020161	Melakukan pengempaan & penempaan	\N
843090301	Menerapkan fungsi anatomi tubuh manusia dalam olah tubuh 	\N
875180009	Melakukan fabrikasi material komposit	\N
999903318	Proses alir pengelasan (MD-1)	KRS033
999904715	Manajemen Perkantoran 	KRS047
999912404	MD 4. Pengantar llmu Hortlkultura	KRS124
999913102	Persiapan Pekerjaan Pasangan Bata  (MD. 2)	KRS131
999906419	Terapi Penunjang: Persiapan & Pengemasan di SPA sesuai dengan kondisi kerja	KRS064
999908816	Penanganan keberangkatan pesawat (departure)	KRS088
999905914	PPPk dan Cedera Olahraga (MD. 3)	KRS059
999912423	Teknik merangkai bunga pola dasar bentuk T terbalik	KRS124
999913815	Modul Trouble Shoting Hardware (MTH)	KRS139
999913714	MD.14 Sistem robot dan pengujiannya	KRS137
999915011	Pembuatan kaldu (white beef stock dan brown stock)	KRS150
999915903	MD 3. Praktikum Komputerisasi Perpajakan 	KRS159
999915071	Resep masakan lauk pauk nabati  dari bahan tahu	KRS150
999916007	MD 2. Praktikum Komputerisasi Perpajakan 	KRS160
999916904	Teknik Pengukuran & Pengetahuan Peralatan Roti (MDU-4)	KRS169
999916905	Pengetahuan Dasar Pengolahan Roti & Pengetahuan Bahan Adiktif (MDR-5)	KRS169
200030020	Kearifan lokal (P4 Pancasila & Budaya Kerja)	\N
800000145	Dasar Dasar Desain Komunikasi Visual	\N
804110502	Melaksanakan pekerjaan pemesinan operasi dasar	\N
814031700	Regulasi Sektor Logistik dan Keselamatan Kerja	\N
800000253	Usaha Layanan Wisata	\N
800000110	Dasar Dasar Teknik Elektronika	\N
800000135	Dasar Dasar Teknika Kapal Niaga	\N
803060500	Perencanaan dan Instalasi Sistem Atena Penerima	\N
820070104	Melakukan perbaikan sistem bahan bakar sepeda motor	\N
826107100	Pembukaan Wilayah Hutan Produksi	\N
825210160	Melakukan pembesaran ikan	\N
843060907	Memainkan karawitan mandiri (PKB) tingkat pengrawit	\N
843080133	Melakukan teknik perang sesuai dengan jenis&karakter wayang	\N
817110111	Mendeskripsikan storage and handling & sistem instrumentasi	\N
813010119	Melakukan perawatan & perbaikan sistem kontrol mekanik	\N
802011000	Kerja Proyek Teknik Komputer dan Jaringan	\N
999910412	Keterampilan Dasar Berbahasa (MD-4)	KRS104
999907707	Level 7	KRS077
999905824	Korespondensi Bahasa Niaga Bahasa Indonesia	KRS058
999906628	Menghilangkan bulu yang tidak dikehendaki (Depilasi) (MD.9)	KRS066
999908812	Kedatangan Kargo, Transfer, Interline, Transit, Penyimpanan dan  Penanganan Pen	KRS088
999907014	Pengetahuan dan Praktek: Pemasakan, Pencetakan Malam Batik Berdasarkan SOP & K3	KRS070
822100100	Comfort Safety and Information Technology (CSIT)	\N
804040500	Estimasi Biaya Konstruksi, Sanitasi, dan Perawatan Gedung	\N
999911702	MD 2  Penataan Tari (Karya Tari)	KRS117
999912444	MD.8 Teknik merangkai rangkaian bunga kiriman  dengan tema sukacita	KRS124
804050806	Melaksanakan pekerjaan konstruksi batu & beton	\N
823010200	Sistem Kontrol dan Instalasi Kelistrikan PLTS	\N
999902230	Hukum tentang Ketenagaker-jaan di Negara Tujuan (MD-19)	KRS022
999911217	Standar mutu hasil kerja dengan pengawasan tidak langsung (MD-08)	KRS112
999908017	Modul Teknik Pensolderan dan PCB (ED-02.03)	KRS080
807022000	Aircraft Electronic, Comnav & Digital Technique	\N
999908514	Sistem pemindah tenaga (MD-3)	KRS085
999912405	MD 5.Cara membuat Decorative Wrapping Flower Arrangement	KRS124
999906412	MD 1. Hidroterapi: Perawatan Penguapan Badan (body steam)	KRS064
825210141	Membuat diversifikasi produk hasil perikanan	\N
820100111	Melaksanakan pekerjaan dasar powertrain & undercarriage	\N
830120200	Perawatan Tangan, Kaki, Nail Art dan Rias Wajah Khusus dan Kreatif	\N
803071100	Instalasi dan Perbaikan Sistem Komunikasi digital& teknologi komunikasi bergerak	\N
827320110	Konstruksi dan Stabilitas Kapal (Ship Construction and Stability)	\N
826030200	Pengkuran dan Pemetaan Hutan	\N
999906514	Pengendalian Biaya dan Pembukuan (MDU III-2)	KRS065
999913704	MD.4 Dasar-dasar penyolderan standar baku (IPC J-STD-001 certification)	KRS137
843120600	Perawatan Kulit dan Rias Wajah	\N
843060957	Menabuh gamelan palegongan iringan tari	\N
843060951	Menabuh gamelan angklung tabuh instrumental	\N
843060954	Memainkan instrumen kendang pepanggulan	\N
999914402	Perkembangan teknologi dalam bidang CAD (MD-2)	KRS144
999915001	Cara Memilih Bahan Makanan Yang Berkualitas	KRS150
808060620	Material Komposit Pesawat Udara (Aircraft Material Composite)	\N
999907012	Pengetahuan Bahan, Alat, Tempat Penyedia Bahan dan Alat Pembuatan Malam Batik	KRS070
804100905	Merawat peralatan rumah tangga listrik	\N
825210133	Mengoperasikan alat & mesin pengolahan hasil perikanan	\N
999906724	Pengetahuan Penunjang Ahli Kecantikan Rambut (MD-01)	KRS067
999907917	Pengantar Animasi (MD-01)	KRS079
999912453	MD.17 Teknik  merangkai bunga untuk meja bulat,dan meja panjang	KRS124
825060302	Melakukan pemeriksaan secara laboratorium kesehatan ternak	\N
999912914	MD-5  Engine dan Komponen-komponennya	KRS129
999906634	Perawatan Wajah Menua dengan teknologi alat listrik (MD.6)	KRS066
999907109	Level 9	KRS071
804090305	Menerapkan sistem plambing pipa tembaga	\N
839020107	Membuat kria tekstil dgn teknik jahit perca,aplikasi &tindas	\N
999900615	Kemampuan Umum dalam bekerja	KRS006
999903114	Topologi Jaringan Komputer (MDIII-3)	KRS031
800010122	Melaksanakan pekerjaan dalam lingkup pekerjaan yang berbeda	\N
999907327	Makanan Berkhasiat Menurut Ilmu Sinshe/TCM (MD-17)	KRS073
999914712	Berwirausaha di bidang pemrograman web (MP.IV-12)	KRS147
803070700	Pembuatan dan Pemeliharaan Peralatan Elektronik	\N
999915117	Kontrol pelaksanaan pengembangan resep	KRS150
827350600	P2TL dan Dinas Jaga (Col Reg & Watchk.Include Introduc. to BRM & Sec. Awareness)	\N
804050804	Menggunkn perlatn tngan & mknik listrik pd konst. batu beton	\N
804140200	Teknik Pengoperasian Mesin Pengecoran	\N
818010600	Teknik Eksplorasi dan Teknik Penambangan	\N
825250104	Melakukan analisis kimia konvensional & non instrumental 	\N
827380200	Penanganan dan Pengaturan Muatan (CHS include CSI/Inspection & Reporting)	\N
999903424	Pemahaman Peraturan Lalu Lintas (MD-03)	KRS034
999801001	Keterampilan membaca, menulis dan bahasa Indonesia tingkat lanjutan	PKBM010
843060576	Memainkan instrumen Pokok kendang tingkat Pengrawit	\N
999906820	Teknik komunikasi efektif terhadap pelanggan dan rekan kerja 	KRS068
803080504	Melaksanakan penyambungan kabel serat optik	\N
843060903	Memainkan instrumen gender penerus tingkat pengrawit	\N
843060532	Menarikan tari Mulo Pado Zuryati Zoebir, Nurbaini .B.	\N
999912804	Dasar-dasar Diesel EngineFastener, Sealing device & locking application (MD-4)	KRS128
\.


--
-- TOC entry 4115 (class 0 OID 16653)
-- Dependencies: 253
-- Data for Name: ref_teknik; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.ref_teknik (teknik_id, nama_teknik, status) FROM stdin;
1	Tes Tulis	1
2	Tes Lisan	1
3	Portofolio	1
\.


--
-- TOC entry 4117 (class 0 OID 16657)
-- Dependencies: 255
-- Data for Name: refekstra_kurikuler; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.refekstra_kurikuler (id_ekskul, nm_ekskul, u_sd, u_smp, u_sma, u_smk) FROM stdin;
1	Pramuka	1	1	1	1
2	Paskibra	0	1	1	1
3	Palang Merah Remaja (PMR)	0	1	1	1
4	Olahraga/ Beladiri	1	1	1	1
5	Unit Kesehatan Sekolah (UKS)	0	1	1	1
6	Pencinta Alam	0	0	1	1
7	Komputer dan Teknologi	1	1	1	1
8	Kerohanian	0	1	1	1
9	Karya Ilmiah Remaja/ Sains (KIR)	0	1	1	1
10	Seni Musik	1	1	1	1
11	Seni Tari dan Peran	1	1	1	1
12	Seni Media, Jurnalistik, Fotografi	0	1	1	1
13	Otomotif/ Bengkel/ Bikers	0	0	1	1
14	Patroli Keamanan Sekolah (PKS)	1	1	1	1
15	Wirausaha/ Koperasi/ keterampilan produktif	0	0	1	1
16	Bahasa	0	1	1	1
17	Tanggap Bencana	1	1	1	1
\.


--
-- TOC entry 4118 (class 0 OID 16664)
-- Dependencies: 256
-- Data for Name: semester; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.semester (semester_id, tahun_ajaran_id, nama_semester, semester, periode_aktif, tanggal_mulai, tanggal_selesai) FROM stdin;
20242	2024	2024/2025 Genap	2	1	2025-04-20	2025-04-20
\.


--
-- TOC entry 4119 (class 0 OID 16667)
-- Dependencies: 257
-- Data for Name: status_data; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.status_data (semester_id, aktif_data, keterangan) FROM stdin;
\.


--
-- TOC entry 4120 (class 0 OID 16670)
-- Dependencies: 258
-- Data for Name: status_input; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.status_input (semester_id, aktif_data, keterangan) FROM stdin;
\.


--
-- TOC entry 4121 (class 0 OID 16673)
-- Dependencies: 259
-- Data for Name: tabel_anggotakelas; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_anggotakelas (anggota_rombel_id, peserta_didik_id, rombongan_belajar_id, semester_id) FROM stdin;
\.


--
-- TOC entry 4122 (class 0 OID 16676)
-- Dependencies: 260
-- Data for Name: tabel_antar_mapel; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_antar_mapel (id_antar_mapel, anggota_rombel_id, semester_id, otomatis, sosial, keterangan, keterangansos, peserta_didik_id, sikap, sikapsos, khusus, semester) FROM stdin;
\.


--
-- TOC entry 4123 (class 0 OID 16681)
-- Dependencies: 261
-- Data for Name: tabel_asesor; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_asesor (asesor_id, sekolah_id, nama, nip, nuptk, jenis_kelamin, tempat_lahir, tanggal_lahir, alamat, status, id_dudi) FROM stdin;
\.


--
-- TOC entry 4124 (class 0 OID 16685)
-- Dependencies: 262
-- Data for Name: tabel_capaiantp; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_capaiantp (id_kompetensi, mata_pelajaran_id, tingkat_pendidikan_id, semester, jenis, kd_kompetensi, kompetensi, ringkasan_kompetensi, bidang, status, jenjang) FROM stdin;
\.


--
-- TOC entry 4125 (class 0 OID 16692)
-- Dependencies: 263
-- Data for Name: tabel_cat_wali; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_cat_wali (sikap_id, rombongan_belajar_id, peserta_didik_id, semester_id, deskripsi, deskripsi1, semester) FROM stdin;
\.


--
-- TOC entry 4126 (class 0 OID 16697)
-- Dependencies: 264
-- Data for Name: tabel_deskripsi; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_deskripsi (deskripsi_id, mata_pelajaran_id, rombongan_belajar_id, peserta_didik_id, deskripsi_peng_o, deskripsi_peng_m, deskripsi_ket_o, deskripsi_ket_m, deskripsi_sik_o, deskripsi_sik_m, deskripsi_siksos_o, deskripsi_siksos_m, semester_id, id_minat, anggota_rombel_id, semester) FROM stdin;
\.


--
-- TOC entry 4127 (class 0 OID 16702)
-- Dependencies: 265
-- Data for Name: tabel_deskripsi_tengah; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_deskripsi_tengah (deskripsi_id, mata_pelajaran_id, rombongan_belajar_id, peserta_didik_id, deskripsi_peng_o, deskripsi_peng_m, deskripsi_ket_o, deskripsi_ket_m, deskripsi_sik_o, deskripsi_sik_m, deskripsi_siksos_o, deskripsi_siksos_m, semester_id, id_minat, anggota_rombel_id, semester) FROM stdin;
\.


--
-- TOC entry 4128 (class 0 OID 16707)
-- Dependencies: 266
-- Data for Name: tabel_dudi; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_dudi (id_dudi, sekolah_id, nama_dudi, lokasi, keterangan, status) FROM stdin;
\.


--
-- TOC entry 4129 (class 0 OID 16713)
-- Dependencies: 267
-- Data for Name: tabel_ekstra; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_ekstra (id_ekstra, nama_ekstra, id_ekskul) FROM stdin;
\.


--
-- TOC entry 4130 (class 0 OID 16716)
-- Dependencies: 268
-- Data for Name: tabel_indikator_skkni; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_indikator_skkni (id_indikator, skkd_id, no_urut, indikator, status, sekolah_id) FROM stdin;
\.


--
-- TOC entry 4131 (class 0 OID 16723)
-- Dependencies: 269
-- Data for Name: tabel_info; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_info (id_info, v_app, v_db, pesan, tanggal, tampil) FROM stdin;
\.


--
-- TOC entry 4132 (class 0 OID 16726)
-- Dependencies: 270
-- Data for Name: tabel_jurusan; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_jurusan (jurusan_id, nama_jurusan_sp, kurikulum, jurusan_sp_id, kurikulum_id, sekolah_id) FROM stdin;
\.


--
-- TOC entry 4133 (class 0 OID 16729)
-- Dependencies: 271
-- Data for Name: tabel_kehadiran; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_kehadiran (kd_kehadiran, semester_id, anggota_rombel_id, sakit, izin, tanpa_keterangan, peserta_didik_id, semester) FROM stdin;
\.


--
-- TOC entry 4134 (class 0 OID 16732)
-- Dependencies: 272
-- Data for Name: tabel_kelas; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_kelas (rombongan_belajar_id, sekolah_id, semester_id, jurusan_id, ptk_id, nm_kelas, tingkat_pendidikan_id, jenis_rombel, nama_jurusan_sp, jurusan_sp_id, kurikulum_id, program, konsentrasi) FROM stdin;
\.


--
-- TOC entry 4135 (class 0 OID 16735)
-- Dependencies: 273
-- Data for Name: tabel_kelas_ekskul; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_kelas_ekskul (id_kelas_ekskul, rombongan_belajar_id, id_ekskul, nm_ekskul, sk_ekskul, tgl_sk_ekskul, jam_kegiatan_per_minggu) FROM stdin;
\.


--
-- TOC entry 4136 (class 0 OID 16738)
-- Dependencies: 274
-- Data for Name: tabel_kenaikan; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_kenaikan (kd_kenaikan, semester_id, anggota_rombel_id, peserta_didik_id, kenaikan, tingkat) FROM stdin;
\.


--
-- TOC entry 4137 (class 0 OID 16741)
-- Dependencies: 275
-- Data for Name: tabel_kkm; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_kkm (id_kkm, mata_pelajaran_id, tingkat_pendidikan_id, semester_id, kkm, jjm, jurusan_id) FROM stdin;
\.


--
-- TOC entry 4138 (class 0 OID 16744)
-- Dependencies: 276
-- Data for Name: tabel_kurikulum; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_kurikulum (kurikulum_id, nama_kurikulum, mulai_berlaku, sistem_sks, total_sks, jenjang_pendidikan_id, jurusan_id, create_date, last_update, expired_date, last_sync) FROM stdin;
\.


--
-- TOC entry 4139 (class 0 OID 16747)
-- Dependencies: 277
-- Data for Name: tabel_map_mapelk2013; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_map_mapelk2013 (id_map_mapel, mata_pelajaran_id, nm_lokal, area_kompetensi, klp_mpl, kurikulum_id, urut_rapor, tingkat_pendidikan_id) FROM stdin;
\.


--
-- TOC entry 4140 (class 0 OID 16751)
-- Dependencies: 278
-- Data for Name: tabel_map_mapelskl; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_map_mapelskl (id_map_mapel, mata_pelajaran_id, nm_lokal, area_kompetensi, klp_mpl, kurikulum_id, urut_skl, tingkat_pendidikan_id) FROM stdin;
\.


--
-- TOC entry 4141 (class 0 OID 16755)
-- Dependencies: 279
-- Data for Name: tabel_mapel; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_mapel (mata_pelajaran_id, nm_mapel, kelompok, semester, jurusan_id, urut_rapor, nm_lokal, nm_ringkas) FROM stdin;
\.


--
-- TOC entry 4142 (class 0 OID 16758)
-- Dependencies: 280
-- Data for Name: tabel_nilai_dudi; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_nilai_dudi (id_nilai_dudi, rombongan_belajar_id, anggota_rombel_id, peserta_didik_id, mitra, lokasi, lama, keterangan, semester_id, semester) FROM stdin;
\.


--
-- TOC entry 4143 (class 0 OID 16763)
-- Dependencies: 281
-- Data for Name: tabel_nilai_ekstra; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_nilai_ekstra (kd_nilai_ekstra, semester_id, anggota_rombel_id, id_ekstra, nilai_ekstra, deskripsi, peserta_didik_id, id_kelas_ekskul, ekskul_rombel_id, id_ekskul_baru, semester) FROM stdin;
\.


--
-- TOC entry 4144 (class 0 OID 16768)
-- Dependencies: 282
-- Data for Name: tabel_nilai_formatif; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_nilai_formatif (formatif_id, mata_pelajaran_id, rombongan_belajar_id, peserta_didik_id, id_kompetensi, nilai, teknik_id, semester_id, penilaian_ke) FROM stdin;
\.


--
-- TOC entry 4145 (class 0 OID 16771)
-- Dependencies: 283
-- Data for Name: tabel_nilai_karakter; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_nilai_karakter (id_nilai, rombongan_belajar_id, anggota_rombel_id, peserta_didik_id, dimensi1, dimensi2, dimensi3, dimensi4, dimensi5, dimensi6, semester_id, semester) FROM stdin;
\.


--
-- TOC entry 4146 (class 0 OID 16776)
-- Dependencies: 284
-- Data for Name: tabel_nilai_p3guru; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_nilai_p3guru (id_p3, rombongan_belajar_id, peserta_didik_id, id_subelemen, nilai, dimensi, semester_id, id_elemen, ptk_id, anggota_rombel_id, id_dimensi) FROM stdin;
\.


--
-- TOC entry 4147 (class 0 OID 16779)
-- Dependencies: 285
-- Data for Name: tabel_nilai_ukk; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_nilai_ukk (id_nilai_ukk, sekolah_id, semester_id, rombongan_belajar_id, anggota_rombel_id, peserta_didik_id, id_paket, id_dudi, ptk_id, asesor_id, tempat_ttd, tanggal, nilai_ukk, kesimpulan_id, kesimpulan_en, keterangan, waktu) FROM stdin;
\.


--
-- TOC entry 4148 (class 0 OID 16784)
-- Dependencies: 286
-- Data for Name: tabel_nilaiakhir; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_nilaiakhir (id_nilai_akhir, anggota_rombel_id, mata_pelajaran_id, semester_id, nilai_peng, predikat_peng, nilai_ket, predikat_ket, nilai_sik, predikat_sik, nilai_siksos, predikat_siksos, peserta_didik_id, id_minat, semester) FROM stdin;
\.


--
-- TOC entry 4149 (class 0 OID 16787)
-- Dependencies: 287
-- Data for Name: tabel_nilaiskl; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_nilaiskl (id_nilai_skl, semester_id, sekolah_id, rombongan_belajar_id, anggota_rombel_id, peserta_didik_id, mata_pelajaran_id, kurikulum_id, nilai) FROM stdin;
\.


--
-- TOC entry 4150 (class 0 OID 16790)
-- Dependencies: 288
-- Data for Name: tabel_nilaitengah; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_nilaitengah (id_nilai_akhir, anggota_rombel_id, mata_pelajaran_id, semester_id, nilai_peng, predikat_peng, nilai_ket, predikat_ket, nilai_sik, predikat_sik, nilai_siksos, predikat_siksos, peserta_didik_id, id_minat, semester) FROM stdin;
\.


--
-- TOC entry 4151 (class 0 OID 16793)
-- Dependencies: 289
-- Data for Name: tabel_paket_kompetensi; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_paket_kompetensi (id_paket, sekolah_id, kd_paket, nama_paket_id, nama_paket_en, jurusan_id, kurikulum_id, status) FROM stdin;
\.


--
-- TOC entry 4152 (class 0 OID 16797)
-- Dependencies: 290
-- Data for Name: tabel_pembelajaran; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_pembelajaran (pembelajaran_id, rombongan_belajar_id, mata_pelajaran_id, semester_id, ptk_terdaftar_id, status_di_kurikulum, nama_mata_pelajaran, induk_pembelajaran, is_dapo) FROM stdin;
\.


--
-- TOC entry 4153 (class 0 OID 16802)
-- Dependencies: 291
-- Data for Name: tabel_pengumumanlulus; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_pengumumanlulus (setlulus_id, tahun_ajaran_id, nomor_sk, link_sk, isi_lulus, isi_gagal, sekolah_id, tgl_pengumuman, status_aktif) FROM stdin;
\.


--
-- TOC entry 4154 (class 0 OID 16809)
-- Dependencies: 292
-- Data for Name: tabel_ptk; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_ptk (ptk_id, nama, nip, jenis_ptk_id, jenis_kelamin, tempat_lahir, tanggal_lahir, nuptk, alamat_jalan, status_keaktifan_id, soft_delete) FROM stdin;
\.


--
-- TOC entry 4155 (class 0 OID 16812)
-- Dependencies: 293
-- Data for Name: tabel_ptk_pelengkap; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_ptk_pelengkap (ptk_pelengkap_id, ptk_id, gelar_depan, gelar_belakang, nip_niy) FROM stdin;
\.


--
-- TOC entry 4156 (class 0 OID 16816)
-- Dependencies: 294
-- Data for Name: tabel_ptk_terdaftar; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_ptk_terdaftar (ptk_terdaftar_id, ptk_id, tahun_ajaran_id, jenis_keluar_id, soft_delete, sekolah_id) FROM stdin;
\.


--
-- TOC entry 4157 (class 0 OID 16819)
-- Dependencies: 295
-- Data for Name: tabel_ptspas; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_ptspas (id_ptspas, semester_id, mata_pelajaran_id, rombongan_belajar_id, peserta_didik_id, anggota_rombel_id, nil_pts, nil_pas) FROM stdin;
\.


--
-- TOC entry 4158 (class 0 OID 16822)
-- Dependencies: 296
-- Data for Name: tabel_registrasi_pd; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_registrasi_pd (registrasi_id, jurusan_sp_id, peserta_didik_id, sekolah_id, jenis_pendaftaran_id, nipd, tanggal_masuk_sekolah, jenis_keluar_id, tanggal_keluar, keterangan, no_skhun, no_peserta_ujian, no_seri_ijazah, a_pernah_paud, a_pernah_tk, sekolah_asal, id_hobby, id_cita, last_update, soft_delete, last_sync, updater_id) FROM stdin;
\.


--
-- TOC entry 4159 (class 0 OID 16829)
-- Dependencies: 297
-- Data for Name: tabel_rombel_skil; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_rombel_skil (idrombel_skill, rombongan_belajar_id, skkd_id, semester_id, id_indikator) FROM stdin;
\.


--
-- TOC entry 4160 (class 0 OID 16834)
-- Dependencies: 298
-- Data for Name: tabel_sekolah; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_sekolah (sekolah_id, nama, npsn, nss, alamat, kd_pos, telepon, fax, kelurahan, kecamatan, kab_kota, propinsi, website, email, nm_kepsek, nip_kepsek, niy_kepsek, status_kepemilikan_id, kode_aktivasi, jenjang, bentuk_pendidikan_id) FROM stdin;
\.


--
-- TOC entry 4161 (class 0 OID 16839)
-- Dependencies: 299
-- Data for Name: tabel_setskl; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_setskl (setskl_id, tahun_ajaran_id, judul_1, nomor_skl, judul_2, isi_text1, identitas_id1, identitas_id2, identitas_id3, identitas_id4, identitas_id5, identitas_id6, identitas_id7, identitas_id8, isi_text2, isi_text3, ada_nilai, judul_nilai, isi_text4, ket_tempat_ttd, nama_kepsek, nip_kepsek, ada_foto, ada_ttd, ada_kop, statuslulus, desimal_nilai, ada_ratarata, desimal_ratarata, sekolah_id) FROM stdin;
\.


--
-- TOC entry 4162 (class 0 OID 16853)
-- Dependencies: 300
-- Data for Name: tabel_siswa; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_siswa (peserta_didik_id, nis, nisn, nm_siswa, tempat_lahir, tanggal_lahir, jenis_kelamin, agama, alamat_siswa, telepon_siswa, diterima_tanggal, nm_ayah, nm_ibu, pekerjaan_ayah, pekerjaan_ibu, nm_wali, pekerjaan_wali) FROM stdin;
\.


--
-- TOC entry 4163 (class 0 OID 16858)
-- Dependencies: 301
-- Data for Name: tabel_siswa_pelengkap; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_siswa_pelengkap (pelengkap_siswa_id, peserta_didik_id, status_dalam_kel, anak_ke, sekolah_asal, diterima_kelas, alamat_ortu, telepon_ortu, alamat_wali, telepon_wali, foto_siswa, no_ijasahnas, tgl_lulus, no_transkrip) FROM stdin;
\.


--
-- TOC entry 4164 (class 0 OID 16864)
-- Dependencies: 302
-- Data for Name: tabel_skilpassport; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_skilpassport (id_skilpassport, idrombel_skill, rombongan_belajar_id, anggota_rombel_id, peserta_didik_id, skkd_id, semester_id, ujisiswa, tgl_uji, nilai, ptk_id) FROM stdin;
\.


--
-- TOC entry 4165 (class 0 OID 16867)
-- Dependencies: 303
-- Data for Name: tabel_sklidentitas; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_sklidentitas (id, nama_identitas, kolom, status) FROM stdin;
\.


--
-- TOC entry 4166 (class 0 OID 16870)
-- Dependencies: 304
-- Data for Name: tabel_sskkd_skkni; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_sskkd_skkni (skkd_id, sekolah_id, kurikulum_id, tingkat_pendidikan_id, kd_skkni, kompetensi, jenjang, status, urut_kd) FROM stdin;
\.


--
-- TOC entry 4167 (class 0 OID 16876)
-- Dependencies: 305
-- Data for Name: tabel_sumatif_pas; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_sumatif_pas (sumatif_id, mata_pelajaran_id, rombongan_belajar_id, peserta_didik_id, nilai, jenis, semester_id, penilaian_ke, targetcapaian, capaian, keterangan, statuscapaian, targetcapaian_id, kd_capaian, bobotsum) FROM stdin;
\.


--
-- TOC entry 4168 (class 0 OID 16880)
-- Dependencies: 306
-- Data for Name: tabel_tanggalrapor; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_tanggalrapor (tanggal_id, semester_id, tanggal, semester, tempat_ttd, status_kepsek, status_nip_kepsek, status_nip_walas, ttd_validasi) FROM stdin;
\.


--
-- TOC entry 4169 (class 0 OID 16884)
-- Dependencies: 307
-- Data for Name: tabel_targetcapaian; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_targetcapaian (targetcapaian_id, mata_pelajaran_id, tingkat_pendidikan_id, semester, kd_capaian, targetcapaian, status, jenjang) FROM stdin;
\.


--
-- TOC entry 4170 (class 0 OID 16889)
-- Dependencies: 308
-- Data for Name: tabel_targetcptp; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_targetcptp (targetid, mata_pelajaran_id, fase, targetcapaian_id, id_kompetensi) FROM stdin;
\.


--
-- TOC entry 4171 (class 0 OID 16893)
-- Dependencies: 309
-- Data for Name: tabel_unit_kompetensi; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.tabel_unit_kompetensi (id_unit, id_paket, urut_unit, kd_unit, nama_unit, status) FROM stdin;
\.


--
-- TOC entry 4172 (class 0 OID 16898)
-- Dependencies: 310
-- Data for Name: user_login; Type: TABLE DATA; Schema: public; Owner: raporsp_user
--

COPY public.user_login (userid, password, nama, level, ptk_id, salt, is_logged_in, tgl_daftar, last_logged_in, add_by, ip_address, photo, status_edit, is_active, email, sub_you, id, last_logged_out, thema, warnaheader, warnaside) FROM stdin;
administrator	3d7754b21a0fc33c34419d7f7e505faa6a3fb608e7e31c8441f66f9410513c9923379a887a3d0ec2cb130fde5234d756c6437d391b0d285be38d947a9cb3e651	Administrator	Admin	\N	e46dcf409336f030b0e2bb05ac603db06046ca40b1abeaedf43ea79a186931ef5d0060b18d7d96d0b1827e3d0b27eb506edf717cc0b26aac1de43fb134f108b7	0	\N	2025-04-25 07:18:37	\N	::1	\N	1	1	adminraporsp@aplikasipasek.com	0	b466e99b-6ca5-4977-b96e-0c862b07a10d	2025-04-25 09:25:14	pasek-theme		
\.


--
-- TOC entry 4173 (class 0 OID 16910)
-- Dependencies: 311
-- Data for Name: koneksi; Type: TABLE DATA; Schema: tambah; Owner: raporsp_user
--

COPY tambah.koneksi (id_data, nama_app, alamat_ip, key, port, npsn, ip_mpd) FROM stdin;
\.


--
-- TOC entry 4174 (class 0 OID 16917)
-- Dependencies: 312
-- Data for Name: koneksi_ext; Type: TABLE DATA; Schema: tambah; Owner: raporsp_user
--

COPY tambah.koneksi_ext (id_data, nama_app, ip_ext, key, "user", pass, id_sekolah) FROM stdin;
\.


--
-- TOC entry 4175 (class 0 OID 16924)
-- Dependencies: 313
-- Data for Name: log_nilaiakhir; Type: TABLE DATA; Schema: tambah; Owner: raporsp_user
--

COPY tambah.log_nilaiakhir (id_log, anggota_rombel_id, mata_pelajaran_id, semester_id, nilai_peng_awal, nilai_peng_akhir, peserta_didik_id, tgl_update, pengguna_id, keterangan) FROM stdin;
\.


--
-- TOC entry 4176 (class 0 OID 16931)
-- Dependencies: 314
-- Data for Name: logo_ttdkepsek; Type: TABLE DATA; Schema: tambah; Owner: raporsp_user
--

COPY tambah.logo_ttdkepsek (sekolah_id, logo_pemda, logo_sek, ttd_kepsek, kop_sekolah) FROM stdin;
\.


--
-- TOC entry 4177 (class 0 OID 16934)
-- Dependencies: 315
-- Data for Name: mapel_gabung; Type: TABLE DATA; Schema: tambah; Owner: raporsp_user
--

COPY tambah.mapel_gabung (id_data, mata_pelajaran_id_asal, mata_pelajaran_id, tingkat_pendidikan_id, jenjang, status) FROM stdin;
\.


--
-- TOC entry 4178 (class 0 OID 16939)
-- Dependencies: 316
-- Data for Name: mata_pelajaran_kurikulum; Type: TABLE DATA; Schema: tambah; Owner: raporsp_user
--

COPY tambah.mata_pelajaran_kurikulum (kurikulum_id, mata_pelajaran_id, tingkat_pendidikan_id, jumlah_jam, jumlah_jam_maksimum, status_di_kurikulum, wajib, sks, a_peminatan, area_kompetensi, gmp_id, create_date, last_update, expired_date, last_sync) FROM stdin;
4	100011000	1	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.579	\N	2022-07-01 22:05:01.579
4	100011000	2	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.58	\N	2022-07-01 22:05:01.58
4	100011000	3	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.58	\N	2022-07-01 22:05:01.58
4	100011000	4	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.58	\N	2022-07-01 22:05:01.58
4	100011000	5	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.581	\N	2022-07-01 22:05:01.581
4	100011000	6	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.581	\N	2022-07-01 22:05:01.581
4	100011070	1	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.592	\N	2022-07-01 22:05:01.592
4	100011070	2	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.592	\N	2022-07-01 22:05:01.592
4	100011070	3	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.593	\N	2022-07-01 22:05:01.593
4	100011070	4	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.593	\N	2022-07-01 22:05:01.593
4	100011070	5	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.593	\N	2022-07-01 22:05:01.593
4	100011070	6	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.594	\N	2022-07-01 22:05:01.594
4	100012000	1	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.594	\N	2022-07-01 22:05:01.594
4	100012000	2	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.594	\N	2022-07-01 22:05:01.594
4	100012000	3	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.595	\N	2022-07-01 22:05:01.595
4	100012000	4	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.595	\N	2022-07-01 22:05:01.595
4	100012000	5	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.595	\N	2022-07-01 22:05:01.595
4	100012000	6	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.596	\N	2022-07-01 22:05:01.596
4	100012050	1	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.605	\N	2022-07-01 22:05:01.605
4	100012050	2	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.605	\N	2022-07-01 22:05:01.605
4	100012050	3	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.605	\N	2022-07-01 22:05:01.605
4	100012050	4	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.606	\N	2022-07-01 22:05:01.606
4	100012050	5	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.606	\N	2022-07-01 22:05:01.606
4	100012050	6	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.606	\N	2022-07-01 22:05:01.606
4	100013000	1	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.607	\N	2022-07-01 22:05:01.607
4	100013000	2	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.607	\N	2022-07-01 22:05:01.607
4	100013000	3	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.607	\N	2022-07-01 22:05:01.607
4	100013000	4	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.607	\N	2022-07-01 22:05:01.607
4	100013000	5	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.608	\N	2022-07-01 22:05:01.608
4	100013000	6	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.608	\N	2022-07-01 22:05:01.608
4	100013010	1	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.609	\N	2022-07-01 22:05:01.609
4	100013010	2	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.61	\N	2022-07-01 22:05:01.61
4	100013010	3	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.61	\N	2022-07-01 22:05:01.61
4	100013010	4	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.61	\N	2022-07-01 22:05:01.61
4	100013010	5	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.611	\N	2022-07-01 22:05:01.611
4	100013010	6	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.611	\N	2022-07-01 22:05:01.611
4	100014000	1	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.611	\N	2022-07-01 22:05:01.611
4	100014000	2	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.612	\N	2022-07-01 22:05:01.612
4	100014000	3	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.612	\N	2022-07-01 22:05:01.612
4	100014000	4	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.612	\N	2022-07-01 22:05:01.612
4	100014000	5	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.613	\N	2022-07-01 22:05:01.613
4	100014000	6	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.613	\N	2022-07-01 22:05:01.613
4	100014140	1	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.615	\N	2022-07-01 22:05:01.615
4	100014140	2	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.615	\N	2022-07-01 22:05:01.615
4	100014140	3	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.615	\N	2022-07-01 22:05:01.615
4	100014140	4	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.616	\N	2022-07-01 22:05:01.616
4	100014140	5	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.616	\N	2022-07-01 22:05:01.616
4	100014140	6	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.616	\N	2022-07-01 22:05:01.616
4	100015000	1	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.617	\N	2022-07-01 22:05:01.617
4	100015000	2	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.617	\N	2022-07-01 22:05:01.617
4	100015000	3	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.617	\N	2022-07-01 22:05:01.617
4	100015000	4	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.617	\N	2022-07-01 22:05:01.617
4	100015000	5	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.618	\N	2022-07-01 22:05:01.618
4	100015000	6	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.618	\N	2022-07-01 22:05:01.618
4	100015010	1	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.619	\N	2022-07-01 22:05:01.619
4	100015010	2	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.62	\N	2022-07-01 22:05:01.62
4	100015010	3	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.621	\N	2022-07-01 22:05:01.621
4	100015010	4	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.621	\N	2022-07-01 22:05:01.621
4	100015010	5	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.621	\N	2022-07-01 22:05:01.621
4	100015010	6	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.622	\N	2022-07-01 22:05:01.622
4	100016000	1	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.622	\N	2022-07-01 22:05:01.622
4	100016000	2	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.622	\N	2022-07-01 22:05:01.622
4	100016000	3	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.623	\N	2022-07-01 22:05:01.623
4	100016000	4	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.623	\N	2022-07-01 22:05:01.623
4	100016000	5	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.623	\N	2022-07-01 22:05:01.623
4	100016000	6	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.623	\N	2022-07-01 22:05:01.623
4	100016010	1	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.625	\N	2022-07-01 22:05:01.625
4	100016010	2	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.625	\N	2022-07-01 22:05:01.625
4	100016010	3	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.625	\N	2022-07-01 22:05:01.625
4	100016010	4	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.626	\N	2022-07-01 22:05:01.626
4	100016010	5	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.626	\N	2022-07-01 22:05:01.626
4	100016010	6	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.626	\N	2022-07-01 22:05:01.626
4	109011000	1	0	4	1	1	0	0	*	\N	2017-01-31 01:00:00	2022-07-01 22:05:01.627	\N	2022-07-01 22:05:01.627
4	109011000	2	0	4	1	1	0	0	*	\N	2017-01-31 01:00:00	2022-07-01 22:05:01.627	\N	2022-07-01 22:05:01.627
4	109011000	3	0	4	1	1	0	0	*	\N	2017-01-31 01:00:00	2022-07-01 22:05:01.627	\N	2022-07-01 22:05:01.627
4	109011000	4	0	4	1	1	0	0	*	\N	2017-01-31 01:00:00	2022-07-01 22:05:01.628	\N	2022-07-01 22:05:01.628
4	109011000	5	0	4	1	1	0	0	*	\N	2017-01-31 01:00:00	2022-07-01 22:05:01.628	\N	2022-07-01 22:05:01.628
4	109011000	6	0	4	1	1	0	0	*	\N	2017-01-31 01:00:00	2022-07-01 22:05:01.628	\N	2022-07-01 22:05:01.628
4	109011010	1	0	4	10	0	0	0	*	\N	2017-01-31 01:00:00	2022-07-01 22:05:01.63	\N	2022-07-01 22:05:01.63
4	109011010	2	0	4	10	0	0	0	*	\N	2017-01-31 01:00:00	2022-07-01 22:05:01.63	\N	2022-07-01 22:05:01.63
4	109011010	3	0	4	10	0	0	0	*	\N	2017-01-31 01:00:00	2022-07-01 22:05:01.63	\N	2022-07-01 22:05:01.63
4	109011010	4	0	4	10	0	0	0	*	\N	2017-01-31 01:00:00	2022-07-01 22:05:01.631	\N	2022-07-01 22:05:01.631
4	109011010	5	0	4	10	0	0	0	*	\N	2017-01-31 01:00:00	2022-07-01 22:05:01.631	\N	2022-07-01 22:05:01.631
4	109011010	6	0	4	10	0	0	0	*	\N	2017-01-31 01:00:00	2022-07-01 22:05:01.631	\N	2022-07-01 22:05:01.631
4	200010000	1	0	5	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.632	\N	2022-07-01 22:05:01.632
4	200010000	2	0	6	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.632	\N	2022-07-01 22:05:01.632
4	200010000	3	0	6	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.632	\N	2022-07-01 22:05:01.632
4	200010000	4	0	6	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.633	\N	2022-07-01 22:05:01.633
4	200010000	5	0	6	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.633	\N	2022-07-01 22:05:01.633
4	200010000	6	0	6	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.633	\N	2022-07-01 22:05:01.633
4	300110000	1	0	8	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.635	\N	2022-07-01 22:05:01.635
4	300110000	2	0	8	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.636	\N	2022-07-01 22:05:01.636
4	300110000	3	0	8	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.636	\N	2022-07-01 22:05:01.636
4	300110000	4	0	8	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.636	\N	2022-07-01 22:05:01.636
4	300110000	5	0	8	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.637	\N	2022-07-01 22:05:01.637
4	300110000	6	0	8	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.637	\N	2022-07-01 22:05:01.637
4	300311900	1	0	2	2	2	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.655	\N	2022-07-01 22:05:01.655
4	300311900	2	0	2	2	2	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.655	\N	2022-07-01 22:05:01.655
4	300311900	3	0	2	2	2	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.656	\N	2022-07-01 22:05:01.656
4	300311900	4	0	2	2	2	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.656	\N	2022-07-01 22:05:01.656
4	300311900	5	0	2	2	2	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.656	\N	2022-07-01 22:05:01.656
4	300311900	6	0	2	2	2	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.657	\N	2022-07-01 22:05:01.657
4	300312900	1	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:01.658	\N	2022-07-01 22:05:01.658
4	300312900	2	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:01.658	\N	2022-07-01 22:05:01.658
4	300312900	3	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:01.659	\N	2022-07-01 22:05:01.659
4	300312900	4	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:01.659	\N	2022-07-01 22:05:01.659
4	300312900	5	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:01.659	\N	2022-07-01 22:05:01.659
4	300312900	6	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:01.66	\N	2022-07-01 22:05:01.66
4	400200000	1	0	24	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.661	\N	2022-07-01 22:05:01.661
4	400200000	2	0	24	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.661	\N	2022-07-01 22:05:01.661
4	400200000	3	0	24	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.662	\N	2022-07-01 22:05:01.662
4	400200000	4	0	24	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.662	\N	2022-07-01 22:05:01.662
4	400200000	5	0	24	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.662	\N	2022-07-01 22:05:01.662
4	400200000	6	0	24	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.663	\N	2022-07-01 22:05:01.663
4	401000000	1	0	5	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.664	\N	2022-07-01 22:05:01.664
4	401000000	2	0	6	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.664	\N	2022-07-01 22:05:01.664
4	401000000	3	0	6	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.665	\N	2022-07-01 22:05:01.665
4	401000000	4	0	6	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.665	\N	2022-07-01 22:05:01.665
4	401000000	5	0	6	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.665	\N	2022-07-01 22:05:01.665
4	401000000	6	0	6	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.666	\N	2022-07-01 22:05:01.666
4	401100000	1	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.667	\N	2022-07-01 22:05:01.667
4	401100000	2	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.667	\N	2022-07-01 22:05:01.667
4	401100000	3	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.668	\N	2022-07-01 22:05:01.668
4	401100000	4	0	0	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.668	\N	2022-07-01 22:05:01.668
4	401100000	5	0	0	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.668	\N	2022-07-01 22:05:01.668
4	401100000	6	0	0	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.669	\N	2022-07-01 22:05:01.669
4	401200000	1	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.679	\N	2022-07-01 22:05:01.679
4	401200000	2	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.679	\N	2022-07-01 22:05:01.679
4	401200000	3	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.679	\N	2022-07-01 22:05:01.679
4	401200000	4	0	0	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.68	\N	2022-07-01 22:05:01.68
4	401200000	5	0	0	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.68	\N	2022-07-01 22:05:01.68
4	401200000	6	0	0	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.68	\N	2022-07-01 22:05:01.68
4	500010000	1	0	4	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.696	\N	2022-07-01 22:05:01.696
4	500010000	2	0	4	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.697	\N	2022-07-01 22:05:01.697
4	500010000	3	0	4	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.697	\N	2022-07-01 22:05:01.697
4	500010000	4	0	4	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.697	\N	2022-07-01 22:05:01.697
4	500010000	5	0	4	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.698	\N	2022-07-01 22:05:01.698
4	500010000	6	0	4	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.698	\N	2022-07-01 22:05:01.698
4	600020000	1	0	0	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.705	\N	2022-07-01 22:05:01.705
4	600020000	2	0	0	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.705	\N	2022-07-01 22:05:01.705
4	600020000	3	0	0	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.706	\N	2022-07-01 22:05:01.706
4	600020000	4	0	0	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.706	\N	2022-07-01 22:05:01.706
4	600020000	5	0	0	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.706	\N	2022-07-01 22:05:01.706
4	600020000	6	0	0	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.707	\N	2022-07-01 22:05:01.707
10111	100011070	1	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	100011070	2	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	100011070	3	0	4	1	1	0	0	*	\N	2022-07-10 09:00:00	2023-07-10 00:00:00	\N	1901-01-01 00:00:00
10111	100011070	4	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	100011070	5	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	100011070	6	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	100012050	1	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	100012050	2	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	100012050	3	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	100012050	4	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	100012050	5	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	100012050	6	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	100013010	1	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	100013010	2	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	100013010	3	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	100013010	4	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	100013010	5	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	100013010	6	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	100014140	1	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	100014140	2	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	100014140	3	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	100014140	4	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	100014140	5	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	100014140	6	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	100015010	1	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	100015010	2	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	100015010	3	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	100015010	4	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	100015010	5	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	100015010	6	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	100016010	1	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	100016010	2	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	100016010	3	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	100016010	4	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	100016010	5	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	100016010	6	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	109011010	1	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	109011010	2	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	109011010	3	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	109011010	4	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	109011010	5	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	109011010	6	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	200010000	1	0	5	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	200010000	2	0	5	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	200010000	3	0	5	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	200010000	4	0	5	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	200010000	5	0	5	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	200010000	6	0	5	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	300110000	1	0	8	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	300110000	2	0	8	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	300110000	3	0	7	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	300110000	4	0	7	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	300110000	5	0	7	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	300110000	6	0	7	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	300210000	1	0	2	2	2	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	300210000	2	0	2	2	2	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	300210000	3	0	2	2	2	0	0	*	\N	2022-06-21 15:00:00	2024-07-17 00:00:00	\N	1901-01-01 00:00:00
10111	300210000	4	0	2	2	2	0	0	*	\N	2022-06-21 15:00:00	2024-07-17 00:00:00	\N	1901-01-01 00:00:00
10111	300210000	5	0	2	2	2	0	0	*	\N	2022-06-21 15:00:00	2024-07-17 00:00:00	\N	1901-01-01 00:00:00
10111	300210000	6	0	2	2	2	0	0	*	\N	2022-06-21 15:00:00	2024-07-17 00:00:00	\N	1901-01-01 00:00:00
10111	300311900	1	0	2	2	2	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	300311900	2	0	2	2	2	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	300311900	3	0	2	2	2	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	300311900	4	0	2	2	2	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	300311900	5	0	2	2	2	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	300311900	6	0	2	2	2	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	300312900	1	0	2	2	2	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	300312900	2	0	2	2	2	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	300312900	3	0	2	2	2	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	300312900	4	0	2	2	2	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	300312900	5	0	2	2	2	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	300312900	6	0	2	2	2	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	400200000	1	0	24	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	400200000	2	0	24	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	400200000	3	0	24	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	400200000	4	0	24	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	400200000	5	0	24	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	400200000	6	0	24	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	401000000	1	0	5	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	401000000	2	0	6	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	401000000	3	0	6	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	401000000	4	0	6	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	401000000	5	0	6	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	401000000	6	0	6	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	401900000	3	0	6	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	401900000	4	0	6	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	401900000	5	0	6	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	401900000	6	0	6	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	500010000	1	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	500010000	2	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	500010000	3	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	500010000	4	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	500010000	5	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	500010000	6	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	843020100	1	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	843020100	2	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	843020100	3	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	843020100	4	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	843020100	5	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
10111	843020100	6	0	4	1	1	0	0	*	\N	2022-06-21 15:00:00	2022-07-15 01:44:06.18	\N	2022-07-15 01:44:06.18
\.


--
-- TOC entry 4179 (class 0 OID 16948)
-- Dependencies: 317
-- Data for Name: ref_mapping_mapeldapo; Type: TABLE DATA; Schema: tambah; Owner: raporsp_user
--

COPY tambah.ref_mapping_mapeldapo (kurikulum_id, mata_pelajaran_id, tingkat_pendidikan_id, jumlah_jam, jumlah_jam_maksimum, status_di_kurikulum, wajib, sks, a_peminatan, area_kompetensi, gmp_id, create_date, last_update, expired_date, last_sync) FROM stdin;
428	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.196	\N	2022-07-01 22:05:12.196
428	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.196	\N	2022-07-01 22:05:12.196
429	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.196	\N	2022-07-01 22:05:12.196
429	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.196	\N	2022-07-01 22:05:12.196
429	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.197	\N	2022-07-01 22:05:12.197
429	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.197	\N	2022-07-01 22:05:12.197
429	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.197	\N	2022-07-01 22:05:12.197
429	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.197	\N	2022-07-01 22:05:12.197
429	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.198	\N	2022-07-01 22:05:12.198
429	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.198	\N	2022-07-01 22:05:12.198
429	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.198	\N	2022-07-01 22:05:12.198
429	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.198	\N	2022-07-01 22:05:12.198
429	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.199	\N	2022-07-01 22:05:12.199
429	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.199	\N	2022-07-01 22:05:12.199
429	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.199	\N	2022-07-01 22:05:12.199
429	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.199	\N	2022-07-01 22:05:12.199
429	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.2	\N	2022-07-01 22:05:12.2
429	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.2	\N	2022-07-01 22:05:12.2
429	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.2	\N	2022-07-01 22:05:12.2
429	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.2	\N	2022-07-01 22:05:12.2
429	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.201	\N	2022-07-01 22:05:12.201
429	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.201	\N	2022-07-01 22:05:12.201
429	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.202	\N	2022-07-01 22:05:12.202
429	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.202	\N	2022-07-01 22:05:12.202
429	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.202	\N	2022-07-01 22:05:12.202
429	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.202	\N	2022-07-01 22:05:12.202
429	300210000	13	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.203	\N	2022-07-01 22:05:12.203
429	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.203	\N	2022-07-01 22:05:12.203
429	300310100	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.203	\N	2022-07-01 22:05:12.203
429	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.203	\N	2022-07-01 22:05:12.203
429	300310200	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.204	\N	2022-07-01 22:05:12.204
429	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.204	\N	2022-07-01 22:05:12.204
429	300310300	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.204	\N	2022-07-01 22:05:12.204
429	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.204	\N	2022-07-01 22:05:12.204
429	300310400	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.205	\N	2022-07-01 22:05:12.205
429	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.205	\N	2022-07-01 22:05:12.205
429	300310500	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.205	\N	2022-07-01 22:05:12.205
429	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.205	\N	2022-07-01 22:05:12.205
429	300310600	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.206	\N	2022-07-01 22:05:12.206
429	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.206	\N	2022-07-01 22:05:12.206
429	300310700	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.206	\N	2022-07-01 22:05:12.206
429	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.206	\N	2022-07-01 22:05:12.206
429	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.207	\N	2022-07-01 22:05:12.207
429	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.208	\N	2022-07-01 22:05:12.208
429	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.208	\N	2022-07-01 22:05:12.208
429	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.208	\N	2022-07-01 22:05:12.208
10814	800000280	12	0	4	11	0	0	0	P	\N	2024-07-10 17:30:00	2024-07-17 00:00:00	\N	1901-01-01 00:00:00
429	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:12.208	\N	2022-07-01 22:05:12.208
429	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:12.209	\N	2022-07-01 22:05:12.209
429	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.209	\N	2022-07-01 22:05:12.209
429	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.209	\N	2022-07-01 22:05:12.209
429	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.209	\N	2022-07-01 22:05:12.209
429	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.21	\N	2022-07-01 22:05:12.21
429	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.211	\N	2022-07-01 22:05:12.211
429	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.211	\N	2022-07-01 22:05:12.211
429	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.211	\N	2022-07-01 22:05:12.211
429	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.211	\N	2022-07-01 22:05:12.211
429	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.212	\N	2022-07-01 22:05:12.212
429	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.217	\N	2022-07-01 22:05:12.217
429	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.217	\N	2022-07-01 22:05:12.217
429	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.217	\N	2022-07-01 22:05:12.217
429	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.218	\N	2022-07-01 22:05:12.218
429	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.218	\N	2022-07-01 22:05:12.218
429	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.218	\N	2022-07-01 22:05:12.218
429	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.219	\N	2022-07-01 22:05:12.219
429	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.219	\N	2022-07-01 22:05:12.219
429	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.219	\N	2022-07-01 22:05:12.219
430	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.22	\N	2022-07-01 22:05:12.22
430	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.22	\N	2022-07-01 22:05:12.22
430	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.22	\N	2022-07-01 22:05:12.22
430	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.221	\N	2022-07-01 22:05:12.221
430	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.221	\N	2022-07-01 22:05:12.221
430	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.221	\N	2022-07-01 22:05:12.221
430	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.221	\N	2022-07-01 22:05:12.221
430	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.221	\N	2022-07-01 22:05:12.221
430	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.222	\N	2022-07-01 22:05:12.222
430	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.222	\N	2022-07-01 22:05:12.222
430	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.222	\N	2022-07-01 22:05:12.222
430	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.222	\N	2022-07-01 22:05:12.222
430	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.223	\N	2022-07-01 22:05:12.223
430	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.223	\N	2022-07-01 22:05:12.223
430	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.223	\N	2022-07-01 22:05:12.223
430	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.223	\N	2022-07-01 22:05:12.223
430	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.224	\N	2022-07-01 22:05:12.224
430	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.224	\N	2022-07-01 22:05:12.224
430	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.225	\N	2022-07-01 22:05:12.225
430	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.225	\N	2022-07-01 22:05:12.225
430	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.225	\N	2022-07-01 22:05:12.225
430	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.226	\N	2022-07-01 22:05:12.226
430	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.226	\N	2022-07-01 22:05:12.226
430	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.226	\N	2022-07-01 22:05:12.226
430	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.227	\N	2022-07-01 22:05:12.227
430	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.227	\N	2022-07-01 22:05:12.227
430	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.227	\N	2022-07-01 22:05:12.227
430	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.227	\N	2022-07-01 22:05:12.227
430	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.228	\N	2022-07-01 22:05:12.228
430	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.228	\N	2022-07-01 22:05:12.228
430	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.228	\N	2022-07-01 22:05:12.228
10837	800000280	12	0	4	11	0	0	0	P	\N	2024-07-10 17:30:00	2024-07-17 00:00:00	\N	1901-01-01 00:00:00
429	401240000	10	0	2	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
430	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.229	\N	2022-07-01 22:05:12.229
430	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.229	\N	2022-07-01 22:05:12.229
430	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.229	\N	2022-07-01 22:05:12.229
430	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
430	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
430	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.229	\N	2022-07-01 22:05:12.229
430	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:12.23	\N	2022-07-01 22:05:12.23
430	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:12.23	\N	2022-07-01 22:05:12.23
430	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.23	\N	2022-07-01 22:05:12.23
430	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.23	\N	2022-07-01 22:05:12.23
430	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.231	\N	2022-07-01 22:05:12.231
430	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.232	\N	2022-07-01 22:05:12.232
430	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.232	\N	2022-07-01 22:05:12.232
430	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.232	\N	2022-07-01 22:05:12.232
430	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.233	\N	2022-07-01 22:05:12.233
430	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.233	\N	2022-07-01 22:05:12.233
10864	800000280	12	0	4	11	0	0	0	P	\N	2024-07-10 17:30:00	2024-07-17 00:00:00	\N	1901-01-01 00:00:00
430	401121000	10	0	2	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
430	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.234	\N	2022-07-01 22:05:12.234
430	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.234	\N	2022-07-01 22:05:12.234
430	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.234	\N	2022-07-01 22:05:12.234
430	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.238	\N	2022-07-01 22:05:12.238
430	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.238	\N	2022-07-01 22:05:12.238
430	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.239	\N	2022-07-01 22:05:12.239
430	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.239	\N	2022-07-01 22:05:12.239
4	100010000	4	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.578	\N	2022-07-01 22:05:01.578
4	100010000	5	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.579	\N	2022-07-01 22:05:01.579
4	100010000	6	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.579	\N	2022-07-01 22:05:01.579
4	100011000	1	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.579	\N	2022-07-01 22:05:01.579
4	100011000	2	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.58	\N	2022-07-01 22:05:01.58
4	100011000	3	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.58	\N	2022-07-01 22:05:01.58
4	100011000	4	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.58	\N	2022-07-01 22:05:01.58
4	100011000	5	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.581	\N	2022-07-01 22:05:01.581
4	100011000	7	0	4	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.581	\N	2022-07-01 22:05:01.581
4	100011000	8	0	4	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.582	\N	2022-07-01 22:05:01.582
4	100011000	9	0	4	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.582	\N	2022-07-01 22:05:01.582
4	100011010	1	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.582	\N	2022-07-01 22:05:01.582
4	100011010	2	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.583	\N	2022-07-01 22:05:01.583
4	100011010	3	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.583	\N	2022-07-01 22:05:01.583
4	100011070	3	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.593	\N	2022-07-01 22:05:01.593
4	100011070	4	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.593	\N	2022-07-01 22:05:01.593
4	100011070	5	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.593	\N	2022-07-01 22:05:01.593
4	100011070	6	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.594	\N	2022-07-01 22:05:01.594
4	100012000	1	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.594	\N	2022-07-01 22:05:01.594
4	100012000	2	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.594	\N	2022-07-01 22:05:01.594
4	100012000	3	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.595	\N	2022-07-01 22:05:01.595
4	100012000	4	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.595	\N	2022-07-01 22:05:01.595
430	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.239	\N	2022-07-01 22:05:12.239
4	100012000	7	0	4	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.596	\N	2022-07-01 22:05:01.596
4	100012010	1	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.597	\N	2022-07-01 22:05:01.597
4	100012010	2	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.597	\N	2022-07-01 22:05:01.597
4	100012010	3	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.598	\N	2022-07-01 22:05:01.598
4	100012010	4	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.598	\N	2022-07-01 22:05:01.598
4	100012010	5	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.598	\N	2022-07-01 22:05:01.598
4	100012010	6	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.599	\N	2022-07-01 22:05:01.599
4	100012020	1	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.599	\N	2022-07-01 22:05:01.599
4	100012020	2	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.599	\N	2022-07-01 22:05:01.599
4	100012020	3	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.599	\N	2022-07-01 22:05:01.599
4	100012020	4	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.6	\N	2022-07-01 22:05:01.6
4	100012020	5	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.6	\N	2022-07-01 22:05:01.6
4	100012020	6	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.6	\N	2022-07-01 22:05:01.6
4	100012030	1	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.601	\N	2022-07-01 22:05:01.601
4	100012030	2	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.601	\N	2022-07-01 22:05:01.601
4	100012030	3	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.601	\N	2022-07-01 22:05:01.601
4	100012030	5	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.602	\N	2022-07-01 22:05:01.602
4	100012030	6	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.602	\N	2022-07-01 22:05:01.602
4	100012040	1	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.603	\N	2022-07-01 22:05:01.603
4	100012040	2	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.603	\N	2022-07-01 22:05:01.603
4	100012040	3	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.603	\N	2022-07-01 22:05:01.603
4	100012040	4	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.604	\N	2022-07-01 22:05:01.604
4	100012040	5	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.604	\N	2022-07-01 22:05:01.604
4	100012040	6	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.604	\N	2022-07-01 22:05:01.604
4	100012050	1	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.605	\N	2022-07-01 22:05:01.605
4	100012050	2	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.605	\N	2022-07-01 22:05:01.605
4	100012050	3	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.605	\N	2022-07-01 22:05:01.605
4	100012050	4	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.606	\N	2022-07-01 22:05:01.606
4	100012050	5	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.606	\N	2022-07-01 22:05:01.606
4	100012050	6	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.606	\N	2022-07-01 22:05:01.606
4	100013000	1	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.607	\N	2022-07-01 22:05:01.607
4	100013000	2	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.607	\N	2022-07-01 22:05:01.607
4	100013000	3	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.607	\N	2022-07-01 22:05:01.607
4	100013000	4	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.607	\N	2022-07-01 22:05:01.607
4	100013000	5	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.608	\N	2022-07-01 22:05:01.608
4	100013000	6	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.608	\N	2022-07-01 22:05:01.608
4	100013000	7	0	4	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.608	\N	2022-07-01 22:05:01.608
4	100013000	8	0	4	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.609	\N	2022-07-01 22:05:01.609
4	100013000	9	0	4	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.609	\N	2022-07-01 22:05:01.609
4	100013010	1	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.609	\N	2022-07-01 22:05:01.609
4	100013010	3	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.61	\N	2022-07-01 22:05:01.61
4	100013010	4	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.61	\N	2022-07-01 22:05:01.61
4	100013010	5	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.611	\N	2022-07-01 22:05:01.611
4	100013010	6	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.611	\N	2022-07-01 22:05:01.611
4	100014000	1	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.611	\N	2022-07-01 22:05:01.611
4	100014000	2	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.612	\N	2022-07-01 22:05:01.612
4	100014000	3	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.612	\N	2022-07-01 22:05:01.612
4	100014000	4	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.612	\N	2022-07-01 22:05:01.612
4	100014000	5	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.613	\N	2022-07-01 22:05:01.613
4	100014000	6	0	4	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.613	\N	2022-07-01 22:05:01.613
4	100014000	7	0	4	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.614	\N	2022-07-01 22:05:01.614
4	100014000	8	0	4	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.614	\N	2022-07-01 22:05:01.614
4	100014000	9	0	4	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.614	\N	2022-07-01 22:05:01.614
4	100014140	1	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.615	\N	2022-07-01 22:05:01.615
4	100014140	2	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.615	\N	2022-07-01 22:05:01.615
4	100014140	3	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.615	\N	2022-07-01 22:05:01.615
4	100014140	4	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.616	\N	2022-07-01 22:05:01.616
4	100016010	3	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.625	\N	2022-07-01 22:05:01.625
4	100016010	4	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.626	\N	2022-07-01 22:05:01.626
4	100016010	5	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.626	\N	2022-07-01 22:05:01.626
4	100016010	6	0	4	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.626	\N	2022-07-01 22:05:01.626
4	109011000	1	0	4	1	1	0	0	*	\N	2017-01-31 01:00:00	2022-07-01 22:05:01.627	\N	2022-07-01 22:05:01.627
4	109011000	2	0	4	1	1	0	0	*	\N	2017-01-31 01:00:00	2022-07-01 22:05:01.627	\N	2022-07-01 22:05:01.627
4	109011000	3	0	4	1	1	0	0	*	\N	2017-01-31 01:00:00	2022-07-01 22:05:01.627	\N	2022-07-01 22:05:01.627
4	109011000	5	0	4	1	1	0	0	*	\N	2017-01-31 01:00:00	2022-07-01 22:05:01.628	\N	2022-07-01 22:05:01.628
4	109011000	6	0	4	1	1	0	0	*	\N	2017-01-31 01:00:00	2022-07-01 22:05:01.628	\N	2022-07-01 22:05:01.628
4	109011000	7	0	4	10	0	0	0	*	\N	2017-01-31 01:00:00	2022-07-01 22:05:01.629	\N	2022-07-01 22:05:01.629
4	109011000	8	0	4	10	0	0	0	*	\N	2017-01-31 01:00:00	2022-07-01 22:05:01.629	\N	2022-07-01 22:05:01.629
4	109011000	9	0	4	10	0	0	0	*	\N	2017-01-31 01:00:00	2022-07-01 22:05:01.629	\N	2022-07-01 22:05:01.629
4	109011010	1	0	4	10	0	0	0	*	\N	2017-01-31 01:00:00	2022-07-01 22:05:01.63	\N	2022-07-01 22:05:01.63
4	109011010	2	0	4	10	0	0	0	*	\N	2017-01-31 01:00:00	2022-07-01 22:05:01.63	\N	2022-07-01 22:05:01.63
4	109011010	3	0	4	10	0	0	0	*	\N	2017-01-31 01:00:00	2022-07-01 22:05:01.63	\N	2022-07-01 22:05:01.63
4	109011010	4	0	4	10	0	0	0	*	\N	2017-01-31 01:00:00	2022-07-01 22:05:01.631	\N	2022-07-01 22:05:01.631
4	109011010	5	0	4	10	0	0	0	*	\N	2017-01-31 01:00:00	2022-07-01 22:05:01.631	\N	2022-07-01 22:05:01.631
4	109011010	6	0	4	10	0	0	0	*	\N	2017-01-31 01:00:00	2022-07-01 22:05:01.631	\N	2022-07-01 22:05:01.631
4	200010000	1	0	5	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.632	\N	2022-07-01 22:05:01.632
430	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.239	\N	2022-07-01 22:05:12.239
4	200010000	4	0	6	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.633	\N	2022-07-01 22:05:01.633
4	200010000	5	0	6	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.633	\N	2022-07-01 22:05:01.633
4	200010000	6	0	6	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.633	\N	2022-07-01 22:05:01.633
4	200010000	7	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.634	\N	2022-07-01 22:05:01.634
4	200010000	8	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.634	\N	2022-07-01 22:05:01.634
4	200010000	9	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.634	\N	2022-07-01 22:05:01.634
4	200010200	4	0	0	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.634	\N	2022-07-01 22:05:01.634
4	200010200	5	0	0	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.635	\N	2022-07-01 22:05:01.635
4	200010200	6	0	0	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.635	\N	2022-07-01 22:05:01.635
4	300110000	1	0	8	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.635	\N	2022-07-01 22:05:01.635
4	300110000	2	0	8	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.636	\N	2022-07-01 22:05:01.636
4	300110000	3	0	8	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.636	\N	2022-07-01 22:05:01.636
4	300110000	4	0	8	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.636	\N	2022-07-01 22:05:01.636
4	300110000	5	0	8	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.637	\N	2022-07-01 22:05:01.637
4	300110000	6	0	8	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.637	\N	2022-07-01 22:05:01.637
4	300210000	1	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.637	\N	2022-07-01 22:05:01.637
4	300210000	3	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.638	\N	2022-07-01 22:05:01.638
4	300210000	4	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.638	\N	2022-07-01 22:05:01.638
4	300210000	5	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.639	\N	2022-07-01 22:05:01.639
4	300210000	6	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.639	\N	2022-07-01 22:05:01.639
4	300210000	7	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.639	\N	2022-07-01 22:05:01.639
4	300210000	8	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.64	\N	2022-07-01 22:05:01.64
4	300210000	9	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.64	\N	2022-07-01 22:05:01.64
4	300310100	1	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.64	\N	2022-07-01 22:05:01.64
4	300310100	2	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.641	\N	2022-07-01 22:05:01.641
4	300310100	3	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.641	\N	2022-07-01 22:05:01.641
4	300310100	4	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.641	\N	2022-07-01 22:05:01.641
4	300310100	5	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.642	\N	2022-07-01 22:05:01.642
4	300310100	6	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.642	\N	2022-07-01 22:05:01.642
4	300310100	7	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.642	\N	2022-07-01 22:05:01.642
4	300310100	8	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.643	\N	2022-07-01 22:05:01.643
4	300310100	9	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.643	\N	2022-07-01 22:05:01.643
4	300310400	1	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.643	\N	2022-07-01 22:05:01.643
4	300310400	2	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.644	\N	2022-07-01 22:05:01.644
4	300310400	3	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.644	\N	2022-07-01 22:05:01.644
4	300310400	4	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.644	\N	2022-07-01 22:05:01.644
4	300310400	5	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.644	\N	2022-07-01 22:05:01.644
4	300310400	6	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.645	\N	2022-07-01 22:05:01.645
4	300310400	7	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.645	\N	2022-07-01 22:05:01.645
4	300310400	8	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.645	\N	2022-07-01 22:05:01.645
4	300310500	1	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.646	\N	2022-07-01 22:05:01.646
4	300310500	2	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.646	\N	2022-07-01 22:05:01.646
4	300310500	3	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.647	\N	2022-07-01 22:05:01.647
4	300310500	4	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.647	\N	2022-07-01 22:05:01.647
4	300310500	5	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.647	\N	2022-07-01 22:05:01.647
4	300310500	6	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.648	\N	2022-07-01 22:05:01.648
4	300310500	7	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.648	\N	2022-07-01 22:05:01.648
4	300310500	8	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.648	\N	2022-07-01 22:05:01.648
4	300310800	9	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.655	\N	2022-07-01 22:05:01.655
4	300311900	1	0	2	2	2	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.655	\N	2022-07-01 22:05:01.655
4	300311900	2	0	2	2	2	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.655	\N	2022-07-01 22:05:01.655
4	300311900	3	0	2	2	2	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.656	\N	2022-07-01 22:05:01.656
4	300311900	4	0	2	2	2	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.656	\N	2022-07-01 22:05:01.656
4	300311900	5	0	2	2	2	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.656	\N	2022-07-01 22:05:01.656
4	300311900	6	0	2	2	2	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.657	\N	2022-07-01 22:05:01.657
4	300311900	7	0	2	2	2	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.657	\N	2022-07-01 22:05:01.657
4	300311900	8	0	2	2	2	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.657	\N	2022-07-01 22:05:01.657
4	300311900	9	0	2	2	2	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.658	\N	2022-07-01 22:05:01.658
4	300312900	1	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:01.658	\N	2022-07-01 22:05:01.658
4	300312900	2	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:01.658	\N	2022-07-01 22:05:01.658
4	300312900	3	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:01.659	\N	2022-07-01 22:05:01.659
4	300312900	4	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:01.659	\N	2022-07-01 22:05:01.659
4	300312900	5	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:01.659	\N	2022-07-01 22:05:01.659
4	300312900	6	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:01.66	\N	2022-07-01 22:05:01.66
4	300312900	8	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:01.66	\N	2022-07-01 22:05:01.66
4	300312900	9	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:01.661	\N	2022-07-01 22:05:01.661
4	400200000	1	0	24	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.661	\N	2022-07-01 22:05:01.661
4	400200000	2	0	24	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.661	\N	2022-07-01 22:05:01.661
4	400200000	3	0	24	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.662	\N	2022-07-01 22:05:01.662
4	400200000	4	0	24	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.662	\N	2022-07-01 22:05:01.662
4	400200000	5	0	24	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.662	\N	2022-07-01 22:05:01.662
4	400200000	6	0	24	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.663	\N	2022-07-01 22:05:01.663
4	400200000	7	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.663	\N	2022-07-01 22:05:01.663
4	400200000	8	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.663	\N	2022-07-01 22:05:01.663
4	400200000	9	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.664	\N	2022-07-01 22:05:01.664
4	401000000	1	0	5	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.664	\N	2022-07-01 22:05:01.664
430	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.24	\N	2022-07-01 22:05:12.24
4	401000000	4	0	6	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.665	\N	2022-07-01 22:05:01.665
4	401000000	5	0	6	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.665	\N	2022-07-01 22:05:01.665
4	401000000	6	0	6	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.666	\N	2022-07-01 22:05:01.666
4	401000000	7	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.666	\N	2022-07-01 22:05:01.666
4	401000000	8	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.666	\N	2022-07-01 22:05:01.666
4	401000000	9	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.667	\N	2022-07-01 22:05:01.667
4	401100000	1	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.667	\N	2022-07-01 22:05:01.667
4	401100000	2	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.667	\N	2022-07-01 22:05:01.667
4	401100000	3	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.668	\N	2022-07-01 22:05:01.668
4	401100000	4	0	0	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.668	\N	2022-07-01 22:05:01.668
4	401100000	5	0	0	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.668	\N	2022-07-01 22:05:01.668
4	401100000	6	0	0	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.669	\N	2022-07-01 22:05:01.669
4	401100000	7	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.669	\N	2022-07-01 22:05:01.669
4	401100000	8	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.669	\N	2022-07-01 22:05:01.669
4	401100000	9	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.67	\N	2022-07-01 22:05:01.67
4	401110200	1	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.67	\N	2022-07-01 22:05:01.67
4	401110200	3	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.671	\N	2022-07-01 22:05:01.671
4	401110200	4	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.671	\N	2022-07-01 22:05:01.671
4	401110200	5	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.671	\N	2022-07-01 22:05:01.671
4	401110200	6	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.672	\N	2022-07-01 22:05:01.672
4	401110200	7	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.672	\N	2022-07-01 22:05:01.672
4	401110200	8	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.672	\N	2022-07-01 22:05:01.672
4	401110200	9	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.672	\N	2022-07-01 22:05:01.672
4	401121000	1	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.673	\N	2022-07-01 22:05:01.673
4	401121000	2	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.673	\N	2022-07-01 22:05:01.673
4	401121000	3	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.673	\N	2022-07-01 22:05:01.673
4	401121000	4	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.674	\N	2022-07-01 22:05:01.674
4	401121000	5	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.674	\N	2022-07-01 22:05:01.674
4	401121000	6	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.674	\N	2022-07-01 22:05:01.674
4	401121000	7	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.675	\N	2022-07-01 22:05:01.675
4	401121000	8	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.675	\N	2022-07-01 22:05:01.675
4	401121000	9	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.675	\N	2022-07-01 22:05:01.675
4	401130000	1	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.676	\N	2022-07-01 22:05:01.676
4	401130000	2	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.676	\N	2022-07-01 22:05:01.676
4	401130000	3	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.676	\N	2022-07-01 22:05:01.676
4	401130000	4	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.677	\N	2022-07-01 22:05:01.677
4	401130000	5	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.677	\N	2022-07-01 22:05:01.677
4	401130000	6	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.677	\N	2022-07-01 22:05:01.677
4	401130000	7	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.678	\N	2022-07-01 22:05:01.678
4	401130000	8	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.678	\N	2022-07-01 22:05:01.678
4	401200000	1	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.679	\N	2022-07-01 22:05:01.679
4	401200000	2	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.679	\N	2022-07-01 22:05:01.679
4	401200000	3	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.679	\N	2022-07-01 22:05:01.679
4	401200000	4	0	0	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.68	\N	2022-07-01 22:05:01.68
4	401200000	5	0	0	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.68	\N	2022-07-01 22:05:01.68
4	401200000	6	0	0	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.68	\N	2022-07-01 22:05:01.68
4	401200000	7	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.681	\N	2022-07-01 22:05:01.681
4	401200000	8	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.681	\N	2022-07-01 22:05:01.681
4	401200000	9	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.681	\N	2022-07-01 22:05:01.681
4	401240000	3	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.688	\N	2022-07-01 22:05:01.688
4	401240000	4	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.688	\N	2022-07-01 22:05:01.688
4	401240000	5	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.689	\N	2022-07-01 22:05:01.689
4	401240000	6	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.689	\N	2022-07-01 22:05:01.689
4	401240000	7	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.689	\N	2022-07-01 22:05:01.689
4	401240000	8	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.69	\N	2022-07-01 22:05:01.69
4	401240000	9	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.69	\N	2022-07-01 22:05:01.69
4	401250100	1	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.69	\N	2022-07-01 22:05:01.69
4	401250100	2	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.691	\N	2022-07-01 22:05:01.691
4	401250100	3	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.691	\N	2022-07-01 22:05:01.691
4	401250100	4	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.691	\N	2022-07-01 22:05:01.691
4	401250100	5	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.692	\N	2022-07-01 22:05:01.692
4	401250100	6	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.692	\N	2022-07-01 22:05:01.692
4	401250100	7	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.692	\N	2022-07-01 22:05:01.692
4	401250100	8	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.692	\N	2022-07-01 22:05:01.692
4	401260000	1	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.693	\N	2022-07-01 22:05:01.693
4	401260000	2	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.694	\N	2022-07-01 22:05:01.694
4	401260000	3	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.694	\N	2022-07-01 22:05:01.694
4	401260000	4	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.694	\N	2022-07-01 22:05:01.694
4	401260000	5	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.695	\N	2022-07-01 22:05:01.695
4	401260000	6	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.695	\N	2022-07-01 22:05:01.695
4	401260000	7	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.695	\N	2022-07-01 22:05:01.695
4	401260000	8	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.696	\N	2022-07-01 22:05:01.696
4	401260000	9	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.696	\N	2022-07-01 22:05:01.696
4	500010000	1	0	4	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.696	\N	2022-07-01 22:05:01.696
4	500010000	2	0	4	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.697	\N	2022-07-01 22:05:01.697
4	500010000	3	0	4	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.697	\N	2022-07-01 22:05:01.697
431	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.24	\N	2022-07-01 22:05:12.24
4	500010000	6	0	4	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.698	\N	2022-07-01 22:05:01.698
4	500010000	7	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.698	\N	2022-07-01 22:05:01.698
4	500010000	8	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.699	\N	2022-07-01 22:05:01.699
4	500010000	9	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.699	\N	2022-07-01 22:05:01.699
4	500050000	1	0	0	9	9	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.699	\N	2022-07-01 22:05:01.699
4	500050000	2	0	0	9	9	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.7	\N	2022-07-01 22:05:01.7
4	500050000	3	0	0	9	9	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.7	\N	2022-07-01 22:05:01.7
4	500050000	4	0	0	9	9	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.7	\N	2022-07-01 22:05:01.7
4	500050000	5	0	0	9	9	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.701	\N	2022-07-01 22:05:01.701
4	500050000	6	0	0	9	9	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.701	\N	2022-07-01 22:05:01.701
4	500050000	7	0	0	9	9	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.701	\N	2022-07-01 22:05:01.701
4	500050000	8	0	0	9	9	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.701	\N	2022-07-01 22:05:01.701
4	500050000	9	0	0	9	9	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.702	\N	2022-07-01 22:05:01.702
4	600011000	1	0	2	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.702	\N	2022-07-01 22:05:01.702
4	600011000	2	0	2	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.702	\N	2022-07-01 22:05:01.702
4	600011000	3	0	2	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.703	\N	2022-07-01 22:05:01.703
4	600011000	5	0	3	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.703	\N	2022-07-01 22:05:01.703
4	600011000	6	0	3	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.704	\N	2022-07-01 22:05:01.704
4	600011000	7	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.704	\N	2022-07-01 22:05:01.704
4	600011000	8	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.704	\N	2022-07-01 22:05:01.704
4	600011000	9	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.705	\N	2022-07-01 22:05:01.705
4	600020000	1	0	0	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.705	\N	2022-07-01 22:05:01.705
4	600020000	2	0	0	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.705	\N	2022-07-01 22:05:01.705
4	600020000	3	0	0	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.706	\N	2022-07-01 22:05:01.706
4	600020000	4	0	0	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.706	\N	2022-07-01 22:05:01.706
4	600020000	5	0	0	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.706	\N	2022-07-01 22:05:01.706
4	600020000	6	0	0	10	0	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:01.707	\N	2022-07-01 22:05:01.707
4	600040000	1	0	2	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.707	\N	2022-07-01 22:05:01.707
4	600040000	2	0	2	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.707	\N	2022-07-01 22:05:01.707
4	600040000	3	0	2	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.708	\N	2022-07-01 22:05:01.708
4	600040000	4	0	3	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.708	\N	2022-07-01 22:05:01.708
4	600040000	5	0	3	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.708	\N	2022-07-01 22:05:01.708
4	600040000	6	0	3	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.709	\N	2022-07-01 22:05:01.709
4	600040000	7	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.709	\N	2022-07-01 22:05:01.709
4	600040000	8	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.709	\N	2022-07-01 22:05:01.709
4	600040000	9	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.71	\N	2022-07-01 22:05:01.71
4	801050100	1	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.71	\N	2022-07-01 22:05:01.71
4	801050100	2	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.71	\N	2022-07-01 22:05:01.71
4	801050100	3	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.71	\N	2022-07-01 22:05:01.71
4	801050100	4	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.711	\N	2022-07-01 22:05:01.711
4	801050100	6	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.711	\N	2022-07-01 22:05:01.711
4	801050100	7	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.712	\N	2022-07-01 22:05:01.712
4	801050100	8	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.712	\N	2022-07-01 22:05:01.712
4	801050100	9	0	0	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:01.712	\N	2022-07-01 22:05:01.712
431	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.24	\N	2022-07-01 22:05:12.24
431	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.24	\N	2022-07-01 22:05:12.24
431	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.241	\N	2022-07-01 22:05:12.241
431	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.241	\N	2022-07-01 22:05:12.241
431	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.241	\N	2022-07-01 22:05:12.241
431	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.241	\N	2022-07-01 22:05:12.241
431	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.242	\N	2022-07-01 22:05:12.242
431	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.242	\N	2022-07-01 22:05:12.242
431	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.242	\N	2022-07-01 22:05:12.242
431	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.242	\N	2022-07-01 22:05:12.242
431	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.243	\N	2022-07-01 22:05:12.243
431	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.243	\N	2022-07-01 22:05:12.243
431	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.243	\N	2022-07-01 22:05:12.243
431	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.243	\N	2022-07-01 22:05:12.243
431	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.243	\N	2022-07-01 22:05:12.243
431	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.244	\N	2022-07-01 22:05:12.244
431	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.244	\N	2022-07-01 22:05:12.244
431	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.245	\N	2022-07-01 22:05:12.245
431	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.246	\N	2022-07-01 22:05:12.246
431	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.246	\N	2022-07-01 22:05:12.246
431	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.246	\N	2022-07-01 22:05:12.246
431	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.246	\N	2022-07-01 22:05:12.246
8	100011070	7	0	3	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:03.637	\N	2022-07-01 22:05:03.637
8	100011070	8	0	3	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:03.637	\N	2022-07-01 22:05:03.637
8	100011070	9	0	3	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:03.637	\N	2022-07-01 22:05:03.637
8	300312900	8	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:04.155	\N	2022-07-01 22:05:04.155
8	100012050	7	0	3	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:04.107	\N	2022-07-01 22:05:04.107
8	100015010	7	0	3	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:04.12	\N	2022-07-01 22:05:04.12
8	100015010	8	0	3	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:04.12	\N	2022-07-01 22:05:04.12
8	100015010	9	0	3	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:04.121	\N	2022-07-01 22:05:04.121
8	100016010	7	0	3	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:04.124	\N	2022-07-01 22:05:04.124
8	100016010	8	0	3	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:04.124	\N	2022-07-01 22:05:04.124
8	100016010	9	0	3	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:04.125	\N	2022-07-01 22:05:04.125
8	109011010	7	0	3	1	1	0	0	*	\N	2017-01-31 01:00:00	2022-07-01 22:05:04.128	\N	2022-07-01 22:05:04.128
8	109011010	8	0	3	1	1	0	0	*	\N	2017-01-31 01:00:00	2022-07-01 22:05:04.129	\N	2022-07-01 22:05:04.129
8	109011010	9	0	3	1	1	0	0	*	\N	2017-01-31 01:00:00	2022-07-01 22:05:04.129	\N	2022-07-01 22:05:04.129
8	200010000	7	0	3	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:04.131	\N	2022-07-01 22:05:04.131
8	200010000	8	0	3	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:04.132	\N	2022-07-01 22:05:04.132
8	200010000	9	0	3	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:04.132	\N	2022-07-01 22:05:04.132
8	300110000	7	0	6	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:04.132	\N	2022-07-01 22:05:04.132
8	300110000	8	0	6	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:04.133	\N	2022-07-01 22:05:04.133
8	300110000	9	0	6	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:04.133	\N	2022-07-01 22:05:04.133
8	300210000	7	0	4	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:04.135	\N	2022-07-01 22:05:04.135
8	300210000	8	0	4	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:04.136	\N	2022-07-01 22:05:04.136
8	300210000	9	0	4	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:04.136	\N	2022-07-01 22:05:04.136
431	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.247	\N	2022-07-01 22:05:12.247
8	300311900	7	0	2	2	2	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:04.154	\N	2022-07-01 22:05:04.154
8	300311900	8	0	2	2	2	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:04.154	\N	2022-07-01 22:05:04.154
8	300311900	9	0	2	2	2	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:04.154	\N	2022-07-01 22:05:04.154
8	300312900	7	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:04.155	\N	2022-07-01 22:05:04.155
8	300312900	9	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:04.155	\N	2022-07-01 22:05:04.155
8	401000000	7	0	5	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:04.161	\N	2022-07-01 22:05:04.161
8	401000000	8	0	5	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:04.161	\N	2022-07-01 22:05:04.161
8	401000000	9	0	5	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:04.161	\N	2022-07-01 22:05:04.161
8	401100000	7	0	5	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:04.164	\N	2022-07-01 22:05:04.164
8	401100000	8	0	5	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:04.164	\N	2022-07-01 22:05:04.164
8	401100000	9	0	5	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:04.165	\N	2022-07-01 22:05:04.165
431	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.247	\N	2022-07-01 22:05:12.247
8	500010000	7	0	3	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:04.195	\N	2022-07-01 22:05:04.195
8	500010000	8	0	3	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:04.195	\N	2022-07-01 22:05:04.195
8	500010000	9	0	3	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:04.196	\N	2022-07-01 22:05:04.196
8	500050000	7	0	0	9	9	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:04.198	\N	2022-07-01 22:05:04.198
8	500050000	8	0	0	9	9	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:04.199	\N	2022-07-01 22:05:04.199
8	500050000	9	0	0	9	9	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:04.199	\N	2022-07-01 22:05:04.199
8	600011000	7	0	3	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:04.201	\N	2022-07-01 22:05:04.201
8	600011000	8	0	3	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:04.202	\N	2022-07-01 22:05:04.202
8	600011000	9	0	3	1	1	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:04.202	\N	2022-07-01 22:05:04.202
8	600070000	7	0	2	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:04.207	\N	2022-07-01 22:05:04.207
8	600070000	8	0	2	1	1	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:04.207	\N	2022-07-01 22:05:04.207
8	700106100	7	0	2	1	1	0	0	*	\N	2019-08-13 16:00:00	2022-07-01 22:05:04.208	\N	2022-07-01 22:05:04.208
8	700106100	8	0	2	1	1	0	0	*	\N	2019-08-13 16:00:00	2022-07-01 22:05:04.208	\N	2022-07-01 22:05:04.208
8	700106100	9	0	2	1	1	0	0	*	\N	2019-08-13 16:00:00	2022-07-01 22:05:04.208	\N	2022-07-01 22:05:04.208
8	802000300	7	0	0	9	9	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:04.215	\N	2022-07-01 22:05:04.215
8	802000300	8	0	0	9	9	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:04.215	\N	2022-07-01 22:05:04.215
8	802000300	9	0	0	9	9	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:04.216	\N	2022-07-01 22:05:04.216
21	500050000	12	0	0	9	9	0	0	*	\N	2016-03-22 01:00:00	2022-07-01 22:05:07.577	\N	2022-07-01 22:05:07.577
8	850010100	7	0	2	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:04.219	\N	2022-07-01 22:05:04.219
8	850010100	8	0	2	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:04.219	\N	2022-07-01 22:05:04.219
8	850010100	9	0	2	10	0	0	0	*	\N	2016-07-22 00:00:00	2022-07-01 22:05:04.22	\N	2022-07-01 22:05:04.22
431	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.247	\N	2022-07-01 22:05:12.247
10761	800000281	12	0	4	11	0	0	0	P	\N	2024-07-10 17:30:00	2024-07-17 00:00:00	\N	1901-01-01 00:00:00
431	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.248	\N	2022-07-01 22:05:12.248
431	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.25	\N	2022-07-01 22:05:12.25
10774	800000281	12	0	4	11	0	0	0	P	\N	2024-07-10 17:30:00	2024-07-17 00:00:00	\N	1901-01-01 00:00:00
431	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.248	\N	2022-07-01 22:05:12.248
10792	800000281	12	0	4	11	0	0	0	P	\N	2024-07-10 17:30:00	2024-07-17 00:00:00	\N	1901-01-01 00:00:00
431	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.248	\N	2022-07-01 22:05:12.248
431	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.248	\N	2022-07-01 22:05:12.248
431	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.248	\N	2022-07-01 22:05:12.248
10817	800000281	12	0	4	11	0	0	0	P	\N	2024-07-10 17:30:00	2024-07-17 00:00:00	\N	1901-01-01 00:00:00
431	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.249	\N	2022-07-01 22:05:12.249
431	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.249	\N	2022-07-01 22:05:12.249
431	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.249	\N	2022-07-01 22:05:12.249
431	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.25	\N	2022-07-01 22:05:12.25
431	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:12.25	\N	2022-07-01 22:05:12.25
431	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:12.25	\N	2022-07-01 22:05:12.25
431	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.251	\N	2022-07-01 22:05:12.251
431	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.251	\N	2022-07-01 22:05:12.251
431	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.251	\N	2022-07-01 22:05:12.251
431	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.252	\N	2022-07-01 22:05:12.252
431	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.252	\N	2022-07-01 22:05:12.252
431	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.253	\N	2022-07-01 22:05:12.253
431	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.253	\N	2022-07-01 22:05:12.253
431	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.253	\N	2022-07-01 22:05:12.253
431	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.253	\N	2022-07-01 22:05:12.253
10849	800000281	12	0	4	11	0	0	0	P	\N	2024-07-10 17:30:00	2024-07-17 00:00:00	\N	1901-01-01 00:00:00
431	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.254	\N	2022-07-01 22:05:12.254
431	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.254	\N	2022-07-01 22:05:12.254
21	100011070	10	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.23	\N	2022-07-01 22:05:07.23
21	100011070	11	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.232	\N	2022-07-01 22:05:07.232
21	100011070	12	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.235	\N	2022-07-01 22:05:07.235
21	850010100	11	0	2	2	2	0	0	*	\N	2016-03-22 01:00:00	2022-07-01 22:05:07.618	\N	2022-07-01 22:05:07.618
21	100012050	10	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.275	\N	2022-07-01 22:05:07.275
21	100012050	11	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.277	\N	2022-07-01 22:05:07.277
21	100013010	10	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.29	\N	2022-07-01 22:05:07.29
21	100013010	11	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.292	\N	2022-07-01 22:05:07.292
21	100013010	12	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.294	\N	2022-07-01 22:05:07.294
21	100014140	10	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.304	\N	2022-07-01 22:05:07.304
21	100014140	11	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.307	\N	2022-07-01 22:05:07.307
21	100014140	12	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.31	\N	2022-07-01 22:05:07.31
21	100015010	10	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.319	\N	2022-07-01 22:05:07.319
21	100015010	11	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.322	\N	2022-07-01 22:05:07.322
21	100015010	12	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.324	\N	2022-07-01 22:05:07.324
21	100016010	10	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.334	\N	2022-07-01 22:05:07.334
21	100016010	11	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.336	\N	2022-07-01 22:05:07.336
21	100016010	12	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.339	\N	2022-07-01 22:05:07.339
21	109011010	10	0	3	3	3	0	0	*	\N	2017-01-31 01:00:00	2022-07-01 22:05:07.349	\N	2022-07-01 22:05:07.349
21	109011010	11	0	3	3	3	0	0	*	\N	2017-01-31 01:00:00	2022-07-01 22:05:07.351	\N	2022-07-01 22:05:07.351
21	109011010	12	0	3	3	3	0	0	*	\N	2017-01-31 01:00:00	2022-07-01 22:05:07.353	\N	2022-07-01 22:05:07.353
21	300110000	11	0	4	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.38	\N	2022-07-01 22:05:07.38
21	300110000	12	0	4	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.383	\N	2022-07-01 22:05:07.383
21	300210000	10	0	2	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.392	\N	2022-07-01 22:05:07.392
21	300210000	11	0	2	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.395	\N	2022-07-01 22:05:07.395
21	300210000	12	0	2	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.397	\N	2022-07-01 22:05:07.397
431	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.254	\N	2022-07-01 22:05:12.254
21	300310900	10	0	3	10	0	0	5	*	\N	2016-03-10 23:30:00	2022-07-01 22:05:07.464	\N	2022-07-01 22:05:07.464
21	300310900	11	0	4	10	0	0	5	*	\N	2016-03-10 23:30:00	2022-07-01 22:05:07.467	\N	2022-07-01 22:05:07.467
21	300310900	12	0	4	10	0	0	5	*	\N	2016-03-10 23:30:00	2022-07-01 22:05:07.469	\N	2022-07-01 22:05:07.469
21	300311900	10	0	2	2	2	0	0	*	\N	2016-03-10 23:30:00	2022-07-01 22:05:07.471	\N	2022-07-01 22:05:07.471
21	300311900	11	0	2	2	2	0	0	*	\N	2016-03-10 23:30:00	2022-07-01 22:05:07.474	\N	2022-07-01 22:05:07.474
21	300311900	12	0	2	2	2	0	0	*	\N	2016-03-10 23:30:00	2022-07-01 22:05:07.476	\N	2022-07-01 22:05:07.476
21	300312900	10	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:07.478	\N	2022-07-01 22:05:07.478
21	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:07.481	\N	2022-07-01 22:05:07.481
21	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:07.483	\N	2022-07-01 22:05:07.483
21	401000000	10	0	4	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.485	\N	2022-07-01 22:05:07.485
21	401000000	11	0	4	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.488	\N	2022-07-01 22:05:07.488
10862	800000281	12	0	4	11	0	0	0	P	\N	2024-07-10 17:30:00	2024-07-17 00:00:00	\N	1901-01-01 00:00:00
21	401000000	12	0	4	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.491	\N	2022-07-01 22:05:07.491
21	500010000	10	0	3	4	4	0	0	*	\N	2014-10-18 18:00:00	2022-07-01 22:05:07.566	\N	2022-07-01 22:05:07.566
21	500010000	11	0	3	4	4	0	0	*	\N	2014-10-18 18:00:00	2022-07-01 22:05:07.568	\N	2022-07-01 22:05:07.568
21	500010000	12	0	3	4	4	0	0	*	\N	2014-10-18 18:00:00	2022-07-01 22:05:07.57	\N	2022-07-01 22:05:07.57
21	500050000	10	0	0	9	9	0	0	*	\N	2016-03-22 01:00:00	2022-07-01 22:05:07.573	\N	2022-07-01 22:05:07.573
21	500050000	11	0	0	9	9	0	0	*	\N	2016-03-22 01:00:00	2022-07-01 22:05:07.575	\N	2022-07-01 22:05:07.575
21	600060000	10	0	2	4	4	0	0	*	\N	2014-10-18 18:00:00	2022-07-01 22:05:07.58	\N	2022-07-01 22:05:07.58
21	600060000	11	0	2	4	4	0	0	*	\N	2014-10-18 18:00:00	2022-07-01 22:05:07.582	\N	2022-07-01 22:05:07.582
21	600060000	12	0	2	4	4	0	0	*	\N	2014-10-18 18:00:00	2022-07-01 22:05:07.584	\N	2022-07-01 22:05:07.584
21	700106100	10	0	3	5	5	0	0	*	\N	2019-08-13 16:00:00	2022-07-01 22:05:07.587	\N	2022-07-01 22:05:07.587
21	700106100	11	0	4	5	5	0	0	*	\N	2019-08-13 16:00:00	2022-07-01 22:05:07.589	\N	2022-07-01 22:05:07.589
21	700106100	12	0	4	5	5	0	0	*	\N	2019-08-13 16:00:00	2022-07-01 22:05:07.592	\N	2022-07-01 22:05:07.592
21	802000300	10	0	0	9	9	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.594	\N	2022-07-01 22:05:07.594
21	802000300	11	0	0	9	9	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.602	\N	2022-07-01 22:05:07.602
21	802000300	12	0	0	9	9	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.604	\N	2022-07-01 22:05:07.604
21	843020100	10	0	2	4	4	0	0	*	\N	2014-10-18 18:00:00	2022-07-01 22:05:07.607	\N	2022-07-01 22:05:07.607
21	843020100	11	0	2	4	4	0	0	*	\N	2014-10-18 18:00:00	2022-07-01 22:05:07.609	\N	2022-07-01 22:05:07.609
21	843020100	12	0	2	4	4	0	0	*	\N	2014-10-18 18:00:00	2022-07-01 22:05:07.613	\N	2022-07-01 22:05:07.613
21	850010100	10	0	2	2	2	0	0	*	\N	2016-03-22 01:00:00	2022-07-01 22:05:07.615	\N	2022-07-01 22:05:07.615
21	200010000	12	0	2	3	3	0	0	*	\N	2014-02-14 00:00:00	2023-07-12 00:00:00	\N	2014-10-17 21:37:51.253
21	850010100	12	0	2	2	2	0	0	*	\N	2016-03-22 01:00:00	2022-07-01 22:05:07.62	\N	2022-07-01 22:05:07.62
21	850030100	11	0	2	2	2	0	0	*	\N	2016-03-22 01:00:00	2022-07-01 22:05:07.625	\N	2022-07-01 22:05:07.625
21	850030100	12	0	2	2	2	0	0	*	\N	2016-03-22 01:00:00	2022-07-01 22:05:07.627	\N	2022-07-01 22:05:07.627
22	100011070	10	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.681	\N	2022-07-01 22:05:07.681
22	100011070	11	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.683	\N	2022-07-01 22:05:07.683
22	100011070	12	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.686	\N	2022-07-01 22:05:07.686
10752	800000282	12	0	4	11	0	0	0	P	\N	2024-07-10 17:30:00	2024-07-17 00:00:00	\N	1901-01-01 00:00:00
21	300120000	11	0	4	5	0	0	5	*	\N	2014-02-14 00:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
21	300310700	10	0	3	5	0	0	5	*	\N	2014-02-14 00:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
21	300310700	11	0	4	5	0	0	5	*	\N	2014-02-14 00:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
21	300310800	10	0	3	5	0	0	5	*	\N	2014-02-14 00:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
21	300310800	12	0	4	5	0	0	5	*	\N	2014-02-14 00:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
21	401001000	11	0	4	10	0	0	5	*	\N	2016-03-22 01:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
21	401001000	12	0	4	10	0	0	5	*	\N	2016-03-22 01:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
22	100012050	10	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.724	\N	2022-07-01 22:05:07.724
22	100012050	11	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.727	\N	2022-07-01 22:05:07.727
22	100012050	12	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.729	\N	2022-07-01 22:05:07.729
22	100013010	10	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.518	\N	2022-07-01 22:05:07.518
22	100013010	11	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.518	\N	2022-07-01 22:05:07.518
22	100013010	12	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.519	\N	2022-07-01 22:05:07.519
22	100014140	10	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.52	\N	2022-07-01 22:05:07.52
22	100014140	11	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.521	\N	2022-07-01 22:05:07.521
22	100014140	12	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.521	\N	2022-07-01 22:05:07.521
1062	200010000	10	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
22	100015010	10	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.522	\N	2022-07-01 22:05:07.522
22	300310900	10	0	3	10	0	0	5	*	\N	2016-03-22 01:00:00	2022-07-01 22:05:07.542	\N	2022-07-01 22:05:07.542
22	300310900	11	0	4	10	0	0	5	*	\N	2016-03-22 01:00:00	2022-07-01 22:05:07.542	\N	2022-07-01 22:05:07.542
22	300310900	12	0	4	10	0	0	5	*	\N	2016-03-22 01:00:00	2022-07-01 22:05:07.542	\N	2022-07-01 22:05:07.542
22	300311900	10	0	2	2	2	0	0	*	\N	2016-03-10 23:30:00	2022-07-01 22:05:07.543	\N	2022-07-01 22:05:07.543
22	300311900	11	0	2	2	2	0	0	*	\N	2016-03-10 23:30:00	2022-07-01 22:05:07.543	\N	2022-07-01 22:05:07.543
22	300311900	12	0	2	2	2	0	0	*	\N	2016-03-10 23:30:00	2022-07-01 22:05:07.543	\N	2022-07-01 22:05:07.543
22	300312900	10	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:07.544	\N	2022-07-01 22:05:07.544
22	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:07.544	\N	2022-07-01 22:05:07.544
22	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:07.544	\N	2022-07-01 22:05:07.544
22	401000000	10	0	4	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.545	\N	2022-07-01 22:05:07.545
22	401000000	11	0	4	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.545	\N	2022-07-01 22:05:07.545
22	401000000	12	0	4	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.545	\N	2022-07-01 22:05:07.545
22	401231000	11	0	2	3	3	0	0	*	\N	2014-10-18 18:00:00	2022-07-01 22:05:07.552	\N	2022-07-01 22:05:07.552
22	401231000	12	0	2	3	3	0	0	*	\N	2014-10-18 18:00:00	2022-07-01 22:05:07.552	\N	2022-07-01 22:05:07.552
22	850030100	12	0	2	2	2	0	0	*	\N	2016-03-22 01:00:00	2022-07-01 22:05:07.565	\N	2022-07-01 22:05:07.565
10777	800000282	12	0	4	11	0	0	0	P	\N	2024-07-10 17:30:00	2024-07-17 00:00:00	\N	1901-01-01 00:00:00
22	300310200	12	0	4	10	0	0	5	*	\N	2016-03-22 01:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
23	100011070	10	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.573	\N	2022-07-01 22:05:07.573
23	100011070	11	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.573	\N	2022-07-01 22:05:07.573
23	100011070	12	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.573	\N	2022-07-01 22:05:07.573
23	401231000	10	0	2	3	3	0	0	*	\N	2014-10-18 18:00:00	2022-07-01 22:05:07.615	\N	2022-07-01 22:05:07.615
23	100012050	10	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.579	\N	2022-07-01 22:05:07.579
23	100012050	11	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.579	\N	2022-07-01 22:05:07.579
23	100012050	12	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.58	\N	2022-07-01 22:05:07.58
23	100013010	10	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.581	\N	2022-07-01 22:05:07.581
23	100013010	11	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.581	\N	2022-07-01 22:05:07.581
23	100013010	12	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.582	\N	2022-07-01 22:05:07.582
23	100014140	10	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.583	\N	2022-07-01 22:05:07.583
23	100014140	11	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.583	\N	2022-07-01 22:05:07.583
23	100014140	12	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.584	\N	2022-07-01 22:05:07.584
23	100015010	10	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.585	\N	2022-07-01 22:05:07.585
23	100015010	11	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.585	\N	2022-07-01 22:05:07.585
23	100015010	12	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.586	\N	2022-07-01 22:05:07.586
23	100016010	10	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.587	\N	2022-07-01 22:05:07.587
23	100016010	11	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.587	\N	2022-07-01 22:05:07.587
23	100016010	12	0	3	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.588	\N	2022-07-01 22:05:07.588
23	109011010	10	0	3	3	3	0	0	*	\N	2017-01-31 01:00:00	2022-07-01 22:05:07.589	\N	2022-07-01 22:05:07.589
23	109011010	11	0	3	3	3	0	0	*	\N	2017-01-31 01:00:00	2022-07-01 22:05:07.59	\N	2022-07-01 22:05:07.59
23	300110000	12	0	4	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.593	\N	2022-07-01 22:05:07.593
23	300210000	10	0	2	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.594	\N	2022-07-01 22:05:07.594
23	300210000	11	0	2	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.595	\N	2022-07-01 22:05:07.595
10802	800000282	12	0	4	11	0	0	0	P	\N	2024-07-10 17:30:00	2024-07-17 00:00:00	\N	1901-01-01 00:00:00
22	300310600	10	0	3	10	0	0	5	*	\N	2016-03-22 01:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
22	300310600	11	0	4	10	0	0	5	*	\N	2016-03-22 01:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
22	300310600	12	0	4	10	0	0	5	*	\N	2016-03-22 01:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
22	300310700	10	0	3	10	0	0	5	*	\N	2016-03-22 01:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
22	300310700	11	0	4	10	0	0	5	*	\N	2016-03-22 01:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
22	300310700	12	0	4	10	0	0	5	*	\N	2016-03-22 01:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
22	300310800	10	0	3	10	0	0	5	*	\N	2016-03-22 01:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
22	300310800	11	0	4	10	0	0	5	*	\N	2016-03-22 01:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
22	401001000	12	0	4	10	0	0	5	*	\N	2016-03-22 01:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
23	300210000	12	0	2	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.595	\N	2022-07-01 22:05:07.595
23	300310900	10	0	3	10	0	0	5	*	\N	2016-03-22 01:00:00	2022-07-01 22:05:07.604	\N	2022-07-01 22:05:07.604
23	300310900	11	0	4	10	0	0	5	*	\N	2016-03-22 01:00:00	2022-07-01 22:05:07.605	\N	2022-07-01 22:05:07.605
23	300310900	12	0	4	10	0	0	5	*	\N	2016-03-22 01:00:00	2022-07-01 22:05:07.605	\N	2022-07-01 22:05:07.605
23	300311900	10	0	2	2	2	0	0	*	\N	2016-03-10 23:30:00	2022-07-01 22:05:07.605	\N	2022-07-01 22:05:07.605
23	300311900	11	0	2	2	2	0	0	*	\N	2016-03-10 23:30:00	2022-07-01 22:05:07.606	\N	2022-07-01 22:05:07.606
23	300311900	12	0	2	2	2	0	0	*	\N	2016-03-10 23:30:00	2022-07-01 22:05:07.606	\N	2022-07-01 22:05:07.606
23	300312900	10	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:07.606	\N	2022-07-01 22:05:07.606
23	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:07.607	\N	2022-07-01 22:05:07.607
23	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:07.607	\N	2022-07-01 22:05:07.607
23	401000000	10	0	4	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.607	\N	2022-07-01 22:05:07.607
23	401000000	11	0	4	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.608	\N	2022-07-01 22:05:07.608
23	401000000	12	0	4	3	3	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.608	\N	2022-07-01 22:05:07.608
23	401231000	11	0	2	3	3	0	0	*	\N	2014-10-18 18:00:00	2022-07-01 22:05:07.616	\N	2022-07-01 22:05:07.616
23	401231000	12	0	2	3	3	0	0	*	\N	2014-10-18 18:00:00	2022-07-01 22:05:07.616	\N	2022-07-01 22:05:07.616
23	500010000	10	0	3	4	4	0	0	*	\N	2014-10-18 18:00:00	2022-07-01 22:05:07.62	\N	2022-07-01 22:05:07.62
23	500010000	11	0	3	4	4	0	0	*	\N	2014-10-18 18:00:00	2022-07-01 22:05:07.62	\N	2022-07-01 22:05:07.62
23	500010000	12	0	3	4	4	0	0	*	\N	2014-10-18 18:00:00	2022-07-01 22:05:07.621	\N	2022-07-01 22:05:07.621
23	500050000	10	0	0	9	9	0	0	*	\N	2016-03-22 01:00:00	2022-07-01 22:05:07.621	\N	2022-07-01 22:05:07.621
23	500050000	11	0	0	9	9	0	0	*	\N	2016-03-22 01:00:00	2022-07-01 22:05:07.621	\N	2022-07-01 22:05:07.621
23	500050000	12	0	0	9	9	0	0	*	\N	2016-03-22 01:00:00	2022-07-01 22:05:07.622	\N	2022-07-01 22:05:07.622
23	600060000	10	0	2	4	4	0	0	*	\N	2014-10-18 18:00:00	2022-07-01 22:05:07.622	\N	2022-07-01 22:05:07.622
23	600060000	11	0	2	4	4	0	0	*	\N	2014-10-18 18:00:00	2022-07-01 22:05:07.623	\N	2022-07-01 22:05:07.623
23	600060000	12	0	2	4	4	0	0	*	\N	2014-10-18 18:00:00	2022-07-01 22:05:07.623	\N	2022-07-01 22:05:07.623
23	700106100	10	0	3	5	5	0	0	*	\N	2019-08-13 16:00:00	2022-07-01 22:05:07.623	\N	2022-07-01 22:05:07.623
23	700106100	11	0	4	5	5	0	0	*	\N	2019-08-13 16:00:00	2022-07-01 22:05:07.624	\N	2022-07-01 22:05:07.624
23	700106100	12	0	4	5	5	0	0	*	\N	2019-08-13 16:00:00	2022-07-01 22:05:07.624	\N	2022-07-01 22:05:07.624
23	802000300	10	0	0	9	9	0	0	*	\N	2014-02-14 00:00:00	2022-07-01 22:05:07.624	\N	2022-07-01 22:05:07.624
23	850030100	12	0	2	2	2	0	0	*	\N	2016-03-22 01:00:00	2022-07-01 22:05:07.628	\N	2022-07-01 22:05:07.628
1054	200010000	10	0	2	1	1	0	0	*	\N	2018-08-14 06:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
10815	800000282	12	0	4	11	0	0	0	P	\N	2024-07-10 17:30:00	2024-07-17 00:00:00	\N	1901-01-01 00:00:00
23	300220000	10	0	3	10	0	0	5	*	\N	2016-03-22 01:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
1056	200010000	10	0	2	1	1	0	0	*	\N	2018-08-14 06:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
10838	800000282	12	0	4	11	0	0	0	P	\N	2024-07-10 17:30:00	2024-07-17 00:00:00	\N	1901-01-01 00:00:00
23	401001000	11	0	4	5	0	0	5	*	\N	2015-04-27 23:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
44	401100000	6	0	3	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.108	\N	2022-07-01 22:05:08.108
1057	200010000	10	0	2	1	1	0	0	*	\N	2018-08-14 06:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
1058	200010000	10	0	2	1	1	0	0	*	\N	2018-08-14 06:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
31	100013070	10	0	4	10	0	0	5	*	\N	2017-03-17 12:00:00	2022-07-01 22:05:07.704	\N	2022-07-01 22:05:07.704
31	100013070	11	0	4	10	0	0	5	*	\N	2017-03-17 12:00:00	2022-07-01 22:05:07.705	\N	2022-07-01 22:05:07.705
31	100013070	12	0	4	10	0	0	5	*	\N	2017-03-17 12:00:00	2022-07-01 22:05:07.705	\N	2022-07-01 22:05:07.705
31	100013080	10	0	4	10	0	0	5	*	\N	2017-03-17 12:00:00	2022-07-01 22:05:07.705	\N	2022-07-01 22:05:07.705
31	100013080	11	0	4	10	0	0	5	*	\N	2017-03-17 12:00:00	2022-07-01 22:05:07.706	\N	2022-07-01 22:05:07.706
31	100013080	12	0	4	10	0	0	5	*	\N	2017-03-17 12:00:00	2022-07-01 22:05:07.706	\N	2022-07-01 22:05:07.706
31	100013090	11	0	4	10	0	0	5	*	\N	2017-03-17 12:00:00	2022-07-01 22:05:07.707	\N	2022-07-01 22:05:07.707
31	100013090	12	0	4	10	0	0	5	*	\N	2017-03-17 12:00:00	2022-07-01 22:05:07.707	\N	2022-07-01 22:05:07.707
31	300110000	10	0	4	3	3	0	0	*	\N	2017-03-17 12:00:00	2022-07-01 22:05:07.708	\N	2022-07-01 22:05:07.708
31	300110000	11	0	4	3	3	0	0	*	\N	2017-03-17 12:00:00	2022-07-01 22:05:07.709	\N	2022-07-01 22:05:07.709
31	300110000	12	0	4	3	3	0	0	*	\N	2017-03-17 12:00:00	2022-07-01 22:05:07.709	\N	2022-07-01 22:05:07.709
10865	800000282	12	0	4	11	0	0	0	P	\N	2024-07-10 17:30:00	2024-07-17 00:00:00	\N	1901-01-01 00:00:00
31	300210000	10	0	4	3	3	0	0	*	\N	2017-03-17 12:00:00	2022-07-01 22:05:07.709	\N	2022-07-01 22:05:07.709
31	300210000	11	0	4	3	3	0	0	*	\N	2017-03-17 12:00:00	2022-07-01 22:05:07.71	\N	2022-07-01 22:05:07.71
31	300210000	12	0	4	3	3	0	0	*	\N	2017-03-17 12:00:00	2022-07-01 22:05:07.71	\N	2022-07-01 22:05:07.71
31	401000000	10	0	4	3	3	0	0	*	\N	2017-03-17 12:00:00	2022-07-01 22:05:07.71	\N	2022-07-01 22:05:07.71
31	401000000	11	0	4	3	3	0	0	*	\N	2017-03-17 12:00:00	2022-07-01 22:05:07.711	\N	2022-07-01 22:05:07.711
31	401000000	12	0	4	3	3	0	0	*	\N	2017-03-17 12:00:00	2022-07-01 22:05:07.711	\N	2022-07-01 22:05:07.711
31	401231000	10	0	2	3	3	0	0	*	\N	2017-03-17 12:00:00	2022-07-01 22:05:08.662	\N	2022-07-01 22:05:08.662
34	401230000	11	0	4	10	0	0	5	*	\N	2017-03-17 12:00:00	2022-07-01 22:05:08.962	\N	2022-07-01 22:05:08.962
34	401230000	12	0	4	10	0	0	5	*	\N	2017-03-17 12:00:00	2022-07-01 22:05:08.964	\N	2022-07-01 22:05:08.964
34	401240000	10	0	3	10	0	0	5	*	\N	2017-03-17 12:00:00	2022-07-01 22:05:08.967	\N	2022-07-01 22:05:08.967
34	401240000	11	0	4	10	0	0	5	*	\N	2017-03-17 12:00:00	2022-07-01 22:05:08.969	\N	2022-07-01 22:05:08.969
34	401240000	12	0	4	10	0	0	5	*	\N	2017-03-17 12:00:00	2022-07-01 22:05:08.972	\N	2022-07-01 22:05:08.972
34	401250100	10	0	3	10	0	0	5	*	\N	2017-03-17 12:00:00	2022-07-01 22:05:08.974	\N	2022-07-01 22:05:08.974
34	401250100	11	0	4	10	0	0	5	*	\N	2017-03-17 12:00:00	2022-07-01 22:05:08.977	\N	2022-07-01 22:05:08.977
34	401250100	12	0	4	10	0	0	5	*	\N	2017-03-17 12:00:00	2022-07-01 22:05:08.979	\N	2022-07-01 22:05:08.979
34	500010000	10	0	2	4	4	0	0	*	\N	2017-03-17 12:00:00	2022-07-01 22:05:08.981	\N	2022-07-01 22:05:08.981
34	500010000	11	0	2	4	4	0	0	*	\N	2017-03-17 12:00:00	2022-07-01 22:05:08.984	\N	2022-07-01 22:05:08.984
34	500010000	12	0	2	4	4	0	0	*	\N	2017-03-17 12:00:00	2022-07-01 22:05:08.986	\N	2022-07-01 22:05:08.986
34	600010000	10	0	2	4	4	0	0	*	\N	2017-03-17 12:00:00	2022-07-01 22:05:08.988	\N	2022-07-01 22:05:08.988
34	600010000	11	0	2	4	4	0	0	*	\N	2017-03-17 12:00:00	2022-07-01 22:05:08.991	\N	2022-07-01 22:05:08.991
34	600010000	12	0	2	4	4	0	0	*	\N	2017-03-17 12:00:00	2022-07-01 22:05:08.993	\N	2022-07-01 22:05:08.993
34	600060000	11	0	2	4	4	0	0	*	\N	2017-03-17 12:00:00	2022-07-01 22:05:08.998	\N	2022-07-01 22:05:08.998
34	600060000	12	0	2	4	4	0	0	*	\N	2017-03-17 12:00:00	2022-07-01 22:05:08.1	\N	2022-07-01 22:05:08.1
44	100012011	4	0	2	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.1	\N	2022-07-01 22:05:08.1
44	100012011	5	0	2	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.1	\N	2022-07-01 22:05:08.1
44	100012011	6	0	2	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.1	\N	2022-07-01 22:05:08.1
44	100012050	1	0	4	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.101	\N	2022-07-01 22:05:08.101
44	100012050	2	0	4	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.101	\N	2022-07-01 22:05:08.101
44	100012080	5	0	2	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.102	\N	2022-07-01 22:05:08.102
44	100012080	6	0	2	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.103	\N	2022-07-01 22:05:08.103
44	200010000	1	0	5	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.103	\N	2022-07-01 22:05:08.103
44	200010000	2	0	5	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.103	\N	2022-07-01 22:05:08.103
44	200010000	3	0	6	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.103	\N	2022-07-01 22:05:08.103
44	200010000	4	0	5	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.104	\N	2022-07-01 22:05:08.104
44	200010000	5	0	5	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.104	\N	2022-07-01 22:05:08.104
44	200010000	6	0	5	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.104	\N	2022-07-01 22:05:08.104
44	300110000	1	0	8	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.104	\N	2022-07-01 22:05:08.104
44	300110000	2	0	9	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.105	\N	2022-07-01 22:05:08.105
44	300110000	3	0	10	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.105	\N	2022-07-01 22:05:08.105
44	300110000	4	0	7	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.105	\N	2022-07-01 22:05:08.105
44	300110000	5	0	7	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.105	\N	2022-07-01 22:05:08.105
44	300110000	6	0	7	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.105	\N	2022-07-01 22:05:08.105
44	401000000	1	0	5	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.106	\N	2022-07-01 22:05:08.106
44	401000000	2	0	6	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.106	\N	2022-07-01 22:05:08.106
44	401000000	3	0	6	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.106	\N	2022-07-01 22:05:08.106
44	401000000	5	0	6	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.107	\N	2022-07-01 22:05:08.107
44	401000000	6	0	6	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.107	\N	2022-07-01 22:05:08.107
44	401100000	4	0	3	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.107	\N	2022-07-01 22:05:08.107
44	401100000	5	0	3	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.107	\N	2022-07-01 22:05:08.107
44	401200000	4	0	3	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.108	\N	2022-07-01 22:05:08.108
44	401200000	5	0	3	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.108	\N	2022-07-01 22:05:08.108
44	401200000	6	0	3	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.108	\N	2022-07-01 22:05:08.108
44	500010000	1	0	4	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.109	\N	2022-07-01 22:05:08.109
44	500010000	2	0	4	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.109	\N	2022-07-01 22:05:08.109
44	500010000	3	0	4	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.109	\N	2022-07-01 22:05:08.109
44	500010000	4	0	4	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.109	\N	2022-07-01 22:05:08.109
44	500010000	5	0	4	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.11	\N	2022-07-01 22:05:08.11
44	500010000	6	0	4	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.11	\N	2022-07-01 22:05:08.11
44	600020000	1	0	4	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.11	\N	2022-07-01 22:05:08.11
44	600020000	2	0	4	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.11	\N	2022-07-01 22:05:08.11
44	600020000	3	0	4	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.11	\N	2022-07-01 22:05:08.11
44	600020000	4	0	4	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.111	\N	2022-07-01 22:05:08.111
44	600020000	5	0	4	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.111	\N	2022-07-01 22:05:08.111
44	600020000	6	0	4	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.111	\N	2022-07-01 22:05:08.111
45	100012011	7	0	2	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.111	\N	2022-07-01 22:05:08.111
45	100012011	8	0	2	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.112	\N	2022-07-01 22:05:08.112
45	100012011	9	0	2	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.112	\N	2022-07-01 22:05:08.112
45	100012030	7	0	2	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.112	\N	2022-07-01 22:05:08.112
45	100012030	9	0	2	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.113	\N	2022-07-01 22:05:08.113
45	100012050	7	0	3	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.113	\N	2022-07-01 22:05:08.113
45	100012050	8	0	3	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.113	\N	2022-07-01 22:05:08.113
45	100012050	9	0	3	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.113	\N	2022-07-01 22:05:08.113
45	100012080	7	0	2	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.114	\N	2022-07-01 22:05:08.114
45	100012080	8	0	2	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.114	\N	2022-07-01 22:05:08.114
45	100012080	9	0	2	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.114	\N	2022-07-01 22:05:08.114
45	200010200	7	0	3	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.114	\N	2022-07-01 22:05:08.114
45	200010200	8	0	3	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.114	\N	2022-07-01 22:05:08.114
45	200010200	9	0	3	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.115	\N	2022-07-01 22:05:08.115
45	300110000	7	0	6	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.115	\N	2022-07-01 22:05:08.115
45	300110000	8	0	6	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.115	\N	2022-07-01 22:05:08.115
45	300210000	8	0	4	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.116	\N	2022-07-01 22:05:08.116
45	300210000	9	0	4	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.116	\N	2022-07-01 22:05:08.116
45	401000000	7	0	5	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.116	\N	2022-07-01 22:05:08.116
45	401000000	8	0	5	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.117	\N	2022-07-01 22:05:08.117
45	401000000	9	0	5	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.117	\N	2022-07-01 22:05:08.117
45	401100000	7	0	4	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.117	\N	2022-07-01 22:05:08.117
45	401100000	8	0	4	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.117	\N	2022-07-01 22:05:08.117
45	401100000	9	0	4	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.118	\N	2022-07-01 22:05:08.118
45	401200000	7	0	3	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.118	\N	2022-07-01 22:05:08.118
45	401200000	8	0	3	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.118	\N	2022-07-01 22:05:08.118
45	401200000	9	0	3	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.118	\N	2022-07-01 22:05:08.118
45	500010000	7	0	3	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.119	\N	2022-07-01 22:05:08.119
45	500010000	8	0	3	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.119	\N	2022-07-01 22:05:08.119
45	500010000	9	0	3	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.119	\N	2022-07-01 22:05:08.119
45	600070000	7	0	2	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.119	\N	2022-07-01 22:05:08.119
45	600070000	8	0	2	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.12	\N	2022-07-01 22:05:08.12
45	843020100	7	0	3	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.12	\N	2022-07-01 22:05:08.12
45	843020100	8	0	3	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.121	\N	2022-07-01 22:05:08.121
45	843020100	9	0	3	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.121	\N	2022-07-01 22:05:08.121
46	100012011	10	0	4	1	1	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.121	\N	2022-07-01 22:05:08.121
46	100012011	11	0	4	1	1	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.121	\N	2022-07-01 22:05:08.121
46	100012011	12	0	4	1	1	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.122	\N	2022-07-01 22:05:08.122
46	100012021	10	0	4	1	1	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.122	\N	2022-07-01 22:05:08.122
46	100012021	11	0	4	1	1	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.122	\N	2022-07-01 22:05:08.122
46	100012021	12	0	4	1	1	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.122	\N	2022-07-01 22:05:08.122
46	100012030	10	0	4	1	1	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.123	\N	2022-07-01 22:05:08.123
46	100012030	11	0	4	1	1	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.123	\N	2022-07-01 22:05:08.123
46	100012030	12	0	4	1	1	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.123	\N	2022-07-01 22:05:08.123
46	100012040	10	0	2	1	1	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.123	\N	2022-07-01 22:05:08.123
46	100012040	11	0	2	1	1	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.124	\N	2022-07-01 22:05:08.124
46	100012040	12	0	2	1	1	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.124	\N	2022-07-01 22:05:08.124
46	100012050	10	0	2	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.124	\N	2022-07-01 22:05:08.124
46	100012050	11	0	2	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.124	\N	2022-07-01 22:05:08.124
46	100012050	12	0	2	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.124	\N	2022-07-01 22:05:08.124
46	100012060	10	0	2	1	1	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.125	\N	2022-07-01 22:05:08.125
46	100012060	11	0	2	1	1	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.125	\N	2022-07-01 22:05:08.125
46	100012060	12	0	2	1	1	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.125	\N	2022-07-01 22:05:08.125
46	401231000	12	0	2	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.131	\N	2022-07-01 22:05:08.131
46	500010000	10	0	2	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.131	\N	2022-07-01 22:05:08.131
46	500010000	11	0	2	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.131	\N	2022-07-01 22:05:08.131
46	600060000	10	0	2	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.132	\N	2022-07-01 22:05:08.132
46	600060000	11	0	2	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.132	\N	2022-07-01 22:05:08.132
46	600060000	12	0	2	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.132	\N	2022-07-01 22:05:08.132
46	843020100	10	0	2	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.133	\N	2022-07-01 22:05:08.133
46	843020100	11	0	2	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.133	\N	2022-07-01 22:05:08.133
46	843020100	12	0	2	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.133	\N	2022-07-01 22:05:08.133
47	100012011	10	0	2	1	1	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.133	\N	2022-07-01 22:05:08.133
47	100012011	11	0	2	1	1	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.134	\N	2022-07-01 22:05:08.134
47	100012011	12	0	2	1	1	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.134	\N	2022-07-01 22:05:08.134
47	100012021	10	0	2	1	1	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.134	\N	2022-07-01 22:05:08.134
47	100012021	11	0	2	1	1	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.134	\N	2022-07-01 22:05:08.134
47	100012021	12	0	2	1	1	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.135	\N	2022-07-01 22:05:08.135
47	100012050	10	0	2	1	1	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.135	\N	2022-07-01 22:05:08.135
47	100012050	11	0	2	1	1	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.135	\N	2022-07-01 22:05:08.135
47	100012050	12	0	2	1	1	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.135	\N	2022-07-01 22:05:08.135
47	200010200	10	0	2	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.136	\N	2022-07-01 22:05:08.136
47	200010200	11	0	2	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.136	\N	2022-07-01 22:05:08.136
47	200010200	12	0	2	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.136	\N	2022-07-01 22:05:08.136
47	300110000	10	0	4	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.136	\N	2022-07-01 22:05:08.136
47	300110000	11	0	4	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.137	\N	2022-07-01 22:05:08.137
47	300110000	12	0	4	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.137	\N	2022-07-01 22:05:08.137
47	300210000	10	0	2	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.137	\N	2022-07-01 22:05:08.137
47	300210000	11	0	2	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.137	\N	2022-07-01 22:05:08.137
47	300210000	12	0	2	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.137	\N	2022-07-01 22:05:08.137
47	401000000	11	0	4	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.138	\N	2022-07-01 22:05:08.138
47	401000000	12	0	4	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.138	\N	2022-07-01 22:05:08.138
47	401001000	10	0	3	10	0	0	5	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.138	\N	2022-07-01 22:05:08.138
47	401001000	11	0	4	10	0	0	5	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.139	\N	2022-07-01 22:05:08.139
47	401001000	12	0	4	10	0	0	5	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.139	\N	2022-07-01 22:05:08.139
47	401110200	10	0	3	10	0	0	5	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.139	\N	2022-07-01 22:05:08.139
47	401110200	11	0	4	10	0	0	5	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.139	\N	2022-07-01 22:05:08.139
47	401110200	12	0	4	10	0	0	5	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.14	\N	2022-07-01 22:05:08.14
47	401121000	10	0	3	10	0	0	5	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.14	\N	2022-07-01 22:05:08.14
47	401121000	11	0	4	10	0	0	5	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.14	\N	2022-07-01 22:05:08.14
47	401121000	12	0	4	10	0	0	5	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.14	\N	2022-07-01 22:05:08.14
47	401130000	10	0	3	10	0	0	5	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.141	\N	2022-07-01 22:05:08.141
47	401231000	10	0	2	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.141	\N	2022-07-01 22:05:08.141
47	401231000	11	0	2	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.142	\N	2022-07-01 22:05:08.142
47	401231000	12	0	2	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.142	\N	2022-07-01 22:05:08.142
47	500010000	10	0	3	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.142	\N	2022-07-01 22:05:08.142
47	500010000	11	0	3	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.142	\N	2022-07-01 22:05:08.142
47	500010000	12	0	3	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.142	\N	2022-07-01 22:05:08.142
47	600060000	10	0	2	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.143	\N	2022-07-01 22:05:08.143
47	600060000	11	0	2	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.143	\N	2022-07-01 22:05:08.143
47	600060000	12	0	2	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.143	\N	2022-07-01 22:05:08.143
47	843020100	10	0	2	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.143	\N	2022-07-01 22:05:08.143
47	843020100	11	0	2	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.144	\N	2022-07-01 22:05:08.144
47	843020100	12	0	2	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.144	\N	2022-07-01 22:05:08.144
48	100012011	10	0	2	1	1	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.144	\N	2022-07-01 22:05:08.144
48	100012011	11	0	2	1	1	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.144	\N	2022-07-01 22:05:08.144
48	100012011	12	0	2	1	1	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.145	\N	2022-07-01 22:05:08.145
48	100012021	10	0	2	1	1	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.145	\N	2022-07-01 22:05:08.145
48	100012021	12	0	2	1	1	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.145	\N	2022-07-01 22:05:08.145
48	100012050	10	0	2	1	1	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.146	\N	2022-07-01 22:05:08.146
48	100012050	11	0	2	1	1	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.146	\N	2022-07-01 22:05:08.146
48	100012050	12	0	2	1	1	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.146	\N	2022-07-01 22:05:08.146
48	200010200	10	0	2	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.146	\N	2022-07-01 22:05:08.146
48	200010200	11	0	2	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.147	\N	2022-07-01 22:05:08.147
48	200010200	12	0	2	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.147	\N	2022-07-01 22:05:08.147
48	300110000	10	0	4	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.147	\N	2022-07-01 22:05:08.147
48	300110000	11	0	4	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.147	\N	2022-07-01 22:05:08.147
48	300110000	12	0	4	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.147	\N	2022-07-01 22:05:08.147
48	300210000	10	0	2	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.148	\N	2022-07-01 22:05:08.148
48	300210000	11	0	2	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.148	\N	2022-07-01 22:05:08.148
48	300210000	12	0	2	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.148	\N	2022-07-01 22:05:08.148
48	401000000	10	0	4	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.148	\N	2022-07-01 22:05:08.148
48	401000000	11	0	4	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.149	\N	2022-07-01 22:05:08.149
48	401000000	12	0	4	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.149	\N	2022-07-01 22:05:08.149
48	401220000	10	0	3	10	0	0	5	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.149	\N	2022-07-01 22:05:08.149
49	300120000	10	0	3	10	0	0	5	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.159	\N	2022-07-01 22:05:08.159
49	300120000	11	0	4	10	0	0	5	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.159	\N	2022-07-01 22:05:08.159
49	300120000	12	0	4	10	0	0	5	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.159	\N	2022-07-01 22:05:08.159
49	300210000	10	0	2	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.16	\N	2022-07-01 22:05:08.16
49	300210000	11	0	2	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.16	\N	2022-07-01 22:05:08.16
49	300210000	12	0	2	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.16	\N	2022-07-01 22:05:08.16
49	300220000	10	0	3	10	0	0	5	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.161	\N	2022-07-01 22:05:08.161
49	300220000	12	0	4	10	0	0	5	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.162	\N	2022-07-01 22:05:08.162
49	300310900	10	0	3	10	0	0	5	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.162	\N	2022-07-01 22:05:08.162
49	300310900	11	0	4	10	0	0	5	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.162	\N	2022-07-01 22:05:08.162
49	300310900	12	0	4	10	0	0	5	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.163	\N	2022-07-01 22:05:08.163
49	401000000	10	0	4	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.163	\N	2022-07-01 22:05:08.163
49	401000000	11	0	4	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.163	\N	2022-07-01 22:05:08.163
49	401000000	12	0	4	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.164	\N	2022-07-01 22:05:08.164
49	401231000	10	0	2	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.164	\N	2022-07-01 22:05:08.164
49	401231000	11	0	2	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.164	\N	2022-07-01 22:05:08.164
49	401231000	12	0	2	3	3	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.165	\N	2022-07-01 22:05:08.165
49	401260000	10	0	3	10	0	0	5	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.165	\N	2022-07-01 22:05:08.165
49	401260000	11	0	4	10	0	0	5	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.165	\N	2022-07-01 22:05:08.165
49	401260000	12	0	4	10	0	0	5	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.166	\N	2022-07-01 22:05:08.166
49	500010000	10	0	3	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.166	\N	2022-07-01 22:05:08.166
49	500010000	11	0	3	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.166	\N	2022-07-01 22:05:08.166
49	500010000	12	0	3	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.167	\N	2022-07-01 22:05:08.167
49	600060000	10	0	2	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.167	\N	2022-07-01 22:05:08.167
49	600060000	11	0	2	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.167	\N	2022-07-01 22:05:08.167
49	600060000	12	0	2	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.168	\N	2022-07-01 22:05:08.168
49	843020100	10	0	2	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.168	\N	2022-07-01 22:05:08.168
49	843020100	11	0	2	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.168	\N	2022-07-01 22:05:08.168
49	843020100	12	0	2	4	4	0	0	*	\N	2019-10-11 00:00:00	2022-07-01 22:05:08.169	\N	2022-07-01 22:05:08.169
50	100015010	11	3	3	1	1	0	0	*	\N	2021-07-15 00:00:00	2022-07-01 22:05:08.169	\N	2022-07-01 22:05:08.169
50	100015010	12	3	3	1	1	0	0	*	\N	2021-07-15 00:00:00	2022-07-01 22:05:08.17	\N	2022-07-01 22:05:08.17
50	100015020	12	2	2	1	1	0	1	*	\N	2021-07-15 00:00:00	2022-07-01 22:05:08.171	\N	2022-07-01 22:05:08.171
50	100015050	10	1	1	1	1	0	1	*	\N	2021-07-15 00:00:00	2022-07-01 22:05:08.173	\N	2022-07-01 22:05:08.173
50	100015050	11	1	1	1	1	0	1	*	\N	2021-07-15 00:00:00	2022-07-01 22:05:08.173	\N	2022-07-01 22:05:08.173
50	100015050	12	1	1	1	1	0	1	*	\N	2021-07-15 00:00:00	2022-07-01 22:05:08.173	\N	2022-07-01 22:05:08.173
50	100015060	11	1	1	1	1	0	1	*	\N	2021-07-15 00:00:00	2022-07-01 22:05:08.174	\N	2022-07-01 22:05:08.174
50	100015060	12	1	1	1	1	0	1	*	\N	2021-07-15 00:00:00	2022-07-01 22:05:08.174	\N	2022-07-01 22:05:08.174
50	100015070	10	2	2	1	1	0	1	*	\N	2021-07-15 00:00:00	2022-07-01 22:05:08.175	\N	2022-07-01 22:05:08.175
50	100015070	11	2	2	1	1	0	1	*	\N	2021-07-15 00:00:00	2022-07-01 22:05:08.175	\N	2022-07-01 22:05:08.175
50	100015070	12	2	2	1	1	0	1	*	\N	2021-07-15 00:00:00	2022-07-01 22:05:08.175	\N	2022-07-01 22:05:08.175
50	100015080	10	2	2	1	1	0	1	*	\N	2021-07-15 00:00:00	2022-07-01 22:05:08.176	\N	2022-07-01 22:05:08.176
50	100015080	11	2	2	1	1	0	1	*	\N	2021-07-15 00:00:00	2022-07-01 22:05:08.176	\N	2022-07-01 22:05:08.176
50	100015080	12	2	2	1	1	0	1	*	\N	2021-07-15 00:00:00	2022-07-01 22:05:08.176	\N	2022-07-01 22:05:08.176
50	300110000	12	4	4	1	1	0	0	*	\N	2021-07-15 00:00:00	2022-07-01 22:05:08.178	\N	2022-07-01 22:05:08.178
50	300210000	10	2	2	1	1	0	0	*	\N	2021-07-15 00:00:00	2022-07-01 22:05:08.179	\N	2022-07-01 22:05:08.179
50	300210000	11	2	2	1	1	0	0	*	\N	2021-07-15 00:00:00	2022-07-01 22:05:08.179	\N	2022-07-01 22:05:08.179
50	300210000	12	2	2	1	1	0	0	*	\N	2021-07-15 00:00:00	2022-07-01 22:05:08.179	\N	2022-07-01 22:05:08.179
50	401000000	11	4	4	1	1	0	0	*	\N	2021-07-15 00:00:00	2022-07-01 22:05:08.181	\N	2022-07-01 22:05:08.181
1059	200010000	10	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
1060	200010000	10	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
301	200010000	36	0	24	1	1	0	0	*	\N	2020-12-18 14:44:23.03	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
50	401000000	12	4	4	1	1	0	0	*	\N	2021-07-15 00:00:00	2022-07-01 22:05:08.181	\N	2022-07-01 22:05:08.181
50	401100000	10	4	4	1	1	0	0	*	\N	2021-07-15 00:00:00	2022-07-01 22:05:08.182	\N	2022-07-01 22:05:08.182
50	401100000	11	4	4	1	1	0	0	*	\N	2021-07-15 00:00:00	2022-07-01 22:05:08.182	\N	2022-07-01 22:05:08.182
10812	800000270	12	0	4	11	0	0	0	P	\N	2023-07-07 15:00:00	2024-07-17 00:00:00	\N	1901-01-01 00:00:00
50	401100000	12	4	4	1	1	0	0	*	\N	2021-07-15 00:00:00	2022-07-01 22:05:08.182	\N	2022-07-01 22:05:08.182
50	401200000	10	3	3	1	1	0	0	*	\N	2021-07-15 00:00:00	2022-07-01 22:05:08.182	\N	2022-07-01 22:05:08.182
50	401200000	11	3	3	1	1	0	0	*	\N	2021-07-15 00:00:00	2022-07-01 22:05:08.183	\N	2022-07-01 22:05:08.183
50	401200000	12	3	3	1	1	0	0	*	\N	2021-07-15 00:00:00	2022-07-01 22:05:08.183	\N	2022-07-01 22:05:08.183
50	401231000	11	2	2	1	1	0	0	*	\N	2021-07-15 00:00:00	2022-07-01 22:05:08.184	\N	2022-07-01 22:05:08.184
50	401231000	12	2	2	1	1	0	0	*	\N	2021-07-15 00:00:00	2022-07-01 22:05:08.184	\N	2022-07-01 22:05:08.184
50	843020100	10	2	2	1	1	0	0	*	\N	2021-07-15 00:00:00	2022-07-01 22:05:08.187	\N	2022-07-01 22:05:08.187
50	843020100	11	2	2	1	1	0	0	*	\N	2021-07-15 00:00:00	2022-07-01 22:05:08.188	\N	2022-07-01 22:05:08.188
50	843020100	12	2	2	1	1	0	0	*	\N	2021-07-15 00:00:00	2022-07-01 22:05:08.188	\N	2022-07-01 22:05:08.188
50	200010000	12	2	2	1	1	0	0	*	\N	2021-07-15 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
10762	800000283	12	0	4	11	0	0	0	P	\N	2024-07-10 17:30:00	2024-07-17 00:00:00	\N	1901-01-01 00:00:00
1061	200010000	8	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.314	\N	2022-07-01 22:04:59.314
356	200010000	10	0	2	3	3	0	0	N	\N	2020-06-30 08:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
10775	800000283	12	0	4	11	0	0	0	P	\N	2024-07-10 17:30:00	2024-07-17 00:00:00	\N	1901-01-01 00:00:00
431	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.258	\N	2022-07-01 22:05:12.258
431	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.258	\N	2022-07-01 22:05:12.258
431	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.258	\N	2022-07-01 22:05:12.258
301	999800414	32	0	24	4	4	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:05.73	\N	2022-07-01 22:05:05.73
431	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.259	\N	2022-07-01 22:05:12.259
10763	800000173	12	0	4	11	0	0	0	P	\N	2023-07-07 15:00:00	2024-07-17 00:00:00	\N	1901-01-01 00:00:00
431	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.259	\N	2022-07-01 22:05:12.259
1061	300310700	5	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.325	\N	2022-07-01 22:04:59.325
301	999800414	33	0	24	4	4	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:05.753	\N	2022-07-01 22:05:05.753
431	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.259	\N	2022-07-01 22:05:12.259
10793	800000283	12	0	4	11	0	0	0	P	\N	2024-07-10 17:30:00	2024-07-17 00:00:00	\N	1901-01-01 00:00:00
431	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.259	\N	2022-07-01 22:05:12.259
1061	300310700	6	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.325	\N	2022-07-01 22:04:59.325
301	999800414	34	0	24	4	4	0	0	*	\N	2020-12-18 14:43:34.773	2022-07-01 22:05:05.776	\N	2022-07-01 22:05:05.776
432	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.26	\N	2022-07-01 22:05:12.26
31	200010000	11	0	2	3	3	0	0	*	\N	2017-03-17 12:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
10818	800000283	12	0	4	11	0	0	0	P	\N	2024-07-10 17:30:00	2024-07-17 00:00:00	\N	1901-01-01 00:00:00
432	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.26	\N	2022-07-01 22:05:12.26
10850	800000283	12	0	4	11	0	0	0	P	\N	2024-07-10 17:30:00	2024-07-17 00:00:00	\N	1901-01-01 00:00:00
432	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.26	\N	2022-07-01 22:05:12.26
1061	300310700	7	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.325	\N	2022-07-01 22:04:59.325
301	999800415	56	0	24	4	4	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:05.117	\N	2022-07-01 22:05:05.117
432	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.26	\N	2022-07-01 22:05:12.26
1061	300310700	8	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.326	\N	2022-07-01 22:04:59.326
301	999801001	92	0	24	1	1	0	0	*	\N	2020-08-27 08:00:00	2022-07-01 22:05:05.119	\N	2022-07-01 22:05:05.119
432	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.261	\N	2022-07-01 22:05:12.261
10863	800000283	12	0	4	11	0	0	0	P	\N	2024-07-10 17:30:00	2024-07-17 00:00:00	\N	1901-01-01 00:00:00
432	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.261	\N	2022-07-01 22:05:12.261
10753	800000284	12	0	4	11	0	0	0	P	\N	2024-07-10 17:30:00	2024-07-17 00:00:00	\N	1901-01-01 00:00:00
432	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.261	\N	2022-07-01 22:05:12.261
432	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.261	\N	2022-07-01 22:05:12.261
10778	800000284	12	0	4	11	0	0	0	P	\N	2024-07-10 17:30:00	2024-07-17 00:00:00	\N	1901-01-01 00:00:00
432	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.262	\N	2022-07-01 22:05:12.262
10803	800000284	12	0	4	11	0	0	0	P	\N	2024-07-10 17:30:00	2024-07-17 00:00:00	\N	1901-01-01 00:00:00
432	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.262	\N	2022-07-01 22:05:12.262
1061	300310700	9	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.326	\N	2022-07-01 22:04:59.326
301	999801001	93	0	24	1	1	0	0	*	\N	2020-08-27 08:00:00	2022-07-01 22:05:05.122	\N	2022-07-01 22:05:05.122
432	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.262	\N	2022-07-01 22:05:12.262
301	300110000	41	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.425	\N	2022-07-01 22:05:04.425
1061	300310700	10	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.326	\N	2022-07-01 22:04:59.326
301	999801002	92	0	24	1	1	0	0	*	\N	2020-08-27 08:00:00	2022-07-01 22:05:05.124	\N	2022-07-01 22:05:05.124
10816	800000284	12	0	4	11	0	0	0	P	\N	2024-07-10 17:30:00	2024-07-17 00:00:00	\N	1901-01-01 00:00:00
394	200010000	10	0	2	3	3	0	0	N	\N	2020-06-30 08:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
10839	800000284	12	0	4	11	0	0	0	P	\N	2024-07-10 17:30:00	2024-07-17 00:00:00	\N	1901-01-01 00:00:00
10866	800000284	12	0	4	11	0	0	0	P	\N	2024-07-10 17:30:00	2024-07-17 00:00:00	\N	1901-01-01 00:00:00
1061	300310700	11	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.327	\N	2022-07-01 22:04:59.327
301	999801002	93	0	24	1	1	0	0	*	\N	2020-08-27 08:00:00	2022-07-01 22:05:05.126	\N	2022-07-01 22:05:05.126
10763	800000285	12	0	4	11	0	0	0	P	\N	2024-07-10 17:30:00	2024-07-17 00:00:00	\N	1901-01-01 00:00:00
432	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.263	\N	2022-07-01 22:05:12.263
1061	401000000	5	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.329	\N	2022-07-01 22:04:59.329
432	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.263	\N	2022-07-01 22:05:12.263
301	300110000	52	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.426	\N	2022-07-01 22:05:04.426
429	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
1061	200010000	7	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.314	\N	2022-07-01 22:04:59.314
1061	200010000	9	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.314	\N	2022-07-01 22:04:59.314
1061	200010200	1	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.315	\N	2022-07-01 22:04:59.315
1061	200010200	2	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.315	\N	2022-07-01 22:04:59.315
1061	200010200	3	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.316	\N	2022-07-01 22:04:59.316
1061	200010200	4	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.316	\N	2022-07-01 22:04:59.316
1061	200010200	5	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.316	\N	2022-07-01 22:04:59.316
1061	200010200	6	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.316	\N	2022-07-01 22:04:59.316
1061	200010200	7	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.317	\N	2022-07-01 22:04:59.317
1061	200010200	8	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.317	\N	2022-07-01 22:04:59.317
1061	200010200	9	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.317	\N	2022-07-01 22:04:59.317
1061	200010200	10	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.317	\N	2022-07-01 22:04:59.317
1061	200010200	12	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.318	\N	2022-07-01 22:04:59.318
1061	300110000	1	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.318	\N	2022-07-01 22:04:59.318
1061	300110000	2	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.318	\N	2022-07-01 22:04:59.318
1061	300110000	3	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.319	\N	2022-07-01 22:04:59.319
1061	300110000	4	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.319	\N	2022-07-01 22:04:59.319
1061	300110000	5	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.319	\N	2022-07-01 22:04:59.319
1061	300110000	6	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.319	\N	2022-07-01 22:04:59.319
1061	300110000	7	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.319	\N	2022-07-01 22:04:59.319
1061	300110000	8	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.32	\N	2022-07-01 22:04:59.32
1061	300110000	9	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.32	\N	2022-07-01 22:04:59.32
1061	300110000	10	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.32	\N	2022-07-01 22:04:59.32
1061	300110000	11	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.32	\N	2022-07-01 22:04:59.32
1061	300110000	12	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.321	\N	2022-07-01 22:04:59.321
1061	300210000	1	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.321	\N	2022-07-01 22:04:59.321
1061	300210000	2	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.321	\N	2022-07-01 22:04:59.321
1061	300210000	3	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.321	\N	2022-07-01 22:04:59.321
1061	300210000	4	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.322	\N	2022-07-01 22:04:59.322
438	200010000	10	0	2	3	3	0	0	N	\N	2020-06-30 08:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
1061	200010000	12	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
1061	401000000	6	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.329	\N	2022-07-01 22:04:59.329
432	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.263	\N	2022-07-01 22:05:12.263
301	999891004	31	0	24	4	4	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:05.129	\N	2022-07-01 22:05:05.129
1061	401000000	7	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.329	\N	2022-07-01 22:04:59.329
440	200010000	10	0	2	3	3	0	0	N	\N	2020-06-30 08:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
440	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
432	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.264	\N	2022-07-01 22:05:12.264
441	200010000	10	0	2	3	3	0	0	N	\N	2020-06-30 08:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
442	200010000	10	0	2	3	3	0	0	N	\N	2020-06-30 08:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
443	200010000	10	0	2	3	3	0	0	N	\N	2020-06-30 08:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
1061	401000000	2	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.328	\N	2022-07-01 22:04:59.328
1061	401000000	3	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.328	\N	2022-07-01 22:04:59.328
1061	401000000	4	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.328	\N	2022-07-01 22:04:59.328
301	300110000	59	0	24	1	1	0	0	*	\N	2020-12-18 14:44:23.03	2022-07-01 22:05:04.428	\N	2022-07-01 22:05:04.428
301	300120000	40	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.429	\N	2022-07-01 22:05:04.429
1061	401000000	10	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.331	\N	2022-07-01 22:04:59.331
1061	401000000	11	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.331	\N	2022-07-01 22:04:59.331
1061	401000000	12	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.331	\N	2022-07-01 22:04:59.331
1061	401100000	1	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.332	\N	2022-07-01 22:04:59.332
1061	401100000	2	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.332	\N	2022-07-01 22:04:59.332
1061	401100000	3	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.332	\N	2022-07-01 22:04:59.332
1061	401100000	4	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.332	\N	2022-07-01 22:04:59.332
1061	401100000	5	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.333	\N	2022-07-01 22:04:59.333
1061	401100000	6	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.333	\N	2022-07-01 22:04:59.333
445	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
445	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
1061	401100000	7	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.333	\N	2022-07-01 22:04:59.333
1061	401100000	8	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.333	\N	2022-07-01 22:04:59.333
1061	401100000	9	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.334	\N	2022-07-01 22:04:59.334
1061	401100000	10	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.334	\N	2022-07-01 22:04:59.334
1061	401100000	11	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.334	\N	2022-07-01 22:04:59.334
1061	401100000	12	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.334	\N	2022-07-01 22:04:59.334
1061	401110200	1	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.335	\N	2022-07-01 22:04:59.335
1061	401110200	3	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.335	\N	2022-07-01 22:04:59.335
301	300120000	41	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.429	\N	2022-07-01 22:05:04.429
432	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.265	\N	2022-07-01 22:05:12.265
432	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.266	\N	2022-07-01 22:05:12.266
432	300310100	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.267	\N	2022-07-01 22:05:12.267
432	300310200	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.268	\N	2022-07-01 22:05:12.268
432	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.268	\N	2022-07-01 22:05:12.268
432	300310300	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.268	\N	2022-07-01 22:05:12.268
432	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.268	\N	2022-07-01 22:05:12.268
432	300310400	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.269	\N	2022-07-01 22:05:12.269
432	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.269	\N	2022-07-01 22:05:12.269
432	300310500	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.269	\N	2022-07-01 22:05:12.269
432	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.269	\N	2022-07-01 22:05:12.269
432	300310600	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.27	\N	2022-07-01 22:05:12.27
432	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.27	\N	2022-07-01 22:05:12.27
432	300310700	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.27	\N	2022-07-01 22:05:12.27
432	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.27	\N	2022-07-01 22:05:12.27
432	300310800	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.271	\N	2022-07-01 22:05:12.271
432	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.271	\N	2022-07-01 22:05:12.271
432	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.272	\N	2022-07-01 22:05:12.272
432	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.272	\N	2022-07-01 22:05:12.272
432	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.272	\N	2022-07-01 22:05:12.272
432	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:12.272	\N	2022-07-01 22:05:12.272
432	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:12.272	\N	2022-07-01 22:05:12.272
432	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.273	\N	2022-07-01 22:05:12.273
432	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.273	\N	2022-07-01 22:05:12.273
432	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.273	\N	2022-07-01 22:05:12.273
432	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.274	\N	2022-07-01 22:05:12.274
432	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.274	\N	2022-07-01 22:05:12.274
432	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.275	\N	2022-07-01 22:05:12.275
432	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.275	\N	2022-07-01 22:05:12.275
432	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.275	\N	2022-07-01 22:05:12.275
432	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.275	\N	2022-07-01 22:05:12.275
432	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.276	\N	2022-07-01 22:05:12.276
432	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.277	\N	2022-07-01 22:05:12.277
432	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.277	\N	2022-07-01 22:05:12.277
301	401000000	35	0	24	1	1	0	0	*	\N	2020-12-18 14:43:42.613	2022-07-01 22:05:04.447	\N	2022-07-01 22:05:04.447
432	401130000	10	0	2	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
301	300210000	54	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.433	\N	2022-07-01 22:05:04.433
448	200010000	10	0	2	3	3	0	0	N	\N	2020-06-30 08:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
448	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
448	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
301	300210000	55	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.433	\N	2022-07-01 22:05:04.433
449	200010000	10	0	2	3	3	0	0	N	\N	2020-06-30 08:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
301	300210000	56	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.433	\N	2022-07-01 22:05:04.433
301	999891004	32	0	24	4	4	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:05.131	\N	2022-07-01 22:05:05.131
301	300220000	41	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.434	\N	2022-07-01 22:05:04.434
301	300220000	42	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.434	\N	2022-07-01 22:05:04.434
301	300220000	55	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.435	\N	2022-07-01 22:05:04.435
301	300310800	42	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.444	\N	2022-07-01 22:05:04.444
432	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.281	\N	2022-07-01 22:05:12.281
432	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.282	\N	2022-07-01 22:05:12.282
301	999800413	52	0	24	4	4	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:05.517	\N	2022-07-01 22:05:05.517
301	401000000	53	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.45	\N	2022-07-01 22:05:04.45
450	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
301	300310100	40	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.435	\N	2022-07-01 22:05:04.435
432	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.282	\N	2022-07-01 22:05:12.282
450	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
1059	300310700	10	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:05:02.801	\N	2022-07-01 22:05:02.801
301	300310100	42	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.436	\N	2022-07-01 22:05:04.436
432	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.282	\N	2022-07-01 22:05:12.282
432	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.282	\N	2022-07-01 22:05:12.282
301	401000000	54	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.45	\N	2022-07-01 22:05:04.45
301	300310700	55	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.443	\N	2022-07-01 22:05:04.443
301	300310100	55	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.436	\N	2022-07-01 22:05:04.436
432	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.283	\N	2022-07-01 22:05:12.283
432	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.283	\N	2022-07-01 22:05:12.283
433	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.283	\N	2022-07-01 22:05:12.283
433	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.283	\N	2022-07-01 22:05:12.283
433	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.284	\N	2022-07-01 22:05:12.284
433	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.284	\N	2022-07-01 22:05:12.284
433	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.284	\N	2022-07-01 22:05:12.284
433	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.284	\N	2022-07-01 22:05:12.284
433	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.284	\N	2022-07-01 22:05:12.284
433	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.285	\N	2022-07-01 22:05:12.285
433	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.285	\N	2022-07-01 22:05:12.285
433	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.285	\N	2022-07-01 22:05:12.285
433	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.285	\N	2022-07-01 22:05:12.285
433	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.286	\N	2022-07-01 22:05:12.286
433	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.286	\N	2022-07-01 22:05:12.286
433	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.286	\N	2022-07-01 22:05:12.286
433	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.286	\N	2022-07-01 22:05:12.286
433	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.287	\N	2022-07-01 22:05:12.287
301	300310100	56	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.437	\N	2022-07-01 22:05:04.437
433	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.287	\N	2022-07-01 22:05:12.287
433	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.287	\N	2022-07-01 22:05:12.287
451	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
301	300310400	41	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.437	\N	2022-07-01 22:05:04.437
301	300310400	42	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.438	\N	2022-07-01 22:05:04.438
301	999800413	53	0	24	4	4	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:05.54	\N	2022-07-01 22:05:05.54
301	300310400	55	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.438	\N	2022-07-01 22:05:04.438
452	200010000	10	0	2	3	3	0	0	N	\N	2020-06-30 08:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
301	300310400	56	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.438	\N	2022-07-01 22:05:04.438
433	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.288	\N	2022-07-01 22:05:12.288
301	300310500	40	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.439	\N	2022-07-01 22:05:04.439
433	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.288	\N	2022-07-01 22:05:12.288
488	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.294	\N	2022-07-01 22:05:12.294
433	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.289	\N	2022-07-01 22:05:12.289
301	300310500	42	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.439	\N	2022-07-01 22:05:04.439
301	300310500	55	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.44	\N	2022-07-01 22:05:04.44
433	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.289	\N	2022-07-01 22:05:12.289
301	999800413	54	0	24	4	4	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:05.563	\N	2022-07-01 22:05:05.563
301	300310500	56	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.44	\N	2022-07-01 22:05:04.44
433	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.289	\N	2022-07-01 22:05:12.289
301	500060000	42	0	24	4	4	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:04.978	\N	2022-07-01 22:05:04.978
301	300310600	40	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.44	\N	2022-07-01 22:05:04.44
433	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.289	\N	2022-07-01 22:05:12.289
301	500060000	51	0	24	4	4	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:04.979	\N	2022-07-01 22:05:04.979
301	300310600	42	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.441	\N	2022-07-01 22:05:04.441
433	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.29	\N	2022-07-01 22:05:12.29
301	300310600	55	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.441	\N	2022-07-01 22:05:04.441
433	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.29	\N	2022-07-01 22:05:12.29
433	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.29	\N	2022-07-01 22:05:12.29
301	500060000	52	0	24	4	4	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:04.979	\N	2022-07-01 22:05:04.979
433	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.291	\N	2022-07-01 22:05:12.291
301	300310700	40	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.442	\N	2022-07-01 22:05:04.442
301	300310700	41	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.442	\N	2022-07-01 22:05:04.442
433	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.291	\N	2022-07-01 22:05:12.291
433	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.291	\N	2022-07-01 22:05:12.291
433	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.291	\N	2022-07-01 22:05:12.291
301	300310700	56	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.443	\N	2022-07-01 22:05:04.443
433	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.292	\N	2022-07-01 22:05:12.292
301	300310800	40	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.444	\N	2022-07-01 22:05:04.444
433	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.292	\N	2022-07-01 22:05:12.292
301	500060000	53	0	24	4	4	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:04.979	\N	2022-07-01 22:05:04.979
488	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.293	\N	2022-07-01 22:05:12.293
301	300310800	55	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.445	\N	2022-07-01 22:05:04.445
488	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.293	\N	2022-07-01 22:05:12.293
488	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.293	\N	2022-07-01 22:05:12.293
301	401000000	31	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.445	\N	2022-07-01 22:05:04.445
301	401000000	32	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.446	\N	2022-07-01 22:05:04.446
488	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.293	\N	2022-07-01 22:05:12.293
301	401000000	33	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.446	\N	2022-07-01 22:05:04.446
488	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.294	\N	2022-07-01 22:05:12.294
301	999800412	54	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:05.505	\N	2022-07-01 22:05:05.505
488	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.294	\N	2022-07-01 22:05:12.294
301	999891004	33	0	24	4	4	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:05.133	\N	2022-07-01 22:05:05.133
301	999800413	55	0	24	4	4	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:05.586	\N	2022-07-01 22:05:05.586
301	999891004	34	0	24	4	4	0	0	*	\N	2020-12-18 14:43:34.773	2022-07-01 22:05:05.136	\N	2022-07-01 22:05:05.136
301	401000000	36	0	24	1	1	0	0	*	\N	2020-12-18 14:44:23.03	2022-07-01 22:05:04.447	\N	2022-07-01 22:05:04.447
488	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.294	\N	2022-07-01 22:05:12.294
301	401000000	37	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.447	\N	2022-07-01 22:05:04.447
488	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.295	\N	2022-07-01 22:05:12.295
301	401000000	38	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.448	\N	2022-07-01 22:05:04.448
301	401000000	39	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.448	\N	2022-07-01 22:05:04.448
488	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.296	\N	2022-07-01 22:05:12.296
301	401000000	40	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.448	\N	2022-07-01 22:05:04.448
488	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.296	\N	2022-07-01 22:05:12.296
301	401000000	41	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.449	\N	2022-07-01 22:05:04.449
488	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.296	\N	2022-07-01 22:05:12.296
1061	401110200	5	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.336	\N	2022-07-01 22:04:59.336
301	999800412	55	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:05.732	\N	2022-07-01 22:05:05.732
301	999800413	56	0	24	4	4	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:05.613	\N	2022-07-01 22:05:05.613
301	401000000	42	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.449	\N	2022-07-01 22:05:04.449
301	999800413	57	0	24	4	4	0	0	*	\N	2020-12-18 14:43:34.773	2022-07-01 22:05:05.637	\N	2022-07-01 22:05:05.637
301	401000000	51	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.449	\N	2022-07-01 22:05:04.449
488	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.297	\N	2022-07-01 22:05:12.297
301	401000000	52	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.45	\N	2022-07-01 22:05:04.45
301	999800412	56	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:05.962	\N	2022-07-01 22:05:05.962
301	902	78	24	24	1	1	0	0	*	\N	2020-07-19 00:00:00	2022-07-01 22:05:04.405	\N	2022-07-01 22:05:04.405
301	902	92	24	24	1	1	0	0	*	\N	2020-07-19 00:00:00	2022-07-01 22:05:04.405	\N	2022-07-01 22:05:04.405
301	902	93	24	24	1	1	0	0	*	\N	2020-07-19 00:00:00	2022-07-01 22:05:04.405	\N	2022-07-01 22:05:04.405
301	903	78	24	24	1	1	0	0	*	\N	2020-07-19 00:00:00	2022-07-01 22:05:04.406	\N	2022-07-01 22:05:04.406
301	903	92	24	24	1	1	0	0	*	\N	2020-07-19 00:00:00	2022-07-01 22:05:04.406	\N	2022-07-01 22:05:04.406
301	904	78	24	24	1	1	0	0	*	\N	2020-07-19 00:00:00	2022-07-01 22:05:04.407	\N	2022-07-01 22:05:04.407
301	904	92	24	24	1	1	0	0	*	\N	2020-07-19 00:00:00	2022-07-01 22:05:04.407	\N	2022-07-01 22:05:04.407
301	401000000	55	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.451	\N	2022-07-01 22:05:04.451
301	500060000	54	0	24	4	4	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:04.979	\N	2022-07-01 22:05:04.979
301	904	93	24	24	1	1	0	0	*	\N	2020-07-19 00:00:00	2022-07-01 22:05:04.407	\N	2022-07-01 22:05:04.407
301	100010000	37	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.408	\N	2022-07-01 22:05:04.408
301	100010000	38	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.408	\N	2022-07-01 22:05:04.408
301	100010000	39	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.408	\N	2022-07-01 22:05:04.408
301	100010000	40	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.409	\N	2022-07-01 22:05:04.409
301	100010000	41	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.409	\N	2022-07-01 22:05:04.409
301	100010000	42	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.409	\N	2022-07-01 22:05:04.409
301	100010000	53	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.41	\N	2022-07-01 22:05:04.41
301	100010000	54	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.41	\N	2022-07-01 22:05:04.41
301	100010000	55	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.41	\N	2022-07-01 22:05:04.41
301	100010000	56	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.411	\N	2022-07-01 22:05:04.411
301	101001000	31	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.411	\N	2022-07-01 22:05:04.411
301	101001000	32	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.411	\N	2022-07-01 22:05:04.411
301	101001000	33	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.412	\N	2022-07-01 22:05:04.412
301	101001000	34	0	24	1	1	0	0	*	\N	2020-12-18 14:43:34.773	2022-07-01 22:05:04.412	\N	2022-07-01 22:05:04.412
301	101001000	35	0	24	1	1	0	0	*	\N	2020-12-18 14:43:42.613	2022-07-01 22:05:04.412	\N	2022-07-01 22:05:04.412
301	101001000	36	0	24	1	1	0	0	*	\N	2020-12-18 14:44:23.03	2022-07-01 22:05:04.413	\N	2022-07-01 22:05:04.413
301	101001000	51	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.413	\N	2022-07-01 22:05:04.413
301	101001000	52	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.413	\N	2022-07-01 22:05:04.413
301	101001000	57	0	24	1	1	0	0	*	\N	2020-12-18 14:43:34.773	2022-07-01 22:05:04.414	\N	2022-07-01 22:05:04.414
301	101001000	58	0	24	1	1	0	0	*	\N	2020-12-18 14:43:42.613	2022-07-01 22:05:04.414	\N	2022-07-01 22:05:04.414
301	200010000	51	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.417	\N	2022-07-01 22:05:04.417
301	200010000	52	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.417	\N	2022-07-01 22:05:04.417
301	200010000	57	0	24	1	1	0	0	*	\N	2020-12-18 14:43:34.773	2022-07-01 22:05:04.417	\N	2022-07-01 22:05:04.417
301	200010000	58	0	24	1	1	0	0	*	\N	2020-12-18 14:43:42.613	2022-07-01 22:05:04.418	\N	2022-07-01 22:05:04.418
301	200010000	59	0	24	1	1	0	0	*	\N	2020-12-18 14:44:23.03	2022-07-01 22:05:04.418	\N	2022-07-01 22:05:04.418
301	200010200	37	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.418	\N	2022-07-01 22:05:04.418
301	200010200	38	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.419	\N	2022-07-01 22:05:04.419
301	200010200	39	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.419	\N	2022-07-01 22:05:04.419
301	200010200	40	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.419	\N	2022-07-01 22:05:04.419
301	200010200	41	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.42	\N	2022-07-01 22:05:04.42
301	200010200	42	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.42	\N	2022-07-01 22:05:04.42
301	200010200	53	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.42	\N	2022-07-01 22:05:04.42
301	200010200	54	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.421	\N	2022-07-01 22:05:04.421
301	200010200	55	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.421	\N	2022-07-01 22:05:04.421
301	200010200	56	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.421	\N	2022-07-01 22:05:04.421
301	300110000	31	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.422	\N	2022-07-01 22:05:04.422
301	300110000	32	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.422	\N	2022-07-01 22:05:04.422
301	300110000	51	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.426	\N	2022-07-01 22:05:04.426
301	300220000	40	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.434	\N	2022-07-01 22:05:04.434
301	300220000	56	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.435	\N	2022-07-01 22:05:04.435
301	300310100	41	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.436	\N	2022-07-01 22:05:04.436
301	300310400	40	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.437	\N	2022-07-01 22:05:04.437
301	300310500	41	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.439	\N	2022-07-01 22:05:04.439
301	300310600	41	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.441	\N	2022-07-01 22:05:04.441
301	300310600	56	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.442	\N	2022-07-01 22:05:04.442
301	300310700	42	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.443	\N	2022-07-01 22:05:04.443
301	300310800	41	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.444	\N	2022-07-01 22:05:04.444
301	300310800	56	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.445	\N	2022-07-01 22:05:04.445
301	401000000	34	0	24	1	1	0	0	*	\N	2020-12-18 14:43:34.773	2022-07-01 22:05:04.446	\N	2022-07-01 22:05:04.446
301	401000000	56	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.451	\N	2022-07-01 22:05:04.451
301	500060000	41	0	24	4	4	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:04.978	\N	2022-07-01 22:05:04.978
301	401000000	57	0	24	1	1	0	0	*	\N	2020-12-18 14:43:34.773	2022-07-01 22:05:04.451	\N	2022-07-01 22:05:04.451
301	401000000	58	0	24	1	1	0	0	*	\N	2020-12-18 14:43:42.613	2022-07-01 22:05:04.452	\N	2022-07-01 22:05:04.452
301	500060000	55	0	24	4	4	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:04.98	\N	2022-07-01 22:05:04.98
301	500060000	56	0	24	4	4	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:04.98	\N	2022-07-01 22:05:04.98
301	500060000	57	0	24	4	4	0	0	*	\N	2020-12-18 14:43:34.773	2022-07-01 22:05:04.98	\N	2022-07-01 22:05:04.98
301	500060000	59	0	24	4	4	0	0	*	\N	2020-12-18 14:44:23.03	2022-07-01 22:05:04.981	\N	2022-07-01 22:05:04.981
301	600070000	31	0	24	4	4	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:04.981	\N	2022-07-01 22:05:04.981
301	600070000	32	0	24	4	4	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:04.981	\N	2022-07-01 22:05:04.981
301	600070000	33	0	24	4	4	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:04.981	\N	2022-07-01 22:05:04.981
301	600070000	34	0	24	4	4	0	0	*	\N	2020-12-18 14:43:34.773	2022-07-01 22:05:04.981	\N	2022-07-01 22:05:04.981
301	600070000	35	0	24	4	4	0	0	*	\N	2020-12-18 14:43:42.613	2022-07-01 22:05:04.982	\N	2022-07-01 22:05:04.982
301	600070000	36	0	24	4	4	0	0	*	\N	2020-12-18 14:44:23.03	2022-07-01 22:05:04.982	\N	2022-07-01 22:05:04.982
301	600070000	37	0	24	4	4	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:04.982	\N	2022-07-01 22:05:04.982
301	600070000	38	0	24	4	4	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:04.982	\N	2022-07-01 22:05:04.982
301	600070000	39	0	24	4	4	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:04.983	\N	2022-07-01 22:05:04.983
301	600070000	40	0	24	4	4	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:04.983	\N	2022-07-01 22:05:04.983
301	600070000	41	0	24	4	4	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:04.983	\N	2022-07-01 22:05:04.983
301	600080000	42	0	24	3	3	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:04.988	\N	2022-07-01 22:05:04.988
301	600080000	51	0	24	3	3	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:04.989	\N	2022-07-01 22:05:04.989
301	600080000	52	0	24	3	3	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:04.989	\N	2022-07-01 22:05:04.989
301	600080000	53	0	24	3	3	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:04.989	\N	2022-07-01 22:05:04.989
301	600080000	54	0	24	3	3	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:04.989	\N	2022-07-01 22:05:04.989
301	600080000	55	0	24	3	3	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:04.989	\N	2022-07-01 22:05:04.989
301	600080000	56	0	24	3	3	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:04.99	\N	2022-07-01 22:05:04.99
301	600080000	57	0	24	3	3	0	0	*	\N	2020-12-18 14:43:34.773	2022-07-01 22:05:04.99	\N	2022-07-01 22:05:04.99
301	999800313	78	0	24	1	1	0	0	*	\N	2020-08-27 08:00:00	2022-07-01 22:05:04.996	\N	2022-07-01 22:05:04.996
301	999800412	31	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.997	\N	2022-07-01 22:05:04.997
301	999800412	32	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.997	\N	2022-07-01 22:05:04.997
301	999800412	33	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.997	\N	2022-07-01 22:05:04.997
301	999800412	35	0	24	1	1	0	0	*	\N	2020-12-18 14:43:42.613	2022-07-01 22:05:04.997	\N	2022-07-01 22:05:04.997
301	999800412	36	0	24	1	1	0	0	*	\N	2020-12-18 14:44:23.03	2022-07-01 22:05:04.998	\N	2022-07-01 22:05:04.998
301	999800412	37	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.998	\N	2022-07-01 22:05:04.998
301	999800412	38	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.998	\N	2022-07-01 22:05:04.998
301	999800412	39	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.998	\N	2022-07-01 22:05:04.998
301	999800412	40	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.999	\N	2022-07-01 22:05:04.999
301	999800412	41	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.999	\N	2022-07-01 22:05:04.999
301	999800412	42	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.999	\N	2022-07-01 22:05:04.999
301	999800412	51	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.999	\N	2022-07-01 22:05:04.999
301	999800412	53	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:05.278	\N	2022-07-01 22:05:05.278
301	200010000	33	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
301	200010000	34	0	24	1	1	0	0	*	\N	2020-12-18 14:43:34.773	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
301	200010000	35	0	24	1	1	0	0	*	\N	2020-12-18 14:43:42.613	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
301	999800412	57	0	24	1	1	0	0	*	\N	2020-12-18 14:43:34.773	2022-07-01 22:05:05.119	\N	2022-07-01 22:05:05.119
301	999800412	58	0	24	1	1	0	0	*	\N	2020-12-18 14:43:42.613	2022-07-01 22:05:05.143	\N	2022-07-01 22:05:05.143
301	999800412	59	0	24	1	1	0	0	*	\N	2020-12-18 14:44:23.03	2022-07-01 22:05:05.166	\N	2022-07-01 22:05:05.166
301	999800413	31	0	24	4	4	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:05.189	\N	2022-07-01 22:05:05.189
301	999800413	32	0	24	4	4	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:05.213	\N	2022-07-01 22:05:05.213
301	999800413	33	0	24	4	4	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:05.236	\N	2022-07-01 22:05:05.236
301	999800413	34	0	24	4	4	0	0	*	\N	2020-12-18 14:43:34.773	2022-07-01 22:05:05.26	\N	2022-07-01 22:05:05.26
301	999800413	35	0	24	4	4	0	0	*	\N	2020-12-18 14:43:42.613	2022-07-01 22:05:05.301	\N	2022-07-01 22:05:05.301
301	999800413	36	0	24	4	4	0	0	*	\N	2020-12-18 14:44:23.03	2022-07-01 22:05:05.326	\N	2022-07-01 22:05:05.326
301	999800413	37	0	24	4	4	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:05.35	\N	2022-07-01 22:05:05.35
301	999800413	38	0	24	4	4	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:05.375	\N	2022-07-01 22:05:05.375
301	999800413	39	0	24	4	4	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:05.398	\N	2022-07-01 22:05:05.398
301	999800413	41	0	24	4	4	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:05.444	\N	2022-07-01 22:05:05.444
301	999800413	42	0	24	4	4	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:05.468	\N	2022-07-01 22:05:05.468
301	999800413	51	0	24	4	4	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:05.492	\N	2022-07-01 22:05:05.492
301	999800413	58	0	24	4	4	0	0	*	\N	2020-12-18 14:43:42.613	2022-07-01 22:05:05.661	\N	2022-07-01 22:05:05.661
301	999800413	59	0	24	4	4	0	0	*	\N	2020-12-18 14:44:23.03	2022-07-01 22:05:05.684	\N	2022-07-01 22:05:05.684
301	999800414	31	0	24	4	4	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:05.707	\N	2022-07-01 22:05:05.707
301	999891004	36	0	24	4	4	0	0	*	\N	2020-12-18 14:44:23.03	2022-07-01 22:05:05.14	\N	2022-07-01 22:05:05.14
301	999891004	37	0	24	4	4	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:05.143	\N	2022-07-01 22:05:05.143
301	999891004	38	0	24	4	4	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:05.145	\N	2022-07-01 22:05:05.145
301	999891004	52	0	24	4	4	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:05.16	\N	2022-07-01 22:05:05.16
301	999891004	53	0	24	4	4	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:05.162	\N	2022-07-01 22:05:05.162
301	999891004	54	0	24	4	4	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:05.165	\N	2022-07-01 22:05:05.165
301	999891004	55	0	24	4	4	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:05.167	\N	2022-07-01 22:05:05.167
301	999891004	56	0	24	4	4	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:05.169	\N	2022-07-01 22:05:05.169
301	999891004	57	0	24	4	4	0	0	*	\N	2020-12-18 14:43:34.773	2022-07-01 22:05:05.172	\N	2022-07-01 22:05:05.172
301	999891004	58	0	24	4	4	0	0	*	\N	2020-12-18 14:43:42.613	2022-07-01 22:05:05.174	\N	2022-07-01 22:05:05.174
301	999891004	59	0	24	4	4	0	0	*	\N	2020-12-18 14:44:23.03	2022-07-01 22:05:05.176	\N	2022-07-01 22:05:05.176
301	401001000	40	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.452	\N	2022-07-01 22:05:04.452
301	401001000	41	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.453	\N	2022-07-01 22:05:04.453
301	401001000	42	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.453	\N	2022-07-01 22:05:04.453
301	81	73	0	24	1	1	0	0	*	\N	2013-04-29 16:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
929	200010000	11	0	2	1	1	0	0	*	\N	2017-07-31 16:32:53.437	2023-07-12 00:00:00	\N	2017-07-31 16:32:53.437
301	401001000	55	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.453	\N	2022-07-01 22:05:04.453
301	81	74	0	24	1	1	0	0	*	\N	2013-04-29 16:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
301	901	78	24	24	1	1	0	0	*	\N	2020-07-19 00:00:00	2022-07-01 22:05:04.404	\N	2022-07-01 22:05:04.404
301	901	92	24	24	1	1	0	0	*	\N	2020-07-19 00:00:00	2022-07-01 22:05:04.404	\N	2022-07-01 22:05:04.404
301	901	93	24	24	1	1	0	0	*	\N	2020-07-19 00:00:00	2022-07-01 22:05:04.404	\N	2022-07-01 22:05:04.404
301	81	75	0	24	1	1	0	0	*	\N	2013-04-29 16:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
301	401200000	51	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.467	\N	2022-07-01 22:05:04.467
301	401200000	52	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.468	\N	2022-07-01 22:05:04.468
301	401200000	53	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.468	\N	2022-07-01 22:05:04.468
301	401200000	54	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.468	\N	2022-07-01 22:05:04.468
301	401200000	57	0	24	1	1	0	0	*	\N	2020-12-18 14:43:34.773	2022-07-01 22:05:04.469	\N	2022-07-01 22:05:04.469
301	401200000	58	0	24	1	1	0	0	*	\N	2020-12-18 14:43:42.613	2022-07-01 22:05:04.469	\N	2022-07-01 22:05:04.469
301	401200000	59	0	24	1	1	0	0	*	\N	2020-12-18 14:44:23.03	2022-07-01 22:05:04.469	\N	2022-07-01 22:05:04.469
301	401220000	40	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.47	\N	2022-07-01 22:05:04.47
301	401220000	41	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.47	\N	2022-07-01 22:05:04.47
301	401220000	42	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.47	\N	2022-07-01 22:05:04.47
301	401220000	55	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.471	\N	2022-07-01 22:05:04.471
301	401220000	56	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.471	\N	2022-07-01 22:05:04.471
301	401230000	40	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.471	\N	2022-07-01 22:05:04.471
301	401230000	41	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.472	\N	2022-07-01 22:05:04.472
301	401230000	42	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.472	\N	2022-07-01 22:05:04.472
301	401230000	55	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.472	\N	2022-07-01 22:05:04.472
301	401231000	40	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.473	\N	2022-07-01 22:05:04.473
301	401231000	41	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.473	\N	2022-07-01 22:05:04.473
301	401231000	42	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.474	\N	2022-07-01 22:05:04.474
301	401231000	55	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.474	\N	2022-07-01 22:05:04.474
301	401231000	56	0	24	1	1	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.474	\N	2022-07-01 22:05:04.474
301	401240000	40	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.475	\N	2022-07-01 22:05:04.475
301	401240000	41	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.475	\N	2022-07-01 22:05:04.475
301	401240000	42	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.475	\N	2022-07-01 22:05:04.475
301	401240000	55	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.476	\N	2022-07-01 22:05:04.476
301	401240000	56	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.476	\N	2022-07-01 22:05:04.476
301	401250100	40	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.476	\N	2022-07-01 22:05:04.476
301	401250100	41	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.477	\N	2022-07-01 22:05:04.477
301	401250100	42	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.477	\N	2022-07-01 22:05:04.477
301	401250100	55	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.477	\N	2022-07-01 22:05:04.477
301	401250100	56	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.478	\N	2022-07-01 22:05:04.478
301	401260000	40	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.478	\N	2022-07-01 22:05:04.478
301	401260000	41	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.975	\N	2022-07-01 22:05:04.975
301	401260000	42	0	24	5	5	0	0	*	\N	2020-07-11 08:00:00	2022-07-01 22:05:04.975	\N	2022-07-01 22:05:04.975
301	600080000	58	0	24	3	3	0	0	*	\N	2020-12-18 14:43:42.613	2022-07-01 22:05:04.99	\N	2022-07-01 22:05:04.99
301	600080000	59	0	24	3	3	0	0	*	\N	2020-12-18 14:44:23.03	2022-07-01 22:05:04.99	\N	2022-07-01 22:05:04.99
301	600080010	31	0	24	3	3	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:04.991	\N	2022-07-01 22:05:04.991
301	600080010	32	0	24	3	3	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:04.991	\N	2022-07-01 22:05:04.991
301	600080010	33	0	24	3	3	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:04.991	\N	2022-07-01 22:05:04.991
301	600080010	34	0	24	3	3	0	0	*	\N	2020-12-18 14:43:34.773	2022-07-01 22:05:04.991	\N	2022-07-01 22:05:04.991
301	600080010	36	0	24	3	3	0	0	*	\N	2020-12-18 14:44:23.03	2022-07-01 22:05:04.992	\N	2022-07-01 22:05:04.992
301	600080010	37	0	24	3	3	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:04.992	\N	2022-07-01 22:05:04.992
301	600080010	38	0	24	3	3	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:04.992	\N	2022-07-01 22:05:04.992
301	600080010	39	0	24	3	3	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:04.992	\N	2022-07-01 22:05:04.992
301	600080010	40	0	24	3	3	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:04.993	\N	2022-07-01 22:05:04.993
301	600080010	41	0	24	3	3	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:04.993	\N	2022-07-01 22:05:04.993
301	600080010	42	0	24	3	3	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:04.993	\N	2022-07-01 22:05:04.993
301	600080010	51	0	24	3	3	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:04.993	\N	2022-07-01 22:05:04.993
301	600080010	52	0	24	3	3	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:04.994	\N	2022-07-01 22:05:04.994
301	600080010	53	0	24	3	3	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:04.994	\N	2022-07-01 22:05:04.994
301	600080010	54	0	24	3	3	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:04.994	\N	2022-07-01 22:05:04.994
301	600080010	55	0	24	3	3	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:04.994	\N	2022-07-01 22:05:04.994
301	600080010	56	0	24	3	3	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:04.995	\N	2022-07-01 22:05:04.995
301	600080010	57	0	24	3	3	0	0	*	\N	2020-12-18 14:43:34.773	2022-07-01 22:05:04.995	\N	2022-07-01 22:05:04.995
301	600080010	58	0	24	3	3	0	0	*	\N	2020-12-18 14:43:42.613	2022-07-01 22:05:04.996	\N	2022-07-01 22:05:04.996
301	600080010	59	0	24	3	3	0	0	*	\N	2020-12-18 14:44:23.03	2022-07-01 22:05:04.996	\N	2022-07-01 22:05:04.996
301	999800312	78	0	24	1	1	0	0	*	\N	2020-08-27 08:00:00	2022-07-01 22:05:04.996	\N	2022-07-01 22:05:04.996
354	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.288	\N	2022-07-01 22:05:06.288
301	999891004	41	0	24	4	4	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:05.152	\N	2022-07-01 22:05:05.152
301	999891004	42	0	24	4	4	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:05.155	\N	2022-07-01 22:05:05.155
301	999891004	51	0	24	4	4	0	0	*	\N	2020-10-20 08:00:00	2022-07-01 22:05:05.157	\N	2022-07-01 22:05:05.157
354	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.289	\N	2022-07-01 22:05:06.289
353	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.25	\N	2022-07-01 22:05:06.25
353	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.25	\N	2022-07-01 22:05:06.25
353	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.251	\N	2022-07-01 22:05:06.251
353	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.251	\N	2022-07-01 22:05:06.251
353	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.251	\N	2022-07-01 22:05:06.251
353	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.252	\N	2022-07-01 22:05:06.252
353	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.252	\N	2022-07-01 22:05:06.252
353	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.252	\N	2022-07-01 22:05:06.252
353	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.252	\N	2022-07-01 22:05:06.252
353	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.253	\N	2022-07-01 22:05:06.253
353	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.253	\N	2022-07-01 22:05:06.253
353	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.253	\N	2022-07-01 22:05:06.253
353	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.253	\N	2022-07-01 22:05:06.253
353	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.254	\N	2022-07-01 22:05:06.254
353	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.254	\N	2022-07-01 22:05:06.254
353	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.255	\N	2022-07-01 22:05:06.255
353	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.255	\N	2022-07-01 22:05:06.255
353	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.255	\N	2022-07-01 22:05:06.255
353	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.256	\N	2022-07-01 22:05:06.256
353	300210000	13	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.256	\N	2022-07-01 22:05:06.256
353	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.256	\N	2022-07-01 22:05:06.256
353	300310100	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.257	\N	2022-07-01 22:05:06.257
353	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.257	\N	2022-07-01 22:05:06.257
353	300310200	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.257	\N	2022-07-01 22:05:06.257
353	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.257	\N	2022-07-01 22:05:06.257
353	300310300	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.258	\N	2022-07-01 22:05:06.258
353	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.258	\N	2022-07-01 22:05:06.258
353	300310400	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.258	\N	2022-07-01 22:05:06.258
353	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.258	\N	2022-07-01 22:05:06.258
353	300310500	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.259	\N	2022-07-01 22:05:06.259
353	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.259	\N	2022-07-01 22:05:06.259
353	300310600	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.259	\N	2022-07-01 22:05:06.259
353	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.259	\N	2022-07-01 22:05:06.259
353	300310700	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.26	\N	2022-07-01 22:05:06.26
353	300310800	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.26	\N	2022-07-01 22:05:06.26
353	200010000	10	0	2	3	3	0	0	N	\N	2020-06-30 08:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
353	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
353	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.261	\N	2022-07-01 22:05:06.261
353	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.261	\N	2022-07-01 22:05:06.261
353	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.261	\N	2022-07-01 22:05:06.261
353	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.261	\N	2022-07-01 22:05:06.261
353	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:06.262	\N	2022-07-01 22:05:06.262
353	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:06.262	\N	2022-07-01 22:05:06.262
353	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.262	\N	2022-07-01 22:05:06.262
353	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.262	\N	2022-07-01 22:05:06.262
353	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.263	\N	2022-07-01 22:05:06.263
353	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.263	\N	2022-07-01 22:05:06.263
353	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.264	\N	2022-07-01 22:05:06.264
353	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.264	\N	2022-07-01 22:05:06.264
353	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.265	\N	2022-07-01 22:05:06.265
353	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.266	\N	2022-07-01 22:05:06.266
353	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.266	\N	2022-07-01 22:05:06.266
353	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.266	\N	2022-07-01 22:05:06.266
353	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.271	\N	2022-07-01 22:05:06.271
353	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.271	\N	2022-07-01 22:05:06.271
353	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.271	\N	2022-07-01 22:05:06.271
353	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.271	\N	2022-07-01 22:05:06.271
353	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.272	\N	2022-07-01 22:05:06.272
353	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.272	\N	2022-07-01 22:05:06.272
354	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.272	\N	2022-07-01 22:05:06.272
354	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.272	\N	2022-07-01 22:05:06.272
354	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.273	\N	2022-07-01 22:05:06.273
354	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.273	\N	2022-07-01 22:05:06.273
354	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.273	\N	2022-07-01 22:05:06.273
354	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.273	\N	2022-07-01 22:05:06.273
354	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.274	\N	2022-07-01 22:05:06.274
354	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.274	\N	2022-07-01 22:05:06.274
354	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.274	\N	2022-07-01 22:05:06.274
354	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.274	\N	2022-07-01 22:05:06.274
354	300310100	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.279	\N	2022-07-01 22:05:06.279
354	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.279	\N	2022-07-01 22:05:06.279
354	300310200	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.28	\N	2022-07-01 22:05:06.28
354	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.28	\N	2022-07-01 22:05:06.28
357	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.649	\N	2022-07-01 22:05:06.649
354	300310300	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.28	\N	2022-07-01 22:05:06.28
354	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.28	\N	2022-07-01 22:05:06.28
354	300310400	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.281	\N	2022-07-01 22:05:06.281
354	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.281	\N	2022-07-01 22:05:06.281
354	300310500	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.281	\N	2022-07-01 22:05:06.281
354	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.281	\N	2022-07-01 22:05:06.281
354	300310600	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.282	\N	2022-07-01 22:05:06.282
354	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.282	\N	2022-07-01 22:05:06.282
354	300310700	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.282	\N	2022-07-01 22:05:06.282
354	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.282	\N	2022-07-01 22:05:06.282
354	300310800	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.283	\N	2022-07-01 22:05:06.283
354	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.283	\N	2022-07-01 22:05:06.283
354	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.284	\N	2022-07-01 22:05:06.284
354	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.284	\N	2022-07-01 22:05:06.284
354	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:06.284	\N	2022-07-01 22:05:06.284
354	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:06.285	\N	2022-07-01 22:05:06.285
354	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.285	\N	2022-07-01 22:05:06.285
354	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.285	\N	2022-07-01 22:05:06.285
354	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.285	\N	2022-07-01 22:05:06.285
354	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.286	\N	2022-07-01 22:05:06.286
354	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.286	\N	2022-07-01 22:05:06.286
354	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.287	\N	2022-07-01 22:05:06.287
354	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.287	\N	2022-07-01 22:05:06.287
354	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.287	\N	2022-07-01 22:05:06.287
354	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.287	\N	2022-07-01 22:05:06.287
354	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.289	\N	2022-07-01 22:05:06.289
354	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.294	\N	2022-07-01 22:05:06.294
354	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.294	\N	2022-07-01 22:05:06.294
354	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.294	\N	2022-07-01 22:05:06.294
354	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.294	\N	2022-07-01 22:05:06.294
354	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.295	\N	2022-07-01 22:05:06.295
354	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.295	\N	2022-07-01 22:05:06.295
354	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.295	\N	2022-07-01 22:05:06.295
355	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.295	\N	2022-07-01 22:05:06.295
355	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.296	\N	2022-07-01 22:05:06.296
355	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.296	\N	2022-07-01 22:05:06.296
355	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.296	\N	2022-07-01 22:05:06.296
355	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.296	\N	2022-07-01 22:05:06.296
355	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.297	\N	2022-07-01 22:05:06.297
355	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.297	\N	2022-07-01 22:05:06.297
355	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.297	\N	2022-07-01 22:05:06.297
355	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.297	\N	2022-07-01 22:05:06.297
355	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.298	\N	2022-07-01 22:05:06.298
355	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.298	\N	2022-07-01 22:05:06.298
355	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.298	\N	2022-07-01 22:05:06.298
355	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.298	\N	2022-07-01 22:05:06.298
355	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.299	\N	2022-07-01 22:05:06.299
355	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.299	\N	2022-07-01 22:05:06.299
355	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.308	\N	2022-07-01 22:05:06.308
355	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.308	\N	2022-07-01 22:05:06.308
355	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.612	\N	2022-07-01 22:05:06.612
355	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.612	\N	2022-07-01 22:05:06.612
355	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.616	\N	2022-07-01 22:05:06.616
355	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.617	\N	2022-07-01 22:05:06.617
355	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.617	\N	2022-07-01 22:05:06.617
354	401130000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
488	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.303	\N	2022-07-01 22:05:12.303
355	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.618	\N	2022-07-01 22:05:06.618
355	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.618	\N	2022-07-01 22:05:06.618
356	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.619	\N	2022-07-01 22:05:06.619
356	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.619	\N	2022-07-01 22:05:06.619
356	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.619	\N	2022-07-01 22:05:06.619
356	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.62	\N	2022-07-01 22:05:06.62
356	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.621	\N	2022-07-01 22:05:06.621
356	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.621	\N	2022-07-01 22:05:06.621
356	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.621	\N	2022-07-01 22:05:06.621
356	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.622	\N	2022-07-01 22:05:06.622
356	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.622	\N	2022-07-01 22:05:06.622
356	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.622	\N	2022-07-01 22:05:06.622
356	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.623	\N	2022-07-01 22:05:06.623
356	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.623	\N	2022-07-01 22:05:06.623
356	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.623	\N	2022-07-01 22:05:06.623
356	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.623	\N	2022-07-01 22:05:06.623
356	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.624	\N	2022-07-01 22:05:06.624
356	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.624	\N	2022-07-01 22:05:06.624
356	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.625	\N	2022-07-01 22:05:06.625
356	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.626	\N	2022-07-01 22:05:06.626
356	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.626	\N	2022-07-01 22:05:06.626
356	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.627	\N	2022-07-01 22:05:06.627
356	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.627	\N	2022-07-01 22:05:06.627
356	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.627	\N	2022-07-01 22:05:06.627
356	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.628	\N	2022-07-01 22:05:06.628
356	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.628	\N	2022-07-01 22:05:06.628
356	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.628	\N	2022-07-01 22:05:06.628
356	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.629	\N	2022-07-01 22:05:06.629
356	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.629	\N	2022-07-01 22:05:06.629
356	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.629	\N	2022-07-01 22:05:06.629
356	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.63	\N	2022-07-01 22:05:06.63
356	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.63	\N	2022-07-01 22:05:06.63
356	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.63	\N	2022-07-01 22:05:06.63
356	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.631	\N	2022-07-01 22:05:06.631
356	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.642	\N	2022-07-01 22:05:06.642
356	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.642	\N	2022-07-01 22:05:06.642
356	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.642	\N	2022-07-01 22:05:06.642
356	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.643	\N	2022-07-01 22:05:06.643
356	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.643	\N	2022-07-01 22:05:06.643
356	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.643	\N	2022-07-01 22:05:06.643
356	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.644	\N	2022-07-01 22:05:06.644
357	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.644	\N	2022-07-01 22:05:06.644
357	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.644	\N	2022-07-01 22:05:06.644
357	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.645	\N	2022-07-01 22:05:06.645
357	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.645	\N	2022-07-01 22:05:06.645
357	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.645	\N	2022-07-01 22:05:06.645
357	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.646	\N	2022-07-01 22:05:06.646
357	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.646	\N	2022-07-01 22:05:06.646
357	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.647	\N	2022-07-01 22:05:06.647
357	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.647	\N	2022-07-01 22:05:06.647
357	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.647	\N	2022-07-01 22:05:06.647
357	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.648	\N	2022-07-01 22:05:06.648
357	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.648	\N	2022-07-01 22:05:06.648
357	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.649	\N	2022-07-01 22:05:06.649
357	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.649	\N	2022-07-01 22:05:06.649
357	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.65	\N	2022-07-01 22:05:06.65
357	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.65	\N	2022-07-01 22:05:06.65
357	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.651	\N	2022-07-01 22:05:06.651
357	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.652	\N	2022-07-01 22:05:06.652
357	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.652	\N	2022-07-01 22:05:06.652
357	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.652	\N	2022-07-01 22:05:06.652
357	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.653	\N	2022-07-01 22:05:06.653
488	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.303	\N	2022-07-01 22:05:12.303
357	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.653	\N	2022-07-01 22:05:06.653
357	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.653	\N	2022-07-01 22:05:06.653
357	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.654	\N	2022-07-01 22:05:06.654
357	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.654	\N	2022-07-01 22:05:06.654
357	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.654	\N	2022-07-01 22:05:06.654
357	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.655	\N	2022-07-01 22:05:06.655
357	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.655	\N	2022-07-01 22:05:06.655
357	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.655	\N	2022-07-01 22:05:06.655
357	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.656	\N	2022-07-01 22:05:06.656
357	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.656	\N	2022-07-01 22:05:06.656
357	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.657	\N	2022-07-01 22:05:06.657
357	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.657	\N	2022-07-01 22:05:06.657
357	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.657	\N	2022-07-01 22:05:06.657
356	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
357	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
357	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:06.657	\N	2022-07-01 22:05:06.657
357	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:06.658	\N	2022-07-01 22:05:06.658
357	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.658	\N	2022-07-01 22:05:06.658
357	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.658	\N	2022-07-01 22:05:06.658
357	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.66	\N	2022-07-01 22:05:06.66
357	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.66	\N	2022-07-01 22:05:06.66
357	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.66	\N	2022-07-01 22:05:06.66
357	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.661	\N	2022-07-01 22:05:06.661
357	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.661	\N	2022-07-01 22:05:06.661
357	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.661	\N	2022-07-01 22:05:06.661
357	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.662	\N	2022-07-01 22:05:06.662
357	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.663	\N	2022-07-01 22:05:06.663
357	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.663	\N	2022-07-01 22:05:06.663
357	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.667	\N	2022-07-01 22:05:06.667
357	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.667	\N	2022-07-01 22:05:06.667
357	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.667	\N	2022-07-01 22:05:06.667
357	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.668	\N	2022-07-01 22:05:06.668
357	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.668	\N	2022-07-01 22:05:06.668
357	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.668	\N	2022-07-01 22:05:06.668
357	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.669	\N	2022-07-01 22:05:06.669
358	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.669	\N	2022-07-01 22:05:06.669
358	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.67	\N	2022-07-01 22:05:06.67
358	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.67	\N	2022-07-01 22:05:06.67
358	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.67	\N	2022-07-01 22:05:06.67
358	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.671	\N	2022-07-01 22:05:06.671
358	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.671	\N	2022-07-01 22:05:06.671
358	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.671	\N	2022-07-01 22:05:06.671
358	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.672	\N	2022-07-01 22:05:06.672
358	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.672	\N	2022-07-01 22:05:06.672
358	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.672	\N	2022-07-01 22:05:06.672
358	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.672	\N	2022-07-01 22:05:06.672
358	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.673	\N	2022-07-01 22:05:06.673
358	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.673	\N	2022-07-01 22:05:06.673
358	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.673	\N	2022-07-01 22:05:06.673
358	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.674	\N	2022-07-01 22:05:06.674
358	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.674	\N	2022-07-01 22:05:06.674
358	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.674	\N	2022-07-01 22:05:06.674
358	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.676	\N	2022-07-01 22:05:06.676
358	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.676	\N	2022-07-01 22:05:06.676
358	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.676	\N	2022-07-01 22:05:06.676
358	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.677	\N	2022-07-01 22:05:06.677
358	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.677	\N	2022-07-01 22:05:06.677
358	300210000	13	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.678	\N	2022-07-01 22:05:06.678
358	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.678	\N	2022-07-01 22:05:06.678
358	300310100	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.678	\N	2022-07-01 22:05:06.678
488	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.303	\N	2022-07-01 22:05:12.303
358	200010000	10	0	2	3	3	0	0	N	\N	2020-06-30 08:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
358	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
358	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.679	\N	2022-07-01 22:05:06.679
358	300310200	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.679	\N	2022-07-01 22:05:06.679
358	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.679	\N	2022-07-01 22:05:06.679
358	300310300	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.68	\N	2022-07-01 22:05:06.68
358	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.68	\N	2022-07-01 22:05:06.68
358	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.68	\N	2022-07-01 22:05:06.68
358	300310500	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.681	\N	2022-07-01 22:05:06.681
358	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.681	\N	2022-07-01 22:05:06.681
358	300310600	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.681	\N	2022-07-01 22:05:06.681
358	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.682	\N	2022-07-01 22:05:06.682
358	300310700	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.682	\N	2022-07-01 22:05:06.682
358	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.682	\N	2022-07-01 22:05:06.682
358	300310800	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.683	\N	2022-07-01 22:05:06.683
358	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.684	\N	2022-07-01 22:05:06.684
358	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.684	\N	2022-07-01 22:05:06.684
358	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.684	\N	2022-07-01 22:05:06.684
358	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.685	\N	2022-07-01 22:05:06.685
358	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:06.685	\N	2022-07-01 22:05:06.685
358	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:06.685	\N	2022-07-01 22:05:06.685
358	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.686	\N	2022-07-01 22:05:06.686
358	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.686	\N	2022-07-01 22:05:06.686
358	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.687	\N	2022-07-01 22:05:06.687
358	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.688	\N	2022-07-01 22:05:06.688
358	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.688	\N	2022-07-01 22:05:06.688
358	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.688	\N	2022-07-01 22:05:06.688
358	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.689	\N	2022-07-01 22:05:06.689
488	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.303	\N	2022-07-01 22:05:12.303
358	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.691	\N	2022-07-01 22:05:06.691
358	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.691	\N	2022-07-01 22:05:06.691
358	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.691	\N	2022-07-01 22:05:06.691
359	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.7	\N	2022-07-01 22:05:06.7
359	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.7	\N	2022-07-01 22:05:06.7
359	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.7	\N	2022-07-01 22:05:06.7
359	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.7	\N	2022-07-01 22:05:06.7
359	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.701	\N	2022-07-01 22:05:06.701
359	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.701	\N	2022-07-01 22:05:06.701
359	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.701	\N	2022-07-01 22:05:06.701
359	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.702	\N	2022-07-01 22:05:06.702
359	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.702	\N	2022-07-01 22:05:06.702
359	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.702	\N	2022-07-01 22:05:06.702
359	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.703	\N	2022-07-01 22:05:06.703
359	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.703	\N	2022-07-01 22:05:06.703
359	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.703	\N	2022-07-01 22:05:06.703
359	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.704	\N	2022-07-01 22:05:06.704
359	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.704	\N	2022-07-01 22:05:06.704
359	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.704	\N	2022-07-01 22:05:06.704
359	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.706	\N	2022-07-01 22:05:06.706
359	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.706	\N	2022-07-01 22:05:06.706
359	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.706	\N	2022-07-01 22:05:06.706
359	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.707	\N	2022-07-01 22:05:06.707
359	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.707	\N	2022-07-01 22:05:06.707
359	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.707	\N	2022-07-01 22:05:06.707
359	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.708	\N	2022-07-01 22:05:06.708
359	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.708	\N	2022-07-01 22:05:06.708
359	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.708	\N	2022-07-01 22:05:06.708
359	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.709	\N	2022-07-01 22:05:06.709
359	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.709	\N	2022-07-01 22:05:06.709
359	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.709	\N	2022-07-01 22:05:06.709
359	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.71	\N	2022-07-01 22:05:06.71
359	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.71	\N	2022-07-01 22:05:06.71
359	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.711	\N	2022-07-01 22:05:06.711
359	200010000	10	0	2	3	3	0	0	N	\N	2020-06-30 08:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
359	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
359	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
359	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.711	\N	2022-07-01 22:05:06.711
359	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.711	\N	2022-07-01 22:05:06.711
359	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:06.712	\N	2022-07-01 22:05:06.712
359	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:06.712	\N	2022-07-01 22:05:06.712
359	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.712	\N	2022-07-01 22:05:06.712
359	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.713	\N	2022-07-01 22:05:06.713
359	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.714	\N	2022-07-01 22:05:06.714
359	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.714	\N	2022-07-01 22:05:06.714
359	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.714	\N	2022-07-01 22:05:06.714
359	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.715	\N	2022-07-01 22:05:06.715
359	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.715	\N	2022-07-01 22:05:06.715
359	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.715	\N	2022-07-01 22:05:06.715
359	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.716	\N	2022-07-01 22:05:06.716
359	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.717	\N	2022-07-01 22:05:06.717
359	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.717	\N	2022-07-01 22:05:06.717
488	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.304	\N	2022-07-01 22:05:12.304
359	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.721	\N	2022-07-01 22:05:06.721
359	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.721	\N	2022-07-01 22:05:06.721
359	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.722	\N	2022-07-01 22:05:06.722
359	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.722	\N	2022-07-01 22:05:06.722
359	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.722	\N	2022-07-01 22:05:06.722
359	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.723	\N	2022-07-01 22:05:06.723
359	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.723	\N	2022-07-01 22:05:06.723
360	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.723	\N	2022-07-01 22:05:06.723
360	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.724	\N	2022-07-01 22:05:06.724
360	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.724	\N	2022-07-01 22:05:06.724
360	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.724	\N	2022-07-01 22:05:06.724
360	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.725	\N	2022-07-01 22:05:06.725
360	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.725	\N	2022-07-01 22:05:06.725
360	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.725	\N	2022-07-01 22:05:06.725
360	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.726	\N	2022-07-01 22:05:06.726
360	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.726	\N	2022-07-01 22:05:06.726
360	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.726	\N	2022-07-01 22:05:06.726
360	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.727	\N	2022-07-01 22:05:06.727
360	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.727	\N	2022-07-01 22:05:06.727
360	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.728	\N	2022-07-01 22:05:06.728
360	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.728	\N	2022-07-01 22:05:06.728
360	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.728	\N	2022-07-01 22:05:06.728
360	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.737	\N	2022-07-01 22:05:06.737
360	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.737	\N	2022-07-01 22:05:06.737
360	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.738	\N	2022-07-01 22:05:06.738
360	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.739	\N	2022-07-01 22:05:06.739
360	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.739	\N	2022-07-01 22:05:06.739
360	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.739	\N	2022-07-01 22:05:06.739
360	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.74	\N	2022-07-01 22:05:06.74
360	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.74	\N	2022-07-01 22:05:06.74
360	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.74	\N	2022-07-01 22:05:06.74
360	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.741	\N	2022-07-01 22:05:06.741
360	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.742	\N	2022-07-01 22:05:06.742
360	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.742	\N	2022-07-01 22:05:06.742
360	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.746	\N	2022-07-01 22:05:06.746
360	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.746	\N	2022-07-01 22:05:06.746
360	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.747	\N	2022-07-01 22:05:06.747
360	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.747	\N	2022-07-01 22:05:06.747
360	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.747	\N	2022-07-01 22:05:06.747
360	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.747	\N	2022-07-01 22:05:06.747
360	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.748	\N	2022-07-01 22:05:06.748
361	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.748	\N	2022-07-01 22:05:06.748
361	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.748	\N	2022-07-01 22:05:06.748
361	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.748	\N	2022-07-01 22:05:06.748
360	401121000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
360	401130000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
361	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.749	\N	2022-07-01 22:05:06.749
361	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.749	\N	2022-07-01 22:05:06.749
361	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.749	\N	2022-07-01 22:05:06.749
361	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.75	\N	2022-07-01 22:05:06.75
488	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.304	\N	2022-07-01 22:05:12.304
362	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.773	\N	2022-07-01 22:05:06.773
361	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.75	\N	2022-07-01 22:05:06.75
361	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.75	\N	2022-07-01 22:05:06.75
361	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.75	\N	2022-07-01 22:05:06.75
361	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.751	\N	2022-07-01 22:05:06.751
361	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.751	\N	2022-07-01 22:05:06.751
361	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.751	\N	2022-07-01 22:05:06.751
361	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.751	\N	2022-07-01 22:05:06.751
361	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.752	\N	2022-07-01 22:05:06.752
361	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.752	\N	2022-07-01 22:05:06.752
361	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.752	\N	2022-07-01 22:05:06.752
361	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.752	\N	2022-07-01 22:05:06.752
361	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.753	\N	2022-07-01 22:05:06.753
361	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.754	\N	2022-07-01 22:05:06.754
361	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.754	\N	2022-07-01 22:05:06.754
361	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.754	\N	2022-07-01 22:05:06.754
361	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.754	\N	2022-07-01 22:05:06.754
361	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.755	\N	2022-07-01 22:05:06.755
361	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.755	\N	2022-07-01 22:05:06.755
361	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.755	\N	2022-07-01 22:05:06.755
361	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.755	\N	2022-07-01 22:05:06.755
361	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.756	\N	2022-07-01 22:05:06.756
361	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.756	\N	2022-07-01 22:05:06.756
361	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.756	\N	2022-07-01 22:05:06.756
361	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.756	\N	2022-07-01 22:05:06.756
361	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.757	\N	2022-07-01 22:05:06.757
361	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.757	\N	2022-07-01 22:05:06.757
361	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.757	\N	2022-07-01 22:05:06.757
361	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.766	\N	2022-07-01 22:05:06.766
362	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.766	\N	2022-07-01 22:05:06.766
362	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.767	\N	2022-07-01 22:05:06.767
362	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.767	\N	2022-07-01 22:05:06.767
362	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.767	\N	2022-07-01 22:05:06.767
362	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.768	\N	2022-07-01 22:05:06.768
362	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.768	\N	2022-07-01 22:05:06.768
362	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.768	\N	2022-07-01 22:05:06.768
362	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.768	\N	2022-07-01 22:05:06.768
362	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.769	\N	2022-07-01 22:05:06.769
489	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.304	\N	2022-07-01 22:05:12.304
353	100011070	10	0	3	3	3	0	0	N	\N	2020-09-02 08:00:00	2022-07-01 22:05:06.25	\N	2022-07-01 22:05:06.25
362	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.769	\N	2022-07-01 22:05:06.769
362	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.769	\N	2022-07-01 22:05:06.769
362	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.769	\N	2022-07-01 22:05:06.769
362	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.77	\N	2022-07-01 22:05:06.77
362	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.77	\N	2022-07-01 22:05:06.77
362	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.77	\N	2022-07-01 22:05:06.77
361	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
362	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.77	\N	2022-07-01 22:05:06.77
362	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.77	\N	2022-07-01 22:05:06.77
362	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.771	\N	2022-07-01 22:05:06.771
362	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.772	\N	2022-07-01 22:05:06.772
362	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.772	\N	2022-07-01 22:05:06.772
362	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.772	\N	2022-07-01 22:05:06.772
362	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.772	\N	2022-07-01 22:05:06.772
362	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.773	\N	2022-07-01 22:05:06.773
362	300210000	13	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.773	\N	2022-07-01 22:05:06.773
362	300310100	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.773	\N	2022-07-01 22:05:06.773
362	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.774	\N	2022-07-01 22:05:06.774
362	300310200	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.774	\N	2022-07-01 22:05:06.774
362	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.774	\N	2022-07-01 22:05:06.774
362	300310300	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.774	\N	2022-07-01 22:05:06.774
362	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.774	\N	2022-07-01 22:05:06.774
362	300310400	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.775	\N	2022-07-01 22:05:06.775
362	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.775	\N	2022-07-01 22:05:06.775
362	300310500	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.775	\N	2022-07-01 22:05:06.775
362	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.775	\N	2022-07-01 22:05:06.775
362	300310600	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.776	\N	2022-07-01 22:05:06.776
362	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.776	\N	2022-07-01 22:05:06.776
362	300310700	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.776	\N	2022-07-01 22:05:06.776
362	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.776	\N	2022-07-01 22:05:06.776
362	300310800	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.777	\N	2022-07-01 22:05:06.777
362	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.777	\N	2022-07-01 22:05:06.777
362	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.778	\N	2022-07-01 22:05:06.778
362	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.778	\N	2022-07-01 22:05:06.778
362	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.778	\N	2022-07-01 22:05:06.778
362	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:06.778	\N	2022-07-01 22:05:06.778
362	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:06.779	\N	2022-07-01 22:05:06.779
362	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.779	\N	2022-07-01 22:05:06.779
362	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.779	\N	2022-07-01 22:05:06.779
362	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.779	\N	2022-07-01 22:05:06.779
362	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.78	\N	2022-07-01 22:05:06.78
362	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.78	\N	2022-07-01 22:05:06.78
362	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.78	\N	2022-07-01 22:05:06.78
362	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.781	\N	2022-07-01 22:05:06.781
362	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.781	\N	2022-07-01 22:05:06.781
362	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.781	\N	2022-07-01 22:05:06.781
362	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.773	\N	2022-07-01 22:05:07.773
362	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.777	\N	2022-07-01 22:05:07.777
362	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.779	\N	2022-07-01 22:05:07.779
362	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.782	\N	2022-07-01 22:05:07.782
362	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.784	\N	2022-07-01 22:05:07.784
362	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.787	\N	2022-07-01 22:05:07.787
363	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.789	\N	2022-07-01 22:05:07.789
363	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.792	\N	2022-07-01 22:05:07.792
363	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.794	\N	2022-07-01 22:05:07.794
363	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.796	\N	2022-07-01 22:05:07.796
489	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.304	\N	2022-07-01 22:05:12.304
363	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.799	\N	2022-07-01 22:05:07.799
363	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.801	\N	2022-07-01 22:05:07.801
363	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.803	\N	2022-07-01 22:05:07.803
363	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.806	\N	2022-07-01 22:05:07.806
363	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.808	\N	2022-07-01 22:05:07.808
363	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.811	\N	2022-07-01 22:05:07.811
363	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.813	\N	2022-07-01 22:05:07.813
363	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.815	\N	2022-07-01 22:05:07.815
362	401130000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
363	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.817	\N	2022-07-01 22:05:07.817
363	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.82	\N	2022-07-01 22:05:07.82
363	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.822	\N	2022-07-01 22:05:07.822
363	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.825	\N	2022-07-01 22:05:07.825
363	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.827	\N	2022-07-01 22:05:07.827
363	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.829	\N	2022-07-01 22:05:07.829
363	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.839	\N	2022-07-01 22:05:07.839
363	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.841	\N	2022-07-01 22:05:07.841
363	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.844	\N	2022-07-01 22:05:07.844
363	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.846	\N	2022-07-01 22:05:07.846
363	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.848	\N	2022-07-01 22:05:07.848
363	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.851	\N	2022-07-01 22:05:07.851
363	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.853	\N	2022-07-01 22:05:07.853
363	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.856	\N	2022-07-01 22:05:07.856
363	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.858	\N	2022-07-01 22:05:07.858
363	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.861	\N	2022-07-01 22:05:07.861
363	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.863	\N	2022-07-01 22:05:07.863
363	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.866	\N	2022-07-01 22:05:07.866
363	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.868	\N	2022-07-01 22:05:07.868
362	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
363	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.87	\N	2022-07-01 22:05:07.87
363	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.875	\N	2022-07-01 22:05:07.875
363	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.877	\N	2022-07-01 22:05:07.877
363	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.88	\N	2022-07-01 22:05:07.88
363	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.882	\N	2022-07-01 22:05:07.882
363	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:07.884	\N	2022-07-01 22:05:07.884
363	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:07.887	\N	2022-07-01 22:05:07.887
363	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.889	\N	2022-07-01 22:05:07.889
363	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.895	\N	2022-07-01 22:05:07.895
363	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.902	\N	2022-07-01 22:05:07.902
363	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.905	\N	2022-07-01 22:05:07.905
363	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.907	\N	2022-07-01 22:05:07.907
363	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.909	\N	2022-07-01 22:05:07.909
363	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.912	\N	2022-07-01 22:05:07.912
363	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.914	\N	2022-07-01 22:05:07.914
363	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.921	\N	2022-07-01 22:05:07.921
363	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.924	\N	2022-07-01 22:05:07.924
363	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.926	\N	2022-07-01 22:05:07.926
363	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.957	\N	2022-07-01 22:05:07.957
363	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.96	\N	2022-07-01 22:05:07.96
363	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.962	\N	2022-07-01 22:05:07.962
363	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.965	\N	2022-07-01 22:05:07.965
363	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.967	\N	2022-07-01 22:05:07.967
363	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.969	\N	2022-07-01 22:05:07.969
363	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.972	\N	2022-07-01 22:05:07.972
364	100011070	10	0	3	3	3	0	0	N	\N	2020-09-02 08:00:00	2022-07-01 22:05:07.974	\N	2022-07-01 22:05:07.974
364	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.977	\N	2022-07-01 22:05:07.977
364	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.979	\N	2022-07-01 22:05:07.979
364	100012050	10	0	3	3	3	0	0	N	\N	2020-09-02 08:00:00	2022-07-01 22:05:07.981	\N	2022-07-01 22:05:07.981
364	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.984	\N	2022-07-01 22:05:07.984
364	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.986	\N	2022-07-01 22:05:07.986
489	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.305	\N	2022-07-01 22:05:12.305
354	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.275	\N	2022-07-01 22:05:06.275
354	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.275	\N	2022-07-01 22:05:06.275
354	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.276	\N	2022-07-01 22:05:06.276
354	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.276	\N	2022-07-01 22:05:06.276
354	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.276	\N	2022-07-01 22:05:06.276
354	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.276	\N	2022-07-01 22:05:06.276
354	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.277	\N	2022-07-01 22:05:06.277
354	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.277	\N	2022-07-01 22:05:06.277
354	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.278	\N	2022-07-01 22:05:06.278
354	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.278	\N	2022-07-01 22:05:06.278
354	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.278	\N	2022-07-01 22:05:06.278
354	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.278	\N	2022-07-01 22:05:06.278
354	300210000	13	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.279	\N	2022-07-01 22:05:06.279
364	100013010	10	0	3	3	3	0	0	N	\N	2020-09-02 08:00:00	2022-07-01 22:05:07.988	\N	2022-07-01 22:05:07.988
364	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.991	\N	2022-07-01 22:05:07.991
364	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.993	\N	2022-07-01 22:05:07.993
364	100014140	10	0	3	3	3	0	0	N	\N	2020-09-02 08:00:00	2022-07-01 22:05:07.996	\N	2022-07-01 22:05:07.996
364	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.998	\N	2022-07-01 22:05:07.998
364	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.1	\N	2022-07-01 22:05:07.1
364	100015010	10	0	3	3	3	0	0	N	\N	2020-09-02 08:00:00	2022-07-01 22:05:07.1	\N	2022-07-01 22:05:07.1
364	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.1	\N	2022-07-01 22:05:07.1
364	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.1	\N	2022-07-01 22:05:07.1
363	401130000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
364	100016010	10	0	3	3	3	0	0	N	\N	2020-09-02 08:00:00	2022-07-01 22:05:07.101	\N	2022-07-01 22:05:07.101
364	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.101	\N	2022-07-01 22:05:07.101
364	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.101	\N	2022-07-01 22:05:07.101
364	300110000	10	0	4	3	3	0	0	N	\N	2020-09-02 08:00:00	2022-07-01 22:05:07.102	\N	2022-07-01 22:05:07.102
364	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.102	\N	2022-07-01 22:05:07.102
364	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.102	\N	2022-07-01 22:05:07.102
364	300210000	10	0	3	3	3	0	0	A	\N	2020-09-02 08:00:00	2022-07-01 22:05:07.103	\N	2022-07-01 22:05:07.103
364	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.103	\N	2022-07-01 22:05:07.103
364	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.103	\N	2022-07-01 22:05:07.103
364	300210000	13	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.103	\N	2022-07-01 22:05:07.103
364	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.104	\N	2022-07-01 22:05:07.104
364	300310100	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.104	\N	2022-07-01 22:05:07.104
364	300310200	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.104	\N	2022-07-01 22:05:07.104
364	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.105	\N	2022-07-01 22:05:07.105
364	300310300	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.105	\N	2022-07-01 22:05:07.105
364	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.105	\N	2022-07-01 22:05:07.105
364	300310400	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.105	\N	2022-07-01 22:05:07.105
364	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.106	\N	2022-07-01 22:05:07.106
364	300310500	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.106	\N	2022-07-01 22:05:07.106
364	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.106	\N	2022-07-01 22:05:07.106
354	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
354	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
363	200010000	10	0	2	3	3	0	0	N	\N	2020-06-30 08:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
363	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
364	300310600	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.106	\N	2022-07-01 22:05:07.106
364	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.107	\N	2022-07-01 22:05:07.107
364	300310700	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.107	\N	2022-07-01 22:05:07.107
364	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.107	\N	2022-07-01 22:05:07.107
364	300310800	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.107	\N	2022-07-01 22:05:07.107
364	300311900	10	0	2	2	2	0	0	*	\N	2020-09-02 08:00:00	2022-07-01 22:05:07.108	\N	2022-07-01 22:05:07.108
364	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.108	\N	2022-07-01 22:05:07.108
364	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.108	\N	2022-07-01 22:05:07.108
364	300312900	10	0	2	2	2	0	0	*	\N	2020-09-02 08:00:00	2022-07-01 22:05:07.109	\N	2022-07-01 22:05:07.109
364	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:07.109	\N	2022-07-01 22:05:07.109
364	401000000	10	0	4	3	3	0	0	A	\N	2020-09-02 08:00:00	2022-07-01 22:05:07.109	\N	2022-07-01 22:05:07.109
364	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.11	\N	2022-07-01 22:05:07.11
364	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.11	\N	2022-07-01 22:05:07.11
364	401231000	10	0	3	3	3	0	0	*	\N	2020-09-02 08:00:00	2022-07-01 22:05:07.111	\N	2022-07-01 22:05:07.111
364	500010000	10	0	2	4	4	0	0	N	\N	2020-09-02 08:00:00	2022-07-01 22:05:07.111	\N	2022-07-01 22:05:07.111
364	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.111	\N	2022-07-01 22:05:07.111
364	500050000	10	0	0	9	9	0	0	*	\N	2020-09-02 08:00:00	2022-07-01 22:05:07.111	\N	2022-07-01 22:05:07.111
364	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.112	\N	2022-07-01 22:05:07.112
364	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.112	\N	2022-07-01 22:05:07.112
364	802000300	10	0	0	9	9	0	0	*	\N	2020-09-02 08:00:00	2022-07-01 22:05:07.113	\N	2022-07-01 22:05:07.113
364	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.113	\N	2022-07-01 22:05:07.113
489	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.305	\N	2022-07-01 22:05:12.305
355	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.3	\N	2022-07-01 22:05:06.3
355	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.3	\N	2022-07-01 22:05:06.3
355	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.301	\N	2022-07-01 22:05:06.301
355	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.301	\N	2022-07-01 22:05:06.301
355	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.301	\N	2022-07-01 22:05:06.301
355	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.301	\N	2022-07-01 22:05:06.301
355	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.302	\N	2022-07-01 22:05:06.302
355	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.302	\N	2022-07-01 22:05:06.302
355	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.302	\N	2022-07-01 22:05:06.302
355	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.303	\N	2022-07-01 22:05:06.303
355	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.303	\N	2022-07-01 22:05:06.303
355	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.303	\N	2022-07-01 22:05:06.303
355	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.303	\N	2022-07-01 22:05:06.303
355	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.304	\N	2022-07-01 22:05:06.304
355	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.304	\N	2022-07-01 22:05:06.304
355	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.304	\N	2022-07-01 22:05:06.304
355	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.305	\N	2022-07-01 22:05:06.305
355	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.305	\N	2022-07-01 22:05:06.305
355	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:06.305	\N	2022-07-01 22:05:06.305
355	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:06.305	\N	2022-07-01 22:05:06.305
355	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.306	\N	2022-07-01 22:05:06.306
355	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.306	\N	2022-07-01 22:05:06.306
355	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.306	\N	2022-07-01 22:05:06.306
355	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.307	\N	2022-07-01 22:05:06.307
355	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.307	\N	2022-07-01 22:05:06.307
355	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.307	\N	2022-07-01 22:05:06.307
355	401130000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
364	401121000	10	0	3	8	0	0	6	A	\N	2020-09-02 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
355	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.308	\N	2022-07-01 22:05:06.308
356	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.631	\N	2022-07-01 22:05:06.631
356	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.632	\N	2022-07-01 22:05:06.632
356	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:06.632	\N	2022-07-01 22:05:06.632
356	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:06.632	\N	2022-07-01 22:05:06.632
356	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.633	\N	2022-07-01 22:05:06.633
356	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.633	\N	2022-07-01 22:05:06.633
356	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.634	\N	2022-07-01 22:05:06.634
356	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.635	\N	2022-07-01 22:05:06.635
364	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.113	\N	2022-07-01 22:05:07.113
364	843020100	10	0	3	4	4	0	0	*	\N	2020-09-02 08:00:00	2022-07-01 22:05:07.117	\N	2022-07-01 22:05:07.117
364	850010100	10	0	2	2	2	0	0	*	\N	2020-09-02 08:00:00	2022-07-01 22:05:07.118	\N	2022-07-01 22:05:07.118
364	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.118	\N	2022-07-01 22:05:07.118
364	850030100	10	0	2	2	2	0	0	*	\N	2020-09-02 08:00:00	2022-07-01 22:05:07.118	\N	2022-07-01 22:05:07.118
364	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.119	\N	2022-07-01 22:05:07.119
364	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.119	\N	2022-07-01 22:05:07.119
365	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.119	\N	2022-07-01 22:05:07.119
365	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.119	\N	2022-07-01 22:05:07.119
365	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.125	\N	2022-07-01 22:05:07.125
365	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.125	\N	2022-07-01 22:05:07.125
365	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.125	\N	2022-07-01 22:05:07.125
365	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.126	\N	2022-07-01 22:05:07.126
355	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
355	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
364	200010000	10	0	2	3	3	0	0	N	\N	2020-09-02 08:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
364	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
364	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
365	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.126	\N	2022-07-01 22:05:07.126
365	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.126	\N	2022-07-01 22:05:07.126
489	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.305	\N	2022-07-01 22:05:12.305
356	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.636	\N	2022-07-01 22:05:06.636
356	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.636	\N	2022-07-01 22:05:06.636
356	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.637	\N	2022-07-01 22:05:06.637
356	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.637	\N	2022-07-01 22:05:06.637
356	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.638	\N	2022-07-01 22:05:06.638
365	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.126	\N	2022-07-01 22:05:07.126
365	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.126	\N	2022-07-01 22:05:07.126
365	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.127	\N	2022-07-01 22:05:07.127
365	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.127	\N	2022-07-01 22:05:07.127
365	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.127	\N	2022-07-01 22:05:07.127
365	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.127	\N	2022-07-01 22:05:07.127
365	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.128	\N	2022-07-01 22:05:07.128
365	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.128	\N	2022-07-01 22:05:07.128
365	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.128	\N	2022-07-01 22:05:07.128
365	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.129	\N	2022-07-01 22:05:07.129
365	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.129	\N	2022-07-01 22:05:07.129
365	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.129	\N	2022-07-01 22:05:07.129
365	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:07.129	\N	2022-07-01 22:05:07.129
365	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:07.13	\N	2022-07-01 22:05:07.13
365	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.13	\N	2022-07-01 22:05:07.13
365	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.13	\N	2022-07-01 22:05:07.13
365	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.131	\N	2022-07-01 22:05:07.131
365	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.131	\N	2022-07-01 22:05:07.131
365	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.131	\N	2022-07-01 22:05:07.131
365	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.132	\N	2022-07-01 22:05:07.132
365	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.132	\N	2022-07-01 22:05:07.132
365	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.132	\N	2022-07-01 22:05:07.132
365	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.132	\N	2022-07-01 22:05:07.132
365	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.133	\N	2022-07-01 22:05:07.133
365	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.133	\N	2022-07-01 22:05:07.133
365	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.134	\N	2022-07-01 22:05:07.134
365	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.137	\N	2022-07-01 22:05:07.137
365	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.137	\N	2022-07-01 22:05:07.137
365	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.138	\N	2022-07-01 22:05:07.138
365	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.138	\N	2022-07-01 22:05:07.138
365	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.138	\N	2022-07-01 22:05:07.138
365	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.138	\N	2022-07-01 22:05:07.138
365	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.138	\N	2022-07-01 22:05:07.138
366	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.139	\N	2022-07-01 22:05:07.139
366	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.139	\N	2022-07-01 22:05:07.139
366	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.139	\N	2022-07-01 22:05:07.139
366	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.139	\N	2022-07-01 22:05:07.139
366	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.14	\N	2022-07-01 22:05:07.14
366	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.14	\N	2022-07-01 22:05:07.14
366	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.14	\N	2022-07-01 22:05:07.14
489	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.305	\N	2022-07-01 22:05:12.305
489	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.305	\N	2022-07-01 22:05:12.305
366	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.141	\N	2022-07-01 22:05:07.141
366	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.141	\N	2022-07-01 22:05:07.141
356	401130000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
365	401121000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
366	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.141	\N	2022-07-01 22:05:07.141
366	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.142	\N	2022-07-01 22:05:07.142
366	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.142	\N	2022-07-01 22:05:07.142
366	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.142	\N	2022-07-01 22:05:07.142
366	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.142	\N	2022-07-01 22:05:07.142
366	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.143	\N	2022-07-01 22:05:07.143
366	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.143	\N	2022-07-01 22:05:07.143
366	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.144	\N	2022-07-01 22:05:07.144
366	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.144	\N	2022-07-01 22:05:07.144
366	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.144	\N	2022-07-01 22:05:07.144
366	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.155	\N	2022-07-01 22:05:07.155
366	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.156	\N	2022-07-01 22:05:07.156
366	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.156	\N	2022-07-01 22:05:07.156
366	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.156	\N	2022-07-01 22:05:07.156
366	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.156	\N	2022-07-01 22:05:07.156
366	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.157	\N	2022-07-01 22:05:07.157
366	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.157	\N	2022-07-01 22:05:07.157
367	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.157	\N	2022-07-01 22:05:07.157
367	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.157	\N	2022-07-01 22:05:07.157
367	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.158	\N	2022-07-01 22:05:07.158
367	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.158	\N	2022-07-01 22:05:07.158
367	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.158	\N	2022-07-01 22:05:07.158
367	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.158	\N	2022-07-01 22:05:07.158
367	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.159	\N	2022-07-01 22:05:07.159
365	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
367	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.159	\N	2022-07-01 22:05:07.159
367	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.159	\N	2022-07-01 22:05:07.159
367	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.159	\N	2022-07-01 22:05:07.159
367	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.16	\N	2022-07-01 22:05:07.16
367	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.16	\N	2022-07-01 22:05:07.16
367	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.16	\N	2022-07-01 22:05:07.16
367	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.16	\N	2022-07-01 22:05:07.16
367	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.161	\N	2022-07-01 22:05:07.161
367	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.161	\N	2022-07-01 22:05:07.161
367	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.161	\N	2022-07-01 22:05:07.161
367	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.162	\N	2022-07-01 22:05:07.162
367	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.162	\N	2022-07-01 22:05:07.162
367	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.163	\N	2022-07-01 22:05:07.163
367	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.163	\N	2022-07-01 22:05:07.163
367	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.163	\N	2022-07-01 22:05:07.163
367	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.163	\N	2022-07-01 22:05:07.163
367	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.163	\N	2022-07-01 22:05:07.163
367	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.164	\N	2022-07-01 22:05:07.164
367	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.164	\N	2022-07-01 22:05:07.164
367	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.164	\N	2022-07-01 22:05:07.164
367	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.164	\N	2022-07-01 22:05:07.164
367	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.165	\N	2022-07-01 22:05:07.165
367	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.165	\N	2022-07-01 22:05:07.165
367	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.165	\N	2022-07-01 22:05:07.165
367	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.166	\N	2022-07-01 22:05:07.166
367	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.166	\N	2022-07-01 22:05:07.166
367	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.166	\N	2022-07-01 22:05:07.166
367	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.166	\N	2022-07-01 22:05:07.166
367	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:07.167	\N	2022-07-01 22:05:07.167
367	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:07.167	\N	2022-07-01 22:05:07.167
367	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.167	\N	2022-07-01 22:05:07.167
367	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.167	\N	2022-07-01 22:05:07.167
367	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.168	\N	2022-07-01 22:05:07.168
367	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.168	\N	2022-07-01 22:05:07.168
489	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.306	\N	2022-07-01 22:05:12.306
358	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.697	\N	2022-07-01 22:05:06.697
358	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.698	\N	2022-07-01 22:05:06.698
358	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.698	\N	2022-07-01 22:05:06.698
358	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.698	\N	2022-07-01 22:05:06.698
358	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.699	\N	2022-07-01 22:05:06.699
359	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.699	\N	2022-07-01 22:05:06.699
359	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.699	\N	2022-07-01 22:05:06.699
367	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.168	\N	2022-07-01 22:05:07.168
368	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.175	\N	2022-07-01 22:05:07.175
368	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.176	\N	2022-07-01 22:05:07.176
368	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.176	\N	2022-07-01 22:05:07.176
368	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.176	\N	2022-07-01 22:05:07.176
368	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.176	\N	2022-07-01 22:05:07.176
368	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.177	\N	2022-07-01 22:05:07.177
367	401130000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
368	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.177	\N	2022-07-01 22:05:07.177
368	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.177	\N	2022-07-01 22:05:07.177
368	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.178	\N	2022-07-01 22:05:07.178
368	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.178	\N	2022-07-01 22:05:07.178
368	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.178	\N	2022-07-01 22:05:07.178
368	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.179	\N	2022-07-01 22:05:07.179
368	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.179	\N	2022-07-01 22:05:07.179
368	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.179	\N	2022-07-01 22:05:07.179
368	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.179	\N	2022-07-01 22:05:07.179
368	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.179	\N	2022-07-01 22:05:07.179
368	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.18	\N	2022-07-01 22:05:07.18
368	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.181	\N	2022-07-01 22:05:07.181
368	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.181	\N	2022-07-01 22:05:07.181
368	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.181	\N	2022-07-01 22:05:07.181
368	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.181	\N	2022-07-01 22:05:07.181
368	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.182	\N	2022-07-01 22:05:07.182
368	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.182	\N	2022-07-01 22:05:07.182
368	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.182	\N	2022-07-01 22:05:07.182
368	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.182	\N	2022-07-01 22:05:07.182
368	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.183	\N	2022-07-01 22:05:07.183
368	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.183	\N	2022-07-01 22:05:07.183
368	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.183	\N	2022-07-01 22:05:07.183
368	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.183	\N	2022-07-01 22:05:07.183
368	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.184	\N	2022-07-01 22:05:07.184
366	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
366	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
367	200010000	10	0	2	3	3	0	0	N	\N	2020-06-30 08:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
367	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
367	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
368	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.184	\N	2022-07-01 22:05:07.184
368	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.184	\N	2022-07-01 22:05:07.184
368	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.185	\N	2022-07-01 22:05:07.185
368	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:07.185	\N	2022-07-01 22:05:07.185
368	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:07.185	\N	2022-07-01 22:05:07.185
368	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.185	\N	2022-07-01 22:05:07.185
368	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.186	\N	2022-07-01 22:05:07.186
368	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.186	\N	2022-07-01 22:05:07.186
368	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.187	\N	2022-07-01 22:05:07.187
368	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.187	\N	2022-07-01 22:05:07.187
368	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.187	\N	2022-07-01 22:05:07.187
368	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.187	\N	2022-07-01 22:05:07.187
368	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.188	\N	2022-07-01 22:05:07.188
368	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.188	\N	2022-07-01 22:05:07.188
368	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.189	\N	2022-07-01 22:05:07.189
368	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.189	\N	2022-07-01 22:05:07.189
368	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.192	\N	2022-07-01 22:05:07.192
368	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.192	\N	2022-07-01 22:05:07.192
368	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.192	\N	2022-07-01 22:05:07.192
368	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.192	\N	2022-07-01 22:05:07.192
489	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.306	\N	2022-07-01 22:05:12.306
360	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.73	\N	2022-07-01 22:05:06.73
360	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.731	\N	2022-07-01 22:05:06.731
360	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.731	\N	2022-07-01 22:05:06.731
360	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.731	\N	2022-07-01 22:05:06.731
360	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.732	\N	2022-07-01 22:05:06.732
360	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.732	\N	2022-07-01 22:05:06.732
360	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.732	\N	2022-07-01 22:05:06.732
360	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.733	\N	2022-07-01 22:05:06.733
360	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.733	\N	2022-07-01 22:05:06.733
360	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.733	\N	2022-07-01 22:05:06.733
360	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.733	\N	2022-07-01 22:05:06.733
360	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.734	\N	2022-07-01 22:05:06.734
360	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.734	\N	2022-07-01 22:05:06.734
360	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.735	\N	2022-07-01 22:05:06.735
360	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.735	\N	2022-07-01 22:05:06.735
360	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.736	\N	2022-07-01 22:05:06.736
360	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.736	\N	2022-07-01 22:05:06.736
360	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:06.736	\N	2022-07-01 22:05:06.736
360	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:06.737	\N	2022-07-01 22:05:06.737
368	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.193	\N	2022-07-01 22:05:07.193
369	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.195	\N	2022-07-01 22:05:07.195
369	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.196	\N	2022-07-01 22:05:07.196
369	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.196	\N	2022-07-01 22:05:07.196
369	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.196	\N	2022-07-01 22:05:07.196
369	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.196	\N	2022-07-01 22:05:07.196
369	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.197	\N	2022-07-01 22:05:07.197
368	401130000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
369	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.197	\N	2022-07-01 22:05:07.197
369	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.197	\N	2022-07-01 22:05:07.197
369	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.197	\N	2022-07-01 22:05:07.197
369	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.197	\N	2022-07-01 22:05:07.197
369	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.198	\N	2022-07-01 22:05:07.198
369	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.199	\N	2022-07-01 22:05:07.199
369	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.199	\N	2022-07-01 22:05:07.199
369	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.199	\N	2022-07-01 22:05:07.199
369	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.2	\N	2022-07-01 22:05:07.2
369	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.2	\N	2022-07-01 22:05:07.2
369	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.2	\N	2022-07-01 22:05:07.2
369	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.2	\N	2022-07-01 22:05:07.2
369	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.201	\N	2022-07-01 22:05:07.201
369	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.201	\N	2022-07-01 22:05:07.201
369	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.201	\N	2022-07-01 22:05:07.201
369	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.201	\N	2022-07-01 22:05:07.201
369	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.202	\N	2022-07-01 22:05:07.202
369	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.202	\N	2022-07-01 22:05:07.202
369	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.202	\N	2022-07-01 22:05:07.202
369	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.203	\N	2022-07-01 22:05:07.203
369	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.203	\N	2022-07-01 22:05:07.203
369	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:07.203	\N	2022-07-01 22:05:07.203
369	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:07.203	\N	2022-07-01 22:05:07.203
369	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.203	\N	2022-07-01 22:05:07.203
369	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.204	\N	2022-07-01 22:05:07.204
369	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.204	\N	2022-07-01 22:05:07.204
360	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
368	200010000	10	0	2	3	3	0	0	N	\N	2020-06-30 08:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
368	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
368	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
369	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.205	\N	2022-07-01 22:05:07.205
369	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.205	\N	2022-07-01 22:05:07.205
369	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.205	\N	2022-07-01 22:05:07.205
369	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.205	\N	2022-07-01 22:05:07.205
369	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.206	\N	2022-07-01 22:05:07.206
369	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.206	\N	2022-07-01 22:05:07.206
369	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.207	\N	2022-07-01 22:05:07.207
369	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.208	\N	2022-07-01 22:05:07.208
369	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.208	\N	2022-07-01 22:05:07.208
489	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.306	\N	2022-07-01 22:05:12.306
361	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:06.758	\N	2022-07-01 22:05:06.758
361	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.758	\N	2022-07-01 22:05:06.758
361	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.758	\N	2022-07-01 22:05:06.758
361	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.759	\N	2022-07-01 22:05:06.759
361	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.759	\N	2022-07-01 22:05:06.759
361	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.76	\N	2022-07-01 22:05:06.76
361	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.76	\N	2022-07-01 22:05:06.76
361	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.76	\N	2022-07-01 22:05:06.76
361	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.76	\N	2022-07-01 22:05:06.76
361	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.761	\N	2022-07-01 22:05:06.761
361	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.761	\N	2022-07-01 22:05:06.761
361	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.762	\N	2022-07-01 22:05:06.762
361	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.765	\N	2022-07-01 22:05:06.765
361	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.765	\N	2022-07-01 22:05:06.765
361	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.765	\N	2022-07-01 22:05:06.765
361	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.766	\N	2022-07-01 22:05:06.766
361	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.766	\N	2022-07-01 22:05:06.766
361	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.766	\N	2022-07-01 22:05:06.766
362	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:06.782	\N	2022-07-01 22:05:06.782
362	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.782	\N	2022-07-01 22:05:06.782
362	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:06.783	\N	2022-07-01 22:05:06.783
369	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.212	\N	2022-07-01 22:05:07.212
369	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.212	\N	2022-07-01 22:05:07.212
369	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.213	\N	2022-07-01 22:05:07.213
369	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.213	\N	2022-07-01 22:05:07.213
369	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.213	\N	2022-07-01 22:05:07.213
369	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.711	\N	2022-07-01 22:05:07.711
369	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.712	\N	2022-07-01 22:05:07.712
370	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.712	\N	2022-07-01 22:05:07.712
370	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.713	\N	2022-07-01 22:05:07.713
370	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.713	\N	2022-07-01 22:05:07.713
370	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.713	\N	2022-07-01 22:05:07.713
370	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.713	\N	2022-07-01 22:05:07.713
370	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.714	\N	2022-07-01 22:05:07.714
370	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.714	\N	2022-07-01 22:05:07.714
370	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.714	\N	2022-07-01 22:05:07.714
370	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.715	\N	2022-07-01 22:05:07.715
370	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.715	\N	2022-07-01 22:05:07.715
361	401130000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
370	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.715	\N	2022-07-01 22:05:07.715
370	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.716	\N	2022-07-01 22:05:07.716
370	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.716	\N	2022-07-01 22:05:07.716
489	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.307	\N	2022-07-01 22:05:12.307
370	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.717	\N	2022-07-01 22:05:07.717
370	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.717	\N	2022-07-01 22:05:07.717
370	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.719	\N	2022-07-01 22:05:07.719
370	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.719	\N	2022-07-01 22:05:07.719
370	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.721	\N	2022-07-01 22:05:07.721
370	300310200	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.722	\N	2022-07-01 22:05:07.722
370	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.722	\N	2022-07-01 22:05:07.722
370	300310300	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.722	\N	2022-07-01 22:05:07.722
370	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.723	\N	2022-07-01 22:05:07.723
370	300310400	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.723	\N	2022-07-01 22:05:07.723
370	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.723	\N	2022-07-01 22:05:07.723
370	300310500	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.724	\N	2022-07-01 22:05:07.724
370	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.724	\N	2022-07-01 22:05:07.724
370	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.725	\N	2022-07-01 22:05:07.725
370	300310700	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.725	\N	2022-07-01 22:05:07.725
370	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.725	\N	2022-07-01 22:05:07.725
370	300310800	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.726	\N	2022-07-01 22:05:07.726
370	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.727	\N	2022-07-01 22:05:07.727
370	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.727	\N	2022-07-01 22:05:07.727
370	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.727	\N	2022-07-01 22:05:07.727
370	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.728	\N	2022-07-01 22:05:07.728
370	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:07.728	\N	2022-07-01 22:05:07.728
370	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:07.728	\N	2022-07-01 22:05:07.728
369	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
369	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
370	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.729	\N	2022-07-01 22:05:07.729
370	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.729	\N	2022-07-01 22:05:07.729
370	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.729	\N	2022-07-01 22:05:07.729
370	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.73	\N	2022-07-01 22:05:07.73
370	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.731	\N	2022-07-01 22:05:07.731
370	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.731	\N	2022-07-01 22:05:07.731
370	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.732	\N	2022-07-01 22:05:07.732
370	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.732	\N	2022-07-01 22:05:07.732
370	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.733	\N	2022-07-01 22:05:07.733
370	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.734	\N	2022-07-01 22:05:07.734
370	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.734	\N	2022-07-01 22:05:07.734
370	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.74	\N	2022-07-01 22:05:07.74
370	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.741	\N	2022-07-01 22:05:07.741
370	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.741	\N	2022-07-01 22:05:07.741
370	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.741	\N	2022-07-01 22:05:07.741
370	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.742	\N	2022-07-01 22:05:07.742
370	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.742	\N	2022-07-01 22:05:07.742
371	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.742	\N	2022-07-01 22:05:07.742
371	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.743	\N	2022-07-01 22:05:07.743
371	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.743	\N	2022-07-01 22:05:07.743
371	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.743	\N	2022-07-01 22:05:07.743
371	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.744	\N	2022-07-01 22:05:07.744
371	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.744	\N	2022-07-01 22:05:07.744
371	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.744	\N	2022-07-01 22:05:07.744
371	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.745	\N	2022-07-01 22:05:07.745
371	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.746	\N	2022-07-01 22:05:07.746
371	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.746	\N	2022-07-01 22:05:07.746
489	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.307	\N	2022-07-01 22:05:12.307
371	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.747	\N	2022-07-01 22:05:07.747
371	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.747	\N	2022-07-01 22:05:07.747
371	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.748	\N	2022-07-01 22:05:07.748
371	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.748	\N	2022-07-01 22:05:07.748
371	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.748	\N	2022-07-01 22:05:07.748
371	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.749	\N	2022-07-01 22:05:07.749
371	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.75	\N	2022-07-01 22:05:07.75
371	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.75	\N	2022-07-01 22:05:07.75
371	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.75	\N	2022-07-01 22:05:07.75
371	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.751	\N	2022-07-01 22:05:07.751
371	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.751	\N	2022-07-01 22:05:07.751
371	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.751	\N	2022-07-01 22:05:07.751
371	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.752	\N	2022-07-01 22:05:07.752
371	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.752	\N	2022-07-01 22:05:07.752
371	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.753	\N	2022-07-01 22:05:07.753
371	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.761	\N	2022-07-01 22:05:07.761
370	401130000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
371	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.761	\N	2022-07-01 22:05:07.761
371	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.766	\N	2022-07-01 22:05:07.766
371	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.766	\N	2022-07-01 22:05:07.766
371	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.767	\N	2022-07-01 22:05:07.767
371	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.767	\N	2022-07-01 22:05:07.767
371	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.767	\N	2022-07-01 22:05:07.767
371	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.767	\N	2022-07-01 22:05:07.767
371	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.768	\N	2022-07-01 22:05:07.768
372	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.769	\N	2022-07-01 22:05:07.769
372	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.769	\N	2022-07-01 22:05:07.769
372	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.77	\N	2022-07-01 22:05:07.77
372	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.77	\N	2022-07-01 22:05:07.77
372	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.77	\N	2022-07-01 22:05:07.77
372	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.771	\N	2022-07-01 22:05:07.771
372	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.771	\N	2022-07-01 22:05:07.771
372	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.771	\N	2022-07-01 22:05:07.771
372	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.772	\N	2022-07-01 22:05:07.772
372	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.772	\N	2022-07-01 22:05:07.772
372	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.772	\N	2022-07-01 22:05:07.772
372	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.773	\N	2022-07-01 22:05:07.773
372	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.773	\N	2022-07-01 22:05:07.773
372	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.773	\N	2022-07-01 22:05:07.773
372	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.774	\N	2022-07-01 22:05:07.774
372	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.774	\N	2022-07-01 22:05:07.774
372	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.774	\N	2022-07-01 22:05:07.774
372	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.775	\N	2022-07-01 22:05:07.775
372	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.776	\N	2022-07-01 22:05:07.776
372	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.776	\N	2022-07-01 22:05:07.776
372	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.776	\N	2022-07-01 22:05:07.776
372	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.777	\N	2022-07-01 22:05:07.777
372	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.777	\N	2022-07-01 22:05:07.777
370	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
371	200010000	10	0	2	3	3	0	0	N	\N	2020-06-30 08:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
371	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
371	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
372	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.778	\N	2022-07-01 22:05:07.778
372	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.778	\N	2022-07-01 22:05:07.778
372	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.778	\N	2022-07-01 22:05:07.778
372	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.779	\N	2022-07-01 22:05:07.779
372	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.779	\N	2022-07-01 22:05:07.779
372	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.779	\N	2022-07-01 22:05:07.779
372	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.78	\N	2022-07-01 22:05:07.78
372	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.78	\N	2022-07-01 22:05:07.78
372	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.781	\N	2022-07-01 22:05:07.781
489	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.307	\N	2022-07-01 22:05:12.307
365	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.121	\N	2022-07-01 22:05:07.121
365	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.121	\N	2022-07-01 22:05:07.121
365	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.121	\N	2022-07-01 22:05:07.121
365	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.121	\N	2022-07-01 22:05:07.121
365	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.122	\N	2022-07-01 22:05:07.122
365	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.122	\N	2022-07-01 22:05:07.122
365	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.122	\N	2022-07-01 22:05:07.122
365	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.122	\N	2022-07-01 22:05:07.122
365	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.123	\N	2022-07-01 22:05:07.123
365	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.123	\N	2022-07-01 22:05:07.123
365	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.123	\N	2022-07-01 22:05:07.123
365	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.123	\N	2022-07-01 22:05:07.123
365	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.124	\N	2022-07-01 22:05:07.124
365	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.124	\N	2022-07-01 22:05:07.124
372	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.781	\N	2022-07-01 22:05:07.781
372	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.782	\N	2022-07-01 22:05:07.782
372	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:07.782	\N	2022-07-01 22:05:07.782
372	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:07.783	\N	2022-07-01 22:05:07.783
372	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.783	\N	2022-07-01 22:05:07.783
372	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.784	\N	2022-07-01 22:05:07.784
372	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.784	\N	2022-07-01 22:05:07.784
372	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.785	\N	2022-07-01 22:05:07.785
372	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.785	\N	2022-07-01 22:05:07.785
372	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.786	\N	2022-07-01 22:05:07.786
372	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.786	\N	2022-07-01 22:05:07.786
372	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.786	\N	2022-07-01 22:05:07.786
373	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.8	\N	2022-07-01 22:05:07.8
373	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.8	\N	2022-07-01 22:05:07.8
373	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.801	\N	2022-07-01 22:05:07.801
373	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.801	\N	2022-07-01 22:05:07.801
373	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.801	\N	2022-07-01 22:05:07.801
372	401130000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
373	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.803	\N	2022-07-01 22:05:07.803
373	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.803	\N	2022-07-01 22:05:07.803
373	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.803	\N	2022-07-01 22:05:07.803
373	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.804	\N	2022-07-01 22:05:07.804
373	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.804	\N	2022-07-01 22:05:07.804
373	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.805	\N	2022-07-01 22:05:07.805
373	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.805	\N	2022-07-01 22:05:07.805
373	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.805	\N	2022-07-01 22:05:07.805
373	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.806	\N	2022-07-01 22:05:07.806
373	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.806	\N	2022-07-01 22:05:07.806
373	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.806	\N	2022-07-01 22:05:07.806
373	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.807	\N	2022-07-01 22:05:07.807
373	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.807	\N	2022-07-01 22:05:07.807
373	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.808	\N	2022-07-01 22:05:07.808
373	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.808	\N	2022-07-01 22:05:07.808
373	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.808	\N	2022-07-01 22:05:07.808
373	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.808	\N	2022-07-01 22:05:07.808
373	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:07.809	\N	2022-07-01 22:05:07.809
373	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:07.809	\N	2022-07-01 22:05:07.809
373	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.809	\N	2022-07-01 22:05:07.809
373	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.81	\N	2022-07-01 22:05:07.81
373	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.81	\N	2022-07-01 22:05:07.81
373	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.811	\N	2022-07-01 22:05:07.811
373	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.812	\N	2022-07-01 22:05:07.812
373	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.812	\N	2022-07-01 22:05:07.812
373	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.812	\N	2022-07-01 22:05:07.812
373	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.813	\N	2022-07-01 22:05:07.813
373	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.814	\N	2022-07-01 22:05:07.814
373	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.814	\N	2022-07-01 22:05:07.814
373	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.814	\N	2022-07-01 22:05:07.814
489	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.307	\N	2022-07-01 22:05:12.307
366	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.145	\N	2022-07-01 22:05:07.145
372	200010000	10	0	2	3	3	0	0	N	\N	2020-06-30 08:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
372	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
372	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
373	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
366	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.145	\N	2022-07-01 22:05:07.145
366	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.146	\N	2022-07-01 22:05:07.146
366	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.146	\N	2022-07-01 22:05:07.146
366	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.146	\N	2022-07-01 22:05:07.146
366	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.146	\N	2022-07-01 22:05:07.146
366	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.146	\N	2022-07-01 22:05:07.146
366	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.147	\N	2022-07-01 22:05:07.147
366	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.147	\N	2022-07-01 22:05:07.147
366	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.147	\N	2022-07-01 22:05:07.147
366	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.148	\N	2022-07-01 22:05:07.148
366	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.148	\N	2022-07-01 22:05:07.148
366	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.148	\N	2022-07-01 22:05:07.148
366	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:07.149	\N	2022-07-01 22:05:07.149
366	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.149	\N	2022-07-01 22:05:07.149
366	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.149	\N	2022-07-01 22:05:07.149
366	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.149	\N	2022-07-01 22:05:07.149
366	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.15	\N	2022-07-01 22:05:07.15
366	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.15	\N	2022-07-01 22:05:07.15
366	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.151	\N	2022-07-01 22:05:07.151
366	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.151	\N	2022-07-01 22:05:07.151
366	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.151	\N	2022-07-01 22:05:07.151
366	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.151	\N	2022-07-01 22:05:07.151
366	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.152	\N	2022-07-01 22:05:07.152
366	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.152	\N	2022-07-01 22:05:07.152
366	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.153	\N	2022-07-01 22:05:07.153
367	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.169	\N	2022-07-01 22:05:07.169
367	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.169	\N	2022-07-01 22:05:07.169
367	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.169	\N	2022-07-01 22:05:07.169
367	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.169	\N	2022-07-01 22:05:07.169
367	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.17	\N	2022-07-01 22:05:07.17
367	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.171	\N	2022-07-01 22:05:07.171
367	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.173	\N	2022-07-01 22:05:07.173
367	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.174	\N	2022-07-01 22:05:07.174
367	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.174	\N	2022-07-01 22:05:07.174
367	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.174	\N	2022-07-01 22:05:07.174
373	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.819	\N	2022-07-01 22:05:07.819
373	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.819	\N	2022-07-01 22:05:07.819
373	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.82	\N	2022-07-01 22:05:07.82
373	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.82	\N	2022-07-01 22:05:07.82
374	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.828	\N	2022-07-01 22:05:07.828
366	401130000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
373	401130000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
374	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.829	\N	2022-07-01 22:05:07.829
374	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.829	\N	2022-07-01 22:05:07.829
374	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.83	\N	2022-07-01 22:05:07.83
374	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.83	\N	2022-07-01 22:05:07.83
374	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.83	\N	2022-07-01 22:05:07.83
489	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.307	\N	2022-07-01 22:05:12.307
367	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.175	\N	2022-07-01 22:05:07.175
368	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.175	\N	2022-07-01 22:05:07.175
368	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.193	\N	2022-07-01 22:05:07.193
368	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.193	\N	2022-07-01 22:05:07.193
369	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.193	\N	2022-07-01 22:05:07.193
369	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.194	\N	2022-07-01 22:05:07.194
369	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.194	\N	2022-07-01 22:05:07.194
369	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.194	\N	2022-07-01 22:05:07.194
369	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.194	\N	2022-07-01 22:05:07.194
369	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.195	\N	2022-07-01 22:05:07.195
369	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.195	\N	2022-07-01 22:05:07.195
369	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.195	\N	2022-07-01 22:05:07.195
374	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.831	\N	2022-07-01 22:05:07.831
374	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.831	\N	2022-07-01 22:05:07.831
374	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.831	\N	2022-07-01 22:05:07.831
374	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.832	\N	2022-07-01 22:05:07.832
374	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.832	\N	2022-07-01 22:05:07.832
374	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.833	\N	2022-07-01 22:05:07.833
374	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.833	\N	2022-07-01 22:05:07.833
374	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.833	\N	2022-07-01 22:05:07.833
374	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.834	\N	2022-07-01 22:05:07.834
374	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.834	\N	2022-07-01 22:05:07.834
374	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.835	\N	2022-07-01 22:05:07.835
374	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.835	\N	2022-07-01 22:05:07.835
374	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:07.835	\N	2022-07-01 22:05:07.835
374	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:07.836	\N	2022-07-01 22:05:07.836
374	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.836	\N	2022-07-01 22:05:07.836
374	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.836	\N	2022-07-01 22:05:07.836
374	200010000	10	0	2	3	3	0	0	N	\N	2020-06-30 08:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
374	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
374	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.837	\N	2022-07-01 22:05:07.837
374	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.838	\N	2022-07-01 22:05:07.838
374	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.838	\N	2022-07-01 22:05:07.838
374	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.838	\N	2022-07-01 22:05:07.838
374	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.839	\N	2022-07-01 22:05:07.839
374	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.839	\N	2022-07-01 22:05:07.839
374	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.839	\N	2022-07-01 22:05:07.839
374	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.84	\N	2022-07-01 22:05:07.84
374	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.841	\N	2022-07-01 22:05:07.841
374	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.841	\N	2022-07-01 22:05:07.841
374	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.845	\N	2022-07-01 22:05:07.845
374	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.845	\N	2022-07-01 22:05:07.845
374	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.846	\N	2022-07-01 22:05:07.846
374	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.846	\N	2022-07-01 22:05:07.846
374	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.847	\N	2022-07-01 22:05:07.847
374	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.847	\N	2022-07-01 22:05:07.847
374	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.848	\N	2022-07-01 22:05:07.848
375	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.848	\N	2022-07-01 22:05:07.848
375	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.848	\N	2022-07-01 22:05:07.848
375	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.849	\N	2022-07-01 22:05:07.849
375	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.849	\N	2022-07-01 22:05:07.849
375	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.85	\N	2022-07-01 22:05:07.85
375	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.85	\N	2022-07-01 22:05:07.85
375	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.85	\N	2022-07-01 22:05:07.85
375	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.851	\N	2022-07-01 22:05:07.851
375	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.851	\N	2022-07-01 22:05:07.851
375	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.851	\N	2022-07-01 22:05:07.851
375	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.852	\N	2022-07-01 22:05:07.852
375	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.852	\N	2022-07-01 22:05:07.852
375	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.852	\N	2022-07-01 22:05:07.852
375	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.853	\N	2022-07-01 22:05:07.853
375	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.853	\N	2022-07-01 22:05:07.853
375	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.853	\N	2022-07-01 22:05:07.853
489	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.308	\N	2022-07-01 22:05:12.308
375	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.856	\N	2022-07-01 22:05:07.856
375	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.856	\N	2022-07-01 22:05:07.856
375	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.856	\N	2022-07-01 22:05:07.856
375	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.857	\N	2022-07-01 22:05:07.857
375	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.857	\N	2022-07-01 22:05:07.857
375	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.857	\N	2022-07-01 22:05:07.857
375	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.858	\N	2022-07-01 22:05:07.858
374	401130000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
375	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.858	\N	2022-07-01 22:05:07.858
375	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.858	\N	2022-07-01 22:05:07.858
375	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.859	\N	2022-07-01 22:05:07.859
375	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.859	\N	2022-07-01 22:05:07.859
375	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.859	\N	2022-07-01 22:05:07.859
375	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.86	\N	2022-07-01 22:05:07.86
375	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.86	\N	2022-07-01 22:05:07.86
375	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.86	\N	2022-07-01 22:05:07.86
375	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.861	\N	2022-07-01 22:05:07.861
375	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:07.861	\N	2022-07-01 22:05:07.861
375	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:07.862	\N	2022-07-01 22:05:07.862
375	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.862	\N	2022-07-01 22:05:07.862
375	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.862	\N	2022-07-01 22:05:07.862
375	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.862	\N	2022-07-01 22:05:07.862
375	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.863	\N	2022-07-01 22:05:07.863
375	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.864	\N	2022-07-01 22:05:07.864
375	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.864	\N	2022-07-01 22:05:07.864
375	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.864	\N	2022-07-01 22:05:07.864
375	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.865	\N	2022-07-01 22:05:07.865
375	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.865	\N	2022-07-01 22:05:07.865
375	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.866	\N	2022-07-01 22:05:07.866
375	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.867	\N	2022-07-01 22:05:07.867
375	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.867	\N	2022-07-01 22:05:07.867
375	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.871	\N	2022-07-01 22:05:07.871
375	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.871	\N	2022-07-01 22:05:07.871
375	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.872	\N	2022-07-01 22:05:07.872
375	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.872	\N	2022-07-01 22:05:07.872
375	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.872	\N	2022-07-01 22:05:07.872
375	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.873	\N	2022-07-01 22:05:07.873
375	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.873	\N	2022-07-01 22:05:07.873
376	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.874	\N	2022-07-01 22:05:07.874
376	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.874	\N	2022-07-01 22:05:07.874
376	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.875	\N	2022-07-01 22:05:07.875
376	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.875	\N	2022-07-01 22:05:07.875
376	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.875	\N	2022-07-01 22:05:07.875
376	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.876	\N	2022-07-01 22:05:07.876
375	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
375	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
376	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.876	\N	2022-07-01 22:05:07.876
376	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.876	\N	2022-07-01 22:05:07.876
376	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.876	\N	2022-07-01 22:05:07.876
376	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.877	\N	2022-07-01 22:05:07.877
376	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.877	\N	2022-07-01 22:05:07.877
376	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.878	\N	2022-07-01 22:05:07.878
376	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.878	\N	2022-07-01 22:05:07.878
376	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.879	\N	2022-07-01 22:05:07.879
376	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.879	\N	2022-07-01 22:05:07.879
376	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.879	\N	2022-07-01 22:05:07.879
376	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.88	\N	2022-07-01 22:05:07.88
376	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.881	\N	2022-07-01 22:05:07.881
376	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.881	\N	2022-07-01 22:05:07.881
489	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.308	\N	2022-07-01 22:05:12.308
370	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.72	\N	2022-07-01 22:05:07.72
370	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.72	\N	2022-07-01 22:05:07.72
370	300210000	13	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.72	\N	2022-07-01 22:05:07.72
370	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.721	\N	2022-07-01 22:05:07.721
370	300310100	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.721	\N	2022-07-01 22:05:07.721
376	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.882	\N	2022-07-01 22:05:07.882
376	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.882	\N	2022-07-01 22:05:07.882
376	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.882	\N	2022-07-01 22:05:07.882
376	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.883	\N	2022-07-01 22:05:07.883
376	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.883	\N	2022-07-01 22:05:07.883
376	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.883	\N	2022-07-01 22:05:07.883
376	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.884	\N	2022-07-01 22:05:07.884
376	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.884	\N	2022-07-01 22:05:07.884
376	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.884	\N	2022-07-01 22:05:07.884
376	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.885	\N	2022-07-01 22:05:07.885
376	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.885	\N	2022-07-01 22:05:07.885
376	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.886	\N	2022-07-01 22:05:07.886
376	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.886	\N	2022-07-01 22:05:07.886
376	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.886	\N	2022-07-01 22:05:07.886
376	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.887	\N	2022-07-01 22:05:07.887
376	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:07.887	\N	2022-07-01 22:05:07.887
376	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:07.887	\N	2022-07-01 22:05:07.887
376	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.888	\N	2022-07-01 22:05:07.888
376	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.888	\N	2022-07-01 22:05:07.888
376	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.897	\N	2022-07-01 22:05:07.897
375	401130000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
376	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.897	\N	2022-07-01 22:05:07.897
376	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.897	\N	2022-07-01 22:05:07.897
376	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.898	\N	2022-07-01 22:05:07.898
376	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.898	\N	2022-07-01 22:05:07.898
376	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.899	\N	2022-07-01 22:05:07.899
377	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.899	\N	2022-07-01 22:05:07.899
377	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.899	\N	2022-07-01 22:05:07.899
377	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.9	\N	2022-07-01 22:05:07.9
377	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.9	\N	2022-07-01 22:05:07.9
377	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.9	\N	2022-07-01 22:05:07.9
377	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.901	\N	2022-07-01 22:05:07.901
377	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.901	\N	2022-07-01 22:05:07.901
377	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.901	\N	2022-07-01 22:05:07.901
377	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.902	\N	2022-07-01 22:05:07.902
377	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.902	\N	2022-07-01 22:05:07.902
377	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.22	\N	2022-07-01 22:05:08.22
377	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.22	\N	2022-07-01 22:05:08.22
377	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.22	\N	2022-07-01 22:05:08.22
377	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.221	\N	2022-07-01 22:05:08.221
377	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.221	\N	2022-07-01 22:05:08.221
377	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.221	\N	2022-07-01 22:05:08.221
377	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.222	\N	2022-07-01 22:05:08.222
377	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.222	\N	2022-07-01 22:05:08.222
377	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.223	\N	2022-07-01 22:05:08.223
377	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.224	\N	2022-07-01 22:05:08.224
377	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.224	\N	2022-07-01 22:05:08.224
377	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.224	\N	2022-07-01 22:05:08.224
377	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.225	\N	2022-07-01 22:05:08.225
377	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.225	\N	2022-07-01 22:05:08.225
377	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.225	\N	2022-07-01 22:05:08.225
377	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.226	\N	2022-07-01 22:05:08.226
377	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.226	\N	2022-07-01 22:05:08.226
377	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.226	\N	2022-07-01 22:05:08.226
377	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.227	\N	2022-07-01 22:05:08.227
377	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.227	\N	2022-07-01 22:05:08.227
377	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.227	\N	2022-07-01 22:05:08.227
376	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
376	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
489	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.308	\N	2022-07-01 22:05:12.308
371	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.754	\N	2022-07-01 22:05:07.754
371	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.754	\N	2022-07-01 22:05:07.754
371	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.755	\N	2022-07-01 22:05:07.755
371	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.755	\N	2022-07-01 22:05:07.755
371	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.755	\N	2022-07-01 22:05:07.755
371	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.756	\N	2022-07-01 22:05:07.756
371	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:07.756	\N	2022-07-01 22:05:07.756
371	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:07.756	\N	2022-07-01 22:05:07.756
371	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.757	\N	2022-07-01 22:05:07.757
371	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.757	\N	2022-07-01 22:05:07.757
371	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.757	\N	2022-07-01 22:05:07.757
371	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.759	\N	2022-07-01 22:05:07.759
371	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.759	\N	2022-07-01 22:05:07.759
371	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.759	\N	2022-07-01 22:05:07.759
371	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.76	\N	2022-07-01 22:05:07.76
371	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.76	\N	2022-07-01 22:05:07.76
371	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.761	\N	2022-07-01 22:05:07.761
372	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.787	\N	2022-07-01 22:05:07.787
372	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.788	\N	2022-07-01 22:05:07.788
372	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.788	\N	2022-07-01 22:05:07.788
372	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.789	\N	2022-07-01 22:05:07.789
377	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.228	\N	2022-07-01 22:05:08.228
377	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.228	\N	2022-07-01 22:05:08.228
377	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.229	\N	2022-07-01 22:05:08.229
377	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.229	\N	2022-07-01 22:05:08.229
377	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:08.23	\N	2022-07-01 22:05:08.23
377	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.23	\N	2022-07-01 22:05:08.23
377	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.23	\N	2022-07-01 22:05:08.23
377	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.23	\N	2022-07-01 22:05:08.23
377	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.231	\N	2022-07-01 22:05:08.231
377	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.232	\N	2022-07-01 22:05:08.232
377	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.232	\N	2022-07-01 22:05:08.232
377	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.232	\N	2022-07-01 22:05:08.232
377	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.233	\N	2022-07-01 22:05:08.233
377	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.233	\N	2022-07-01 22:05:08.233
371	401130000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
377	401121000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
377	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.234	\N	2022-07-01 22:05:08.234
377	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.234	\N	2022-07-01 22:05:08.234
377	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.235	\N	2022-07-01 22:05:08.235
378	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.25	\N	2022-07-01 22:05:08.25
378	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.25	\N	2022-07-01 22:05:08.25
378	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.25	\N	2022-07-01 22:05:08.25
378	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.251	\N	2022-07-01 22:05:08.251
378	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.251	\N	2022-07-01 22:05:08.251
378	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.251	\N	2022-07-01 22:05:08.251
378	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.252	\N	2022-07-01 22:05:08.252
378	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.252	\N	2022-07-01 22:05:08.252
378	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.252	\N	2022-07-01 22:05:08.252
378	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.252	\N	2022-07-01 22:05:08.252
378	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.253	\N	2022-07-01 22:05:08.253
378	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.253	\N	2022-07-01 22:05:08.253
372	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.793	\N	2022-07-01 22:05:07.793
372	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.793	\N	2022-07-01 22:05:07.793
372	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.794	\N	2022-07-01 22:05:07.794
372	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.794	\N	2022-07-01 22:05:07.794
372	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.794	\N	2022-07-01 22:05:07.794
372	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.795	\N	2022-07-01 22:05:07.795
372	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.795	\N	2022-07-01 22:05:07.795
373	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.796	\N	2022-07-01 22:05:07.796
373	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.796	\N	2022-07-01 22:05:07.796
373	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.796	\N	2022-07-01 22:05:07.796
373	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.797	\N	2022-07-01 22:05:07.797
373	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.797	\N	2022-07-01 22:05:07.797
373	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.798	\N	2022-07-01 22:05:07.798
373	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.798	\N	2022-07-01 22:05:07.798
373	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.798	\N	2022-07-01 22:05:07.798
373	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.799	\N	2022-07-01 22:05:07.799
373	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.799	\N	2022-07-01 22:05:07.799
373	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.799	\N	2022-07-01 22:05:07.799
373	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.8	\N	2022-07-01 22:05:07.8
373	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.821	\N	2022-07-01 22:05:07.821
373	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.821	\N	2022-07-01 22:05:07.821
373	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.821	\N	2022-07-01 22:05:07.821
374	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.822	\N	2022-07-01 22:05:07.822
374	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.822	\N	2022-07-01 22:05:07.822
377	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
377	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
374	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.822	\N	2022-07-01 22:05:07.822
374	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.823	\N	2022-07-01 22:05:07.823
374	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.823	\N	2022-07-01 22:05:07.823
374	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.823	\N	2022-07-01 22:05:07.823
374	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.824	\N	2022-07-01 22:05:07.824
374	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.824	\N	2022-07-01 22:05:07.824
374	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.824	\N	2022-07-01 22:05:07.824
374	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.825	\N	2022-07-01 22:05:07.825
374	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.825	\N	2022-07-01 22:05:07.825
374	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.826	\N	2022-07-01 22:05:07.826
374	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.826	\N	2022-07-01 22:05:07.826
374	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.826	\N	2022-07-01 22:05:07.826
374	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.827	\N	2022-07-01 22:05:07.827
374	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.827	\N	2022-07-01 22:05:07.827
378	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.253	\N	2022-07-01 22:05:08.253
378	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.254	\N	2022-07-01 22:05:08.254
378	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.254	\N	2022-07-01 22:05:08.254
378	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.255	\N	2022-07-01 22:05:08.255
378	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.255	\N	2022-07-01 22:05:08.255
378	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.255	\N	2022-07-01 22:05:08.255
378	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:08.256	\N	2022-07-01 22:05:08.256
378	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:08.256	\N	2022-07-01 22:05:08.256
378	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.256	\N	2022-07-01 22:05:08.256
378	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.257	\N	2022-07-01 22:05:08.257
378	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.257	\N	2022-07-01 22:05:08.257
378	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.258	\N	2022-07-01 22:05:08.258
378	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.258	\N	2022-07-01 22:05:08.258
378	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.259	\N	2022-07-01 22:05:08.259
378	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.259	\N	2022-07-01 22:05:08.259
378	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.259	\N	2022-07-01 22:05:08.259
378	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.259	\N	2022-07-01 22:05:08.259
378	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.261	\N	2022-07-01 22:05:08.261
378	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.261	\N	2022-07-01 22:05:08.261
378	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.262	\N	2022-07-01 22:05:08.262
378	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.265	\N	2022-07-01 22:05:08.265
378	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.266	\N	2022-07-01 22:05:08.266
378	401130000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
378	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.266	\N	2022-07-01 22:05:08.266
378	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.266	\N	2022-07-01 22:05:08.266
378	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.267	\N	2022-07-01 22:05:08.267
378	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.267	\N	2022-07-01 22:05:08.267
378	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.267	\N	2022-07-01 22:05:08.267
379	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.268	\N	2022-07-01 22:05:08.268
379	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.268	\N	2022-07-01 22:05:08.268
379	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.268	\N	2022-07-01 22:05:08.268
379	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.268	\N	2022-07-01 22:05:08.268
379	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.269	\N	2022-07-01 22:05:08.269
379	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.269	\N	2022-07-01 22:05:08.269
379	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.269	\N	2022-07-01 22:05:08.269
379	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.27	\N	2022-07-01 22:05:08.27
379	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.27	\N	2022-07-01 22:05:08.27
379	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.271	\N	2022-07-01 22:05:08.271
379	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:08.282	\N	2022-07-01 22:05:08.282
379	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.283	\N	2022-07-01 22:05:08.283
379	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.283	\N	2022-07-01 22:05:08.283
379	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.283	\N	2022-07-01 22:05:08.283
379	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.285	\N	2022-07-01 22:05:08.285
379	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.285	\N	2022-07-01 22:05:08.285
379	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.286	\N	2022-07-01 22:05:08.286
379	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.286	\N	2022-07-01 22:05:08.286
379	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.286	\N	2022-07-01 22:05:08.286
379	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.287	\N	2022-07-01 22:05:08.287
379	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.288	\N	2022-07-01 22:05:08.288
379	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.288	\N	2022-07-01 22:05:08.288
379	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.289	\N	2022-07-01 22:05:08.289
379	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.294	\N	2022-07-01 22:05:08.294
379	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.294	\N	2022-07-01 22:05:08.294
379	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.295	\N	2022-07-01 22:05:08.295
379	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.295	\N	2022-07-01 22:05:08.295
379	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.295	\N	2022-07-01 22:05:08.295
379	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.296	\N	2022-07-01 22:05:08.296
379	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.296	\N	2022-07-01 22:05:08.296
380	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.296	\N	2022-07-01 22:05:08.296
380	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.297	\N	2022-07-01 22:05:08.297
380	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.297	\N	2022-07-01 22:05:08.297
380	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.298	\N	2022-07-01 22:05:08.298
380	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.298	\N	2022-07-01 22:05:08.298
489	200010000	10	0	2	3	3	0	0	N	\N	2020-06-30 08:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
489	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
380	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.298	\N	2022-07-01 22:05:08.298
380	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.299	\N	2022-07-01 22:05:08.299
380	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.299	\N	2022-07-01 22:05:08.299
380	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.3	\N	2022-07-01 22:05:08.3
380	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.3	\N	2022-07-01 22:05:08.3
380	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.301	\N	2022-07-01 22:05:08.301
380	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.301	\N	2022-07-01 22:05:08.301
380	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.302	\N	2022-07-01 22:05:08.302
380	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.302	\N	2022-07-01 22:05:08.302
380	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.302	\N	2022-07-01 22:05:08.302
380	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.303	\N	2022-07-01 22:05:08.303
380	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.303	\N	2022-07-01 22:05:08.303
380	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.305	\N	2022-07-01 22:05:08.305
380	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.305	\N	2022-07-01 22:05:08.305
380	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.306	\N	2022-07-01 22:05:08.306
380	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.307	\N	2022-07-01 22:05:08.307
380	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.307	\N	2022-07-01 22:05:08.307
380	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.307	\N	2022-07-01 22:05:08.307
380	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.308	\N	2022-07-01 22:05:08.308
380	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.308	\N	2022-07-01 22:05:08.308
380	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.309	\N	2022-07-01 22:05:08.309
380	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.309	\N	2022-07-01 22:05:08.309
380	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.309	\N	2022-07-01 22:05:08.309
380	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.315	\N	2022-07-01 22:05:08.315
380	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.315	\N	2022-07-01 22:05:08.315
380	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.316	\N	2022-07-01 22:05:08.316
380	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.316	\N	2022-07-01 22:05:08.316
380	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.317	\N	2022-07-01 22:05:08.317
380	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.317	\N	2022-07-01 22:05:08.317
380	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.318	\N	2022-07-01 22:05:08.318
380	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.319	\N	2022-07-01 22:05:08.319
380	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.319	\N	2022-07-01 22:05:08.319
379	401130000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
380	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.323	\N	2022-07-01 22:05:08.323
380	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.324	\N	2022-07-01 22:05:08.324
380	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.324	\N	2022-07-01 22:05:08.324
380	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.325	\N	2022-07-01 22:05:08.325
380	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.325	\N	2022-07-01 22:05:08.325
380	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.325	\N	2022-07-01 22:05:08.325
380	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.326	\N	2022-07-01 22:05:08.326
381	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.326	\N	2022-07-01 22:05:08.326
381	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.327	\N	2022-07-01 22:05:08.327
381	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.327	\N	2022-07-01 22:05:08.327
381	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.328	\N	2022-07-01 22:05:08.328
381	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.328	\N	2022-07-01 22:05:08.328
381	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.329	\N	2022-07-01 22:05:08.329
381	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.329	\N	2022-07-01 22:05:08.329
381	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.329	\N	2022-07-01 22:05:08.329
381	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.33	\N	2022-07-01 22:05:08.33
381	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.33	\N	2022-07-01 22:05:08.33
381	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.33	\N	2022-07-01 22:05:08.33
381	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.331	\N	2022-07-01 22:05:08.331
381	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.331	\N	2022-07-01 22:05:08.331
381	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.331	\N	2022-07-01 22:05:08.331
381	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.332	\N	2022-07-01 22:05:08.332
381	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.332	\N	2022-07-01 22:05:08.332
381	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.332	\N	2022-07-01 22:05:08.332
381	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.334	\N	2022-07-01 22:05:08.334
381	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.334	\N	2022-07-01 22:05:08.334
381	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.335	\N	2022-07-01 22:05:08.335
381	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.335	\N	2022-07-01 22:05:08.335
381	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.335	\N	2022-07-01 22:05:08.335
381	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.336	\N	2022-07-01 22:05:08.336
381	300210000	13	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.336	\N	2022-07-01 22:05:08.336
381	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.336	\N	2022-07-01 22:05:08.336
381	300310100	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.337	\N	2022-07-01 22:05:08.337
381	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.337	\N	2022-07-01 22:05:08.337
381	300310200	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.337	\N	2022-07-01 22:05:08.337
381	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.338	\N	2022-07-01 22:05:08.338
381	300310300	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.338	\N	2022-07-01 22:05:08.338
381	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.338	\N	2022-07-01 22:05:08.338
381	300310400	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.339	\N	2022-07-01 22:05:08.339
381	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.339	\N	2022-07-01 22:05:08.339
380	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
380	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
489	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
381	300310500	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.339	\N	2022-07-01 22:05:08.339
381	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.34	\N	2022-07-01 22:05:08.34
381	300310600	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.34	\N	2022-07-01 22:05:08.34
489	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.309	\N	2022-07-01 22:05:12.309
376	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.889	\N	2022-07-01 22:05:07.889
376	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.89	\N	2022-07-01 22:05:07.89
376	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.89	\N	2022-07-01 22:05:07.89
376	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.89	\N	2022-07-01 22:05:07.89
376	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.891	\N	2022-07-01 22:05:07.891
376	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.891	\N	2022-07-01 22:05:07.891
376	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:07.892	\N	2022-07-01 22:05:07.892
376	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.892	\N	2022-07-01 22:05:07.892
376	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:07.893	\N	2022-07-01 22:05:07.893
377	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.24	\N	2022-07-01 22:05:08.24
381	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.34	\N	2022-07-01 22:05:08.34
381	300310700	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.341	\N	2022-07-01 22:05:08.341
381	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.341	\N	2022-07-01 22:05:08.341
381	300310800	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.341	\N	2022-07-01 22:05:08.341
381	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.342	\N	2022-07-01 22:05:08.342
381	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.343	\N	2022-07-01 22:05:08.343
381	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.343	\N	2022-07-01 22:05:08.343
381	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.343	\N	2022-07-01 22:05:08.343
381	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:08.344	\N	2022-07-01 22:05:08.344
381	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:08.344	\N	2022-07-01 22:05:08.344
381	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.344	\N	2022-07-01 22:05:08.344
381	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.345	\N	2022-07-01 22:05:08.345
381	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.345	\N	2022-07-01 22:05:08.345
381	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.349	\N	2022-07-01 22:05:08.349
381	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.349	\N	2022-07-01 22:05:08.349
381	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.349	\N	2022-07-01 22:05:08.349
381	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.355	\N	2022-07-01 22:05:08.355
381	401121000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
381	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.355	\N	2022-07-01 22:05:08.355
381	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.355	\N	2022-07-01 22:05:08.355
381	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.356	\N	2022-07-01 22:05:08.356
381	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.356	\N	2022-07-01 22:05:08.356
381	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.357	\N	2022-07-01 22:05:08.357
382	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.357	\N	2022-07-01 22:05:08.357
382	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.357	\N	2022-07-01 22:05:08.357
382	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.357	\N	2022-07-01 22:05:08.357
382	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.358	\N	2022-07-01 22:05:08.358
382	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.358	\N	2022-07-01 22:05:08.358
382	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.358	\N	2022-07-01 22:05:08.358
382	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.359	\N	2022-07-01 22:05:08.359
382	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.359	\N	2022-07-01 22:05:08.359
382	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.359	\N	2022-07-01 22:05:08.359
382	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.36	\N	2022-07-01 22:05:08.36
382	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.36	\N	2022-07-01 22:05:08.36
382	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.36	\N	2022-07-01 22:05:08.36
382	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.361	\N	2022-07-01 22:05:08.361
382	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.361	\N	2022-07-01 22:05:08.361
382	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.361	\N	2022-07-01 22:05:08.361
489	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.309	\N	2022-07-01 22:05:12.309
377	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.241	\N	2022-07-01 22:05:08.241
377	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.241	\N	2022-07-01 22:05:08.241
377	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.242	\N	2022-07-01 22:05:08.242
377	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.242	\N	2022-07-01 22:05:08.242
378	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.242	\N	2022-07-01 22:05:08.242
378	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.243	\N	2022-07-01 22:05:08.243
378	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.243	\N	2022-07-01 22:05:08.243
378	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.243	\N	2022-07-01 22:05:08.243
378	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.244	\N	2022-07-01 22:05:08.244
378	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.244	\N	2022-07-01 22:05:08.244
378	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.244	\N	2022-07-01 22:05:08.244
378	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.245	\N	2022-07-01 22:05:08.245
378	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.245	\N	2022-07-01 22:05:08.245
378	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.246	\N	2022-07-01 22:05:08.246
378	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.246	\N	2022-07-01 22:05:08.246
378	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.246	\N	2022-07-01 22:05:08.246
378	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.247	\N	2022-07-01 22:05:08.247
378	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.247	\N	2022-07-01 22:05:08.247
378	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.248	\N	2022-07-01 22:05:08.248
378	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.248	\N	2022-07-01 22:05:08.248
378	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.248	\N	2022-07-01 22:05:08.248
379	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.271	\N	2022-07-01 22:05:08.271
379	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.272	\N	2022-07-01 22:05:08.272
381	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
381	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
379	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.272	\N	2022-07-01 22:05:08.272
379	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.272	\N	2022-07-01 22:05:08.272
379	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.273	\N	2022-07-01 22:05:08.273
379	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.273	\N	2022-07-01 22:05:08.273
379	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.273	\N	2022-07-01 22:05:08.273
379	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.275	\N	2022-07-01 22:05:08.275
379	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.275	\N	2022-07-01 22:05:08.275
379	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.275	\N	2022-07-01 22:05:08.275
379	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.276	\N	2022-07-01 22:05:08.276
379	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.276	\N	2022-07-01 22:05:08.276
379	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.277	\N	2022-07-01 22:05:08.277
379	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.277	\N	2022-07-01 22:05:08.277
379	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.278	\N	2022-07-01 22:05:08.278
379	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.278	\N	2022-07-01 22:05:08.278
379	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.278	\N	2022-07-01 22:05:08.278
379	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.279	\N	2022-07-01 22:05:08.279
379	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.279	\N	2022-07-01 22:05:08.279
379	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.279	\N	2022-07-01 22:05:08.279
379	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.28	\N	2022-07-01 22:05:08.28
379	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.281	\N	2022-07-01 22:05:08.281
379	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.281	\N	2022-07-01 22:05:08.281
379	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.281	\N	2022-07-01 22:05:08.281
379	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:08.282	\N	2022-07-01 22:05:08.282
382	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.362	\N	2022-07-01 22:05:08.362
382	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.362	\N	2022-07-01 22:05:08.362
382	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.362	\N	2022-07-01 22:05:08.362
382	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.364	\N	2022-07-01 22:05:08.364
382	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.364	\N	2022-07-01 22:05:08.364
382	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.364	\N	2022-07-01 22:05:08.364
382	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.365	\N	2022-07-01 22:05:08.365
382	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.365	\N	2022-07-01 22:05:08.365
382	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.366	\N	2022-07-01 22:05:08.366
382	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.366	\N	2022-07-01 22:05:08.366
382	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.366	\N	2022-07-01 22:05:08.366
382	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.367	\N	2022-07-01 22:05:08.367
382	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.367	\N	2022-07-01 22:05:08.367
382	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.367	\N	2022-07-01 22:05:08.367
382	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.368	\N	2022-07-01 22:05:08.368
382	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.368	\N	2022-07-01 22:05:08.368
382	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.369	\N	2022-07-01 22:05:08.369
382	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.369	\N	2022-07-01 22:05:08.369
382	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.369	\N	2022-07-01 22:05:08.369
382	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.37	\N	2022-07-01 22:05:08.37
489	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.31	\N	2022-07-01 22:05:12.31
380	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.311	\N	2022-07-01 22:05:08.311
380	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.311	\N	2022-07-01 22:05:08.311
380	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.311	\N	2022-07-01 22:05:08.311
380	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.312	\N	2022-07-01 22:05:08.312
380	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:08.312	\N	2022-07-01 22:05:08.312
380	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:08.313	\N	2022-07-01 22:05:08.313
380	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.313	\N	2022-07-01 22:05:08.313
380	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.313	\N	2022-07-01 22:05:08.313
380	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.314	\N	2022-07-01 22:05:08.314
382	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:08.37	\N	2022-07-01 22:05:08.37
382	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:08.371	\N	2022-07-01 22:05:08.371
382	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.371	\N	2022-07-01 22:05:08.371
382	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.371	\N	2022-07-01 22:05:08.371
382	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.372	\N	2022-07-01 22:05:08.372
382	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.372	\N	2022-07-01 22:05:08.372
382	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.372	\N	2022-07-01 22:05:08.372
382	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.373	\N	2022-07-01 22:05:08.373
382	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.373	\N	2022-07-01 22:05:08.373
382	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.373	\N	2022-07-01 22:05:08.373
382	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.374	\N	2022-07-01 22:05:08.374
382	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.374	\N	2022-07-01 22:05:08.374
382	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.374	\N	2022-07-01 22:05:08.374
383	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.382	\N	2022-07-01 22:05:08.382
383	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.382	\N	2022-07-01 22:05:08.382
383	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.383	\N	2022-07-01 22:05:08.383
383	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.383	\N	2022-07-01 22:05:08.383
383	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.384	\N	2022-07-01 22:05:08.384
383	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.384	\N	2022-07-01 22:05:08.384
383	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.385	\N	2022-07-01 22:05:08.385
379	200010000	10	0	2	3	3	0	0	N	\N	2020-06-30 08:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
379	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
382	200010000	10	0	2	3	3	0	0	N	\N	2020-06-30 08:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
382	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
382	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
383	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.385	\N	2022-07-01 22:05:08.385
383	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.385	\N	2022-07-01 22:05:08.385
383	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.385	\N	2022-07-01 22:05:08.385
383	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.386	\N	2022-07-01 22:05:08.386
383	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.386	\N	2022-07-01 22:05:08.386
383	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.386	\N	2022-07-01 22:05:08.386
383	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.386	\N	2022-07-01 22:05:08.386
383	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.387	\N	2022-07-01 22:05:08.387
383	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.387	\N	2022-07-01 22:05:08.387
383	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.387	\N	2022-07-01 22:05:08.387
383	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.387	\N	2022-07-01 22:05:08.387
383	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.388	\N	2022-07-01 22:05:08.388
383	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.388	\N	2022-07-01 22:05:08.388
383	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.388	\N	2022-07-01 22:05:08.388
383	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:08.389	\N	2022-07-01 22:05:08.389
383	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:08.389	\N	2022-07-01 22:05:08.389
383	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.389	\N	2022-07-01 22:05:08.389
383	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.389	\N	2022-07-01 22:05:08.389
383	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.39	\N	2022-07-01 22:05:08.39
383	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.39	\N	2022-07-01 22:05:08.39
383	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.391	\N	2022-07-01 22:05:08.391
383	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.391	\N	2022-07-01 22:05:08.391
383	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.391	\N	2022-07-01 22:05:08.391
383	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.391	\N	2022-07-01 22:05:08.391
383	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.392	\N	2022-07-01 22:05:08.392
489	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.31	\N	2022-07-01 22:05:12.31
382	401121000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
383	401121000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
383	401130000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
383	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.392	\N	2022-07-01 22:05:08.392
383	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.393	\N	2022-07-01 22:05:08.393
383	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.398	\N	2022-07-01 22:05:08.398
383	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.398	\N	2022-07-01 22:05:08.398
383	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.399	\N	2022-07-01 22:05:08.399
383	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.399	\N	2022-07-01 22:05:08.399
383	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.399	\N	2022-07-01 22:05:08.399
383	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.399	\N	2022-07-01 22:05:08.399
384	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.4	\N	2022-07-01 22:05:08.4
384	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.4	\N	2022-07-01 22:05:08.4
384	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.4	\N	2022-07-01 22:05:08.4
384	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.4	\N	2022-07-01 22:05:08.4
384	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.401	\N	2022-07-01 22:05:08.401
384	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.753	\N	2022-07-01 22:05:08.753
384	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.754	\N	2022-07-01 22:05:08.754
384	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.754	\N	2022-07-01 22:05:08.754
384	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.755	\N	2022-07-01 22:05:08.755
384	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.755	\N	2022-07-01 22:05:08.755
384	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.755	\N	2022-07-01 22:05:08.755
384	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.755	\N	2022-07-01 22:05:08.755
384	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.756	\N	2022-07-01 22:05:08.756
384	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.756	\N	2022-07-01 22:05:08.756
384	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.757	\N	2022-07-01 22:05:08.757
384	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.757	\N	2022-07-01 22:05:08.757
384	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.76	\N	2022-07-01 22:05:08.76
384	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.76	\N	2022-07-01 22:05:08.76
384	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.76	\N	2022-07-01 22:05:08.76
384	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.76	\N	2022-07-01 22:05:08.76
384	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.76	\N	2022-07-01 22:05:08.76
384	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.761	\N	2022-07-01 22:05:08.761
384	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.761	\N	2022-07-01 22:05:08.761
385	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.761	\N	2022-07-01 22:05:08.761
385	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.762	\N	2022-07-01 22:05:08.762
385	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.762	\N	2022-07-01 22:05:08.762
385	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.762	\N	2022-07-01 22:05:08.762
385	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.762	\N	2022-07-01 22:05:08.762
385	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.763	\N	2022-07-01 22:05:08.763
385	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.763	\N	2022-07-01 22:05:08.763
385	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.763	\N	2022-07-01 22:05:08.763
385	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.764	\N	2022-07-01 22:05:08.764
385	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.764	\N	2022-07-01 22:05:08.764
383	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
385	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.764	\N	2022-07-01 22:05:08.764
385	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.764	\N	2022-07-01 22:05:08.764
489	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.31	\N	2022-07-01 22:05:12.31
381	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.347	\N	2022-07-01 22:05:08.347
381	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.348	\N	2022-07-01 22:05:08.348
382	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.377	\N	2022-07-01 22:05:08.377
382	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.378	\N	2022-07-01 22:05:08.378
382	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.378	\N	2022-07-01 22:05:08.378
382	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.378	\N	2022-07-01 22:05:08.378
385	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.765	\N	2022-07-01 22:05:08.765
385	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.765	\N	2022-07-01 22:05:08.765
385	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.765	\N	2022-07-01 22:05:08.765
385	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.765	\N	2022-07-01 22:05:08.765
385	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.766	\N	2022-07-01 22:05:08.766
385	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.767	\N	2022-07-01 22:05:08.767
385	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.767	\N	2022-07-01 22:05:08.767
385	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.767	\N	2022-07-01 22:05:08.767
385	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.768	\N	2022-07-01 22:05:08.768
385	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.768	\N	2022-07-01 22:05:08.768
385	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.768	\N	2022-07-01 22:05:08.768
385	300210000	13	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.768	\N	2022-07-01 22:05:08.768
385	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.769	\N	2022-07-01 22:05:08.769
385	300310100	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.769	\N	2022-07-01 22:05:08.769
385	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:08.774	\N	2022-07-01 22:05:08.774
385	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:08.774	\N	2022-07-01 22:05:08.774
385	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.774	\N	2022-07-01 22:05:08.774
385	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.775	\N	2022-07-01 22:05:08.775
385	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.775	\N	2022-07-01 22:05:08.775
384	401130000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
385	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.776	\N	2022-07-01 22:05:08.776
385	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.776	\N	2022-07-01 22:05:08.776
385	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.776	\N	2022-07-01 22:05:08.776
385	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.776	\N	2022-07-01 22:05:08.776
385	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.777	\N	2022-07-01 22:05:08.777
385	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.777	\N	2022-07-01 22:05:08.777
385	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.778	\N	2022-07-01 22:05:08.778
385	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.778	\N	2022-07-01 22:05:08.778
385	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.778	\N	2022-07-01 22:05:08.778
385	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.781	\N	2022-07-01 22:05:08.781
385	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.781	\N	2022-07-01 22:05:08.781
385	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.781	\N	2022-07-01 22:05:08.781
385	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.782	\N	2022-07-01 22:05:08.782
385	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.782	\N	2022-07-01 22:05:08.782
385	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.782	\N	2022-07-01 22:05:08.782
385	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.782	\N	2022-07-01 22:05:08.782
386	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.782	\N	2022-07-01 22:05:08.782
386	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.783	\N	2022-07-01 22:05:08.783
386	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.783	\N	2022-07-01 22:05:08.783
386	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.783	\N	2022-07-01 22:05:08.783
386	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.784	\N	2022-07-01 22:05:08.784
386	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.784	\N	2022-07-01 22:05:08.784
386	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.784	\N	2022-07-01 22:05:08.784
386	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.784	\N	2022-07-01 22:05:08.784
386	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.785	\N	2022-07-01 22:05:08.785
386	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.785	\N	2022-07-01 22:05:08.785
386	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.785	\N	2022-07-01 22:05:08.785
386	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.785	\N	2022-07-01 22:05:08.785
386	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.786	\N	2022-07-01 22:05:08.786
386	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.786	\N	2022-07-01 22:05:08.786
386	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.786	\N	2022-07-01 22:05:08.786
489	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.31	\N	2022-07-01 22:05:12.31
382	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.379	\N	2022-07-01 22:05:08.379
383	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.379	\N	2022-07-01 22:05:08.379
383	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.379	\N	2022-07-01 22:05:08.379
383	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.38	\N	2022-07-01 22:05:08.38
383	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.38	\N	2022-07-01 22:05:08.38
383	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.38	\N	2022-07-01 22:05:08.38
383	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.38	\N	2022-07-01 22:05:08.38
383	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.381	\N	2022-07-01 22:05:08.381
383	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.381	\N	2022-07-01 22:05:08.381
383	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.381	\N	2022-07-01 22:05:08.381
383	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.381	\N	2022-07-01 22:05:08.381
383	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.382	\N	2022-07-01 22:05:08.382
383	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.382	\N	2022-07-01 22:05:08.382
383	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.382	\N	2022-07-01 22:05:08.382
384	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.401	\N	2022-07-01 22:05:08.401
384	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.401	\N	2022-07-01 22:05:08.401
384	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.402	\N	2022-07-01 22:05:08.402
384	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.402	\N	2022-07-01 22:05:08.402
385	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
384	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.402	\N	2022-07-01 22:05:08.402
384	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.402	\N	2022-07-01 22:05:08.402
384	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.403	\N	2022-07-01 22:05:08.403
384	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.403	\N	2022-07-01 22:05:08.403
384	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.403	\N	2022-07-01 22:05:08.403
384	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.403	\N	2022-07-01 22:05:08.403
384	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.746	\N	2022-07-01 22:05:08.746
384	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.747	\N	2022-07-01 22:05:08.747
384	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.748	\N	2022-07-01 22:05:08.748
384	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.748	\N	2022-07-01 22:05:08.748
384	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.748	\N	2022-07-01 22:05:08.748
384	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.749	\N	2022-07-01 22:05:08.749
384	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.749	\N	2022-07-01 22:05:08.749
384	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.749	\N	2022-07-01 22:05:08.749
384	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.749	\N	2022-07-01 22:05:08.749
384	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.75	\N	2022-07-01 22:05:08.75
384	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.75	\N	2022-07-01 22:05:08.75
384	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.75	\N	2022-07-01 22:05:08.75
384	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.75	\N	2022-07-01 22:05:08.75
384	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.751	\N	2022-07-01 22:05:08.751
384	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.751	\N	2022-07-01 22:05:08.751
386	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.786	\N	2022-07-01 22:05:08.786
386	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.787	\N	2022-07-01 22:05:08.787
386	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.787	\N	2022-07-01 22:05:08.787
386	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.788	\N	2022-07-01 22:05:08.788
386	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.788	\N	2022-07-01 22:05:08.788
386	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.788	\N	2022-07-01 22:05:08.788
386	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.789	\N	2022-07-01 22:05:08.789
386	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.789	\N	2022-07-01 22:05:08.789
386	300210000	13	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.789	\N	2022-07-01 22:05:08.789
386	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.789	\N	2022-07-01 22:05:08.789
386	300310100	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.79	\N	2022-07-01 22:05:08.79
386	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.79	\N	2022-07-01 22:05:08.79
386	300310200	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.79	\N	2022-07-01 22:05:08.79
386	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.791	\N	2022-07-01 22:05:08.791
386	300310300	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.791	\N	2022-07-01 22:05:08.791
386	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.791	\N	2022-07-01 22:05:08.791
386	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.791	\N	2022-07-01 22:05:08.791
386	300310500	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.792	\N	2022-07-01 22:05:08.792
386	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.792	\N	2022-07-01 22:05:08.792
386	300310600	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.792	\N	2022-07-01 22:05:08.792
386	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.792	\N	2022-07-01 22:05:08.792
386	300310700	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.793	\N	2022-07-01 22:05:08.793
386	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.793	\N	2022-07-01 22:05:08.793
386	300310800	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.793	\N	2022-07-01 22:05:08.793
386	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.794	\N	2022-07-01 22:05:08.794
386	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.795	\N	2022-07-01 22:05:08.795
386	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.795	\N	2022-07-01 22:05:08.795
386	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:08.795	\N	2022-07-01 22:05:08.795
386	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:08.795	\N	2022-07-01 22:05:08.795
489	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.31	\N	2022-07-01 22:05:12.31
384	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.752	\N	2022-07-01 22:05:08.752
384	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.752	\N	2022-07-01 22:05:08.752
384	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:08.753	\N	2022-07-01 22:05:08.753
384	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:08.753	\N	2022-07-01 22:05:08.753
384	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.753	\N	2022-07-01 22:05:08.753
385	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.769	\N	2022-07-01 22:05:08.769
385	300310200	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.769	\N	2022-07-01 22:05:08.769
385	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.769	\N	2022-07-01 22:05:08.769
385	300310300	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.77	\N	2022-07-01 22:05:08.77
385	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.77	\N	2022-07-01 22:05:08.77
385	300310400	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.77	\N	2022-07-01 22:05:08.77
385	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.77	\N	2022-07-01 22:05:08.77
385	300310500	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.771	\N	2022-07-01 22:05:08.771
385	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.771	\N	2022-07-01 22:05:08.771
385	300310600	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.771	\N	2022-07-01 22:05:08.771
385	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.771	\N	2022-07-01 22:05:08.771
385	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.772	\N	2022-07-01 22:05:08.772
385	300310800	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.772	\N	2022-07-01 22:05:08.772
385	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.773	\N	2022-07-01 22:05:08.773
385	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.773	\N	2022-07-01 22:05:08.773
385	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.773	\N	2022-07-01 22:05:08.773
384	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
384	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
386	200010000	10	0	2	3	3	0	0	N	\N	2020-06-30 08:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
386	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
385	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.774	\N	2022-07-01 22:05:08.774
386	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.794	\N	2022-07-01 22:05:08.794
386	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.795	\N	2022-07-01 22:05:08.795
386	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.796	\N	2022-07-01 22:05:08.796
386	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.796	\N	2022-07-01 22:05:08.796
386	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.797	\N	2022-07-01 22:05:08.797
386	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.797	\N	2022-07-01 22:05:08.797
386	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.797	\N	2022-07-01 22:05:08.797
386	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.798	\N	2022-07-01 22:05:08.798
386	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.798	\N	2022-07-01 22:05:08.798
386	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.799	\N	2022-07-01 22:05:08.799
386	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.799	\N	2022-07-01 22:05:08.799
386	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.799	\N	2022-07-01 22:05:08.799
386	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.803	\N	2022-07-01 22:05:08.803
386	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.803	\N	2022-07-01 22:05:08.803
386	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.803	\N	2022-07-01 22:05:08.803
386	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.804	\N	2022-07-01 22:05:08.804
386	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.804	\N	2022-07-01 22:05:08.804
386	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.804	\N	2022-07-01 22:05:08.804
387	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.805	\N	2022-07-01 22:05:08.805
387	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.805	\N	2022-07-01 22:05:08.805
387	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.805	\N	2022-07-01 22:05:08.805
387	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.805	\N	2022-07-01 22:05:08.805
387	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.806	\N	2022-07-01 22:05:08.806
387	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.806	\N	2022-07-01 22:05:08.806
387	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.806	\N	2022-07-01 22:05:08.806
387	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.806	\N	2022-07-01 22:05:08.806
387	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.807	\N	2022-07-01 22:05:08.807
387	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.807	\N	2022-07-01 22:05:08.807
387	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.807	\N	2022-07-01 22:05:08.807
387	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.807	\N	2022-07-01 22:05:08.807
387	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.808	\N	2022-07-01 22:05:08.808
387	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.808	\N	2022-07-01 22:05:08.808
387	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.808	\N	2022-07-01 22:05:08.808
489	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.311	\N	2022-07-01 22:05:12.311
387	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.809	\N	2022-07-01 22:05:08.809
387	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.81	\N	2022-07-01 22:05:08.81
387	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.811	\N	2022-07-01 22:05:08.811
387	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.811	\N	2022-07-01 22:05:08.811
387	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.811	\N	2022-07-01 22:05:08.811
387	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.811	\N	2022-07-01 22:05:08.811
387	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.812	\N	2022-07-01 22:05:08.812
387	300210000	13	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.812	\N	2022-07-01 22:05:08.812
387	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.812	\N	2022-07-01 22:05:08.812
387	300310100	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.812	\N	2022-07-01 22:05:08.812
387	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.812	\N	2022-07-01 22:05:08.812
387	300310200	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.813	\N	2022-07-01 22:05:08.813
387	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.813	\N	2022-07-01 22:05:08.813
387	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.813	\N	2022-07-01 22:05:08.813
387	300310400	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.814	\N	2022-07-01 22:05:08.814
387	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.814	\N	2022-07-01 22:05:08.814
387	300310500	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.814	\N	2022-07-01 22:05:08.814
387	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.814	\N	2022-07-01 22:05:08.814
387	300310600	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.815	\N	2022-07-01 22:05:08.815
387	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.815	\N	2022-07-01 22:05:08.815
387	300310700	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.815	\N	2022-07-01 22:05:08.815
387	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.815	\N	2022-07-01 22:05:08.815
387	300310800	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.816	\N	2022-07-01 22:05:08.816
387	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.816	\N	2022-07-01 22:05:08.816
387	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.817	\N	2022-07-01 22:05:08.817
387	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.817	\N	2022-07-01 22:05:08.817
387	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.817	\N	2022-07-01 22:05:08.817
387	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:08.817	\N	2022-07-01 22:05:08.817
387	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:08.817	\N	2022-07-01 22:05:08.817
387	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.818	\N	2022-07-01 22:05:08.818
387	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.818	\N	2022-07-01 22:05:08.818
387	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.824	\N	2022-07-01 22:05:08.824
387	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.825	\N	2022-07-01 22:05:08.825
387	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.825	\N	2022-07-01 22:05:08.825
387	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.825	\N	2022-07-01 22:05:08.825
387	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.825	\N	2022-07-01 22:05:08.825
387	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.826	\N	2022-07-01 22:05:08.826
387	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.826	\N	2022-07-01 22:05:08.826
388	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.826	\N	2022-07-01 22:05:08.826
388	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.826	\N	2022-07-01 22:05:08.826
388	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.826	\N	2022-07-01 22:05:08.826
388	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.827	\N	2022-07-01 22:05:08.827
388	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.827	\N	2022-07-01 22:05:08.827
388	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.827	\N	2022-07-01 22:05:08.827
388	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.827	\N	2022-07-01 22:05:08.827
388	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.828	\N	2022-07-01 22:05:08.828
388	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.828	\N	2022-07-01 22:05:08.828
388	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.828	\N	2022-07-01 22:05:08.828
388	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.829	\N	2022-07-01 22:05:08.829
388	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.829	\N	2022-07-01 22:05:08.829
388	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.829	\N	2022-07-01 22:05:08.829
388	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.829	\N	2022-07-01 22:05:08.829
388	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.83	\N	2022-07-01 22:05:08.83
388	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.83	\N	2022-07-01 22:05:08.83
388	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.83	\N	2022-07-01 22:05:08.83
388	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.831	\N	2022-07-01 22:05:08.831
388	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.831	\N	2022-07-01 22:05:08.831
388	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.831	\N	2022-07-01 22:05:08.831
388	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.832	\N	2022-07-01 22:05:08.832
489	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.311	\N	2022-07-01 22:05:12.311
387	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.819	\N	2022-07-01 22:05:08.819
387	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.819	\N	2022-07-01 22:05:08.819
387	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.82	\N	2022-07-01 22:05:08.82
387	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.82	\N	2022-07-01 22:05:08.82
387	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.82	\N	2022-07-01 22:05:08.82
387	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.821	\N	2022-07-01 22:05:08.821
387	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.821	\N	2022-07-01 22:05:08.821
387	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.821	\N	2022-07-01 22:05:08.821
388	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.832	\N	2022-07-01 22:05:08.832
388	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.832	\N	2022-07-01 22:05:08.832
388	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.832	\N	2022-07-01 22:05:08.832
388	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.833	\N	2022-07-01 22:05:08.833
388	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.833	\N	2022-07-01 22:05:08.833
388	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.833	\N	2022-07-01 22:05:08.833
388	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.834	\N	2022-07-01 22:05:08.834
388	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.834	\N	2022-07-01 22:05:08.834
388	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.834	\N	2022-07-01 22:05:08.834
388	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.834	\N	2022-07-01 22:05:08.834
388	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.835	\N	2022-07-01 22:05:08.835
388	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.835	\N	2022-07-01 22:05:08.835
388	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.835	\N	2022-07-01 22:05:08.835
388	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:08.835	\N	2022-07-01 22:05:08.835
388	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:08.836	\N	2022-07-01 22:05:08.836
388	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.836	\N	2022-07-01 22:05:08.836
388	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.836	\N	2022-07-01 22:05:08.836
388	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.836	\N	2022-07-01 22:05:08.836
388	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.84	\N	2022-07-01 22:05:08.84
388	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.84	\N	2022-07-01 22:05:08.84
388	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.84	\N	2022-07-01 22:05:08.84
388	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.84	\N	2022-07-01 22:05:08.84
388	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.841	\N	2022-07-01 22:05:08.841
388	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.841	\N	2022-07-01 22:05:08.841
388	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.842	\N	2022-07-01 22:05:08.842
388	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.842	\N	2022-07-01 22:05:08.842
388	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.842	\N	2022-07-01 22:05:08.842
389	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.85	\N	2022-07-01 22:05:08.85
389	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.85	\N	2022-07-01 22:05:08.85
389	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.851	\N	2022-07-01 22:05:08.851
389	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.851	\N	2022-07-01 22:05:08.851
389	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.851	\N	2022-07-01 22:05:08.851
389	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.851	\N	2022-07-01 22:05:08.851
389	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.852	\N	2022-07-01 22:05:08.852
389	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.852	\N	2022-07-01 22:05:08.852
389	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.852	\N	2022-07-01 22:05:08.852
389	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.853	\N	2022-07-01 22:05:08.853
389	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.853	\N	2022-07-01 22:05:08.853
389	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.853	\N	2022-07-01 22:05:08.853
389	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.854	\N	2022-07-01 22:05:08.854
389	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:08.854	\N	2022-07-01 22:05:08.854
389	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:08.854	\N	2022-07-01 22:05:08.854
389	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.854	\N	2022-07-01 22:05:08.854
389	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.854	\N	2022-07-01 22:05:08.854
389	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.855	\N	2022-07-01 22:05:08.855
489	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.311	\N	2022-07-01 22:05:12.311
388	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.843	\N	2022-07-01 22:05:08.843
388	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.843	\N	2022-07-01 22:05:08.843
388	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.843	\N	2022-07-01 22:05:08.843
387	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
388	200010000	10	0	2	3	3	0	0	N	\N	2020-06-30 08:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
388	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
388	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
388	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.843	\N	2022-07-01 22:05:08.843
388	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.844	\N	2022-07-01 22:05:08.844
388	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.844	\N	2022-07-01 22:05:08.844
388	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.844	\N	2022-07-01 22:05:08.844
389	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.844	\N	2022-07-01 22:05:08.844
389	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.845	\N	2022-07-01 22:05:08.845
389	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.845	\N	2022-07-01 22:05:08.845
389	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.845	\N	2022-07-01 22:05:08.845
389	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.845	\N	2022-07-01 22:05:08.845
389	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.845	\N	2022-07-01 22:05:08.845
389	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.846	\N	2022-07-01 22:05:08.846
389	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.846	\N	2022-07-01 22:05:08.846
389	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.846	\N	2022-07-01 22:05:08.846
389	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.847	\N	2022-07-01 22:05:08.847
389	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.847	\N	2022-07-01 22:05:08.847
389	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.847	\N	2022-07-01 22:05:08.847
389	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.847	\N	2022-07-01 22:05:08.847
389	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.848	\N	2022-07-01 22:05:08.848
389	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.848	\N	2022-07-01 22:05:08.848
389	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.848	\N	2022-07-01 22:05:08.848
389	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.848	\N	2022-07-01 22:05:08.848
388	401130000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
389	401130000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
389	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.858	\N	2022-07-01 22:05:08.858
389	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.858	\N	2022-07-01 22:05:08.858
389	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.858	\N	2022-07-01 22:05:08.858
389	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.859	\N	2022-07-01 22:05:08.859
389	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.859	\N	2022-07-01 22:05:08.859
389	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.86	\N	2022-07-01 22:05:08.86
389	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.86	\N	2022-07-01 22:05:08.86
389	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.86	\N	2022-07-01 22:05:08.86
389	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.861	\N	2022-07-01 22:05:08.861
389	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.861	\N	2022-07-01 22:05:08.861
389	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.861	\N	2022-07-01 22:05:08.861
389	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.861	\N	2022-07-01 22:05:08.861
389	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.862	\N	2022-07-01 22:05:08.862
389	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.862	\N	2022-07-01 22:05:08.862
389	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.862	\N	2022-07-01 22:05:08.862
390	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.862	\N	2022-07-01 22:05:08.862
390	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.863	\N	2022-07-01 22:05:08.863
390	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.863	\N	2022-07-01 22:05:08.863
390	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.863	\N	2022-07-01 22:05:08.863
390	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.863	\N	2022-07-01 22:05:08.863
390	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.863	\N	2022-07-01 22:05:08.863
390	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.864	\N	2022-07-01 22:05:08.864
390	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.864	\N	2022-07-01 22:05:08.864
390	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.864	\N	2022-07-01 22:05:08.864
390	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.864	\N	2022-07-01 22:05:08.864
390	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.865	\N	2022-07-01 22:05:08.865
390	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.865	\N	2022-07-01 22:05:08.865
390	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.865	\N	2022-07-01 22:05:08.865
390	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.866	\N	2022-07-01 22:05:08.866
390	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.866	\N	2022-07-01 22:05:08.866
390	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.866	\N	2022-07-01 22:05:08.866
390	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.874	\N	2022-07-01 22:05:08.874
390	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.874	\N	2022-07-01 22:05:08.874
390	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.875	\N	2022-07-01 22:05:08.875
390	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:08.875	\N	2022-07-01 22:05:08.875
390	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:08.875	\N	2022-07-01 22:05:08.875
390	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.875	\N	2022-07-01 22:05:08.875
489	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.311	\N	2022-07-01 22:05:12.311
389	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.85	\N	2022-07-01 22:05:08.85
389	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.85	\N	2022-07-01 22:05:08.85
390	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.866	\N	2022-07-01 22:05:08.866
390	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.867	\N	2022-07-01 22:05:08.867
390	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.868	\N	2022-07-01 22:05:08.868
390	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.868	\N	2022-07-01 22:05:08.868
390	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.868	\N	2022-07-01 22:05:08.868
390	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.868	\N	2022-07-01 22:05:08.868
390	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.869	\N	2022-07-01 22:05:08.869
390	300210000	13	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.869	\N	2022-07-01 22:05:08.869
390	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.869	\N	2022-07-01 22:05:08.869
390	300310100	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.869	\N	2022-07-01 22:05:08.869
390	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.87	\N	2022-07-01 22:05:08.87
390	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.87	\N	2022-07-01 22:05:08.87
390	300310300	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.871	\N	2022-07-01 22:05:08.871
390	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.871	\N	2022-07-01 22:05:08.871
390	300310400	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.871	\N	2022-07-01 22:05:08.871
390	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.871	\N	2022-07-01 22:05:08.871
390	300310500	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.872	\N	2022-07-01 22:05:08.872
390	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.872	\N	2022-07-01 22:05:08.872
390	300310600	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.872	\N	2022-07-01 22:05:08.872
390	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.872	\N	2022-07-01 22:05:08.872
390	300310700	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.873	\N	2022-07-01 22:05:08.873
390	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.873	\N	2022-07-01 22:05:08.873
390	300310800	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.873	\N	2022-07-01 22:05:08.873
390	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.874	\N	2022-07-01 22:05:08.874
390	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.875	\N	2022-07-01 22:05:08.875
390	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.876	\N	2022-07-01 22:05:08.876
390	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.88	\N	2022-07-01 22:05:08.88
390	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.88	\N	2022-07-01 22:05:08.88
390	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.88	\N	2022-07-01 22:05:08.88
390	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.88	\N	2022-07-01 22:05:08.88
390	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.881	\N	2022-07-01 22:05:08.881
390	401130000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
390	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.881	\N	2022-07-01 22:05:08.881
390	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.882	\N	2022-07-01 22:05:08.882
390	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.882	\N	2022-07-01 22:05:08.882
390	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.882	\N	2022-07-01 22:05:08.882
390	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.883	\N	2022-07-01 22:05:08.883
390	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.884	\N	2022-07-01 22:05:08.884
390	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.884	\N	2022-07-01 22:05:08.884
390	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.884	\N	2022-07-01 22:05:08.884
390	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.884	\N	2022-07-01 22:05:08.884
390	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.885	\N	2022-07-01 22:05:08.885
390	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.885	\N	2022-07-01 22:05:08.885
391	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:08.885	\N	2022-07-01 22:05:08.885
391	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.885	\N	2022-07-01 22:05:08.885
391	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:08.885	\N	2022-07-01 22:05:08.885
391	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.172	\N	2022-07-01 22:05:09.172
391	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.173	\N	2022-07-01 22:05:09.173
391	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.173	\N	2022-07-01 22:05:09.173
391	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.173	\N	2022-07-01 22:05:09.173
489	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.312	\N	2022-07-01 22:05:12.312
391	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.174	\N	2022-07-01 22:05:09.174
391	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.174	\N	2022-07-01 22:05:09.174
391	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.174	\N	2022-07-01 22:05:09.174
391	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.175	\N	2022-07-01 22:05:09.175
391	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.175	\N	2022-07-01 22:05:09.175
391	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.176	\N	2022-07-01 22:05:09.176
391	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.176	\N	2022-07-01 22:05:09.176
391	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.176	\N	2022-07-01 22:05:09.176
391	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.177	\N	2022-07-01 22:05:09.177
391	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.178	\N	2022-07-01 22:05:09.178
391	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.178	\N	2022-07-01 22:05:09.178
391	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.179	\N	2022-07-01 22:05:09.179
391	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.179	\N	2022-07-01 22:05:09.179
391	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.18	\N	2022-07-01 22:05:09.18
391	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.18	\N	2022-07-01 22:05:09.18
391	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.18	\N	2022-07-01 22:05:09.18
391	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.181	\N	2022-07-01 22:05:09.181
391	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.181	\N	2022-07-01 22:05:09.181
391	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.181	\N	2022-07-01 22:05:09.181
391	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.181	\N	2022-07-01 22:05:09.181
391	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.182	\N	2022-07-01 22:05:09.182
391	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.182	\N	2022-07-01 22:05:09.182
391	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.183	\N	2022-07-01 22:05:09.183
391	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.183	\N	2022-07-01 22:05:09.183
391	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.183	\N	2022-07-01 22:05:09.183
391	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.184	\N	2022-07-01 22:05:09.184
391	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:09.184	\N	2022-07-01 22:05:09.184
391	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:09.184	\N	2022-07-01 22:05:09.184
391	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.185	\N	2022-07-01 22:05:09.185
391	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.185	\N	2022-07-01 22:05:09.185
391	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.185	\N	2022-07-01 22:05:09.185
391	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.189	\N	2022-07-01 22:05:09.189
391	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.189	\N	2022-07-01 22:05:09.189
391	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.19	\N	2022-07-01 22:05:09.19
391	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.19	\N	2022-07-01 22:05:09.19
391	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.19	\N	2022-07-01 22:05:09.19
391	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.191	\N	2022-07-01 22:05:09.191
391	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.192	\N	2022-07-01 22:05:09.192
391	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.192	\N	2022-07-01 22:05:09.192
391	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.192	\N	2022-07-01 22:05:09.192
389	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
390	200010000	10	0	2	3	3	0	0	N	\N	2020-06-30 08:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
390	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
390	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
391	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.193	\N	2022-07-01 22:05:09.193
391	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.193	\N	2022-07-01 22:05:09.193
391	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.194	\N	2022-07-01 22:05:09.194
391	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.194	\N	2022-07-01 22:05:09.194
391	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.194	\N	2022-07-01 22:05:09.194
391	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.195	\N	2022-07-01 22:05:09.195
392	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.195	\N	2022-07-01 22:05:09.195
392	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.196	\N	2022-07-01 22:05:09.196
392	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.196	\N	2022-07-01 22:05:09.196
392	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.196	\N	2022-07-01 22:05:09.196
392	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.197	\N	2022-07-01 22:05:09.197
392	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.197	\N	2022-07-01 22:05:09.197
392	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.197	\N	2022-07-01 22:05:09.197
392	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.198	\N	2022-07-01 22:05:09.198
392	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.198	\N	2022-07-01 22:05:09.198
392	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.199	\N	2022-07-01 22:05:09.199
391	401130000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
392	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.199	\N	2022-07-01 22:05:09.199
392	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.199	\N	2022-07-01 22:05:09.199
392	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.199	\N	2022-07-01 22:05:09.199
392	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.2	\N	2022-07-01 22:05:09.2
489	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.312	\N	2022-07-01 22:05:12.312
392	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.201	\N	2022-07-01 22:05:09.201
392	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.201	\N	2022-07-01 22:05:09.201
392	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.202	\N	2022-07-01 22:05:09.202
392	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.203	\N	2022-07-01 22:05:09.203
392	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.203	\N	2022-07-01 22:05:09.203
392	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.204	\N	2022-07-01 22:05:09.204
392	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.204	\N	2022-07-01 22:05:09.204
392	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.204	\N	2022-07-01 22:05:09.204
392	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.205	\N	2022-07-01 22:05:09.205
392	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.205	\N	2022-07-01 22:05:09.205
392	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.205	\N	2022-07-01 22:05:09.205
392	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.206	\N	2022-07-01 22:05:09.206
392	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.206	\N	2022-07-01 22:05:09.206
392	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.207	\N	2022-07-01 22:05:09.207
392	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.207	\N	2022-07-01 22:05:09.207
392	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.207	\N	2022-07-01 22:05:09.207
392	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.208	\N	2022-07-01 22:05:09.208
392	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.208	\N	2022-07-01 22:05:09.208
392	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.209	\N	2022-07-01 22:05:09.209
392	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:09.209	\N	2022-07-01 22:05:09.209
392	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:09.209	\N	2022-07-01 22:05:09.209
392	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.209	\N	2022-07-01 22:05:09.209
392	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.21	\N	2022-07-01 22:05:09.21
392	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.21	\N	2022-07-01 22:05:09.21
392	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.211	\N	2022-07-01 22:05:09.211
392	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.211	\N	2022-07-01 22:05:09.211
392	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.212	\N	2022-07-01 22:05:09.212
392	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.212	\N	2022-07-01 22:05:09.212
392	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.212	\N	2022-07-01 22:05:09.212
392	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.213	\N	2022-07-01 22:05:09.213
392	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.214	\N	2022-07-01 22:05:09.214
392	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.214	\N	2022-07-01 22:05:09.214
392	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.218	\N	2022-07-01 22:05:09.218
392	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.218	\N	2022-07-01 22:05:09.218
392	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.219	\N	2022-07-01 22:05:09.219
392	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.219	\N	2022-07-01 22:05:09.219
392	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.219	\N	2022-07-01 22:05:09.219
392	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.22	\N	2022-07-01 22:05:09.22
392	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.22	\N	2022-07-01 22:05:09.22
393	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.22	\N	2022-07-01 22:05:09.22
393	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.221	\N	2022-07-01 22:05:09.221
393	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.221	\N	2022-07-01 22:05:09.221
393	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.221	\N	2022-07-01 22:05:09.221
393	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.222	\N	2022-07-01 22:05:09.222
393	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.222	\N	2022-07-01 22:05:09.222
393	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.223	\N	2022-07-01 22:05:09.223
393	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.223	\N	2022-07-01 22:05:09.223
393	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.223	\N	2022-07-01 22:05:09.223
393	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.224	\N	2022-07-01 22:05:09.224
393	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.224	\N	2022-07-01 22:05:09.224
393	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.224	\N	2022-07-01 22:05:09.224
393	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.225	\N	2022-07-01 22:05:09.225
393	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.225	\N	2022-07-01 22:05:09.225
393	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.225	\N	2022-07-01 22:05:09.225
393	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.226	\N	2022-07-01 22:05:09.226
391	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
391	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
393	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.226	\N	2022-07-01 22:05:09.226
489	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.312	\N	2022-07-01 22:05:12.312
393	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.227	\N	2022-07-01 22:05:09.227
393	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.228	\N	2022-07-01 22:05:09.228
393	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.228	\N	2022-07-01 22:05:09.228
393	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.228	\N	2022-07-01 22:05:09.228
393	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.229	\N	2022-07-01 22:05:09.229
393	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.229	\N	2022-07-01 22:05:09.229
393	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.229	\N	2022-07-01 22:05:09.229
393	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.23	\N	2022-07-01 22:05:09.23
393	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.23	\N	2022-07-01 22:05:09.23
393	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.23	\N	2022-07-01 22:05:09.23
393	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.231	\N	2022-07-01 22:05:09.231
392	401130000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
393	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.231	\N	2022-07-01 22:05:09.231
393	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.231	\N	2022-07-01 22:05:09.231
393	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.232	\N	2022-07-01 22:05:09.232
393	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.233	\N	2022-07-01 22:05:09.233
393	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.233	\N	2022-07-01 22:05:09.233
393	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:09.233	\N	2022-07-01 22:05:09.233
393	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:09.234	\N	2022-07-01 22:05:09.234
393	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.234	\N	2022-07-01 22:05:09.234
393	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.234	\N	2022-07-01 22:05:09.234
393	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.235	\N	2022-07-01 22:05:09.235
393	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.236	\N	2022-07-01 22:05:09.236
393	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.236	\N	2022-07-01 22:05:09.236
393	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.236	\N	2022-07-01 22:05:09.236
393	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.237	\N	2022-07-01 22:05:09.237
393	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.237	\N	2022-07-01 22:05:09.237
393	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.237	\N	2022-07-01 22:05:09.237
393	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.238	\N	2022-07-01 22:05:09.238
393	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.239	\N	2022-07-01 22:05:09.239
393	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.239	\N	2022-07-01 22:05:09.239
393	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.243	\N	2022-07-01 22:05:09.243
393	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.243	\N	2022-07-01 22:05:09.243
393	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.244	\N	2022-07-01 22:05:09.244
393	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.244	\N	2022-07-01 22:05:09.244
393	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.244	\N	2022-07-01 22:05:09.244
393	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.245	\N	2022-07-01 22:05:09.245
393	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.245	\N	2022-07-01 22:05:09.245
394	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.246	\N	2022-07-01 22:05:09.246
394	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.246	\N	2022-07-01 22:05:09.246
394	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.246	\N	2022-07-01 22:05:09.246
394	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.247	\N	2022-07-01 22:05:09.247
394	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.247	\N	2022-07-01 22:05:09.247
394	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.247	\N	2022-07-01 22:05:09.247
394	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.248	\N	2022-07-01 22:05:09.248
394	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.248	\N	2022-07-01 22:05:09.248
394	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.248	\N	2022-07-01 22:05:09.248
394	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.249	\N	2022-07-01 22:05:09.249
394	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.249	\N	2022-07-01 22:05:09.249
394	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.25	\N	2022-07-01 22:05:09.25
394	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.25	\N	2022-07-01 22:05:09.25
394	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.25	\N	2022-07-01 22:05:09.25
394	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.251	\N	2022-07-01 22:05:09.251
394	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.251	\N	2022-07-01 22:05:09.251
394	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.251	\N	2022-07-01 22:05:09.251
394	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.253	\N	2022-07-01 22:05:09.253
394	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.253	\N	2022-07-01 22:05:09.253
394	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.253	\N	2022-07-01 22:05:09.253
394	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.254	\N	2022-07-01 22:05:09.254
394	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.255	\N	2022-07-01 22:05:09.255
394	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.255	\N	2022-07-01 22:05:09.255
394	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.255	\N	2022-07-01 22:05:09.255
394	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.256	\N	2022-07-01 22:05:09.256
394	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.256	\N	2022-07-01 22:05:09.256
394	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.256	\N	2022-07-01 22:05:09.256
394	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.257	\N	2022-07-01 22:05:09.257
394	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.257	\N	2022-07-01 22:05:09.257
394	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.258	\N	2022-07-01 22:05:09.258
394	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.258	\N	2022-07-01 22:05:09.258
394	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.258	\N	2022-07-01 22:05:09.258
394	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.259	\N	2022-07-01 22:05:09.259
392	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
392	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
393	200010000	10	0	2	3	3	0	0	N	\N	2020-06-30 08:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
393	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
394	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:09.259	\N	2022-07-01 22:05:09.259
394	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.26	\N	2022-07-01 22:05:09.26
394	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.26	\N	2022-07-01 22:05:09.26
394	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.26	\N	2022-07-01 22:05:09.26
394	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.261	\N	2022-07-01 22:05:09.261
394	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.261	\N	2022-07-01 22:05:09.261
394	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.262	\N	2022-07-01 22:05:09.262
394	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.262	\N	2022-07-01 22:05:09.262
394	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.262	\N	2022-07-01 22:05:09.262
394	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.263	\N	2022-07-01 22:05:09.263
394	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.264	\N	2022-07-01 22:05:09.264
394	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.264	\N	2022-07-01 22:05:09.264
393	401130000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
394	401121000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
394	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.264	\N	2022-07-01 22:05:09.264
394	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.269	\N	2022-07-01 22:05:09.269
394	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.269	\N	2022-07-01 22:05:09.269
394	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.269	\N	2022-07-01 22:05:09.269
394	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.27	\N	2022-07-01 22:05:09.27
394	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.27	\N	2022-07-01 22:05:09.27
394	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.27	\N	2022-07-01 22:05:09.27
394	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.271	\N	2022-07-01 22:05:09.271
395	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.271	\N	2022-07-01 22:05:09.271
395	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.271	\N	2022-07-01 22:05:09.271
395	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.272	\N	2022-07-01 22:05:09.272
395	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.272	\N	2022-07-01 22:05:09.272
395	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.272	\N	2022-07-01 22:05:09.272
395	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.273	\N	2022-07-01 22:05:09.273
395	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.273	\N	2022-07-01 22:05:09.273
395	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.273	\N	2022-07-01 22:05:09.273
395	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.274	\N	2022-07-01 22:05:09.274
395	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.274	\N	2022-07-01 22:05:09.274
395	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.274	\N	2022-07-01 22:05:09.274
395	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.275	\N	2022-07-01 22:05:09.275
395	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.275	\N	2022-07-01 22:05:09.275
395	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.275	\N	2022-07-01 22:05:09.275
395	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.276	\N	2022-07-01 22:05:09.276
395	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.276	\N	2022-07-01 22:05:09.276
395	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.277	\N	2022-07-01 22:05:09.277
395	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.278	\N	2022-07-01 22:05:09.278
395	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.278	\N	2022-07-01 22:05:09.278
395	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.279	\N	2022-07-01 22:05:09.279
395	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.279	\N	2022-07-01 22:05:09.279
395	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.279	\N	2022-07-01 22:05:09.279
395	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.28	\N	2022-07-01 22:05:09.28
395	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.28	\N	2022-07-01 22:05:09.28
395	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.28	\N	2022-07-01 22:05:09.28
489	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.313	\N	2022-07-01 22:05:12.313
395	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.281	\N	2022-07-01 22:05:09.281
395	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.282	\N	2022-07-01 22:05:09.282
395	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.282	\N	2022-07-01 22:05:09.282
395	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.282	\N	2022-07-01 22:05:09.282
395	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.283	\N	2022-07-01 22:05:09.283
395	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.283	\N	2022-07-01 22:05:09.283
395	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.284	\N	2022-07-01 22:05:09.284
395	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.284	\N	2022-07-01 22:05:09.284
395	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:09.284	\N	2022-07-01 22:05:09.284
395	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:09.285	\N	2022-07-01 22:05:09.285
395	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.285	\N	2022-07-01 22:05:09.285
395	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.285	\N	2022-07-01 22:05:09.285
395	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.286	\N	2022-07-01 22:05:09.286
395	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.287	\N	2022-07-01 22:05:09.287
395	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.287	\N	2022-07-01 22:05:09.287
395	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.287	\N	2022-07-01 22:05:09.287
395	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.288	\N	2022-07-01 22:05:09.288
395	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.288	\N	2022-07-01 22:05:09.288
395	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.288	\N	2022-07-01 22:05:09.288
395	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.289	\N	2022-07-01 22:05:09.289
395	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.29	\N	2022-07-01 22:05:09.29
395	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.29	\N	2022-07-01 22:05:09.29
395	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.293	\N	2022-07-01 22:05:09.293
395	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.293	\N	2022-07-01 22:05:09.293
395	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.294	\N	2022-07-01 22:05:09.294
395	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.294	\N	2022-07-01 22:05:09.294
395	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.295	\N	2022-07-01 22:05:09.295
395	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.295	\N	2022-07-01 22:05:09.295
396	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.295	\N	2022-07-01 22:05:09.295
394	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
394	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
396	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.296	\N	2022-07-01 22:05:09.296
396	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.296	\N	2022-07-01 22:05:09.296
396	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.296	\N	2022-07-01 22:05:09.296
396	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.297	\N	2022-07-01 22:05:09.297
396	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.297	\N	2022-07-01 22:05:09.297
396	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.297	\N	2022-07-01 22:05:09.297
396	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.298	\N	2022-07-01 22:05:09.298
396	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.298	\N	2022-07-01 22:05:09.298
396	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.298	\N	2022-07-01 22:05:09.298
396	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.299	\N	2022-07-01 22:05:09.299
396	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.299	\N	2022-07-01 22:05:09.299
396	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.299	\N	2022-07-01 22:05:09.299
396	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.3	\N	2022-07-01 22:05:09.3
396	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.3	\N	2022-07-01 22:05:09.3
396	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.3	\N	2022-07-01 22:05:09.3
396	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.301	\N	2022-07-01 22:05:09.301
396	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.301	\N	2022-07-01 22:05:09.301
396	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.311	\N	2022-07-01 22:05:09.311
396	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.312	\N	2022-07-01 22:05:09.312
396	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.312	\N	2022-07-01 22:05:09.312
396	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.313	\N	2022-07-01 22:05:09.313
396	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.314	\N	2022-07-01 22:05:09.314
396	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.314	\N	2022-07-01 22:05:09.314
489	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.313	\N	2022-07-01 22:05:12.313
396	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.318	\N	2022-07-01 22:05:09.318
396	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.318	\N	2022-07-01 22:05:09.318
396	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.319	\N	2022-07-01 22:05:09.319
396	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.32	\N	2022-07-01 22:05:09.32
397	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.32	\N	2022-07-01 22:05:09.32
397	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.32	\N	2022-07-01 22:05:09.32
397	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.321	\N	2022-07-01 22:05:09.321
397	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.321	\N	2022-07-01 22:05:09.321
397	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.321	\N	2022-07-01 22:05:09.321
397	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.322	\N	2022-07-01 22:05:09.322
397	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.322	\N	2022-07-01 22:05:09.322
397	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.322	\N	2022-07-01 22:05:09.322
397	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.322	\N	2022-07-01 22:05:09.322
397	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.323	\N	2022-07-01 22:05:09.323
397	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.323	\N	2022-07-01 22:05:09.323
397	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.323	\N	2022-07-01 22:05:09.323
397	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.324	\N	2022-07-01 22:05:09.324
397	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.324	\N	2022-07-01 22:05:09.324
397	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.325	\N	2022-07-01 22:05:09.325
397	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.325	\N	2022-07-01 22:05:09.325
397	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.325	\N	2022-07-01 22:05:09.325
397	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.327	\N	2022-07-01 22:05:09.327
397	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.327	\N	2022-07-01 22:05:09.327
397	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.328	\N	2022-07-01 22:05:09.328
397	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.328	\N	2022-07-01 22:05:09.328
397	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.328	\N	2022-07-01 22:05:09.328
397	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.329	\N	2022-07-01 22:05:09.329
397	300210000	13	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.329	\N	2022-07-01 22:05:09.329
397	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.329	\N	2022-07-01 22:05:09.329
397	300310100	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.33	\N	2022-07-01 22:05:09.33
397	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.33	\N	2022-07-01 22:05:09.33
397	300310200	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.33	\N	2022-07-01 22:05:09.33
397	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.331	\N	2022-07-01 22:05:09.331
397	300310300	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.331	\N	2022-07-01 22:05:09.331
397	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.331	\N	2022-07-01 22:05:09.331
397	300310400	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.332	\N	2022-07-01 22:05:09.332
397	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.332	\N	2022-07-01 22:05:09.332
397	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.333	\N	2022-07-01 22:05:09.333
397	300310600	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.333	\N	2022-07-01 22:05:09.333
397	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.333	\N	2022-07-01 22:05:09.333
397	300310700	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.334	\N	2022-07-01 22:05:09.334
397	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.334	\N	2022-07-01 22:05:09.334
397	300310800	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.334	\N	2022-07-01 22:05:09.334
397	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.335	\N	2022-07-01 22:05:09.335
397	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.348	\N	2022-07-01 22:05:09.348
397	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.348	\N	2022-07-01 22:05:09.348
397	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.349	\N	2022-07-01 22:05:09.349
397	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.349	\N	2022-07-01 22:05:09.349
397	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.349	\N	2022-07-01 22:05:09.349
397	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.35	\N	2022-07-01 22:05:09.35
398	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.35	\N	2022-07-01 22:05:09.35
398	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.35	\N	2022-07-01 22:05:09.35
395	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
395	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
398	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.351	\N	2022-07-01 22:05:09.351
398	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.351	\N	2022-07-01 22:05:09.351
398	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.351	\N	2022-07-01 22:05:09.351
398	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.352	\N	2022-07-01 22:05:09.352
398	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.352	\N	2022-07-01 22:05:09.352
398	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.352	\N	2022-07-01 22:05:09.352
398	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.352	\N	2022-07-01 22:05:09.352
398	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.353	\N	2022-07-01 22:05:09.353
398	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.353	\N	2022-07-01 22:05:09.353
489	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.313	\N	2022-07-01 22:05:12.313
398	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.354	\N	2022-07-01 22:05:09.354
398	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.354	\N	2022-07-01 22:05:09.354
398	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.355	\N	2022-07-01 22:05:09.355
398	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.355	\N	2022-07-01 22:05:09.355
398	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.355	\N	2022-07-01 22:05:09.355
398	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.357	\N	2022-07-01 22:05:09.357
398	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.357	\N	2022-07-01 22:05:09.357
398	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.357	\N	2022-07-01 22:05:09.357
398	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.358	\N	2022-07-01 22:05:09.358
398	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.358	\N	2022-07-01 22:05:09.358
398	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.358	\N	2022-07-01 22:05:09.358
398	300210000	13	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.359	\N	2022-07-01 22:05:09.359
398	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.359	\N	2022-07-01 22:05:09.359
398	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.36	\N	2022-07-01 22:05:09.36
398	300310200	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.36	\N	2022-07-01 22:05:09.36
398	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.646	\N	2022-07-01 22:05:09.646
398	300310300	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.646	\N	2022-07-01 22:05:09.646
398	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.646	\N	2022-07-01 22:05:09.646
398	300310400	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.646	\N	2022-07-01 22:05:09.646
398	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.647	\N	2022-07-01 22:05:09.647
398	300310500	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.647	\N	2022-07-01 22:05:09.647
398	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.647	\N	2022-07-01 22:05:09.647
398	300310600	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.647	\N	2022-07-01 22:05:09.647
398	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.648	\N	2022-07-01 22:05:09.648
398	300310700	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.648	\N	2022-07-01 22:05:09.648
398	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.648	\N	2022-07-01 22:05:09.648
398	300310800	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.648	\N	2022-07-01 22:05:09.648
398	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.649	\N	2022-07-01 22:05:09.649
398	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.649	\N	2022-07-01 22:05:09.649
398	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.65	\N	2022-07-01 22:05:09.65
398	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.65	\N	2022-07-01 22:05:09.65
398	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:09.65	\N	2022-07-01 22:05:09.65
398	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.651	\N	2022-07-01 22:05:09.651
398	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.651	\N	2022-07-01 22:05:09.651
398	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.651	\N	2022-07-01 22:05:09.651
398	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.659	\N	2022-07-01 22:05:09.659
398	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.659	\N	2022-07-01 22:05:09.659
398	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.659	\N	2022-07-01 22:05:09.659
398	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.66	\N	2022-07-01 22:05:09.66
398	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.66	\N	2022-07-01 22:05:09.66
398	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.66	\N	2022-07-01 22:05:09.66
398	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.66	\N	2022-07-01 22:05:09.66
399	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.66	\N	2022-07-01 22:05:09.66
399	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.661	\N	2022-07-01 22:05:09.661
399	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.661	\N	2022-07-01 22:05:09.661
399	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.661	\N	2022-07-01 22:05:09.661
399	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.661	\N	2022-07-01 22:05:09.661
399	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.662	\N	2022-07-01 22:05:09.662
399	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.665	\N	2022-07-01 22:05:09.665
399	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.666	\N	2022-07-01 22:05:09.666
399	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.666	\N	2022-07-01 22:05:09.666
399	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.666	\N	2022-07-01 22:05:09.666
399	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.667	\N	2022-07-01 22:05:09.667
399	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.667	\N	2022-07-01 22:05:09.667
399	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.667	\N	2022-07-01 22:05:09.667
399	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.667	\N	2022-07-01 22:05:09.667
399	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.668	\N	2022-07-01 22:05:09.668
399	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.668	\N	2022-07-01 22:05:09.668
399	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.668	\N	2022-07-01 22:05:09.668
399	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.668	\N	2022-07-01 22:05:09.668
399	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.668	\N	2022-07-01 22:05:09.668
399	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.669	\N	2022-07-01 22:05:09.669
399	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.669	\N	2022-07-01 22:05:09.669
399	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.669	\N	2022-07-01 22:05:09.669
397	200010000	10	0	2	3	3	0	0	N	\N	2020-06-30 08:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
397	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
397	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
399	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.67	\N	2022-07-01 22:05:09.67
399	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.67	\N	2022-07-01 22:05:09.67
489	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.313	\N	2022-07-01 22:05:12.313
399	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.671	\N	2022-07-01 22:05:09.671
399	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.671	\N	2022-07-01 22:05:09.671
399	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.671	\N	2022-07-01 22:05:09.671
399	401121000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
399	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.672	\N	2022-07-01 22:05:09.672
399	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.672	\N	2022-07-01 22:05:09.672
399	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.672	\N	2022-07-01 22:05:09.672
399	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.673	\N	2022-07-01 22:05:09.673
399	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.673	\N	2022-07-01 22:05:09.673
399	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.673	\N	2022-07-01 22:05:09.673
399	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.674	\N	2022-07-01 22:05:09.674
399	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.674	\N	2022-07-01 22:05:09.674
399	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.674	\N	2022-07-01 22:05:09.674
400	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.683	\N	2022-07-01 22:05:09.683
400	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.684	\N	2022-07-01 22:05:09.684
400	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.685	\N	2022-07-01 22:05:09.685
400	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.685	\N	2022-07-01 22:05:09.685
400	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.685	\N	2022-07-01 22:05:09.685
400	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.685	\N	2022-07-01 22:05:09.685
400	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.686	\N	2022-07-01 22:05:09.686
400	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.686	\N	2022-07-01 22:05:09.686
400	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.686	\N	2022-07-01 22:05:09.686
400	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.686	\N	2022-07-01 22:05:09.686
400	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.686	\N	2022-07-01 22:05:09.686
400	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.687	\N	2022-07-01 22:05:09.687
400	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.687	\N	2022-07-01 22:05:09.687
400	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.687	\N	2022-07-01 22:05:09.687
400	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.687	\N	2022-07-01 22:05:09.687
400	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.688	\N	2022-07-01 22:05:09.688
400	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.688	\N	2022-07-01 22:05:09.688
400	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.688	\N	2022-07-01 22:05:09.688
400	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.689	\N	2022-07-01 22:05:09.689
400	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.689	\N	2022-07-01 22:05:09.689
400	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:09.689	\N	2022-07-01 22:05:09.689
400	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:09.689	\N	2022-07-01 22:05:09.689
400	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.69	\N	2022-07-01 22:05:09.69
400	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.69	\N	2022-07-01 22:05:09.69
400	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.69	\N	2022-07-01 22:05:09.69
400	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.693	\N	2022-07-01 22:05:09.693
400	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.693	\N	2022-07-01 22:05:09.693
400	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.693	\N	2022-07-01 22:05:09.693
400	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.697	\N	2022-07-01 22:05:09.697
400	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.697	\N	2022-07-01 22:05:09.697
400	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.697	\N	2022-07-01 22:05:09.697
400	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.697	\N	2022-07-01 22:05:09.697
400	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.698	\N	2022-07-01 22:05:09.698
400	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.698	\N	2022-07-01 22:05:09.698
400	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.698	\N	2022-07-01 22:05:09.698
401	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.698	\N	2022-07-01 22:05:09.698
401	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.699	\N	2022-07-01 22:05:09.699
401	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.699	\N	2022-07-01 22:05:09.699
489	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:12.314	\N	2022-07-01 22:05:12.314
401	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.699	\N	2022-07-01 22:05:09.699
401	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.7	\N	2022-07-01 22:05:09.7
401	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.7	\N	2022-07-01 22:05:09.7
401	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.7	\N	2022-07-01 22:05:09.7
401	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.7	\N	2022-07-01 22:05:09.7
401	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.708	\N	2022-07-01 22:05:09.708
401	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:09.708	\N	2022-07-01 22:05:09.708
401	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:09.708	\N	2022-07-01 22:05:09.708
401	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.709	\N	2022-07-01 22:05:09.709
401	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.709	\N	2022-07-01 22:05:09.709
401	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.709	\N	2022-07-01 22:05:09.709
401	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.71	\N	2022-07-01 22:05:09.71
401	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.71	\N	2022-07-01 22:05:09.71
401	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.71	\N	2022-07-01 22:05:09.71
401	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.711	\N	2022-07-01 22:05:09.711
401	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.711	\N	2022-07-01 22:05:09.711
401	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.712	\N	2022-07-01 22:05:09.712
401	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.712	\N	2022-07-01 22:05:09.712
401	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.712	\N	2022-07-01 22:05:09.712
401	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.715	\N	2022-07-01 22:05:09.715
398	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
398	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
399	200010000	10	0	2	3	3	0	0	N	\N	2020-06-30 08:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
399	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
399	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
401	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.715	\N	2022-07-01 22:05:09.715
401	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.716	\N	2022-07-01 22:05:09.716
402	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.717	\N	2022-07-01 22:05:09.717
402	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.717	\N	2022-07-01 22:05:09.717
402	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.717	\N	2022-07-01 22:05:09.717
402	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.717	\N	2022-07-01 22:05:09.717
402	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.718	\N	2022-07-01 22:05:09.718
401	401121000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
402	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.718	\N	2022-07-01 22:05:09.718
402	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.718	\N	2022-07-01 22:05:09.718
402	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.719	\N	2022-07-01 22:05:09.719
402	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.719	\N	2022-07-01 22:05:09.719
402	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.719	\N	2022-07-01 22:05:09.719
402	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.719	\N	2022-07-01 22:05:09.719
402	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.72	\N	2022-07-01 22:05:09.72
402	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.72	\N	2022-07-01 22:05:09.72
402	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.72	\N	2022-07-01 22:05:09.72
402	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.72	\N	2022-07-01 22:05:09.72
402	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.721	\N	2022-07-01 22:05:09.721
402	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.721	\N	2022-07-01 22:05:09.721
402	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.722	\N	2022-07-01 22:05:09.722
402	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.722	\N	2022-07-01 22:05:09.722
402	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.722	\N	2022-07-01 22:05:09.722
402	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.723	\N	2022-07-01 22:05:09.723
402	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.723	\N	2022-07-01 22:05:09.723
402	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.723	\N	2022-07-01 22:05:09.723
402	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.723	\N	2022-07-01 22:05:09.723
402	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.724	\N	2022-07-01 22:05:09.724
402	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.724	\N	2022-07-01 22:05:09.724
402	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.724	\N	2022-07-01 22:05:09.724
402	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.725	\N	2022-07-01 22:05:09.725
402	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.725	\N	2022-07-01 22:05:09.725
402	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.725	\N	2022-07-01 22:05:09.725
402	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.731	\N	2022-07-01 22:05:09.731
402	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.731	\N	2022-07-01 22:05:09.731
489	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:12.314	\N	2022-07-01 22:05:12.314
402	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.734	\N	2022-07-01 22:05:09.734
402	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.734	\N	2022-07-01 22:05:09.734
402	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.735	\N	2022-07-01 22:05:09.735
402	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.735	\N	2022-07-01 22:05:09.735
402	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.735	\N	2022-07-01 22:05:09.735
402	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.735	\N	2022-07-01 22:05:09.735
402	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.736	\N	2022-07-01 22:05:09.736
403	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.736	\N	2022-07-01 22:05:09.736
403	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.736	\N	2022-07-01 22:05:09.736
403	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.736	\N	2022-07-01 22:05:09.736
403	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.737	\N	2022-07-01 22:05:09.737
403	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.737	\N	2022-07-01 22:05:09.737
403	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.737	\N	2022-07-01 22:05:09.737
403	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.738	\N	2022-07-01 22:05:09.738
403	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.738	\N	2022-07-01 22:05:09.738
403	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.738	\N	2022-07-01 22:05:09.738
403	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.738	\N	2022-07-01 22:05:09.738
403	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.739	\N	2022-07-01 22:05:09.739
403	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.739	\N	2022-07-01 22:05:09.739
403	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.739	\N	2022-07-01 22:05:09.739
403	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.739	\N	2022-07-01 22:05:09.739
403	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.74	\N	2022-07-01 22:05:09.74
403	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.74	\N	2022-07-01 22:05:09.74
403	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.74	\N	2022-07-01 22:05:09.74
403	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.741	\N	2022-07-01 22:05:09.741
403	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.742	\N	2022-07-01 22:05:09.742
403	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.742	\N	2022-07-01 22:05:09.742
403	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.742	\N	2022-07-01 22:05:09.742
403	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.742	\N	2022-07-01 22:05:09.742
403	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.743	\N	2022-07-01 22:05:09.743
403	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.743	\N	2022-07-01 22:05:09.743
403	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.743	\N	2022-07-01 22:05:09.743
403	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.744	\N	2022-07-01 22:05:09.744
403	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.744	\N	2022-07-01 22:05:09.744
403	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.744	\N	2022-07-01 22:05:09.744
403	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.744	\N	2022-07-01 22:05:09.744
403	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.745	\N	2022-07-01 22:05:09.745
403	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.746	\N	2022-07-01 22:05:09.746
403	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.746	\N	2022-07-01 22:05:09.746
403	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.746	\N	2022-07-01 22:05:09.746
403	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.746	\N	2022-07-01 22:05:09.746
400	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
400	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
403	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:09.747	\N	2022-07-01 22:05:09.747
403	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:09.747	\N	2022-07-01 22:05:09.747
403	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.747	\N	2022-07-01 22:05:09.747
403	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.747	\N	2022-07-01 22:05:09.747
403	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.748	\N	2022-07-01 22:05:09.748
403	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.748	\N	2022-07-01 22:05:09.748
403	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.749	\N	2022-07-01 22:05:09.749
403	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.749	\N	2022-07-01 22:05:09.749
403	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.749	\N	2022-07-01 22:05:09.749
403	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.749	\N	2022-07-01 22:05:09.749
403	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.75	\N	2022-07-01 22:05:09.75
403	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.751	\N	2022-07-01 22:05:09.751
403	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.751	\N	2022-07-01 22:05:09.751
404	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.757	\N	2022-07-01 22:05:09.757
404	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.757	\N	2022-07-01 22:05:09.757
404	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.758	\N	2022-07-01 22:05:09.758
404	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.758	\N	2022-07-01 22:05:09.758
404	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.758	\N	2022-07-01 22:05:09.758
404	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.759	\N	2022-07-01 22:05:09.759
489	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:12.314	\N	2022-07-01 22:05:12.314
404	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.759	\N	2022-07-01 22:05:09.759
404	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.76	\N	2022-07-01 22:05:09.76
404	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.76	\N	2022-07-01 22:05:09.76
404	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.76	\N	2022-07-01 22:05:09.76
404	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.761	\N	2022-07-01 22:05:09.761
404	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.761	\N	2022-07-01 22:05:09.761
404	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.761	\N	2022-07-01 22:05:09.761
404	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.761	\N	2022-07-01 22:05:09.761
404	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.762	\N	2022-07-01 22:05:09.762
404	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.762	\N	2022-07-01 22:05:09.762
404	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.762	\N	2022-07-01 22:05:09.762
404	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.762	\N	2022-07-01 22:05:09.762
404	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.763	\N	2022-07-01 22:05:09.763
404	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.763	\N	2022-07-01 22:05:09.763
404	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.763	\N	2022-07-01 22:05:09.763
404	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.764	\N	2022-07-01 22:05:09.764
404	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.764	\N	2022-07-01 22:05:09.764
404	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.764	\N	2022-07-01 22:05:09.764
404	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.765	\N	2022-07-01 22:05:09.765
404	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:09.765	\N	2022-07-01 22:05:09.765
404	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:09.765	\N	2022-07-01 22:05:09.765
404	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.765	\N	2022-07-01 22:05:09.765
404	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.766	\N	2022-07-01 22:05:09.766
404	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.766	\N	2022-07-01 22:05:09.766
404	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.767	\N	2022-07-01 22:05:09.767
404	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.767	\N	2022-07-01 22:05:09.767
404	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.767	\N	2022-07-01 22:05:09.767
404	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.767	\N	2022-07-01 22:05:09.767
404	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.767	\N	2022-07-01 22:05:09.767
404	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.768	\N	2022-07-01 22:05:09.768
404	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.768	\N	2022-07-01 22:05:09.768
404	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.769	\N	2022-07-01 22:05:09.769
404	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.769	\N	2022-07-01 22:05:09.769
404	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.772	\N	2022-07-01 22:05:09.772
404	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.772	\N	2022-07-01 22:05:09.772
404	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.773	\N	2022-07-01 22:05:09.773
404	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.773	\N	2022-07-01 22:05:09.773
404	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.773	\N	2022-07-01 22:05:09.773
404	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.773	\N	2022-07-01 22:05:09.773
404	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.774	\N	2022-07-01 22:05:09.774
405	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.774	\N	2022-07-01 22:05:09.774
405	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.774	\N	2022-07-01 22:05:09.774
405	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.774	\N	2022-07-01 22:05:09.774
405	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.775	\N	2022-07-01 22:05:09.775
405	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.775	\N	2022-07-01 22:05:09.775
405	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.775	\N	2022-07-01 22:05:09.775
405	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.775	\N	2022-07-01 22:05:09.775
405	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.775	\N	2022-07-01 22:05:09.775
405	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.776	\N	2022-07-01 22:05:09.776
405	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.284	\N	2022-07-01 22:05:10.284
405	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.285	\N	2022-07-01 22:05:10.285
405	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.285	\N	2022-07-01 22:05:10.285
405	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.285	\N	2022-07-01 22:05:10.285
405	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.285	\N	2022-07-01 22:05:10.285
405	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.286	\N	2022-07-01 22:05:10.286
405	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.286	\N	2022-07-01 22:05:10.286
402	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
403	200010000	10	0	2	3	3	0	0	N	\N	2020-06-30 08:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
403	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
403	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
406	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.286	\N	2022-07-01 22:05:10.286
406	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.286	\N	2022-07-01 22:05:10.286
406	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.286	\N	2022-07-01 22:05:10.286
403	401130000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
404	401121000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
406	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.287	\N	2022-07-01 22:05:10.287
406	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.287	\N	2022-07-01 22:05:10.287
489	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:12.314	\N	2022-07-01 22:05:12.314
405	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:09.784	\N	2022-07-01 22:05:09.784
405	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:09.784	\N	2022-07-01 22:05:09.784
405	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.784	\N	2022-07-01 22:05:09.784
405	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.784	\N	2022-07-01 22:05:09.784
405	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.785	\N	2022-07-01 22:05:09.785
405	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.785	\N	2022-07-01 22:05:09.785
405	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.786	\N	2022-07-01 22:05:09.786
405	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.786	\N	2022-07-01 22:05:09.786
405	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:09.786	\N	2022-07-01 22:05:09.786
405	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.786	\N	2022-07-01 22:05:09.786
405	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:09.787	\N	2022-07-01 22:05:09.787
405	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.281	\N	2022-07-01 22:05:10.281
405	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.281	\N	2022-07-01 22:05:10.281
406	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.287	\N	2022-07-01 22:05:10.287
406	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.287	\N	2022-07-01 22:05:10.287
406	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.288	\N	2022-07-01 22:05:10.288
406	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.288	\N	2022-07-01 22:05:10.288
406	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.288	\N	2022-07-01 22:05:10.288
406	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.288	\N	2022-07-01 22:05:10.288
406	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.289	\N	2022-07-01 22:05:10.289
406	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.289	\N	2022-07-01 22:05:10.289
406	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.289	\N	2022-07-01 22:05:10.289
406	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.289	\N	2022-07-01 22:05:10.289
406	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.29	\N	2022-07-01 22:05:10.29
406	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.29	\N	2022-07-01 22:05:10.29
406	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.29	\N	2022-07-01 22:05:10.29
406	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.291	\N	2022-07-01 22:05:10.291
406	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.291	\N	2022-07-01 22:05:10.291
406	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.292	\N	2022-07-01 22:05:10.292
406	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.292	\N	2022-07-01 22:05:10.292
406	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.292	\N	2022-07-01 22:05:10.292
406	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.292	\N	2022-07-01 22:05:10.292
406	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.293	\N	2022-07-01 22:05:10.293
406	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.293	\N	2022-07-01 22:05:10.293
406	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.293	\N	2022-07-01 22:05:10.293
406	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.293	\N	2022-07-01 22:05:10.293
406	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.294	\N	2022-07-01 22:05:10.294
407	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.312	\N	2022-07-01 22:05:10.312
407	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.312	\N	2022-07-01 22:05:10.312
407	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.312	\N	2022-07-01 22:05:10.312
407	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.313	\N	2022-07-01 22:05:10.313
407	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.313	\N	2022-07-01 22:05:10.313
407	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.313	\N	2022-07-01 22:05:10.313
407	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.314	\N	2022-07-01 22:05:10.314
407	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.314	\N	2022-07-01 22:05:10.314
407	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.314	\N	2022-07-01 22:05:10.314
407	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.314	\N	2022-07-01 22:05:10.314
407	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:10.315	\N	2022-07-01 22:05:10.315
407	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:10.315	\N	2022-07-01 22:05:10.315
407	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.315	\N	2022-07-01 22:05:10.315
407	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.315	\N	2022-07-01 22:05:10.315
407	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.316	\N	2022-07-01 22:05:10.316
407	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.316	\N	2022-07-01 22:05:10.316
407	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.317	\N	2022-07-01 22:05:10.317
407	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.317	\N	2022-07-01 22:05:10.317
407	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.317	\N	2022-07-01 22:05:10.317
407	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.317	\N	2022-07-01 22:05:10.317
407	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.318	\N	2022-07-01 22:05:10.318
407	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.318	\N	2022-07-01 22:05:10.318
407	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.322	\N	2022-07-01 22:05:10.322
407	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.323	\N	2022-07-01 22:05:10.323
407	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.323	\N	2022-07-01 22:05:10.323
407	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.323	\N	2022-07-01 22:05:10.323
407	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.323	\N	2022-07-01 22:05:10.323
406	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.303	\N	2022-07-01 22:05:10.303
406	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.303	\N	2022-07-01 22:05:10.303
406	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.303	\N	2022-07-01 22:05:10.303
404	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
404	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
406	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.304	\N	2022-07-01 22:05:10.304
406	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.304	\N	2022-07-01 22:05:10.304
405	401130000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
406	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.304	\N	2022-07-01 22:05:10.304
406	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.304	\N	2022-07-01 22:05:10.304
407	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.305	\N	2022-07-01 22:05:10.305
407	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.305	\N	2022-07-01 22:05:10.305
407	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.305	\N	2022-07-01 22:05:10.305
407	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.306	\N	2022-07-01 22:05:10.306
407	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.306	\N	2022-07-01 22:05:10.306
407	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.306	\N	2022-07-01 22:05:10.306
407	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.306	\N	2022-07-01 22:05:10.306
407	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.307	\N	2022-07-01 22:05:10.307
407	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.307	\N	2022-07-01 22:05:10.307
407	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.307	\N	2022-07-01 22:05:10.307
407	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.307	\N	2022-07-01 22:05:10.307
407	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.308	\N	2022-07-01 22:05:10.308
407	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.308	\N	2022-07-01 22:05:10.308
407	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.308	\N	2022-07-01 22:05:10.308
407	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.308	\N	2022-07-01 22:05:10.308
407	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.309	\N	2022-07-01 22:05:10.309
407	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.309	\N	2022-07-01 22:05:10.309
407	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.31	\N	2022-07-01 22:05:10.31
407	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.31	\N	2022-07-01 22:05:10.31
408	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.324	\N	2022-07-01 22:05:10.324
408	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.324	\N	2022-07-01 22:05:10.324
408	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.324	\N	2022-07-01 22:05:10.324
408	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.324	\N	2022-07-01 22:05:10.324
408	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.325	\N	2022-07-01 22:05:10.325
408	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.325	\N	2022-07-01 22:05:10.325
408	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.325	\N	2022-07-01 22:05:10.325
408	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.326	\N	2022-07-01 22:05:10.326
408	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.326	\N	2022-07-01 22:05:10.326
408	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.326	\N	2022-07-01 22:05:10.326
408	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.327	\N	2022-07-01 22:05:10.327
408	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.327	\N	2022-07-01 22:05:10.327
408	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.327	\N	2022-07-01 22:05:10.327
408	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.327	\N	2022-07-01 22:05:10.327
408	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.328	\N	2022-07-01 22:05:10.328
408	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.328	\N	2022-07-01 22:05:10.328
408	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.328	\N	2022-07-01 22:05:10.328
408	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.329	\N	2022-07-01 22:05:10.329
408	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.329	\N	2022-07-01 22:05:10.329
408	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.33	\N	2022-07-01 22:05:10.33
408	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.33	\N	2022-07-01 22:05:10.33
408	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.33	\N	2022-07-01 22:05:10.33
408	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.33	\N	2022-07-01 22:05:10.33
408	300210000	13	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.331	\N	2022-07-01 22:05:10.331
408	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.331	\N	2022-07-01 22:05:10.331
408	300310100	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.331	\N	2022-07-01 22:05:10.331
408	300310200	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.332	\N	2022-07-01 22:05:10.332
408	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.332	\N	2022-07-01 22:05:10.332
408	300310300	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.332	\N	2022-07-01 22:05:10.332
408	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.332	\N	2022-07-01 22:05:10.332
408	300310400	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.333	\N	2022-07-01 22:05:10.333
408	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.333	\N	2022-07-01 22:05:10.333
408	300310500	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.333	\N	2022-07-01 22:05:10.333
408	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.333	\N	2022-07-01 22:05:10.333
408	300310600	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.334	\N	2022-07-01 22:05:10.334
408	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.334	\N	2022-07-01 22:05:10.334
408	300310700	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.334	\N	2022-07-01 22:05:10.334
408	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.334	\N	2022-07-01 22:05:10.334
1061	100015010	3	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.298	\N	2022-07-01 22:04:59.298
408	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.335	\N	2022-07-01 22:05:10.335
408	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.336	\N	2022-07-01 22:05:10.336
408	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.336	\N	2022-07-01 22:05:10.336
408	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.336	\N	2022-07-01 22:05:10.336
408	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:10.336	\N	2022-07-01 22:05:10.336
408	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:10.337	\N	2022-07-01 22:05:10.337
408	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.337	\N	2022-07-01 22:05:10.337
408	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.337	\N	2022-07-01 22:05:10.337
408	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.337	\N	2022-07-01 22:05:10.337
408	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.338	\N	2022-07-01 22:05:10.338
408	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.338	\N	2022-07-01 22:05:10.338
408	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.339	\N	2022-07-01 22:05:10.339
408	401130000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
406	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
406	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
408	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.339	\N	2022-07-01 22:05:10.339
408	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.339	\N	2022-07-01 22:05:10.339
408	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.34	\N	2022-07-01 22:05:10.34
408	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.34	\N	2022-07-01 22:05:10.34
408	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.341	\N	2022-07-01 22:05:10.341
408	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.346	\N	2022-07-01 22:05:10.346
409	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.347	\N	2022-07-01 22:05:10.347
409	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.347	\N	2022-07-01 22:05:10.347
409	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.347	\N	2022-07-01 22:05:10.347
409	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.348	\N	2022-07-01 22:05:10.348
409	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.348	\N	2022-07-01 22:05:10.348
409	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.348	\N	2022-07-01 22:05:10.348
409	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.348	\N	2022-07-01 22:05:10.348
409	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.349	\N	2022-07-01 22:05:10.349
409	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.349	\N	2022-07-01 22:05:10.349
409	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.349	\N	2022-07-01 22:05:10.349
409	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.349	\N	2022-07-01 22:05:10.349
409	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.35	\N	2022-07-01 22:05:10.35
409	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.35	\N	2022-07-01 22:05:10.35
409	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.35	\N	2022-07-01 22:05:10.35
409	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.35	\N	2022-07-01 22:05:10.35
409	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.351	\N	2022-07-01 22:05:10.351
409	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.351	\N	2022-07-01 22:05:10.351
409	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.352	\N	2022-07-01 22:05:10.352
409	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.352	\N	2022-07-01 22:05:10.352
409	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.352	\N	2022-07-01 22:05:10.352
409	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.353	\N	2022-07-01 22:05:10.353
409	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.353	\N	2022-07-01 22:05:10.353
409	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.353	\N	2022-07-01 22:05:10.353
409	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.353	\N	2022-07-01 22:05:10.353
409	300310100	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.354	\N	2022-07-01 22:05:10.354
409	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.354	\N	2022-07-01 22:05:10.354
409	300310200	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.354	\N	2022-07-01 22:05:10.354
409	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.354	\N	2022-07-01 22:05:10.354
409	300310300	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.355	\N	2022-07-01 22:05:10.355
409	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.355	\N	2022-07-01 22:05:10.355
409	300310400	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.355	\N	2022-07-01 22:05:10.355
409	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.355	\N	2022-07-01 22:05:10.355
409	300310500	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.356	\N	2022-07-01 22:05:10.356
409	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.356	\N	2022-07-01 22:05:10.356
409	300310600	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.356	\N	2022-07-01 22:05:10.356
409	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.356	\N	2022-07-01 22:05:10.356
409	300310700	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.357	\N	2022-07-01 22:05:10.357
409	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.357	\N	2022-07-01 22:05:10.357
409	300310800	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.357	\N	2022-07-01 22:05:10.357
1061	109011000	5	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.307	\N	2022-07-01 22:04:59.307
409	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.358	\N	2022-07-01 22:05:10.358
409	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.358	\N	2022-07-01 22:05:10.358
409	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.358	\N	2022-07-01 22:05:10.358
409	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.359	\N	2022-07-01 22:05:10.359
409	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:10.359	\N	2022-07-01 22:05:10.359
409	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:10.359	\N	2022-07-01 22:05:10.359
409	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.359	\N	2022-07-01 22:05:10.359
409	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.36	\N	2022-07-01 22:05:10.36
409	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.36	\N	2022-07-01 22:05:10.36
409	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.361	\N	2022-07-01 22:05:10.361
409	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.361	\N	2022-07-01 22:05:10.361
409	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.361	\N	2022-07-01 22:05:10.361
409	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.362	\N	2022-07-01 22:05:10.362
409	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.362	\N	2022-07-01 22:05:10.362
409	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.363	\N	2022-07-01 22:05:10.363
409	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.363	\N	2022-07-01 22:05:10.363
409	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.364	\N	2022-07-01 22:05:10.364
409	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.368	\N	2022-07-01 22:05:10.368
409	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.368	\N	2022-07-01 22:05:10.368
410	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.375	\N	2022-07-01 22:05:10.375
410	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.375	\N	2022-07-01 22:05:10.375
410	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.375	\N	2022-07-01 22:05:10.375
410	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.376	\N	2022-07-01 22:05:10.376
410	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.379	\N	2022-07-01 22:05:10.379
410	300310500	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.379	\N	2022-07-01 22:05:10.379
410	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.379	\N	2022-07-01 22:05:10.379
410	300310600	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.379	\N	2022-07-01 22:05:10.379
409	401130000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
407	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
407	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
408	200010000	10	0	2	3	3	0	0	N	\N	2020-06-30 08:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
408	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
409	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
409	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
410	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.38	\N	2022-07-01 22:05:10.38
410	300310700	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.38	\N	2022-07-01 22:05:10.38
410	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.38	\N	2022-07-01 22:05:10.38
410	300310800	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.38	\N	2022-07-01 22:05:10.38
410	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.381	\N	2022-07-01 22:05:10.381
410	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.382	\N	2022-07-01 22:05:10.382
410	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.382	\N	2022-07-01 22:05:10.382
410	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:10.382	\N	2022-07-01 22:05:10.382
410	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:10.382	\N	2022-07-01 22:05:10.382
410	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.383	\N	2022-07-01 22:05:10.383
410	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.383	\N	2022-07-01 22:05:10.383
410	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.385	\N	2022-07-01 22:05:10.385
410	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.385	\N	2022-07-01 22:05:10.385
410	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.385	\N	2022-07-01 22:05:10.385
1061	200010000	4	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.313	\N	2022-07-01 22:04:59.313
410	300210000	13	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.376	\N	2022-07-01 22:05:10.376
410	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.377	\N	2022-07-01 22:05:10.377
410	300310100	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.377	\N	2022-07-01 22:05:10.377
410	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.377	\N	2022-07-01 22:05:10.377
410	300310200	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.377	\N	2022-07-01 22:05:10.377
410	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.378	\N	2022-07-01 22:05:10.378
410	300310300	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.378	\N	2022-07-01 22:05:10.378
410	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.378	\N	2022-07-01 22:05:10.378
410	300310400	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.378	\N	2022-07-01 22:05:10.378
410	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.387	\N	2022-07-01 22:05:10.387
410	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.387	\N	2022-07-01 22:05:10.387
410	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.391	\N	2022-07-01 22:05:10.391
410	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.391	\N	2022-07-01 22:05:10.391
410	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.391	\N	2022-07-01 22:05:10.391
410	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.392	\N	2022-07-01 22:05:10.392
410	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.392	\N	2022-07-01 22:05:10.392
410	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.392	\N	2022-07-01 22:05:10.392
410	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.392	\N	2022-07-01 22:05:10.392
411	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.393	\N	2022-07-01 22:05:10.393
411	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.393	\N	2022-07-01 22:05:10.393
411	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.393	\N	2022-07-01 22:05:10.393
411	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.393	\N	2022-07-01 22:05:10.393
411	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.394	\N	2022-07-01 22:05:10.394
411	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.394	\N	2022-07-01 22:05:10.394
411	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.394	\N	2022-07-01 22:05:10.394
411	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.395	\N	2022-07-01 22:05:10.395
411	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.395	\N	2022-07-01 22:05:10.395
411	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.395	\N	2022-07-01 22:05:10.395
411	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.395	\N	2022-07-01 22:05:10.395
411	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.396	\N	2022-07-01 22:05:10.396
411	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.396	\N	2022-07-01 22:05:10.396
411	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.396	\N	2022-07-01 22:05:10.396
411	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.397	\N	2022-07-01 22:05:10.397
411	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.397	\N	2022-07-01 22:05:10.397
411	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.397	\N	2022-07-01 22:05:10.397
411	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.398	\N	2022-07-01 22:05:10.398
411	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.398	\N	2022-07-01 22:05:10.398
411	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.398	\N	2022-07-01 22:05:10.398
411	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.399	\N	2022-07-01 22:05:10.399
411	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.399	\N	2022-07-01 22:05:10.399
411	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.399	\N	2022-07-01 22:05:10.399
411	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.399	\N	2022-07-01 22:05:10.399
411	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.4	\N	2022-07-01 22:05:10.4
411	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.4	\N	2022-07-01 22:05:10.4
411	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.4	\N	2022-07-01 22:05:10.4
411	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.41	\N	2022-07-01 22:05:10.41
411	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.41	\N	2022-07-01 22:05:10.41
411	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.41	\N	2022-07-01 22:05:10.41
411	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.411	\N	2022-07-01 22:05:10.411
1061	200010000	6	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.313	\N	2022-07-01 22:04:59.313
411	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.401	\N	2022-07-01 22:05:10.401
411	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.402	\N	2022-07-01 22:05:10.402
411	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.402	\N	2022-07-01 22:05:10.402
411	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.402	\N	2022-07-01 22:05:10.402
411	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.402	\N	2022-07-01 22:05:10.402
411	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:10.403	\N	2022-07-01 22:05:10.403
411	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:10.403	\N	2022-07-01 22:05:10.403
411	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.403	\N	2022-07-01 22:05:10.403
411	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.403	\N	2022-07-01 22:05:10.403
411	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.404	\N	2022-07-01 22:05:10.404
410	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
410	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
411	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.404	\N	2022-07-01 22:05:10.404
411	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.405	\N	2022-07-01 22:05:10.405
411	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.405	\N	2022-07-01 22:05:10.405
411	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.405	\N	2022-07-01 22:05:10.405
411	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.406	\N	2022-07-01 22:05:10.406
411	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.406	\N	2022-07-01 22:05:10.406
411	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.407	\N	2022-07-01 22:05:10.407
411	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.407	\N	2022-07-01 22:05:10.407
411	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.411	\N	2022-07-01 22:05:10.411
411	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.411	\N	2022-07-01 22:05:10.411
411	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.411	\N	2022-07-01 22:05:10.411
412	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.412	\N	2022-07-01 22:05:10.412
412	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.412	\N	2022-07-01 22:05:10.412
412	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.412	\N	2022-07-01 22:05:10.412
412	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.412	\N	2022-07-01 22:05:10.412
412	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.413	\N	2022-07-01 22:05:10.413
412	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.413	\N	2022-07-01 22:05:10.413
412	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.413	\N	2022-07-01 22:05:10.413
412	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.413	\N	2022-07-01 22:05:10.413
412	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.414	\N	2022-07-01 22:05:10.414
412	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.414	\N	2022-07-01 22:05:10.414
412	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.414	\N	2022-07-01 22:05:10.414
412	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.415	\N	2022-07-01 22:05:10.415
412	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.415	\N	2022-07-01 22:05:10.415
412	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.415	\N	2022-07-01 22:05:10.415
412	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.415	\N	2022-07-01 22:05:10.415
412	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.416	\N	2022-07-01 22:05:10.416
412	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.416	\N	2022-07-01 22:05:10.416
412	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.417	\N	2022-07-01 22:05:10.417
412	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.417	\N	2022-07-01 22:05:10.417
412	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.417	\N	2022-07-01 22:05:10.417
412	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.417	\N	2022-07-01 22:05:10.417
412	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.418	\N	2022-07-01 22:05:10.418
412	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.418	\N	2022-07-01 22:05:10.418
412	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.418	\N	2022-07-01 22:05:10.418
412	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.418	\N	2022-07-01 22:05:10.418
412	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.419	\N	2022-07-01 22:05:10.419
412	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.419	\N	2022-07-01 22:05:10.419
412	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.419	\N	2022-07-01 22:05:10.419
412	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.419	\N	2022-07-01 22:05:10.419
412	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.42	\N	2022-07-01 22:05:10.42
412	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.42	\N	2022-07-01 22:05:10.42
412	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.421	\N	2022-07-01 22:05:10.421
412	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.421	\N	2022-07-01 22:05:10.421
412	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.896	\N	2022-07-01 22:05:10.896
412	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:10.896	\N	2022-07-01 22:05:10.896
412	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:10.896	\N	2022-07-01 22:05:10.896
412	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.897	\N	2022-07-01 22:05:10.897
412	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.897	\N	2022-07-01 22:05:10.897
412	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.897	\N	2022-07-01 22:05:10.897
412	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.898	\N	2022-07-01 22:05:10.898
412	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.898	\N	2022-07-01 22:05:10.898
1061	300310700	4	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.325	\N	2022-07-01 22:04:59.325
412	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.899	\N	2022-07-01 22:05:10.899
412	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.899	\N	2022-07-01 22:05:10.899
412	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.9	\N	2022-07-01 22:05:10.9
412	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.9	\N	2022-07-01 22:05:10.9
412	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.901	\N	2022-07-01 22:05:10.901
412	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.904	\N	2022-07-01 22:05:10.904
412	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.904	\N	2022-07-01 22:05:10.904
412	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.904	\N	2022-07-01 22:05:10.904
412	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.905	\N	2022-07-01 22:05:10.905
412	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.905	\N	2022-07-01 22:05:10.905
412	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.905	\N	2022-07-01 22:05:10.905
412	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.905	\N	2022-07-01 22:05:10.905
413	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.906	\N	2022-07-01 22:05:10.906
413	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.906	\N	2022-07-01 22:05:10.906
413	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.906	\N	2022-07-01 22:05:10.906
413	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.906	\N	2022-07-01 22:05:10.906
413	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.907	\N	2022-07-01 22:05:10.907
413	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.907	\N	2022-07-01 22:05:10.907
413	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.907	\N	2022-07-01 22:05:10.907
413	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.907	\N	2022-07-01 22:05:10.907
411	401130000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
412	401121000	10	0	4	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
411	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
411	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
412	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
412	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
413	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.908	\N	2022-07-01 22:05:10.908
413	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.908	\N	2022-07-01 22:05:10.908
413	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.908	\N	2022-07-01 22:05:10.908
413	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.908	\N	2022-07-01 22:05:10.908
413	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.908	\N	2022-07-01 22:05:10.908
413	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.909	\N	2022-07-01 22:05:10.909
413	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.909	\N	2022-07-01 22:05:10.909
413	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.909	\N	2022-07-01 22:05:10.909
413	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.91	\N	2022-07-01 22:05:10.91
413	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.911	\N	2022-07-01 22:05:10.911
413	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.911	\N	2022-07-01 22:05:10.911
413	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.911	\N	2022-07-01 22:05:10.911
413	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.911	\N	2022-07-01 22:05:10.911
413	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.912	\N	2022-07-01 22:05:10.912
413	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.912	\N	2022-07-01 22:05:10.912
413	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.912	\N	2022-07-01 22:05:10.912
413	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.912	\N	2022-07-01 22:05:10.912
413	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.913	\N	2022-07-01 22:05:10.913
413	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.913	\N	2022-07-01 22:05:10.913
413	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.913	\N	2022-07-01 22:05:10.913
413	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.913	\N	2022-07-01 22:05:10.913
413	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.914	\N	2022-07-01 22:05:10.914
413	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.914	\N	2022-07-01 22:05:10.914
413	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.914	\N	2022-07-01 22:05:10.914
413	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.915	\N	2022-07-01 22:05:10.915
413	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.915	\N	2022-07-01 22:05:10.915
413	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:10.915	\N	2022-07-01 22:05:10.915
413	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:10.916	\N	2022-07-01 22:05:10.916
413	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.916	\N	2022-07-01 22:05:10.916
413	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.916	\N	2022-07-01 22:05:10.916
413	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.916	\N	2022-07-01 22:05:10.916
413	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.917	\N	2022-07-01 22:05:10.917
413	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.917	\N	2022-07-01 22:05:10.917
413	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.918	\N	2022-07-01 22:05:10.918
413	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.918	\N	2022-07-01 22:05:10.918
413	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.918	\N	2022-07-01 22:05:10.918
413	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.918	\N	2022-07-01 22:05:10.918
1061	401000000	1	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.327	\N	2022-07-01 22:04:59.327
413	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.919	\N	2022-07-01 22:05:10.919
413	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.919	\N	2022-07-01 22:05:10.919
413	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.92	\N	2022-07-01 22:05:10.92
413	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.923	\N	2022-07-01 22:05:10.923
413	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.924	\N	2022-07-01 22:05:10.924
413	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.924	\N	2022-07-01 22:05:10.924
413	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.924	\N	2022-07-01 22:05:10.924
413	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.924	\N	2022-07-01 22:05:10.924
413	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.925	\N	2022-07-01 22:05:10.925
414	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.925	\N	2022-07-01 22:05:10.925
414	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.926	\N	2022-07-01 22:05:10.926
414	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.926	\N	2022-07-01 22:05:10.926
414	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.926	\N	2022-07-01 22:05:10.926
414	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.926	\N	2022-07-01 22:05:10.926
414	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.927	\N	2022-07-01 22:05:10.927
414	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.927	\N	2022-07-01 22:05:10.927
414	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.927	\N	2022-07-01 22:05:10.927
414	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.927	\N	2022-07-01 22:05:10.927
414	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.928	\N	2022-07-01 22:05:10.928
414	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.928	\N	2022-07-01 22:05:10.928
414	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.928	\N	2022-07-01 22:05:10.928
414	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.928	\N	2022-07-01 22:05:10.928
414	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.929	\N	2022-07-01 22:05:10.929
414	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.929	\N	2022-07-01 22:05:10.929
414	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.929	\N	2022-07-01 22:05:10.929
414	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.931	\N	2022-07-01 22:05:10.931
414	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.931	\N	2022-07-01 22:05:10.931
414	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.931	\N	2022-07-01 22:05:10.931
414	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.932	\N	2022-07-01 22:05:10.932
414	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.932	\N	2022-07-01 22:05:10.932
414	300210000	13	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.932	\N	2022-07-01 22:05:10.932
414	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.932	\N	2022-07-01 22:05:10.932
414	300310100	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.933	\N	2022-07-01 22:05:10.933
414	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.933	\N	2022-07-01 22:05:10.933
414	300310200	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.933	\N	2022-07-01 22:05:10.933
414	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.933	\N	2022-07-01 22:05:10.933
414	300310300	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.933	\N	2022-07-01 22:05:10.933
413	401130000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
414	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.934	\N	2022-07-01 22:05:10.934
413	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
413	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
414	300310400	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.934	\N	2022-07-01 22:05:10.934
414	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.934	\N	2022-07-01 22:05:10.934
414	300310500	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.934	\N	2022-07-01 22:05:10.934
414	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.935	\N	2022-07-01 22:05:10.935
414	300310600	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.935	\N	2022-07-01 22:05:10.935
414	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.935	\N	2022-07-01 22:05:10.935
414	300310700	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.935	\N	2022-07-01 22:05:10.935
414	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.936	\N	2022-07-01 22:05:10.936
414	300310800	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.936	\N	2022-07-01 22:05:10.936
414	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.937	\N	2022-07-01 22:05:10.937
414	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.937	\N	2022-07-01 22:05:10.937
414	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.937	\N	2022-07-01 22:05:10.937
414	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.937	\N	2022-07-01 22:05:10.937
414	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:10.938	\N	2022-07-01 22:05:10.938
414	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:10.938	\N	2022-07-01 22:05:10.938
414	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.938	\N	2022-07-01 22:05:10.938
414	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.938	\N	2022-07-01 22:05:10.938
414	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.939	\N	2022-07-01 22:05:10.939
414	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.939	\N	2022-07-01 22:05:10.939
414	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.94	\N	2022-07-01 22:05:10.94
414	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.94	\N	2022-07-01 22:05:10.94
414	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.94	\N	2022-07-01 22:05:10.94
1061	401000000	9	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.33	\N	2022-07-01 22:04:59.33
414	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.942	\N	2022-07-01 22:05:10.942
414	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.942	\N	2022-07-01 22:05:10.942
414	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.942	\N	2022-07-01 22:05:10.942
414	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.946	\N	2022-07-01 22:05:10.946
414	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.946	\N	2022-07-01 22:05:10.946
414	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.946	\N	2022-07-01 22:05:10.946
414	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.947	\N	2022-07-01 22:05:10.947
414	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.947	\N	2022-07-01 22:05:10.947
414	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.947	\N	2022-07-01 22:05:10.947
415	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.948	\N	2022-07-01 22:05:10.948
415	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.948	\N	2022-07-01 22:05:10.948
415	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.948	\N	2022-07-01 22:05:10.948
415	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.948	\N	2022-07-01 22:05:10.948
415	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.949	\N	2022-07-01 22:05:10.949
415	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.949	\N	2022-07-01 22:05:10.949
415	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.949	\N	2022-07-01 22:05:10.949
415	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.949	\N	2022-07-01 22:05:10.949
415	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.95	\N	2022-07-01 22:05:10.95
415	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.95	\N	2022-07-01 22:05:10.95
415	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.95	\N	2022-07-01 22:05:10.95
415	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.95	\N	2022-07-01 22:05:10.95
415	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.951	\N	2022-07-01 22:05:10.951
415	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.951	\N	2022-07-01 22:05:10.951
415	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.951	\N	2022-07-01 22:05:10.951
415	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.951	\N	2022-07-01 22:05:10.951
415	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.952	\N	2022-07-01 22:05:10.952
415	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.952	\N	2022-07-01 22:05:10.952
415	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.953	\N	2022-07-01 22:05:10.953
415	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.953	\N	2022-07-01 22:05:10.953
415	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.954	\N	2022-07-01 22:05:10.954
415	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.954	\N	2022-07-01 22:05:10.954
415	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.954	\N	2022-07-01 22:05:10.954
415	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.954	\N	2022-07-01 22:05:10.954
415	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.955	\N	2022-07-01 22:05:10.955
415	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.955	\N	2022-07-01 22:05:10.955
415	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.955	\N	2022-07-01 22:05:10.955
415	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.955	\N	2022-07-01 22:05:10.955
415	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.956	\N	2022-07-01 22:05:10.956
415	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.956	\N	2022-07-01 22:05:10.956
415	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.956	\N	2022-07-01 22:05:10.956
415	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.957	\N	2022-07-01 22:05:10.957
415	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.957	\N	2022-07-01 22:05:10.957
415	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.957	\N	2022-07-01 22:05:10.957
415	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.957	\N	2022-07-01 22:05:10.957
415	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:10.958	\N	2022-07-01 22:05:10.958
415	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:10.958	\N	2022-07-01 22:05:10.958
415	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.958	\N	2022-07-01 22:05:10.958
415	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.958	\N	2022-07-01 22:05:10.958
414	401130000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
415	401130000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
415	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.959	\N	2022-07-01 22:05:10.959
415	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.96	\N	2022-07-01 22:05:10.96
415	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.96	\N	2022-07-01 22:05:10.96
415	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
415	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
415	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.96	\N	2022-07-01 22:05:10.96
415	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.96	\N	2022-07-01 22:05:10.96
415	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.961	\N	2022-07-01 22:05:10.961
415	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.961	\N	2022-07-01 22:05:10.961
415	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.962	\N	2022-07-01 22:05:10.962
415	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.962	\N	2022-07-01 22:05:10.962
1061	401121000	4	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.338	\N	2022-07-01 22:04:59.338
415	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.965	\N	2022-07-01 22:05:10.965
415	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.965	\N	2022-07-01 22:05:10.965
415	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.966	\N	2022-07-01 22:05:10.966
415	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.966	\N	2022-07-01 22:05:10.966
415	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.966	\N	2022-07-01 22:05:10.966
415	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.966	\N	2022-07-01 22:05:10.966
415	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.967	\N	2022-07-01 22:05:10.967
416	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.967	\N	2022-07-01 22:05:10.967
416	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.967	\N	2022-07-01 22:05:10.967
416	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.968	\N	2022-07-01 22:05:10.968
416	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.974	\N	2022-07-01 22:05:10.974
416	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.974	\N	2022-07-01 22:05:10.974
416	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.974	\N	2022-07-01 22:05:10.974
416	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.975	\N	2022-07-01 22:05:10.975
416	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.975	\N	2022-07-01 22:05:10.975
416	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.975	\N	2022-07-01 22:05:10.975
416	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.975	\N	2022-07-01 22:05:10.975
416	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.976	\N	2022-07-01 22:05:10.976
416	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.976	\N	2022-07-01 22:05:10.976
416	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.977	\N	2022-07-01 22:05:10.977
416	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.977	\N	2022-07-01 22:05:10.977
416	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.977	\N	2022-07-01 22:05:10.977
416	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:10.978	\N	2022-07-01 22:05:10.978
416	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:10.978	\N	2022-07-01 22:05:10.978
416	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.978	\N	2022-07-01 22:05:10.978
416	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.978	\N	2022-07-01 22:05:10.978
416	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.979	\N	2022-07-01 22:05:10.979
416	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.979	\N	2022-07-01 22:05:10.979
416	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.98	\N	2022-07-01 22:05:10.98
416	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.98	\N	2022-07-01 22:05:10.98
416	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.98	\N	2022-07-01 22:05:10.98
416	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.98	\N	2022-07-01 22:05:10.98
416	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.981	\N	2022-07-01 22:05:10.981
416	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.981	\N	2022-07-01 22:05:10.981
416	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.982	\N	2022-07-01 22:05:10.982
416	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.982	\N	2022-07-01 22:05:10.982
416	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.985	\N	2022-07-01 22:05:10.985
416	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.986	\N	2022-07-01 22:05:10.986
416	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.986	\N	2022-07-01 22:05:10.986
416	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.986	\N	2022-07-01 22:05:10.986
416	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.986	\N	2022-07-01 22:05:10.986
416	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.987	\N	2022-07-01 22:05:10.987
417	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.987	\N	2022-07-01 22:05:10.987
417	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.987	\N	2022-07-01 22:05:10.987
417	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.987	\N	2022-07-01 22:05:10.987
417	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.988	\N	2022-07-01 22:05:10.988
417	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.988	\N	2022-07-01 22:05:10.988
417	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.988	\N	2022-07-01 22:05:10.988
417	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.988	\N	2022-07-01 22:05:10.988
417	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.989	\N	2022-07-01 22:05:10.989
417	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.989	\N	2022-07-01 22:05:10.989
1061	401241000	5	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.356	\N	2022-07-01 22:04:59.356
417	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.99	\N	2022-07-01 22:05:10.99
417	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.99	\N	2022-07-01 22:05:10.99
417	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.99	\N	2022-07-01 22:05:10.99
417	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.99	\N	2022-07-01 22:05:10.99
417	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.991	\N	2022-07-01 22:05:10.991
417	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.991	\N	2022-07-01 22:05:10.991
417	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.991	\N	2022-07-01 22:05:10.991
417	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.992	\N	2022-07-01 22:05:10.992
417	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.992	\N	2022-07-01 22:05:10.992
417	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.993	\N	2022-07-01 22:05:10.993
417	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:10.993	\N	2022-07-01 22:05:10.993
417	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.993	\N	2022-07-01 22:05:10.993
417	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:10.993	\N	2022-07-01 22:05:10.993
417	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.477	\N	2022-07-01 22:05:11.477
417	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.727	\N	2022-07-01 22:05:11.727
417	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.969	\N	2022-07-01 22:05:11.969
417	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.169	\N	2022-07-01 22:05:11.169
417	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.193	\N	2022-07-01 22:05:11.193
417	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
417	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
417	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.221	\N	2022-07-01 22:05:11.221
417	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.704	\N	2022-07-01 22:05:11.704
417	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.729	\N	2022-07-01 22:05:11.729
417	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.753	\N	2022-07-01 22:05:11.753
417	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.777	\N	2022-07-01 22:05:11.777
417	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.801	\N	2022-07-01 22:05:11.801
417	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.826	\N	2022-07-01 22:05:11.826
417	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.851	\N	2022-07-01 22:05:11.851
418	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.875	\N	2022-07-01 22:05:11.875
418	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.899	\N	2022-07-01 22:05:11.899
418	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.926	\N	2022-07-01 22:05:11.926
418	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.95	\N	2022-07-01 22:05:11.95
418	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.975	\N	2022-07-01 22:05:11.975
418	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.998	\N	2022-07-01 22:05:11.998
418	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.104	\N	2022-07-01 22:05:11.104
418	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.107	\N	2022-07-01 22:05:11.107
418	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.109	\N	2022-07-01 22:05:11.109
418	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.112	\N	2022-07-01 22:05:11.112
418	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.114	\N	2022-07-01 22:05:11.114
418	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.117	\N	2022-07-01 22:05:11.117
418	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.119	\N	2022-07-01 22:05:11.119
418	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.122	\N	2022-07-01 22:05:11.122
418	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.124	\N	2022-07-01 22:05:11.124
418	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.129	\N	2022-07-01 22:05:11.129
418	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.132	\N	2022-07-01 22:05:11.132
418	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.142	\N	2022-07-01 22:05:11.142
418	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.144	\N	2022-07-01 22:05:11.144
418	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.147	\N	2022-07-01 22:05:11.147
418	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.149	\N	2022-07-01 22:05:11.149
418	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.152	\N	2022-07-01 22:05:11.152
418	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.154	\N	2022-07-01 22:05:11.154
418	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.157	\N	2022-07-01 22:05:11.157
418	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.159	\N	2022-07-01 22:05:11.159
1061	850010100	6	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.38	\N	2022-07-01 22:04:59.38
418	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.167	\N	2022-07-01 22:05:11.167
418	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.169	\N	2022-07-01 22:05:11.169
418	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.172	\N	2022-07-01 22:05:11.172
418	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.174	\N	2022-07-01 22:05:11.174
418	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.18	\N	2022-07-01 22:05:11.18
418	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.183	\N	2022-07-01 22:05:11.183
418	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.186	\N	2022-07-01 22:05:11.186
418	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.188	\N	2022-07-01 22:05:11.188
418	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:11.191	\N	2022-07-01 22:05:11.191
418	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:11.193	\N	2022-07-01 22:05:11.193
418	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.196	\N	2022-07-01 22:05:11.196
418	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.198	\N	2022-07-01 22:05:11.198
418	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.201	\N	2022-07-01 22:05:11.201
418	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.208	\N	2022-07-01 22:05:11.208
418	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.211	\N	2022-07-01 22:05:11.211
418	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.213	\N	2022-07-01 22:05:11.213
418	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.215	\N	2022-07-01 22:05:11.215
418	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.218	\N	2022-07-01 22:05:11.218
418	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.221	\N	2022-07-01 22:05:11.221
418	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.228	\N	2022-07-01 22:05:11.228
418	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.23	\N	2022-07-01 22:05:11.23
418	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.233	\N	2022-07-01 22:05:11.233
418	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.265	\N	2022-07-01 22:05:11.265
418	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.268	\N	2022-07-01 22:05:11.268
418	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.27	\N	2022-07-01 22:05:11.27
418	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.273	\N	2022-07-01 22:05:11.273
418	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.276	\N	2022-07-01 22:05:11.276
418	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.278	\N	2022-07-01 22:05:11.278
419	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.283	\N	2022-07-01 22:05:11.283
419	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.285	\N	2022-07-01 22:05:11.285
419	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.288	\N	2022-07-01 22:05:11.288
419	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.29	\N	2022-07-01 22:05:11.29
419	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.293	\N	2022-07-01 22:05:11.293
419	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.295	\N	2022-07-01 22:05:11.295
419	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.298	\N	2022-07-01 22:05:11.298
419	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.3	\N	2022-07-01 22:05:11.3
419	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.303	\N	2022-07-01 22:05:11.303
419	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.305	\N	2022-07-01 22:05:11.305
419	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.308	\N	2022-07-01 22:05:11.308
419	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.31	\N	2022-07-01 22:05:11.31
418	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
419	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.312	\N	2022-07-01 22:05:11.312
419	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.315	\N	2022-07-01 22:05:11.315
419	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.317	\N	2022-07-01 22:05:11.317
419	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.32	\N	2022-07-01 22:05:11.32
419	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.322	\N	2022-07-01 22:05:11.322
419	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.325	\N	2022-07-01 22:05:11.325
419	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.335	\N	2022-07-01 22:05:11.335
419	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.337	\N	2022-07-01 22:05:11.337
419	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.34	\N	2022-07-01 22:05:11.34
419	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.345	\N	2022-07-01 22:05:11.345
419	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.347	\N	2022-07-01 22:05:11.347
419	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.35	\N	2022-07-01 22:05:11.35
419	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.352	\N	2022-07-01 22:05:11.352
419	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.355	\N	2022-07-01 22:05:11.355
419	300310400	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.357	\N	2022-07-01 22:05:11.357
419	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.36	\N	2022-07-01 22:05:11.36
419	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.362	\N	2022-07-01 22:05:11.362
419	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.365	\N	2022-07-01 22:05:11.365
419	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.367	\N	2022-07-01 22:05:11.367
419	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.372	\N	2022-07-01 22:05:11.372
419	300311900	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.375	\N	2022-07-01 22:05:11.375
419	300311900	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.377	\N	2022-07-01 22:05:11.377
1062	100012050	11	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.384	\N	2022-07-01 22:04:59.384
419	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:11.384	\N	2022-07-01 22:05:11.384
419	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.387	\N	2022-07-01 22:05:11.387
419	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.389	\N	2022-07-01 22:05:11.389
419	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.392	\N	2022-07-01 22:05:11.392
419	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.542	\N	2022-07-01 22:05:11.542
419	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.543	\N	2022-07-01 22:05:11.543
419	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.543	\N	2022-07-01 22:05:11.543
419	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.543	\N	2022-07-01 22:05:11.543
419	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.543	\N	2022-07-01 22:05:11.543
419	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.543	\N	2022-07-01 22:05:11.543
419	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.544	\N	2022-07-01 22:05:11.544
419	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.545	\N	2022-07-01 22:05:11.545
419	850010100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.547	\N	2022-07-01 22:05:11.547
419	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.548	\N	2022-07-01 22:05:11.548
419	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.548	\N	2022-07-01 22:05:11.548
419	850030100	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.548	\N	2022-07-01 22:05:11.548
419	850030100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.548	\N	2022-07-01 22:05:11.548
419	850030100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.549	\N	2022-07-01 22:05:11.549
420	100011070	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.549	\N	2022-07-01 22:05:11.549
420	100011070	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.549	\N	2022-07-01 22:05:11.549
420	100011070	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.549	\N	2022-07-01 22:05:11.549
420	100012050	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.55	\N	2022-07-01 22:05:11.55
420	100012050	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.55	\N	2022-07-01 22:05:11.55
420	100012050	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.55	\N	2022-07-01 22:05:11.55
420	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.55	\N	2022-07-01 22:05:11.55
420	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.551	\N	2022-07-01 22:05:11.551
420	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.551	\N	2022-07-01 22:05:11.551
420	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.551	\N	2022-07-01 22:05:11.551
420	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.552	\N	2022-07-01 22:05:11.552
420	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.552	\N	2022-07-01 22:05:11.552
420	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.552	\N	2022-07-01 22:05:11.552
420	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.552	\N	2022-07-01 22:05:11.552
420	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.552	\N	2022-07-01 22:05:11.552
420	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.553	\N	2022-07-01 22:05:11.553
420	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.553	\N	2022-07-01 22:05:11.553
420	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.554	\N	2022-07-01 22:05:11.554
420	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.554	\N	2022-07-01 22:05:11.554
420	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.554	\N	2022-07-01 22:05:11.554
420	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.555	\N	2022-07-01 22:05:11.555
420	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.555	\N	2022-07-01 22:05:11.555
420	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.555	\N	2022-07-01 22:05:11.555
420	300210000	13	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.555	\N	2022-07-01 22:05:11.555
420	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.556	\N	2022-07-01 22:05:11.556
419	401130000	10	0	3	8	0	0	6	A	\N	2020-06-30 08:00:00	2023-05-29 13:02:09.523	\N	2023-05-29 13:02:09.523
420	300310100	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.556	\N	2022-07-01 22:05:11.556
420	300310200	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.556	\N	2022-07-01 22:05:11.556
420	300310200	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.556	\N	2022-07-01 22:05:11.556
420	300310300	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.557	\N	2022-07-01 22:05:11.557
420	300310300	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.557	\N	2022-07-01 22:05:11.557
420	300310400	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.557	\N	2022-07-01 22:05:11.557
420	300310500	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.558	\N	2022-07-01 22:05:11.558
420	300310500	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.558	\N	2022-07-01 22:05:11.558
419	200010000	11	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
419	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
420	200010000	10	0	2	3	3	0	0	N	\N	2020-06-30 08:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
420	200010000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2023-07-12 00:00:00	\N	1901-01-01 00:00:00
420	300310600	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.558	\N	2022-07-01 22:05:11.558
420	300310600	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.558	\N	2022-07-01 22:05:11.558
420	300310700	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.559	\N	2022-07-01 22:05:11.559
420	300310700	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.559	\N	2022-07-01 22:05:11.559
420	300310800	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.559	\N	2022-07-01 22:05:11.559
420	300310800	13	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.559	\N	2022-07-01 22:05:11.559
420	300311900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.56	\N	2022-07-01 22:05:11.56
1062	100015010	10	0	0	1	1	0	0	*	\N	2018-08-14 06:00:00	2022-07-01 22:04:59.401	\N	2022-07-01 22:04:59.401
420	300312900	10	0	2	2	2	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.561	\N	2022-07-01 22:05:11.561
420	300312900	11	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:11.561	\N	2022-07-01 22:05:11.561
420	300312900	12	0	2	2	2	0	0	*	\N	2018-01-31 16:00:00	2022-07-01 22:05:11.561	\N	2022-07-01 22:05:11.561
420	401000000	10	0	4	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.561	\N	2022-07-01 22:05:11.561
420	401000000	11	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.562	\N	2022-07-01 22:05:11.562
420	401000000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.562	\N	2022-07-01 22:05:11.562
420	401231000	10	0	3	3	3	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.563	\N	2022-07-01 22:05:11.563
420	500010000	10	0	2	4	4	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.563	\N	2022-07-01 22:05:11.563
420	500010000	11	0	2	4	4	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.563	\N	2022-07-01 22:05:11.563
420	500050000	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.563	\N	2022-07-01 22:05:11.563
420	500050000	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.564	\N	2022-07-01 22:05:11.564
420	500050000	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.564	\N	2022-07-01 22:05:11.564
420	802000300	10	0	0	9	9	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.565	\N	2022-07-01 22:05:11.565
420	802000300	11	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.565	\N	2022-07-01 22:05:11.565
420	802000300	12	0	0	9	9	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.565	\N	2022-07-01 22:05:11.565
420	843020100	10	0	3	4	4	0	0	*	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.571	\N	2022-07-01 22:05:11.571
420	850010100	11	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.571	\N	2022-07-01 22:05:11.571
420	850010100	12	0	2	2	2	0	0	*	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.571	\N	2022-07-01 22:05:11.571
421	100013010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.574	\N	2022-07-01 22:05:11.574
421	100013010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.574	\N	2022-07-01 22:05:11.574
421	100013010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.574	\N	2022-07-01 22:05:11.574
421	100014140	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.575	\N	2022-07-01 22:05:11.575
421	100014140	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.575	\N	2022-07-01 22:05:11.575
421	100014140	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.575	\N	2022-07-01 22:05:11.575
421	100015010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.575	\N	2022-07-01 22:05:11.575
421	100015010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.576	\N	2022-07-01 22:05:11.576
421	100015010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.576	\N	2022-07-01 22:05:11.576
421	100016010	10	0	3	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.576	\N	2022-07-01 22:05:11.576
421	100016010	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.576	\N	2022-07-01 22:05:11.576
421	100016010	12	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.577	\N	2022-07-01 22:05:11.577
421	300110000	10	0	4	3	3	0	0	N	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.578	\N	2022-07-01 22:05:11.578
421	300110000	11	0	3	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.578	\N	2022-07-01 22:05:11.578
421	300110000	12	0	2	3	3	0	0	N	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.578	\N	2022-07-01 22:05:11.578
421	300210000	10	0	3	3	3	0	0	A	\N	2020-06-30 08:00:00	2022-07-01 22:05:11.578	\N	2022-07-01 22:05:11.578
421	300210000	11	0	3	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.579	\N	2022-07-01 22:05:11.579
421	300210000	12	0	4	3	3	0	0	A	\N	2017-09-01 00:00:00	2022-07-01 22:05:11.579	\N	2022-07-01 22:05:11.579
421	300310100	12	0	2	3	3	0	0	A	\N	2017-09-01 00:00:00	202